// The path to the Web Widgets source
var webWidgetBasePath = "../../../../../ui/webwidgets/src/";

// Regex to tell build not to search CVS folders
var excludeCvsPaths = [[ ".", ".", /(\/\.)|(~$)|(CVS)/ ]];

var profile = {
	// Set the path from which dojo calculates all other relative paths.
    // Set here to the directory containing this file.
    basePath: ".",

    // The folder name containing the UI code processed by this build
    // configuration. It will copy all the source files here before processing them.
    releaseName: "gbt-working",

    // The directory where dojo will place all the built artifacts
    releaseDir: "./release",

    // Remove comments from CSS files
    cssOptimize: "comments",

    // The CSS selector engine built into the code
    selectorEngine: "acme",

    // Configuration flag for Web Widgets
    buildingInBaT: true,

	staticHasFeatures: {
		'dojo-bidi': false, //We do not support Bi-Directional Interfaces
	},

  	// ANY Packages you need defined in ANY dependent code need to go here.

    packages: [{
			name: "dojo",
			location: webWidgetBasePath + "js/dojo/dojo",
			trees: excludeCvsPaths
        }, {
            name: "dijit",
            location: webWidgetBasePath + "js/dojo/dijit",
            trees: excludeCvsPaths
        }, {
            name: "dojox",
            location: webWidgetBasePath + "js/dojo/dojox",
            trees: excludeCvsPaths
        }, {
            name: "MW",
            location: webWidgetBasePath + "js/MW",
            trees: excludeCvsPaths
        }, {
            name: "l10n",
            location: webWidgetBasePath + "l10n",
            trees: excludeCvsPaths
        }, {
            name: "images",
            location: webWidgetBasePath + "images",
            trees: excludeCvsPaths
        }, {
            name: "css",
            location: webWidgetBasePath + "css",
            trees: excludeCvsPaths
        }, {
            name: "fonts",
            location: webWidgetBasePath + "fonts",
            trees: excludeCvsPaths
        }, {
            name: "xstyle",
            location:  webWidgetBasePath + "js/xstyle",
            trees: excludeCvsPaths
        }, {
            name: "dgrid",
            location:  webWidgetBasePath + "js/dgrid",
            trees: excludeCvsPaths
        }, {
            name: "put-selector",
            location:  webWidgetBasePath + "js/put-selector",
            trees: excludeCvsPaths
        }, {
            name: "gbt",
            location: "js/gbt",
            trees: excludeCvsPaths
        }, {
            name: "appdesigner",
            location: "../../../hmi/web/js/MW/appdesigner",
            trees: excludeCvsPaths
        }, {
            name: "visualcomponents",
            location: "../../../hmicomponents/web/js/MW/visualcomponents",
            trees: excludeCvsPaths
        }, {
            name: "hmishared",
            location: "../../../hmishared/web/js/MW/hmishared",
            trees: excludeCvsPaths
        }, {
            name: "images-appdesigner",
            location: "../../../hmi/web/images-appdesigner",
            trees: excludeCvsPaths
        }, {
            name: "css-appdesigner",
            location: "../../../hmi/web/css-appdesigner",
            trees: excludeCvsPaths
        },{
            name: "css-appdescomp",
            location: "../../../hmicomponents/web/css-appdescomp",
            trees: excludeCvsPaths
        }
    ],

    // The JavaScript code will get minimized into layer files. dojo generates
    // files to: [releaseDir]/[package name]/[layer file name].
    layers: {
        "gbt/gbt": {
            copyright: "copyright.txt",
            include: [
              // Add your main application modules first
			  "gbt/widgetview/FigureContainer",
              "dojo/io-query",
			  "dojo/domReady"
            ],
            exclude: [
              "gbt/browsercheck"
            ]
        },

        "gbt/browsercheck": {
            copyright: "copyright.txt",
            include: [
                "dojo/require",
                "MW/utils/BrowserCheck"
            ]
        }
    }
};