/**
 * This file defines all pixel - based values used custom Dijit implementations.
 *
 * Things that belong in this file:
 * - pixel values for padding, spacing,
 * - heights of pieces of a component, such as a check box width
 * - minimum values of components width, height
 *
 * Things that do not belong here:
 * - non pixel based values
 * - CSS values
 * - default values for component width , height
 *
 */

define({
    /**
     * Note about "common" and text area properties:
     *
     *   Can eliminate the need to specific these if we use box-sizing:border-box
     *
     *   However, that property is still considered experimental on the mozilla website and therefore
     *   we have not started using it.
     */

    COMMON: {
        "PADDING_LEFT": 2,          // 2px padding on the left
        "PADDING_RIGHT": 2,         // 2px padding on the right
        "BORDER_LEFTRIGHT": 2,      // 1px each on all the left and the right
        "BORDER_TOP_BOTTOM": 2,     // 1px each on the top and the bottom
        "DROP_SHADOW": 1            // 1px bottom drop shadow
    },

    TEXT_BOX: {
        "PADDING_TOP": 1
    },

    TEXT_AREA: {
        "PADDING_TOP": 1
    },

    DROP_DOWN: {
        "ARROW_BUTTON_WIDTH": 15
    },

    CHECK_BOX: {
        // Width of the physical box on the check box, excluding all text
        "CHECKBOX_WIDTH": 20
    },

    BUTTON: {
        // The padding between the label DOM elements and the icon DOM elements
        //
        // It should be applied intelligently taking into account the current positioning of the icon relative to the label
        //
        //Eg: if the icon is to the right, the labelNode gets a a padding on the right
        PADDING_LABEL_ICON: 2,

        // Minimum Dimensions for the button
        MINIMUM_WIDTH: 86,
        MINIMUM_HEIGHT: 20
    },

    LABEL: {
        // The width to be used when the label is blank
        BLANK_WIDTH: 20
    }
});