define([
	"dojo/_base/declare",	       
	"MW/remote/MessageService",
	"MW/remote/Remote",
	"dojox/widget/ColorPicker",
	"dijit/ColorPalette",
	"dijit/form/Button", 
	"dijit/layout/AccordionContainer",
	"dijit/layout/ContentPane",
	"dojo/dom",
	"dojo/parser",
	"dojo/domReady!"
	], function (declare, MessageService, Remote, ColorPicker, ColorPalette, Button, AccordionContainer, ContentPane, dom, parser) {

		return declare([], {
			constructor: function () {

				Remote.setEndpoint("/");

				Remote.setWorkerEndpoint(location.origin);
				Remote.setComputeToken({computeSessionId: "/gbt/dialogs/uisetcolor"});
				MessageService.start();

				var currentColor = '#000000';

				var updateColor = function (color) {
					currentColor = color;
                	colorPicker.setColor(currentColor); // Set the Picker to the same color, not sure how to make the palette the same color (if available)
                }

                var onOK = function () {
	                //console.log(currentColor);
	                MessageService.publish("/gbt/dialogs/uisetcolor/return", currentColor);
	            }

	            var onCancel = function () {
	                //console.log(currentColor);
	                MessageService.publish("/gbt/dialogs/uisetcolor/return", "cancel");
	            }

	            var init = function (initColor) {
	            	if (initColor.data.length == 0) {
	            		updateColor(currentColor);
	            	} else {
	            		updateColor(initColor.data);
	            	}
	            }

	            MessageService.subscribe("/gbt/dialogs/uisetcolor/initialize", init);
	            
	            var ac = new AccordionContainer({
	            	style: "height: 100%; width: 100%;"
	            }, "colorContainer");

	            var cp1 = new ContentPane({
	            	title: "Basic Colors",
	            	content: "<div id='ColorPalette' style='height: 100%; width: 100%;'></div>" });
	            ac.addChild(cp1);

	            var cp2 = new ContentPane({
	            	title: "More Colors",	            	
	            	content: "<div id='ColorPicker' style='height: 100%; width: 100%;''></div>"
	            });
	            ac.addChild(cp2);
	            ac.startup();

	            var colorPalette = new ColorPalette({palette: "7x10", onChange: updateColor}, dom.byId("ColorPalette"));
	            var colorPicker = new ColorPicker({onChange: updateColor, webSafe: false}, dom.byId("ColorPicker"));
	            var bok = new Button({label: "Ok", onClick: onOK}, dom.byId("OKButton"));
	            var bcancel = new Button({label: "Cancel", onClick: onCancel}, dom.byId("CancelButton")); 


	            MessageService.publish("/gbt/dialogs/uisetcolor/ready", []);
	            
	        }
	    });
});