/**
 * Created with IntelliJ IDEA.
 * User: kkaminen
 * Date: 12/12/13
 * Time: 8:52 AM
 * To change this template use File | Settings | File Templates.
 */

define([
    "dojo/_base/declare",
    "dojo/on",
    "dojo/dom-construct",
    "dojo/dom-geometry",
    "gbt/model/MWidget",
    "gbt/widgetview/_PositionMixin",
    "gbtx/widgetview/customdijit/Button"
], function (declare, on, domConstruct, domGeometry, MWidget, _PositionMixin, Button) {

    return declare([MWidget, _PositionMixin], {

        // handle to the Dijit instance, such as a gbt/widgetview/customdijit/Figure
        DijitHandle : null,

        /* Create the Web figure Dijit */
        constructor: function (widgetData) {
            this.DijitHandle =  new Button();
            this.configure(widgetData);
        },

        configure: function (widgetData) {

            // we can set defaults
            console.log("configuring MButton");
            this.DijitHandle.attr('label', "Button");
            this.inherited(arguments);

            var containerPos =  domGeometry.position(this.DijitHandle.domNode);
            //set the initial position
            this.position("" + containerPos.x + "," + containerPos.y);

            // Events can be sent back to MATLAB with arbitrary data...this is just an example.
            on(this.DijitHandle, "click", function (event) {
                console.log("Clicked!");
                var eventData = {
                    id: this._id,
                    Name: "click",
                    arbitrary_data1: "Foozle",
                    arbitrary_data2: "Woozle"
                };
                widgetData.getPeerNode().dispatchEvent("peerEvent", this.config, eventData);
            });
        },

        label: function (newValue) {
            this.DijitHandle.set("label", newValue);
        }
    });

});

