/**
 * Created with IntelliJ IDEA.
 * User: kkaminen
 * Date: 2/26/14
 * Time: 12:43 PM
 * To change this template use File | Settings | File Templates.
 */
/**
 * The Locator used to locate the widget views based on the type of the peernode
 */
define("gbt/Locator", [
    "dojo/_base/declare",
    // - Figure
    "gbt/widgetview/MFigure",
    // - Standard Controls
    "visualcomponents/widgetview/standardcomponents/PushButton",
    "visualcomponents/widgetview/standardcomponents/RadioButton",
    "visualcomponents/widgetview/standardcomponents/CheckBox",
    "visualcomponents/widgetview/standardcomponents/TextField",
    "visualcomponents/widgetview/standardcomponents/TextArea",
    "visualcomponents/widgetview/standardcomponents/NumberField",
    "visualcomponents/widgetview/standardcomponents/Label",
    "visualcomponents/widgetview/standardcomponents/Slider",
    "visualcomponents/widgetview/standardcomponents/ComboBox",
    "visualcomponents/widgetview/standardcomponents/DropDown",
    "visualcomponents/widgetview/standardcomponents/ListBox",
    "visualcomponents/widgetview/standardcomponents/ToggleButton",
    "visualcomponents/widgetview/standardcomponents/GroupedToggleButton",


    //Guages
    "visualcomponents/widgetview/hmicomponents/SemicircularGauge",
    "visualcomponents/widgetview/hmicomponents/CircularGauge",
    "visualcomponents/widgetview/hmicomponents/NinetyDegreeGauge",
    "visualcomponents/widgetview/hmicomponents/LinearGauge",
    "visualcomponents/widgetview/hmicomponents/Lamp",

    //Knob
    "visualcomponents/widgetview/hmicomponents/ContinuousKnob",
    "visualcomponents/widgetview/hmicomponents/DiscreteKnob",

    //switches
    "visualcomponents/widgetview/hmicomponents/RockerSwitch",
    "visualcomponents/widgetview/hmicomponents/SliderSwitch",
    "visualcomponents/widgetview/hmicomponents/ToggleSwitch",

    // - Containers
    "visualcomponents/widgetview/standardcomponents/Panel",
    //"gbt/widgetview/MPanel",
    "visualcomponents/widgetview/standardcomponents/ButtonGroup"

], function (declare, Figure, PushButton, RadioButton, CheckBox, TextField, TextArea, NumberField,
             Label, Slider, ComboBox, DropDown, ListBox, ToggleButton, GroupedToggleButton,
             SemicircularGauge, CircularGauge, NinetyDegreeGauge, LinearGauge, Lamp,
             ContinuousKnob, DiscreteKnob, RockerSwitch, SliderSwitch, ToggleSwitch, Panel, ButtonGroup) {

    return declare([], {

        /**
         * locate the Widget based on the type of the peernode
         * @param nodeType
         * @returns {widgetView}
         */
        locate: function (nodeType) {
            //get the widgetView to create
            var widgetView =  this._locate(nodeType);
            return widgetView;
        },

        /**
         * ------------------------------------------------------------------------------------------------------
         * Private Functions
         * ------------------------------------------------------------------------------------------------------
         */

        /**
         * Look up the WidgetView based on the Peer node type
         * @param nodeType
         * @returns {component}
         * @private
         */
        _locate: function (nodeType) {

            switch (nodeType) {
                case "ContainerRoot":
                    return Figure;
                case "matlab.ui.control.Button":
                    return PushButton;
                case "matlab.ui.control.RadioButton":
                    return RadioButton;
                case "matlab.ui.control.CheckBox":
                    return CheckBox;
                case "matlab.ui.control.EditField":
                    return TextField;
                case "matlab.ui.control.TextArea":
                    return TextArea;
                case "matlab.ui.control.NumericEditField":
                    return NumberField;
                case "matlab.ui.control.Label":
                    return Label;
                case "matlab.ui.control.Slider":
                    return Slider;
                case "matlab.ui.control.EditableDropDown":
                    return ComboBox;
                case "matlab.ui.control.DropDown":
                    return DropDown;
                case "matlab.ui.control.ListBox":
                    return ListBox;
                case "matlab.ui.control.StateButton":
                    return ToggleButton;
                case "matlab.ui.control.ToggleButton":
                    return GroupedToggleButton;

                //Guages

                case "matlab.ui.control.SemicircularGauge":
                    return SemicircularGauge;
                case "matlab.ui.control.Gauge":
                    return CircularGauge;
                case "matlab.ui.control.NinetyDegreeGauge":
                    return NinetyDegreeGauge;
                case "matlab.ui.control.LinearGauge":
                    return LinearGauge;

                //Lamps
                case "matlab.ui.control.Lamp":
                    return Lamp;

                //Knob
                case "matlab.ui.control.Knob":
                    return ContinuousKnob;
                case "matlab.ui.control.DiscreteKnob":
                    return DiscreteKnob;

                //Switch
                case "matlab.ui.control.RockerSwitch":
                    return RockerSwitch;
                case "matlab.ui.control.Switch":
                    return SliderSwitch;
                case "matlab.ui.control.ToggleSwitch":
                    return ToggleSwitch;

                //Containers
                case "matlab.ui.control.Panel":
                    return Panel;
                case "matlab.ui.control.ButtonGroup":
                    return ButtonGroup;

                default:
                    throw "Unexpected WidgetView type: " + nodeType;
            }
        }

    });
});
