/*
 *
 * This file and its contents are the property of The MathWorks, Inc.
 * 
 * This file contains confidential proprietary information.
 * The reproduction, distribution, utilization or the communication
 * of this file or any part thereof is strictly prohibited.
 * Offenders will be held liable for the payment of damages.
 *
 * Copyright 1999-2011 The MathWorks, Inc.
 *
 */

/* 
   Polyspace non standard stubs.

   __polyspace__non_stdstubs.c


   *************************************************
   * Those stubs have not been fully validated yet *
   * Use them with caution !                       *
   *************************************************


   Pragma POLYSPACE_POLYMORPHIC indicates that the function have no important access to global variables
     (neither syntaxically nor by pointer). Suc a declaration impacts the precision of the Verifier.
     In fact, we can say that the following functions are polymorphic:
       - the pure functions (POLYSPACE_PURE or functions that only deal will basic types)
       - the functions that only deal with const pointers
     The following functions cannot be declared polymorphic:
       - the functions that return a pointer
       - the functions that deal with non const pointers
       - the functions that syntaxically access to a global variable.


   We always initialize the randoms, although they are volatile. It may allows to be a bit more precise on NIVs.


   Defines that this file may understand: <none>
*/

#ifdef POLYSPACE_NO_IOB_ACCESSES
#undef __OS_SOLARIS
#endif

/* ************************************************** */
/* ***** Stubs for non ANSI C standard includes ***** */
/* ************************************************** */

/* includes stubbed:
 * - pthread.h
 * - sys/socket.h
 * - netdb.h
 * - sys/resource.h
 * - unistd.h
 * - syslog.h
 * - fcntl.h
 * - dirent.h
 */

/*********************************************************************** pthread.h */
#ifdef  __polyspace_pthread_create
#include <pthread.h>
int pthread_create(pthread_t *thread, const pthread_attr_t *attr, void * (*start_routine)(void *), void *arg) {
  volatile int random;
  volatile pthread_t random_thread;

  start_routine(arg);

  *thread = random_thread;
  return random;
}
#endif /* __polyspace_pthread_create */

#ifdef __polyspace_pthread_cancel
/* extern int pthread_cancel(pthread_t target_thread); */
#pragma POLYSPACE_PURE "pthread_cancel"
#endif /* __polyspace_pthread_cancel */

#ifdef __polyspace_pthread_exit
void pthread_exit(void *value_ptr) {
  for (;;) ; /* The pthread_exit() function cannot return to its caller. */
}
#endif /* __polyspace_pthread_exit */

#ifdef __polyspace_pthread_join
/* int pthread_join(pthread_t thread, void **value_ptr); */
#pragma POLYSPACE_PURE "pthread_join"
#endif /* __polyspace_pthread_join */

#ifdef __polyspace_pthread_attr_init
#include <pthread.h>
int pthread_attr_init(pthread_attr_t *attr) {
  volatile pthread_attr_t random_attr;
  volatile int random;

  if (attr != NULL)
    *attr = random_attr;

  return random;
}
#endif /* __polyspace_pthread_attr_init */

#ifdef __polyspace_pthread_attr_destroy
#include <pthread.h>
int pthread_attr_destroy(pthread_attr_t *attr) {
  volatile pthread_attr_t random_attr;
  volatile int random;

  if (attr != NULL)
    *attr = random_attr;

  return random;
}
#endif /* __polyspace_pthread_attr_destroy */


/*********************************************************************** sys/socket.h */
#ifdef __polyspace_socket
/* int socket(int domain, int type, int protocol); */
#pragma POLYSPACE_PURE "socket"
#endif /* __polyspace_socket */

#ifdef __polyspace_bind
/* int bind(int s, const struct sockaddr *name, socklen_t *namelen); */
#pragma POLYSPACE_PURE "bind"
#endif /* __polyspace_bind */

#ifdef __polyspace_connect
/* int connect(int s, const struct sockaddr *name, struct_t namelen); */
#pragma POLYSPACE_PURE "connect"
#endif /* __polyspace_connect */

#ifdef __polyspace_accept
/* int accept(int s, struct sockaddr *addr, socklen_t *addrlen); */
/* NOT STUBBED as it causes troubles with includes */
#endif /* __polyspace_accept */

#ifdef __polyspace_getsockname
/* int getsockname(int s, struct sockaddr *name, socklen_t *namelen); */
/* NOT STUBBED as it causes troubles with includes */
#endif /* __polyspace_getsockname */

#ifdef __polyspace_getsockopt
/* int getsockopt(int s, int level, int optname, void  *optval, socklen_t *optlen); */
/* NOT STUBBED as it causes troubles with includes */
#endif /* __polyspace_getsockopt */

#ifdef __polyspace_setsockopt
/* int setsockopt(int s, int level, int optname, const void *optval, socklen_t optlen); */
#pragma POLYSPACE_PURE "setsockopt"
#endif /* __polyspace_setsockopt */

#ifdef __polyspace_listen
/* int listen(int s, int backlog); */
#pragma POLYSPACE_PURE "listen"
#endif /* __polyspace_listen */

#ifdef __polyspace_recv
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
ssize_t recv(int s, void *buf, size_t len, int flags) {
  volatile int random;
  volatile char random_char;
  size_t i;
  char *ptr;

  ptr = (char*) buf;
  for (i = 0; i < len; i++) {
    ptr[i] = random_char;
    if (random) return -1;
    if (random) return i;
  }
  return len;
}
#endif /* __polyspace_recv */

#ifdef __polyspace_recvfrom
/* ssize_t recvfrom(int s, void *buf, size_t len, int flags, struct sockaddr *from, socklen_t *fromlen); */
/* NOT STUBBED as it causes troubles with includes */
#endif /* __polyspace_recvfrom */

#ifdef __polyspace_recvmsg
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
ssize_t recvmsg(int s, struct msghdr *msg, int flags) {
  volatile int random;
  volatile ssize_t random_ssize_t;
  volatile struct msghdr random_msghdr;

  if (random) return -1;

  *msg = random_msghdr;

  return random_ssize_t;
}
#endif /* __polyspace_recvmsg */

#ifdef __polyspace_send
/* ssize_t send(int s, const void *msg, size_t len, int flags); */
#pragma POLYSPACE_PURE "send"
#endif /* __polyspace_send */

#ifdef __polyspace_sendto
/* ssize_t sendto(int s, const void *msg, size_t len, int flags, const struct sockaddr *to, socklen_t tolen); */
#pragma POLYSPACE_PURE "sendto"
#endif /* __polyspace_sendto */

#ifdef __polyspace_sendmsg
/* ssize_t sendmsg(int s, const struct msghdr *msg, int flags); */
#pragma POLYSPACE_PURE "sendmsg"
#endif

#ifdef __polyspace_shutdown
/* int shutdown(int s, int how); */
#pragma POLYSPACE_PURE "shutdown"
#endif /* __polyspace_shutdown */

#ifdef __polyspace_socketpair
int socketpair(int domain, int type, int protocol, int sv[2]) {
  volatile int random;

  sv[0] = random;
  sv[1] = random;

  if (random) return -1;

  return 0;
}
#endif /* __polyspace_socketpair */












/****************************************************************************
 ****************************************************************************
 ********  VARIABLES STUBS
 ****************************************************************************
 ****************************************************************************/


/****************************************************************************
 *  NON-STD LIBRARIES - OS-TARGET LINUX
 ****************************************************************************/
#if defined(__OS_LINUX)


#if defined(__polyspace_compositeWidgetClass) && !defined(__polyspace_no_compositeWidgetClass)
#include <X11/Composite.h>
#undef compositeWidgetClass
  externalref WidgetClass compositeWidgetClass;
#endif

#if defined(__polyspace_compositeClassRec) && !defined(__polyspace_no_compositeClassRec)
#include <X11/CompositeP.h>
#undef compositeClassRec
  externalref CompositeClassRec compositeClassRec;
#endif

#if defined(__polyspace_constraintClassRec) && !defined(__polyspace_no_constraintClassRec)
#include <X11/ConstrainP.h>
#undef constraintClassRec
  externalref ConstraintClassRec constraintClassRec;
#endif

#if defined(__polyspace_constraintWidgetClass) && !defined(__polyspace_no_constraintWidgetClass)
#include <X11/Constraint.h>
#undef constraintWidgetClass
  externalref WidgetClass constraintWidgetClass;
#endif

#if defined(__polyspace_coreWidgetClass) && !defined(__polyspace_no_coreWidgetClass)
#include <X11/Core.h>
#undef coreWidgetClass
  externalref WidgetClass coreWidgetClass;
#endif

#if defined(__polyspace_widgetClass) && !defined(__polyspace_no_widgetClass)
#include <X11/Core.h>
#undef widgetClass
  externalref WidgetClass widgetClass;
#endif

#if defined(__polyspace__XtInheritTranslations) && !defined(__polyspace_no__XtInheritTranslations)
#include <X11/CoreP.h>
#undef _XtInheritTranslations
  externalref int _XtInheritTranslations;
#endif

#if defined(__polyspace_widgetClassRec) && !defined(__polyspace_no_widgetClassRec)
#include <X11/CoreP.h>
#undef widgetClassRec
  externalref WidgetClassRec widgetClassRec;
#endif

#if defined(__polyspace_colorConvertArgs) && !defined(__polyspace_no_colorConvertArgs)
#include <X11/Intrinsic.h>
#undef colorConvertArgs
  externalref XtConvertArgRec const colorConvertArgs[];
#endif

#if defined(__polyspace_screenConvertArg) && !defined(__polyspace_no_screenConvertArg)
#include <X11/Intrinsic.h>
#undef screenConvertArg
  externalref XtConvertArgRec const screenConvertArg[];
#endif

#if defined(__polyspace_objectClass) && !defined(__polyspace_no_objectClass)
#include <X11/Object.h>
#undef objectClass
  externalref WidgetClass objectClass;
#endif

#if defined(__polyspace_objectClassRec) && !defined(__polyspace_no_objectClassRec)
#include <X11/ObjectP.h>
#undef objectClassRec
  externalref ObjectClassRec objectClassRec;
#endif

#if defined(__polyspace_PEXDisplayInfoHeader) && !defined(__polyspace_no_PEXDisplayInfoHeader)
#include <X11/PEX5/PEXlibint.h>
#undef PEXDisplayInfoHeader
  extern PEXDisplayInfo *PEXDisplayInfoHeader;
#endif

#if defined(__polyspace_PEXPickCache) && !defined(__polyspace_no_PEXPickCache)
#include <X11/PEX5/PEXlibint.h>
#undef PEXPickCache
  extern PEXPickPath *PEXPickCache;
#endif

#if defined(__polyspace_PEXPickCacheSize) && !defined(__polyspace_no_PEXPickCacheSize)
#include <X11/PEX5/PEXlibint.h>
#undef PEXPickCacheSize
  extern unsigned int PEXPickCacheSize;
#endif

#if defined(__polyspace_PEXPickCacheInUse) && !defined(__polyspace_no_PEXPickCacheInUse)
#include <X11/PEX5/PEXlibint.h>
#undef PEXPickCacheInUse
  extern int PEXPickCacheInUse;
#endif

#if defined(__polyspace_rectObjClass) && !defined(__polyspace_no_rectObjClass)
#include <X11/RectObj.h>
#undef rectObjClass
  externalref WidgetClass rectObjClass;
#endif

#if defined(__polyspace_rectObjClassRec) && !defined(__polyspace_no_rectObjClassRec)
#include <X11/RectObjP.h>
#undef rectObjClassRec
  externalref RectObjClassRec rectObjClassRec;
#endif

#if defined(__polyspace_XtShellStrings) && !defined(__polyspace_no_XtShellStrings)
#include <X11/Shell.h>
#undef XtShellStrings
  extern _XtShell_h_Const char XtShellStrings[];
#endif

#if defined(__polyspace_shellWidgetClass) && !defined(__polyspace_no_shellWidgetClass)
#include <X11/Shell.h>
#undef shellWidgetClass
  externalref WidgetClass shellWidgetClass;
#endif

#if defined(__polyspace_overrideShellWidgetClass) && !defined(__polyspace_no_overrideShellWidgetClass)
#include <X11/Shell.h>
#undef overrideShellWidgetClass
  externalref WidgetClass overrideShellWidgetClass;
#endif

#if defined(__polyspace_wmShellWidgetClass) && !defined(__polyspace_no_wmShellWidgetClass)
#include <X11/Shell.h>
#undef wmShellWidgetClass
  externalref WidgetClass wmShellWidgetClass;
#endif

#if defined(__polyspace_transientShellWidgetClass) && !defined(__polyspace_no_transientShellWidgetClass)
#include <X11/Shell.h>
#undef transientShellWidgetClass
  externalref WidgetClass transientShellWidgetClass;
#endif

#if defined(__polyspace_topLevelShellWidgetClass) && !defined(__polyspace_no_topLevelShellWidgetClass)
#include <X11/Shell.h>
#undef topLevelShellWidgetClass
  externalref WidgetClass topLevelShellWidgetClass;
#endif

#if defined(__polyspace_applicationShellWidgetClass) && !defined(__polyspace_no_applicationShellWidgetClass)
#include <X11/Shell.h>
#undef applicationShellWidgetClass
  externalref WidgetClass applicationShellWidgetClass;
#endif

#if defined(__polyspace_sessionShellWidgetClass) && !defined(__polyspace_no_sessionShellWidgetClass)
#include <X11/Shell.h>
#undef sessionShellWidgetClass
  externalref WidgetClass sessionShellWidgetClass;
#endif

#if defined(__polyspace_shellClassRec) && !defined(__polyspace_no_shellClassRec)
#include <X11/ShellP.h>
#undef shellClassRec
  externalref ShellClassRec shellClassRec;
#endif

#if defined(__polyspace_overrideShellClassRec) && !defined(__polyspace_no_overrideShellClassRec)
#include <X11/ShellP.h>
#undef overrideShellClassRec
  externalref OverrideShellClassRec overrideShellClassRec;
#endif

#if defined(__polyspace_wmShellClassRec) && !defined(__polyspace_no_wmShellClassRec)
#include <X11/ShellP.h>
#undef wmShellClassRec
  externalref WMShellClassRec wmShellClassRec;
#endif

#if defined(__polyspace_transientShellClassRec) && !defined(__polyspace_no_transientShellClassRec)
#include <X11/ShellP.h>
#undef transientShellClassRec
  externalref TransientShellClassRec transientShellClassRec;
#endif

#if defined(__polyspace_topLevelShellClassRec) && !defined(__polyspace_no_topLevelShellClassRec)
#include <X11/ShellP.h>
#undef topLevelShellClassRec
  externalref TopLevelShellClassRec topLevelShellClassRec;
#endif

#if defined(__polyspace_applicationShellClassRec) && !defined(__polyspace_no_applicationShellClassRec)
#include <X11/ShellP.h>
#undef applicationShellClassRec
  externalref ApplicationShellClassRec applicationShellClassRec;
#endif

#if defined(__polyspace_sessionShellClassRec) && !defined(__polyspace_no_sessionShellClassRec)
#include <X11/ShellP.h>
#undef sessionShellClassRec
  externalref SessionShellClassRec sessionShellClassRec;
#endif

#if defined(__polyspace_XtStrings) && !defined(__polyspace_no_XtStrings)
#include <X11/StringDefs.h>
#undef XtStrings
  extern _XtStringDefs_h_Const char XtStrings[];
#endif

#if defined(__polyspace_vendorShellWidgetClass) && !defined(__polyspace_no_vendorShellWidgetClass)
#include <X11/Vendor.h>
#undef vendorShellWidgetClass
  externalref WidgetClass vendorShellWidgetClass;
#endif

#if defined(__polyspace_vendorShellClassRec) && !defined(__polyspace_no_vendorShellClassRec)
#include <X11/VendorP.h>
#undef vendorShellClassRec
  externalref VendorShellClassRec vendorShellClassRec;
#endif

#if defined(__polyspace_XawWidgetArray) && !defined(__polyspace_no_XawWidgetArray)
#include <X11/Xaw/AllWidgets.h>
#undef XawWidgetArray
  extern XmuWidgetNode XawWidgetArray[];
#endif

#if defined(__polyspace_XawWidgetCount) && !defined(__polyspace_no_XawWidgetCount)
#include <X11/Xaw/AllWidgets.h>
#undef XawWidgetCount
  extern int   XawWidgetCount;
#endif

#if defined(__polyspace_asciiSinkObjectClass) && !defined(__polyspace_no_asciiSinkObjectClass)
#include <X11/Xaw/AsciiSink.h>
#undef asciiSinkObjectClass
  extern WidgetClass asciiSinkObjectClass;
#endif

#if defined(__polyspace_asciiSinkClassRec) && !defined(__polyspace_no_asciiSinkClassRec)
#include <X11/Xaw/AsciiSinkP.h>
#undef asciiSinkClassRec
  extern AsciiSinkClassRec asciiSinkClassRec;
#endif

#if defined(__polyspace_asciiSrcObjectClass) && !defined(__polyspace_no_asciiSrcObjectClass)
#include <X11/Xaw/AsciiSrc.h>
#undef asciiSrcObjectClass
  extern WidgetClass asciiSrcObjectClass;
#endif

#if defined(__polyspace_asciiSrcClassRec) && !defined(__polyspace_no_asciiSrcClassRec)
#include <X11/Xaw/AsciiSrcP.h>
#undef asciiSrcClassRec
  extern AsciiSrcClassRec asciiSrcClassRec;
#endif

#if defined(__polyspace_asciiTextWidgetClass) && !defined(__polyspace_no_asciiTextWidgetClass)
#include <X11/Xaw/AsciiText.h>
#undef asciiTextWidgetClass
  extern WidgetClass asciiTextWidgetClass;
#endif

#if defined(__polyspace_asciiStringWidgetClass) && !defined(__polyspace_no_asciiStringWidgetClass)
#include <X11/Xaw/AsciiText.h>
#undef asciiStringWidgetClass
  extern WidgetClass asciiStringWidgetClass;
#endif

#if defined(__polyspace_asciiDiskWidgetClass) && !defined(__polyspace_no_asciiDiskWidgetClass)
#include <X11/Xaw/AsciiText.h>
#undef asciiDiskWidgetClass
  extern WidgetClass asciiDiskWidgetClass;
#endif

#if defined(__polyspace_asciiTextClassRec) && !defined(__polyspace_no_asciiTextClassRec)
#include <X11/Xaw/AsciiTextP.h>
#undef asciiTextClassRec
  extern AsciiTextClassRec asciiTextClassRec;
#endif

#if defined(__polyspace_asciiStringClassRec) && !defined(__polyspace_no_asciiStringClassRec)
#include <X11/Xaw/AsciiTextP.h>
#undef asciiStringClassRec
  extern AsciiStringClassRec asciiStringClassRec;
#endif

#if defined(__polyspace_asciiDiskClassRec) && !defined(__polyspace_no_asciiDiskClassRec)
#include <X11/Xaw/AsciiTextP.h>
#undef asciiDiskClassRec
  extern AsciiDiskClassRec asciiDiskClassRec;
#endif

#if defined(__polyspace_boxWidgetClass) && !defined(__polyspace_no_boxWidgetClass)
#include <X11/Xaw/Box.h>
#undef boxWidgetClass
  extern WidgetClass boxWidgetClass;
#endif

#if defined(__polyspace_boxClassRec) && !defined(__polyspace_no_boxClassRec)
#include <X11/Xaw/BoxP.h>
#undef boxClassRec
  extern BoxClassRec boxClassRec;
#endif

#if defined(__polyspace_commandWidgetClass) && !defined(__polyspace_no_commandWidgetClass)
#include <X11/Xaw/Command.h>
#undef commandWidgetClass
  extern WidgetClass  commandWidgetClass;
#endif

#if defined(__polyspace_commandClassRec) && !defined(__polyspace_no_commandClassRec)
#include <X11/Xaw/CommandP.h>
#undef commandClassRec
  extern CommandClassRec commandClassRec;
#endif

#if defined(__polyspace_dialogWidgetClass) && !defined(__polyspace_no_dialogWidgetClass)
#include <X11/Xaw/Dialog.h>
#undef dialogWidgetClass
  extern WidgetClass dialogWidgetClass;
#endif

#if defined(__polyspace_dialogClassRec) && !defined(__polyspace_no_dialogClassRec)
#include <X11/Xaw/DialogP.h>
#undef dialogClassRec
  extern DialogClassRec dialogClassRec;
#endif

#if defined(__polyspace_formWidgetClass) && !defined(__polyspace_no_formWidgetClass)
#include <X11/Xaw/Form.h>
#undef formWidgetClass
  extern WidgetClass formWidgetClass;
#endif

#if defined(__polyspace_formClassRec) && !defined(__polyspace_no_formClassRec)
#include <X11/Xaw/FormP.h>
#undef formClassRec
  extern FormClassRec formClassRec;
#endif

#if defined(__polyspace_gripWidgetClass) && !defined(__polyspace_no_gripWidgetClass)
#include <X11/Xaw/Grip.h>
#undef gripWidgetClass
  extern WidgetClass gripWidgetClass;
#endif

#if defined(__polyspace_gripClassRec) && !defined(__polyspace_no_gripClassRec)
#include <X11/Xaw/GripP.h>
#undef gripClassRec
  extern GripClassRec gripClassRec;
#endif

#if defined(__polyspace_labelWidgetClass) && !defined(__polyspace_no_labelWidgetClass)
#include <X11/Xaw/Label.h>
#undef labelWidgetClass
  extern WidgetClass labelWidgetClass;
#endif

#if defined(__polyspace_labelClassRec) && !defined(__polyspace_no_labelClassRec)
#include <X11/Xaw/LabelP.h>
#undef labelClassRec
  extern LabelClassRec labelClassRec;
#endif

#if defined(__polyspace_listWidgetClass) && !defined(__polyspace_no_listWidgetClass)
#include <X11/Xaw/List.h>
#undef listWidgetClass
  extern WidgetClass listWidgetClass;
#endif

#if defined(__polyspace_listClassRec) && !defined(__polyspace_no_listClassRec)
#include <X11/Xaw/ListP.h>
#undef listClassRec
  extern ListClassRec listClassRec;
#endif

#if defined(__polyspace_menuButtonClassRec) && !defined(__polyspace_no_menuButtonClassRec)
#include <X11/Xaw/MenuButtoP.h>
#undef menuButtonClassRec
  extern MenuButtonClassRec menuButtonClassRec;
#endif

#if defined(__polyspace_menuButtonWidgetClass) && !defined(__polyspace_no_menuButtonWidgetClass)
#include <X11/Xaw/MenuButton.h>
#undef menuButtonWidgetClass
  extern WidgetClass  menuButtonWidgetClass;
#endif

#if defined(__polyspace_multiSinkObjectClass) && !defined(__polyspace_no_multiSinkObjectClass)
#include <X11/Xaw/MultiSink.h>
#undef multiSinkObjectClass
  extern WidgetClass multiSinkObjectClass;
#endif

#if defined(__polyspace_multiSinkClassRec) && !defined(__polyspace_no_multiSinkClassRec)
#include <X11/Xaw/MultiSinkP.h>
#undef multiSinkClassRec
  extern MultiSinkClassRec multiSinkClassRec;
#endif

#if defined(__polyspace_multiSrcObjectClass) && !defined(__polyspace_no_multiSrcObjectClass)
#include <X11/Xaw/MultiSrc.h>
#undef multiSrcObjectClass
  extern WidgetClass multiSrcObjectClass;
#endif

#if defined(__polyspace_multiSrcClassRec) && !defined(__polyspace_no_multiSrcClassRec)
#include <X11/Xaw/MultiSrcP.h>
#undef multiSrcClassRec
  extern MultiSrcClassRec multiSrcClassRec;
#endif

#if defined(__polyspace_panedWidgetClass) && !defined(__polyspace_no_panedWidgetClass)
#include <X11/Xaw/Paned.h>
#undef panedWidgetClass
  extern WidgetClass panedWidgetClass;
#endif

#if defined(__polyspace_panedClassRec) && !defined(__polyspace_no_panedClassRec)
#include <X11/Xaw/PanedP.h>
#undef panedClassRec
  extern PanedClassRec panedClassRec;
#endif

#if defined(__polyspace_pannerWidgetClass) && !defined(__polyspace_no_pannerWidgetClass)
#include <X11/Xaw/Panner.h>
#undef pannerWidgetClass
  extern WidgetClass pannerWidgetClass;
#endif

#if defined(__polyspace_pannerClassRec) && !defined(__polyspace_no_pannerClassRec)
#include <X11/Xaw/PannerP.h>
#undef pannerClassRec
  extern PannerClassRec pannerClassRec;
#endif

#if defined(__polyspace_portholeWidgetClass) && !defined(__polyspace_no_portholeWidgetClass)
#include <X11/Xaw/Porthole.h>
#undef portholeWidgetClass
  extern WidgetClass portholeWidgetClass;
#endif

#if defined(__polyspace_portholeClassRec) && !defined(__polyspace_no_portholeClassRec)
#include <X11/Xaw/PortholeP.h>
#undef portholeClassRec
  extern PortholeClassRec portholeClassRec;
#endif

#if defined(__polyspace_repeaterWidgetClass) && !defined(__polyspace_no_repeaterWidgetClass)
#include <X11/Xaw/Repeater.h>
#undef repeaterWidgetClass
  extern WidgetClass repeaterWidgetClass;
#endif

#if defined(__polyspace_repeaterClassRec) && !defined(__polyspace_no_repeaterClassRec)
#include <X11/Xaw/RepeaterP.h>
#undef repeaterClassRec
  extern RepeaterClassRec repeaterClassRec;
#endif

#if defined(__polyspace_scrollbarWidgetClass) && !defined(__polyspace_no_scrollbarWidgetClass)
#include <X11/Xaw/Scrollbar.h>
#undef scrollbarWidgetClass
  extern WidgetClass scrollbarWidgetClass;
#endif

#if defined(__polyspace_scrollbarClassRec) && !defined(__polyspace_no_scrollbarClassRec)
#include <X11/Xaw/ScrollbarP.h>
#undef scrollbarClassRec
  extern ScrollbarClassRec scrollbarClassRec;
#endif

#if defined(__polyspace_simpleWidgetClass) && !defined(__polyspace_no_simpleWidgetClass)
#include <X11/Xaw/Simple.h>
#undef simpleWidgetClass
  extern WidgetClass simpleWidgetClass;
#endif

#if defined(__polyspace_simpleMenuClassRec) && !defined(__polyspace_no_simpleMenuClassRec)
#include <X11/Xaw/SimpleMenP.h>
#undef simpleMenuClassRec
  extern SimpleMenuClassRec simpleMenuClassRec;
#endif

#if defined(__polyspace_simpleMenuWidgetClass) && !defined(__polyspace_no_simpleMenuWidgetClass)
#include <X11/Xaw/SimpleMenu.h>
#undef simpleMenuWidgetClass
  extern WidgetClass simpleMenuWidgetClass;
#endif

#if defined(__polyspace_simpleClassRec) && !defined(__polyspace_no_simpleClassRec)
#include <X11/Xaw/SimpleP.h>
#undef simpleClassRec
  extern SimpleClassRec simpleClassRec;
#endif

#if defined(__polyspace_smeObjectClass) && !defined(__polyspace_no_smeObjectClass)
#include <X11/Xaw/Sme.h>
#undef smeObjectClass
  extern WidgetClass smeObjectClass;
#endif

#if defined(__polyspace_smeBSBObjectClass) && !defined(__polyspace_no_smeBSBObjectClass)
#include <X11/Xaw/SmeBSB.h>
#undef smeBSBObjectClass
  extern WidgetClass smeBSBObjectClass;
#endif

#if defined(__polyspace_smeBSBClassRec) && !defined(__polyspace_no_smeBSBClassRec)
#include <X11/Xaw/SmeBSBP.h>
#undef smeBSBClassRec
  extern SmeBSBClassRec smeBSBClassRec;
#endif

#if defined(__polyspace_smeLineObjectClass) && !defined(__polyspace_no_smeLineObjectClass)
#include <X11/Xaw/SmeLine.h>
#undef smeLineObjectClass
  extern WidgetClass smeLineObjectClass;
#endif

#if defined(__polyspace_smeLineClassRec) && !defined(__polyspace_no_smeLineClassRec)
#include <X11/Xaw/SmeLineP.h>
#undef smeLineClassRec
  extern SmeLineClassRec smeLineClassRec;
#endif

#if defined(__polyspace_smeClassRec) && !defined(__polyspace_no_smeClassRec)
#include <X11/Xaw/SmeP.h>
#undef smeClassRec
  extern SmeClassRec smeClassRec;
#endif

#if defined(__polyspace_stripChartClassRec) && !defined(__polyspace_no_stripChartClassRec)
#include <X11/Xaw/StripCharP.h>
#undef stripChartClassRec
  extern StripChartClassRec stripChartClassRec;
#endif

#if defined(__polyspace_stripChartWidgetClass) && !defined(__polyspace_no_stripChartWidgetClass)
#include <X11/Xaw/StripChart.h>
#undef stripChartWidgetClass
  extern WidgetClass stripChartWidgetClass;
#endif

#if defined(__polyspace_templateWidgetClass) && !defined(__polyspace_no_templateWidgetClass)
#include <X11/Xaw/Template.h>
#undef templateWidgetClass
  extern WidgetClass templateWidgetClass;
#endif

#if defined(__polyspace_templateClassRec) && !defined(__polyspace_no_templateClassRec)
#include <X11/Xaw/TemplateP.h>
#undef templateClassRec
  extern TemplateClassRec templateClassRec;
#endif

#if defined(__polyspace_FMT8BIT) && !defined(__polyspace_no_FMT8BIT)
#include <X11/Xaw/Text.h>
#undef FMT8BIT
  extern unsigned long FMT8BIT;
#endif

#if defined(__polyspace_XawFmt8Bit) && !defined(__polyspace_no_XawFmt8Bit)
#include <X11/Xaw/Text.h>
#undef XawFmt8Bit
  extern unsigned long XawFmt8Bit;
#endif

#if defined(__polyspace_XawFmtWide) && !defined(__polyspace_no_XawFmtWide)
#include <X11/Xaw/Text.h>
#undef XawFmtWide
  extern unsigned long XawFmtWide;
#endif

#if defined(__polyspace_textWidgetClass) && !defined(__polyspace_no_textWidgetClass)
#include <X11/Xaw/Text.h>
#undef textWidgetClass
  extern WidgetClass textWidgetClass;
#endif

#if defined(__polyspace__XawTextActionsTable) && !defined(__polyspace_no__XawTextActionsTable)
#include <X11/Xaw/TextP.h>
#undef _XawTextActionsTable
  extern XtActionsRec _XawTextActionsTable[];
#endif

#if defined(__polyspace__XawTextActionsTableCount) && !defined(__polyspace_no__XawTextActionsTableCount)
#include <X11/Xaw/TextP.h>
#undef _XawTextActionsTableCount
  extern Cardinal _XawTextActionsTableCount;
#endif

#if defined(__polyspace_textClassRec) && !defined(__polyspace_no_textClassRec)
#include <X11/Xaw/TextP.h>
#undef textClassRec
  extern TextClassRec textClassRec;
#endif

#if defined(__polyspace_textSinkObjectClass) && !defined(__polyspace_no_textSinkObjectClass)
#include <X11/Xaw/TextSink.h>
#undef textSinkObjectClass
  extern WidgetClass textSinkObjectClass;
#endif

#if defined(__polyspace_textSinkClassRec) && !defined(__polyspace_no_textSinkClassRec)
#include <X11/Xaw/TextSinkP.h>
#undef textSinkClassRec
  extern TextSinkClassRec textSinkClassRec;
#endif

#if defined(__polyspace_textSrcObjectClass) && !defined(__polyspace_no_textSrcObjectClass)
#include <X11/Xaw/TextSrc.h>
#undef textSrcObjectClass
  extern WidgetClass textSrcObjectClass;
#endif

#if defined(__polyspace_textSrcClassRec) && !defined(__polyspace_no_textSrcClassRec)
#include <X11/Xaw/TextSrcP.h>
#undef textSrcClassRec
  extern TextSrcClassRec textSrcClassRec;
#endif

#if defined(__polyspace_toggleWidgetClass) && !defined(__polyspace_no_toggleWidgetClass)
#include <X11/Xaw/Toggle.h>
#undef toggleWidgetClass
  extern WidgetClass    toggleWidgetClass;
#endif

#if defined(__polyspace_toggleClassRec) && !defined(__polyspace_no_toggleClassRec)
#include <X11/Xaw/ToggleP.h>
#undef toggleClassRec
  extern ToggleClassRec toggleClassRec;
#endif

#if defined(__polyspace_treeWidgetClass) && !defined(__polyspace_no_treeWidgetClass)
#include <X11/Xaw/Tree.h>
#undef treeWidgetClass
  extern WidgetClass treeWidgetClass;
#endif

#if defined(__polyspace_treeClassRec) && !defined(__polyspace_no_treeClassRec)
#include <X11/Xaw/TreeP.h>
#undef treeClassRec
  extern TreeClassRec treeClassRec;
#endif

#if defined(__polyspace_viewportWidgetClass) && !defined(__polyspace_no_viewportWidgetClass)
#include <X11/Xaw/Viewport.h>
#undef viewportWidgetClass
  extern WidgetClass viewportWidgetClass;
#endif

#if defined(__polyspace_viewportClassRec) && !defined(__polyspace_no_viewportClassRec)
#include <X11/Xaw/ViewportP.h>
#undef viewportClassRec
  extern ViewportClassRec viewportClassRec;
#endif

#if defined(__polyspace__Xdebug) && !defined(__polyspace_no__Xdebug)
#include <X11/Xlib.h>
#undef _Xdebug
  extern int _Xdebug;
#endif

#if defined(__polyspace__Xglobal_lock) && !defined(__polyspace_no__Xglobal_lock)
#include <X11/Xlibint.h>
#undef _Xglobal_lock
  extern LockInfoPtr _Xglobal_lock;
#endif

#if defined(__polyspace__XA_ATOM_PAIR) && !defined(__polyspace_no__XA_ATOM_PAIR)
#include <X11/Xmu/Atoms.h>
#undef _XA_ATOM_PAIR
  extern AtomPtr  _XA_ATOM_PAIR;
#endif

#if defined(__polyspace__XA_CHARACTER_POSITION) && !defined(__polyspace_no__XA_CHARACTER_POSITION)
#include <X11/Xmu/Atoms.h>
#undef _XA_CHARACTER_POSITION
  extern AtomPtr   _XA_CHARACTER_POSITION;
#endif

#if defined(__polyspace__XA_CLASS) && !defined(__polyspace_no__XA_CLASS)
#include <X11/Xmu/Atoms.h>
#undef _XA_CLASS
  extern AtomPtr   _XA_CLASS;
#endif

#if defined(__polyspace__XA_CLIENT_WINDOW) && !defined(__polyspace_no__XA_CLIENT_WINDOW)
#include <X11/Xmu/Atoms.h>
#undef _XA_CLIENT_WINDOW
  extern AtomPtr   _XA_CLIENT_WINDOW;
#endif

#if defined(__polyspace__XA_CLIPBOARD) && !defined(__polyspace_no__XA_CLIPBOARD)
#include <X11/Xmu/Atoms.h>
#undef _XA_CLIPBOARD
  extern AtomPtr   _XA_CLIPBOARD;
#endif

#if defined(__polyspace__XA_COMPOUND_TEXT) && !defined(__polyspace_no__XA_COMPOUND_TEXT)
#include <X11/Xmu/Atoms.h>
#undef _XA_COMPOUND_TEXT
  extern AtomPtr   _XA_COMPOUND_TEXT;
#endif

#if defined(__polyspace__XA_DECNET_ADDRESS) && !defined(__polyspace_no__XA_DECNET_ADDRESS)
#include <X11/Xmu/Atoms.h>
#undef _XA_DECNET_ADDRESS
  extern AtomPtr   _XA_DECNET_ADDRESS;
#endif

#if defined(__polyspace__XA_DELETE) && !defined(__polyspace_no__XA_DELETE)
#include <X11/Xmu/Atoms.h>
#undef _XA_DELETE
  extern AtomPtr   _XA_DELETE;
#endif

#if defined(__polyspace__XA_FILENAME) && !defined(__polyspace_no__XA_FILENAME)
#include <X11/Xmu/Atoms.h>
#undef _XA_FILENAME
  extern AtomPtr   _XA_FILENAME;
#endif

#if defined(__polyspace__XA_HOSTNAME) && !defined(__polyspace_no__XA_HOSTNAME)
#include <X11/Xmu/Atoms.h>
#undef _XA_HOSTNAME
  extern AtomPtr   _XA_HOSTNAME;
#endif

#if defined(__polyspace__XA_IP_ADDRESS) && !defined(__polyspace_no__XA_IP_ADDRESS)
#include <X11/Xmu/Atoms.h>
#undef _XA_IP_ADDRESS
  extern AtomPtr   _XA_IP_ADDRESS;
#endif

#if defined(__polyspace__XA_LENGTH) && !defined(__polyspace_no__XA_LENGTH)
#include <X11/Xmu/Atoms.h>
#undef _XA_LENGTH
  extern AtomPtr   _XA_LENGTH;
#endif

#if defined(__polyspace__XA_LIST_LENGTH) && !defined(__polyspace_no__XA_LIST_LENGTH)
#include <X11/Xmu/Atoms.h>
#undef _XA_LIST_LENGTH
  extern AtomPtr   _XA_LIST_LENGTH;
#endif

#if defined(__polyspace__XA_NAME) && !defined(__polyspace_no__XA_NAME)
#include <X11/Xmu/Atoms.h>
#undef _XA_NAME
  extern AtomPtr   _XA_NAME;
#endif

#if defined(__polyspace__XA_NET_ADDRESS) && !defined(__polyspace_no__XA_NET_ADDRESS)
#include <X11/Xmu/Atoms.h>
#undef _XA_NET_ADDRESS
  extern AtomPtr   _XA_NET_ADDRESS;
#endif

#if defined(__polyspace__XA_NULL) && !defined(__polyspace_no__XA_NULL)
#include <X11/Xmu/Atoms.h>
#undef _XA_NULL
  extern AtomPtr   _XA_NULL;
#endif

#if defined(__polyspace__XA_OWNER_OS) && !defined(__polyspace_no__XA_OWNER_OS)
#include <X11/Xmu/Atoms.h>
#undef _XA_OWNER_OS
  extern AtomPtr   _XA_OWNER_OS;
#endif

#if defined(__polyspace__XA_SPAN) && !defined(__polyspace_no__XA_SPAN)
#include <X11/Xmu/Atoms.h>
#undef _XA_SPAN
  extern AtomPtr   _XA_SPAN;
#endif

#if defined(__polyspace__XA_TARGETS) && !defined(__polyspace_no__XA_TARGETS)
#include <X11/Xmu/Atoms.h>
#undef _XA_TARGETS
  extern AtomPtr   _XA_TARGETS;
#endif

#if defined(__polyspace__XA_TEXT) && !defined(__polyspace_no__XA_TEXT)
#include <X11/Xmu/Atoms.h>
#undef _XA_TEXT
  extern AtomPtr   _XA_TEXT;
#endif

#if defined(__polyspace__XA_TIMESTAMP) && !defined(__polyspace_no__XA_TIMESTAMP)
#include <X11/Xmu/Atoms.h>
#undef _XA_TIMESTAMP
  extern AtomPtr   _XA_TIMESTAMP;
#endif

#if defined(__polyspace__XA_USER) && !defined(__polyspace_no__XA_USER)
#include <X11/Xmu/Atoms.h>
#undef _XA_USER
  extern AtomPtr   _XA_USER;
#endif

#if defined(__polyspace_sys_errlist) && !defined(__polyspace_no_sys_errlist)
#include <X11/Xos.h>
#undef sys_errlist
  extern char *sys_errlist[];
#endif

#if defined(__polyspace_sys_nerr) && !defined(__polyspace_no_sys_nerr)
#include <X11/Xos.h>
#undef sys_nerr
  extern int sys_nerr;
#endif

#if defined(__polyspace__xp_hinter_proc) && !defined(__polyspace_no__xp_hinter_proc)
#include <X11/extensions/Printstr.h>
#undef _xp_hinter_proc
  extern XPHinterProc _xp_hinter_proc;
#endif

#if defined(__polyspace__xp_hinter_desc) && !defined(__polyspace_no__xp_hinter_desc)
#include <X11/extensions/Printstr.h>
#undef _xp_hinter_desc
  extern char   *_xp_hinter_desc;
#endif

#if defined(__polyspace__xp_hinter_init) && !defined(__polyspace_no__xp_hinter_init)
#include <X11/extensions/Printstr.h>
#undef _xp_hinter_init
  extern int   _xp_hinter_init;
#endif

#if defined(__polyspace_XkbCFDflts) && !defined(__polyspace_no_XkbCFDflts)
#include <X11/extensions/XKBconfig.h>
#undef XkbCFDflts
  extern XkbConfigFieldsPtr XkbCFDflts;
#endif

#if defined(__polyspace__XkbErrMessages) && !defined(__polyspace_no__XkbErrMessages)
#include <X11/extensions/XKBfile.h>
#undef _XkbErrMessages
  extern char * _XkbErrMessages[];
#endif

#if defined(__polyspace__XkbErrCode) && !defined(__polyspace_no__XkbErrCode)
#include <X11/extensions/XKBfile.h>
#undef _XkbErrCode
  extern unsigned _XkbErrCode;
#endif

#if defined(__polyspace__XkbErrLocation) && !defined(__polyspace_no__XkbErrLocation)
#include <X11/extensions/XKBfile.h>
#undef _XkbErrLocation
  extern char * _XkbErrLocation;
#endif

#if defined(__polyspace__XkbErrData) && !defined(__polyspace_no__XkbErrData)
#include <X11/extensions/XKBfile.h>
#undef _XkbErrData
  extern unsigned _XkbErrData;
#endif

#if defined(__polyspace_XkbReqCode) && !defined(__polyspace_no_XkbReqCode)
#include <X11/extensions/XKBsrv.h>
#undef XkbReqCode
  extern int XkbReqCode;
#endif

#if defined(__polyspace_XkbEventBase) && !defined(__polyspace_no_XkbEventBase)
#include <X11/extensions/XKBsrv.h>
#undef XkbEventBase
  extern int XkbEventBase;
#endif

#if defined(__polyspace_XkbKeyboardErrorCode) && !defined(__polyspace_no_XkbKeyboardErrorCode)
#include <X11/extensions/XKBsrv.h>
#undef XkbKeyboardErrorCode
  extern int XkbKeyboardErrorCode;
#endif

#if defined(__polyspace_XkbDisableLockActions) && !defined(__polyspace_no_XkbDisableLockActions)
#include <X11/extensions/XKBsrv.h>
#undef XkbDisableLockActions
  extern int XkbDisableLockActions;
#endif

#if defined(__polyspace_XkbBaseDirectory) && !defined(__polyspace_no_XkbBaseDirectory)
#include <X11/extensions/XKBsrv.h>
#undef XkbBaseDirectory
  extern char * XkbBaseDirectory;
#endif

#if defined(__polyspace_XkbInitialMap) && !defined(__polyspace_no_XkbInitialMap)
#include <X11/extensions/XKBsrv.h>
#undef XkbInitialMap
  extern char * XkbInitialMap;
#endif

#if defined(__polyspace__XkbClientMajor) && !defined(__polyspace_no__XkbClientMajor)
#include <X11/extensions/XKBsrv.h>
#undef _XkbClientMajor
  extern int _XkbClientMajor;
#endif

#if defined(__polyspace__XkbClientMinor) && !defined(__polyspace_no__XkbClientMinor)
#include <X11/extensions/XKBsrv.h>
#undef _XkbClientMinor
  extern int _XkbClientMinor;
#endif

#if defined(__polyspace_XkbXIUnsupported) && !defined(__polyspace_no_XkbXIUnsupported)
#include <X11/extensions/XKBsrv.h>
#undef XkbXIUnsupported
  extern unsigned int XkbXIUnsupported;
#endif

#if defined(__polyspace_XkbModelUsed) && !defined(__polyspace_no_XkbModelUsed)
#include <X11/extensions/XKBsrv.h>
#undef XkbModelUsed
  extern char * XkbModelUsed;
#endif

#if defined(__polyspace_XkbLayoutUsed) && !defined(__polyspace_no_XkbLayoutUsed)
#include <X11/extensions/XKBsrv.h>
#undef XkbLayoutUsed
  extern char * *XkbLayoutUsed;
#endif

#if defined(__polyspace_XkbVariantUsed) && !defined(__polyspace_no_XkbVariantUsed)
#include <X11/extensions/XKBsrv.h>
#undef XkbVariantUsed
  extern char * *XkbVariantUsed;
#endif

#if defined(__polyspace_XkbOptionsUsed) && !defined(__polyspace_no_XkbOptionsUsed)
#include <X11/extensions/XKBsrv.h>
#undef XkbOptionsUsed
  extern char * *XkbOptionsUsed;
#endif

#if defined(__polyspace_noXkbExtension) && !defined(__polyspace_no_noXkbExtension)
#include <X11/extensions/XKBsrv.h>
#undef noXkbExtension
  extern Bool noXkbExtension;
#endif

#if defined(__polyspace_XkbWantRulesProp) && !defined(__polyspace_no_XkbWantRulesProp)
#include <X11/extensions/XKBsrv.h>
#undef XkbWantRulesProp
  extern Bool XkbWantRulesProp;
#endif

#if defined(__polyspace_XkbLastRepeatEvent) && !defined(__polyspace_no_XkbLastRepeatEvent)
#include <X11/extensions/XKBsrv.h>
#undef XkbLastRepeatEvent
  extern pointer XkbLastRepeatEvent;
#endif

#if defined(__polyspace_xkbDebugFlags) && !defined(__polyspace_no_xkbDebugFlags)
#include <X11/extensions/XKBsrv.h>
#undef xkbDebugFlags
  extern CARD32 xkbDebugFlags;
#endif

#if defined(__polyspace_xkbDebugCtrls) && !defined(__polyspace_no_xkbDebugCtrls)
#include <X11/extensions/XKBsrv.h>
#undef xkbDebugCtrls
  extern CARD32 xkbDebugCtrls;
#endif

#if defined(__polyspace_DeviceKeyPress) && !defined(__polyspace_no_DeviceKeyPress)
#include <X11/extensions/XKBsrv.h>
#undef DeviceKeyPress
  extern int DeviceKeyPress;
#endif

#if defined(__polyspace_DeviceKeyRelease) && !defined(__polyspace_no_DeviceKeyRelease)
#include <X11/extensions/XKBsrv.h>
#undef DeviceKeyRelease
  extern int DeviceKeyRelease;
#endif

#if defined(__polyspace_DeviceButtonPress) && !defined(__polyspace_no_DeviceButtonPress)
#include <X11/extensions/XKBsrv.h>
#undef DeviceButtonPress
  extern int DeviceButtonPress;
#endif

#if defined(__polyspace_DeviceButtonRelease) && !defined(__polyspace_no_DeviceButtonRelease)
#include <X11/extensions/XKBsrv.h>
#undef DeviceButtonRelease
  extern int DeviceButtonRelease;
#endif

#if defined(__polyspace_lbxDebug) && !defined(__polyspace_no_lbxDebug)
#include <X11/extensions/lbxstr.h>
#undef lbxDebug
  extern int lbxDebug;
#endif

#if defined(__polyspace_SecurityAuthorizationResType) && !defined(__polyspace_no_SecurityAuthorizationResType)
#include <X11/extensions/security.h>
#undef SecurityAuthorizationResType
  extern RESTYPE SecurityAuthorizationResType;
#endif

#if defined(__polyspace_SecurityValidateGroupCallback) && !defined(__polyspace_no_SecurityValidateGroupCallback)
#include <X11/extensions/security.h>
#undef SecurityValidateGroupCallback
  extern CallbackListPtr SecurityValidateGroupCallback;
#endif

#if defined(__polyspace_layoutWidgetClass) && !defined(__polyspace_no_layoutWidgetClass)
#include <X11/Xaw3d/Layout.h>
#undef layoutWidgetClass
  extern WidgetClass layoutWidgetClass;
#endif

#if defined(__polyspace_layoutClassRec) && !defined(__polyspace_no_layoutClassRec)
#include <X11/Xaw3d/LayoutP.h>
#undef layoutClassRec
  extern LayoutClassRec layoutClassRec;
#endif

#if defined(__polyspace_smeThreeDWidgetClass) && !defined(__polyspace_no_smeThreeDWidgetClass)
#include <X11/Xaw3d/SmeThreeD.h>
#undef smeThreeDWidgetClass
  extern WidgetClass smeThreeDWidgetClass;
#endif

#if defined(__polyspace_smeThreeDClassRec) && !defined(__polyspace_no_smeThreeDClassRec)
#include <X11/Xaw3d/SmeThreeDP.h>
#undef smeThreeDClassRec
  extern SmeThreeDClassRec smeThreeDClassRec;
#endif

#if defined(__polyspace_threeDWidgetClass) && !defined(__polyspace_no_threeDWidgetClass)
#include <X11/Xaw3d/ThreeD.h>
#undef threeDWidgetClass
  extern WidgetClass threeDWidgetClass;
#endif

#if defined(__polyspace_threeDClassRec) && !defined(__polyspace_no_threeDClassRec)
#include <X11/Xaw3d/ThreeDP.h>
#undef threeDClassRec
  extern ThreeDClassRec threeDClassRec;
#endif

#if defined(__polyspace_argp_program_version) && !defined(__polyspace_no_argp_program_version)
#include <argp.h>
#undef argp_program_version
  extern __const char *argp_program_version;
#endif

#if defined(__polyspace_argp_program_bug_address) && !defined(__polyspace_no_argp_program_bug_address)
#include <argp.h>
#undef argp_program_bug_address
  extern __const char *argp_program_bug_address;
#endif

#if defined(__polyspace_argp_err_exit_status) && !defined(__polyspace_no_argp_err_exit_status)
#include <argp.h>
#undef argp_err_exit_status
  extern error_t argp_err_exit_status;
#endif

#if defined(__polyspace_telcmds) && !defined(__polyspace_no_telcmds)
#include <arpa/telnet.h>
#undef telcmds
  extern char *telcmds[];
#endif

#if defined(__polyspace_slc_names) && !defined(__polyspace_no_slc_names)
#include <arpa/telnet.h>
#undef slc_names
  extern char *slc_names[];
#endif

#if defined(__polyspace_authtype_names) && !defined(__polyspace_no_authtype_names)
#include <arpa/telnet.h>
#undef authtype_names
  extern char *authtype_names[];
#endif

#if defined(__polyspace_encrypt_names) && !defined(__polyspace_no_encrypt_names)
#include <arpa/telnet.h>
#undef encrypt_names
  extern char *encrypt_names[];
#endif

#if defined(__polyspace_enctype_names) && !defined(__polyspace_no_enctype_names)
#include <arpa/telnet.h>
#undef enctype_names
  extern char *enctype_names[];
#endif

#if defined(__polyspace_bigmem_start) && !defined(__polyspace_no_bigmem_start)
#include <asm/bigmem.h>
#undef bigmem_start
  extern unsigned long bigmem_start;
#endif

#if defined(__polyspace_bigmem_end) && !defined(__polyspace_no_bigmem_end)
#include <asm/bigmem.h>
#undef bigmem_end
  extern unsigned long bigmem_end;
#endif

#if defined(__polyspace_nr_free_bigpages) && !defined(__polyspace_no_nr_free_bigpages)
#include <asm/bigmem.h>
#undef nr_free_bigpages
  extern int nr_free_bigpages;
#endif

#if defined(__polyspace_kmap_pte) && !defined(__polyspace_no_kmap_pte)
#include <asm/bigmem.h>
#undef kmap_pte
  extern pte_t *kmap_pte;
#endif

#if defined(__polyspace_kmap_prot) && !defined(__polyspace_no_kmap_prot)
#include <asm/bigmem.h>
#undef kmap_prot
  extern pgprot_t kmap_prot;
#endif

#if defined(__polyspace_Cx86_dir0_msb) && !defined(__polyspace_no_Cx86_dir0_msb)
#include <asm/bugs.h>
#undef Cx86_dir0_msb
  extern unsigned char Cx86_dir0_msb;
#endif

#if defined(__polyspace_visws_board_type) && !defined(__polyspace_no_visws_board_type)
#include <asm/cobalt.h>
#undef visws_board_type
  extern char visws_board_type;
#endif

#if defined(__polyspace_visws_board_rev) && !defined(__polyspace_no_visws_board_rev)
#include <asm/cobalt.h>
#undef visws_board_rev
  extern char visws_board_rev;
#endif

#if defined(__polyspace_gdt_table) && !defined(__polyspace_no_gdt_table)
#include <asm/desc.h>
#undef gdt_table
  extern struct desc_struct gdt_table[];
#endif

#if defined(__polyspace_idt) && !defined(__polyspace_no_idt)
#include <asm/desc.h>
#undef idt
  extern struct desc_struct *idt;
#endif

#if defined(__polyspace_gdt) && !defined(__polyspace_no_gdt)
#include <asm/desc.h>
#undef gdt
  extern struct desc_struct *gdt;
#endif

#if defined(__polyspace_default_ldt) && !defined(__polyspace_no_default_ldt)
#include <asm/desc.h>
#undef default_ldt
  extern struct desc_struct default_ldt;
#endif

#if defined(__polyspace_dma_spin_lock) && !defined(__polyspace_no_dma_spin_lock)
#include <asm/dma.h>
#undef dma_spin_lock
  extern spinlock_t dma_spin_lock;
#endif

#if defined(__polyspace_isa_dma_bridge_buggy) && !defined(__polyspace_no_isa_dma_bridge_buggy)
#include <asm/dma.h>
#undef isa_dma_bridge_buggy
  extern int isa_dma_bridge_buggy;
#endif

#if defined(__polyspace_local_irq_count) && !defined(__polyspace_no_local_irq_count)
#include <asm/hardirq.h>
#undef local_irq_count
  extern unsigned int local_irq_count[NR_CPUS];
#endif

#if defined(__polyspace_global_irq_holder) && !defined(__polyspace_no_global_irq_holder)
#include <asm/hardirq.h>
#undef global_irq_holder
  extern unsigned char global_irq_holder;
#endif

#if defined(__polyspace_global_irq_lock) && !defined(__polyspace_no_global_irq_lock)
#include <asm/hardirq.h>
#undef global_irq_lock
  extern unsigned volatile int global_irq_lock;
#endif

#if defined(__polyspace_global_irq_count) && !defined(__polyspace_no_global_irq_count)
#include <asm/hardirq.h>
#undef global_irq_count
  extern atomic_t global_irq_count;
#endif

#if defined(__polyspace_pckbd_sysrq_xlate) && !defined(__polyspace_no_pckbd_sysrq_xlate)
#include <asm/keyboard.h>
#undef pckbd_sysrq_xlate
  extern unsigned char pckbd_sysrq_xlate[128];
#endif

#if defined(__polyspace_linux_logo_red) && !defined(__polyspace_no_linux_logo_red)
#include <asm/linux_logo.h>
#undef linux_logo_red
  extern unsigned char linux_logo_red[];
#endif

#if defined(__polyspace_linux_logo_green) && !defined(__polyspace_no_linux_logo_green)
#include <asm/linux_logo.h>
#undef linux_logo_green
  extern unsigned char linux_logo_green[];
#endif

#if defined(__polyspace_linux_logo_blue) && !defined(__polyspace_no_linux_logo_blue)
#include <asm/linux_logo.h>
#undef linux_logo_blue
  extern unsigned char linux_logo_blue[];
#endif

#if defined(__polyspace_linux_logo) && !defined(__polyspace_no_linux_logo)
#include <asm/linux_logo.h>
#undef linux_logo
  extern unsigned char linux_logo[];
#endif

#if defined(__polyspace_linux_logo_bw) && !defined(__polyspace_no_linux_logo_bw)
#include <asm/linux_logo.h>
#undef linux_logo_bw
  extern unsigned char linux_logo_bw[];
#endif

#if defined(__polyspace_linux_logo16_red) && !defined(__polyspace_no_linux_logo16_red)
#include <asm/linux_logo.h>
#undef linux_logo16_red
  extern unsigned char linux_logo16_red[];
#endif

#if defined(__polyspace_linux_logo16_green) && !defined(__polyspace_no_linux_logo16_green)
#include <asm/linux_logo.h>
#undef linux_logo16_green
  extern unsigned char linux_logo16_green[];
#endif

#if defined(__polyspace_linux_logo16_blue) && !defined(__polyspace_no_linux_logo16_blue)
#include <asm/linux_logo.h>
#undef linux_logo16_blue
  extern unsigned char linux_logo16_blue[];
#endif

#if defined(__polyspace_linux_logo16) && !defined(__polyspace_no_linux_logo16)
#include <asm/linux_logo.h>
#undef linux_logo16
  extern unsigned char linux_logo16[];
#endif

#if defined(__polyspace_pg0) && !defined(__polyspace_no_pg0)
#include <asm/pgtable.h>
#undef pg0
  extern unsigned long pg0[1024];
#endif

#if defined(__polyspace_empty_zero_page) && !defined(__polyspace_no_empty_zero_page)
#include <asm/pgtable.h>
#undef empty_zero_page
  extern unsigned long empty_zero_page[1024];
#endif

#if defined(__polyspace_swapper_pg_dir) && !defined(__polyspace_no_swapper_pg_dir)
#include <asm/pgtable.h>
#undef swapper_pg_dir
  extern pgd_t swapper_pg_dir[1024];
#endif

#if defined(__polyspace_boot_cpu_data) && !defined(__polyspace_no_boot_cpu_data)
#include <asm/processor.h>
#undef boot_cpu_data
  extern struct cpuinfo_x86 boot_cpu_data;
#endif

#if defined(__polyspace_cpu_data) && !defined(__polyspace_no_cpu_data)
#include <asm/processor.h>
#undef cpu_data
  extern struct cpuinfo_x86 cpu_data[];
#endif

#if defined(__polyspace_ignore_irq13) && !defined(__polyspace_no_ignore_irq13)
#include <asm/processor.h>
#undef ignore_irq13
  extern char ignore_irq13;
#endif

#if defined(__polyspace_EISA_bus) && !defined(__polyspace_no_EISA_bus)
#include <asm/processor.h>
#undef EISA_bus
  extern int EISA_bus;
#endif

#if defined(__polyspace_MCA_bus) && !defined(__polyspace_no_MCA_bus)
#include <asm/processor.h>
#undef MCA_bus
  extern int MCA_bus;
#endif

#if defined(__polyspace_machine_id) && !defined(__polyspace_no_machine_id)
#include <asm/processor.h>
#undef machine_id
  extern unsigned int machine_id;
#endif

#if defined(__polyspace_machine_submodel_id) && !defined(__polyspace_no_machine_submodel_id)
#include <asm/processor.h>
#undef machine_submodel_id
  extern unsigned int machine_submodel_id;
#endif

#if defined(__polyspace_BIOS_revision) && !defined(__polyspace_no_BIOS_revision)
#include <asm/processor.h>
#undef BIOS_revision
  extern unsigned int BIOS_revision;
#endif

#if defined(__polyspace_mca_pentium_flag) && !defined(__polyspace_no_mca_pentium_flag)
#include <asm/processor.h>
#undef mca_pentium_flag
  extern unsigned int mca_pentium_flag;
#endif

#if defined(__polyspace_semaphore_wake_lock) && !defined(__polyspace_no_semaphore_wake_lock)
#include <asm/semaphore.h>
#undef semaphore_wake_lock
  extern spinlock_t semaphore_wake_lock;
#endif

#if defined(__polyspace_smp_found_config) && !defined(__polyspace_no_smp_found_config)
#include <asm/smp.h>
#undef smp_found_config
  extern int smp_found_config;
#endif

#if defined(__polyspace_boot_cpu_id) && !defined(__polyspace_no_boot_cpu_id)
#include <asm/smp.h>
#undef boot_cpu_id
  extern unsigned char boot_cpu_id;
#endif

#if defined(__polyspace_cpu_present_map) && !defined(__polyspace_no_cpu_present_map)
#include <asm/smp.h>
#undef cpu_present_map
  extern unsigned long cpu_present_map;
#endif

#if defined(__polyspace_cpu_online_map) && !defined(__polyspace_no_cpu_online_map)
#include <asm/smp.h>
#undef cpu_online_map
  extern unsigned long cpu_online_map;
#endif

#if defined(__polyspace_cpu_number_map) && !defined(__polyspace_no_cpu_number_map)
#include <asm/smp.h>
#undef cpu_number_map
  extern volatile int cpu_number_map[NR_CPUS];
#endif

#if defined(__polyspace_smp_invalidate_needed) && !defined(__polyspace_no_smp_invalidate_needed)
#include <asm/smp.h>
#undef smp_invalidate_needed
  extern volatile unsigned long smp_invalidate_needed;
#endif

#if defined(__polyspace_cpu_callin_map) && !defined(__polyspace_no_cpu_callin_map)
#include <asm/smp.h>
#undef cpu_callin_map
  extern volatile unsigned long cpu_callin_map[NR_CPUS];
#endif

#if defined(__polyspace_ipi_count) && !defined(__polyspace_no_ipi_count)
#include <asm/smp.h>
#undef ipi_count
  extern unsigned long ipi_count;
#endif

#if defined(__polyspace___cpu_logical_map) && !defined(__polyspace_no___cpu_logical_map)
#include <asm/smp.h>
#undef __cpu_logical_map
  extern volatile int __cpu_logical_map[NR_CPUS];
#endif

#if defined(__polyspace_kernel_flag) && !defined(__polyspace_no_kernel_flag)
#include <asm/smplock.h>
#undef kernel_flag
  extern spinlock_t kernel_flag;
#endif

#if defined(__polyspace_local_bh_count) && !defined(__polyspace_no_local_bh_count)
#include <asm/softirq.h>
#undef local_bh_count
  extern unsigned int local_bh_count[NR_CPUS];
#endif

#if defined(__polyspace_global_bh_lock) && !defined(__polyspace_no_global_bh_lock)
#include <asm/softirq.h>
#undef global_bh_lock
  extern atomic_t global_bh_lock;
#endif

#if defined(__polyspace_global_bh_count) && !defined(__polyspace_no_global_bh_count)
#include <asm/softirq.h>
#undef global_bh_count
  extern atomic_t global_bh_count;
#endif

#if defined(__polyspace_i386_bh_lock) && !defined(__polyspace_no_i386_bh_lock)
#include <asm/softirq.h>
#undef i386_bh_lock
  extern spinlock_t i386_bh_lock;
#endif

#if defined(__polyspace_cacheflush_time) && !defined(__polyspace_no_cacheflush_time)
#include <asm/timex.h>
#undef cacheflush_time
  extern cycles_t cacheflush_time;
#endif

#if defined(__polyspace_bfd_abs_section) && !defined(__polyspace_no_bfd_abs_section)
#include <bfd.h>
#undef bfd_abs_section
  extern const asection bfd_abs_section;
#endif

#if defined(__polyspace_bfd_und_section) && !defined(__polyspace_no_bfd_und_section)
#include <bfd.h>
#undef bfd_und_section
  extern const asection bfd_und_section;
#endif

#if defined(__polyspace_bfd_com_section) && !defined(__polyspace_no_bfd_com_section)
#include <bfd.h>
#undef bfd_com_section
  extern const asection bfd_com_section;
#endif

#if defined(__polyspace_bfd_ind_section) && !defined(__polyspace_no_bfd_ind_section)
#include <bfd.h>
#undef bfd_ind_section
  extern const asection bfd_ind_section;
#endif

#if defined(__polyspace_bfd_abs_symbol) && !defined(__polyspace_no_bfd_abs_symbol)
#include <bfd.h>
#undef bfd_abs_symbol
  extern const struct symbol_cache_entry * const bfd_abs_symbol;
#endif

#if defined(__polyspace_bfd_com_symbol) && !defined(__polyspace_no_bfd_com_symbol)
#include <bfd.h>
#undef bfd_com_symbol
  extern const struct symbol_cache_entry * const bfd_com_symbol;
#endif

#if defined(__polyspace_bfd_und_symbol) && !defined(__polyspace_no_bfd_und_symbol)
#include <bfd.h>
#undef bfd_und_symbol
  extern const struct symbol_cache_entry * const bfd_und_symbol;
#endif

#if defined(__polyspace_bfd_ind_symbol) && !defined(__polyspace_no_bfd_ind_symbol)
#include <bfd.h>
#undef bfd_ind_symbol
  extern const struct symbol_cache_entry * const bfd_ind_symbol;
#endif

#if defined(__polyspace_db_rw_conflicts) && !defined(__polyspace_no_db_rw_conflicts)
#include <db.h>
#undef db_rw_conflicts
  extern const u_int8_t db_rw_conflicts[];
#endif

#if defined(__polyspace_db_riw_conflicts) && !defined(__polyspace_no_db_riw_conflicts)
#include <db.h>
#undef db_riw_conflicts
  extern const u_int8_t db_riw_conflicts[];
#endif

#if defined(__polyspace_error_message_count) && !defined(__polyspace_no_error_message_count)
#include <error.h>
#undef error_message_count
  extern unsigned int error_message_count;
#endif

#if defined(__polyspace_error_one_per_line) && !defined(__polyspace_no_error_one_per_line)
#include <error.h>
#undef error_one_per_line
  extern int error_one_per_line;
#endif

#if defined(__polyspace_exp_buffer) && !defined(__polyspace_no_exp_buffer)
#include <expect.h>
#undef exp_buffer
  EXTERN char *exp_buffer;
#endif

#if defined(__polyspace_exp_buffer_end) && !defined(__polyspace_no_exp_buffer_end)
#include <expect.h>
#undef exp_buffer_end
  EXTERN char *exp_buffer_end;
#endif

#if defined(__polyspace_exp_match) && !defined(__polyspace_no_exp_match)
#include <expect.h>
#undef exp_match
  EXTERN char *exp_match;
#endif

#if defined(__polyspace_exp_match_end) && !defined(__polyspace_no_exp_match_end)
#include <expect.h>
#undef exp_match_end
  EXTERN char *exp_match_end;
#endif

#if defined(__polyspace_exp_match_max) && !defined(__polyspace_no_exp_match_max)
#include <expect.h>
#undef exp_match_max
  EXTERN int exp_match_max;
#endif

#if defined(__polyspace_exp_timeout) && !defined(__polyspace_no_exp_timeout)
#include <expect.h>
#undef exp_timeout
  EXTERN int exp_timeout;
#endif

#if defined(__polyspace_exp_full_buffer) && !defined(__polyspace_no_exp_full_buffer)
#include <expect.h>
#undef exp_full_buffer
  EXTERN int exp_full_buffer;
#endif

#if defined(__polyspace_exp_remove_nulls) && !defined(__polyspace_no_exp_remove_nulls)
#include <expect.h>
#undef exp_remove_nulls
  EXTERN int exp_remove_nulls;
#endif

#if defined(__polyspace_exp_pty_timeout) && !defined(__polyspace_no_exp_pty_timeout)
#include <expect.h>
#undef exp_pty_timeout
  EXTERN int exp_pty_timeout;
#endif

#if defined(__polyspace_exp_pid) && !defined(__polyspace_no_exp_pid)
#include <expect.h>
#undef exp_pid
  EXTERN int exp_pid;
#endif

#if defined(__polyspace_exp_autoallocpty) && !defined(__polyspace_no_exp_autoallocpty)
#include <expect.h>
#undef exp_autoallocpty
  EXTERN int exp_autoallocpty;
#endif

#if defined(__polyspace_exp_pty) && !defined(__polyspace_no_exp_pty)
#include <expect.h>
#undef exp_pty
  EXTERN int exp_pty[2];
#endif

#if defined(__polyspace_exp_pty_slave_name) && !defined(__polyspace_no_exp_pty_slave_name)
#include <expect.h>
#undef exp_pty_slave_name
  EXTERN char *exp_pty_slave_name;
#endif

#if defined(__polyspace_exp_stty_init) && !defined(__polyspace_no_exp_stty_init)
#include <expect.h>
#undef exp_stty_init
  EXTERN char *exp_stty_init;
#endif

#if defined(__polyspace_exp_ttycopy) && !defined(__polyspace_no_exp_ttycopy)
#include <expect.h>
#undef exp_ttycopy
  EXTERN int exp_ttycopy;
#endif

#if defined(__polyspace_exp_ttyinit) && !defined(__polyspace_no_exp_ttyinit)
#include <expect.h>
#undef exp_ttyinit
  EXTERN int exp_ttyinit;
#endif

#if defined(__polyspace_exp_console) && !defined(__polyspace_no_exp_console)
#include <expect.h>
#undef exp_console
  EXTERN int exp_console;
#endif

#if defined(__polyspace_exp_readenv) && !defined(__polyspace_no_exp_readenv)
#include <expect.h>
#undef exp_readenv
  EXTERN jmp_buf exp_readenv;
#endif

#if defined(__polyspace_exp_reading) && !defined(__polyspace_no_exp_reading)
#include <expect.h>
#undef exp_reading
  EXTERN int exp_reading;
#endif

#if defined(__polyspace_exp_logfile_all) && !defined(__polyspace_no_exp_logfile_all)
#include <expect.h>
#undef exp_logfile_all
  EXTERN int exp_logfile_all;
#endif

#if defined(__polyspace_exp_debugfile) && !defined(__polyspace_no_exp_debugfile)
#include <expect.h>
#undef exp_debugfile
  EXTERN FILE *exp_debugfile;
#endif

#if defined(__polyspace_exp_logfile) && !defined(__polyspace_no_exp_logfile)
#include <expect.h>
#undef exp_logfile
  EXTERN FILE *exp_logfile;
#endif

#if defined(__polyspace_exp_is_debugging) && !defined(__polyspace_no_exp_is_debugging)
#include <expect_comm.h>
#undef exp_is_debugging
  EXTERN int exp_is_debugging;
#endif

#if defined(__polyspace_exp_loguser) && !defined(__polyspace_no_exp_loguser)
#include <expect_comm.h>
#undef exp_loguser
  EXTERN int exp_loguser;
#endif

#if defined(__polyspace_exp_disconnected) && !defined(__polyspace_no_exp_disconnected)
#include <expect_comm.h>
#undef exp_disconnected
  EXTERN int exp_disconnected;
#endif

#if defined(__polyspace_exp_pty_error) && !defined(__polyspace_no_exp_pty_error)
#include <expect_comm.h>
#undef exp_pty_error
  EXTERN char *exp_pty_error;
#endif

#if defined(__polyspace_exp_cmdlinecmds) && !defined(__polyspace_no_exp_cmdlinecmds)
#include <expect_tcl.h>
#undef exp_cmdlinecmds
  EXTERN int exp_cmdlinecmds;
#endif

#if defined(__polyspace_exp_interactive) && !defined(__polyspace_no_exp_interactive)
#include <expect_tcl.h>
#undef exp_interactive
  EXTERN int exp_interactive;
#endif

#if defined(__polyspace_exp_cmdfile) && !defined(__polyspace_no_exp_cmdfile)
#include <expect_tcl.h>
#undef exp_cmdfile
  EXTERN FILE *exp_cmdfile;
#endif

#if defined(__polyspace_exp_cmdfilename) && !defined(__polyspace_no_exp_cmdfilename)
#include <expect_tcl.h>
#undef exp_cmdfilename
  EXTERN char *exp_cmdfilename;
#endif

#if defined(__polyspace_exp_getpid) && !defined(__polyspace_no_exp_getpid)
#include <expect_tcl.h>
#undef exp_getpid
  EXTERN int exp_getpid;
#endif

#if defined(__polyspace_exp_buffer_command_input) && !defined(__polyspace_no_exp_buffer_command_input)
#include <expect_tcl.h>
#undef exp_buffer_command_input
  EXTERN int exp_buffer_command_input;
#endif

#if defined(__polyspace_exp_tcl_debugger_available) && !defined(__polyspace_no_exp_tcl_debugger_available)
#include <expect_tcl.h>
#undef exp_tcl_debugger_available
  EXTERN int exp_tcl_debugger_available;
#endif

#if defined(__polyspace_exp_interp) && !defined(__polyspace_no_exp_interp)
#include <expect_tcl.h>
#undef exp_interp
  EXTERN Tcl_Interp *exp_interp;
#endif

#if defined(__polyspace___fpu_control) && !defined(__polyspace_no___fpu_control)
#include <fpu_control.h>
#undef __fpu_control
  extern fpu_control_t __fpu_control;
#endif

#if defined(__polyspace_cin) && !defined(__polyspace_no_cin)
#include <g++-2/iostream.h>
#undef cin
  extern _IO_istream_withassign cin;
#endif

#if defined(__polyspace_cout) && !defined(__polyspace_no_cout)
#include <g++-2/iostream.h>
#undef cout
  extern _IO_ostream_withassign cout;
#endif

#if defined(__polyspace_cerr) && !defined(__polyspace_no_cerr)
#include <g++-2/iostream.h>
#undef cerr
  extern _IO_ostream_withassign cerr;
#endif

#if defined(__polyspace_gdbm_version) && !defined(__polyspace_no_gdbm_version)
#include <gdbm/gdbm.h>
#undef gdbm_version
  extern char *gdbm_version;
#endif

#if defined(__polyspace_gdbm_errno) && !defined(__polyspace_no_gdbm_errno)
#include <gdbm/gdbm.h>
#undef gdbm_errno
  extern gdbm_error gdbm_errno;
#endif

#if defined(__polyspace_gdFontGiant) && !defined(__polyspace_no_gdFontGiant)
#include <gdfontg.h>
#undef gdFontGiant
  extern gdFontPtr gdFontGiant;
#endif

#if defined(__polyspace_gdFontLarge) && !defined(__polyspace_no_gdFontLarge)
#include <gdfontl.h>
#undef gdFontLarge
  extern gdFontPtr gdFontLarge;
#endif

#if defined(__polyspace_gdFontMediumBold) && !defined(__polyspace_no_gdFontMediumBold)
#include <gdfontmb.h>
#undef gdFontMediumBold
  extern gdFontPtr gdFontMediumBold;
#endif

#if defined(__polyspace_gdFontSmall) && !defined(__polyspace_no_gdFontSmall)
#include <gdfonts.h>
#undef gdFontSmall
  extern gdFontPtr gdFontSmall;
#endif

#if defined(__polyspace_gdFontTiny) && !defined(__polyspace_no_gdFontTiny)
#include <gdfontt.h>
#undef gdFontTiny
  extern gdFontPtr gdFontTiny;
#endif

#if defined(__polyspace_gdk_threads_mutex) && !defined(__polyspace_no_gdk_threads_mutex)
#include <gdk/gdk.h>
#undef gdk_threads_mutex
  extern GMutex *gdk_threads_mutex;
#endif

#if defined(__polyspace_gdk_debug_level) && !defined(__polyspace_no_gdk_debug_level)
#include <gdk/gdkprivate.h>
#undef gdk_debug_level
  extern gint gdk_debug_level;
#endif

#if defined(__polyspace_gdk_show_events) && !defined(__polyspace_no_gdk_show_events)
#include <gdk/gdkprivate.h>
#undef gdk_show_events
  extern gint gdk_show_events;
#endif

#if defined(__polyspace_gdk_use_xshm) && !defined(__polyspace_no_gdk_use_xshm)
#include <gdk/gdkprivate.h>
#undef gdk_use_xshm
  extern gint gdk_use_xshm;
#endif

#if defined(__polyspace_gdk_stack_trace) && !defined(__polyspace_no_gdk_stack_trace)
#include <gdk/gdkprivate.h>
#undef gdk_stack_trace
  extern gint gdk_stack_trace;
#endif

#if defined(__polyspace_gdk_display_name) && !defined(__polyspace_no_gdk_display_name)
#include <gdk/gdkprivate.h>
#undef gdk_display_name
  extern gchar *gdk_display_name;
#endif

#if defined(__polyspace_gdk_display) && !defined(__polyspace_no_gdk_display)
#include <gdk/gdkprivate.h>
#undef gdk_display
  extern Display *gdk_display;
#endif

#if defined(__polyspace_gdk_screen) && !defined(__polyspace_no_gdk_screen)
#include <gdk/gdkprivate.h>
#undef gdk_screen
  extern gint gdk_screen;
#endif

#if defined(__polyspace_gdk_root_window) && !defined(__polyspace_no_gdk_root_window)
#include <gdk/gdkprivate.h>
#undef gdk_root_window
  extern Window gdk_root_window;
#endif

#if defined(__polyspace_gdk_leader_window) && !defined(__polyspace_no_gdk_leader_window)
#include <gdk/gdkprivate.h>
#undef gdk_leader_window
  extern Window gdk_leader_window;
#endif

#if defined(__polyspace_gdk_root_parent) && !defined(__polyspace_no_gdk_root_parent)
#include <gdk/gdkprivate.h>
#undef gdk_root_parent
  extern GdkWindowPrivate gdk_root_parent;
#endif

#if defined(__polyspace_gdk_wm_delete_window) && !defined(__polyspace_no_gdk_wm_delete_window)
#include <gdk/gdkprivate.h>
#undef gdk_wm_delete_window
  extern Atom gdk_wm_delete_window;
#endif

#if defined(__polyspace_gdk_wm_take_focus) && !defined(__polyspace_no_gdk_wm_take_focus)
#include <gdk/gdkprivate.h>
#undef gdk_wm_take_focus
  extern Atom gdk_wm_take_focus;
#endif

#if defined(__polyspace_gdk_wm_protocols) && !defined(__polyspace_no_gdk_wm_protocols)
#include <gdk/gdkprivate.h>
#undef gdk_wm_protocols
  extern Atom gdk_wm_protocols;
#endif

#if defined(__polyspace_gdk_wm_window_protocols) && !defined(__polyspace_no_gdk_wm_window_protocols)
#include <gdk/gdkprivate.h>
#undef gdk_wm_window_protocols
  extern Atom gdk_wm_window_protocols[];
#endif

#if defined(__polyspace_gdk_selection_property) && !defined(__polyspace_no_gdk_selection_property)
#include <gdk/gdkprivate.h>
#undef gdk_selection_property
  extern Atom gdk_selection_property;
#endif

#if defined(__polyspace_gdk_dnd) && !defined(__polyspace_no_gdk_dnd)
#include <gdk/gdkprivate.h>
#undef gdk_dnd
  extern GdkDndGlobals gdk_dnd;
#endif

#if defined(__polyspace_selection_owner) && !defined(__polyspace_no_selection_owner)
#include <gdk/gdkprivate.h>
#undef selection_owner
  extern GdkWindow *selection_owner[];
#endif

#if defined(__polyspace_gdk_progclass) && !defined(__polyspace_no_gdk_progclass)
#include <gdk/gdkprivate.h>
#undef gdk_progclass
  extern gchar *gdk_progclass;
#endif

#if defined(__polyspace_gdk_error_code) && !defined(__polyspace_no_gdk_error_code)
#include <gdk/gdkprivate.h>
#undef gdk_error_code
  extern gint gdk_error_code;
#endif

#if defined(__polyspace_gdk_error_warnings) && !defined(__polyspace_no_gdk_error_warnings)
#include <gdk/gdkprivate.h>
#undef gdk_error_warnings
  extern gint gdk_error_warnings;
#endif

#if defined(__polyspace_gdk_null_window_warnings) && !defined(__polyspace_no_gdk_null_window_warnings)
#include <gdk/gdkprivate.h>
#undef gdk_null_window_warnings
  extern gint    gdk_null_window_warnings;
#endif

#if defined(__polyspace_gdk_default_filters) && !defined(__polyspace_no_gdk_default_filters)
#include <gdk/gdkprivate.h>
#undef gdk_default_filters
  extern GList   *gdk_default_filters;
#endif

#if defined(__polyspace_gdk_nevent_masks) && !defined(__polyspace_no_gdk_nevent_masks)
#include <gdk/gdkprivate.h>
#undef gdk_nevent_masks
  extern const int   gdk_nevent_masks;
#endif

#if defined(__polyspace_gdk_event_mask_table) && !defined(__polyspace_no_gdk_event_mask_table)
#include <gdk/gdkprivate.h>
#undef gdk_event_mask_table
  extern const int   gdk_event_mask_table[];
#endif

#if defined(__polyspace_gdk_xgrab_window) && !defined(__polyspace_no_gdk_xgrab_window)
#include <gdk/gdkprivate.h>
#undef gdk_xgrab_window
  extern GdkWindowPrivate *gdk_xgrab_window;
#endif

#if defined(__polyspace_gdk_xim_ic) && !defined(__polyspace_no_gdk_xim_ic)
#include <gdk/gdkprivate.h>
#undef gdk_xim_ic
  extern GdkICPrivate *gdk_xim_ic;
#endif

#if defined(__polyspace_gdk_xim_window) && !defined(__polyspace_no_gdk_xim_window)
#include <gdk/gdkprivate.h>
#undef gdk_xim_window
  extern GdkWindow *gdk_xim_window;
#endif

#if defined(__polyspace_gdk_debug_flags) && !defined(__polyspace_no_gdk_debug_flags)
#include <gdk/gdkprivate.h>
#undef gdk_debug_flags
  extern guint gdk_debug_flags;
#endif

#if defined(__polyspace_optind) && !defined(__polyspace_no_optind)
#include <getopt.h>
#undef optind
  extern int optind;
#endif

#if defined(__polyspace_opterr) && !defined(__polyspace_no_opterr)
#include <getopt.h>
#undef opterr
  extern int opterr;
#endif

#if defined(__polyspace_optopt) && !defined(__polyspace_no_optopt)
#include <getopt.h>
#undef optopt
  extern int optopt;
#endif

#if defined(__polyspace_GifQuietPrint) && !defined(__polyspace_no_GifQuietPrint)
#include <gif_lib.h>
#undef GifQuietPrint
  extern int GifQuietPrint;
#endif

#if defined(__polyspace_AsciiTable) && !defined(__polyspace_no_AsciiTable)
#include <gif_lib.h>
#undef AsciiTable
  extern unsigned char AsciiTable[][GIF_FONT_WIDTH];
#endif

#if defined(__polyspace_g_log_domain_glib) && !defined(__polyspace_no_g_log_domain_glib)
#include <glib.h>
#undef g_log_domain_glib
  extern   const gchar *g_log_domain_glib;
#endif

#if defined(__polyspace_gpm_flag) && !defined(__polyspace_no_gpm_flag)
#include <gpm.h>
#undef gpm_flag
  extern int gpm_flag;
#endif

#if defined(__polyspace_gpm_ctlfd) && !defined(__polyspace_no_gpm_ctlfd)
#include <gpm.h>
#undef gpm_ctlfd
  extern int gpm_ctlfd;
#endif

#if defined(__polyspace_gpm_fd) && !defined(__polyspace_no_gpm_fd)
#include <gpm.h>
#undef gpm_fd
  extern int gpm_fd;
#endif

#if defined(__polyspace_gpm_hflag) && !defined(__polyspace_no_gpm_hflag)
#include <gpm.h>
#undef gpm_hflag
  extern int gpm_hflag;
#endif

#if defined(__polyspace_gpm_morekeys) && !defined(__polyspace_no_gpm_morekeys)
#include <gpm.h>
#undef gpm_morekeys
  extern int gpm_morekeys;
#endif

#if defined(__polyspace_gpm_zerobased) && !defined(__polyspace_no_gpm_zerobased)
#include <gpm.h>
#undef gpm_zerobased
  extern int gpm_zerobased;
#endif

#if defined(__polyspace_gpm_visiblepointer) && !defined(__polyspace_no_gpm_visiblepointer)
#include <gpm.h>
#undef gpm_visiblepointer
  extern int gpm_visiblepointer;
#endif

#if defined(__polyspace_gpm_mx) && !defined(__polyspace_no_gpm_mx)
#include <gpm.h>
#undef gpm_mx
  extern int gpm_mx;
#endif

#if defined(__polyspace_gpm_my) && !defined(__polyspace_no_gpm_my)
#include <gpm.h>
#undef gpm_my
  extern int gpm_my;
#endif

#if defined(__polyspace_gpm_timeout) && !defined(__polyspace_no_gpm_timeout)
#include <gpm.h>
#undef gpm_timeout
  extern struct timeval gpm_timeout;
#endif

#if defined(__polyspace__gpm_buf) && !defined(__polyspace_no__gpm_buf)
#include <gpm.h>
#undef _gpm_buf
  extern unsigned char _gpm_buf[];
#endif

#if defined(__polyspace__gpm_arg) && !defined(__polyspace_no__gpm_arg)
#include <gpm.h>
#undef _gpm_arg
  extern unsigned short * _gpm_arg;
#endif

#if defined(__polyspace_gpm_handler) && !defined(__polyspace_no_gpm_handler)
#include <gpm.h>
#undef gpm_handler
  extern Gpm_Handler *gpm_handler;
#endif

#if defined(__polyspace_gpm_data) && !defined(__polyspace_no_gpm_data)
#include <gpm.h>
#undef gpm_data
  extern void *gpm_data;
#endif

#if defined(__polyspace_gpm_roi_handler) && !defined(__polyspace_no_gpm_roi_handler)
#include <gpm.h>
#undef gpm_roi_handler
  extern Gpm_Handler *gpm_roi_handler;
#endif

#if defined(__polyspace_gpm_roi_data) && !defined(__polyspace_no_gpm_roi_data)
#include <gpm.h>
#undef gpm_roi_data
  extern void *gpm_roi_data;
#endif

#if defined(__polyspace_gpm_roi) && !defined(__polyspace_no_gpm_roi)
#include <gpm.h>
#undef gpm_roi
  extern Gpm_Roi *gpm_roi;
#endif

#if defined(__polyspace_gpm_current_roi) && !defined(__polyspace_no_gpm_current_roi)
#include <gpm.h>
#undef gpm_current_roi
  extern Gpm_Roi *gpm_current_roi;
#endif

#if defined(__polyspace_gpm_consolefd) && !defined(__polyspace_no_gpm_consolefd)
#include <gpm.h>
#undef gpm_consolefd
  extern int gpm_consolefd;
#endif

#if defined(__polyspace_gtk_debug_flags) && !defined(__polyspace_no_gtk_debug_flags)
#include <gtk/gtkdebug.h>
#undef gtk_debug_flags
  extern guint gtk_debug_flags;
#endif

#if defined(__polyspace_gtk_major_version) && !defined(__polyspace_no_gtk_major_version)
#include <gtk/gtkmain.h>
#undef gtk_major_version
  extern const guint gtk_major_version;
#endif

#if defined(__polyspace_gtk_minor_version) && !defined(__polyspace_no_gtk_minor_version)
#include <gtk/gtkmain.h>
#undef gtk_minor_version
  extern const guint gtk_minor_version;
#endif

#if defined(__polyspace_gtk_micro_version) && !defined(__polyspace_no_gtk_micro_version)
#include <gtk/gtkmain.h>
#undef gtk_micro_version
  extern const guint gtk_micro_version;
#endif

#if defined(__polyspace_gtk_binary_age) && !defined(__polyspace_no_gtk_binary_age)
#include <gtk/gtkmain.h>
#undef gtk_binary_age
  extern const guint gtk_binary_age;
#endif

#if defined(__polyspace_gtk_interface_age) && !defined(__polyspace_no_gtk_interface_age)
#include <gtk/gtkmain.h>
#undef gtk_interface_age
  extern const guint gtk_interface_age;
#endif

#if defined(__polyspace_GTK_TYPE_ACCEL_FLAGS) && !defined(__polyspace_no_GTK_TYPE_ACCEL_FLAGS)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_ACCEL_FLAGS
  extern GtkType GTK_TYPE_ACCEL_FLAGS;
#endif

#if defined(__polyspace_GTK_TYPE_CALENDAR_DISPLAY_OPTIONS) && !defined(__polyspace_no_GTK_TYPE_CALENDAR_DISPLAY_OPTIONS)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_CALENDAR_DISPLAY_OPTIONS
  extern GtkType GTK_TYPE_CALENDAR_DISPLAY_OPTIONS;
#endif

#if defined(__polyspace_GTK_TYPE_CELL_TYPE) && !defined(__polyspace_no_GTK_TYPE_CELL_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_CELL_TYPE
  extern GtkType GTK_TYPE_CELL_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_CLIST_DRAG_POS) && !defined(__polyspace_no_GTK_TYPE_CLIST_DRAG_POS)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_CLIST_DRAG_POS
  extern GtkType GTK_TYPE_CLIST_DRAG_POS;
#endif

#if defined(__polyspace_GTK_TYPE_BUTTON_ACTION) && !defined(__polyspace_no_GTK_TYPE_BUTTON_ACTION)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_BUTTON_ACTION
  extern GtkType GTK_TYPE_BUTTON_ACTION;
#endif

#if defined(__polyspace_GTK_TYPE_CTREE_POS) && !defined(__polyspace_no_GTK_TYPE_CTREE_POS)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_CTREE_POS
  extern GtkType GTK_TYPE_CTREE_POS;
#endif

#if defined(__polyspace_GTK_TYPE_CTREE_LINE_STYLE) && !defined(__polyspace_no_GTK_TYPE_CTREE_LINE_STYLE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_CTREE_LINE_STYLE
  extern GtkType GTK_TYPE_CTREE_LINE_STYLE;
#endif

#if defined(__polyspace_GTK_TYPE_CTREE_EXPANDER_STYLE) && !defined(__polyspace_no_GTK_TYPE_CTREE_EXPANDER_STYLE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_CTREE_EXPANDER_STYLE
  extern GtkType GTK_TYPE_CTREE_EXPANDER_STYLE;
#endif

#if defined(__polyspace_GTK_TYPE_CTREE_EXPANSION_TYPE) && !defined(__polyspace_no_GTK_TYPE_CTREE_EXPANSION_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_CTREE_EXPANSION_TYPE
  extern GtkType GTK_TYPE_CTREE_EXPANSION_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_DEBUG_FLAG) && !defined(__polyspace_no_GTK_TYPE_DEBUG_FLAG)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_DEBUG_FLAG
  extern GtkType GTK_TYPE_DEBUG_FLAG;
#endif

#if defined(__polyspace_GTK_TYPE_DEST_DEFAULTS) && !defined(__polyspace_no_GTK_TYPE_DEST_DEFAULTS)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_DEST_DEFAULTS
  extern GtkType GTK_TYPE_DEST_DEFAULTS;
#endif

#if defined(__polyspace_GTK_TYPE_TARGET_FLAGS) && !defined(__polyspace_no_GTK_TYPE_TARGET_FLAGS)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_TARGET_FLAGS
  extern GtkType GTK_TYPE_TARGET_FLAGS;
#endif

#if defined(__polyspace_GTK_TYPE_ARROW_TYPE) && !defined(__polyspace_no_GTK_TYPE_ARROW_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_ARROW_TYPE
  extern GtkType GTK_TYPE_ARROW_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_ATTACH_OPTIONS) && !defined(__polyspace_no_GTK_TYPE_ATTACH_OPTIONS)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_ATTACH_OPTIONS
  extern GtkType GTK_TYPE_ATTACH_OPTIONS;
#endif

#if defined(__polyspace_GTK_TYPE_BUTTON_BOX_STYLE) && !defined(__polyspace_no_GTK_TYPE_BUTTON_BOX_STYLE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_BUTTON_BOX_STYLE
  extern GtkType GTK_TYPE_BUTTON_BOX_STYLE;
#endif

#if defined(__polyspace_GTK_TYPE_CURVE_TYPE) && !defined(__polyspace_no_GTK_TYPE_CURVE_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_CURVE_TYPE
  extern GtkType GTK_TYPE_CURVE_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_DIRECTION_TYPE) && !defined(__polyspace_no_GTK_TYPE_DIRECTION_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_DIRECTION_TYPE
  extern GtkType GTK_TYPE_DIRECTION_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_JUSTIFICATION) && !defined(__polyspace_no_GTK_TYPE_JUSTIFICATION)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_JUSTIFICATION
  extern GtkType GTK_TYPE_JUSTIFICATION;
#endif

#if defined(__polyspace_GTK_TYPE_MATCH_TYPE) && !defined(__polyspace_no_GTK_TYPE_MATCH_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_MATCH_TYPE
  extern GtkType GTK_TYPE_MATCH_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_MENU_DIRECTION_TYPE) && !defined(__polyspace_no_GTK_TYPE_MENU_DIRECTION_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_MENU_DIRECTION_TYPE
  extern GtkType GTK_TYPE_MENU_DIRECTION_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_MENU_FACTORY_TYPE) && !defined(__polyspace_no_GTK_TYPE_MENU_FACTORY_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_MENU_FACTORY_TYPE
  extern GtkType GTK_TYPE_MENU_FACTORY_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_METRIC_TYPE) && !defined(__polyspace_no_GTK_TYPE_METRIC_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_METRIC_TYPE
  extern GtkType GTK_TYPE_METRIC_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_ORIENTATION) && !defined(__polyspace_no_GTK_TYPE_ORIENTATION)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_ORIENTATION
  extern GtkType GTK_TYPE_ORIENTATION;
#endif

#if defined(__polyspace_GTK_TYPE_CORNER_TYPE) && !defined(__polyspace_no_GTK_TYPE_CORNER_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_CORNER_TYPE
  extern GtkType GTK_TYPE_CORNER_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_PACK_TYPE) && !defined(__polyspace_no_GTK_TYPE_PACK_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_PACK_TYPE
  extern GtkType GTK_TYPE_PACK_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_PATH_PRIORITY_TYPE) && !defined(__polyspace_no_GTK_TYPE_PATH_PRIORITY_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_PATH_PRIORITY_TYPE
  extern GtkType GTK_TYPE_PATH_PRIORITY_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_PATH_TYPE) && !defined(__polyspace_no_GTK_TYPE_PATH_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_PATH_TYPE
  extern GtkType GTK_TYPE_PATH_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_POLICY_TYPE) && !defined(__polyspace_no_GTK_TYPE_POLICY_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_POLICY_TYPE
  extern GtkType GTK_TYPE_POLICY_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_POSITION_TYPE) && !defined(__polyspace_no_GTK_TYPE_POSITION_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_POSITION_TYPE
  extern GtkType GTK_TYPE_POSITION_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_PREVIEW_TYPE) && !defined(__polyspace_no_GTK_TYPE_PREVIEW_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_PREVIEW_TYPE
  extern GtkType GTK_TYPE_PREVIEW_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_RELIEF_STYLE) && !defined(__polyspace_no_GTK_TYPE_RELIEF_STYLE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_RELIEF_STYLE
  extern GtkType GTK_TYPE_RELIEF_STYLE;
#endif

#if defined(__polyspace_GTK_TYPE_RESIZE_MODE) && !defined(__polyspace_no_GTK_TYPE_RESIZE_MODE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_RESIZE_MODE
  extern GtkType GTK_TYPE_RESIZE_MODE;
#endif

#if defined(__polyspace_GTK_TYPE_SIGNAL_RUN_TYPE) && !defined(__polyspace_no_GTK_TYPE_SIGNAL_RUN_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_SIGNAL_RUN_TYPE
  extern GtkType GTK_TYPE_SIGNAL_RUN_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_SCROLL_TYPE) && !defined(__polyspace_no_GTK_TYPE_SCROLL_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_SCROLL_TYPE
  extern GtkType GTK_TYPE_SCROLL_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_SELECTION_MODE) && !defined(__polyspace_no_GTK_TYPE_SELECTION_MODE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_SELECTION_MODE
  extern GtkType GTK_TYPE_SELECTION_MODE;
#endif

#if defined(__polyspace_GTK_TYPE_SHADOW_TYPE) && !defined(__polyspace_no_GTK_TYPE_SHADOW_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_SHADOW_TYPE
  extern GtkType GTK_TYPE_SHADOW_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_STATE_TYPE) && !defined(__polyspace_no_GTK_TYPE_STATE_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_STATE_TYPE
  extern GtkType GTK_TYPE_STATE_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_SUBMENU_DIRECTION) && !defined(__polyspace_no_GTK_TYPE_SUBMENU_DIRECTION)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_SUBMENU_DIRECTION
  extern GtkType GTK_TYPE_SUBMENU_DIRECTION;
#endif

#if defined(__polyspace_GTK_TYPE_SUBMENU_PLACEMENT) && !defined(__polyspace_no_GTK_TYPE_SUBMENU_PLACEMENT)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_SUBMENU_PLACEMENT
  extern GtkType GTK_TYPE_SUBMENU_PLACEMENT;
#endif

#if defined(__polyspace_GTK_TYPE_TOOLBAR_STYLE) && !defined(__polyspace_no_GTK_TYPE_TOOLBAR_STYLE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_TOOLBAR_STYLE
  extern GtkType GTK_TYPE_TOOLBAR_STYLE;
#endif

#if defined(__polyspace_GTK_TYPE_TROUGH_TYPE) && !defined(__polyspace_no_GTK_TYPE_TROUGH_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_TROUGH_TYPE
  extern GtkType GTK_TYPE_TROUGH_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_UPDATE_TYPE) && !defined(__polyspace_no_GTK_TYPE_UPDATE_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_UPDATE_TYPE
  extern GtkType GTK_TYPE_UPDATE_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_VISIBILITY) && !defined(__polyspace_no_GTK_TYPE_VISIBILITY)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_VISIBILITY
  extern GtkType GTK_TYPE_VISIBILITY;
#endif

#if defined(__polyspace_GTK_TYPE_WINDOW_POSITION) && !defined(__polyspace_no_GTK_TYPE_WINDOW_POSITION)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_WINDOW_POSITION
  extern GtkType GTK_TYPE_WINDOW_POSITION;
#endif

#if defined(__polyspace_GTK_TYPE_WINDOW_TYPE) && !defined(__polyspace_no_GTK_TYPE_WINDOW_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_WINDOW_TYPE
  extern GtkType GTK_TYPE_WINDOW_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_SORT_TYPE) && !defined(__polyspace_no_GTK_TYPE_SORT_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_SORT_TYPE
  extern GtkType GTK_TYPE_SORT_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_FONT_METRIC_TYPE) && !defined(__polyspace_no_GTK_TYPE_FONT_METRIC_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_FONT_METRIC_TYPE
  extern GtkType GTK_TYPE_FONT_METRIC_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_FONT_TYPE) && !defined(__polyspace_no_GTK_TYPE_FONT_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_FONT_TYPE
  extern GtkType GTK_TYPE_FONT_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_FONT_FILTER_TYPE) && !defined(__polyspace_no_GTK_TYPE_FONT_FILTER_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_FONT_FILTER_TYPE
  extern GtkType GTK_TYPE_FONT_FILTER_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_OBJECT_FLAGS) && !defined(__polyspace_no_GTK_TYPE_OBJECT_FLAGS)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_OBJECT_FLAGS
  extern GtkType GTK_TYPE_OBJECT_FLAGS;
#endif

#if defined(__polyspace_GTK_TYPE_ARG_FLAGS) && !defined(__polyspace_no_GTK_TYPE_ARG_FLAGS)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_ARG_FLAGS
  extern GtkType GTK_TYPE_ARG_FLAGS;
#endif

#if defined(__polyspace_GTK_TYPE_PACKER_OPTIONS) && !defined(__polyspace_no_GTK_TYPE_PACKER_OPTIONS)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_PACKER_OPTIONS
  extern GtkType GTK_TYPE_PACKER_OPTIONS;
#endif

#if defined(__polyspace_GTK_TYPE_SIDE_TYPE) && !defined(__polyspace_no_GTK_TYPE_SIDE_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_SIDE_TYPE
  extern GtkType GTK_TYPE_SIDE_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_ANCHOR_TYPE) && !defined(__polyspace_no_GTK_TYPE_ANCHOR_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_ANCHOR_TYPE
  extern GtkType GTK_TYPE_ANCHOR_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_PRIVATE_FLAGS) && !defined(__polyspace_no_GTK_TYPE_PRIVATE_FLAGS)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_PRIVATE_FLAGS
  extern GtkType GTK_TYPE_PRIVATE_FLAGS;
#endif

#if defined(__polyspace_GTK_TYPE_PROGRESS_BAR_STYLE) && !defined(__polyspace_no_GTK_TYPE_PROGRESS_BAR_STYLE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_PROGRESS_BAR_STYLE
  extern GtkType GTK_TYPE_PROGRESS_BAR_STYLE;
#endif

#if defined(__polyspace_GTK_TYPE_PROGRESS_BAR_ORIENTATION) && !defined(__polyspace_no_GTK_TYPE_PROGRESS_BAR_ORIENTATION)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_PROGRESS_BAR_ORIENTATION
  extern GtkType GTK_TYPE_PROGRESS_BAR_ORIENTATION;
#endif

#if defined(__polyspace_GTK_TYPE_RC_FLAGS) && !defined(__polyspace_no_GTK_TYPE_RC_FLAGS)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_RC_FLAGS
  extern GtkType GTK_TYPE_RC_FLAGS;
#endif

#if defined(__polyspace_GTK_TYPE_RC_TOKEN_TYPE) && !defined(__polyspace_no_GTK_TYPE_RC_TOKEN_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_RC_TOKEN_TYPE
  extern GtkType GTK_TYPE_RC_TOKEN_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_SPIN_BUTTON_UPDATE_POLICY) && !defined(__polyspace_no_GTK_TYPE_SPIN_BUTTON_UPDATE_POLICY)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_SPIN_BUTTON_UPDATE_POLICY
  extern GtkType GTK_TYPE_SPIN_BUTTON_UPDATE_POLICY;
#endif

#if defined(__polyspace_GTK_TYPE_SPIN_TYPE) && !defined(__polyspace_no_GTK_TYPE_SPIN_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_SPIN_TYPE
  extern GtkType GTK_TYPE_SPIN_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_TOOLBAR_CHILD_TYPE) && !defined(__polyspace_no_GTK_TYPE_TOOLBAR_CHILD_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_TOOLBAR_CHILD_TYPE
  extern GtkType GTK_TYPE_TOOLBAR_CHILD_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_TOOLBAR_SPACE_STYLE) && !defined(__polyspace_no_GTK_TYPE_TOOLBAR_SPACE_STYLE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_TOOLBAR_SPACE_STYLE
  extern GtkType GTK_TYPE_TOOLBAR_SPACE_STYLE;
#endif

#if defined(__polyspace_GTK_TYPE_TREE_VIEW_MODE) && !defined(__polyspace_no_GTK_TYPE_TREE_VIEW_MODE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_TREE_VIEW_MODE
  extern GtkType GTK_TYPE_TREE_VIEW_MODE;
#endif

#if defined(__polyspace_GTK_TYPE_FUNDAMENTAL_TYPE) && !defined(__polyspace_no_GTK_TYPE_FUNDAMENTAL_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_FUNDAMENTAL_TYPE
  extern GtkType GTK_TYPE_FUNDAMENTAL_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_WIDGET_FLAGS) && !defined(__polyspace_no_GTK_TYPE_WIDGET_FLAGS)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_WIDGET_FLAGS
  extern GtkType GTK_TYPE_WIDGET_FLAGS;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_WINDOW_TYPE) && !defined(__polyspace_no_GTK_TYPE_GDK_WINDOW_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_WINDOW_TYPE
  extern GtkType GTK_TYPE_GDK_WINDOW_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_WINDOW_CLASS) && !defined(__polyspace_no_GTK_TYPE_GDK_WINDOW_CLASS)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_WINDOW_CLASS
  extern GtkType GTK_TYPE_GDK_WINDOW_CLASS;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_IMAGE_TYPE) && !defined(__polyspace_no_GTK_TYPE_GDK_IMAGE_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_IMAGE_TYPE
  extern GtkType GTK_TYPE_GDK_IMAGE_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_VISUAL_TYPE) && !defined(__polyspace_no_GTK_TYPE_GDK_VISUAL_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_VISUAL_TYPE
  extern GtkType GTK_TYPE_GDK_VISUAL_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_FONT_TYPE) && !defined(__polyspace_no_GTK_TYPE_GDK_FONT_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_FONT_TYPE
  extern GtkType GTK_TYPE_GDK_FONT_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_WINDOW_ATTRIBUTES_TYPE) && !defined(__polyspace_no_GTK_TYPE_GDK_WINDOW_ATTRIBUTES_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_WINDOW_ATTRIBUTES_TYPE
  extern GtkType GTK_TYPE_GDK_WINDOW_ATTRIBUTES_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_WINDOW_HINTS) && !defined(__polyspace_no_GTK_TYPE_GDK_WINDOW_HINTS)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_WINDOW_HINTS
  extern GtkType GTK_TYPE_GDK_WINDOW_HINTS;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_FUNCTION) && !defined(__polyspace_no_GTK_TYPE_GDK_FUNCTION)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_FUNCTION
  extern GtkType GTK_TYPE_GDK_FUNCTION;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_FILL) && !defined(__polyspace_no_GTK_TYPE_GDK_FILL)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_FILL
  extern GtkType GTK_TYPE_GDK_FILL;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_FILL_RULE) && !defined(__polyspace_no_GTK_TYPE_GDK_FILL_RULE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_FILL_RULE
  extern GtkType GTK_TYPE_GDK_FILL_RULE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_LINE_STYLE) && !defined(__polyspace_no_GTK_TYPE_GDK_LINE_STYLE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_LINE_STYLE
  extern GtkType GTK_TYPE_GDK_LINE_STYLE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_CAP_STYLE) && !defined(__polyspace_no_GTK_TYPE_GDK_CAP_STYLE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_CAP_STYLE
  extern GtkType GTK_TYPE_GDK_CAP_STYLE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_JOIN_STYLE) && !defined(__polyspace_no_GTK_TYPE_GDK_JOIN_STYLE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_JOIN_STYLE
  extern GtkType GTK_TYPE_GDK_JOIN_STYLE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_CURSOR_TYPE) && !defined(__polyspace_no_GTK_TYPE_GDK_CURSOR_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_CURSOR_TYPE
  extern GtkType GTK_TYPE_GDK_CURSOR_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_FILTER_RETURN) && !defined(__polyspace_no_GTK_TYPE_GDK_FILTER_RETURN)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_FILTER_RETURN
  extern GtkType GTK_TYPE_GDK_FILTER_RETURN;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_VISIBILITY_STATE) && !defined(__polyspace_no_GTK_TYPE_GDK_VISIBILITY_STATE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_VISIBILITY_STATE
  extern GtkType GTK_TYPE_GDK_VISIBILITY_STATE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_EVENT_TYPE) && !defined(__polyspace_no_GTK_TYPE_GDK_EVENT_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_EVENT_TYPE
  extern GtkType GTK_TYPE_GDK_EVENT_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_EVENT_MASK) && !defined(__polyspace_no_GTK_TYPE_GDK_EVENT_MASK)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_EVENT_MASK
  extern GtkType GTK_TYPE_GDK_EVENT_MASK;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_NOTIFY_TYPE) && !defined(__polyspace_no_GTK_TYPE_GDK_NOTIFY_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_NOTIFY_TYPE
  extern GtkType GTK_TYPE_GDK_NOTIFY_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_CROSSING_MODE) && !defined(__polyspace_no_GTK_TYPE_GDK_CROSSING_MODE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_CROSSING_MODE
  extern GtkType GTK_TYPE_GDK_CROSSING_MODE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_MODIFIER_TYPE) && !defined(__polyspace_no_GTK_TYPE_GDK_MODIFIER_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_MODIFIER_TYPE
  extern GtkType GTK_TYPE_GDK_MODIFIER_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_SUBWINDOW_MODE) && !defined(__polyspace_no_GTK_TYPE_GDK_SUBWINDOW_MODE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_SUBWINDOW_MODE
  extern GtkType GTK_TYPE_GDK_SUBWINDOW_MODE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_INPUT_CONDITION) && !defined(__polyspace_no_GTK_TYPE_GDK_INPUT_CONDITION)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_INPUT_CONDITION
  extern GtkType GTK_TYPE_GDK_INPUT_CONDITION;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_STATUS) && !defined(__polyspace_no_GTK_TYPE_GDK_STATUS)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_STATUS
  extern GtkType GTK_TYPE_GDK_STATUS;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_BYTE_ORDER) && !defined(__polyspace_no_GTK_TYPE_GDK_BYTE_ORDER)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_BYTE_ORDER
  extern GtkType GTK_TYPE_GDK_BYTE_ORDER;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_GC_VALUES_MASK) && !defined(__polyspace_no_GTK_TYPE_GDK_GC_VALUES_MASK)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_GC_VALUES_MASK
  extern GtkType GTK_TYPE_GDK_GC_VALUES_MASK;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_SELECTION) && !defined(__polyspace_no_GTK_TYPE_GDK_SELECTION)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_SELECTION
  extern GtkType GTK_TYPE_GDK_SELECTION;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_PROPERTY_STATE) && !defined(__polyspace_no_GTK_TYPE_GDK_PROPERTY_STATE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_PROPERTY_STATE
  extern GtkType GTK_TYPE_GDK_PROPERTY_STATE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_PROP_MODE) && !defined(__polyspace_no_GTK_TYPE_GDK_PROP_MODE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_PROP_MODE
  extern GtkType GTK_TYPE_GDK_PROP_MODE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_INPUT_SOURCE) && !defined(__polyspace_no_GTK_TYPE_GDK_INPUT_SOURCE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_INPUT_SOURCE
  extern GtkType GTK_TYPE_GDK_INPUT_SOURCE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_INPUT_MODE) && !defined(__polyspace_no_GTK_TYPE_GDK_INPUT_MODE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_INPUT_MODE
  extern GtkType GTK_TYPE_GDK_INPUT_MODE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_AXIS_USE) && !defined(__polyspace_no_GTK_TYPE_GDK_AXIS_USE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_AXIS_USE
  extern GtkType GTK_TYPE_GDK_AXIS_USE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_TARGET) && !defined(__polyspace_no_GTK_TYPE_GDK_TARGET)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_TARGET
  extern GtkType GTK_TYPE_GDK_TARGET;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_SELECTION_TYPE) && !defined(__polyspace_no_GTK_TYPE_GDK_SELECTION_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_SELECTION_TYPE
  extern GtkType GTK_TYPE_GDK_SELECTION_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_EXTENSION_MODE) && !defined(__polyspace_no_GTK_TYPE_GDK_EXTENSION_MODE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_EXTENSION_MODE
  extern GtkType GTK_TYPE_GDK_EXTENSION_MODE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_IM_STYLE) && !defined(__polyspace_no_GTK_TYPE_GDK_IM_STYLE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_IM_STYLE
  extern GtkType GTK_TYPE_GDK_IM_STYLE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_IC_ATTRIBUTES_TYPE) && !defined(__polyspace_no_GTK_TYPE_GDK_IC_ATTRIBUTES_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_IC_ATTRIBUTES_TYPE
  extern GtkType GTK_TYPE_GDK_IC_ATTRIBUTES_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_WM_DECORATION) && !defined(__polyspace_no_GTK_TYPE_GDK_WM_DECORATION)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_WM_DECORATION
  extern GtkType GTK_TYPE_GDK_WM_DECORATION;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_WM_FUNCTION) && !defined(__polyspace_no_GTK_TYPE_GDK_WM_FUNCTION)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_WM_FUNCTION
  extern GtkType GTK_TYPE_GDK_WM_FUNCTION;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_COLOR_CONTEXT_MODE) && !defined(__polyspace_no_GTK_TYPE_GDK_COLOR_CONTEXT_MODE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_COLOR_CONTEXT_MODE
  extern GtkType GTK_TYPE_GDK_COLOR_CONTEXT_MODE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_OVERLAP_TYPE) && !defined(__polyspace_no_GTK_TYPE_GDK_OVERLAP_TYPE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_OVERLAP_TYPE
  extern GtkType GTK_TYPE_GDK_OVERLAP_TYPE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_DRAG_ACTION) && !defined(__polyspace_no_GTK_TYPE_GDK_DRAG_ACTION)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_DRAG_ACTION
  extern GtkType GTK_TYPE_GDK_DRAG_ACTION;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_DRAG_PROTOCOL) && !defined(__polyspace_no_GTK_TYPE_GDK_DRAG_PROTOCOL)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_DRAG_PROTOCOL
  extern GtkType GTK_TYPE_GDK_DRAG_PROTOCOL;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_RGB_DITHER) && !defined(__polyspace_no_GTK_TYPE_GDK_RGB_DITHER)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_RGB_DITHER
  extern GtkType GTK_TYPE_GDK_RGB_DITHER;
#endif

#if defined(__polyspace_GTK_TYPE_ACCEL_GROUP) && !defined(__polyspace_no_GTK_TYPE_ACCEL_GROUP)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_ACCEL_GROUP
  extern GtkType GTK_TYPE_ACCEL_GROUP;
#endif

#if defined(__polyspace_GTK_TYPE_SELECTION_DATA) && !defined(__polyspace_no_GTK_TYPE_SELECTION_DATA)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_SELECTION_DATA
  extern GtkType GTK_TYPE_SELECTION_DATA;
#endif

#if defined(__polyspace_GTK_TYPE_STYLE) && !defined(__polyspace_no_GTK_TYPE_STYLE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_STYLE
  extern GtkType GTK_TYPE_STYLE;
#endif

#if defined(__polyspace_GTK_TYPE_CTREE_NODE) && !defined(__polyspace_no_GTK_TYPE_CTREE_NODE)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_CTREE_NODE
  extern GtkType GTK_TYPE_CTREE_NODE;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_COLORMAP) && !defined(__polyspace_no_GTK_TYPE_GDK_COLORMAP)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_COLORMAP
  extern GtkType GTK_TYPE_GDK_COLORMAP;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_VISUAL) && !defined(__polyspace_no_GTK_TYPE_GDK_VISUAL)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_VISUAL
  extern GtkType GTK_TYPE_GDK_VISUAL;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_FONT) && !defined(__polyspace_no_GTK_TYPE_GDK_FONT)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_FONT
  extern GtkType GTK_TYPE_GDK_FONT;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_WINDOW) && !defined(__polyspace_no_GTK_TYPE_GDK_WINDOW)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_WINDOW
  extern GtkType GTK_TYPE_GDK_WINDOW;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_DRAG_CONTEXT) && !defined(__polyspace_no_GTK_TYPE_GDK_DRAG_CONTEXT)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_DRAG_CONTEXT
  extern GtkType GTK_TYPE_GDK_DRAG_CONTEXT;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_EVENT) && !defined(__polyspace_no_GTK_TYPE_GDK_EVENT)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_EVENT
  extern GtkType GTK_TYPE_GDK_EVENT;
#endif

#if defined(__polyspace_GTK_TYPE_GDK_COLOR) && !defined(__polyspace_no_GTK_TYPE_GDK_COLOR)
#include <gtk/gtktypebuiltins.h>
#undef GTK_TYPE_GDK_COLOR
  extern GtkType GTK_TYPE_GDK_COLOR;
#endif

#if defined(__polyspace_js_latin1_tolower) && !defined(__polyspace_no_js_latin1_tolower)
#include <jsint.h>
#undef js_latin1_tolower
  extern unsigned char js_latin1_tolower[256];
#endif

#if defined(__polyspace_js_latin1_toupper) && !defined(__polyspace_no_js_latin1_toupper)
#include <jsint.h>
#undef js_latin1_toupper
  extern unsigned char js_latin1_toupper[256];
#endif

#if defined(__polyspace_js_compiler_bytecode) && !defined(__polyspace_no_js_compiler_bytecode)
#include <jsint.h>
#undef js_compiler_bytecode
  extern unsigned char js_compiler_bytecode[];
#endif

#if defined(__polyspace_js_compiler_bytecode_len) && !defined(__polyspace_no_js_compiler_bytecode_len)
#include <jsint.h>
#undef js_compiler_bytecode_len
  extern unsigned int js_compiler_bytecode_len;
#endif

#if defined(__polyspace_KKeys) && !defined(__polyspace_no_KKeys)
#include <kde/kckey.h>
#undef KKeys
  extern KKey KKeys[NB_KEYS];
#endif

#if defined(__polyspace_theKProcessController) && !defined(__polyspace_no_theKProcessController)
#include <kde/kprocctrl.h>
#undef theKProcessController
  extern KProcessController *theKProcessController;
#endif

#if defined(__polyspace_lam_mpi_comm_world) && !defined(__polyspace_no_lam_mpi_comm_world)
#include <lam/mpi.h>
#undef lam_mpi_comm_world
  extern struct _comm lam_mpi_comm_world;
#endif

#if defined(__polyspace_lam_mpi_comm_self) && !defined(__polyspace_no_lam_mpi_comm_self)
#include <lam/mpi.h>
#undef lam_mpi_comm_self
  extern struct _comm lam_mpi_comm_self;
#endif

#if defined(__polyspace_lam_mpi_group_empty) && !defined(__polyspace_no_lam_mpi_group_empty)
#include <lam/mpi.h>
#undef lam_mpi_group_empty
  extern struct _group lam_mpi_group_empty;
#endif

#if defined(__polyspace_lam_mpi_max) && !defined(__polyspace_no_lam_mpi_max)
#include <lam/mpi.h>
#undef lam_mpi_max
  extern struct _op lam_mpi_max;
#endif

#if defined(__polyspace_lam_mpi_min) && !defined(__polyspace_no_lam_mpi_min)
#include <lam/mpi.h>
#undef lam_mpi_min
  extern struct _op lam_mpi_min;
#endif

#if defined(__polyspace_lam_mpi_sum) && !defined(__polyspace_no_lam_mpi_sum)
#include <lam/mpi.h>
#undef lam_mpi_sum
  extern struct _op lam_mpi_sum;
#endif

#if defined(__polyspace_lam_mpi_prod) && !defined(__polyspace_no_lam_mpi_prod)
#include <lam/mpi.h>
#undef lam_mpi_prod
  extern struct _op lam_mpi_prod;
#endif

#if defined(__polyspace_lam_mpi_land) && !defined(__polyspace_no_lam_mpi_land)
#include <lam/mpi.h>
#undef lam_mpi_land
  extern struct _op lam_mpi_land;
#endif

#if defined(__polyspace_lam_mpi_band) && !defined(__polyspace_no_lam_mpi_band)
#include <lam/mpi.h>
#undef lam_mpi_band
  extern struct _op lam_mpi_band;
#endif

#if defined(__polyspace_lam_mpi_lor) && !defined(__polyspace_no_lam_mpi_lor)
#include <lam/mpi.h>
#undef lam_mpi_lor
  extern struct _op lam_mpi_lor;
#endif

#if defined(__polyspace_lam_mpi_bor) && !defined(__polyspace_no_lam_mpi_bor)
#include <lam/mpi.h>
#undef lam_mpi_bor
  extern struct _op lam_mpi_bor;
#endif

#if defined(__polyspace_lam_mpi_lxor) && !defined(__polyspace_no_lam_mpi_lxor)
#include <lam/mpi.h>
#undef lam_mpi_lxor
  extern struct _op lam_mpi_lxor;
#endif

#if defined(__polyspace_lam_mpi_bxor) && !defined(__polyspace_no_lam_mpi_bxor)
#include <lam/mpi.h>
#undef lam_mpi_bxor
  extern struct _op lam_mpi_bxor;
#endif

#if defined(__polyspace_lam_mpi_maxloc) && !defined(__polyspace_no_lam_mpi_maxloc)
#include <lam/mpi.h>
#undef lam_mpi_maxloc
  extern struct _op lam_mpi_maxloc;
#endif

#if defined(__polyspace_lam_mpi_minloc) && !defined(__polyspace_no_lam_mpi_minloc)
#include <lam/mpi.h>
#undef lam_mpi_minloc
  extern struct _op lam_mpi_minloc;
#endif

#if defined(__polyspace_lam_mpi_replace) && !defined(__polyspace_no_lam_mpi_replace)
#include <lam/mpi.h>
#undef lam_mpi_replace
  extern struct _op lam_mpi_replace;
#endif

#if defined(__polyspace_lam_mpi_char) && !defined(__polyspace_no_lam_mpi_char)
#include <lam/mpi.h>
#undef lam_mpi_char
  extern struct _dtype lam_mpi_char;
#endif

#if defined(__polyspace_lam_mpi_byte) && !defined(__polyspace_no_lam_mpi_byte)
#include <lam/mpi.h>
#undef lam_mpi_byte
  extern struct _dtype lam_mpi_byte;
#endif

#if defined(__polyspace_lam_mpi_int) && !defined(__polyspace_no_lam_mpi_int)
#include <lam/mpi.h>
#undef lam_mpi_int
  extern struct _dtype lam_mpi_int;
#endif

#if defined(__polyspace_lam_mpi_logic) && !defined(__polyspace_no_lam_mpi_logic)
#include <lam/mpi.h>
#undef lam_mpi_logic
  extern struct _dtype lam_mpi_logic;
#endif

#if defined(__polyspace_lam_mpi_short) && !defined(__polyspace_no_lam_mpi_short)
#include <lam/mpi.h>
#undef lam_mpi_short
  extern struct _dtype lam_mpi_short;
#endif

#if defined(__polyspace_lam_mpi_long) && !defined(__polyspace_no_lam_mpi_long)
#include <lam/mpi.h>
#undef lam_mpi_long
  extern struct _dtype lam_mpi_long;
#endif

#if defined(__polyspace_lam_mpi_float) && !defined(__polyspace_no_lam_mpi_float)
#include <lam/mpi.h>
#undef lam_mpi_float
  extern struct _dtype lam_mpi_float;
#endif

#if defined(__polyspace_lam_mpi_double) && !defined(__polyspace_no_lam_mpi_double)
#include <lam/mpi.h>
#undef lam_mpi_double
  extern struct _dtype lam_mpi_double;
#endif

#if defined(__polyspace_lam_mpi_long_double) && !defined(__polyspace_no_lam_mpi_long_double)
#include <lam/mpi.h>
#undef lam_mpi_long_double
  extern struct _dtype lam_mpi_long_double;
#endif

#if defined(__polyspace_lam_mpi_cplex) && !defined(__polyspace_no_lam_mpi_cplex)
#include <lam/mpi.h>
#undef lam_mpi_cplex
  extern struct _dtype lam_mpi_cplex;
#endif

#if defined(__polyspace_lam_mpi_packed) && !defined(__polyspace_no_lam_mpi_packed)
#include <lam/mpi.h>
#undef lam_mpi_packed
  extern struct _dtype lam_mpi_packed;
#endif

#if defined(__polyspace_lam_mpi_unsigned_char) && !defined(__polyspace_no_lam_mpi_unsigned_char)
#include <lam/mpi.h>
#undef lam_mpi_unsigned_char
  extern struct _dtype lam_mpi_unsigned_char;
#endif

#if defined(__polyspace_lam_mpi_unsigned_short) && !defined(__polyspace_no_lam_mpi_unsigned_short)
#include <lam/mpi.h>
#undef lam_mpi_unsigned_short
  extern struct _dtype lam_mpi_unsigned_short;
#endif

#if defined(__polyspace_lam_mpi_unsigned) && !defined(__polyspace_no_lam_mpi_unsigned)
#include <lam/mpi.h>
#undef lam_mpi_unsigned
  extern struct _dtype lam_mpi_unsigned;
#endif

#if defined(__polyspace_lam_mpi_unsigned_long) && !defined(__polyspace_no_lam_mpi_unsigned_long)
#include <lam/mpi.h>
#undef lam_mpi_unsigned_long
  extern struct _dtype lam_mpi_unsigned_long;
#endif

#if defined(__polyspace_lam_mpi_ub) && !defined(__polyspace_no_lam_mpi_ub)
#include <lam/mpi.h>
#undef lam_mpi_ub
  extern struct _dtype lam_mpi_ub;
#endif

#if defined(__polyspace_lam_mpi_lb) && !defined(__polyspace_no_lam_mpi_lb)
#include <lam/mpi.h>
#undef lam_mpi_lb
  extern struct _dtype lam_mpi_lb;
#endif

#if defined(__polyspace_lam_mpi_float_int) && !defined(__polyspace_no_lam_mpi_float_int)
#include <lam/mpi.h>
#undef lam_mpi_float_int
  extern struct _dtype lam_mpi_float_int;
#endif

#if defined(__polyspace_lam_mpi_double_int) && !defined(__polyspace_no_lam_mpi_double_int)
#include <lam/mpi.h>
#undef lam_mpi_double_int
  extern struct _dtype lam_mpi_double_int;
#endif

#if defined(__polyspace_lam_mpi_long_int) && !defined(__polyspace_no_lam_mpi_long_int)
#include <lam/mpi.h>
#undef lam_mpi_long_int
  extern struct _dtype lam_mpi_long_int;
#endif

#if defined(__polyspace_lam_mpi_2int) && !defined(__polyspace_no_lam_mpi_2int)
#include <lam/mpi.h>
#undef lam_mpi_2int
  extern struct _dtype lam_mpi_2int;
#endif

#if defined(__polyspace_lam_mpi_short_int) && !defined(__polyspace_no_lam_mpi_short_int)
#include <lam/mpi.h>
#undef lam_mpi_short_int
  extern struct _dtype lam_mpi_short_int;
#endif

#if defined(__polyspace_lam_mpi_dblcplex) && !defined(__polyspace_no_lam_mpi_dblcplex)
#include <lam/mpi.h>
#undef lam_mpi_dblcplex
  extern struct _dtype lam_mpi_dblcplex;
#endif

#if defined(__polyspace_lam_mpi_integer) && !defined(__polyspace_no_lam_mpi_integer)
#include <lam/mpi.h>
#undef lam_mpi_integer
  extern struct _dtype lam_mpi_integer;
#endif

#if defined(__polyspace_lam_mpi_real) && !defined(__polyspace_no_lam_mpi_real)
#include <lam/mpi.h>
#undef lam_mpi_real
  extern struct _dtype lam_mpi_real;
#endif

#if defined(__polyspace_lam_mpi_dblprec) && !defined(__polyspace_no_lam_mpi_dblprec)
#include <lam/mpi.h>
#undef lam_mpi_dblprec
  extern struct _dtype lam_mpi_dblprec;
#endif

#if defined(__polyspace_lam_mpi_character) && !defined(__polyspace_no_lam_mpi_character)
#include <lam/mpi.h>
#undef lam_mpi_character
  extern struct _dtype lam_mpi_character;
#endif

#if defined(__polyspace_lam_mpi_2real) && !defined(__polyspace_no_lam_mpi_2real)
#include <lam/mpi.h>
#undef lam_mpi_2real
  extern struct _dtype lam_mpi_2real;
#endif

#if defined(__polyspace_lam_mpi_2dblprec) && !defined(__polyspace_no_lam_mpi_2dblprec)
#include <lam/mpi.h>
#undef lam_mpi_2dblprec
  extern struct _dtype lam_mpi_2dblprec;
#endif

#if defined(__polyspace_lam_mpi_2integer) && !defined(__polyspace_no_lam_mpi_2integer)
#include <lam/mpi.h>
#undef lam_mpi_2integer
  extern struct _dtype lam_mpi_2integer;
#endif

#if defined(__polyspace_lam_mpi_longdbl_int) && !defined(__polyspace_no_lam_mpi_longdbl_int)
#include <lam/mpi.h>
#undef lam_mpi_longdbl_int
  extern struct _dtype lam_mpi_longdbl_int;
#endif

#if defined(__polyspace_lam_mpi_wchar) && !defined(__polyspace_no_lam_mpi_wchar)
#include <lam/mpi.h>
#undef lam_mpi_wchar
  extern struct _dtype lam_mpi_wchar;
#endif

#if defined(__polyspace_lam_mpi_long_long_int) && !defined(__polyspace_no_lam_mpi_long_long_int)
#include <lam/mpi.h>
#undef lam_mpi_long_long_int
  extern struct _dtype lam_mpi_long_long_int;
#endif

#if defined(__polyspace_lam_mpi_unsigned_long_long) && !defined(__polyspace_no_lam_mpi_unsigned_long_long)
#include <lam/mpi.h>
#undef lam_mpi_unsigned_long_long
  extern struct _dtype lam_mpi_unsigned_long_long;
#endif

#if defined(__polyspace_lam_mpi_errors_are_fatal) && !defined(__polyspace_no_lam_mpi_errors_are_fatal)
#include <lam/mpi.h>
#undef lam_mpi_errors_are_fatal
  extern struct _errhdl lam_mpi_errors_are_fatal;
#endif

#if defined(__polyspace_lam_mpi_errors_return) && !defined(__polyspace_no_lam_mpi_errors_return)
#include <lam/mpi.h>
#undef lam_mpi_errors_return
  extern struct _errhdl lam_mpi_errors_return;
#endif

#if defined(__polyspace_MPI_F_STATUS_IGNORE) && !defined(__polyspace_no_MPI_F_STATUS_IGNORE)
#include <lam/mpi.h>
#undef MPI_F_STATUS_IGNORE
  extern MPI_Fint *MPI_F_STATUS_IGNORE;
#endif

#if defined(__polyspace_MPI_F_STATUSES_IGNORE) && !defined(__polyspace_no_MPI_F_STATUSES_IGNORE)
#include <lam/mpi.h>
#undef MPI_F_STATUSES_IGNORE
  extern MPI_Fint *MPI_F_STATUSES_IGNORE;
#endif

#if defined(__polyspace_lam_comm_parent) && !defined(__polyspace_no_lam_comm_parent)
#include <lam/mpisys.h>
#undef lam_comm_parent
  extern MPI_Comm lam_comm_parent;
#endif

#if defined(__polyspace_lam_myproc) && !defined(__polyspace_no_lam_myproc)
#include <lam/mpisys.h>
#undef lam_myproc
  extern struct _proc *lam_myproc;
#endif

#if defined(__polyspace_lam_comms) && !defined(__polyspace_no_lam_comms)
#include <lam/mpisys.h>
#undef lam_comms
  extern LIST *lam_comms;
#endif

#if defined(__polyspace_lam_ports) && !defined(__polyspace_no_lam_ports)
#include <lam/mpisys.h>
#undef lam_ports
  extern LIST *lam_ports;
#endif

#if defined(__polyspace_lam_clockskew) && !defined(__polyspace_no_lam_clockskew)
#include <lam/mpisys.h>
#undef lam_clockskew
  extern float8 lam_clockskew;
#endif

#if defined(__polyspace_lam_f77init) && !defined(__polyspace_no_lam_f77init)
#include <lam/mpisys.h>
#undef lam_f77init
  extern int lam_f77init;
#endif

#if defined(__polyspace_lam_c2c) && !defined(__polyspace_no_lam_c2c)
#include <lam/mpisys.h>
#undef lam_c2c
  extern int lam_c2c;
#endif

#if defined(__polyspace_lam_impi) && !defined(__polyspace_no_lam_impi)
#include <lam/mpisys.h>
#undef lam_impi
  extern int lam_impi;
#endif

#if defined(__polyspace_lam_ger) && !defined(__polyspace_no_lam_ger)
#include <lam/mpisys.h>
#undef lam_ger
  extern int lam_ger;
#endif

#if defined(__polyspace_lam_homog) && !defined(__polyspace_no_lam_homog)
#include <lam/mpisys.h>
#undef lam_homog
  extern int lam_homog;
#endif

#if defined(__polyspace_lam_jobid) && !defined(__polyspace_no_lam_jobid)
#include <lam/mpisys.h>
#undef lam_jobid
  extern struct jobid_t lam_jobid;
#endif

#if defined(__polyspace_lam_universe_size) && !defined(__polyspace_no_lam_universe_size)
#include <lam/mpisys.h>
#undef lam_universe_size
  extern int lam_universe_size;
#endif

#if defined(__polyspace_lam_appnum) && !defined(__polyspace_no_lam_appnum)
#include <lam/mpisys.h>
#undef lam_appnum
  extern int lam_appnum;
#endif

#if defined(__polyspace_lam_rq_flblock) && !defined(__polyspace_no_lam_rq_flblock)
#include <lam/mpisys.h>
#undef lam_rq_flblock
  extern int lam_rq_flblock;
#endif

#if defined(__polyspace_lam_rq_nreqs) && !defined(__polyspace_no_lam_rq_nreqs)
#include <lam/mpisys.h>
#undef lam_rq_nreqs
  extern int lam_rq_nreqs;
#endif

#if defined(__polyspace_lam_rq_nactv) && !defined(__polyspace_no_lam_rq_nactv)
#include <lam/mpisys.h>
#undef lam_rq_nactv
  extern int lam_rq_nactv;
#endif

#if defined(__polyspace_lam_seqnum) && !defined(__polyspace_no_lam_seqnum)
#include <lam/mpisys.h>
#undef lam_seqnum
  extern int lam_seqnum;
#endif

#if defined(__polyspace_lam_rq_top) && !defined(__polyspace_no_lam_rq_top)
#include <lam/mpisys.h>
#undef lam_rq_top
  extern MPI_Request lam_rq_top;
#endif

#if defined(__polyspace_lam_rq_bottom) && !defined(__polyspace_no_lam_rq_bottom)
#include <lam/mpisys.h>
#undef lam_rq_bottom
  extern MPI_Request lam_rq_bottom;
#endif

#if defined(__polyspace_lam_topfunc) && !defined(__polyspace_no_lam_topfunc)
#include <lam/mpisys.h>
#undef lam_topfunc
  extern int lam_topfunc;
#endif

#if defined(__polyspace_lam_flinit) && !defined(__polyspace_no_lam_flinit)
#include <lam/mpisys.h>
#undef lam_flinit
  extern int lam_flinit;
#endif

#if defined(__polyspace_lam_flfinal) && !defined(__polyspace_no_lam_flfinal)
#include <lam/mpisys.h>
#undef lam_flfinal
  extern int lam_flfinal;
#endif

#if defined(__polyspace_lam_osdhdr_type) && !defined(__polyspace_no_lam_osdhdr_type)
#include <lam/mpisys.h>
#undef lam_osdhdr_type
  extern MPI_Datatype lam_osdhdr_type;
#endif

#if defined(__polyspace__kio) && !defined(__polyspace_no__kio)
#include <lam/mpisys.h>
#undef _kio
  extern struct kio_t  _kio;
#endif

#if defined(__polyspace_lam_F_maxhdl) && !defined(__polyspace_no_lam_F_maxhdl)
#include <lam/mpisys.h>
#undef lam_F_maxhdl
  extern int lam_F_maxhdl;
#endif

#if defined(__polyspace_lam_F_nhdl) && !defined(__polyspace_no_lam_F_nhdl)
#include <lam/mpisys.h>
#undef lam_F_nhdl
  extern int lam_F_nhdl;
#endif

#if defined(__polyspace_lam_F_sizehdlarray) && !defined(__polyspace_no_lam_F_sizehdlarray)
#include <lam/mpisys.h>
#undef lam_F_sizehdlarray
  extern int lam_F_sizehdlarray;
#endif

#if defined(__polyspace_lam_F_handles) && !defined(__polyspace_no_lam_F_handles)
#include <lam/mpisys.h>
#undef lam_F_handles
  extern void **lam_F_handles;
#endif

#if defined(__polyspace_lam_F_bottom) && !defined(__polyspace_no_lam_F_bottom)
#include <lam/mpisys.h>
#undef lam_F_bottom
  extern char *lam_F_bottom;
#endif

#if defined(__polyspace_lam_F_argvnull) && !defined(__polyspace_no_lam_F_argvnull)
#include <lam/mpisys.h>
#undef lam_F_argvnull
  extern void *lam_F_argvnull;
#endif

#if defined(__polyspace_lam_F_argvsnull) && !defined(__polyspace_no_lam_F_argvsnull)
#include <lam/mpisys.h>
#undef lam_F_argvsnull
  extern void *lam_F_argvsnull;
#endif

#if defined(__polyspace_lam_F_errorcodes_ignore) && !defined(__polyspace_no_lam_F_errorcodes_ignore)
#include <lam/mpisys.h>
#undef lam_F_errorcodes_ignore
  extern void *lam_F_errorcodes_ignore;
#endif

#if defined(__polyspace_lam_F_status_ignore) && !defined(__polyspace_no_lam_F_status_ignore)
#include <lam/mpisys.h>
#undef lam_F_status_ignore
  extern void *lam_F_status_ignore;
#endif

#if defined(__polyspace_lam_F_statuses_ignore) && !defined(__polyspace_no_lam_F_statuses_ignore)
#include <lam/mpisys.h>
#undef lam_F_statuses_ignore
  extern void *lam_F_statuses_ignore;
#endif

#if defined(__polyspace__shm_membase) && !defined(__polyspace_no__shm_membase)
#include <lam/rpi.shm.h>
#undef _shm_membase
  extern char *_shm_membase;
#endif

#if defined(__polyspace__shm_poll_yield) && !defined(__polyspace_no__shm_poll_yield)
#include <lam/rpi.shm.h>
#undef _shm_poll_yield
  extern int _shm_poll_yield;
#endif

#if defined(__polyspace__lock_poll_read) && !defined(__polyspace_no__lock_poll_read)
#include <lam/rpi.shm.h>
#undef _lock_poll_read
  extern int _lock_poll_read;
#endif

#if defined(__polyspace__lock_poll_write) && !defined(__polyspace_no__lock_poll_write)
#include <lam/rpi.shm.h>
#undef _lock_poll_write
  extern int _lock_poll_write;
#endif

#if defined(__polyspace__tiob) && !defined(__polyspace_no__tiob)
#include <lam/tstdio.h>
#undef _tiob
  extern TFILE _tiob[];
#endif

#if defined(__polyspace__hex_value) && !defined(__polyspace_no__hex_value)
#include <libiberty.h>
#undef _hex_value
  extern char _hex_value[_hex_array_size];
#endif

#if defined(__polyspace__nl_msg_cat_cntr) && !defined(__polyspace_no__nl_msg_cat_cntr)
#include <libintl.h>
#undef _nl_msg_cat_cntr
  extern int _nl_msg_cat_cntr;
#endif

#if defined(__polyspace__IO_2_1_stdin_) && !defined(__polyspace_no__IO_2_1_stdin_)
#include <libio.h>
#undef _IO_2_1_stdin_
  extern struct _IO_FILE_plus _IO_2_1_stdin_;
#endif

#if defined(__polyspace__IO_2_1_stdout_) && !defined(__polyspace_no__IO_2_1_stdout_)
#include <libio.h>
#undef _IO_2_1_stdout_
  extern struct _IO_FILE_plus _IO_2_1_stdout_;
#endif

#if defined(__polyspace__IO_2_1_stderr_) && !defined(__polyspace_no__IO_2_1_stderr_)
#include <libio.h>
#undef _IO_2_1_stderr_
  extern struct _IO_FILE_plus _IO_2_1_stderr_;
#endif

#if defined(__polyspace__IO_stdin) && !defined(__polyspace_no__IO_stdin)
#include <libio.h>
#undef _IO_stdin
  extern _IO_FILE *_IO_stdin;
#endif

#if defined(__polyspace__IO_stdout) && !defined(__polyspace_no__IO_stdout)
#include <libio.h>
#undef _IO_stdout
  extern _IO_FILE *_IO_stdout;
#endif

#if defined(__polyspace__IO_stderr) && !defined(__polyspace_no__IO_stderr)
#include <libio.h>
#undef _IO_stderr
  extern _IO_FILE *_IO_stderr;
#endif

#if defined(__polyspace__r_debug) && !defined(__polyspace_no__r_debug)
#include <link.h>
#undef _r_debug
  extern struct r_debug _r_debug;
#endif

#if defined(__polyspace_adfs_dir_inode_operations) && !defined(__polyspace_no_adfs_dir_inode_operations)
#include <linux/adfs_fs.h>
#undef adfs_dir_inode_operations
  extern struct inode_operations adfs_dir_inode_operations;
#endif

#if defined(__polyspace_adfs_file_inode_operations) && !defined(__polyspace_no_adfs_file_inode_operations)
#include <linux/adfs_fs.h>
#undef adfs_file_inode_operations
  extern struct inode_operations adfs_file_inode_operations;
#endif

#if defined(__polyspace_affs_file_inode_operations) && !defined(__polyspace_no_affs_file_inode_operations)
#include <linux/affs_fs.h>
#undef affs_file_inode_operations
  extern struct inode_operations affs_file_inode_operations;
#endif

#if defined(__polyspace_affs_file_inode_operations_ofs) && !defined(__polyspace_no_affs_file_inode_operations_ofs)
#include <linux/affs_fs.h>
#undef affs_file_inode_operations_ofs
  extern struct inode_operations affs_file_inode_operations_ofs;
#endif

#if defined(__polyspace_affs_dir_inode_operations) && !defined(__polyspace_no_affs_dir_inode_operations)
#include <linux/affs_fs.h>
#undef affs_dir_inode_operations
  extern struct inode_operations affs_dir_inode_operations;
#endif

#if defined(__polyspace_affs_symlink_inode_operations) && !defined(__polyspace_no_affs_symlink_inode_operations)
#include <linux/affs_fs.h>
#undef affs_symlink_inode_operations
  extern struct inode_operations affs_symlink_inode_operations;
#endif

#if defined(__polyspace_affs_chrdev_inode_operations) && !defined(__polyspace_no_affs_chrdev_inode_operations)
#include <linux/affs_fs.h>
#undef affs_chrdev_inode_operations
  extern struct inode_operations affs_chrdev_inode_operations;
#endif

#if defined(__polyspace_affs_blkdev_inode_operations) && !defined(__polyspace_no_affs_blkdev_inode_operations)
#include <linux/affs_fs.h>
#undef affs_blkdev_inode_operations
  extern struct inode_operations affs_blkdev_inode_operations;
#endif

#if defined(__polyspace_affs_dentry_operations) && !defined(__polyspace_no_affs_dentry_operations)
#include <linux/affs_fs.h>
#undef affs_dentry_operations
  extern struct dentry_operations affs_dentry_operations;
#endif

#if defined(__polyspace_affs_dentry_operations_intl) && !defined(__polyspace_no_affs_dentry_operations_intl)
#include <linux/affs_fs.h>
#undef affs_dentry_operations_intl
  extern struct dentry_operations affs_dentry_operations_intl;
#endif

#if defined(__polyspace_apm_bios_info) && !defined(__polyspace_no_apm_bios_info)
#include <linux/apm_bios.h>
#undef apm_bios_info
  extern struct apm_bios_info apm_bios_info;
#endif

#if defined(__polyspace_arcnet_debug) && !defined(__polyspace_no_arcnet_debug)
#include <linux/arcdevice.h>
#undef arcnet_debug
  extern int arcnet_debug;
#endif

#if defined(__polyspace_ddp_dl) && !defined(__polyspace_no_ddp_dl)
#include <linux/atalk.h>
#undef ddp_dl
  extern struct datalink_proto *ddp_dl;
#endif

#if defined(__polyspace_aarp_dl) && !defined(__polyspace_no_aarp_dl)
#include <linux/atalk.h>
#undef aarp_dl
  extern struct datalink_proto *aarp_dl;
#endif

#if defined(__polyspace_bigmem_mapnr) && !defined(__polyspace_no_bigmem_mapnr)
#include <linux/bigmem.h>
#undef bigmem_mapnr
  extern unsigned long bigmem_mapnr;
#endif

#if defined(__polyspace_io_request_lock) && !defined(__polyspace_no_io_request_lock)
#include <linux/blk.h>
#undef io_request_lock
  extern spinlock_t io_request_lock;
#endif

#if defined(__polyspace_rd_doload) && !defined(__polyspace_no_rd_doload)
#include <linux/blk.h>
#undef rd_doload
  extern int rd_doload;
#endif

#if defined(__polyspace_rd_prompt) && !defined(__polyspace_no_rd_prompt)
#include <linux/blk.h>
#undef rd_prompt
  extern int rd_prompt;
#endif

#if defined(__polyspace_rd_image_start) && !defined(__polyspace_no_rd_image_start)
#include <linux/blk.h>
#undef rd_image_start
  extern int rd_image_start;
#endif

#if defined(__polyspace_initrd_start) && !defined(__polyspace_no_initrd_start)
#include <linux/blk.h>
#undef initrd_start
  extern unsigned long initrd_start;
#endif

#if defined(__polyspace_initrd_end) && !defined(__polyspace_no_initrd_end)
#include <linux/blk.h>
#undef initrd_end
  extern unsigned long initrd_end;
#endif

#if defined(__polyspace_mount_initrd) && !defined(__polyspace_no_mount_initrd)
#include <linux/blk.h>
#undef mount_initrd
  extern int mount_initrd;
#endif

#if defined(__polyspace_initrd_below_start_ok) && !defined(__polyspace_no_initrd_below_start_ok)
#include <linux/blk.h>
#undef initrd_below_start_ok
  extern int initrd_below_start_ok;
#endif

#if defined(__polyspace_blk_sec) && !defined(__polyspace_no_blk_sec)
#include <linux/blkdev.h>
#undef blk_sec
  extern struct sec_size * blk_sec[MAX_BLKDEV];
#endif

#if defined(__polyspace_blk_dev) && !defined(__polyspace_no_blk_dev)
#include <linux/blkdev.h>
#undef blk_dev
  extern struct blk_dev_struct blk_dev[MAX_BLKDEV];
#endif

#if defined(__polyspace_wait_for_request) && !defined(__polyspace_no_wait_for_request)
#include <linux/blkdev.h>
#undef wait_for_request
  extern struct wait_queue * wait_for_request;
#endif

#if defined(__polyspace_blk_size) && !defined(__polyspace_no_blk_size)
#include <linux/blkdev.h>
#undef blk_size
  extern int * blk_size[MAX_BLKDEV];
#endif

#if defined(__polyspace_blksize_size) && !defined(__polyspace_no_blksize_size)
#include <linux/blkdev.h>
#undef blksize_size
  extern int * blksize_size[MAX_BLKDEV];
#endif

#if defined(__polyspace_hardsect_size) && !defined(__polyspace_no_hardsect_size)
#include <linux/blkdev.h>
#undef hardsect_size
  extern int * hardsect_size[MAX_BLKDEV];
#endif

#if defined(__polyspace_max_readahead) && !defined(__polyspace_no_max_readahead)
#include <linux/blkdev.h>
#undef max_readahead
  extern int * max_readahead[MAX_BLKDEV];
#endif

#if defined(__polyspace_max_sectors) && !defined(__polyspace_no_max_sectors)
#include <linux/blkdev.h>
#undef max_sectors
  extern int * max_sectors[MAX_BLKDEV];
#endif

#if defined(__polyspace_max_segments) && !defined(__polyspace_no_max_segments)
#include <linux/blkdev.h>
#undef max_segments
  extern int * max_segments[MAX_BLKDEV];
#endif

#if defined(__polyspace_cap_bset) && !defined(__polyspace_no_cap_bset)
#include <linux/capability.h>
#undef cap_bset
  extern kernel_cap_t cap_bset;
#endif

#if defined(__polyspace_cdrom_fops) && !defined(__polyspace_no_cdrom_fops)
#include <linux/cdrom.h>
#undef cdrom_fops
  extern struct file_operations cdrom_fops;
#endif

#if defined(__polyspace_coda_dir_inode_operations) && !defined(__polyspace_no_coda_dir_inode_operations)
#include <linux/coda_linux.h>
#undef coda_dir_inode_operations
  extern struct inode_operations coda_dir_inode_operations;
#endif

#if defined(__polyspace_coda_file_inode_operations) && !defined(__polyspace_no_coda_file_inode_operations)
#include <linux/coda_linux.h>
#undef coda_file_inode_operations
  extern struct inode_operations coda_file_inode_operations;
#endif

#if defined(__polyspace_coda_ioctl_inode_operations) && !defined(__polyspace_no_coda_ioctl_inode_operations)
#include <linux/coda_linux.h>
#undef coda_ioctl_inode_operations
  extern struct inode_operations coda_ioctl_inode_operations;
#endif

#if defined(__polyspace_coda_symlink_inode_operations) && !defined(__polyspace_no_coda_symlink_inode_operations)
#include <linux/coda_linux.h>
#undef coda_symlink_inode_operations
  extern struct inode_operations coda_symlink_inode_operations;
#endif

#if defined(__polyspace_coda_dir_operations) && !defined(__polyspace_no_coda_dir_operations)
#include <linux/coda_linux.h>
#undef coda_dir_operations
  extern struct file_operations coda_dir_operations;
#endif

#if defined(__polyspace_coda_file_operations) && !defined(__polyspace_no_coda_file_operations)
#include <linux/coda_linux.h>
#undef coda_file_operations
  extern struct file_operations coda_file_operations;
#endif

#if defined(__polyspace_coda_ioctl_operations) && !defined(__polyspace_no_coda_ioctl_operations)
#include <linux/coda_linux.h>
#undef coda_ioctl_operations
  extern struct file_operations coda_ioctl_operations;
#endif

#if defined(__polyspace_coda_debug) && !defined(__polyspace_no_coda_debug)
#include <linux/coda_linux.h>
#undef coda_debug
  extern int coda_debug;
#endif

#if defined(__polyspace_coda_print_entry) && !defined(__polyspace_no_coda_print_entry)
#include <linux/coda_linux.h>
#undef coda_print_entry
  extern int coda_print_entry;
#endif

#if defined(__polyspace_coda_access_cache) && !defined(__polyspace_no_coda_access_cache)
#include <linux/coda_linux.h>
#undef coda_access_cache
  extern int coda_access_cache;
#endif

#if defined(__polyspace_coda_vfs_stat) && !defined(__polyspace_no_coda_vfs_stat)
#include <linux/coda_proc.h>
#undef coda_vfs_stat
  extern struct coda_vfs_stats coda_vfs_stat;
#endif

#if defined(__polyspace_coda_permission_stat) && !defined(__polyspace_no_coda_permission_stat)
#include <linux/coda_proc.h>
#undef coda_permission_stat
  extern struct coda_permission_stats coda_permission_stat;
#endif

#if defined(__polyspace_coda_cache_inv_stat) && !defined(__polyspace_no_coda_cache_inv_stat)
#include <linux/coda_proc.h>
#undef coda_cache_inv_stat
  extern struct coda_cache_inv_stats coda_cache_inv_stat;
#endif

#if defined(__polyspace_coda_upcall_timestamping) && !defined(__polyspace_no_coda_upcall_timestamping)
#include <linux/coda_proc.h>
#undef coda_upcall_timestamping
  extern int coda_upcall_timestamping;
#endif

#if defined(__polyspace_coda_upc_comm) && !defined(__polyspace_no_coda_upc_comm)
#include <linux/coda_psdev.h>
#undef coda_upc_comm
  extern struct venus_comm coda_upc_comm;
#endif

#if defined(__polyspace_coda_super_info) && !defined(__polyspace_no_coda_super_info)
#include <linux/coda_psdev.h>
#undef coda_super_info
  extern struct coda_sb_info coda_super_info;
#endif

#if defined(__polyspace_coda_hard) && !defined(__polyspace_no_coda_hard)
#include <linux/coda_psdev.h>
#undef coda_hard
  extern int coda_hard;
#endif

#if defined(__polyspace_coda_timeout) && !defined(__polyspace_no_coda_timeout)
#include <linux/coda_psdev.h>
#undef coda_timeout
  extern unsigned long coda_timeout;
#endif

#if defined(__polyspace_coda_callstats) && !defined(__polyspace_no_coda_callstats)
#include <linux/coda_psdev.h>
#undef coda_callstats
  extern struct coda_upcallstats coda_callstats;
#endif

#if defined(__polyspace_conswitchp) && !defined(__polyspace_no_conswitchp)
#include <linux/console.h>
#undef conswitchp
  extern struct consw *conswitchp;
#endif

#if defined(__polyspace_dummy_con) && !defined(__polyspace_no_dummy_con)
#include <linux/console.h>
#undef dummy_con
  extern struct consw dummy_con;
#endif

#if defined(__polyspace_fb_con) && !defined(__polyspace_no_fb_con)
#include <linux/console.h>
#undef fb_con
  extern struct consw fb_con;
#endif

#if defined(__polyspace_vga_con) && !defined(__polyspace_no_vga_con)
#include <linux/console.h>
#undef vga_con
  extern struct consw vga_con;
#endif

#if defined(__polyspace_newport_con) && !defined(__polyspace_no_newport_con)
#include <linux/console.h>
#undef newport_con
  extern struct consw newport_con;
#endif

#if defined(__polyspace_prom_con) && !defined(__polyspace_no_prom_con)
#include <linux/console.h>
#undef prom_con
  extern struct consw prom_con;
#endif

#if defined(__polyspace_console_list) && !defined(__polyspace_no_console_list)
#include <linux/console.h>
#undef console_list
  extern struct console_cmdline console_list[MAX_CMDLINECONSOLES];
#endif

#if defined(__polyspace_console_drivers) && !defined(__polyspace_no_console_drivers)
#include <linux/console.h>
#undef console_drivers
  extern struct console *console_drivers;
#endif

#if defined(__polyspace_) && !defined(__polyspace_no_)
#include <linux/console_struct.h>
#undef 
  extern struct vc vc_cons [MAX_NR_CONSOLES];
#endif

#if defined(__polyspace_loops_per_sec) && !defined(__polyspace_no_loops_per_sec)
#include <linux/delay.h>
#undef loops_per_sec
  extern unsigned long loops_per_sec;
#endif

#if defined(__polyspace_unix98_max_ptys) && !defined(__polyspace_no_unix98_max_ptys)
#include <linux/devpts_fs.h>
#undef unix98_max_ptys
  extern unsigned int unix98_max_ptys;
#endif

#if defined(__polyspace_efs_dir_inode_operations) && !defined(__polyspace_no_efs_dir_inode_operations)
#include <linux/efs_fs.h>
#undef efs_dir_inode_operations
  extern struct inode_operations efs_dir_inode_operations;
#endif

#if defined(__polyspace_efs_file_inode_operations) && !defined(__polyspace_no_efs_file_inode_operations)
#include <linux/efs_fs.h>
#undef efs_file_inode_operations
  extern struct inode_operations efs_file_inode_operations;
#endif

#if defined(__polyspace_efs_symlink_inode_operations) && !defined(__polyspace_no_efs_symlink_inode_operations)
#include <linux/efs_fs.h>
#undef efs_symlink_inode_operations
  extern struct inode_operations efs_symlink_inode_operations;
#endif

#if defined(__polyspace_ext2_max_sizes) && !defined(__polyspace_no_ext2_max_sizes)
#include <linux/ext2_fs.h>
#undef ext2_max_sizes
  extern long long ext2_max_sizes[];
#endif

#if defined(__polyspace_ext2_dir_inode_operations) && !defined(__polyspace_no_ext2_dir_inode_operations)
#include <linux/ext2_fs.h>
#undef ext2_dir_inode_operations
  extern struct inode_operations ext2_dir_inode_operations;
#endif

#if defined(__polyspace_ext2_file_inode_operations) && !defined(__polyspace_no_ext2_file_inode_operations)
#include <linux/ext2_fs.h>
#undef ext2_file_inode_operations
  extern struct inode_operations ext2_file_inode_operations;
#endif

#if defined(__polyspace_ext2_symlink_inode_operations) && !defined(__polyspace_no_ext2_symlink_inode_operations)
#include <linux/ext2_fs.h>
#undef ext2_symlink_inode_operations
  extern struct inode_operations ext2_symlink_inode_operations;
#endif

#if defined(__polyspace_cvf_formats) && !defined(__polyspace_no_cvf_formats)
#include <linux/fat_cvf.h>
#undef cvf_formats
  extern struct cvf_format *cvf_formats[];
#endif

#if defined(__polyspace_cvf_format_use_count) && !defined(__polyspace_no_cvf_format_use_count)
#include <linux/fat_cvf.h>
#undef cvf_format_use_count
  extern int cvf_format_use_count[];
#endif

#if defined(__polyspace_num_registered_fb) && !defined(__polyspace_no_num_registered_fb)
#include <linux/fb.h>
#undef num_registered_fb
  extern int num_registered_fb;
#endif

#if defined(__polyspace_registered_fb) && !defined(__polyspace_no_registered_fb)
#include <linux/fb.h>
#undef registered_fb
  extern struct fb_info *registered_fb[FB_MAX];
#endif

#if defined(__polyspace_con2fb_map) && !defined(__polyspace_no_con2fb_map)
#include <linux/fb.h>
#undef con2fb_map
  extern char con2fb_map[MAX_NR_CONSOLES];
#endif

#if defined(__polyspace_fb_display) && !defined(__polyspace_no_fb_display)
#include <linux/fb.h>
#undef fb_display
  extern struct display fb_display[MAX_NR_CONSOLES];
#endif

#if defined(__polyspace_max_inodes) && !defined(__polyspace_no_max_inodes)
#include <linux/fs.h>
#undef max_inodes
  extern int max_inodes;
#endif

#if defined(__polyspace_max_files) && !defined(__polyspace_no_max_files)
#include <linux/fs.h>
#undef max_files
  extern int max_files;
#endif

#if defined(__polyspace_nr_files) && !defined(__polyspace_no_nr_files)
#include <linux/fs.h>
#undef nr_files
  extern int nr_files;
#endif

#if defined(__polyspace_nr_free_files) && !defined(__polyspace_no_nr_free_files)
#include <linux/fs.h>
#undef nr_free_files
  extern int nr_free_files;
#endif

#if defined(__polyspace_max_super_blocks) && !defined(__polyspace_no_max_super_blocks)
#include <linux/fs.h>
#undef max_super_blocks
  extern int max_super_blocks;
#endif

#if defined(__polyspace_nr_super_blocks) && !defined(__polyspace_no_nr_super_blocks)
#include <linux/fs.h>
#undef nr_super_blocks
  extern int nr_super_blocks;
#endif

#if defined(__polyspace_file_lock_table) && !defined(__polyspace_no_file_lock_table)
#include <linux/fs.h>
#undef file_lock_table
  extern struct file_lock *file_lock_table;
#endif

#if defined(__polyspace_super_blocks) && !defined(__polyspace_no_super_blocks)
#include <linux/fs.h>
#undef super_blocks
  extern struct list_head super_blocks;
#endif

#if defined(__polyspace_def_blk_fops) && !defined(__polyspace_no_def_blk_fops)
#include <linux/fs.h>
#undef def_blk_fops
  extern struct file_operations def_blk_fops;
#endif

#if defined(__polyspace_blkdev_inode_operations) && !defined(__polyspace_no_blkdev_inode_operations)
#include <linux/fs.h>
#undef blkdev_inode_operations
  extern struct inode_operations blkdev_inode_operations;
#endif

#if defined(__polyspace_def_chr_fops) && !defined(__polyspace_no_def_chr_fops)
#include <linux/fs.h>
#undef def_chr_fops
  extern struct file_operations def_chr_fops;
#endif

#if defined(__polyspace_chrdev_inode_operations) && !defined(__polyspace_no_chrdev_inode_operations)
#include <linux/fs.h>
#undef chrdev_inode_operations
  extern struct inode_operations chrdev_inode_operations;
#endif

#if defined(__polyspace_fifo_inode_operations) && !defined(__polyspace_no_fifo_inode_operations)
#include <linux/fs.h>
#undef fifo_inode_operations
  extern struct inode_operations fifo_inode_operations;
#endif

#if defined(__polyspace_connecting_fifo_fops) && !defined(__polyspace_no_connecting_fifo_fops)
#include <linux/fs.h>
#undef connecting_fifo_fops
  extern struct file_operations connecting_fifo_fops;
#endif

#if defined(__polyspace_read_fifo_fops) && !defined(__polyspace_no_read_fifo_fops)
#include <linux/fs.h>
#undef read_fifo_fops
  extern struct file_operations read_fifo_fops;
#endif

#if defined(__polyspace_write_fifo_fops) && !defined(__polyspace_no_write_fifo_fops)
#include <linux/fs.h>
#undef write_fifo_fops
  extern struct file_operations write_fifo_fops;
#endif

#if defined(__polyspace_rdwr_fifo_fops) && !defined(__polyspace_no_rdwr_fifo_fops)
#include <linux/fs.h>
#undef rdwr_fifo_fops
  extern struct file_operations rdwr_fifo_fops;
#endif

#if defined(__polyspace_read_pipe_fops) && !defined(__polyspace_no_read_pipe_fops)
#include <linux/fs.h>
#undef read_pipe_fops
  extern struct file_operations read_pipe_fops;
#endif

#if defined(__polyspace_write_pipe_fops) && !defined(__polyspace_no_write_pipe_fops)
#include <linux/fs.h>
#undef write_pipe_fops
  extern struct file_operations write_pipe_fops;
#endif

#if defined(__polyspace_rdwr_pipe_fops) && !defined(__polyspace_no_rdwr_pipe_fops)
#include <linux/fs.h>
#undef rdwr_pipe_fops
  extern struct file_operations rdwr_pipe_fops;
#endif

#if defined(__polyspace_inuse_filps) && !defined(__polyspace_no_inuse_filps)
#include <linux/fs.h>
#undef inuse_filps
  extern struct file *inuse_filps;
#endif

#if defined(__polyspace_nr_buffers) && !defined(__polyspace_no_nr_buffers)
#include <linux/fs.h>
#undef nr_buffers
  extern int nr_buffers;
#endif

#if defined(__polyspace_buffermem) && !defined(__polyspace_no_buffermem)
#include <linux/fs.h>
#undef buffermem
  extern long buffermem;
#endif

#if defined(__polyspace_nr_buffer_heads) && !defined(__polyspace_no_nr_buffer_heads)
#include <linux/fs.h>
#undef nr_buffer_heads
  extern int nr_buffer_heads;
#endif

#if defined(__polyspace_ROOT_DEV) && !defined(__polyspace_no_ROOT_DEV)
#include <linux/fs.h>
#undef ROOT_DEV
  extern kdev_t ROOT_DEV;
#endif

#if defined(__polyspace_real_root_dev) && !defined(__polyspace_no_real_root_dev)
#include <linux/fs.h>
#undef real_root_dev
  extern kdev_t real_root_dev;
#endif

#if defined(__polyspace_read_ahead) && !defined(__polyspace_no_read_ahead)
#include <linux/fs.h>
#undef read_ahead
  extern int read_ahead[];
#endif

#if defined(__polyspace_inode_generation_count) && !defined(__polyspace_no_inode_generation_count)
#include <linux/fs.h>
#undef inode_generation_count
  extern __u32 inode_generation_count;
#endif

#if defined(__polyspace_gendisk_head) && !defined(__polyspace_no_gendisk_head)
#include <linux/genhd.h>
#undef gendisk_head
  extern struct gendisk *gendisk_head;
#endif

#if defined(__polyspace_hfmodem_drvname) && !defined(__polyspace_no_hfmodem_drvname)
#include <linux/hfmodem.h>
#undef hfmodem_drvname
  extern const char hfmodem_drvname[];
#endif

#if defined(__polyspace_hfmodem_drvinfo) && !defined(__polyspace_no_hfmodem_drvinfo)
#include <linux/hfmodem.h>
#undef hfmodem_drvinfo
  extern const char hfmodem_drvinfo[];
#endif

#if defined(__polyspace_hfmodem_state) && !defined(__polyspace_no_hfmodem_state)
#include <linux/hfmodem.h>
#undef hfmodem_state
  extern struct hfmodem_state hfmodem_state[NR_DEVICE];
#endif

#if defined(__polyspace_hfmodem_correlator_cache) && !defined(__polyspace_no_hfmodem_correlator_cache)
#include <linux/hfmodem.h>
#undef hfmodem_correlator_cache
  extern struct hfmodem_correlator_cache hfmodem_correlator_cache[HFMODEM_CORRELATOR_CACHE];
#endif

#if defined(__polyspace_hfs_cap_reserved1) && !defined(__polyspace_no_hfs_cap_reserved1)
#include <linux/hfs_fs.h>
#undef hfs_cap_reserved1
  extern const struct hfs_name hfs_cap_reserved1[];
#endif

#if defined(__polyspace_hfs_cap_reserved2) && !defined(__polyspace_no_hfs_cap_reserved2)
#include <linux/hfs_fs.h>
#undef hfs_cap_reserved2
  extern const struct hfs_name hfs_cap_reserved2[];
#endif

#if defined(__polyspace_hfs_cap_ndir_inode_operations) && !defined(__polyspace_no_hfs_cap_ndir_inode_operations)
#include <linux/hfs_fs.h>
#undef hfs_cap_ndir_inode_operations
  extern struct inode_operations hfs_cap_ndir_inode_operations;
#endif

#if defined(__polyspace_hfs_cap_fdir_inode_operations) && !defined(__polyspace_no_hfs_cap_fdir_inode_operations)
#include <linux/hfs_fs.h>
#undef hfs_cap_fdir_inode_operations
  extern struct inode_operations hfs_cap_fdir_inode_operations;
#endif

#if defined(__polyspace_hfs_cap_rdir_inode_operations) && !defined(__polyspace_no_hfs_cap_rdir_inode_operations)
#include <linux/hfs_fs.h>
#undef hfs_cap_rdir_inode_operations
  extern struct inode_operations hfs_cap_rdir_inode_operations;
#endif

#if defined(__polyspace_hfs_dbl_reserved1) && !defined(__polyspace_no_hfs_dbl_reserved1)
#include <linux/hfs_fs.h>
#undef hfs_dbl_reserved1
  extern const struct hfs_name hfs_dbl_reserved1[];
#endif

#if defined(__polyspace_hfs_dbl_reserved2) && !defined(__polyspace_no_hfs_dbl_reserved2)
#include <linux/hfs_fs.h>
#undef hfs_dbl_reserved2
  extern const struct hfs_name hfs_dbl_reserved2[];
#endif

#if defined(__polyspace_hfs_dbl_dir_inode_operations) && !defined(__polyspace_no_hfs_dbl_dir_inode_operations)
#include <linux/hfs_fs.h>
#undef hfs_dbl_dir_inode_operations
  extern struct inode_operations hfs_dbl_dir_inode_operations;
#endif

#if defined(__polyspace_hfs_nat_reserved1) && !defined(__polyspace_no_hfs_nat_reserved1)
#include <linux/hfs_fs.h>
#undef hfs_nat_reserved1
  extern const struct hfs_name hfs_nat_reserved1[];
#endif

#if defined(__polyspace_hfs_nat_reserved2) && !defined(__polyspace_no_hfs_nat_reserved2)
#include <linux/hfs_fs.h>
#undef hfs_nat_reserved2
  extern const struct hfs_name hfs_nat_reserved2[];
#endif

#if defined(__polyspace_hfs_nat_ndir_inode_operations) && !defined(__polyspace_no_hfs_nat_ndir_inode_operations)
#include <linux/hfs_fs.h>
#undef hfs_nat_ndir_inode_operations
  extern struct inode_operations hfs_nat_ndir_inode_operations;
#endif

#if defined(__polyspace_hfs_nat_hdir_inode_operations) && !defined(__polyspace_no_hfs_nat_hdir_inode_operations)
#include <linux/hfs_fs.h>
#undef hfs_nat_hdir_inode_operations
  extern struct inode_operations hfs_nat_hdir_inode_operations;
#endif

#if defined(__polyspace_hfs_sngl_reserved1) && !defined(__polyspace_no_hfs_sngl_reserved1)
#include <linux/hfs_fs.h>
#undef hfs_sngl_reserved1
  extern const struct hfs_name hfs_sngl_reserved1[];
#endif

#if defined(__polyspace_hfs_sngl_reserved2) && !defined(__polyspace_no_hfs_sngl_reserved2)
#include <linux/hfs_fs.h>
#undef hfs_sngl_reserved2
  extern const struct hfs_name hfs_sngl_reserved2[];
#endif

#if defined(__polyspace_hfs_sngl_dir_inode_operations) && !defined(__polyspace_no_hfs_sngl_dir_inode_operations)
#include <linux/hfs_fs.h>
#undef hfs_sngl_dir_inode_operations
  extern struct inode_operations hfs_sngl_dir_inode_operations;
#endif

#if defined(__polyspace_hfs_file_inode_operations) && !defined(__polyspace_no_hfs_file_inode_operations)
#include <linux/hfs_fs.h>
#undef hfs_file_inode_operations
  extern struct inode_operations hfs_file_inode_operations;
#endif

#if defined(__polyspace_hfs_cap_info_inode_operations) && !defined(__polyspace_no_hfs_cap_info_inode_operations)
#include <linux/hfs_fs.h>
#undef hfs_cap_info_inode_operations
  extern struct inode_operations hfs_cap_info_inode_operations;
#endif

#if defined(__polyspace_hfs_hdr_inode_operations) && !defined(__polyspace_no_hfs_hdr_inode_operations)
#include <linux/hfs_fs.h>
#undef hfs_hdr_inode_operations
  extern struct inode_operations hfs_hdr_inode_operations;
#endif

#if defined(__polyspace_hfs_dbl_fil_hdr_layout) && !defined(__polyspace_no_hfs_dbl_fil_hdr_layout)
#include <linux/hfs_fs.h>
#undef hfs_dbl_fil_hdr_layout
  extern const struct hfs_hdr_layout hfs_dbl_fil_hdr_layout;
#endif

#if defined(__polyspace_hfs_dbl_dir_hdr_layout) && !defined(__polyspace_no_hfs_dbl_dir_hdr_layout)
#include <linux/hfs_fs.h>
#undef hfs_dbl_dir_hdr_layout
  extern const struct hfs_hdr_layout hfs_dbl_dir_hdr_layout;
#endif

#if defined(__polyspace_hfs_nat_hdr_layout) && !defined(__polyspace_no_hfs_nat_hdr_layout)
#include <linux/hfs_fs.h>
#undef hfs_nat_hdr_layout
  extern const struct hfs_hdr_layout hfs_nat_hdr_layout;
#endif

#if defined(__polyspace_hfs_nat2_hdr_layout) && !defined(__polyspace_no_hfs_nat2_hdr_layout)
#include <linux/hfs_fs.h>
#undef hfs_nat2_hdr_layout
  extern const struct hfs_hdr_layout hfs_nat2_hdr_layout;
#endif

#if defined(__polyspace_hfs_sngl_hdr_layout) && !defined(__polyspace_no_hfs_sngl_hdr_layout)
#include <linux/hfs_fs.h>
#undef hfs_sngl_hdr_layout
  extern const struct hfs_hdr_layout hfs_sngl_hdr_layout;
#endif

#if defined(__polyspace_sys_tz) && !defined(__polyspace_no_sys_tz)
#include <linux/hfs_sysdep.h>
#undef sys_tz
  extern struct timezone sys_tz;
#endif

#if defined(__polyspace_hfs_alloc) && !defined(__polyspace_no_hfs_alloc)
#include <linux/hfs_sysdep.h>
#undef hfs_alloc
  extern long int hfs_alloc;
#endif

#if defined(__polyspace_ipv4_devconf) && !defined(__polyspace_no_ipv4_devconf)
#include <linux/inetdevice.h>
#undef ipv4_devconf
  extern struct ipv4_devconf ipv4_devconf;
#endif

#if defined(__polyspace_bh_running) && !defined(__polyspace_no_bh_running)
#include <linux/interrupt.h>
#undef bh_running
  extern volatile unsigned char bh_running;
#endif

#if defined(__polyspace_bh_mask_count) && !defined(__polyspace_no_bh_mask_count)
#include <linux/interrupt.h>
#undef bh_mask_count
  extern atomic_t bh_mask_count[32];
#endif

#if defined(__polyspace_bh_active) && !defined(__polyspace_no_bh_active)
#include <linux/interrupt.h>
#undef bh_active
  extern unsigned long bh_active;
#endif

#if defined(__polyspace_bh_mask) && !defined(__polyspace_no_bh_mask)
#include <linux/interrupt.h>
#undef bh_mask
  extern unsigned long bh_mask;
#endif

#if defined(__polyspace_dev) && !defined(__polyspace_no_dev)
#include <linux/isdn.h>
#undef dev
  extern isdn_dev *dev;
#endif

#if defined(__polyspace_isofs_file_inode_operations) && !defined(__polyspace_no_isofs_file_inode_operations)
#include <linux/iso_fs.h>
#undef isofs_file_inode_operations
  extern struct inode_operations isofs_file_inode_operations;
#endif

#if defined(__polyspace_isofs_dir_inode_operations) && !defined(__polyspace_no_isofs_dir_inode_operations)
#include <linux/iso_fs.h>
#undef isofs_dir_inode_operations
  extern struct inode_operations isofs_dir_inode_operations;
#endif

#if defined(__polyspace_isofs_symlink_inode_operations) && !defined(__polyspace_no_isofs_symlink_inode_operations)
#include <linux/iso_fs.h>
#undef isofs_symlink_inode_operations
  extern struct inode_operations isofs_symlink_inode_operations;
#endif

#if defined(__polyspace_isofs_chrdev_inode_operations) && !defined(__polyspace_no_isofs_chrdev_inode_operations)
#include <linux/iso_fs.h>
#undef isofs_chrdev_inode_operations
  extern struct inode_operations isofs_chrdev_inode_operations;
#endif

#if defined(__polyspace_isofs_blkdev_inode_operations) && !defined(__polyspace_no_isofs_blkdev_inode_operations)
#include <linux/iso_fs.h>
#undef isofs_blkdev_inode_operations
  extern struct inode_operations isofs_blkdev_inode_operations;
#endif

#if defined(__polyspace_isofs_fifo_inode_operations) && !defined(__polyspace_no_isofs_fifo_inode_operations)
#include <linux/iso_fs.h>
#undef isofs_fifo_inode_operations
  extern struct inode_operations isofs_fifo_inode_operations;
#endif

#if defined(__polyspace_accent_table) && !defined(__polyspace_no_accent_table)
#include <linux/kbd_diacr.h>
#undef accent_table
  extern struct kbdiacr accent_table[];
#endif

#if defined(__polyspace_accent_table_size) && !defined(__polyspace_no_accent_table_size)
#include <linux/kbd_diacr.h>
#undef accent_table_size
  extern unsigned int accent_table_size;
#endif

#if defined(__polyspace_shift_state) && !defined(__polyspace_no_shift_state)
#include <linux/kbd_kern.h>
#undef shift_state
  extern int shift_state;
#endif

#if defined(__polyspace_func_table) && !defined(__polyspace_no_func_table)
#include <linux/kbd_kern.h>
#undef func_table
  extern char *func_table[MAX_NR_FUNC];
#endif

#if defined(__polyspace_func_buf) && !defined(__polyspace_no_func_buf)
#include <linux/kbd_kern.h>
#undef func_buf
  extern char func_buf[];
#endif

#if defined(__polyspace_funcbufptr) && !defined(__polyspace_no_funcbufptr)
#include <linux/kbd_kern.h>
#undef funcbufptr
  extern char *funcbufptr;
#endif

#if defined(__polyspace_funcbufsize) && !defined(__polyspace_no_funcbufsize)
#include <linux/kbd_kern.h>
#undef funcbufsize
  extern int funcbufsize;
#endif

#if defined(__polyspace_funcbufleft) && !defined(__polyspace_no_funcbufleft)
#include <linux/kbd_kern.h>
#undef funcbufleft
  extern int funcbufleft;
#endif

#if defined(__polyspace_kbd_table) && !defined(__polyspace_no_kbd_table)
#include <linux/kbd_kern.h>
#undef kbd_table
  extern struct kbd_struct kbd_table[];
#endif

#if defined(__polyspace_do_poke_blanked_console) && !defined(__polyspace_no_do_poke_blanked_console)
#include <linux/kbd_kern.h>
#undef do_poke_blanked_console
  extern int do_poke_blanked_console;
#endif

#if defined(__polyspace_keymap_count) && !defined(__polyspace_no_keymap_count)
#include <linux/kbd_kern.h>
#undef keymap_count
  extern unsigned int keymap_count;
#endif

#if defined(__polyspace_con_task_queue) && !defined(__polyspace_no_con_task_queue)
#include <linux/kbd_kern.h>
#undef con_task_queue
  extern task_queue con_task_queue;
#endif

#if defined(__polyspace_kbd_pt_regs) && !defined(__polyspace_no_kbd_pt_regs)
#include <linux/kbd_ll.h>
#undef kbd_pt_regs
  extern struct pt_regs *kbd_pt_regs;
#endif

#if defined(__polyspace_panic_notifier_list) && !defined(__polyspace_no_panic_notifier_list)
#include <linux/kernel.h>
#undef panic_notifier_list
  extern struct notifier_block *panic_notifier_list;
#endif

#if defined(__polyspace_kstat) && !defined(__polyspace_no_kstat)
#include <linux/kernel_stat.h>
#undef kstat
  extern struct kernel_stat kstat;
#endif

#if defined(__polyspace_NR_TYPES) && !defined(__polyspace_no_NR_TYPES)
#include <linux/keyboard.h>
#undef NR_TYPES
  extern const int NR_TYPES;
#endif

#if defined(__polyspace_max_vals) && !defined(__polyspace_no_max_vals)
#include <linux/keyboard.h>
#undef max_vals
  extern const int max_vals[];
#endif

#if defined(__polyspace_key_maps) && !defined(__polyspace_no_key_maps)
#include <linux/keyboard.h>
#undef key_maps
  extern unsigned short *key_maps[MAX_NR_KEYMAPS];
#endif

#if defined(__polyspace_plain_map) && !defined(__polyspace_no_plain_map)
#include <linux/keyboard.h>
#undef plain_map
  extern unsigned short plain_map[NR_KEYS];
#endif

#if defined(__polyspace_keypress_wait) && !defined(__polyspace_no_keypress_wait)
#include <linux/keyboard.h>
#undef keypress_wait
  extern struct wait_queue * keypress_wait;
#endif

#if defined(__polyspace_keyboard_type) && !defined(__polyspace_no_keyboard_type)
#include <linux/keyboard.h>
#undef keyboard_type
  extern unsigned char keyboard_type;
#endif

#if defined(__polyspace_nlmsvc_ops) && !defined(__polyspace_no_nlmsvc_ops)
#include <linux/lockd/bind.h>
#undef nlmsvc_ops
  extern struct nlmsvc_binding * nlmsvc_ops;
#endif

#if defined(__polyspace_nlm_program) && !defined(__polyspace_no_nlm_program)
#include <linux/lockd/lockd.h>
#undef nlm_program
  extern struct rpc_program nlm_program;
#endif

#if defined(__polyspace_nlmsvc_procedures) && !defined(__polyspace_no_nlmsvc_procedures)
#include <linux/lockd/lockd.h>
#undef nlmsvc_procedures
  extern struct svc_procedure nlmsvc_procedures[];
#endif

#if defined(__polyspace_nlmsvc_grace_period) && !defined(__polyspace_no_nlmsvc_grace_period)
#include <linux/lockd/lockd.h>
#undef nlmsvc_grace_period
  extern unsigned long nlmsvc_grace_period;
#endif

#if defined(__polyspace_nlmsvc_timeout) && !defined(__polyspace_no_nlmsvc_timeout)
#include <linux/lockd/lockd.h>
#undef nlmsvc_timeout
  extern unsigned long nlmsvc_timeout;
#endif

#if defined(__polyspace_nsm_local_state) && !defined(__polyspace_no_nsm_local_state)
#include <linux/lockd/sm_inter.h>
#undef nsm_local_state
  extern u32 nsm_local_state;
#endif

#if defined(__polyspace_nlm_granted) && !defined(__polyspace_no_nlm_granted)
#include <linux/lockd/xdr.h>
#undef nlm_granted
  extern u32 nlm_granted;
#endif

#if defined(__polyspace_nlm_lck_denied) && !defined(__polyspace_no_nlm_lck_denied)
#include <linux/lockd/xdr.h>
#undef nlm_lck_denied
  extern u32 nlm_lck_denied;
#endif

#if defined(__polyspace_nlm_lck_denied_nolocks) && !defined(__polyspace_no_nlm_lck_denied_nolocks)
#include <linux/lockd/xdr.h>
#undef nlm_lck_denied_nolocks
  extern u32 nlm_lck_denied_nolocks;
#endif

#if defined(__polyspace_nlm_lck_blocked) && !defined(__polyspace_no_nlm_lck_blocked)
#include <linux/lockd/xdr.h>
#undef nlm_lck_blocked
  extern u32 nlm_lck_blocked;
#endif

#if defined(__polyspace_nlm_lck_denied_grace_period) && !defined(__polyspace_no_nlm_lck_denied_grace_period)
#include <linux/lockd/xdr.h>
#undef nlm_lck_denied_grace_period
  extern u32 nlm_lck_denied_grace_period;
#endif

#if defined(__polyspace_lp_table) && !defined(__polyspace_no_lp_table)
#include <linux/lp_m68k.h>
#undef lp_table
  extern struct lp_struct *lp_table[MAX_LP];
#endif

#if defined(__polyspace_lp_irq) && !defined(__polyspace_no_lp_irq)
#include <linux/lp_m68k.h>
#undef lp_irq
  extern unsigned int lp_irq;
#endif

#if defined(__polyspace_minix_file_inode_operations) && !defined(__polyspace_no_minix_file_inode_operations)
#include <linux/minix_fs.h>
#undef minix_file_inode_operations
  extern struct inode_operations minix_file_inode_operations;
#endif

#if defined(__polyspace_minix_dir_inode_operations) && !defined(__polyspace_no_minix_dir_inode_operations)
#include <linux/minix_fs.h>
#undef minix_dir_inode_operations
  extern struct inode_operations minix_dir_inode_operations;
#endif

#if defined(__polyspace_minix_symlink_inode_operations) && !defined(__polyspace_no_minix_symlink_inode_operations)
#include <linux/minix_fs.h>
#undef minix_symlink_inode_operations
  extern struct inode_operations minix_symlink_inode_operations;
#endif

#if defined(__polyspace_minix_dentry_operations) && !defined(__polyspace_no_minix_dentry_operations)
#include <linux/minix_fs.h>
#undef minix_dentry_operations
  extern struct dentry_operations minix_dentry_operations;
#endif

#if defined(__polyspace_max_mapnr) && !defined(__polyspace_no_max_mapnr)
#include <linux/mm.h>
#undef max_mapnr
  extern unsigned long max_mapnr;
#endif

#if defined(__polyspace_num_physpages) && !defined(__polyspace_no_num_physpages)
#include <linux/mm.h>
#undef num_physpages
  extern unsigned long num_physpages;
#endif

#if defined(__polyspace_high_memory) && !defined(__polyspace_no_high_memory)
#include <linux/mm.h>
#undef high_memory
  extern void * high_memory;
#endif

#if defined(__polyspace_page_cluster) && !defined(__polyspace_no_page_cluster)
#include <linux/mm.h>
#undef page_cluster
  extern int page_cluster;
#endif

#if defined(__polyspace_protection_map) && !defined(__polyspace_no_protection_map)
#include <linux/mm.h>
#undef protection_map
  extern pgprot_t protection_map[16];
#endif

#if defined(__polyspace_mem_map) && !defined(__polyspace_no_mem_map)
#include <linux/mm.h>
#undef mem_map
  extern mem_map_t * mem_map;
#endif

#if defined(__polyspace_low_on_memory) && !defined(__polyspace_no_low_on_memory)
#include <linux/mm.h>
#undef low_on_memory
  extern int low_on_memory;
#endif

#if defined(__polyspace_pgt_cache_water) && !defined(__polyspace_no_pgt_cache_water)
#include <linux/mm.h>
#undef pgt_cache_water
  extern int pgt_cache_water[2];
#endif

#if defined(__polyspace___this_module) && !defined(__polyspace_no___this_module)
#include <linux/module.h>
#undef __this_module
  extern struct module __this_module;
#endif

#if defined(__polyspace_module_list) && !defined(__polyspace_no_module_list)
#include <linux/module.h>
#undef module_list
  extern struct module *module_list;
#endif

#if defined(__polyspace_mroute_socket) && !defined(__polyspace_no_mroute_socket)
#include <linux/mroute.h>
#undef mroute_socket
  extern struct sock *mroute_socket;
#endif

#if defined(__polyspace_fat_dir_operations) && !defined(__polyspace_no_fat_dir_operations)
#include <linux/msdos_fs.h>
#undef fat_dir_operations
  extern struct file_operations fat_dir_operations;
#endif

#if defined(__polyspace_fat_file_inode_operations) && !defined(__polyspace_no_fat_file_inode_operations)
#include <linux/msdos_fs.h>
#undef fat_file_inode_operations
  extern struct inode_operations fat_file_inode_operations;
#endif

#if defined(__polyspace_fat_file_inode_operations_1024) && !defined(__polyspace_no_fat_file_inode_operations_1024)
#include <linux/msdos_fs.h>
#undef fat_file_inode_operations_1024
  extern struct inode_operations fat_file_inode_operations_1024;
#endif

#if defined(__polyspace_fat_file_inode_operations_readpage) && !defined(__polyspace_no_fat_file_inode_operations_readpage)
#include <linux/msdos_fs.h>
#undef fat_file_inode_operations_readpage
  extern struct inode_operations fat_file_inode_operations_readpage;
#endif

#if defined(__polyspace_msdos_fs_type) && !defined(__polyspace_no_msdos_fs_type)
#include <linux/msdos_fs.h>
#undef msdos_fs_type
  extern struct file_system_type msdos_fs_type;
#endif

#if defined(__polyspace_fat_uni2esc) && !defined(__polyspace_no_fat_uni2esc)
#include <linux/msdos_fs.h>
#undef fat_uni2esc
  extern unsigned char fat_uni2esc[];
#endif

#if defined(__polyspace_fat_esc2uni) && !defined(__polyspace_no_fat_esc2uni)
#include <linux/msdos_fs.h>
#undef fat_esc2uni
  extern unsigned char fat_esc2uni[];
#endif

#if defined(__polyspace_vfat_fs_type) && !defined(__polyspace_no_vfat_fs_type)
#include <linux/msdos_fs.h>
#undef vfat_fs_type
  extern struct file_system_type vfat_fs_type;
#endif

#if defined(__polyspace_requests_in) && !defined(__polyspace_no_requests_in)
#include <linux/nbd.h>
#undef requests_in
  extern int requests_in;
#endif

#if defined(__polyspace_requests_out) && !defined(__polyspace_no_requests_out)
#include <linux/nbd.h>
#undef requests_out
  extern int requests_out;
#endif

#if defined(__polyspace_ncp_malloced) && !defined(__polyspace_no_ncp_malloced)
#include <linux/ncp_fs.h>
#undef ncp_malloced
  extern int ncp_malloced;
#endif

#if defined(__polyspace_ncp_current_malloced) && !defined(__polyspace_no_ncp_current_malloced)
#include <linux/ncp_fs.h>
#undef ncp_current_malloced
  extern int ncp_current_malloced;
#endif

#if defined(__polyspace_ncp_dir_inode_operations) && !defined(__polyspace_no_ncp_dir_inode_operations)
#include <linux/ncp_fs.h>
#undef ncp_dir_inode_operations
  extern struct inode_operations ncp_dir_inode_operations;
#endif

#if defined(__polyspace_ncp_file_inode_operations) && !defined(__polyspace_no_ncp_file_inode_operations)
#include <linux/ncp_fs.h>
#undef ncp_file_inode_operations
  extern struct inode_operations ncp_file_inode_operations;
#endif

#if defined(__polyspace_net_families) && !defined(__polyspace_no_net_families)
#include <linux/net.h>
#undef net_families
  extern struct net_proto_family *net_families[];
#endif

#if defined(__polyspace_if_port_text) && !defined(__polyspace_no_if_port_text)
#include <linux/netdevice.h>
#undef if_port_text
  extern const char *if_port_text[];
#endif

#if defined(__polyspace_loopback_dev) && !defined(__polyspace_no_loopback_dev)
#include <linux/netdevice.h>
#undef loopback_dev
  extern struct device loopback_dev;
#endif

#if defined(__polyspace_dev_base) && !defined(__polyspace_no_dev_base)
#include <linux/netdevice.h>
#undef dev_base
  extern struct device *dev_base;
#endif

#if defined(__polyspace_ptype_base) && !defined(__polyspace_no_ptype_base)
#include <linux/netdevice.h>
#undef ptype_base
  extern struct packet_type *ptype_base[16];
#endif

#if defined(__polyspace_netdev_dropping) && !defined(__polyspace_no_netdev_dropping)
#include <linux/netdevice.h>
#undef netdev_dropping
  extern int netdev_dropping;
#endif

#if defined(__polyspace_net_cpu_congestion) && !defined(__polyspace_no_net_cpu_congestion)
#include <linux/netdevice.h>
#undef net_cpu_congestion
  extern int net_cpu_congestion;
#endif

#if defined(__polyspace_netdev_nit) && !defined(__polyspace_no_netdev_nit)
#include <linux/netdevice.h>
#undef netdev_nit
  extern int netdev_nit;
#endif

#if defined(__polyspace_dev_lockct) && !defined(__polyspace_no_dev_lockct)
#include <linux/netdevice.h>
#undef dev_lockct
  extern atomic_t dev_lockct;
#endif

#if defined(__polyspace_netdev_max_backlog) && !defined(__polyspace_no_netdev_max_backlog)
#include <linux/netdevice.h>
#undef netdev_max_backlog
  extern int netdev_max_backlog;
#endif

#if defined(__polyspace_netdev_rx_dropped) && !defined(__polyspace_no_netdev_rx_dropped)
#include <linux/netdevice.h>
#undef netdev_rx_dropped
  extern atomic_t netdev_rx_dropped;
#endif

#if defined(__polyspace_netdev_fc_xoff) && !defined(__polyspace_no_netdev_fc_xoff)
#include <linux/netdevice.h>
#undef netdev_fc_xoff
  extern unsigned long netdev_fc_xoff;
#endif

#if defined(__polyspace_netdev_fastroute) && !defined(__polyspace_no_netdev_fastroute)
#include <linux/netdevice.h>
#undef netdev_fastroute
  extern int netdev_fastroute;
#endif

#if defined(__polyspace_netdev_fastroute_obstacles) && !defined(__polyspace_no_netdev_fastroute_obstacles)
#include <linux/netdevice.h>
#undef netdev_fastroute_obstacles
  extern int netdev_fastroute_obstacles;
#endif

#if defined(__polyspace_dev_fastroute_stat) && !defined(__polyspace_no_dev_fastroute_stat)
#include <linux/netdevice.h>
#undef dev_fastroute_stat
  extern struct net_fastroute_stats dev_fastroute_stat;
#endif

#if defined(__polyspace_nfs_program) && !defined(__polyspace_no_nfs_program)
#include <linux/nfs.h>
#undef nfs_program
  extern struct rpc_program nfs_program;
#endif

#if defined(__polyspace_nfs_rpcstat) && !defined(__polyspace_no_nfs_rpcstat)
#include <linux/nfs.h>
#undef nfs_rpcstat
  extern struct rpc_stat nfs_rpcstat;
#endif

#if defined(__polyspace_nfs_file_inode_operations) && !defined(__polyspace_no_nfs_file_inode_operations)
#include <linux/nfs_fs.h>
#undef nfs_file_inode_operations
  extern struct inode_operations nfs_file_inode_operations;
#endif

#if defined(__polyspace_nfs_dir_inode_operations) && !defined(__polyspace_no_nfs_dir_inode_operations)
#include <linux/nfs_fs.h>
#undef nfs_dir_inode_operations
  extern struct inode_operations nfs_dir_inode_operations;
#endif

#if defined(__polyspace_nfs_dentry_operations) && !defined(__polyspace_no_nfs_dentry_operations)
#include <linux/nfs_fs.h>
#undef nfs_dentry_operations
  extern struct dentry_operations nfs_dentry_operations;
#endif

#if defined(__polyspace_nfs_symlink_inode_operations) && !defined(__polyspace_no_nfs_symlink_inode_operations)
#include <linux/nfs_fs.h>
#undef nfs_symlink_inode_operations
  extern struct inode_operations nfs_symlink_inode_operations;
#endif

#if defined(__polyspace_nfsd_procedures2) && !defined(__polyspace_no_nfsd_procedures2)
#include <linux/nfsd/nfsd.h>
#undef nfsd_procedures2
  extern struct svc_procedure nfsd_procedures2[];
#endif

#if defined(__polyspace_nfsd_program) && !defined(__polyspace_no_nfsd_program)
#include <linux/nfsd/nfsd.h>
#undef nfsd_program
  extern struct svc_program nfsd_program;
#endif

#if defined(__polyspace_nfs_ok) && !defined(__polyspace_no_nfs_ok)
#include <linux/nfsd/nfsd.h>
#undef nfs_ok
  extern u32 nfs_ok;
#endif

#if defined(__polyspace_nfserr_perm) && !defined(__polyspace_no_nfserr_perm)
#include <linux/nfsd/nfsd.h>
#undef nfserr_perm
  extern u32 nfserr_perm;
#endif

#if defined(__polyspace_nfserr_noent) && !defined(__polyspace_no_nfserr_noent)
#include <linux/nfsd/nfsd.h>
#undef nfserr_noent
  extern u32 nfserr_noent;
#endif

#if defined(__polyspace_nfserr_io) && !defined(__polyspace_no_nfserr_io)
#include <linux/nfsd/nfsd.h>
#undef nfserr_io
  extern u32 nfserr_io;
#endif

#if defined(__polyspace_nfserr_nxio) && !defined(__polyspace_no_nfserr_nxio)
#include <linux/nfsd/nfsd.h>
#undef nfserr_nxio
  extern u32 nfserr_nxio;
#endif

#if defined(__polyspace_nfserr_acces) && !defined(__polyspace_no_nfserr_acces)
#include <linux/nfsd/nfsd.h>
#undef nfserr_acces
  extern u32 nfserr_acces;
#endif

#if defined(__polyspace_nfserr_exist) && !defined(__polyspace_no_nfserr_exist)
#include <linux/nfsd/nfsd.h>
#undef nfserr_exist
  extern u32 nfserr_exist;
#endif

#if defined(__polyspace_nfserr_xdev) && !defined(__polyspace_no_nfserr_xdev)
#include <linux/nfsd/nfsd.h>
#undef nfserr_xdev
  extern u32 nfserr_xdev;
#endif

#if defined(__polyspace_nfserr_nodev) && !defined(__polyspace_no_nfserr_nodev)
#include <linux/nfsd/nfsd.h>
#undef nfserr_nodev
  extern u32 nfserr_nodev;
#endif

#if defined(__polyspace_nfserr_notdir) && !defined(__polyspace_no_nfserr_notdir)
#include <linux/nfsd/nfsd.h>
#undef nfserr_notdir
  extern u32 nfserr_notdir;
#endif

#if defined(__polyspace_nfserr_isdir) && !defined(__polyspace_no_nfserr_isdir)
#include <linux/nfsd/nfsd.h>
#undef nfserr_isdir
  extern u32 nfserr_isdir;
#endif

#if defined(__polyspace_nfserr_inval) && !defined(__polyspace_no_nfserr_inval)
#include <linux/nfsd/nfsd.h>
#undef nfserr_inval
  extern u32 nfserr_inval;
#endif

#if defined(__polyspace_nfserr_fbig) && !defined(__polyspace_no_nfserr_fbig)
#include <linux/nfsd/nfsd.h>
#undef nfserr_fbig
  extern u32 nfserr_fbig;
#endif

#if defined(__polyspace_nfserr_nospc) && !defined(__polyspace_no_nfserr_nospc)
#include <linux/nfsd/nfsd.h>
#undef nfserr_nospc
  extern u32 nfserr_nospc;
#endif

#if defined(__polyspace_nfserr_rofs) && !defined(__polyspace_no_nfserr_rofs)
#include <linux/nfsd/nfsd.h>
#undef nfserr_rofs
  extern u32 nfserr_rofs;
#endif

#if defined(__polyspace_nfserr_mlink) && !defined(__polyspace_no_nfserr_mlink)
#include <linux/nfsd/nfsd.h>
#undef nfserr_mlink
  extern u32 nfserr_mlink;
#endif

#if defined(__polyspace_nfserr_nametoolong) && !defined(__polyspace_no_nfserr_nametoolong)
#include <linux/nfsd/nfsd.h>
#undef nfserr_nametoolong
  extern u32 nfserr_nametoolong;
#endif

#if defined(__polyspace_nfserr_dquot) && !defined(__polyspace_no_nfserr_dquot)
#include <linux/nfsd/nfsd.h>
#undef nfserr_dquot
  extern u32 nfserr_dquot;
#endif

#if defined(__polyspace_nfserr_stale) && !defined(__polyspace_no_nfserr_stale)
#include <linux/nfsd/nfsd.h>
#undef nfserr_stale
  extern u32 nfserr_stale;
#endif

#if defined(__polyspace_nfserr_remote) && !defined(__polyspace_no_nfserr_remote)
#include <linux/nfsd/nfsd.h>
#undef nfserr_remote
  extern u32 nfserr_remote;
#endif

#if defined(__polyspace_nfserr_badhandle) && !defined(__polyspace_no_nfserr_badhandle)
#include <linux/nfsd/nfsd.h>
#undef nfserr_badhandle
  extern u32 nfserr_badhandle;
#endif

#if defined(__polyspace_nfserr_notsync) && !defined(__polyspace_no_nfserr_notsync)
#include <linux/nfsd/nfsd.h>
#undef nfserr_notsync
  extern u32 nfserr_notsync;
#endif

#if defined(__polyspace_nfserr_badcookie) && !defined(__polyspace_no_nfserr_badcookie)
#include <linux/nfsd/nfsd.h>
#undef nfserr_badcookie
  extern u32 nfserr_badcookie;
#endif

#if defined(__polyspace_nfserr_notsupp) && !defined(__polyspace_no_nfserr_notsupp)
#include <linux/nfsd/nfsd.h>
#undef nfserr_notsupp
  extern u32 nfserr_notsupp;
#endif

#if defined(__polyspace_nfserr_toosmall) && !defined(__polyspace_no_nfserr_toosmall)
#include <linux/nfsd/nfsd.h>
#undef nfserr_toosmall
  extern u32 nfserr_toosmall;
#endif

#if defined(__polyspace_nfserr_serverfault) && !defined(__polyspace_no_nfserr_serverfault)
#include <linux/nfsd/nfsd.h>
#undef nfserr_serverfault
  extern u32 nfserr_serverfault;
#endif

#if defined(__polyspace_nfserr_badtype) && !defined(__polyspace_no_nfserr_badtype)
#include <linux/nfsd/nfsd.h>
#undef nfserr_badtype
  extern u32 nfserr_badtype;
#endif

#if defined(__polyspace_nfserr_jukebox) && !defined(__polyspace_no_nfserr_jukebox)
#include <linux/nfsd/nfsd.h>
#undef nfserr_jukebox
  extern u32 nfserr_jukebox;
#endif

#if defined(__polyspace_nfssvc_boot) && !defined(__polyspace_no_nfssvc_boot)
#include <linux/nfsd/nfsd.h>
#undef nfssvc_boot
  extern struct timeval nfssvc_boot;
#endif

#if defined(__polyspace_nfsd_nservers) && !defined(__polyspace_no_nfsd_nservers)
#include <linux/nfsd/nfsd.h>
#undef nfsd_nservers
  extern int nfsd_nservers;
#endif

#if defined(__polyspace_nfsdstats) && !defined(__polyspace_no_nfsdstats)
#include <linux/nfsd/stats.h>
#undef nfsdstats
  extern struct nfsd_stats nfsdstats;
#endif

#if defined(__polyspace_nfsd_svcstats) && !defined(__polyspace_no_nfsd_svcstats)
#include <linux/nfsd/stats.h>
#undef nfsd_svcstats
  extern struct svc_stat nfsd_svcstats;
#endif

#if defined(__polyspace_boot_notifier_list) && !defined(__polyspace_no_boot_notifier_list)
#include <linux/notifier.h>
#undef boot_notifier_list
  extern struct notifier_block *boot_notifier_list;
#endif

#if defined(__polyspace_OpenPIC) && !defined(__polyspace_no_OpenPIC)
#include <linux/openpic.h>
#undef OpenPIC
  extern volatile struct OpenPIC *OpenPIC;
#endif

#if defined(__polyspace_OpenPIC_NumInitSenses) && !defined(__polyspace_no_OpenPIC_NumInitSenses)
#include <linux/openpic.h>
#undef OpenPIC_NumInitSenses
  extern u_int OpenPIC_NumInitSenses;
#endif

#if defined(__polyspace_OpenPIC_InitSenses) && !defined(__polyspace_no_OpenPIC_InitSenses)
#include <linux/openpic.h>
#undef OpenPIC_InitSenses
  extern u_char *OpenPIC_InitSenses;
#endif

#if defined(__polyspace_page_cache_size) && !defined(__polyspace_no_page_cache_size)
#include <linux/pagemap.h>
#undef page_cache_size
  extern unsigned long page_cache_size;
#endif

#if defined(__polyspace_page_hash_bits) && !defined(__polyspace_no_page_hash_bits)
#include <linux/pagemap.h>
#undef page_hash_bits
  extern unsigned int page_hash_bits;
#endif

#if defined(__polyspace_page_hash_mask) && !defined(__polyspace_no_page_hash_mask)
#include <linux/pagemap.h>
#undef page_hash_mask
  extern unsigned int page_hash_mask;
#endif

#if defined(__polyspace_page_hash_table) && !defined(__polyspace_no_page_hash_table)
#include <linux/pagemap.h>
#undef page_hash_table
  extern struct page **page_hash_table;
#endif

#if defined(__polyspace_parport_pc_ctr) && !defined(__polyspace_no_parport_pc_ctr)
#include <linux/parport_pc.h>
#undef parport_pc_ctr
  extern volatile unsigned char parport_pc_ctr;
#endif

#if defined(__polyspace_pckbd_read_mask) && !defined(__polyspace_no_pckbd_read_mask)
#include <linux/pc_keyb.h>
#undef pckbd_read_mask
  extern unsigned char pckbd_read_mask;
#endif

#if defined(__polyspace_aux_device_present) && !defined(__polyspace_no_aux_device_present)
#include <linux/pc_keyb.h>
#undef aux_device_present
  extern unsigned char aux_device_present;
#endif

#if defined(__polyspace_pci_root) && !defined(__polyspace_no_pci_root)
#include <linux/pci.h>
#undef pci_root
  extern struct pci_bus pci_root;
#endif

#if defined(__polyspace_pci_devices) && !defined(__polyspace_no_pci_devices)
#include <linux/pci.h>
#undef pci_devices
  extern struct pci_dev *pci_devices;
#endif

#if defined(__polyspace_default_exec_domain) && !defined(__polyspace_no_default_exec_domain)
#include <linux/personality.h>
#undef default_exec_domain
  extern struct exec_domain default_exec_domain;
#endif

#if defined(__polyspace_proc_root) && !defined(__polyspace_no_proc_root)
#include <linux/proc_fs.h>
#undef proc_root
  extern struct proc_dir_entry proc_root;
#endif

#if defined(__polyspace_proc_root_fs) && !defined(__polyspace_no_proc_root_fs)
#include <linux/proc_fs.h>
#undef proc_root_fs
  extern struct proc_dir_entry proc_root_fs;
#endif

#if defined(__polyspace_proc_net) && !defined(__polyspace_no_proc_net)
#include <linux/proc_fs.h>
#undef proc_net
  extern struct proc_dir_entry *proc_net;
#endif

#if defined(__polyspace_proc_scsi) && !defined(__polyspace_no_proc_scsi)
#include <linux/proc_fs.h>
#undef proc_scsi
  extern struct proc_dir_entry *proc_scsi;
#endif

#if defined(__polyspace_proc_sys) && !defined(__polyspace_no_proc_sys)
#include <linux/proc_fs.h>
#undef proc_sys
  extern struct proc_dir_entry proc_sys;
#endif

#if defined(__polyspace_proc_openprom) && !defined(__polyspace_no_proc_openprom)
#include <linux/proc_fs.h>
#undef proc_openprom
  extern struct proc_dir_entry proc_openprom;
#endif

#if defined(__polyspace_proc_pid) && !defined(__polyspace_no_proc_pid)
#include <linux/proc_fs.h>
#undef proc_pid
  extern struct proc_dir_entry proc_pid;
#endif

#if defined(__polyspace_proc_pid_fd) && !defined(__polyspace_no_proc_pid_fd)
#include <linux/proc_fs.h>
#undef proc_pid_fd
  extern struct proc_dir_entry proc_pid_fd;
#endif

#if defined(__polyspace_proc_mca) && !defined(__polyspace_no_proc_mca)
#include <linux/proc_fs.h>
#undef proc_mca
  extern struct proc_dir_entry proc_mca;
#endif

#if defined(__polyspace_proc_bus) && !defined(__polyspace_no_proc_bus)
#include <linux/proc_fs.h>
#undef proc_bus
  extern struct proc_dir_entry *proc_bus;
#endif

#if defined(__polyspace_proc_scsi_inode_operations) && !defined(__polyspace_no_proc_scsi_inode_operations)
#include <linux/proc_fs.h>
#undef proc_scsi_inode_operations
  extern struct inode_operations proc_scsi_inode_operations;
#endif

#if defined(__polyspace_proc_dentry_operations) && !defined(__polyspace_no_proc_dentry_operations)
#include <linux/proc_fs.h>
#undef proc_dentry_operations
  extern struct dentry_operations proc_dentry_operations;
#endif

#if defined(__polyspace_proc_dir_inode_operations) && !defined(__polyspace_no_proc_dir_inode_operations)
#include <linux/proc_fs.h>
#undef proc_dir_inode_operations
  extern struct inode_operations proc_dir_inode_operations;
#endif

#if defined(__polyspace_proc_file_inode_operations) && !defined(__polyspace_no_proc_file_inode_operations)
#include <linux/proc_fs.h>
#undef proc_file_inode_operations
  extern struct inode_operations proc_file_inode_operations;
#endif

#if defined(__polyspace_proc_net_inode_operations) && !defined(__polyspace_no_proc_net_inode_operations)
#include <linux/proc_fs.h>
#undef proc_net_inode_operations
  extern struct inode_operations proc_net_inode_operations;
#endif

#if defined(__polyspace_proc_netdir_inode_operations) && !defined(__polyspace_no_proc_netdir_inode_operations)
#include <linux/proc_fs.h>
#undef proc_netdir_inode_operations
  extern struct inode_operations proc_netdir_inode_operations;
#endif

#if defined(__polyspace_proc_openprom_inode_operations) && !defined(__polyspace_no_proc_openprom_inode_operations)
#include <linux/proc_fs.h>
#undef proc_openprom_inode_operations
  extern struct inode_operations proc_openprom_inode_operations;
#endif

#if defined(__polyspace_proc_mem_inode_operations) && !defined(__polyspace_no_proc_mem_inode_operations)
#include <linux/proc_fs.h>
#undef proc_mem_inode_operations
  extern struct inode_operations proc_mem_inode_operations;
#endif

#if defined(__polyspace_proc_sys_inode_operations) && !defined(__polyspace_no_proc_sys_inode_operations)
#include <linux/proc_fs.h>
#undef proc_sys_inode_operations
  extern struct inode_operations proc_sys_inode_operations;
#endif

#if defined(__polyspace_proc_array_inode_operations) && !defined(__polyspace_no_proc_array_inode_operations)
#include <linux/proc_fs.h>
#undef proc_array_inode_operations
  extern struct inode_operations proc_array_inode_operations;
#endif

#if defined(__polyspace_proc_arraylong_inode_operations) && !defined(__polyspace_no_proc_arraylong_inode_operations)
#include <linux/proc_fs.h>
#undef proc_arraylong_inode_operations
  extern struct inode_operations proc_arraylong_inode_operations;
#endif

#if defined(__polyspace_proc_kcore_inode_operations) && !defined(__polyspace_no_proc_kcore_inode_operations)
#include <linux/proc_fs.h>
#undef proc_kcore_inode_operations
  extern struct inode_operations proc_kcore_inode_operations;
#endif

#if defined(__polyspace_proc_profile_inode_operations) && !defined(__polyspace_no_proc_profile_inode_operations)
#include <linux/proc_fs.h>
#undef proc_profile_inode_operations
  extern struct inode_operations proc_profile_inode_operations;
#endif

#if defined(__polyspace_proc_kmsg_inode_operations) && !defined(__polyspace_no_proc_kmsg_inode_operations)
#include <linux/proc_fs.h>
#undef proc_kmsg_inode_operations
  extern struct inode_operations proc_kmsg_inode_operations;
#endif

#if defined(__polyspace_proc_link_inode_operations) && !defined(__polyspace_no_proc_link_inode_operations)
#include <linux/proc_fs.h>
#undef proc_link_inode_operations
  extern struct inode_operations proc_link_inode_operations;
#endif

#if defined(__polyspace_proc_fd_inode_operations) && !defined(__polyspace_no_proc_fd_inode_operations)
#include <linux/proc_fs.h>
#undef proc_fd_inode_operations
  extern struct inode_operations proc_fd_inode_operations;
#endif

#if defined(__polyspace_proc_ringbuf_inode_operations) && !defined(__polyspace_no_proc_ringbuf_inode_operations)
#include <linux/proc_fs.h>
#undef proc_ringbuf_inode_operations
  extern struct inode_operations proc_ringbuf_inode_operations;
#endif

#if defined(__polyspace_proc_omirr_inode_operations) && !defined(__polyspace_no_proc_omirr_inode_operations)
#include <linux/proc_fs.h>
#undef proc_omirr_inode_operations
  extern struct inode_operations proc_omirr_inode_operations;
#endif

#if defined(__polyspace_proc_ppc_htab_inode_operations) && !defined(__polyspace_no_proc_ppc_htab_inode_operations)
#include <linux/proc_fs.h>
#undef proc_ppc_htab_inode_operations
  extern struct inode_operations proc_ppc_htab_inode_operations;
#endif

#if defined(__polyspace_qnx4_file_inode_operations) && !defined(__polyspace_no_qnx4_file_inode_operations)
#include <linux/qnx4_fs.h>
#undef qnx4_file_inode_operations
  extern struct inode_operations qnx4_file_inode_operations;
#endif

#if defined(__polyspace_qnx4_dir_inode_operations) && !defined(__polyspace_no_qnx4_dir_inode_operations)
#include <linux/qnx4_fs.h>
#undef qnx4_dir_inode_operations
  extern struct inode_operations qnx4_dir_inode_operations;
#endif

#if defined(__polyspace_qnx4_symlink_inode_operations) && !defined(__polyspace_no_qnx4_symlink_inode_operations)
#include <linux/qnx4_fs.h>
#undef qnx4_symlink_inode_operations
  extern struct inode_operations qnx4_symlink_inode_operations;
#endif

#if defined(__polyspace_nr_dquots) && !defined(__polyspace_no_nr_dquots)
#include <linux/quota.h>
#undef nr_dquots
  extern int nr_dquots;
#endif

#if defined(__polyspace_nr_free_dquots) && !defined(__polyspace_no_nr_free_dquots)
#include <linux/quota.h>
#undef nr_free_dquots
  extern int nr_free_dquots;
#endif

#if defined(__polyspace_max_dquots) && !defined(__polyspace_no_max_dquots)
#include <linux/quota.h>
#undef max_dquots
  extern int max_dquots;
#endif

#if defined(__polyspace_dquot_root_squash) && !defined(__polyspace_no_dquot_root_squash)
#include <linux/quota.h>
#undef dquot_root_squash
  extern int dquot_root_squash;
#endif

#if defined(__polyspace_md_size) && !defined(__polyspace_no_md_size)
#include <linux/raid/md.h>
#undef md_size
  extern int md_size[MAX_MD_DEVS];
#endif

#if defined(__polyspace_md_hd_struct) && !defined(__polyspace_no_md_hd_struct)
#include <linux/raid/md.h>
#undef md_hd_struct
  extern struct hd_struct md_hd_struct[MAX_MD_DEVS];
#endif

#if defined(__polyspace_random_fops) && !defined(__polyspace_no_random_fops)
#include <linux/random.h>
#undef random_fops
  extern struct file_operations random_fops;
#endif

#if defined(__polyspace_urandom_fops) && !defined(__polyspace_no_urandom_fops)
#include <linux/random.h>
#undef urandom_fops
  extern struct file_operations urandom_fops;
#endif

#if defined(__polyspace_reboot_notifier_list) && !defined(__polyspace_no_reboot_notifier_list)
#include <linux/reboot.h>
#undef reboot_notifier_list
  extern struct notifier_block *reboot_notifier_list;
#endif

#if defined(__polyspace_rtnl_rlockct) && !defined(__polyspace_no_rtnl_rlockct)
#include <linux/rtnetlink.h>
#undef rtnl_rlockct
  extern atomic_t rtnl_rlockct;
#endif

#if defined(__polyspace_rtnl_wait) && !defined(__polyspace_no_rtnl_wait)
#include <linux/rtnetlink.h>
#undef rtnl_wait
  extern struct wait_queue *rtnl_wait;
#endif

#if defined(__polyspace_rtnl) && !defined(__polyspace_no_rtnl)
#include <linux/rtnetlink.h>
#undef rtnl
  extern struct sock *rtnl;
#endif

#if defined(__polyspace_rtnetlink_links) && !defined(__polyspace_no_rtnetlink_links)
#include <linux/rtnetlink.h>
#undef rtnetlink_links
  extern struct rtnetlink_link * rtnetlink_links[NPROTO];
#endif

#if defined(__polyspace_rtnl_wlockct) && !defined(__polyspace_no_rtnl_wlockct)
#include <linux/rtnetlink.h>
#undef rtnl_wlockct
  extern unsigned long rtnl_wlockct;
#endif

#if defined(__polyspace_global_event) && !defined(__polyspace_no_global_event)
#include <linux/sched.h>
#undef global_event
  extern unsigned long global_event;
#endif

#if defined(__polyspace_avenrun) && !defined(__polyspace_no_avenrun)
#include <linux/sched.h>
#undef avenrun
  extern unsigned long avenrun[];
#endif

#if defined(__polyspace_nr_running) && !defined(__polyspace_no_nr_running)
#include <linux/sched.h>
#undef nr_running
  extern int nr_running;
#endif

#if defined(__polyspace_nr_tasks) && !defined(__polyspace_no_nr_tasks)
#include <linux/sched.h>
#undef nr_tasks
  extern int nr_tasks;
#endif

#if defined(__polyspace_last_pid) && !defined(__polyspace_no_last_pid)
#include <linux/sched.h>
#undef last_pid
  extern int last_pid;
#endif

#if defined(__polyspace_tasklist_lock) && !defined(__polyspace_no_tasklist_lock)
#include <linux/sched.h>
#undef tasklist_lock
  extern rwlock_t tasklist_lock;
#endif

#if defined(__polyspace_runqueue_lock) && !defined(__polyspace_no_runqueue_lock)
#include <linux/sched.h>
#undef runqueue_lock
  extern spinlock_t runqueue_lock;
#endif

#if defined(__polyspace_init_task_union) && !defined(__polyspace_no_init_task_union)
#include <linux/sched.h>
#undef init_task_union
  extern union task_union init_task_union;
#endif

#if defined(__polyspace_init_mm) && !defined(__polyspace_no_init_mm)
#include <linux/sched.h>
#undef init_mm
  extern struct mm_struct init_mm;
#endif

#if defined(__polyspace_task) && !defined(__polyspace_no_task)
#include <linux/sched.h>
#undef task
  extern struct task_struct *task[NR_TASKS];
#endif

#if defined(__polyspace_tarray_freelist) && !defined(__polyspace_no_tarray_freelist)
#include <linux/sched.h>
#undef tarray_freelist
  extern struct task_struct **tarray_freelist;
#endif

#if defined(__polyspace_taskslot_lock) && !defined(__polyspace_no_taskslot_lock)
#include <linux/sched.h>
#undef taskslot_lock
  extern spinlock_t taskslot_lock;
#endif

#if defined(__polyspace_pidhash) && !defined(__polyspace_no_pidhash)
#include <linux/sched.h>
#undef pidhash
  extern struct task_struct *pidhash[PIDHASH_SZ];
#endif

#if defined(__polyspace_jiffies) && !defined(__polyspace_no_jiffies)
#include <linux/sched.h>
#undef jiffies
  extern unsigned long volatile jiffies;
#endif

#if defined(__polyspace_itimer_ticks) && !defined(__polyspace_no_itimer_ticks)
#include <linux/sched.h>
#undef itimer_ticks
  extern unsigned long itimer_ticks;
#endif

#if defined(__polyspace_itimer_next) && !defined(__polyspace_no_itimer_next)
#include <linux/sched.h>
#undef itimer_next
  extern unsigned long itimer_next;
#endif

#if defined(__polyspace_xtime) && !defined(__polyspace_no_xtime)
#include <linux/sched.h>
#undef xtime
  extern struct timeval xtime;
#endif

#if defined(__polyspace_prof_buffer) && !defined(__polyspace_no_prof_buffer)
#include <linux/sched.h>
#undef prof_buffer
  extern unsigned int * prof_buffer;
#endif

#if defined(__polyspace_prof_len) && !defined(__polyspace_no_prof_len)
#include <linux/sched.h>
#undef prof_len
  extern unsigned long prof_len;
#endif

#if defined(__polyspace_prof_shift) && !defined(__polyspace_no_prof_shift)
#include <linux/sched.h>
#undef prof_shift
  extern unsigned long prof_shift;
#endif

#if defined(__polyspace_waitqueue_lock) && !defined(__polyspace_no_waitqueue_lock)
#include <linux/sched.h>
#undef waitqueue_lock
  extern rwlock_t waitqueue_lock;
#endif

#if defined(__polyspace_securebits) && !defined(__polyspace_no_securebits)
#include <linux/securebits.h>
#undef securebits
  extern unsigned securebits;
#endif

#if defined(__polyspace_sel_cons) && !defined(__polyspace_no_sel_cons)
#include <linux/selection.h>
#undef sel_cons
  extern int sel_cons;
#endif

#if defined(__polyspace_console_blanked) && !defined(__polyspace_no_console_blanked)
#include <linux/selection.h>
#undef console_blanked
  extern int console_blanked;
#endif

#if defined(__polyspace_color_table) && !defined(__polyspace_no_color_table)
#include <linux/selection.h>
#undef color_table
  extern unsigned char color_table[];
#endif

#if defined(__polyspace_default_red) && !defined(__polyspace_no_default_red)
#include <linux/selection.h>
#undef default_red
  extern int default_red[];
#endif

#if defined(__polyspace_default_grn) && !defined(__polyspace_no_default_grn)
#include <linux/selection.h>
#undef default_grn
  extern int default_grn[];
#endif

#if defined(__polyspace_default_blu) && !defined(__polyspace_no_default_blu)
#include <linux/selection.h>
#undef default_blu
  extern int default_blu[];
#endif

#if defined(__polyspace_skb_queue_lock) && !defined(__polyspace_no_skb_queue_lock)
#include <linux/skbuff.h>
#undef skb_queue_lock
  extern spinlock_t skb_queue_lock;
#endif

#if defined(__polyspace_vm_area_cachep) && !defined(__polyspace_no_vm_area_cachep)
#include <linux/slab.h>
#undef vm_area_cachep
  extern kmem_cache_t *vm_area_cachep;
#endif

#if defined(__polyspace_mm_cachep) && !defined(__polyspace_no_mm_cachep)
#include <linux/slab.h>
#undef mm_cachep
  extern kmem_cache_t *mm_cachep;
#endif

#if defined(__polyspace_smb_malloced) && !defined(__polyspace_no_smb_malloced)
#include <linux/smb_fs.h>
#undef smb_malloced
  extern int smb_malloced;
#endif

#if defined(__polyspace_smb_current_vmalloced) && !defined(__polyspace_no_smb_current_vmalloced)
#include <linux/smb_fs.h>
#undef smb_current_vmalloced
  extern int smb_current_vmalloced;
#endif

#if defined(__polyspace_smb_file_inode_operations) && !defined(__polyspace_no_smb_file_inode_operations)
#include <linux/smb_fs.h>
#undef smb_file_inode_operations
  extern struct inode_operations smb_file_inode_operations;
#endif

#if defined(__polyspace_smb_dir_inode_operations) && !defined(__polyspace_no_smb_dir_inode_operations)
#include <linux/smb_fs.h>
#undef smb_dir_inode_operations
  extern struct inode_operations smb_dir_inode_operations;
#endif

#if defined(__polyspace_smp_threads_ready) && !defined(__polyspace_no_smp_threads_ready)
#include <linux/smp.h>
#undef smp_threads_ready
  extern int smp_threads_ready;
#endif

#if defined(__polyspace_smp_num_cpus) && !defined(__polyspace_no_smp_num_cpus)
#include <linux/smp.h>
#undef smp_num_cpus
  extern int smp_num_cpus;
#endif

#if defined(__polyspace_smp_msg_data) && !defined(__polyspace_no_smp_msg_data)
#include <linux/smp.h>
#undef smp_msg_data
  extern volatile unsigned long smp_msg_data;
#endif

#if defined(__polyspace_smp_src_cpu) && !defined(__polyspace_no_smp_src_cpu)
#include <linux/smp.h>
#undef smp_src_cpu
  extern volatile int smp_src_cpu;
#endif

#if defined(__polyspace_smp_msg_id) && !defined(__polyspace_no_smp_msg_id)
#include <linux/smp.h>
#undef smp_msg_id
  extern volatile int smp_msg_id;
#endif

#if defined(__polyspace_authunix_ops) && !defined(__polyspace_no_authunix_ops)
#include <linux/sunrpc/auth.h>
#undef authunix_ops
  extern struct rpc_authops authunix_ops;
#endif

#if defined(__polyspace_authnull_ops) && !defined(__polyspace_no_authnull_ops)
#include <linux/sunrpc/auth.h>
#undef authnull_ops
  extern struct rpc_authops authnull_ops;
#endif

#if defined(__polyspace_authdes_ops) && !defined(__polyspace_no_authdes_ops)
#include <linux/sunrpc/auth.h>
#undef authdes_ops
  extern struct rpc_authops authdes_ops;
#endif

#if defined(__polyspace_rpc_debug) && !defined(__polyspace_no_rpc_debug)
#include <linux/sunrpc/debug.h>
#undef rpc_debug
  extern unsigned int rpc_debug;
#endif

#if defined(__polyspace_nfs_debug) && !defined(__polyspace_no_nfs_debug)
#include <linux/sunrpc/debug.h>
#undef nfs_debug
  extern unsigned int nfs_debug;
#endif

#if defined(__polyspace_nfsd_debug) && !defined(__polyspace_no_nfsd_debug)
#include <linux/sunrpc/debug.h>
#undef nfsd_debug
  extern unsigned int nfsd_debug;
#endif

#if defined(__polyspace_nlm_debug) && !defined(__polyspace_no_nlm_debug)
#include <linux/sunrpc/debug.h>
#undef nlm_debug
  extern unsigned int nlm_debug;
#endif

#if defined(__polyspace_xdr_zero) && !defined(__polyspace_no_xdr_zero)
#include <linux/sunrpc/xdr.h>
#undef xdr_zero
  extern u32 xdr_zero;
#endif

#if defined(__polyspace_xdr_one) && !defined(__polyspace_no_xdr_one)
#include <linux/sunrpc/xdr.h>
#undef xdr_one
  extern u32 xdr_one;
#endif

#if defined(__polyspace_xdr_two) && !defined(__polyspace_no_xdr_two)
#include <linux/sunrpc/xdr.h>
#undef xdr_two
  extern u32 xdr_two;
#endif

#if defined(__polyspace_rpc_success) && !defined(__polyspace_no_rpc_success)
#include <linux/sunrpc/xdr.h>
#undef rpc_success
  extern u32 rpc_success;
#endif

#if defined(__polyspace_rpc_prog_unavail) && !defined(__polyspace_no_rpc_prog_unavail)
#include <linux/sunrpc/xdr.h>
#undef rpc_prog_unavail
  extern u32 rpc_prog_unavail;
#endif

#if defined(__polyspace_rpc_prog_mismatch) && !defined(__polyspace_no_rpc_prog_mismatch)
#include <linux/sunrpc/xdr.h>
#undef rpc_prog_mismatch
  extern u32 rpc_prog_mismatch;
#endif

#if defined(__polyspace_rpc_proc_unavail) && !defined(__polyspace_no_rpc_proc_unavail)
#include <linux/sunrpc/xdr.h>
#undef rpc_proc_unavail
  extern u32 rpc_proc_unavail;
#endif

#if defined(__polyspace_rpc_garbage_args) && !defined(__polyspace_no_rpc_garbage_args)
#include <linux/sunrpc/xdr.h>
#undef rpc_garbage_args
  extern u32 rpc_garbage_args;
#endif

#if defined(__polyspace_rpc_system_err) && !defined(__polyspace_no_rpc_system_err)
#include <linux/sunrpc/xdr.h>
#undef rpc_system_err
  extern u32 rpc_system_err;
#endif

#if defined(__polyspace_rpc_auth_ok) && !defined(__polyspace_no_rpc_auth_ok)
#include <linux/sunrpc/xdr.h>
#undef rpc_auth_ok
  extern u32 rpc_auth_ok;
#endif

#if defined(__polyspace_rpc_autherr_badcred) && !defined(__polyspace_no_rpc_autherr_badcred)
#include <linux/sunrpc/xdr.h>
#undef rpc_autherr_badcred
  extern u32 rpc_autherr_badcred;
#endif

#if defined(__polyspace_rpc_autherr_rejectedcred) && !defined(__polyspace_no_rpc_autherr_rejectedcred)
#include <linux/sunrpc/xdr.h>
#undef rpc_autherr_rejectedcred
  extern u32 rpc_autherr_rejectedcred;
#endif

#if defined(__polyspace_rpc_autherr_badverf) && !defined(__polyspace_no_rpc_autherr_badverf)
#include <linux/sunrpc/xdr.h>
#undef rpc_autherr_badverf
  extern u32 rpc_autherr_badverf;
#endif

#if defined(__polyspace_rpc_autherr_rejectedverf) && !defined(__polyspace_no_rpc_autherr_rejectedverf)
#include <linux/sunrpc/xdr.h>
#undef rpc_autherr_rejectedverf
  extern u32 rpc_autherr_rejectedverf;
#endif

#if defined(__polyspace_rpc_autherr_tooweak) && !defined(__polyspace_no_rpc_autherr_tooweak)
#include <linux/sunrpc/xdr.h>
#undef rpc_autherr_tooweak
  extern u32 rpc_autherr_tooweak;
#endif

#if defined(__polyspace_rpc_autherr_dropit) && !defined(__polyspace_no_rpc_autherr_dropit)
#include <linux/sunrpc/xdr.h>
#undef rpc_autherr_dropit
  extern u32 rpc_autherr_dropit;
#endif

#if defined(__polyspace_nr_swap_pages) && !defined(__polyspace_no_nr_swap_pages)
#include <linux/swap.h>
#undef nr_swap_pages
  extern int nr_swap_pages;
#endif

#if defined(__polyspace_nr_free_pages) && !defined(__polyspace_no_nr_free_pages)
#include <linux/swap.h>
#undef nr_free_pages
  extern int nr_free_pages;
#endif

#if defined(__polyspace_nr_async_pages) && !defined(__polyspace_no_nr_async_pages)
#include <linux/swap.h>
#undef nr_async_pages
  extern atomic_t nr_async_pages;
#endif

#if defined(__polyspace_swapper_inode) && !defined(__polyspace_no_swapper_inode)
#include <linux/swap.h>
#undef swapper_inode
  extern struct inode swapper_inode;
#endif

#if defined(__polyspace_nr_swapfiles) && !defined(__polyspace_no_nr_swapfiles)
#include <linux/swap.h>
#undef nr_swapfiles
  extern unsigned int nr_swapfiles;
#endif

#if defined(__polyspace_swap_info) && !defined(__polyspace_no_swap_info)
#include <linux/swap.h>
#undef swap_info
  extern struct swap_info_struct swap_info[];
#endif

#if defined(__polyspace_swap_list) && !defined(__polyspace_no_swap_list)
#include <linux/swap.h>
#undef swap_list
  extern struct swap_list_t swap_list;
#endif

#if defined(__polyspace_swap_cache_add_total) && !defined(__polyspace_no_swap_cache_add_total)
#include <linux/swap.h>
#undef swap_cache_add_total
  extern unsigned long swap_cache_add_total;
#endif

#if defined(__polyspace_swap_cache_del_total) && !defined(__polyspace_no_swap_cache_del_total)
#include <linux/swap.h>
#undef swap_cache_del_total
  extern unsigned long swap_cache_del_total;
#endif

#if defined(__polyspace_swap_cache_find_total) && !defined(__polyspace_no_swap_cache_find_total)
#include <linux/swap.h>
#undef swap_cache_find_total
  extern unsigned long swap_cache_find_total;
#endif

#if defined(__polyspace_swap_cache_find_success) && !defined(__polyspace_no_swap_cache_find_success)
#include <linux/swap.h>
#undef swap_cache_find_success
  extern unsigned long swap_cache_find_success;
#endif

#if defined(__polyspace_buffer_mem) && !defined(__polyspace_no_buffer_mem)
#include <linux/swapctl.h>
#undef buffer_mem
  extern buffer_mem_t buffer_mem;
#endif

#if defined(__polyspace_page_cache) && !defined(__polyspace_no_page_cache)
#include <linux/swapctl.h>
#undef page_cache
  extern buffer_mem_t page_cache;
#endif

#if defined(__polyspace_freepages) && !defined(__polyspace_no_freepages)
#include <linux/swapctl.h>
#undef freepages
  extern freepages_t freepages;
#endif

#if defined(__polyspace_pager_daemon) && !defined(__polyspace_no_pager_daemon)
#include <linux/swapctl.h>
#undef pager_daemon
  extern pager_daemon_t pager_daemon;
#endif

#if defined(__polyspace_sysctl_string) && !defined(__polyspace_no_sysctl_string)
#include <linux/sysctl.h>
#undef sysctl_string
  extern ctl_handler sysctl_string;
#endif

#if defined(__polyspace_sysctl_intvec) && !defined(__polyspace_no_sysctl_intvec)
#include <linux/sysctl.h>
#undef sysctl_intvec
  extern ctl_handler sysctl_intvec;
#endif

#if defined(__polyspace_sysctl_jiffies) && !defined(__polyspace_no_sysctl_jiffies)
#include <linux/sysctl.h>
#undef sysctl_jiffies
  extern ctl_handler sysctl_jiffies;
#endif

#if defined(__polyspace_emergency_sync_scheduled) && !defined(__polyspace_no_emergency_sync_scheduled)
#include <linux/sysrq.h>
#undef emergency_sync_scheduled
  extern int emergency_sync_scheduled;
#endif

#if defined(__polyspace_sysrq_enabled) && !defined(__polyspace_no_sysrq_enabled)
#include <linux/sysrq.h>
#undef sysrq_enabled
  extern int sysrq_enabled;
#endif

#if defined(__polyspace_sysv_file_inode_operations) && !defined(__polyspace_no_sysv_file_inode_operations)
#include <linux/sysv_fs.h>
#undef sysv_file_inode_operations
  extern struct inode_operations sysv_file_inode_operations;
#endif

#if defined(__polyspace_sysv_file_inode_operations_with_bmap) && !defined(__polyspace_no_sysv_file_inode_operations_with_bmap)
#include <linux/sysv_fs.h>
#undef sysv_file_inode_operations_with_bmap
  extern struct inode_operations sysv_file_inode_operations_with_bmap;
#endif

#if defined(__polyspace_sysv_dir_inode_operations) && !defined(__polyspace_no_sysv_dir_inode_operations)
#include <linux/sysv_fs.h>
#undef sysv_dir_inode_operations
  extern struct inode_operations sysv_dir_inode_operations;
#endif

#if defined(__polyspace_sysv_symlink_inode_operations) && !defined(__polyspace_no_sysv_symlink_inode_operations)
#include <linux/sysv_fs.h>
#undef sysv_symlink_inode_operations
  extern struct inode_operations sysv_symlink_inode_operations;
#endif

#if defined(__polyspace_timer_active) && !defined(__polyspace_no_timer_active)
#include <linux/timer.h>
#undef timer_active
  extern unsigned long timer_active;
#endif

#if defined(__polyspace_timer_table) && !defined(__polyspace_no_timer_table)
#include <linux/timer.h>
#undef timer_table
  extern struct timer_struct timer_table[32];
#endif

#if defined(__polyspace_tick) && !defined(__polyspace_no_tick)
#include <linux/timex.h>
#undef tick
  extern long tick;
#endif

#if defined(__polyspace_tickadj) && !defined(__polyspace_no_tickadj)
#include <linux/timex.h>
#undef tickadj
  extern int tickadj;
#endif

#if defined(__polyspace_time_state) && !defined(__polyspace_no_time_state)
#include <linux/timex.h>
#undef time_state
  extern int time_state;
#endif

#if defined(__polyspace_time_status) && !defined(__polyspace_no_time_status)
#include <linux/timex.h>
#undef time_status
  extern int time_status;
#endif

#if defined(__polyspace_time_offset) && !defined(__polyspace_no_time_offset)
#include <linux/timex.h>
#undef time_offset
  extern long time_offset;
#endif

#if defined(__polyspace_time_constant) && !defined(__polyspace_no_time_constant)
#include <linux/timex.h>
#undef time_constant
  extern long time_constant;
#endif

#if defined(__polyspace_time_tolerance) && !defined(__polyspace_no_time_tolerance)
#include <linux/timex.h>
#undef time_tolerance
  extern long time_tolerance;
#endif

#if defined(__polyspace_time_precision) && !defined(__polyspace_no_time_precision)
#include <linux/timex.h>
#undef time_precision
  extern long time_precision;
#endif

#if defined(__polyspace_time_maxerror) && !defined(__polyspace_no_time_maxerror)
#include <linux/timex.h>
#undef time_maxerror
  extern long time_maxerror;
#endif

#if defined(__polyspace_time_esterror) && !defined(__polyspace_no_time_esterror)
#include <linux/timex.h>
#undef time_esterror
  extern long time_esterror;
#endif

#if defined(__polyspace_time_phase) && !defined(__polyspace_no_time_phase)
#include <linux/timex.h>
#undef time_phase
  extern long time_phase;
#endif

#if defined(__polyspace_time_freq) && !defined(__polyspace_no_time_freq)
#include <linux/timex.h>
#undef time_freq
  extern long time_freq;
#endif

#if defined(__polyspace_time_adj) && !defined(__polyspace_no_time_adj)
#include <linux/timex.h>
#undef time_adj
  extern long time_adj;
#endif

#if defined(__polyspace_time_reftime) && !defined(__polyspace_no_time_reftime)
#include <linux/timex.h>
#undef time_reftime
  extern long time_reftime;
#endif

#if defined(__polyspace_time_adjust) && !defined(__polyspace_no_time_adjust)
#include <linux/timex.h>
#undef time_adjust
  extern long time_adjust;
#endif

#if defined(__polyspace_pps_offset) && !defined(__polyspace_no_pps_offset)
#include <linux/timex.h>
#undef pps_offset
  extern long pps_offset;
#endif

#if defined(__polyspace_pps_jitter) && !defined(__polyspace_no_pps_jitter)
#include <linux/timex.h>
#undef pps_jitter
  extern long pps_jitter;
#endif

#if defined(__polyspace_pps_freq) && !defined(__polyspace_no_pps_freq)
#include <linux/timex.h>
#undef pps_freq
  extern long pps_freq;
#endif

#if defined(__polyspace_pps_stabil) && !defined(__polyspace_no_pps_stabil)
#include <linux/timex.h>
#undef pps_stabil
  extern long pps_stabil;
#endif

#if defined(__polyspace_pps_valid) && !defined(__polyspace_no_pps_valid)
#include <linux/timex.h>
#undef pps_valid
  extern long pps_valid;
#endif

#if defined(__polyspace_pps_shift) && !defined(__polyspace_no_pps_shift)
#include <linux/timex.h>
#undef pps_shift
  extern int pps_shift;
#endif

#if defined(__polyspace_pps_jitcnt) && !defined(__polyspace_no_pps_jitcnt)
#include <linux/timex.h>
#undef pps_jitcnt
  extern long pps_jitcnt;
#endif

#if defined(__polyspace_pps_calcnt) && !defined(__polyspace_no_pps_calcnt)
#include <linux/timex.h>
#undef pps_calcnt
  extern long pps_calcnt;
#endif

#if defined(__polyspace_pps_errcnt) && !defined(__polyspace_no_pps_errcnt)
#include <linux/timex.h>
#undef pps_errcnt
  extern long pps_errcnt;
#endif

#if defined(__polyspace_pps_stbcnt) && !defined(__polyspace_no_pps_stbcnt)
#include <linux/timex.h>
#undef pps_stbcnt
  extern long pps_stbcnt;
#endif

#if defined(__polyspace_tq_timer) && !defined(__polyspace_no_tq_timer)
#include <linux/tqueue.h>
#undef tq_timer
  extern task_queue tq_timer;
#endif

#if defined(__polyspace_tq_immediate) && !defined(__polyspace_no_tq_immediate)
#include <linux/tqueue.h>
#undef tq_immediate
  extern task_queue tq_immediate;
#endif

#if defined(__polyspace_tq_scheduler) && !defined(__polyspace_no_tq_scheduler)
#include <linux/tqueue.h>
#undef tq_scheduler
  extern task_queue tq_scheduler;
#endif

#if defined(__polyspace_tq_disk) && !defined(__polyspace_no_tq_disk)
#include <linux/tqueue.h>
#undef tq_disk
  extern task_queue tq_disk;
#endif

#if defined(__polyspace_tqueue_lock) && !defined(__polyspace_no_tqueue_lock)
#include <linux/tqueue.h>
#undef tqueue_lock
  extern spinlock_t tqueue_lock;
#endif

#if defined(__polyspace_screen_info) && !defined(__polyspace_no_screen_info)
#include <linux/tty.h>
#undef screen_info
  extern struct screen_info screen_info;
#endif

#if defined(__polyspace_tty_std_termios) && !defined(__polyspace_no_tty_std_termios)
#include <linux/tty.h>
#undef tty_std_termios
  extern struct termios tty_std_termios;
#endif

#if defined(__polyspace_redirect) && !defined(__polyspace_no_redirect)
#include <linux/tty.h>
#undef redirect
  extern struct tty_struct * redirect;
#endif

#if defined(__polyspace_ldiscs) && !defined(__polyspace_no_ldiscs)
#include <linux/tty.h>
#undef ldiscs
  extern struct tty_ldisc ldiscs[];
#endif

#if defined(__polyspace_fg_console) && !defined(__polyspace_no_fg_console)
#include <linux/tty.h>
#undef fg_console
  extern int fg_console;
#endif

#if defined(__polyspace_last_console) && !defined(__polyspace_no_last_console)
#include <linux/tty.h>
#undef last_console
  extern int last_console;
#endif

#if defined(__polyspace_want_console) && !defined(__polyspace_no_want_console)
#include <linux/tty.h>
#undef want_console
  extern int want_console;
#endif

#if defined(__polyspace_kmsg_redirect) && !defined(__polyspace_no_kmsg_redirect)
#include <linux/tty.h>
#undef kmsg_redirect
  extern int kmsg_redirect;
#endif

#if defined(__polyspace_tty_ldisc_N_TTY) && !defined(__polyspace_no_tty_ldisc_N_TTY)
#include <linux/tty.h>
#undef tty_ldisc_N_TTY
  extern struct tty_ldisc tty_ldisc_N_TTY;
#endif

#if defined(__polyspace_ufs_dir_inode_operations) && !defined(__polyspace_no_ufs_dir_inode_operations)
#include <linux/ufs_fs.h>
#undef ufs_dir_inode_operations
  extern struct inode_operations ufs_dir_inode_operations;
#endif

#if defined(__polyspace_ufs_dir_operations) && !defined(__polyspace_no_ufs_dir_operations)
#include <linux/ufs_fs.h>
#undef ufs_dir_operations
  extern struct file_operations ufs_dir_operations;
#endif

#if defined(__polyspace_ufs_file_inode_operations) && !defined(__polyspace_no_ufs_file_inode_operations)
#include <linux/ufs_fs.h>
#undef ufs_file_inode_operations
  extern struct inode_operations ufs_file_inode_operations;
#endif

#if defined(__polyspace_ufs_file_operations) && !defined(__polyspace_no_ufs_file_operations)
#include <linux/ufs_fs.h>
#undef ufs_file_operations
  extern struct file_operations ufs_file_operations;
#endif

#if defined(__polyspace_ufs_super_ops) && !defined(__polyspace_no_ufs_super_ops)
#include <linux/ufs_fs.h>
#undef ufs_super_ops
  extern struct super_operations ufs_super_ops;
#endif

#if defined(__polyspace_ufs_fs_type) && !defined(__polyspace_no_ufs_fs_type)
#include <linux/ufs_fs.h>
#undef ufs_fs_type
  extern struct file_system_type ufs_fs_type;
#endif

#if defined(__polyspace_ufs_symlink_inode_operations) && !defined(__polyspace_no_ufs_symlink_inode_operations)
#include <linux/ufs_fs.h>
#undef ufs_symlink_inode_operations
  extern struct inode_operations ufs_symlink_inode_operations;
#endif

#if defined(__polyspace_umsdos_dir_inode_operations) && !defined(__polyspace_no_umsdos_dir_inode_operations)
#include <linux/umsdos_fs.h>
#undef umsdos_dir_inode_operations
  extern struct inode_operations umsdos_dir_inode_operations;
#endif

#if defined(__polyspace_umsdos_file_operations) && !defined(__polyspace_no_umsdos_file_operations)
#include <linux/umsdos_fs.h>
#undef umsdos_file_operations
  extern struct file_operations umsdos_file_operations;
#endif

#if defined(__polyspace_umsdos_file_inode_operations) && !defined(__polyspace_no_umsdos_file_inode_operations)
#include <linux/umsdos_fs.h>
#undef umsdos_file_inode_operations
  extern struct inode_operations umsdos_file_inode_operations;
#endif

#if defined(__polyspace_umsdos_file_inode_operations_no_bmap) && !defined(__polyspace_no_umsdos_file_inode_operations_no_bmap)
#include <linux/umsdos_fs.h>
#undef umsdos_file_inode_operations_no_bmap
  extern struct inode_operations umsdos_file_inode_operations_no_bmap;
#endif

#if defined(__polyspace_umsdos_file_inode_operations_readpage) && !defined(__polyspace_no_umsdos_file_inode_operations_readpage)
#include <linux/umsdos_fs.h>
#undef umsdos_file_inode_operations_readpage
  extern struct inode_operations umsdos_file_inode_operations_readpage;
#endif

#if defined(__polyspace_umsdos_symlink_inode_operations) && !defined(__polyspace_no_umsdos_symlink_inode_operations)
#include <linux/umsdos_fs.h>
#undef umsdos_symlink_inode_operations
  extern struct inode_operations umsdos_symlink_inode_operations;
#endif

#if defined(__polyspace_system_utsname) && !defined(__polyspace_no_system_utsname)
#include <linux/utsname.h>
#undef system_utsname
  extern struct new_utsname system_utsname;
#endif

#if defined(__polyspace_uts_sem) && !defined(__polyspace_no_uts_sem)
#include <linux/utsname.h>
#undef uts_sem
  extern struct semaphore uts_sem;
#endif

#if defined(__polyspace_video_font_height) && !defined(__polyspace_no_video_font_height)
#include <linux/vt_kern.h>
#undef video_font_height
  extern unsigned int video_font_height;
#endif

#if defined(__polyspace_default_font_height) && !defined(__polyspace_no_default_font_height)
#include <linux/vt_kern.h>
#undef default_font_height
  extern unsigned int default_font_height;
#endif

#if defined(__polyspace_video_scan_lines) && !defined(__polyspace_no_video_scan_lines)
#include <linux/vt_kern.h>
#undef video_scan_lines
  extern unsigned int video_scan_lines;
#endif

#if defined(__polyspace_router_devlist) && !defined(__polyspace_no_router_devlist)
#include <linux/wanrouter.h>
#undef router_devlist
  extern wan_device_t *router_devlist;
#endif

#if defined(__polyspace_zorro_autocon) && !defined(__polyspace_no_zorro_autocon)
#include <linux/zorro.h>
#undef zorro_autocon
  extern struct ConfigDev zorro_autocon[ZORRO_NUM_AUTO];
#endif

#if defined(__polyspace_zorro_unused_z2ram) && !defined(__polyspace_no_zorro_unused_z2ram)
#include <linux/zorro.h>
#undef zorro_unused_z2ram
  extern __u32 zorro_unused_z2ram[4];
#endif

#if defined(__polyspace_help_nil) && !defined(__polyspace_no_help_nil)
#include <linuxconf/configf.h>
#undef help_nil
  extern HELP_FILE help_nil;
#endif

#if defined(__polyspace_diajava_treemenu) && !defined(__polyspace_no_diajava_treemenu)
#include <linuxconf/diajava.h>
#undef diajava_treemenu
  extern bool diajava_treemenu;
#endif

#if defined(__polyspace_diajava_reconfdia) && !defined(__polyspace_no_diajava_reconfdia)
#include <linuxconf/diajava.h>
#undef diajava_reconfdia
  extern bool diajava_reconfdia;
#endif

#if defined(__polyspace_diajava_setval) && !defined(__polyspace_no_diajava_setval)
#include <linuxconf/diajava.h>
#undef diajava_setval
  extern bool diajava_setval;
#endif

#if defined(__polyspace_diajava_gauge) && !defined(__polyspace_no_diajava_gauge)
#include <linuxconf/diajava.h>
#undef diajava_gauge
  extern bool diajava_gauge;
#endif

#if defined(__polyspace_diajava_slider) && !defined(__polyspace_no_diajava_slider)
#include <linuxconf/diajava.h>
#undef diajava_slider
  extern bool diajava_slider;
#endif

#if defined(__polyspace_diajava_alive) && !defined(__polyspace_no_diajava_alive)
#include <linuxconf/diajava.h>
#undef diajava_alive
  extern bool diajava_alive;
#endif

#if defined(__polyspace_diajava_context) && !defined(__polyspace_no_diajava_context)
#include <linuxconf/diajava.h>
#undef diajava_context
  extern bool diajava_context;
#endif

#if defined(__polyspace_dialog_mode) && !defined(__polyspace_no_dialog_mode)
#include <linuxconf/dialog_def.h>
#undef dialog_mode
  extern DIALOG_MODE dialog_mode;
#endif

#if defined(__polyspace_popen_SOCKETHOLDER) && !defined(__polyspace_no_popen_SOCKETHOLDER)
#include <linuxconf/popen.h>
#undef popen_SOCKETHOLDER
  extern const char popen_SOCKETHOLDER[];
#endif

#if defined(__polyspace_subsys_base) && !defined(__polyspace_no_subsys_base)
#include <linuxconf/subsys.h>
#undef subsys_base
  extern const char subsys_base[];
#endif

#if defined(__polyspace_subsys_stationid) && !defined(__polyspace_no_subsys_stationid)
#include <linuxconf/subsys.h>
#undef subsys_stationid
  extern const char subsys_stationid[];
#endif

#if defined(__polyspace_subsys_netclient) && !defined(__polyspace_no_subsys_netclient)
#include <linuxconf/subsys.h>
#undef subsys_netclient
  extern const char subsys_netclient[];
#endif

#if defined(__polyspace_subsys_hardware) && !defined(__polyspace_no_subsys_hardware)
#include <linuxconf/subsys.h>
#undef subsys_hardware
  extern const char subsys_hardware[];
#endif

#if defined(__polyspace_subsys_netaccess) && !defined(__polyspace_no_subsys_netaccess)
#include <linuxconf/subsys.h>
#undef subsys_netaccess
  extern const char subsys_netaccess[];
#endif

#if defined(__polyspace_subsys_noarch) && !defined(__polyspace_no_subsys_noarch)
#include <linuxconf/subsys.h>
#undef subsys_noarch
  extern const char subsys_noarch[];
#endif

#if defined(__polyspace_subsys_useraccounts) && !defined(__polyspace_no_subsys_useraccounts)
#include <linuxconf/subsys.h>
#undef subsys_useraccounts
  extern const char subsys_useraccounts[];
#endif

#if defined(__polyspace_subsys_userpriv) && !defined(__polyspace_no_subsys_userpriv)
#include <linuxconf/subsys.h>
#undef subsys_userpriv
  extern const char subsys_userpriv[];
#endif

#if defined(__polyspace_lt_preloaded_symbols) && !defined(__polyspace_no_lt_preloaded_symbols)
#include <ltdl.h>
#undef lt_preloaded_symbols
  extern const lt_dlsymlist lt_preloaded_symbols[];
#endif

#if defined(__polyspace_MikMod_errno) && !defined(__polyspace_no_MikMod_errno)
#include <mikmod.h>
#undef MikMod_errno
  extern int MikMod_errno;
#endif

#if defined(__polyspace_MikMod_critical) && !defined(__polyspace_no_MikMod_critical)
#include <mikmod.h>
#undef MikMod_critical
  extern BOOL MikMod_critical;
#endif

#if defined(__polyspace_load_669) && !defined(__polyspace_no_load_669)
#include <mikmod.h>
#undef load_669
  extern struct MLOADER load_669;
#endif

#if defined(__polyspace_load_amf) && !defined(__polyspace_no_load_amf)
#include <mikmod.h>
#undef load_amf
  extern struct MLOADER load_amf;
#endif

#if defined(__polyspace_load_dsm) && !defined(__polyspace_no_load_dsm)
#include <mikmod.h>
#undef load_dsm
  extern struct MLOADER load_dsm;
#endif

#if defined(__polyspace_load_far) && !defined(__polyspace_no_load_far)
#include <mikmod.h>
#undef load_far
  extern struct MLOADER load_far;
#endif

#if defined(__polyspace_load_gdm) && !defined(__polyspace_no_load_gdm)
#include <mikmod.h>
#undef load_gdm
  extern struct MLOADER load_gdm;
#endif

#if defined(__polyspace_load_it) && !defined(__polyspace_no_load_it)
#include <mikmod.h>
#undef load_it
  extern struct MLOADER load_it;
#endif

#if defined(__polyspace_load_imf) && !defined(__polyspace_no_load_imf)
#include <mikmod.h>
#undef load_imf
  extern struct MLOADER load_imf;
#endif

#if defined(__polyspace_load_med) && !defined(__polyspace_no_load_med)
#include <mikmod.h>
#undef load_med
  extern struct MLOADER load_med;
#endif

#if defined(__polyspace_load_m15) && !defined(__polyspace_no_load_m15)
#include <mikmod.h>
#undef load_m15
  extern struct MLOADER load_m15;
#endif

#if defined(__polyspace_load_mod) && !defined(__polyspace_no_load_mod)
#include <mikmod.h>
#undef load_mod
  extern struct MLOADER load_mod;
#endif

#if defined(__polyspace_load_mtm) && !defined(__polyspace_no_load_mtm)
#include <mikmod.h>
#undef load_mtm
  extern struct MLOADER load_mtm;
#endif

#if defined(__polyspace_load_stm) && !defined(__polyspace_no_load_stm)
#include <mikmod.h>
#undef load_stm
  extern struct MLOADER load_stm;
#endif

#if defined(__polyspace_load_stx) && !defined(__polyspace_no_load_stx)
#include <mikmod.h>
#undef load_stx
  extern struct MLOADER load_stx;
#endif

#if defined(__polyspace_load_s3m) && !defined(__polyspace_no_load_s3m)
#include <mikmod.h>
#undef load_s3m
  extern struct MLOADER load_s3m;
#endif

#if defined(__polyspace_load_ult) && !defined(__polyspace_no_load_ult)
#include <mikmod.h>
#undef load_ult
  extern struct MLOADER load_ult;
#endif

#if defined(__polyspace_load_uni) && !defined(__polyspace_no_load_uni)
#include <mikmod.h>
#undef load_uni
  extern struct MLOADER load_uni;
#endif

#if defined(__polyspace_load_xm) && !defined(__polyspace_no_load_xm)
#include <mikmod.h>
#undef load_xm
  extern struct MLOADER load_xm;
#endif

#if defined(__polyspace_md_volume) && !defined(__polyspace_no_md_volume)
#include <mikmod.h>
#undef md_volume
  extern UBYTE md_volume;
#endif

#if defined(__polyspace_md_musicvolume) && !defined(__polyspace_no_md_musicvolume)
#include <mikmod.h>
#undef md_musicvolume
  extern UBYTE md_musicvolume;
#endif

#if defined(__polyspace_md_sndfxvolume) && !defined(__polyspace_no_md_sndfxvolume)
#include <mikmod.h>
#undef md_sndfxvolume
  extern UBYTE md_sndfxvolume;
#endif

#if defined(__polyspace_md_reverb) && !defined(__polyspace_no_md_reverb)
#include <mikmod.h>
#undef md_reverb
  extern UBYTE md_reverb;
#endif

#if defined(__polyspace_md_pansep) && !defined(__polyspace_no_md_pansep)
#include <mikmod.h>
#undef md_pansep
  extern UBYTE md_pansep;
#endif

#if defined(__polyspace_md_device) && !defined(__polyspace_no_md_device)
#include <mikmod.h>
#undef md_device
  extern UWORD md_device;
#endif

#if defined(__polyspace_md_mixfreq) && !defined(__polyspace_no_md_mixfreq)
#include <mikmod.h>
#undef md_mixfreq
  extern UWORD md_mixfreq;
#endif

#if defined(__polyspace_md_mode) && !defined(__polyspace_no_md_mode)
#include <mikmod.h>
#undef md_mode
  extern UWORD md_mode;
#endif

#if defined(__polyspace_md_driver) && !defined(__polyspace_no_md_driver)
#include <mikmod.h>
#undef md_driver
  extern MDRIVER* md_driver;
#endif

#if defined(__polyspace_drv_nos) && !defined(__polyspace_no_drv_nos)
#include <mikmod.h>
#undef drv_nos
  extern struct MDRIVER drv_nos;
#endif

#if defined(__polyspace_drv_pipe) && !defined(__polyspace_no_drv_pipe)
#include <mikmod.h>
#undef drv_pipe
  extern struct MDRIVER drv_pipe;
#endif

#if defined(__polyspace_drv_raw) && !defined(__polyspace_no_drv_raw)
#include <mikmod.h>
#undef drv_raw
  extern struct MDRIVER drv_raw;
#endif

#if defined(__polyspace_drv_stdout) && !defined(__polyspace_no_drv_stdout)
#include <mikmod.h>
#undef drv_stdout
  extern struct MDRIVER drv_stdout;
#endif

#if defined(__polyspace_drv_wav) && !defined(__polyspace_no_drv_wav)
#include <mikmod.h>
#undef drv_wav
  extern struct MDRIVER drv_wav;
#endif

#if defined(__polyspace_drv_ultra) && !defined(__polyspace_no_drv_ultra)
#include <mikmod.h>
#undef drv_ultra
  extern struct MDRIVER drv_ultra;
#endif

#if defined(__polyspace_drv_AF) && !defined(__polyspace_no_drv_AF)
#include <mikmod.h>
#undef drv_AF
  extern struct MDRIVER drv_AF;
#endif

#if defined(__polyspace_drv_aix) && !defined(__polyspace_no_drv_aix)
#include <mikmod.h>
#undef drv_aix
  extern struct MDRIVER drv_aix;
#endif

#if defined(__polyspace_drv_alsa) && !defined(__polyspace_no_drv_alsa)
#include <mikmod.h>
#undef drv_alsa
  extern struct MDRIVER drv_alsa;
#endif

#if defined(__polyspace_drv_esd) && !defined(__polyspace_no_drv_esd)
#include <mikmod.h>
#undef drv_esd
  extern struct MDRIVER drv_esd;
#endif

#if defined(__polyspace_drv_hp) && !defined(__polyspace_no_drv_hp)
#include <mikmod.h>
#undef drv_hp
  extern struct MDRIVER drv_hp;
#endif

#if defined(__polyspace_drv_oss) && !defined(__polyspace_no_drv_oss)
#include <mikmod.h>
#undef drv_oss
  extern struct MDRIVER drv_oss;
#endif

#if defined(__polyspace_drv_sgi) && !defined(__polyspace_no_drv_sgi)
#include <mikmod.h>
#undef drv_sgi
  extern struct MDRIVER drv_sgi;
#endif

#if defined(__polyspace_drv_sun) && !defined(__polyspace_no_drv_sun)
#include <mikmod.h>
#undef drv_sun
  extern struct MDRIVER drv_sun;
#endif

#if defined(__polyspace_drv_dart) && !defined(__polyspace_no_drv_dart)
#include <mikmod.h>
#undef drv_dart
  extern struct MDRIVER drv_dart;
#endif

#if defined(__polyspace_drv_os2) && !defined(__polyspace_no_drv_os2)
#include <mikmod.h>
#undef drv_os2
  extern struct MDRIVER drv_os2;
#endif

#if defined(__polyspace_drv_ds) && !defined(__polyspace_no_drv_ds)
#include <mikmod.h>
#undef drv_ds
  extern struct MDRIVER drv_ds;
#endif

#if defined(__polyspace_drv_win) && !defined(__polyspace_no_drv_win)
#include <mikmod.h>
#undef drv_win
  extern struct MDRIVER drv_win;
#endif

#if defined(__polyspace_drv_mac) && !defined(__polyspace_no_drv_mac)
#include <mikmod.h>
#undef drv_mac
  extern struct MDRIVER drv_mac;
#endif

#if defined(__polyspace_SUCCESS) && !defined(__polyspace_no_SUCCESS)
#include <mpi2c++-1.0.5/constants.h>
#undef SUCCESS
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int SUCCESS;
#endif

#if defined(__polyspace_ERR_BUFFER) && !defined(__polyspace_no_ERR_BUFFER)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_BUFFER
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_BUFFER;
#endif

#if defined(__polyspace_ERR_COUNT) && !defined(__polyspace_no_ERR_COUNT)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_COUNT
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_COUNT;
#endif

#if defined(__polyspace_ERR_TYPE) && !defined(__polyspace_no_ERR_TYPE)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_TYPE
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_TYPE;
#endif

#if defined(__polyspace_ERR_TAG) && !defined(__polyspace_no_ERR_TAG)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_TAG
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_TAG;
#endif

#if defined(__polyspace_ERR_COMM) && !defined(__polyspace_no_ERR_COMM)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_COMM
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_COMM;
#endif

#if defined(__polyspace_ERR_RANK) && !defined(__polyspace_no_ERR_RANK)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_RANK
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_RANK;
#endif

#if defined(__polyspace_ERR_REQUEST) && !defined(__polyspace_no_ERR_REQUEST)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_REQUEST
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_REQUEST;
#endif

#if defined(__polyspace_ERR_ROOT) && !defined(__polyspace_no_ERR_ROOT)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_ROOT
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_ROOT;
#endif

#if defined(__polyspace_ERR_GROUP) && !defined(__polyspace_no_ERR_GROUP)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_GROUP
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_GROUP;
#endif

#if defined(__polyspace_ERR_OP) && !defined(__polyspace_no_ERR_OP)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_OP
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_OP;
#endif

#if defined(__polyspace_ERR_TOPOLOGY) && !defined(__polyspace_no_ERR_TOPOLOGY)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_TOPOLOGY
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_TOPOLOGY;
#endif

#if defined(__polyspace_ERR_DIMS) && !defined(__polyspace_no_ERR_DIMS)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_DIMS
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_DIMS;
#endif

#if defined(__polyspace_ERR_ARG) && !defined(__polyspace_no_ERR_ARG)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_ARG
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_ARG;
#endif

#if defined(__polyspace_ERR_UNKNOWN) && !defined(__polyspace_no_ERR_UNKNOWN)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_UNKNOWN
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_UNKNOWN;
#endif

#if defined(__polyspace_ERR_TRUNCATE) && !defined(__polyspace_no_ERR_TRUNCATE)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_TRUNCATE
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_TRUNCATE;
#endif

#if defined(__polyspace_ERR_OTHER) && !defined(__polyspace_no_ERR_OTHER)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_OTHER
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_OTHER;
#endif

#if defined(__polyspace_ERR_INTERN) && !defined(__polyspace_no_ERR_INTERN)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_INTERN
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_INTERN;
#endif

#if defined(__polyspace_ERR_PENDING) && !defined(__polyspace_no_ERR_PENDING)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_PENDING
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_PENDING;
#endif

#if defined(__polyspace_ERR_IN_STATUS) && !defined(__polyspace_no_ERR_IN_STATUS)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_IN_STATUS
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_IN_STATUS;
#endif

#if defined(__polyspace_ERR_LASTCODE) && !defined(__polyspace_no_ERR_LASTCODE)
#include <mpi2c++-1.0.5/constants.h>
#undef ERR_LASTCODE
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ERR_LASTCODE;
#endif

#if defined(__polyspace_BOTTOM) && !defined(__polyspace_no_BOTTOM)
#include <mpi2c++-1.0.5/constants.h>
#undef BOTTOM
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const void* BOTTOM;
#endif

#if defined(__polyspace_PROC_NULL) && !defined(__polyspace_no_PROC_NULL)
#include <mpi2c++-1.0.5/constants.h>
#undef PROC_NULL
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int PROC_NULL;
#endif

#if defined(__polyspace_ANY_SOURCE) && !defined(__polyspace_no_ANY_SOURCE)
#include <mpi2c++-1.0.5/constants.h>
#undef ANY_SOURCE
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ANY_SOURCE;
#endif

#if defined(__polyspace_ANY_TAG) && !defined(__polyspace_no_ANY_TAG)
#include <mpi2c++-1.0.5/constants.h>
#undef ANY_TAG
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int ANY_TAG;
#endif

#if defined(__polyspace_UNDEFINED) && !defined(__polyspace_no_UNDEFINED)
#include <mpi2c++-1.0.5/constants.h>
#undef UNDEFINED
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int UNDEFINED;
#endif

#if defined(__polyspace_BSEND_OVERHEAD) && !defined(__polyspace_no_BSEND_OVERHEAD)
#include <mpi2c++-1.0.5/constants.h>
#undef BSEND_OVERHEAD
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int BSEND_OVERHEAD;
#endif

#if defined(__polyspace_KEYVAL_INVALID) && !defined(__polyspace_no_KEYVAL_INVALID)
#include <mpi2c++-1.0.5/constants.h>
#undef KEYVAL_INVALID
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int KEYVAL_INVALID;
#endif

#if defined(__polyspace_ERRORS_ARE_FATAL) && !defined(__polyspace_no_ERRORS_ARE_FATAL)
#include <mpi2c++-1.0.5/constants.h>
#undef ERRORS_ARE_FATAL
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Errhandler ERRORS_ARE_FATAL;
#endif

#if defined(__polyspace_ERRORS_RETURN) && !defined(__polyspace_no_ERRORS_RETURN)
#include <mpi2c++-1.0.5/constants.h>
#undef ERRORS_RETURN
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Errhandler ERRORS_RETURN;
#endif

#if defined(__polyspace_ERRORS_THROW_EXCEPTIONS) && !defined(__polyspace_no_ERRORS_THROW_EXCEPTIONS)
#include <mpi2c++-1.0.5/constants.h>
#undef ERRORS_THROW_EXCEPTIONS
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Errhandler ERRORS_THROW_EXCEPTIONS;
#endif

#if defined(__polyspace_MAX_PROCESSOR_NAME) && !defined(__polyspace_no_MAX_PROCESSOR_NAME)
#include <mpi2c++-1.0.5/constants.h>
#undef MAX_PROCESSOR_NAME
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int MAX_PROCESSOR_NAME;
#endif

#if defined(__polyspace_MAX_ERROR_STRING) && !defined(__polyspace_no_MAX_ERROR_STRING)
#include <mpi2c++-1.0.5/constants.h>
#undef MAX_ERROR_STRING
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int MAX_ERROR_STRING;
#endif

#if defined(__polyspace_CHAR) && !defined(__polyspace_no_CHAR)
#include <mpi2c++-1.0.5/constants.h>
#undef CHAR
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype CHAR;
#endif

#if defined(__polyspace_SHORT) && !defined(__polyspace_no_SHORT)
#include <mpi2c++-1.0.5/constants.h>
#undef SHORT
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype SHORT;
#endif

#if defined(__polyspace_INT) && !defined(__polyspace_no_INT)
#include <mpi2c++-1.0.5/constants.h>
#undef INT
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype INT;
#endif

#if defined(__polyspace_LONG) && !defined(__polyspace_no_LONG)
#include <mpi2c++-1.0.5/constants.h>
#undef LONG
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype LONG;
#endif

#if defined(__polyspace_SIGNED_CHAR) && !defined(__polyspace_no_SIGNED_CHAR)
#include <mpi2c++-1.0.5/constants.h>
#undef SIGNED_CHAR
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype SIGNED_CHAR;
#endif

#if defined(__polyspace_UNSIGNED_CHAR) && !defined(__polyspace_no_UNSIGNED_CHAR)
#include <mpi2c++-1.0.5/constants.h>
#undef UNSIGNED_CHAR
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype UNSIGNED_CHAR;
#endif

#if defined(__polyspace_UNSIGNED_SHORT) && !defined(__polyspace_no_UNSIGNED_SHORT)
#include <mpi2c++-1.0.5/constants.h>
#undef UNSIGNED_SHORT
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype UNSIGNED_SHORT;
#endif

#if defined(__polyspace_UNSIGNED) && !defined(__polyspace_no_UNSIGNED)
#include <mpi2c++-1.0.5/constants.h>
#undef UNSIGNED
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype UNSIGNED;
#endif

#if defined(__polyspace_UNSIGNED_LONG) && !defined(__polyspace_no_UNSIGNED_LONG)
#include <mpi2c++-1.0.5/constants.h>
#undef UNSIGNED_LONG
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype UNSIGNED_LONG;
#endif

#if defined(__polyspace_FLOAT) && !defined(__polyspace_no_FLOAT)
#include <mpi2c++-1.0.5/constants.h>
#undef FLOAT
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype FLOAT;
#endif

#if defined(__polyspace_DOUBLE) && !defined(__polyspace_no_DOUBLE)
#include <mpi2c++-1.0.5/constants.h>
#undef DOUBLE
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype DOUBLE;
#endif

#if defined(__polyspace_LONG_DOUBLE) && !defined(__polyspace_no_LONG_DOUBLE)
#include <mpi2c++-1.0.5/constants.h>
#undef LONG_DOUBLE
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype LONG_DOUBLE;
#endif

#if defined(__polyspace_BYTE) && !defined(__polyspace_no_BYTE)
#include <mpi2c++-1.0.5/constants.h>
#undef BYTE
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype BYTE;
#endif

#if defined(__polyspace_PACKED) && !defined(__polyspace_no_PACKED)
#include <mpi2c++-1.0.5/constants.h>
#undef PACKED
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype PACKED;
#endif

#if defined(__polyspace_FLOAT_INT) && !defined(__polyspace_no_FLOAT_INT)
#include <mpi2c++-1.0.5/constants.h>
#undef FLOAT_INT
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype FLOAT_INT;
#endif

#if defined(__polyspace_DOUBLE_INT) && !defined(__polyspace_no_DOUBLE_INT)
#include <mpi2c++-1.0.5/constants.h>
#undef DOUBLE_INT
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype DOUBLE_INT;
#endif

#if defined(__polyspace_LONG_INT) && !defined(__polyspace_no_LONG_INT)
#include <mpi2c++-1.0.5/constants.h>
#undef LONG_INT
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype LONG_INT;
#endif

#if defined(__polyspace_TWOINT) && !defined(__polyspace_no_TWOINT)
#include <mpi2c++-1.0.5/constants.h>
#undef TWOINT
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype TWOINT;
#endif

#if defined(__polyspace_SHORT_INT) && !defined(__polyspace_no_SHORT_INT)
#include <mpi2c++-1.0.5/constants.h>
#undef SHORT_INT
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype SHORT_INT;
#endif

#if defined(__polyspace_LONG_DOUBLE_INT) && !defined(__polyspace_no_LONG_DOUBLE_INT)
#include <mpi2c++-1.0.5/constants.h>
#undef LONG_DOUBLE_INT
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype LONG_DOUBLE_INT;
#endif

#if defined(__polyspace_INTEGER) && !defined(__polyspace_no_INTEGER)
#include <mpi2c++-1.0.5/constants.h>
#undef INTEGER
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype INTEGER;
#endif

#if defined(__polyspace_REAL) && !defined(__polyspace_no_REAL)
#include <mpi2c++-1.0.5/constants.h>
#undef REAL
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype REAL;
#endif

#if defined(__polyspace_DOUBLE_PRECISION) && !defined(__polyspace_no_DOUBLE_PRECISION)
#include <mpi2c++-1.0.5/constants.h>
#undef DOUBLE_PRECISION
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype DOUBLE_PRECISION;
#endif

#if defined(__polyspace_F_COMPLEX) && !defined(__polyspace_no_F_COMPLEX)
#include <mpi2c++-1.0.5/constants.h>
#undef F_COMPLEX
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype F_COMPLEX;
#endif

#if defined(__polyspace_LOGICAL) && !defined(__polyspace_no_LOGICAL)
#include <mpi2c++-1.0.5/constants.h>
#undef LOGICAL
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype LOGICAL;
#endif

#if defined(__polyspace_CHARACTER) && !defined(__polyspace_no_CHARACTER)
#include <mpi2c++-1.0.5/constants.h>
#undef CHARACTER
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype CHARACTER;
#endif

#if defined(__polyspace_TWOREAL) && !defined(__polyspace_no_TWOREAL)
#include <mpi2c++-1.0.5/constants.h>
#undef TWOREAL
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype TWOREAL;
#endif

#if defined(__polyspace_TWODOUBLE_PRECISION) && !defined(__polyspace_no_TWODOUBLE_PRECISION)
#include <mpi2c++-1.0.5/constants.h>
#undef TWODOUBLE_PRECISION
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype TWODOUBLE_PRECISION;
#endif

#if defined(__polyspace_TWOINTEGER) && !defined(__polyspace_no_TWOINTEGER)
#include <mpi2c++-1.0.5/constants.h>
#undef TWOINTEGER
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype TWOINTEGER;
#endif

#if defined(__polyspace_INTEGER1) && !defined(__polyspace_no_INTEGER1)
#include <mpi2c++-1.0.5/constants.h>
#undef INTEGER1
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype INTEGER1;
#endif

#if defined(__polyspace_INTEGER2) && !defined(__polyspace_no_INTEGER2)
#include <mpi2c++-1.0.5/constants.h>
#undef INTEGER2
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype INTEGER2;
#endif

#if defined(__polyspace_INTEGER4) && !defined(__polyspace_no_INTEGER4)
#include <mpi2c++-1.0.5/constants.h>
#undef INTEGER4
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype INTEGER4;
#endif

#if defined(__polyspace_REAL2) && !defined(__polyspace_no_REAL2)
#include <mpi2c++-1.0.5/constants.h>
#undef REAL2
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype REAL2;
#endif

#if defined(__polyspace_REAL4) && !defined(__polyspace_no_REAL4)
#include <mpi2c++-1.0.5/constants.h>
#undef REAL4
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype REAL4;
#endif

#if defined(__polyspace_REAL8) && !defined(__polyspace_no_REAL8)
#include <mpi2c++-1.0.5/constants.h>
#undef REAL8
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype REAL8;
#endif

#if defined(__polyspace_LONG_LONG) && !defined(__polyspace_no_LONG_LONG)
#include <mpi2c++-1.0.5/constants.h>
#undef LONG_LONG
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype LONG_LONG;
#endif

#if defined(__polyspace_UNSIGNED_LONG_LONG) && !defined(__polyspace_no_UNSIGNED_LONG_LONG)
#include <mpi2c++-1.0.5/constants.h>
#undef UNSIGNED_LONG_LONG
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype UNSIGNED_LONG_LONG;
#endif

#if defined(__polyspace_BOOL) && !defined(__polyspace_no_BOOL)
#include <mpi2c++-1.0.5/constants.h>
#undef BOOL
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype BOOL;
#endif

#if defined(__polyspace_COMPLEX) && !defined(__polyspace_no_COMPLEX)
#include <mpi2c++-1.0.5/constants.h>
#undef COMPLEX
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype COMPLEX;
#endif

#if defined(__polyspace_DOUBLE_COMPLEX) && !defined(__polyspace_no_DOUBLE_COMPLEX)
#include <mpi2c++-1.0.5/constants.h>
#undef DOUBLE_COMPLEX
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype DOUBLE_COMPLEX;
#endif

#if defined(__polyspace_LONG_DOUBLE_COMPLEX) && !defined(__polyspace_no_LONG_DOUBLE_COMPLEX)
#include <mpi2c++-1.0.5/constants.h>
#undef LONG_DOUBLE_COMPLEX
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype LONG_DOUBLE_COMPLEX;
#endif

#if defined(__polyspace_UB) && !defined(__polyspace_no_UB)
#include <mpi2c++-1.0.5/constants.h>
#undef UB
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype UB;
#endif

#if defined(__polyspace_LB) && !defined(__polyspace_no_LB)
#include <mpi2c++-1.0.5/constants.h>
#undef LB
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype LB;
#endif

#if defined(__polyspace_COMM_WORLD) && !defined(__polyspace_no_COMM_WORLD)
#include <mpi2c++-1.0.5/constants.h>
#undef COMM_WORLD
  _MPIPP_EXTERN_ _MPIPP_STATIC_ Intracomm COMM_WORLD;
#endif

#if defined(__polyspace_COMM_SELF) && !defined(__polyspace_no_COMM_SELF)
#include <mpi2c++-1.0.5/constants.h>
#undef COMM_SELF
  _MPIPP_EXTERN_ _MPIPP_STATIC_ Intracomm COMM_SELF;
#endif

#if defined(__polyspace_IDENT) && !defined(__polyspace_no_IDENT)
#include <mpi2c++-1.0.5/constants.h>
#undef IDENT
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int IDENT;
#endif

#if defined(__polyspace_CONGRUENT) && !defined(__polyspace_no_CONGRUENT)
#include <mpi2c++-1.0.5/constants.h>
#undef CONGRUENT
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int CONGRUENT;
#endif

#if defined(__polyspace_SIMILAR) && !defined(__polyspace_no_SIMILAR)
#include <mpi2c++-1.0.5/constants.h>
#undef SIMILAR
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int SIMILAR;
#endif

#if defined(__polyspace_UNEQUAL) && !defined(__polyspace_no_UNEQUAL)
#include <mpi2c++-1.0.5/constants.h>
#undef UNEQUAL
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int UNEQUAL;
#endif

#if defined(__polyspace_TAG_UB) && !defined(__polyspace_no_TAG_UB)
#include <mpi2c++-1.0.5/constants.h>
#undef TAG_UB
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int TAG_UB;
#endif

#if defined(__polyspace_IO) && !defined(__polyspace_no_IO)
#include <mpi2c++-1.0.5/constants.h>
#undef IO
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int IO;
#endif

#if defined(__polyspace_HOST) && !defined(__polyspace_no_HOST)
#include <mpi2c++-1.0.5/constants.h>
#undef HOST
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int HOST;
#endif

#if defined(__polyspace_WTIME_IS_GLOBAL) && !defined(__polyspace_no_WTIME_IS_GLOBAL)
#include <mpi2c++-1.0.5/constants.h>
#undef WTIME_IS_GLOBAL
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int WTIME_IS_GLOBAL;
#endif

#if defined(__polyspace_MAX) && !defined(__polyspace_no_MAX)
#include <mpi2c++-1.0.5/constants.h>
#undef MAX
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Op MAX;
#endif

#if defined(__polyspace_MIN) && !defined(__polyspace_no_MIN)
#include <mpi2c++-1.0.5/constants.h>
#undef MIN
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Op MIN;
#endif

#if defined(__polyspace_SUM) && !defined(__polyspace_no_SUM)
#include <mpi2c++-1.0.5/constants.h>
#undef SUM
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Op SUM;
#endif

#if defined(__polyspace_PROD) && !defined(__polyspace_no_PROD)
#include <mpi2c++-1.0.5/constants.h>
#undef PROD
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Op PROD;
#endif

#if defined(__polyspace_MAXLOC) && !defined(__polyspace_no_MAXLOC)
#include <mpi2c++-1.0.5/constants.h>
#undef MAXLOC
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Op MAXLOC;
#endif

#if defined(__polyspace_MINLOC) && !defined(__polyspace_no_MINLOC)
#include <mpi2c++-1.0.5/constants.h>
#undef MINLOC
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Op MINLOC;
#endif

#if defined(__polyspace_BAND) && !defined(__polyspace_no_BAND)
#include <mpi2c++-1.0.5/constants.h>
#undef BAND
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Op BAND;
#endif

#if defined(__polyspace_BOR) && !defined(__polyspace_no_BOR)
#include <mpi2c++-1.0.5/constants.h>
#undef BOR
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Op BOR;
#endif

#if defined(__polyspace_BXOR) && !defined(__polyspace_no_BXOR)
#include <mpi2c++-1.0.5/constants.h>
#undef BXOR
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Op BXOR;
#endif

#if defined(__polyspace_LAND) && !defined(__polyspace_no_LAND)
#include <mpi2c++-1.0.5/constants.h>
#undef LAND
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Op LAND;
#endif

#if defined(__polyspace_LOR) && !defined(__polyspace_no_LOR)
#include <mpi2c++-1.0.5/constants.h>
#undef LOR
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Op LOR;
#endif

#if defined(__polyspace_LXOR) && !defined(__polyspace_no_LXOR)
#include <mpi2c++-1.0.5/constants.h>
#undef LXOR
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Op LXOR;
#endif

#if defined(__polyspace_GROUP_NULL) && !defined(__polyspace_no_GROUP_NULL)
#include <mpi2c++-1.0.5/constants.h>
#undef GROUP_NULL
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Group  GROUP_NULL;
#endif

#if defined(__polyspace_COMM_NULL) && !defined(__polyspace_no_COMM_NULL)
#include <mpi2c++-1.0.5/constants.h>
#undef COMM_NULL
  _MPIPP_EXTERN_ _MPIPP_STATIC_ Comm_Null   COMM_NULL;
#endif

#if defined(__polyspace_DATATYPE_NULL) && !defined(__polyspace_no_DATATYPE_NULL)
#include <mpi2c++-1.0.5/constants.h>
#undef DATATYPE_NULL
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Datatype  DATATYPE_NULL;
#endif

#if defined(__polyspace_REQUEST_NULL) && !defined(__polyspace_no_REQUEST_NULL)
#include <mpi2c++-1.0.5/constants.h>
#undef REQUEST_NULL
  _MPIPP_EXTERN_ _MPIPP_STATIC_ Request   REQUEST_NULL;
#endif

#if defined(__polyspace_OP_NULL) && !defined(__polyspace_no_OP_NULL)
#include <mpi2c++-1.0.5/constants.h>
#undef OP_NULL
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Op   OP_NULL;
#endif

#if defined(__polyspace_ERRHANDLER_NULL) && !defined(__polyspace_no_ERRHANDLER_NULL)
#include <mpi2c++-1.0.5/constants.h>
#undef ERRHANDLER_NULL
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Errhandler ERRHANDLER_NULL;
#endif

#if defined(__polyspace_GROUP_EMPTY) && !defined(__polyspace_no_GROUP_EMPTY)
#include <mpi2c++-1.0.5/constants.h>
#undef GROUP_EMPTY
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const Group GROUP_EMPTY;
#endif

#if defined(__polyspace_GRAPH) && !defined(__polyspace_no_GRAPH)
#include <mpi2c++-1.0.5/constants.h>
#undef GRAPH
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int GRAPH;
#endif

#if defined(__polyspace_CART) && !defined(__polyspace_no_CART)
#include <mpi2c++-1.0.5/constants.h>
#undef CART
  _MPIPP_EXTERN_ _MPIPP_STATIC_ const int CART;
#endif

#if defined(__polyspace_COLOR_PAIRS) && !defined(__polyspace_no_COLOR_PAIRS)
#include <ncurses/curses.h>
#undef COLOR_PAIRS
  extern int COLOR_PAIRS;
#endif

#if defined(__polyspace_acs_map) && !defined(__polyspace_no_acs_map)
#include <ncurses/curses.h>
#undef acs_map
  extern chtype acs_map[];
#endif

#if defined(__polyspace_stdscr) && !defined(__polyspace_no_stdscr)
#include <ncurses/curses.h>
#undef stdscr
  extern WINDOW *stdscr;
#endif

#if defined(__polyspace_curscr) && !defined(__polyspace_no_curscr)
#include <ncurses/curses.h>
#undef curscr
  extern WINDOW *curscr;
#endif

#if defined(__polyspace_newscr) && !defined(__polyspace_no_newscr)
#include <ncurses/curses.h>
#undef newscr
  extern WINDOW *newscr;
#endif

#if defined(__polyspace_LINES) && !defined(__polyspace_no_LINES)
#include <ncurses/curses.h>
#undef LINES
  extern int LINES;
#endif

#if defined(__polyspace_COLS) && !defined(__polyspace_no_COLS)
#include <ncurses/curses.h>
#undef COLS
  extern int COLS;
#endif

#if defined(__polyspace_TABSIZE) && !defined(__polyspace_no_TABSIZE)
#include <ncurses/curses.h>
#undef TABSIZE
  extern int TABSIZE;
#endif

#if defined(__polyspace_ESCDELAY) && !defined(__polyspace_no_ESCDELAY)
#include <ncurses/curses.h>
#undef ESCDELAY
  extern int ESCDELAY;
#endif

#if defined(__polyspace_ttytype) && !defined(__polyspace_no_ttytype)
#include <ncurses/curses.h>
#undef ttytype
  extern char ttytype[];
#endif

#if defined(__polyspace__nc_optimize_enable) && !defined(__polyspace_no__nc_optimize_enable)
#include <ncurses/curses.h>
#undef _nc_optimize_enable
  extern int _nc_optimize_enable;
#endif

#if defined(__polyspace_TYPE_ALPHA) && !defined(__polyspace_no_TYPE_ALPHA)
#include <ncurses/form.h>
#undef TYPE_ALPHA
  extern FIELDTYPE *TYPE_ALPHA;
#endif

#if defined(__polyspace_TYPE_ALNUM) && !defined(__polyspace_no_TYPE_ALNUM)
#include <ncurses/form.h>
#undef TYPE_ALNUM
  extern FIELDTYPE     *TYPE_ALNUM;
#endif

#if defined(__polyspace_TYPE_ENUM) && !defined(__polyspace_no_TYPE_ENUM)
#include <ncurses/form.h>
#undef TYPE_ENUM
  extern FIELDTYPE     *TYPE_ENUM;
#endif

#if defined(__polyspace_TYPE_INTEGER) && !defined(__polyspace_no_TYPE_INTEGER)
#include <ncurses/form.h>
#undef TYPE_INTEGER
  extern FIELDTYPE     *TYPE_INTEGER;
#endif

#if defined(__polyspace_TYPE_NUMERIC) && !defined(__polyspace_no_TYPE_NUMERIC)
#include <ncurses/form.h>
#undef TYPE_NUMERIC
  extern FIELDTYPE     *TYPE_NUMERIC;
#endif

#if defined(__polyspace_TYPE_REGEXP) && !defined(__polyspace_no_TYPE_REGEXP)
#include <ncurses/form.h>
#undef TYPE_REGEXP
  extern FIELDTYPE     *TYPE_REGEXP;
#endif

#if defined(__polyspace_TYPE_IPV4) && !defined(__polyspace_no_TYPE_IPV4)
#include <ncurses/form.h>
#undef TYPE_IPV4
  extern FIELDTYPE *TYPE_IPV4;
#endif

#if defined(__polyspace__nc_Default_Form) && !defined(__polyspace_no__nc_Default_Form)
#include <ncurses/form.h>
#undef _nc_Default_Form
  extern FORM *_nc_Default_Form;
#endif

#if defined(__polyspace__nc_Default_Field) && !defined(__polyspace_no__nc_Default_Field)
#include <ncurses/form.h>
#undef _nc_Default_Field
  extern FIELD *_nc_Default_Field;
#endif

#if defined(__polyspace_cur_term) && !defined(__polyspace_no_cur_term)
#include <ncurses/term.h>
#undef cur_term
  extern TERMINAL *cur_term;
#endif

#if defined(__polyspace_boolnames) && !defined(__polyspace_no_boolnames)
#include <ncurses/term.h>
#undef boolnames
  extern NCURSES_CONST char *const boolnames[];
#endif

#if defined(__polyspace_boolcodes) && !defined(__polyspace_no_boolcodes)
#include <ncurses/term.h>
#undef boolcodes
  extern NCURSES_CONST char *const boolcodes[];
#endif

#if defined(__polyspace_boolfnames) && !defined(__polyspace_no_boolfnames)
#include <ncurses/term.h>
#undef boolfnames
  extern NCURSES_CONST char *const boolfnames[];
#endif

#if defined(__polyspace_numnames) && !defined(__polyspace_no_numnames)
#include <ncurses/term.h>
#undef numnames
  extern NCURSES_CONST char *const numnames[];
#endif

#if defined(__polyspace_numcodes) && !defined(__polyspace_no_numcodes)
#include <ncurses/term.h>
#undef numcodes
  extern NCURSES_CONST char *const numcodes[];
#endif

#if defined(__polyspace_numfnames) && !defined(__polyspace_no_numfnames)
#include <ncurses/term.h>
#undef numfnames
  extern NCURSES_CONST char *const numfnames[];
#endif

#if defined(__polyspace_strnames) && !defined(__polyspace_no_strnames)
#include <ncurses/term.h>
#undef strnames
  extern NCURSES_CONST char *const strnames[];
#endif

#if defined(__polyspace_strcodes) && !defined(__polyspace_no_strcodes)
#include <ncurses/term.h>
#undef strcodes
  extern NCURSES_CONST char *const strcodes[];
#endif

#if defined(__polyspace_strfnames) && !defined(__polyspace_no_strfnames)
#include <ncurses/term.h>
#undef strfnames
  extern NCURSES_CONST char *const strfnames[];
#endif

#if defined(__polyspace_UP) && !defined(__polyspace_no_UP)
#include <ncurses/termcap.h>
#undef UP
  extern char *UP;
#endif

#if defined(__polyspace_BC) && !defined(__polyspace_no_BC)
#include <ncurses/termcap.h>
#undef BC
  extern char *BC;
#endif

#if defined(__polyspace_ospeed) && !defined(__polyspace_no_ospeed)
#include <ncurses/termcap.h>
#undef ospeed
  extern speed_t ospeed;
#endif

#if defined(__polyspace_h_errno) && !defined(__polyspace_no_h_errno)
#include <netdb.h>
#undef h_errno
  extern int h_errno;
#endif

#if defined(__polyspace_in6addr_any) && !defined(__polyspace_no_in6addr_any)
#include <netinet/in.h>
#undef in6addr_any
  extern const struct in6_addr in6addr_any;
#endif

#if defined(__polyspace_in6addr_loopback) && !defined(__polyspace_no_in6addr_loopback)
#include <netinet/in.h>
#undef in6addr_loopback
  extern const struct in6_addr in6addr_loopback;
#endif

#if defined(__polyspace_newtDefaultColorPalette) && !defined(__polyspace_no_newtDefaultColorPalette)
#include <newt.h>
#undef newtDefaultColorPalette
  extern const struct newtColors newtDefaultColorPalette;
#endif

#if defined(__polyspace_obstack_exit_failure) && !defined(__polyspace_no_obstack_exit_failure)
#include <obstack.h>
#undef obstack_exit_failure
  extern int obstack_exit_failure;
#endif

#if defined(__polyspace_pgm_pbmmaxval) && !defined(__polyspace_no_pgm_pbmmaxval)
#include <pgm.h>
#undef pgm_pbmmaxval
  extern gray pgm_pbmmaxval;
#endif

#if defined(__polyspace_DatebookRepeatTypeNames) && !defined(__polyspace_no_DatebookRepeatTypeNames)
#include <pi-datebook.h>
#undef DatebookRepeatTypeNames
  extern char * DatebookRepeatTypeNames[];
#endif

#if defined(__polyspace_dlp_errorlist) && !defined(__polyspace_no_dlp_errorlist)
#include <pi-dlp.h>
#undef dlp_errorlist
  extern char * dlp_errorlist[];
#endif

#if defined(__polyspace_ExpenseDistanceNames) && !defined(__polyspace_no_ExpenseDistanceNames)
#include <pi-expense.h>
#undef ExpenseDistanceNames
  extern char * ExpenseDistanceNames[];
#endif

#if defined(__polyspace_ExpensePaymentNames) && !defined(__polyspace_no_ExpensePaymentNames)
#include <pi-expense.h>
#undef ExpensePaymentNames
  extern char * ExpensePaymentNames[];
#endif

#if defined(__polyspace_ExpenseTypeNames) && !defined(__polyspace_no_ExpenseTypeNames)
#include <pi-expense.h>
#undef ExpenseTypeNames
  extern char * ExpenseTypeNames[];
#endif

#if defined(__polyspace_MailSyncTypeNames) && !defined(__polyspace_no_MailSyncTypeNames)
#include <pi-mail.h>
#undef MailSyncTypeNames
  extern char * MailSyncTypeNames[];
#endif

#if defined(__polyspace_MailSortTypeNames) && !defined(__polyspace_no_MailSortTypeNames)
#include <pi-mail.h>
#undef MailSortTypeNames
  extern char * MailSortTypeNames[];
#endif

#if defined(__polyspace_sys_RPCerror) && !defined(__polyspace_no_sys_RPCerror)
#include <pi-syspkt.h>
#undef sys_RPCerror
  extern int sys_RPCerror;
#endif

#if defined(__polyspace_png_pass_start) && !defined(__polyspace_no_png_pass_start)
#include <png.h>
#undef png_pass_start
  extern int FARDATA png_pass_start[7];
#endif

#if defined(__polyspace_png_pass_inc) && !defined(__polyspace_no_png_pass_inc)
#include <png.h>
#undef png_pass_inc
  extern int FARDATA png_pass_inc[7];
#endif

#if defined(__polyspace_png_pass_ystart) && !defined(__polyspace_no_png_pass_ystart)
#include <png.h>
#undef png_pass_ystart
  extern int FARDATA png_pass_ystart[7];
#endif

#if defined(__polyspace_png_pass_yinc) && !defined(__polyspace_no_png_pass_yinc)
#include <png.h>
#undef png_pass_yinc
  extern int FARDATA png_pass_yinc[7];
#endif

#if defined(__polyspace_png_pass_mask) && !defined(__polyspace_no_png_pass_mask)
#include <png.h>
#undef png_pass_mask
  extern int FARDATA png_pass_mask[7];
#endif

#if defined(__polyspace_png_pass_dsp_mask) && !defined(__polyspace_no_png_pass_dsp_mask)
#include <png.h>
#undef png_pass_dsp_mask
  extern int FARDATA png_pass_dsp_mask[7];
#endif

#if defined(__polyspace_png_sig) && !defined(__polyspace_no_png_sig)
#include <png.h>
#undef png_sig
  extern png_byte FARDATA png_sig[8];
#endif

#if defined(__polyspace_png_IHDR) && !defined(__polyspace_no_png_IHDR)
#include <png.h>
#undef png_IHDR
  extern png_byte FARDATA png_IHDR[5];
#endif

#if defined(__polyspace_png_IDAT) && !defined(__polyspace_no_png_IDAT)
#include <png.h>
#undef png_IDAT
  extern png_byte FARDATA png_IDAT[5];
#endif

#if defined(__polyspace_png_IEND) && !defined(__polyspace_no_png_IEND)
#include <png.h>
#undef png_IEND
  extern png_byte FARDATA png_IEND[5];
#endif

#if defined(__polyspace_png_PLTE) && !defined(__polyspace_no_png_PLTE)
#include <png.h>
#undef png_PLTE
  extern png_byte FARDATA png_PLTE[5];
#endif

#if defined(__polyspace_png_bKGD) && !defined(__polyspace_no_png_bKGD)
#include <png.h>
#undef png_bKGD
  extern png_byte FARDATA png_bKGD[5];
#endif

#if defined(__polyspace_png_cHRM) && !defined(__polyspace_no_png_cHRM)
#include <png.h>
#undef png_cHRM
  extern png_byte FARDATA png_cHRM[5];
#endif

#if defined(__polyspace_png_gAMA) && !defined(__polyspace_no_png_gAMA)
#include <png.h>
#undef png_gAMA
  extern png_byte FARDATA png_gAMA[5];
#endif

#if defined(__polyspace_png_hIST) && !defined(__polyspace_no_png_hIST)
#include <png.h>
#undef png_hIST
  extern png_byte FARDATA png_hIST[5];
#endif

#if defined(__polyspace_png_oFFs) && !defined(__polyspace_no_png_oFFs)
#include <png.h>
#undef png_oFFs
  extern png_byte FARDATA png_oFFs[5];
#endif

#if defined(__polyspace_png_pCAL) && !defined(__polyspace_no_png_pCAL)
#include <png.h>
#undef png_pCAL
  extern png_byte FARDATA png_pCAL[5];
#endif

#if defined(__polyspace_png_pHYs) && !defined(__polyspace_no_png_pHYs)
#include <png.h>
#undef png_pHYs
  extern png_byte FARDATA png_pHYs[5];
#endif

#if defined(__polyspace_png_sBIT) && !defined(__polyspace_no_png_sBIT)
#include <png.h>
#undef png_sBIT
  extern png_byte FARDATA png_sBIT[5];
#endif

#if defined(__polyspace_png_sRGB) && !defined(__polyspace_no_png_sRGB)
#include <png.h>
#undef png_sRGB
  extern png_byte FARDATA png_sRGB[5];
#endif

#if defined(__polyspace_png_tEXt) && !defined(__polyspace_no_png_tEXt)
#include <png.h>
#undef png_tEXt
  extern png_byte FARDATA png_tEXt[5];
#endif

#if defined(__polyspace_png_tIME) && !defined(__polyspace_no_png_tIME)
#include <png.h>
#undef png_tIME
  extern png_byte FARDATA png_tIME[5];
#endif

#if defined(__polyspace_png_tRNS) && !defined(__polyspace_no_png_tRNS)
#include <png.h>
#undef png_tRNS
  extern png_byte FARDATA png_tRNS[5];
#endif

#if defined(__polyspace_png_zTXt) && !defined(__polyspace_no_png_zTXt)
#include <png.h>
#undef png_zTXt
  extern png_byte FARDATA png_zTXt[5];
#endif

#if defined(__polyspace_pnm_pbmmaxval) && !defined(__polyspace_no_pnm_pbmmaxval)
#include <pnm.h>
#undef pnm_pbmmaxval
  extern xelval pnm_pbmmaxval;
#endif

#if defined(__polyspace_poptHelpOptions) && !defined(__polyspace_no_poptHelpOptions)
#include <popt.h>
#undef poptHelpOptions
  extern struct poptOption poptHelpOptions[];
#endif

#if defined(__polyspace_ppm_pbmmaxval) && !defined(__polyspace_no_ppm_pbmmaxval)
#include <ppm.h>
#undef ppm_pbmmaxval
  extern pixval ppm_pbmmaxval;
#endif

#if defined(__polyspace_pwdb_policy) && !defined(__polyspace_no_pwdb_policy)
#include <pwdb/pwdb_public.h>
#undef pwdb_policy
  extern const pwdb_type **pwdb_policy;
#endif

#if defined(__polyspace_pwdb_group_policy) && !defined(__polyspace_no_pwdb_group_policy)
#include <pwdb/pwdb_public.h>
#undef pwdb_group_policy
  extern const pwdb_type **pwdb_group_policy;
#endif

#if defined(__polyspace__PyGdkI_API) && !defined(__polyspace_no__PyGdkI_API)
#include <pygtk/pygdkimlib.h>
#undef _PyGdkI_API
  extern struct _PyGdkImlib_FunctionStruct *_PyGdkI_API;
#endif

#if defined(__polyspace__PyGtk_API) && !defined(__polyspace_no__PyGtk_API)
#include <pygtk/pygtk.h>
#undef _PyGtk_API
  extern struct _PyGtk_FunctionStruct *_PyGtk_API;
#endif

#if defined(__polyspace_history_base) && !defined(__polyspace_no_history_base)
#include <readline/history.h>
#undef history_base
  extern int history_base;
#endif

#if defined(__polyspace_history_length) && !defined(__polyspace_no_history_length)
#include <readline/history.h>
#undef history_length
  extern int history_length;
#endif

#if defined(__polyspace_max_input_history) && !defined(__polyspace_no_max_input_history)
#include <readline/history.h>
#undef max_input_history
  extern int max_input_history;
#endif

#if defined(__polyspace_history_expansion_char) && !defined(__polyspace_no_history_expansion_char)
#include <readline/history.h>
#undef history_expansion_char
  extern char history_expansion_char;
#endif

#if defined(__polyspace_history_subst_char) && !defined(__polyspace_no_history_subst_char)
#include <readline/history.h>
#undef history_subst_char
  extern char history_subst_char;
#endif

#if defined(__polyspace_history_comment_char) && !defined(__polyspace_no_history_comment_char)
#include <readline/history.h>
#undef history_comment_char
  extern char history_comment_char;
#endif

#if defined(__polyspace_history_no_expand_chars) && !defined(__polyspace_no_history_no_expand_chars)
#include <readline/history.h>
#undef history_no_expand_chars
  extern char *history_no_expand_chars;
#endif

#if defined(__polyspace_history_search_delimiter_chars) && !defined(__polyspace_no_history_search_delimiter_chars)
#include <readline/history.h>
#undef history_search_delimiter_chars
  extern char *history_search_delimiter_chars;
#endif

#if defined(__polyspace_history_quotes_inhibit_expansion) && !defined(__polyspace_no_history_quotes_inhibit_expansion)
#include <readline/history.h>
#undef history_quotes_inhibit_expansion
  extern int history_quotes_inhibit_expansion;
#endif

#if defined(__polyspace_history_inhibit_expansion_function) && !defined(__polyspace_no_history_inhibit_expansion_function)
#include <readline/history.h>
#undef history_inhibit_expansion_function
  extern Function *history_inhibit_expansion_function;
#endif

#if defined(__polyspace_emacs_standard_keymap) && !defined(__polyspace_no_emacs_standard_keymap)
#include <readline/keymaps.h>
#undef emacs_standard_keymap
  extern KEYMAP_ENTRY_ARRAY emacs_standard_keymap;
#endif

#if defined(__polyspace_emacs_meta_keymap) && !defined(__polyspace_no_emacs_meta_keymap)
#include <readline/keymaps.h>
#undef emacs_meta_keymap
  extern KEYMAP_ENTRY_ARRAY emacs_meta_keymap;
#endif

#if defined(__polyspace_emacs_ctlx_keymap) && !defined(__polyspace_no_emacs_ctlx_keymap)
#include <readline/keymaps.h>
#undef emacs_ctlx_keymap
  extern KEYMAP_ENTRY_ARRAY emacs_ctlx_keymap;
#endif

#if defined(__polyspace_vi_insertion_keymap) && !defined(__polyspace_no_vi_insertion_keymap)
#include <readline/keymaps.h>
#undef vi_insertion_keymap
  extern KEYMAP_ENTRY_ARRAY vi_insertion_keymap;
#endif

#if defined(__polyspace_vi_movement_keymap) && !defined(__polyspace_no_vi_movement_keymap)
#include <readline/keymaps.h>
#undef vi_movement_keymap
  extern KEYMAP_ENTRY_ARRAY vi_movement_keymap;
#endif

#if defined(__polyspace_rl_undo_list) && !defined(__polyspace_no_rl_undo_list)
#include <readline/readline.h>
#undef rl_undo_list
  extern UNDO_LIST *rl_undo_list;
#endif

#if defined(__polyspace_funmap) && !defined(__polyspace_no_funmap)
#include <readline/readline.h>
#undef funmap
  extern FUNMAP **funmap;
#endif

#if defined(__polyspace_rl_library_version) && !defined(__polyspace_no_rl_library_version)
#include <readline/readline.h>
#undef rl_library_version
  extern char *rl_library_version;
#endif

#if defined(__polyspace_rl_readline_name) && !defined(__polyspace_no_rl_readline_name)
#include <readline/readline.h>
#undef rl_readline_name
  extern char *rl_readline_name;
#endif

#if defined(__polyspace_rl_prompt) && !defined(__polyspace_no_rl_prompt)
#include <readline/readline.h>
#undef rl_prompt
  extern char *rl_prompt;
#endif

#if defined(__polyspace_rl_line_buffer) && !defined(__polyspace_no_rl_line_buffer)
#include <readline/readline.h>
#undef rl_line_buffer
  extern char *rl_line_buffer;
#endif

#if defined(__polyspace_rl_point) && !defined(__polyspace_no_rl_point)
#include <readline/readline.h>
#undef rl_point
  extern int rl_point;
#endif

#if defined(__polyspace_rl_end) && !defined(__polyspace_no_rl_end)
#include <readline/readline.h>
#undef rl_end
  extern int rl_end;
#endif

#if defined(__polyspace_rl_mark) && !defined(__polyspace_no_rl_mark)
#include <readline/readline.h>
#undef rl_mark
  extern int rl_mark;
#endif

#if defined(__polyspace_rl_done) && !defined(__polyspace_no_rl_done)
#include <readline/readline.h>
#undef rl_done
  extern int rl_done;
#endif

#if defined(__polyspace_rl_pending_input) && !defined(__polyspace_no_rl_pending_input)
#include <readline/readline.h>
#undef rl_pending_input
  extern int rl_pending_input;
#endif

#if defined(__polyspace_rl_dispatching) && !defined(__polyspace_no_rl_dispatching)
#include <readline/readline.h>
#undef rl_dispatching
  extern int rl_dispatching;
#endif

#if defined(__polyspace_rl_terminal_name) && !defined(__polyspace_no_rl_terminal_name)
#include <readline/readline.h>
#undef rl_terminal_name
  extern char *rl_terminal_name;
#endif

#if defined(__polyspace_rl_instream) && !defined(__polyspace_no_rl_instream)
#include <readline/readline.h>
#undef rl_instream
  extern FILE *rl_instream;
#endif

#if defined(__polyspace_rl_outstream) && !defined(__polyspace_no_rl_outstream)
#include <readline/readline.h>
#undef rl_outstream
  extern FILE *rl_outstream;
#endif

#if defined(__polyspace_rl_startup_hook) && !defined(__polyspace_no_rl_startup_hook)
#include <readline/readline.h>
#undef rl_startup_hook
  extern Function *rl_startup_hook;
#endif

#if defined(__polyspace_rl_event_hook) && !defined(__polyspace_no_rl_event_hook)
#include <readline/readline.h>
#undef rl_event_hook
  extern Function *rl_event_hook;
#endif

#if defined(__polyspace_rl_getc_function) && !defined(__polyspace_no_rl_getc_function)
#include <readline/readline.h>
#undef rl_getc_function
  extern Function *rl_getc_function;
#endif

#if defined(__polyspace_rl_redisplay_function) && !defined(__polyspace_no_rl_redisplay_function)
#include <readline/readline.h>
#undef rl_redisplay_function
  extern VFunction *rl_redisplay_function;
#endif

#if defined(__polyspace_rl_prep_term_function) && !defined(__polyspace_no_rl_prep_term_function)
#include <readline/readline.h>
#undef rl_prep_term_function
  extern VFunction *rl_prep_term_function;
#endif

#if defined(__polyspace_rl_deprep_term_function) && !defined(__polyspace_no_rl_deprep_term_function)
#include <readline/readline.h>
#undef rl_deprep_term_function
  extern VFunction *rl_deprep_term_function;
#endif

#if defined(__polyspace_rl_executing_keymap) && !defined(__polyspace_no_rl_executing_keymap)
#include <readline/readline.h>
#undef rl_executing_keymap
  extern Keymap rl_executing_keymap;
#endif

#if defined(__polyspace_rl_binding_keymap) && !defined(__polyspace_no_rl_binding_keymap)
#include <readline/readline.h>
#undef rl_binding_keymap
  extern Keymap rl_binding_keymap;
#endif

#if defined(__polyspace_rl_completion_entry_function) && !defined(__polyspace_no_rl_completion_entry_function)
#include <readline/readline.h>
#undef rl_completion_entry_function
  extern Function *rl_completion_entry_function;
#endif

#if defined(__polyspace_rl_ignore_some_completions_function) && !defined(__polyspace_no_rl_ignore_some_completions_function)
#include <readline/readline.h>
#undef rl_ignore_some_completions_function
  extern Function *rl_ignore_some_completions_function;
#endif

#if defined(__polyspace_rl_attempted_completion_function) && !defined(__polyspace_no_rl_attempted_completion_function)
#include <readline/readline.h>
#undef rl_attempted_completion_function
  extern CPPFunction *rl_attempted_completion_function;
#endif

#if defined(__polyspace_rl_basic_word_break_characters) && !defined(__polyspace_no_rl_basic_word_break_characters)
#include <readline/readline.h>
#undef rl_basic_word_break_characters
  extern char *rl_basic_word_break_characters;
#endif

#if defined(__polyspace_rl_completer_word_break_characters) && !defined(__polyspace_no_rl_completer_word_break_characters)
#include <readline/readline.h>
#undef rl_completer_word_break_characters
  extern char *rl_completer_word_break_characters;
#endif

#if defined(__polyspace_rl_completer_quote_characters) && !defined(__polyspace_no_rl_completer_quote_characters)
#include <readline/readline.h>
#undef rl_completer_quote_characters
  extern char *rl_completer_quote_characters;
#endif

#if defined(__polyspace_rl_basic_quote_characters) && !defined(__polyspace_no_rl_basic_quote_characters)
#include <readline/readline.h>
#undef rl_basic_quote_characters
  extern char *rl_basic_quote_characters;
#endif

#if defined(__polyspace_rl_filename_quote_characters) && !defined(__polyspace_no_rl_filename_quote_characters)
#include <readline/readline.h>
#undef rl_filename_quote_characters
  extern char *rl_filename_quote_characters;
#endif

#if defined(__polyspace_rl_special_prefixes) && !defined(__polyspace_no_rl_special_prefixes)
#include <readline/readline.h>
#undef rl_special_prefixes
  extern char *rl_special_prefixes;
#endif

#if defined(__polyspace_rl_directory_completion_hook) && !defined(__polyspace_no_rl_directory_completion_hook)
#include <readline/readline.h>
#undef rl_directory_completion_hook
  extern Function *rl_directory_completion_hook;
#endif

#if defined(__polyspace_rl_filename_completion_desired) && !defined(__polyspace_no_rl_filename_completion_desired)
#include <readline/readline.h>
#undef rl_filename_completion_desired
  extern int rl_filename_completion_desired;
#endif

#if defined(__polyspace_rl_filename_quoting_desired) && !defined(__polyspace_no_rl_filename_quoting_desired)
#include <readline/readline.h>
#undef rl_filename_quoting_desired
  extern int rl_filename_quoting_desired;
#endif

#if defined(__polyspace_rl_filename_quoting_function) && !defined(__polyspace_no_rl_filename_quoting_function)
#include <readline/readline.h>
#undef rl_filename_quoting_function
  extern CPFunction *rl_filename_quoting_function;
#endif

#if defined(__polyspace_rl_filename_dequoting_function) && !defined(__polyspace_no_rl_filename_dequoting_function)
#include <readline/readline.h>
#undef rl_filename_dequoting_function
  extern CPFunction *rl_filename_dequoting_function;
#endif

#if defined(__polyspace_rl_char_is_quoted_p) && !defined(__polyspace_no_rl_char_is_quoted_p)
#include <readline/readline.h>
#undef rl_char_is_quoted_p
  extern Function *rl_char_is_quoted_p;
#endif

#if defined(__polyspace_rl_attempted_completion_over) && !defined(__polyspace_no_rl_attempted_completion_over)
#include <readline/readline.h>
#undef rl_attempted_completion_over
  extern int rl_attempted_completion_over;
#endif

#if defined(__polyspace_rl_completion_type) && !defined(__polyspace_no_rl_completion_type)
#include <readline/readline.h>
#undef rl_completion_type
  extern int rl_completion_type;
#endif

#if defined(__polyspace_rl_completion_append_character) && !defined(__polyspace_no_rl_completion_append_character)
#include <readline/readline.h>
#undef rl_completion_append_character
  extern int rl_completion_append_character;
#endif

#if defined(__polyspace_rl_completion_query_items) && !defined(__polyspace_no_rl_completion_query_items)
#include <readline/readline.h>
#undef rl_completion_query_items
  extern int rl_completion_query_items;
#endif

#if defined(__polyspace_rl_ignore_completion_duplicates) && !defined(__polyspace_no_rl_ignore_completion_duplicates)
#include <readline/readline.h>
#undef rl_ignore_completion_duplicates
  extern int rl_ignore_completion_duplicates;
#endif

#if defined(__polyspace_rl_inhibit_completion) && !defined(__polyspace_no_rl_inhibit_completion)
#include <readline/readline.h>
#undef rl_inhibit_completion
  extern int rl_inhibit_completion;
#endif

#if defined(__polyspace_tilde_expansion_preexpansion_hook) && !defined(__polyspace_no_tilde_expansion_preexpansion_hook)
#include <readline/tilde.h>
#undef tilde_expansion_preexpansion_hook
  extern CPFunction *tilde_expansion_preexpansion_hook;
#endif

#if defined(__polyspace_tilde_expansion_failure_hook) && !defined(__polyspace_no_tilde_expansion_failure_hook)
#include <readline/tilde.h>
#undef tilde_expansion_failure_hook
  extern CPFunction *tilde_expansion_failure_hook;
#endif

#if defined(__polyspace_tilde_additional_prefixes) && !defined(__polyspace_no_tilde_additional_prefixes)
#include <readline/tilde.h>
#undef tilde_additional_prefixes
  extern char **tilde_additional_prefixes;
#endif

#if defined(__polyspace_tilde_additional_suffixes) && !defined(__polyspace_no_tilde_additional_suffixes)
#include <readline/tilde.h>
#undef tilde_additional_suffixes
  extern char **tilde_additional_suffixes;
#endif

#if defined(__polyspace_re_syntax_options) && !defined(__polyspace_no_re_syntax_options)
#include <regex.h>
#undef re_syntax_options
  extern reg_syntax_t re_syntax_options;
#endif

#if defined(__polyspace_rle_dflt_hdr) && !defined(__polyspace_no_rle_dflt_hdr)
#include <rle.h>
#undef rle_dflt_hdr
  extern rle_hdr rle_dflt_hdr;
#endif

#if defined(__polyspace_loc1) && !defined(__polyspace_no_loc1)
#include <regexp.h>
#undef loc1
  extern char *loc1;
#endif

#if defined(__polyspace_loc2) && !defined(__polyspace_no_loc2)
#include <regexp.h>
#undef loc2
  extern char *loc2;
#endif

#if defined(__polyspace_locs) && !defined(__polyspace_no_locs)
#include <regexp.h>
#undef locs
  extern char *locs;
#endif

#if defined(__polyspace__res) && !defined(__polyspace_no__res)
#include <resolv.h>
#undef _res
  extern struct __res_state _res;
#endif

#if defined(__polyspace___p_class_syms) && !defined(__polyspace_no___p_class_syms)
#include <resolv.h>
#undef __p_class_syms
  extern const struct res_sym __p_class_syms[];
#endif

#if defined(__polyspace___p_type_syms) && !defined(__polyspace_no___p_type_syms)
#include <resolv.h>
#undef __p_type_syms
  extern const struct res_sym __p_type_syms[];
#endif

#if defined(__polyspace__null_auth) && !defined(__polyspace_no__null_auth)
#include <rpc/auth.h>
#undef _null_auth
  extern struct opaque_auth _null_auth;
#endif

#if defined(__polyspace_rpc_createerr) && !defined(__polyspace_no_rpc_createerr)
#include <rpc/clnt.h>
#undef rpc_createerr
  extern struct rpc_createerr rpc_createerr;
#endif

#if defined(__polyspace_svc_fdset) && !defined(__polyspace_no_svc_fdset)
#include <rpc/svc.h>
#undef svc_fdset
  extern fd_set svc_fdset;
#endif

#if defined(__polyspace_svc_fds) && !defined(__polyspace_no_svc_fds)
#include <rpc/svc.h>
#undef svc_fds
  extern int svc_fds;
#endif

#if defined(__polyspace_headerDefaultFormats) && !defined(__polyspace_no_headerDefaultFormats)
#include <rpm/header.h>
#undef headerDefaultFormats
  extern const struct headerSprintfExtension headerDefaultFormats[];
#endif

#if defined(__polyspace_gzdio) && !defined(__polyspace_no_gzdio)
#include <rpm/rpmio.h>
#undef gzdio
  extern FDIO_t gzdio;
#endif

#if defined(__polyspace_fdio) && !defined(__polyspace_no_fdio)
#include <rpm/rpmio.h>
#undef fdio
  extern FDIO_t fdio;
#endif

#if defined(__polyspace_fpio) && !defined(__polyspace_no_fpio)
#include <rpm/rpmio.h>
#undef fpio
  extern FDIO_t fpio;
#endif

#if defined(__polyspace_ufdio) && !defined(__polyspace_no_ufdio)
#include <rpm/rpmio.h>
#undef ufdio
  extern FDIO_t ufdio;
#endif

#if defined(__polyspace_fadio) && !defined(__polyspace_no_fadio)
#include <rpm/rpmio.h>
#undef fadio
  extern FDIO_t fadio;
#endif

#if defined(__polyspace_bzdio) && !defined(__polyspace_no_bzdio)
#include <rpm/rpmio.h>
#undef bzdio
  extern FDIO_t bzdio;
#endif

#if defined(__polyspace_rpmTagTable) && !defined(__polyspace_no_rpmTagTable)
#include <rpm/rpmlib.h>
#undef rpmTagTable
  extern const struct headerTagTableEntry rpmTagTable[];
#endif

#if defined(__polyspace_rpmTagTableSize) && !defined(__polyspace_no_rpmTagTableSize)
#include <rpm/rpmlib.h>
#undef rpmTagTableSize
  extern const int rpmTagTableSize;
#endif

#if defined(__polyspace_rpmHeaderFormats) && !defined(__polyspace_no_rpmHeaderFormats)
#include <rpm/rpmlib.h>
#undef rpmHeaderFormats
  extern const struct headerSprintfExtension rpmHeaderFormats[];
#endif

#if defined(__polyspace_rpmQVSourcePoptTable) && !defined(__polyspace_no_rpmQVSourcePoptTable)
#include <rpm/rpmlib.h>
#undef rpmQVSourcePoptTable
  extern struct poptOption rpmQVSourcePoptTable[];
#endif

#if defined(__polyspace_specedit) && !defined(__polyspace_no_specedit)
#include <rpm/rpmlib.h>
#undef specedit
  extern int specedit;
#endif

#if defined(__polyspace_rpmQueryPoptTable) && !defined(__polyspace_no_rpmQueryPoptTable)
#include <rpm/rpmlib.h>
#undef rpmQueryPoptTable
  extern struct poptOption rpmQueryPoptTable[];
#endif

#if defined(__polyspace_rpmVerifyPoptTable) && !defined(__polyspace_no_rpmVerifyPoptTable)
#include <rpm/rpmlib.h>
#undef rpmVerifyPoptTable
  extern struct poptOption rpmVerifyPoptTable[];
#endif

#if defined(__polyspace_pam_misc_conv_warn_time) && !defined(__polyspace_no_pam_misc_conv_warn_time)
#include <security/pam_misc.h>
#undef pam_misc_conv_warn_time
  extern time_t pam_misc_conv_warn_time;
#endif

#if defined(__polyspace_pam_misc_conv_die_time) && !defined(__polyspace_no_pam_misc_conv_die_time)
#include <security/pam_misc.h>
#undef pam_misc_conv_die_time
  extern time_t pam_misc_conv_die_time;
#endif

#if defined(__polyspace_pam_misc_conv_warn_line) && !defined(__polyspace_no_pam_misc_conv_warn_line)
#include <security/pam_misc.h>
#undef pam_misc_conv_warn_line
  extern const char *pam_misc_conv_warn_line;
#endif

#if defined(__polyspace_pam_misc_conv_die_line) && !defined(__polyspace_no_pam_misc_conv_die_line)
#include <security/pam_misc.h>
#undef pam_misc_conv_die_line
  extern const char *pam_misc_conv_die_line;
#endif

#if defined(__polyspace_pam_misc_conv_died) && !defined(__polyspace_no_pam_misc_conv_died)
#include <security/pam_misc.h>
#undef pam_misc_conv_died
  extern int pam_misc_conv_died;
#endif

#if defined(__polyspace_SLang_Error) && !defined(__polyspace_no_SLang_Error)
#include <slang/slang.h>
#undef SLang_Error
  extern volatile int SLang_Error;
#endif

#if defined(__polyspace_SLang_Traceback) && !defined(__polyspace_no_SLang_Traceback)
#include <slang/slang.h>
#undef SLang_Traceback
  extern int SLang_Traceback;
#endif

#if defined(__polyspace_SLang_User_Prompt) && !defined(__polyspace_no_SLang_User_Prompt)
#include <slang/slang.h>
#undef SLang_User_Prompt
  extern char *SLang_User_Prompt;
#endif

#if defined(__polyspace_SLang_Version) && !defined(__polyspace_no_SLang_Version)
#include <slang/slang.h>
#undef SLang_Version
  extern int SLang_Version;
#endif

#if defined(__polyspace_SLang_Num_Function_Args) && !defined(__polyspace_no_SLang_Num_Function_Args)
#include <slang/slang.h>
#undef SLang_Num_Function_Args
  extern int SLang_Num_Function_Args;
#endif

#if defined(__polyspace_SLang_TT_Baud_Rate) && !defined(__polyspace_no_SLang_TT_Baud_Rate)
#include <slang/slang.h>
#undef SLang_TT_Baud_Rate
  extern int SLang_TT_Baud_Rate;
#endif

#if defined(__polyspace_SLang_TT_Read_FD) && !defined(__polyspace_no_SLang_TT_Read_FD)
#include <slang/slang.h>
#undef SLang_TT_Read_FD
  extern int SLang_TT_Read_FD;
#endif

#if defined(__polyspace_SLang_Abort_Char) && !defined(__polyspace_no_SLang_Abort_Char)
#include <slang/slang.h>
#undef SLang_Abort_Char
  extern int SLang_Abort_Char;
#endif

#if defined(__polyspace_SLang_Ignore_User_Abort) && !defined(__polyspace_no_SLang_Ignore_User_Abort)
#include <slang/slang.h>
#undef SLang_Ignore_User_Abort
  extern int SLang_Ignore_User_Abort;
#endif

#if defined(__polyspace_SLang_Input_Buffer_Len) && !defined(__polyspace_no_SLang_Input_Buffer_Len)
#include <slang/slang.h>
#undef SLang_Input_Buffer_Len
  extern unsigned int SLang_Input_Buffer_Len;
#endif

#if defined(__polyspace_SLKeyBoard_Quit) && !defined(__polyspace_no_SLKeyBoard_Quit)
#include <slang/slang.h>
#undef SLKeyBoard_Quit
  extern volatile int SLKeyBoard_Quit;
#endif

#if defined(__polyspace_SLKeyMap_List) && !defined(__polyspace_no_SLKeyMap_List)
#include <slang/slang.h>
#undef SLKeyMap_List
  extern SLKeyMap_List_Type SLKeyMap_List[SLANG_MAX_KEYMAPS];
#endif

#if defined(__polyspace_SLang_Last_Key_Char) && !defined(__polyspace_no_SLang_Last_Key_Char)
#include <slang/slang.h>
#undef SLang_Last_Key_Char
  extern int SLang_Last_Key_Char;
#endif

#if defined(__polyspace_SLang_Key_TimeOut_Flag) && !defined(__polyspace_no_SLang_Key_TimeOut_Flag)
#include <slang/slang.h>
#undef SLang_Key_TimeOut_Flag
  extern int SLang_Key_TimeOut_Flag;
#endif

#if defined(__polyspace_SLang_RL_EOF_Char) && !defined(__polyspace_no_SLang_RL_EOF_Char)
#include <slang/slang.h>
#undef SLang_RL_EOF_Char
  extern int SLang_RL_EOF_Char;
#endif

#if defined(__polyspace_SLang_Rline_Quit) && !defined(__polyspace_no_SLang_Rline_Quit)
#include <slang/slang.h>
#undef SLang_Rline_Quit
  extern int SLang_Rline_Quit;
#endif

#if defined(__polyspace_SLtt_Num_Chars_Output) && !defined(__polyspace_no_SLtt_Num_Chars_Output)
#include <slang/slang.h>
#undef SLtt_Num_Chars_Output
  extern unsigned long SLtt_Num_Chars_Output;
#endif

#if defined(__polyspace_SLtt_Baud_Rate) && !defined(__polyspace_no_SLtt_Baud_Rate)
#include <slang/slang.h>
#undef SLtt_Baud_Rate
  extern int SLtt_Baud_Rate;
#endif

#if defined(__polyspace_SLtt_Screen_Rows) && !defined(__polyspace_no_SLtt_Screen_Rows)
#include <slang/slang.h>
#undef SLtt_Screen_Rows
  extern int SLtt_Screen_Rows;
#endif

#if defined(__polyspace_SLtt_Screen_Cols) && !defined(__polyspace_no_SLtt_Screen_Cols)
#include <slang/slang.h>
#undef SLtt_Screen_Cols
  extern int SLtt_Screen_Cols;
#endif

#if defined(__polyspace_SLtt_Term_Cannot_Insert) && !defined(__polyspace_no_SLtt_Term_Cannot_Insert)
#include <slang/slang.h>
#undef SLtt_Term_Cannot_Insert
  extern int SLtt_Term_Cannot_Insert;
#endif

#if defined(__polyspace_SLtt_Term_Cannot_Scroll) && !defined(__polyspace_no_SLtt_Term_Cannot_Scroll)
#include <slang/slang.h>
#undef SLtt_Term_Cannot_Scroll
  extern int SLtt_Term_Cannot_Scroll;
#endif

#if defined(__polyspace_SLtt_Use_Ansi_Colors) && !defined(__polyspace_no_SLtt_Use_Ansi_Colors)
#include <slang/slang.h>
#undef SLtt_Use_Ansi_Colors
  extern int SLtt_Use_Ansi_Colors;
#endif

#if defined(__polyspace_SLtt_Ignore_Beep) && !defined(__polyspace_no_SLtt_Ignore_Beep)
#include <slang/slang.h>
#undef SLtt_Ignore_Beep
  extern int SLtt_Ignore_Beep;
#endif

#if defined(__polyspace_SLtt_Force_Keypad_Init) && !defined(__polyspace_no_SLtt_Force_Keypad_Init)
#include <slang/slang.h>
#undef SLtt_Force_Keypad_Init
  extern int SLtt_Force_Keypad_Init;
#endif

#if defined(__polyspace_SLtt_Graphics_Char_Pairs) && !defined(__polyspace_no_SLtt_Graphics_Char_Pairs)
#include <slang/slang.h>
#undef SLtt_Graphics_Char_Pairs
  extern char *SLtt_Graphics_Char_Pairs;
#endif

#if defined(__polyspace_SLtt_Blink_Mode) && !defined(__polyspace_no_SLtt_Blink_Mode)
#include <slang/slang.h>
#undef SLtt_Blink_Mode
  extern int SLtt_Blink_Mode;
#endif

#if defined(__polyspace_SLtt_Use_Blink_For_ACS) && !defined(__polyspace_no_SLtt_Use_Blink_For_ACS)
#include <slang/slang.h>
#undef SLtt_Use_Blink_For_ACS
  extern int SLtt_Use_Blink_For_ACS;
#endif

#if defined(__polyspace_SLtt_Newline_Ok) && !defined(__polyspace_no_SLtt_Newline_Ok)
#include <slang/slang.h>
#undef SLtt_Newline_Ok
  extern int SLtt_Newline_Ok;
#endif

#if defined(__polyspace_SLtt_Has_Alt_Charset) && !defined(__polyspace_no_SLtt_Has_Alt_Charset)
#include <slang/slang.h>
#undef SLtt_Has_Alt_Charset
  extern int SLtt_Has_Alt_Charset;
#endif

#if defined(__polyspace_SLtt_Has_Status_Line) && !defined(__polyspace_no_SLtt_Has_Status_Line)
#include <slang/slang.h>
#undef SLtt_Has_Status_Line
  extern int SLtt_Has_Status_Line;
#endif

#if defined(__polyspace_SLtt_Try_Termcap) && !defined(__polyspace_no_SLtt_Try_Termcap)
#include <slang/slang.h>
#undef SLtt_Try_Termcap
  extern int SLtt_Try_Termcap;
#endif

#if defined(__polyspace_SLtt_Msdos_Cheap_Video) && !defined(__polyspace_no_SLtt_Msdos_Cheap_Video)
#include <slang/slang.h>
#undef SLtt_Msdos_Cheap_Video
  extern int SLtt_Msdos_Cheap_Video;
#endif

#if defined(__polyspace_SLsmg_Scroll_Hash_Border) && !defined(__polyspace_no_SLsmg_Scroll_Hash_Border)
#include <slang/slang.h>
#undef SLsmg_Scroll_Hash_Border
  extern int SLsmg_Scroll_Hash_Border;
#endif

#if defined(__polyspace_SLsmg_Display_Eight_Bit) && !defined(__polyspace_no_SLsmg_Display_Eight_Bit)
#include <slang/slang.h>
#undef SLsmg_Display_Eight_Bit
  extern int SLsmg_Display_Eight_Bit;
#endif

#if defined(__polyspace_SLsmg_Tab_Width) && !defined(__polyspace_no_SLsmg_Tab_Width)
#include <slang/slang.h>
#undef SLsmg_Tab_Width
  extern int SLsmg_Tab_Width;
#endif

#if defined(__polyspace_SLsmg_Newline_Behavior) && !defined(__polyspace_no_SLsmg_Newline_Behavior)
#include <slang/slang.h>
#undef SLsmg_Newline_Behavior
  extern int SLsmg_Newline_Behavior;
#endif

#if defined(__polyspace_SLsmg_Backspace_Moves) && !defined(__polyspace_no_SLsmg_Backspace_Moves)
#include <slang/slang.h>
#undef SLsmg_Backspace_Moves
  extern int SLsmg_Backspace_Moves;
#endif

#if defined(__polyspace_SLang_Error_Message) && !defined(__polyspace_no_SLang_Error_Message)
#include <slang/slang.h>
#undef SLang_Error_Message
  extern char *SLang_Error_Message;
#endif

#if defined(__polyspace__SLChg_UCase_Lut) && !defined(__polyspace_no__SLChg_UCase_Lut)
#include <slang/slang.h>
#undef _SLChg_UCase_Lut
  extern unsigned char _SLChg_UCase_Lut[256];
#endif

#if defined(__polyspace__SLChg_LCase_Lut) && !defined(__polyspace_no__SLChg_LCase_Lut)
#include <slang/slang.h>
#undef _SLChg_LCase_Lut
  extern unsigned char _SLChg_LCase_Lut[256];
#endif

#if defined(__polyspace_SLcurses_Stdscr) && !defined(__polyspace_no_SLcurses_Stdscr)
#include <slang/slcurses.h>
#undef SLcurses_Stdscr
  extern SLcurses_Window_Type *SLcurses_Stdscr;
#endif

#if defined(__polyspace_SLcurses_Is_Endwin) && !defined(__polyspace_no_SLcurses_Is_Endwin)
#include <slang/slcurses.h>
#undef SLcurses_Is_Endwin
  extern int SLcurses_Is_Endwin;
#endif

#if defined(__polyspace_SLcurses_Num_Colors) && !defined(__polyspace_no_SLcurses_Num_Colors)
#include <slang/slcurses.h>
#undef SLcurses_Num_Colors
  extern int SLcurses_Num_Colors;
#endif

#if defined(__polyspace_SLcurses_Esc_Delay) && !defined(__polyspace_no_SLcurses_Esc_Delay)
#include <slang/slcurses.h>
#undef SLcurses_Esc_Delay
  extern int SLcurses_Esc_Delay;
#endif

#if defined(__polyspace___bb_head) && !defined(__polyspace_no___bb_head)
#include <sys/gmon.h>
#undef __bb_head
  extern struct __bb *__bb_head;
#endif

#if defined(__polyspace__gmonparam) && !defined(__polyspace_no__gmonparam)
#include <sys/gmon.h>
#undef _gmonparam
  extern struct gmonparam _gmonparam;
#endif

#if defined(__polyspace_Dbg_VarName) && !defined(__polyspace_no_Dbg_VarName)
#include <tcldbg.h>
#undef Dbg_VarName
  EXTERN char *Dbg_VarName;
#endif

#if defined(__polyspace_Dbg_DefaultCmdName) && !defined(__polyspace_no_Dbg_DefaultCmdName)
#include <tcldbg.h>
#undef Dbg_DefaultCmdName
  EXTERN char *Dbg_DefaultCmdName;
#endif

#if defined(__polyspace_unknown) && !defined(__polyspace_no_unknown)
#include <tcpd.h>
#undef unknown
  extern char unknown[];
#endif

#if defined(__polyspace_paranoid) && !defined(__polyspace_no_paranoid)
#include <tcpd.h>
#undef paranoid
  extern char paranoid[];
#endif

#if defined(__polyspace_allow_severity) && !defined(__polyspace_no_allow_severity)
#include <tcpd.h>
#undef allow_severity
  extern int allow_severity;
#endif

#if defined(__polyspace_deny_severity) && !defined(__polyspace_no_deny_severity)
#include <tcpd.h>
#undef deny_severity
  extern int deny_severity;
#endif

#if defined(__polyspace_hosts_allow_table) && !defined(__polyspace_no_hosts_allow_table)
#include <tcpd.h>
#undef hosts_allow_table
  extern char *hosts_allow_table;
#endif

#if defined(__polyspace_hosts_deny_table) && !defined(__polyspace_no_hosts_deny_table)
#include <tcpd.h>
#undef hosts_deny_table
  extern char *hosts_deny_table;
#endif

#if defined(__polyspace_hosts_access_verbose) && !defined(__polyspace_no_hosts_access_verbose)
#include <tcpd.h>
#undef hosts_access_verbose
  extern int hosts_access_verbose;
#endif

#if defined(__polyspace_rfc931_timeout) && !defined(__polyspace_no_rfc931_timeout)
#include <tcpd.h>
#undef rfc931_timeout
  extern int rfc931_timeout;
#endif

#if defined(__polyspace_resident) && !defined(__polyspace_no_resident)
#include <tcpd.h>
#undef resident
  extern int resident;
#endif

#if defined(__polyspace_tcpd_context) && !defined(__polyspace_no_tcpd_context)
#include <tcpd.h>
#undef tcpd_context
  extern struct tcpd_context tcpd_context;
#endif

#if defined(__polyspace_dry_run) && !defined(__polyspace_no_dry_run)
#include <tcpd.h>
#undef dry_run
  extern int dry_run;
#endif

#if defined(__polyspace_PC) && !defined(__polyspace_no_PC)
#include <termcap.h>
#undef PC
  extern char PC;
#endif

#if defined(__polyspace_tixConfigItemType) && !defined(__polyspace_no_tixConfigItemType)
#include <tix.h>
#undef tixConfigItemType
  extern Tk_CustomOption tixConfigItemType;
#endif

#if defined(__polyspace_tixConfigItemStyle) && !defined(__polyspace_no_tixConfigItemStyle)
#include <tix.h>
#undef tixConfigItemStyle
  extern Tk_CustomOption tixConfigItemStyle;
#endif

#if defined(__polyspace_tixConfigRelief) && !defined(__polyspace_no_tixConfigRelief)
#include <tix.h>
#undef tixConfigRelief
  extern Tk_CustomOption tixConfigRelief;
#endif

#if defined(__polyspace___environ) && !defined(__polyspace_no___environ)
#include <unistd.h>
#undef __environ
  extern char **__environ;
#endif

#if defined(__polyspace_environ) && !defined(__polyspace_no_environ)
#include <unistd.h>
#undef environ
  extern char **environ;
#endif

#if defined(__polyspace___libc_enable_secure) && !defined(__polyspace_no___libc_enable_secure)
#include <unistd.h>
#undef __libc_enable_secure
  extern int __libc_enable_secure;
#endif

#if defined(__polyspace_uuyctr) && !defined(__polyspace_no_uuyctr)
#include <uuint.h>
#undef uuyctr
  extern unsigned long uuyctr;
#endif

#if defined(__polyspace_hlcount) && !defined(__polyspace_no_hlcount)
#include <uuint.h>
#undef hlcount
  extern headercount hlcount;
#endif

#if defined(__polyspace_uu_MsgCBArg) && !defined(__polyspace_no_uu_MsgCBArg)
#include <uuint.h>
#undef uu_MsgCBArg
  extern void *uu_MsgCBArg;
#endif

#if defined(__polyspace_uu_BusyCBArg) && !defined(__polyspace_no_uu_BusyCBArg)
#include <uuint.h>
#undef uu_BusyCBArg
  extern void *uu_BusyCBArg;
#endif

#if defined(__polyspace_uu_FileCBArg) && !defined(__polyspace_no_uu_FileCBArg)
#include <uuint.h>
#undef uu_FileCBArg
  extern void *uu_FileCBArg;
#endif

#if defined(__polyspace_uu_FFCBArg) && !defined(__polyspace_no_uu_FFCBArg)
#include <uuint.h>
#undef uu_FFCBArg
  extern void *uu_FFCBArg;
#endif

#if defined(__polyspace_uu_fast_scanning) && !defined(__polyspace_no_uu_fast_scanning)
#include <uuint.h>
#undef uu_fast_scanning
  extern int uu_fast_scanning;
#endif

#if defined(__polyspace_uu_bracket_policy) && !defined(__polyspace_no_uu_bracket_policy)
#include <uuint.h>
#undef uu_bracket_policy
  extern int uu_bracket_policy;
#endif

#if defined(__polyspace_uu_verbose) && !defined(__polyspace_no_uu_verbose)
#include <uuint.h>
#undef uu_verbose
  extern int uu_verbose;
#endif

#if defined(__polyspace_uu_desperate) && !defined(__polyspace_no_uu_desperate)
#include <uuint.h>
#undef uu_desperate
  extern int uu_desperate;
#endif

#if defined(__polyspace_uu_ignreply) && !defined(__polyspace_no_uu_ignreply)
#include <uuint.h>
#undef uu_ignreply
  extern int uu_ignreply;
#endif

#if defined(__polyspace_uu_debug) && !defined(__polyspace_no_uu_debug)
#include <uuint.h>
#undef uu_debug
  extern int uu_debug;
#endif

#if defined(__polyspace_uu_errno) && !defined(__polyspace_no_uu_errno)
#include <uuint.h>
#undef uu_errno
  extern int uu_errno;
#endif

#if defined(__polyspace_uu_dumbness) && !defined(__polyspace_no_uu_dumbness)
#include <uuint.h>
#undef uu_dumbness
  extern int uu_dumbness;
#endif

#if defined(__polyspace_uu_overwrite) && !defined(__polyspace_no_uu_overwrite)
#include <uuint.h>
#undef uu_overwrite
  extern int uu_overwrite;
#endif

#if defined(__polyspace_uu_ignmode) && !defined(__polyspace_no_uu_ignmode)
#include <uuint.h>
#undef uu_ignmode
  extern int uu_ignmode;
#endif

#if defined(__polyspace_uu_headercount) && !defined(__polyspace_no_uu_headercount)
#include <uuint.h>
#undef uu_headercount
  extern int uu_headercount;
#endif

#if defined(__polyspace_uu_usepreamble) && !defined(__polyspace_no_uu_usepreamble)
#include <uuint.h>
#undef uu_usepreamble
  extern int uu_usepreamble;
#endif

#if defined(__polyspace_uu_handletext) && !defined(__polyspace_no_uu_handletext)
#include <uuint.h>
#undef uu_handletext
  extern int uu_handletext;
#endif

#if defined(__polyspace_uu_tinyb64) && !defined(__polyspace_no_uu_tinyb64)
#include <uuint.h>
#undef uu_tinyb64
  extern int uu_tinyb64;
#endif

#if defined(__polyspace_uusavepath) && !defined(__polyspace_no_uusavepath)
#include <uuint.h>
#undef uusavepath
  extern char *uusavepath;
#endif

#if defined(__polyspace_uuencodeext) && !defined(__polyspace_no_uuencodeext)
#include <uuint.h>
#undef uuencodeext
  extern char *uuencodeext;
#endif

#if defined(__polyspace_UUEncodeTable) && !defined(__polyspace_no_UUEncodeTable)
#include <uuint.h>
#undef UUEncodeTable
  extern unsigned char UUEncodeTable[];
#endif

#if defined(__polyspace_XXEncodeTable) && !defined(__polyspace_no_XXEncodeTable)
#include <uuint.h>
#undef XXEncodeTable
  extern unsigned char XXEncodeTable[];
#endif

#if defined(__polyspace_B64EncodeTable) && !defined(__polyspace_no_B64EncodeTable)
#include <uuint.h>
#undef B64EncodeTable
  extern unsigned char B64EncodeTable[];
#endif

#if defined(__polyspace_BHEncodeTable) && !defined(__polyspace_no_BHEncodeTable)
#include <uuint.h>
#undef BHEncodeTable
  extern unsigned char BHEncodeTable[];
#endif

#if defined(__polyspace_msgnames) && !defined(__polyspace_no_msgnames)
#include <uuint.h>
#undef msgnames
  extern char *msgnames[];
#endif

#if defined(__polyspace_codenames) && !defined(__polyspace_no_codenames)
#include <uuint.h>
#undef codenames
  extern char *codenames[];
#endif

#if defined(__polyspace_uuretcodes) && !defined(__polyspace_no_uuretcodes)
#include <uuint.h>
#undef uuretcodes
  extern char *uuretcodes[];
#endif

#if defined(__polyspace_UUGlobalFileList) && !defined(__polyspace_no_UUGlobalFileList)
#include <uuint.h>
#undef UUGlobalFileList
  extern uulist *UUGlobalFileList;
#endif

#if defined(__polyspace_nofnum) && !defined(__polyspace_no_nofnum)
#include <uuint.h>
#undef nofnum
  extern int nofnum;
#endif

#if defined(__polyspace_mssdepth) && !defined(__polyspace_no_mssdepth)
#include <uuint.h>
#undef mssdepth
  extern int mssdepth;
#endif

#if defined(__polyspace_mimseqno) && !defined(__polyspace_no_mimseqno)
#include <uuint.h>
#undef mimseqno
  extern int mimseqno;
#endif

#if defined(__polyspace_lastvalid) && !defined(__polyspace_no_lastvalid)
#include <uuint.h>
#undef lastvalid
  extern int lastvalid;
#endif

#if defined(__polyspace_lastenc) && !defined(__polyspace_no_lastenc)
#include <uuint.h>
#undef lastenc
  extern int lastenc;
#endif

#if defined(__polyspace_multistack) && !defined(__polyspace_no_multistack)
#include <uuint.h>
#undef multistack
  extern scanstate multistack[];
#endif

#if defined(__polyspace_localenv) && !defined(__polyspace_no_localenv)
#include <uuint.h>
#undef localenv
  extern headers localenv;
#endif

#if defined(__polyspace_sstate) && !defined(__polyspace_no_sstate)
#include <uuint.h>
#undef sstate
  extern scanstate sstate;
#endif

#if defined(__polyspace_progress) && !defined(__polyspace_no_progress)
#include <uuint.h>
#undef progress
  extern uuprogress progress;
#endif

#if defined(__polyspace_uugen_fnbuffer) && !defined(__polyspace_no_uugen_fnbuffer)
#include <uuint.h>
#undef uugen_fnbuffer
  extern char *uugen_fnbuffer;
#endif

#if defined(__polyspace_uugen_inbuffer) && !defined(__polyspace_no_uugen_inbuffer)
#include <uuint.h>
#undef uugen_inbuffer
  extern char *uugen_inbuffer;
#endif

#if defined(__polyspace_uucheck_lastname) && !defined(__polyspace_no_uucheck_lastname)
#include <uuint.h>
#undef uucheck_lastname
  extern char *uucheck_lastname;
#endif

#if defined(__polyspace_uucheck_tempname) && !defined(__polyspace_no_uucheck_tempname)
#include <uuint.h>
#undef uucheck_tempname
  extern char *uucheck_tempname;
#endif

#if defined(__polyspace_uuestr_itemp) && !defined(__polyspace_no_uuestr_itemp)
#include <uuint.h>
#undef uuestr_itemp
  extern char *uuestr_itemp;
#endif

#if defined(__polyspace_uuestr_otemp) && !defined(__polyspace_no_uuestr_otemp)
#include <uuint.h>
#undef uuestr_otemp
  extern char *uuestr_otemp;
#endif

#if defined(__polyspace_uulib_msgstring) && !defined(__polyspace_no_uulib_msgstring)
#include <uuint.h>
#undef uulib_msgstring
  extern char *uulib_msgstring;
#endif

#if defined(__polyspace_uuncdl_fulline) && !defined(__polyspace_no_uuncdl_fulline)
#include <uuint.h>
#undef uuncdl_fulline
  extern char *uuncdl_fulline;
#endif

#if defined(__polyspace_uuncdp_oline) && !defined(__polyspace_no_uuncdp_oline)
#include <uuint.h>
#undef uuncdp_oline
  extern char *uuncdp_oline;
#endif

#if defined(__polyspace_uuscan_shlline) && !defined(__polyspace_no_uuscan_shlline)
#include <uuint.h>
#undef uuscan_shlline
  extern char *uuscan_shlline;
#endif

#if defined(__polyspace_uuscan_pvvalue) && !defined(__polyspace_no_uuscan_pvvalue)
#include <uuint.h>
#undef uuscan_pvvalue
  extern char *uuscan_pvvalue;
#endif

#if defined(__polyspace_uuscan_phtext) && !defined(__polyspace_no_uuscan_phtext)
#include <uuint.h>
#undef uuscan_phtext
  extern char *uuscan_phtext;
#endif

#if defined(__polyspace_uuscan_sdline) && !defined(__polyspace_no_uuscan_sdline)
#include <uuint.h>
#undef uuscan_sdline
  extern char *uuscan_sdline;
#endif

#if defined(__polyspace_uuscan_sdbhds1) && !defined(__polyspace_no_uuscan_sdbhds1)
#include <uuint.h>
#undef uuscan_sdbhds1
  extern char *uuscan_sdbhds1;
#endif

#if defined(__polyspace_uuscan_sdbhds2) && !defined(__polyspace_no_uuscan_sdbhds2)
#include <uuint.h>
#undef uuscan_sdbhds2
  extern char *uuscan_sdbhds2;
#endif

#if defined(__polyspace_uuscan_spline) && !defined(__polyspace_no_uuscan_spline)
#include <uuint.h>
#undef uuscan_spline
  extern char *uuscan_spline;
#endif

#if defined(__polyspace_uuutil_bhwtmp) && !defined(__polyspace_no_uuutil_bhwtmp)
#include <uuint.h>
#undef uuutil_bhwtmp
  extern char *uuutil_bhwtmp;
#endif

#if defined(__polyspace_uunconc_UUxlat) && !defined(__polyspace_no_uunconc_UUxlat)
#include <uuint.h>
#undef uunconc_UUxlat
  extern char *uunconc_UUxlat;
#endif

#if defined(__polyspace_uunconc_UUxlen) && !defined(__polyspace_no_uunconc_UUxlen)
#include <uuint.h>
#undef uunconc_UUxlen
  extern char *uunconc_UUxlen;
#endif

#if defined(__polyspace_uunconc_B64xlat) && !defined(__polyspace_no_uunconc_B64xlat)
#include <uuint.h>
#undef uunconc_B64xlat
  extern char *uunconc_B64xlat;
#endif

#if defined(__polyspace_uunconc_XXxlat) && !defined(__polyspace_no_uunconc_XXxlat)
#include <uuint.h>
#undef uunconc_XXxlat
  extern char *uunconc_XXxlat;
#endif

#if defined(__polyspace_uunconc_BHxlat) && !defined(__polyspace_no_uunconc_BHxlat)
#include <uuint.h>
#undef uunconc_BHxlat
  extern char *uunconc_BHxlat;
#endif

#if defined(__polyspace_uunconc_save) && !defined(__polyspace_no_uunconc_save)
#include <uuint.h>
#undef uunconc_save
  extern char *uunconc_save;
#endif

#if defined(__polyspace_graph_mem) && !defined(__polyspace_no_graph_mem)
#include <vga.h>
#undef graph_mem
  extern unsigned char *graph_mem;
#endif

#if defined(__polyspace_currentcontext) && !defined(__polyspace_no_currentcontext)
#include <vgagl.h>
#undef currentcontext
  extern GraphicsContext currentcontext;
#endif

#if defined(__polyspace_gl_font8x8) && !defined(__polyspace_no_gl_font8x8)
#include <vgagl.h>
#undef gl_font8x8
  extern unsigned char *gl_font8x8;
#endif

#if defined(__polyspace___ctype32_b) && !defined(__polyspace_no___ctype32_b)
#include <wctype.h>
#undef __ctype32_b
  extern unsigned int *__ctype32_b;
#endif

#if defined(__polyspace_z_errmsg) && !defined(__polyspace_no_z_errmsg)
#include <zutil.h>
#undef z_errmsg
  extern const char *z_errmsg[10];
#endif

#if defined(__polyspace_z_verbose) && !defined(__polyspace_no_z_verbose)
#include <zutil.h>
#undef z_verbose
  extern int z_verbose;
#endif


/****************************************************************************
 *  NON-STD LIBRARIES - OS-TARGET SOLARIS
 ****************************************************************************/
#elif defined(__OS_SOLARIS)


#if defined(__polyspace__MrmMsg_0000) && !defined(__polyspace_no__MrmMsg_0000)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0000
  externalref _MrmConst char *_MrmMsg_0000;
#endif

#if defined(__polyspace__MrmMsg_0001) && !defined(__polyspace_no__MrmMsg_0001)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0001
  externalref _MrmConst char *_MrmMsg_0001;
#endif

#if defined(__polyspace__MrmMsg_0002) && !defined(__polyspace_no__MrmMsg_0002)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0002
  externalref _MrmConst char *_MrmMsg_0002;
#endif

#if defined(__polyspace__MrmMsg_0003) && !defined(__polyspace_no__MrmMsg_0003)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0003
  externalref _MrmConst char *_MrmMsg_0003;
#endif

#if defined(__polyspace__MrmMsg_0004) && !defined(__polyspace_no__MrmMsg_0004)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0004
  externalref _MrmConst char *_MrmMsg_0004;
#endif

#if defined(__polyspace__MrmMsg_0005) && !defined(__polyspace_no__MrmMsg_0005)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0005
  externalref _MrmConst char *_MrmMsg_0005;
#endif

#if defined(__polyspace__MrmMsg_0006) && !defined(__polyspace_no__MrmMsg_0006)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0006
  externalref _MrmConst char *_MrmMsg_0006;
#endif

#if defined(__polyspace__MrmMsg_0007) && !defined(__polyspace_no__MrmMsg_0007)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0007
  externalref _MrmConst char *_MrmMsg_0007;
#endif

#if defined(__polyspace__MrmMsg_0008) && !defined(__polyspace_no__MrmMsg_0008)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0008
  externalref _MrmConst char *_MrmMsg_0008;
#endif

#if defined(__polyspace__MrmMsg_0009) && !defined(__polyspace_no__MrmMsg_0009)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0009
  externalref _MrmConst char *_MrmMsg_0009;
#endif

#if defined(__polyspace__MrmMsg_0010) && !defined(__polyspace_no__MrmMsg_0010)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0010
  externalref _MrmConst char *_MrmMsg_0010;
#endif

#if defined(__polyspace__MrmMsg_0011) && !defined(__polyspace_no__MrmMsg_0011)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0011
  externalref _MrmConst char *_MrmMsg_0011;
#endif

#if defined(__polyspace__MrmMsg_0012) && !defined(__polyspace_no__MrmMsg_0012)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0012
  externalref _MrmConst char *_MrmMsg_0012;
#endif

#if defined(__polyspace__MrmMsg_0013) && !defined(__polyspace_no__MrmMsg_0013)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0013
  externalref _MrmConst char *_MrmMsg_0013;
#endif

#if defined(__polyspace__MrmMsg_0014) && !defined(__polyspace_no__MrmMsg_0014)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0014
  externalref _MrmConst char *_MrmMsg_0014;
#endif

#if defined(__polyspace__MrmMsg_0015) && !defined(__polyspace_no__MrmMsg_0015)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0015
  externalref _MrmConst char *_MrmMsg_0015;
#endif

#if defined(__polyspace__MrmMsg_0016) && !defined(__polyspace_no__MrmMsg_0016)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0016
  externalref _MrmConst char *_MrmMsg_0016;
#endif

#if defined(__polyspace__MrmMsg_0017) && !defined(__polyspace_no__MrmMsg_0017)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0017
  externalref _MrmConst char *_MrmMsg_0017;
#endif

#if defined(__polyspace__MrmMsg_0018) && !defined(__polyspace_no__MrmMsg_0018)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0018
  externalref _MrmConst char *_MrmMsg_0018;
#endif

#if defined(__polyspace__MrmMsg_0019) && !defined(__polyspace_no__MrmMsg_0019)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0019
  externalref _MrmConst char *_MrmMsg_0019;
#endif

#if defined(__polyspace__MrmMsg_0020) && !defined(__polyspace_no__MrmMsg_0020)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0020
  externalref _MrmConst char *_MrmMsg_0020;
#endif

#if defined(__polyspace__MrmMsg_0021) && !defined(__polyspace_no__MrmMsg_0021)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0021
  externalref _MrmConst char *_MrmMsg_0021;
#endif

#if defined(__polyspace__MrmMsg_0022) && !defined(__polyspace_no__MrmMsg_0022)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0022
  externalref _MrmConst char *_MrmMsg_0022;
#endif

#if defined(__polyspace__MrmMsg_0023) && !defined(__polyspace_no__MrmMsg_0023)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0023
  externalref _MrmConst char *_MrmMsg_0023;
#endif

#if defined(__polyspace__MrmMsg_0024) && !defined(__polyspace_no__MrmMsg_0024)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0024
  externalref _MrmConst char *_MrmMsg_0024;
#endif

#if defined(__polyspace__MrmMsg_0025) && !defined(__polyspace_no__MrmMsg_0025)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0025
  externalref _MrmConst char *_MrmMsg_0025;
#endif

#if defined(__polyspace__MrmMsg_0026) && !defined(__polyspace_no__MrmMsg_0026)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0026
  externalref _MrmConst char *_MrmMsg_0026;
#endif

#if defined(__polyspace__MrmMsg_0027) && !defined(__polyspace_no__MrmMsg_0027)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0027
  externalref _MrmConst char *_MrmMsg_0027;
#endif

#if defined(__polyspace__MrmMsg_0028) && !defined(__polyspace_no__MrmMsg_0028)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0028
  externalref _MrmConst char *_MrmMsg_0028;
#endif

#if defined(__polyspace__MrmMsg_0029) && !defined(__polyspace_no__MrmMsg_0029)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0029
  externalref _MrmConst char *_MrmMsg_0029;
#endif

#if defined(__polyspace__MrmMsg_0030) && !defined(__polyspace_no__MrmMsg_0030)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0030
  externalref _MrmConst char *_MrmMsg_0030;
#endif

#if defined(__polyspace__MrmMsg_0031) && !defined(__polyspace_no__MrmMsg_0031)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0031
  externalref _MrmConst char *_MrmMsg_0031;
#endif

#if defined(__polyspace__MrmMsg_0032) && !defined(__polyspace_no__MrmMsg_0032)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0032
  externalref _MrmConst char *_MrmMsg_0032;
#endif

#if defined(__polyspace__MrmMsg_0033) && !defined(__polyspace_no__MrmMsg_0033)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0033
  externalref _MrmConst char *_MrmMsg_0033;
#endif

#if defined(__polyspace__MrmMsg_0034) && !defined(__polyspace_no__MrmMsg_0034)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0034
  externalref _MrmConst char *_MrmMsg_0034;
#endif

#if defined(__polyspace__MrmMsg_0035) && !defined(__polyspace_no__MrmMsg_0035)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0035
  externalref _MrmConst char *_MrmMsg_0035;
#endif

#if defined(__polyspace__MrmMsg_0036) && !defined(__polyspace_no__MrmMsg_0036)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0036
  externalref _MrmConst char *_MrmMsg_0036;
#endif

#if defined(__polyspace__MrmMsg_0037) && !defined(__polyspace_no__MrmMsg_0037)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0037
  externalref _MrmConst char *_MrmMsg_0037;
#endif

#if defined(__polyspace__MrmMsg_0038) && !defined(__polyspace_no__MrmMsg_0038)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0038
  externalref _MrmConst char *_MrmMsg_0038;
#endif

#if defined(__polyspace__MrmMsg_0039) && !defined(__polyspace_no__MrmMsg_0039)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0039
  externalref _MrmConst char *_MrmMsg_0039;
#endif

#if defined(__polyspace__MrmMsg_0040) && !defined(__polyspace_no__MrmMsg_0040)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0040
  externalref _MrmConst char *_MrmMsg_0040;
#endif

#if defined(__polyspace__MrmMsg_0041) && !defined(__polyspace_no__MrmMsg_0041)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0041
  externalref _MrmConst char *_MrmMsg_0041;
#endif

#if defined(__polyspace__MrmMsg_0042) && !defined(__polyspace_no__MrmMsg_0042)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0042
  externalref _MrmConst char *_MrmMsg_0042;
#endif

#if defined(__polyspace__MrmMsg_0043) && !defined(__polyspace_no__MrmMsg_0043)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0043
  externalref _MrmConst char *_MrmMsg_0043;
#endif

#if defined(__polyspace__MrmMsg_0044) && !defined(__polyspace_no__MrmMsg_0044)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0044
  externalref _MrmConst char *_MrmMsg_0044;
#endif

#if defined(__polyspace__MrmMsg_0045) && !defined(__polyspace_no__MrmMsg_0045)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0045
  externalref _MrmConst char *_MrmMsg_0045;
#endif

#if defined(__polyspace__MrmMsg_0046) && !defined(__polyspace_no__MrmMsg_0046)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0046
  externalref _MrmConst char *_MrmMsg_0046;
#endif

#if defined(__polyspace__MrmMsg_0047) && !defined(__polyspace_no__MrmMsg_0047)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0047
  externalref _MrmConst char *_MrmMsg_0047;
#endif

#if defined(__polyspace__MrmMsg_0048) && !defined(__polyspace_no__MrmMsg_0048)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0048
  externalref _MrmConst char *_MrmMsg_0048;
#endif

#if defined(__polyspace__MrmMsg_0049) && !defined(__polyspace_no__MrmMsg_0049)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0049
  externalref _MrmConst char *_MrmMsg_0049;
#endif

#if defined(__polyspace__MrmMsg_0050) && !defined(__polyspace_no__MrmMsg_0050)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0050
  externalref _MrmConst char *_MrmMsg_0050;
#endif

#if defined(__polyspace__MrmMsg_0051) && !defined(__polyspace_no__MrmMsg_0051)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0051
  externalref _MrmConst char *_MrmMsg_0051;
#endif

#if defined(__polyspace__MrmMsg_0052) && !defined(__polyspace_no__MrmMsg_0052)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0052
  externalref _MrmConst char *_MrmMsg_0052;
#endif

#if defined(__polyspace__MrmMsg_0053) && !defined(__polyspace_no__MrmMsg_0053)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0053
  externalref _MrmConst char *_MrmMsg_0053;
#endif

#if defined(__polyspace__MrmMsg_0054) && !defined(__polyspace_no__MrmMsg_0054)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0054
  externalref _MrmConst char *_MrmMsg_0054;
#endif

#if defined(__polyspace__MrmMsg_0055) && !defined(__polyspace_no__MrmMsg_0055)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0055
  externalref _MrmConst char *_MrmMsg_0055;
#endif

#if defined(__polyspace__MrmMsg_0056) && !defined(__polyspace_no__MrmMsg_0056)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0056
  externalref _MrmConst char *_MrmMsg_0056;
#endif

#if defined(__polyspace__MrmMsg_0057) && !defined(__polyspace_no__MrmMsg_0057)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0057
  externalref _MrmConst char *_MrmMsg_0057;
#endif

#if defined(__polyspace__MrmMsg_0058) && !defined(__polyspace_no__MrmMsg_0058)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0058
  externalref _MrmConst char *_MrmMsg_0058;
#endif

#if defined(__polyspace__MrmMsg_0059) && !defined(__polyspace_no__MrmMsg_0059)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0059
  externalref _MrmConst char *_MrmMsg_0059;
#endif

#if defined(__polyspace__MrmMsg_0060) && !defined(__polyspace_no__MrmMsg_0060)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0060
  externalref _MrmConst char *_MrmMsg_0060;
#endif

#if defined(__polyspace__MrmMsg_0061) && !defined(__polyspace_no__MrmMsg_0061)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0061
  externalref _MrmConst char *_MrmMsg_0061;
#endif

#if defined(__polyspace__MrmMsg_0062) && !defined(__polyspace_no__MrmMsg_0062)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0062
  externalref _MrmConst char *_MrmMsg_0062;
#endif

#if defined(__polyspace__MrmMsg_0063) && !defined(__polyspace_no__MrmMsg_0063)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0063
  externalref _MrmConst char *_MrmMsg_0063;
#endif

#if defined(__polyspace__MrmMsg_0064) && !defined(__polyspace_no__MrmMsg_0064)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0064
  externalref _MrmConst char *_MrmMsg_0064;
#endif

#if defined(__polyspace__MrmMsg_0065) && !defined(__polyspace_no__MrmMsg_0065)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0065
  externalref _MrmConst char *_MrmMsg_0065;
#endif

#if defined(__polyspace__MrmMsg_0066) && !defined(__polyspace_no__MrmMsg_0066)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0066
  externalref _MrmConst char *_MrmMsg_0066;
#endif

#if defined(__polyspace__MrmMsg_0067) && !defined(__polyspace_no__MrmMsg_0067)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0067
  externalref _MrmConst char *_MrmMsg_0067;
#endif

#if defined(__polyspace__MrmMsg_0068) && !defined(__polyspace_no__MrmMsg_0068)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0068
  externalref _MrmConst char *_MrmMsg_0068;
#endif

#if defined(__polyspace__MrmMsg_0069) && !defined(__polyspace_no__MrmMsg_0069)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0069
  externalref _MrmConst char *_MrmMsg_0069;
#endif

#if defined(__polyspace__MrmMsg_0070) && !defined(__polyspace_no__MrmMsg_0070)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0070
  externalref _MrmConst char *_MrmMsg_0070;
#endif

#if defined(__polyspace__MrmMsg_0071) && !defined(__polyspace_no__MrmMsg_0071)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0071
  externalref _MrmConst char *_MrmMsg_0071;
#endif

#if defined(__polyspace__MrmMsg_0072) && !defined(__polyspace_no__MrmMsg_0072)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0072
  externalref _MrmConst char *_MrmMsg_0072;
#endif

#if defined(__polyspace__MrmMsg_0073) && !defined(__polyspace_no__MrmMsg_0073)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0073
  externalref _MrmConst char *_MrmMsg_0073;
#endif

#if defined(__polyspace__MrmMsg_0074) && !defined(__polyspace_no__MrmMsg_0074)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0074
  externalref _MrmConst char *_MrmMsg_0074;
#endif

#if defined(__polyspace__MrmMsg_0075) && !defined(__polyspace_no__MrmMsg_0075)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0075
  externalref _MrmConst char *_MrmMsg_0075;
#endif

#if defined(__polyspace__MrmMsg_0076) && !defined(__polyspace_no__MrmMsg_0076)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0076
  externalref _MrmConst char *_MrmMsg_0076;
#endif

#if defined(__polyspace__MrmMsg_0077) && !defined(__polyspace_no__MrmMsg_0077)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0077
  externalref _MrmConst char *_MrmMsg_0077;
#endif

#if defined(__polyspace__MrmMsg_0078) && !defined(__polyspace_no__MrmMsg_0078)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0078
  externalref _MrmConst char *_MrmMsg_0078;
#endif

#if defined(__polyspace__MrmMsg_0079) && !defined(__polyspace_no__MrmMsg_0079)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0079
  externalref _MrmConst char *_MrmMsg_0079;
#endif

#if defined(__polyspace__MrmMsg_0080) && !defined(__polyspace_no__MrmMsg_0080)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0080
  externalref _MrmConst char *_MrmMsg_0080;
#endif

#if defined(__polyspace__MrmMsg_0081) && !defined(__polyspace_no__MrmMsg_0081)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0081
  externalref _MrmConst char *_MrmMsg_0081;
#endif

#if defined(__polyspace__MrmMsg_0082) && !defined(__polyspace_no__MrmMsg_0082)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0082
  externalref _MrmConst char *_MrmMsg_0082;
#endif

#if defined(__polyspace__MrmMsg_0083) && !defined(__polyspace_no__MrmMsg_0083)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0083
  externalref _MrmConst char *_MrmMsg_0083;
#endif

#if defined(__polyspace__MrmMsg_0084) && !defined(__polyspace_no__MrmMsg_0084)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0084
  externalref _MrmConst char *_MrmMsg_0084;
#endif

#if defined(__polyspace__MrmMsg_0085) && !defined(__polyspace_no__MrmMsg_0085)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0085
  externalref _MrmConst char *_MrmMsg_0085;
#endif

#if defined(__polyspace__MrmMsg_0086) && !defined(__polyspace_no__MrmMsg_0086)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0086
  externalref _MrmConst char *_MrmMsg_0086;
#endif

#if defined(__polyspace__MrmMsg_0087) && !defined(__polyspace_no__MrmMsg_0087)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0087
  externalref _MrmConst char *_MrmMsg_0087;
#endif

#if defined(__polyspace__MrmMsg_0088) && !defined(__polyspace_no__MrmMsg_0088)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0088
  externalref _MrmConst char *_MrmMsg_0088;
#endif

#if defined(__polyspace__MrmMsg_0089) && !defined(__polyspace_no__MrmMsg_0089)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0089
  externalref _MrmConst char *_MrmMsg_0089;
#endif

#if defined(__polyspace__MrmMsg_0090) && !defined(__polyspace_no__MrmMsg_0090)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0090
  externalref _MrmConst char *_MrmMsg_0090;
#endif

#if defined(__polyspace__MrmMsg_0091) && !defined(__polyspace_no__MrmMsg_0091)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0091
  externalref _MrmConst char *_MrmMsg_0091;
#endif

#if defined(__polyspace__MrmMsg_0092) && !defined(__polyspace_no__MrmMsg_0092)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0092
  externalref _MrmConst char *_MrmMsg_0092;
#endif

#if defined(__polyspace__MrmMsg_0093) && !defined(__polyspace_no__MrmMsg_0093)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0093
  externalref _MrmConst char *_MrmMsg_0093;
#endif

#if defined(__polyspace__MrmMsg_0094) && !defined(__polyspace_no__MrmMsg_0094)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0094
  externalref _MrmConst char *_MrmMsg_0094;
#endif

#if defined(__polyspace__MrmMsg_0095) && !defined(__polyspace_no__MrmMsg_0095)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0095
  externalref _MrmConst char *_MrmMsg_0095;
#endif

#if defined(__polyspace__MrmMsg_0096) && !defined(__polyspace_no__MrmMsg_0096)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0096
  externalref _MrmConst char *_MrmMsg_0096;
#endif

#if defined(__polyspace__MrmMsg_0097) && !defined(__polyspace_no__MrmMsg_0097)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0097
  externalref _MrmConst char *_MrmMsg_0097;
#endif

#if defined(__polyspace__MrmMsg_0098) && !defined(__polyspace_no__MrmMsg_0098)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0098
  externalref _MrmConst char *_MrmMsg_0098;
#endif

#if defined(__polyspace__MrmMsg_0099) && !defined(__polyspace_no__MrmMsg_0099)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0099
  externalref _MrmConst char *_MrmMsg_0099;
#endif

#if defined(__polyspace__MrmMsg_0100) && !defined(__polyspace_no__MrmMsg_0100)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0100
  externalref _MrmConst char *_MrmMsg_0100;
#endif

#if defined(__polyspace__MrmMsg_0101) && !defined(__polyspace_no__MrmMsg_0101)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0101
  externalref _MrmConst char *_MrmMsg_0101;
#endif

#if defined(__polyspace__MrmMsg_0102) && !defined(__polyspace_no__MrmMsg_0102)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0102
  externalref _MrmConst char *_MrmMsg_0102;
#endif

#if defined(__polyspace__MrmMsg_0103) && !defined(__polyspace_no__MrmMsg_0103)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0103
  externalref _MrmConst char *_MrmMsg_0103;
#endif

#if defined(__polyspace__MrmMsg_0104) && !defined(__polyspace_no__MrmMsg_0104)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0104
  externalref _MrmConst char *_MrmMsg_0104;
#endif

#if defined(__polyspace__MrmMsg_0105) && !defined(__polyspace_no__MrmMsg_0105)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0105
  externalref _MrmConst char *_MrmMsg_0105;
#endif

#if defined(__polyspace__MrmMsg_0106) && !defined(__polyspace_no__MrmMsg_0106)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0106
  externalref _MrmConst char *_MrmMsg_0106;
#endif

#if defined(__polyspace__MrmMsg_0107) && !defined(__polyspace_no__MrmMsg_0107)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0107
  externalref _MrmConst char *_MrmMsg_0107;
#endif

#if defined(__polyspace__MrmMsg_0108) && !defined(__polyspace_no__MrmMsg_0108)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0108
  externalref _MrmConst char *_MrmMsg_0108;
#endif

#if defined(__polyspace__MrmMsg_0109) && !defined(__polyspace_no__MrmMsg_0109)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0109
  externalref _MrmConst char *_MrmMsg_0109;
#endif

#if defined(__polyspace__MrmMsg_0110) && !defined(__polyspace_no__MrmMsg_0110)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0110
  externalref _MrmConst char *_MrmMsg_0110;
#endif

#if defined(__polyspace__MrmMsg_0111) && !defined(__polyspace_no__MrmMsg_0111)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0111
  externalref _MrmConst char *_MrmMsg_0111;
#endif

#if defined(__polyspace__MrmMsg_0112) && !defined(__polyspace_no__MrmMsg_0112)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0112
  externalref _MrmConst char *_MrmMsg_0112;
#endif

#if defined(__polyspace__MrmMsg_0113) && !defined(__polyspace_no__MrmMsg_0113)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0113
  externalref _MrmConst char *_MrmMsg_0113;
#endif

#if defined(__polyspace__MrmMsg_0114) && !defined(__polyspace_no__MrmMsg_0114)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0114
  externalref _MrmConst char *_MrmMsg_0114;
#endif

#if defined(__polyspace__MrmMsg_0115) && !defined(__polyspace_no__MrmMsg_0115)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0115
  externalref _MrmConst char *_MrmMsg_0115;
#endif

#if defined(__polyspace__MrmMsg_0116) && !defined(__polyspace_no__MrmMsg_0116)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0116
  externalref _MrmConst char *_MrmMsg_0116;
#endif

#if defined(__polyspace__MrmMsg_0117) && !defined(__polyspace_no__MrmMsg_0117)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0117
  externalref _MrmConst char *_MrmMsg_0117;
#endif

#if defined(__polyspace__MrmMsg_0118) && !defined(__polyspace_no__MrmMsg_0118)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0118
  externalref _MrmConst char *_MrmMsg_0118;
#endif

#if defined(__polyspace__MrmMsg_0119) && !defined(__polyspace_no__MrmMsg_0119)
#include <Mrm/MrmDecls.h>
#undef _MrmMsg_0119
  externalref _MrmConst char *_MrmMsg_0119;
#endif

#if defined(__polyspace_Mrm_catd) && !defined(__polyspace_no_Mrm_catd)
#include <Mrm/MrmMsgI.h>
#undef Mrm_catd
  externalref nl_catd Mrm_catd;
#endif

#if defined(__polyspace_colorSelectionBoxWidgetClass) && !defined(__polyspace_no_colorSelectionBoxWidgetClass)
#include <X11/DPS/ColorSB.h>
#undef colorSelectionBoxWidgetClass
  extern WidgetClass colorSelectionBoxWidgetClass;
#endif

#if defined(__polyspace_colorSelectionBoxClassRec) && !defined(__polyspace_no_colorSelectionBoxClassRec)
#include <X11/DPS/ColorSBP.h>
#undef colorSelectionBoxClassRec
  extern ColorSelectionBoxClassRec colorSelectionBoxClassRec;
#endif

#if defined(__polyspace_dpsScrolledWindowWidgetClass) && !defined(__polyspace_no_dpsScrolledWindowWidgetClass)
#include <X11/DPS/DPSScrollW.h>
#undef dpsScrolledWindowWidgetClass
  extern WidgetClass dpsScrolledWindowWidgetClass;
#endif

#if defined(__polyspace_dpsScrolledWindowClassRec) && !defined(__polyspace_no_dpsScrolledWindowClassRec)
#include <X11/DPS/DPSScrollWP.h>
#undef dpsScrolledWindowClassRec
  extern DPSScrolledWindowClassRec dpsScrolledWindowClassRec;
#endif

#if defined(__polyspace_fontCreatorClassRec) && !defined(__polyspace_no_fontCreatorClassRec)
#include <X11/DPS/FontCreatP.h>
#undef fontCreatorClassRec
  extern FontCreatorClassRec fontCreatorClassRec;
#endif

#if defined(__polyspace_fontCreatorWidgetClass) && !defined(__polyspace_no_fontCreatorWidgetClass)
#include <X11/DPS/FontCreato.h>
#undef fontCreatorWidgetClass
  extern WidgetClass fontCreatorWidgetClass;
#endif

#if defined(__polyspace_fontSelectionBoxWidgetClass) && !defined(__polyspace_no_fontSelectionBoxWidgetClass)
#include <X11/DPS/FontSB.h>
#undef fontSelectionBoxWidgetClass
  extern WidgetClass fontSelectionBoxWidgetClass;
#endif

#if defined(__polyspace_fontSelectionBoxClassRec) && !defined(__polyspace_no_fontSelectionBoxClassRec)
#include <X11/DPS/FontSBP.h>
#undef fontSelectionBoxClassRec
  extern FontSelectionBoxClassRec fontSelectionBoxClassRec;
#endif

#if defined(__polyspace_fontSamplerClassRec) && !defined(__polyspace_no_fontSamplerClassRec)
#include <X11/DPS/FontSamplP.h>
#undef fontSamplerClassRec
  extern FontSamplerClassRec fontSamplerClassRec;
#endif

#if defined(__polyspace_fontSamplerWidgetClass) && !defined(__polyspace_no_fontSamplerWidgetClass)
#include <X11/DPS/FontSample.h>
#undef fontSamplerWidgetClass
  extern WidgetClass fontSamplerWidgetClass;
#endif

#if defined(__polyspace_PSResFontOutline) && !defined(__polyspace_no_PSResFontOutline)
#include <X11/DPS/PSres.h>
#undef PSResFontOutline
  extern char *PSResFontOutline;
#endif

#if defined(__polyspace_PSResFontPrebuilt) && !defined(__polyspace_no_PSResFontPrebuilt)
#include <X11/DPS/PSres.h>
#undef PSResFontPrebuilt
  extern char *PSResFontPrebuilt;
#endif

#if defined(__polyspace_PSResFontAFM) && !defined(__polyspace_no_PSResFontAFM)
#include <X11/DPS/PSres.h>
#undef PSResFontAFM
  extern char *PSResFontAFM;
#endif

#if defined(__polyspace_PSResFontBDF) && !defined(__polyspace_no_PSResFontBDF)
#include <X11/DPS/PSres.h>
#undef PSResFontBDF
  extern char *PSResFontBDF;
#endif

#if defined(__polyspace_PSResFontFamily) && !defined(__polyspace_no_PSResFontFamily)
#include <X11/DPS/PSres.h>
#undef PSResFontFamily
  extern char *PSResFontFamily;
#endif

#if defined(__polyspace_PSResFontBDFSizes) && !defined(__polyspace_no_PSResFontBDFSizes)
#include <X11/DPS/PSres.h>
#undef PSResFontBDFSizes
  extern char *PSResFontBDFSizes;
#endif

#if defined(__polyspace_PSResForm) && !defined(__polyspace_no_PSResForm)
#include <X11/DPS/PSres.h>
#undef PSResForm
  extern char *PSResForm;
#endif

#if defined(__polyspace_PSResPattern) && !defined(__polyspace_no_PSResPattern)
#include <X11/DPS/PSres.h>
#undef PSResPattern
  extern char *PSResPattern;
#endif

#if defined(__polyspace_PSResEncoding) && !defined(__polyspace_no_PSResEncoding)
#include <X11/DPS/PSres.h>
#undef PSResEncoding
  extern char *PSResEncoding;
#endif

#if defined(__polyspace_PSResProcSet) && !defined(__polyspace_no_PSResProcSet)
#include <X11/DPS/PSres.h>
#undef PSResProcSet
  extern char *PSResProcSet;
#endif

#if defined(__polyspace_PSResFontPCF) && !defined(__polyspace_no_PSResFontPCF)
#include <X11/DPS/PSres.h>
#undef PSResFontPCF
  extern char *PSResFontPCF;
#endif

#if defined(__polyspace_PSResFontPCFSizes) && !defined(__polyspace_no_PSResFontPCFSizes)
#include <X11/DPS/PSres.h>
#undef PSResFontPCFSizes
  extern char *PSResFontPCFSizes;
#endif

#if defined(__polyspace_PSResMalloc) && !defined(__polyspace_no_PSResMalloc)
#include <X11/DPS/PSres.h>
#undef PSResMalloc
  extern PSResMallocProc PSResMalloc;
#endif

#if defined(__polyspace_PSResRealloc) && !defined(__polyspace_no_PSResRealloc)
#include <X11/DPS/PSres.h>
#undef PSResRealloc
  extern PSResReallocProc PSResRealloc;
#endif

#if defined(__polyspace_PSResFree) && !defined(__polyspace_no_PSResFree)
#include <X11/DPS/PSres.h>
#undef PSResFree
  extern PSResFreeProc PSResFree;
#endif

#if defined(__polyspace_PSResFileWarningHandler) && !defined(__polyspace_no_PSResFileWarningHandler)
#include <X11/DPS/PSres.h>
#undef PSResFileWarningHandler
  extern PSResFileWarningHandlerProc PSResFileWarningHandler;
#endif

#if defined(__polyspace_DPSLastUserObjectIndex) && !defined(__polyspace_no_DPSLastUserObjectIndex)
#include <X11/DPS/dpsXclient.h>
#undef DPSLastUserObjectIndex
  extern long int DPSLastUserObjectIndex;
#endif

#if defined(__polyspace__Exc_Header) && !defined(__polyspace_no__Exc_Header)
#include <X11/DPS/dpsexcept.h>
#undef _Exc_Header
  extern _Exc_Buf *_Exc_Header;
#endif

#if defined(__polyspace_XawWidgetArray) && !defined(__polyspace_no_XawWidgetArray)
#include <X11/Xaw/AllWidgets.h>
#undef XawWidgetArray
  extern XmuWidgetNode XawWidgetArray[];
#endif

#if defined(__polyspace_XawWidgetCount) && !defined(__polyspace_no_XawWidgetCount)
#include <X11/Xaw/AllWidgets.h>
#undef XawWidgetCount
  extern int   XawWidgetCount;
#endif

#if defined(__polyspace_asciiSinkObjectClass) && !defined(__polyspace_no_asciiSinkObjectClass)
#include <X11/Xaw/AsciiSink.h>
#undef asciiSinkObjectClass
  extern WidgetClass asciiSinkObjectClass;
#endif

#if defined(__polyspace_asciiSinkClassRec) && !defined(__polyspace_no_asciiSinkClassRec)
#include <X11/Xaw/AsciiSinkP.h>
#undef asciiSinkClassRec
  extern AsciiSinkClassRec asciiSinkClassRec;
#endif

#if defined(__polyspace_asciiSrcObjectClass) && !defined(__polyspace_no_asciiSrcObjectClass)
#include <X11/Xaw/AsciiSrc.h>
#undef asciiSrcObjectClass
  extern WidgetClass asciiSrcObjectClass;
#endif

#if defined(__polyspace_asciiSrcClassRec) && !defined(__polyspace_no_asciiSrcClassRec)
#include <X11/Xaw/AsciiSrcP.h>
#undef asciiSrcClassRec
  extern AsciiSrcClassRec asciiSrcClassRec;
#endif

#if defined(__polyspace_asciiTextWidgetClass) && !defined(__polyspace_no_asciiTextWidgetClass)
#include <X11/Xaw/AsciiText.h>
#undef asciiTextWidgetClass
  extern WidgetClass asciiTextWidgetClass;
#endif

#if defined(__polyspace_asciiStringWidgetClass) && !defined(__polyspace_no_asciiStringWidgetClass)
#include <X11/Xaw/AsciiText.h>
#undef asciiStringWidgetClass
  extern WidgetClass asciiStringWidgetClass;
#endif

#if defined(__polyspace_asciiDiskWidgetClass) && !defined(__polyspace_no_asciiDiskWidgetClass)
#include <X11/Xaw/AsciiText.h>
#undef asciiDiskWidgetClass
  extern WidgetClass asciiDiskWidgetClass;
#endif

#if defined(__polyspace_asciiTextClassRec) && !defined(__polyspace_no_asciiTextClassRec)
#include <X11/Xaw/AsciiTextP.h>
#undef asciiTextClassRec
  extern AsciiTextClassRec asciiTextClassRec;
#endif

#if defined(__polyspace_asciiStringClassRec) && !defined(__polyspace_no_asciiStringClassRec)
#include <X11/Xaw/AsciiTextP.h>
#undef asciiStringClassRec
  extern AsciiStringClassRec asciiStringClassRec;
#endif

#if defined(__polyspace_asciiDiskClassRec) && !defined(__polyspace_no_asciiDiskClassRec)
#include <X11/Xaw/AsciiTextP.h>
#undef asciiDiskClassRec
  extern AsciiDiskClassRec asciiDiskClassRec;
#endif

#if defined(__polyspace_boxWidgetClass) && !defined(__polyspace_no_boxWidgetClass)
#include <X11/Xaw/Box.h>
#undef boxWidgetClass
  extern WidgetClass boxWidgetClass;
#endif

#if defined(__polyspace_boxClassRec) && !defined(__polyspace_no_boxClassRec)
#include <X11/Xaw/BoxP.h>
#undef boxClassRec
  extern BoxClassRec boxClassRec;
#endif

#if defined(__polyspace_clockWidgetClass) && !defined(__polyspace_no_clockWidgetClass)
#include <X11/Xaw/Clock.h>
#undef clockWidgetClass
  extern WidgetClass clockWidgetClass;
#endif

#if defined(__polyspace_clockClassRec) && !defined(__polyspace_no_clockClassRec)
#include <X11/Xaw/ClockP.h>
#undef clockClassRec
  extern ClockClassRec clockClassRec;
#endif

#if defined(__polyspace_commandWidgetClass) && !defined(__polyspace_no_commandWidgetClass)
#include <X11/Xaw/Command.h>
#undef commandWidgetClass
  extern WidgetClass  commandWidgetClass;
#endif

#if defined(__polyspace_commandClassRec) && !defined(__polyspace_no_commandClassRec)
#include <X11/Xaw/CommandP.h>
#undef commandClassRec
  extern CommandClassRec commandClassRec;
#endif

#if defined(__polyspace_dialogWidgetClass) && !defined(__polyspace_no_dialogWidgetClass)
#include <X11/Xaw/Dialog.h>
#undef dialogWidgetClass
  extern WidgetClass dialogWidgetClass;
#endif

#if defined(__polyspace_dialogClassRec) && !defined(__polyspace_no_dialogClassRec)
#include <X11/Xaw/DialogP.h>
#undef dialogClassRec
  extern DialogClassRec dialogClassRec;
#endif

#if defined(__polyspace_formWidgetClass) && !defined(__polyspace_no_formWidgetClass)
#include <X11/Xaw/Form.h>
#undef formWidgetClass
  extern WidgetClass formWidgetClass;
#endif

#if defined(__polyspace_formClassRec) && !defined(__polyspace_no_formClassRec)
#include <X11/Xaw/FormP.h>
#undef formClassRec
  extern FormClassRec formClassRec;
#endif

#if defined(__polyspace_gripWidgetClass) && !defined(__polyspace_no_gripWidgetClass)
#include <X11/Xaw/Grip.h>
#undef gripWidgetClass
  extern WidgetClass gripWidgetClass;
#endif

#if defined(__polyspace_gripClassRec) && !defined(__polyspace_no_gripClassRec)
#include <X11/Xaw/GripP.h>
#undef gripClassRec
  extern GripClassRec gripClassRec;
#endif

#if defined(__polyspace_labelWidgetClass) && !defined(__polyspace_no_labelWidgetClass)
#include <X11/Xaw/Label.h>
#undef labelWidgetClass
  extern WidgetClass labelWidgetClass;
#endif

#if defined(__polyspace_labelClassRec) && !defined(__polyspace_no_labelClassRec)
#include <X11/Xaw/LabelP.h>
#undef labelClassRec
  extern LabelClassRec labelClassRec;
#endif

#if defined(__polyspace_listWidgetClass) && !defined(__polyspace_no_listWidgetClass)
#include <X11/Xaw/List.h>
#undef listWidgetClass
  extern WidgetClass listWidgetClass;
#endif

#if defined(__polyspace_listClassRec) && !defined(__polyspace_no_listClassRec)
#include <X11/Xaw/ListP.h>
#undef listClassRec
  extern ListClassRec listClassRec;
#endif

#if defined(__polyspace_logoWidgetClass) && !defined(__polyspace_no_logoWidgetClass)
#include <X11/Xaw/Logo.h>
#undef logoWidgetClass
  extern WidgetClass logoWidgetClass;
#endif

#if defined(__polyspace_logoClassRec) && !defined(__polyspace_no_logoClassRec)
#include <X11/Xaw/LogoP.h>
#undef logoClassRec
  extern LogoClassRec logoClassRec;
#endif

#if defined(__polyspace_mailboxWidgetClass) && !defined(__polyspace_no_mailboxWidgetClass)
#include <X11/Xaw/Mailbox.h>
#undef mailboxWidgetClass
  extern WidgetClass mailboxWidgetClass;
#endif

#if defined(__polyspace_mailboxClassRec) && !defined(__polyspace_no_mailboxClassRec)
#include <X11/Xaw/MailboxP.h>
#undef mailboxClassRec
  extern MailboxClassRec mailboxClassRec;
#endif

#if defined(__polyspace_menuButtonClassRec) && !defined(__polyspace_no_menuButtonClassRec)
#include <X11/Xaw/MenuButtoP.h>
#undef menuButtonClassRec
  extern MenuButtonClassRec menuButtonClassRec;
#endif

#if defined(__polyspace_menuButtonWidgetClass) && !defined(__polyspace_no_menuButtonWidgetClass)
#include <X11/Xaw/MenuButton.h>
#undef menuButtonWidgetClass
  extern WidgetClass  menuButtonWidgetClass;
#endif

#if defined(__polyspace_multiSinkObjectClass) && !defined(__polyspace_no_multiSinkObjectClass)
#include <X11/Xaw/MultiSink.h>
#undef multiSinkObjectClass
  extern WidgetClass multiSinkObjectClass;
#endif

#if defined(__polyspace_multiSinkClassRec) && !defined(__polyspace_no_multiSinkClassRec)
#include <X11/Xaw/MultiSinkP.h>
#undef multiSinkClassRec
  extern MultiSinkClassRec multiSinkClassRec;
#endif

#if defined(__polyspace_multiSrcObjectClass) && !defined(__polyspace_no_multiSrcObjectClass)
#include <X11/Xaw/MultiSrc.h>
#undef multiSrcObjectClass
  extern WidgetClass multiSrcObjectClass;
#endif

#if defined(__polyspace_multiSrcClassRec) && !defined(__polyspace_no_multiSrcClassRec)
#include <X11/Xaw/MultiSrcP.h>
#undef multiSrcClassRec
  extern MultiSrcClassRec multiSrcClassRec;
#endif

#if defined(__polyspace_panedWidgetClass) && !defined(__polyspace_no_panedWidgetClass)
#include <X11/Xaw/Paned.h>
#undef panedWidgetClass
  extern WidgetClass panedWidgetClass;
#endif

#if defined(__polyspace_panedClassRec) && !defined(__polyspace_no_panedClassRec)
#include <X11/Xaw/PanedP.h>
#undef panedClassRec
  extern PanedClassRec panedClassRec;
#endif

#if defined(__polyspace_pannerWidgetClass) && !defined(__polyspace_no_pannerWidgetClass)
#include <X11/Xaw/Panner.h>
#undef pannerWidgetClass
  extern WidgetClass pannerWidgetClass;
#endif

#if defined(__polyspace_pannerClassRec) && !defined(__polyspace_no_pannerClassRec)
#include <X11/Xaw/PannerP.h>
#undef pannerClassRec
  extern PannerClassRec pannerClassRec;
#endif

#if defined(__polyspace_portholeWidgetClass) && !defined(__polyspace_no_portholeWidgetClass)
#include <X11/Xaw/Porthole.h>
#undef portholeWidgetClass
  extern WidgetClass portholeWidgetClass;
#endif

#if defined(__polyspace_portholeClassRec) && !defined(__polyspace_no_portholeClassRec)
#include <X11/Xaw/PortholeP.h>
#undef portholeClassRec
  extern PortholeClassRec portholeClassRec;
#endif

#if defined(__polyspace_repeaterWidgetClass) && !defined(__polyspace_no_repeaterWidgetClass)
#include <X11/Xaw/Repeater.h>
#undef repeaterWidgetClass
  extern WidgetClass repeaterWidgetClass;
#endif

#if defined(__polyspace_repeaterClassRec) && !defined(__polyspace_no_repeaterClassRec)
#include <X11/Xaw/RepeaterP.h>
#undef repeaterClassRec
  extern RepeaterClassRec repeaterClassRec;
#endif

#if defined(__polyspace_scrollbarWidgetClass) && !defined(__polyspace_no_scrollbarWidgetClass)
#include <X11/Xaw/Scrollbar.h>
#undef scrollbarWidgetClass
  extern WidgetClass scrollbarWidgetClass;
#endif

#if defined(__polyspace_scrollbarClassRec) && !defined(__polyspace_no_scrollbarClassRec)
#include <X11/Xaw/ScrollbarP.h>
#undef scrollbarClassRec
  extern ScrollbarClassRec scrollbarClassRec;
#endif

#if defined(__polyspace_simpleWidgetClass) && !defined(__polyspace_no_simpleWidgetClass)
#include <X11/Xaw/Simple.h>
#undef simpleWidgetClass
  extern WidgetClass simpleWidgetClass;
#endif

#if defined(__polyspace_simpleMenuClassRec) && !defined(__polyspace_no_simpleMenuClassRec)
#include <X11/Xaw/SimpleMenP.h>
#undef simpleMenuClassRec
  extern SimpleMenuClassRec simpleMenuClassRec;
#endif

#if defined(__polyspace_simpleMenuWidgetClass) && !defined(__polyspace_no_simpleMenuWidgetClass)
#include <X11/Xaw/SimpleMenu.h>
#undef simpleMenuWidgetClass
  extern WidgetClass simpleMenuWidgetClass;
#endif

#if defined(__polyspace_simpleClassRec) && !defined(__polyspace_no_simpleClassRec)
#include <X11/Xaw/SimpleP.h>
#undef simpleClassRec
  extern SimpleClassRec simpleClassRec;
#endif

#if defined(__polyspace_smeObjectClass) && !defined(__polyspace_no_smeObjectClass)
#include <X11/Xaw/Sme.h>
#undef smeObjectClass
  extern WidgetClass smeObjectClass;
#endif

#if defined(__polyspace_smeClassRec) && !defined(__polyspace_no_smeClassRec)
#include <X11/Xaw/SmeP.h>
#undef smeClassRec
  extern SmeClassRec smeClassRec;
#endif

#if defined(__polyspace_smeBSBObjectClass) && !defined(__polyspace_no_smeBSBObjectClass)
#include <X11/Xaw/SmeBSB.h>
#undef smeBSBObjectClass
  extern WidgetClass smeBSBObjectClass;
#endif

#if defined(__polyspace_smeBSBClassRec) && !defined(__polyspace_no_smeBSBClassRec)
#include <X11/Xaw/SmeBSBP.h>
#undef smeBSBClassRec
  extern SmeBSBClassRec smeBSBClassRec;
#endif

#if defined(__polyspace_smeLineObjectClass) && !defined(__polyspace_no_smeLineObjectClass)
#include <X11/Xaw/SmeLine.h>
#undef smeLineObjectClass
  extern WidgetClass smeLineObjectClass;
#endif

#if defined(__polyspace_smeLineClassRec) && !defined(__polyspace_no_smeLineClassRec)
#include <X11/Xaw/SmeLineP.h>
#undef smeLineClassRec
  extern SmeLineClassRec smeLineClassRec;
#endif

#if defined(__polyspace_stripChartClassRec) && !defined(__polyspace_no_stripChartClassRec)
#include <X11/Xaw/StripCharP.h>
#undef stripChartClassRec
  extern StripChartClassRec stripChartClassRec;
#endif

#if defined(__polyspace_stripChartWidgetClass) && !defined(__polyspace_no_stripChartWidgetClass)
#include <X11/Xaw/StripChart.h>
#undef stripChartWidgetClass
  extern WidgetClass stripChartWidgetClass;
#endif

#if defined(__polyspace_templateWidgetClass) && !defined(__polyspace_no_templateWidgetClass)
#include <X11/Xaw/Template.h>
#undef templateWidgetClass
  extern WidgetClass templateWidgetClass;
#endif

#if defined(__polyspace_templateClassRec) && !defined(__polyspace_no_templateClassRec)
#include <X11/Xaw/TemplateP.h>
#undef templateClassRec
  extern TemplateClassRec templateClassRec;
#endif

#if defined(__polyspace_FMT8BIT) && !defined(__polyspace_no_FMT8BIT)
#include <X11/Xaw/Text.h>
#undef FMT8BIT
  extern unsigned long FMT8BIT;
#endif

#if defined(__polyspace_XawFmt8Bit) && !defined(__polyspace_no_XawFmt8Bit)
#include <X11/Xaw/Text.h>
#undef XawFmt8Bit
  extern unsigned long XawFmt8Bit;
#endif

#if defined(__polyspace_XawFmtWide) && !defined(__polyspace_no_XawFmtWide)
#include <X11/Xaw/Text.h>
#undef XawFmtWide
  extern unsigned long XawFmtWide;
#endif

#if defined(__polyspace_textWidgetClass) && !defined(__polyspace_no_textWidgetClass)
#include <X11/Xaw/Text.h>
#undef textWidgetClass
  extern WidgetClass textWidgetClass;
#endif

#if defined(__polyspace__XawTextActionsTable) && !defined(__polyspace_no__XawTextActionsTable)
#include <X11/Xaw/TextP.h>
#undef _XawTextActionsTable
  extern XtActionsRec _XawTextActionsTable[];
#endif

#if defined(__polyspace__XawTextActionsTableCount) && !defined(__polyspace_no__XawTextActionsTableCount)
#include <X11/Xaw/TextP.h>
#undef _XawTextActionsTableCount
  extern Cardinal _XawTextActionsTableCount;
#endif

#if defined(__polyspace_textClassRec) && !defined(__polyspace_no_textClassRec)
#include <X11/Xaw/TextP.h>
#undef textClassRec
  extern TextClassRec textClassRec;
#endif

#if defined(__polyspace_textSinkObjectClass) && !defined(__polyspace_no_textSinkObjectClass)
#include <X11/Xaw/TextSink.h>
#undef textSinkObjectClass
  extern WidgetClass textSinkObjectClass;
#endif

#if defined(__polyspace_textSinkClassRec) && !defined(__polyspace_no_textSinkClassRec)
#include <X11/Xaw/TextSinkP.h>
#undef textSinkClassRec
  extern TextSinkClassRec textSinkClassRec;
#endif

#if defined(__polyspace_textSrcObjectClass) && !defined(__polyspace_no_textSrcObjectClass)
#include <X11/Xaw/TextSrc.h>
#undef textSrcObjectClass
  extern WidgetClass textSrcObjectClass;
#endif

#if defined(__polyspace_textSrcClassRec) && !defined(__polyspace_no_textSrcClassRec)
#include <X11/Xaw/TextSrcP.h>
#undef textSrcClassRec
  extern TextSrcClassRec textSrcClassRec;
#endif

#if defined(__polyspace_toggleWidgetClass) && !defined(__polyspace_no_toggleWidgetClass)
#include <X11/Xaw/Toggle.h>
#undef toggleWidgetClass
  extern WidgetClass    toggleWidgetClass;
#endif

#if defined(__polyspace_toggleClassRec) && !defined(__polyspace_no_toggleClassRec)
#include <X11/Xaw/ToggleP.h>
#undef toggleClassRec
  extern ToggleClassRec toggleClassRec;
#endif

#if defined(__polyspace_treeWidgetClass) && !defined(__polyspace_no_treeWidgetClass)
#include <X11/Xaw/Tree.h>
#undef treeWidgetClass
  extern WidgetClass treeWidgetClass;
#endif

#if defined(__polyspace_treeClassRec) && !defined(__polyspace_no_treeClassRec)
#include <X11/Xaw/TreeP.h>
#undef treeClassRec
  extern TreeClassRec treeClassRec;
#endif

#if defined(__polyspace_viewportWidgetClass) && !defined(__polyspace_no_viewportWidgetClass)
#include <X11/Xaw/Viewport.h>
#undef viewportWidgetClass
  extern WidgetClass viewportWidgetClass;
#endif

#if defined(__polyspace_viewportClassRec) && !defined(__polyspace_no_viewportClassRec)
#include <X11/Xaw/ViewportP.h>
#undef viewportClassRec
  extern ViewportClassRec viewportClassRec;
#endif

#if defined(__polyspace__XA_ATOM_PAIR) && !defined(__polyspace_no__XA_ATOM_PAIR)
#include <X11/Xmu/Atoms.h>
#undef _XA_ATOM_PAIR
  extern AtomPtr  _XA_ATOM_PAIR;
#endif

#if defined(__polyspace__XA_CHARACTER_POSITION) && !defined(__polyspace_no__XA_CHARACTER_POSITION)
#include <X11/Xmu/Atoms.h>
#undef _XA_CHARACTER_POSITION
  extern AtomPtr   _XA_CHARACTER_POSITION;
#endif

#if defined(__polyspace__XA_CLASS) && !defined(__polyspace_no__XA_CLASS)
#include <X11/Xmu/Atoms.h>
#undef _XA_CLASS
  extern AtomPtr   _XA_CLASS;
#endif

#if defined(__polyspace__XA_CLIENT_WINDOW) && !defined(__polyspace_no__XA_CLIENT_WINDOW)
#include <X11/Xmu/Atoms.h>
#undef _XA_CLIENT_WINDOW
  extern AtomPtr   _XA_CLIENT_WINDOW;
#endif

#if defined(__polyspace__XA_CLIPBOARD) && !defined(__polyspace_no__XA_CLIPBOARD)
#include <X11/Xmu/Atoms.h>
#undef _XA_CLIPBOARD
  extern AtomPtr   _XA_CLIPBOARD;
#endif

#if defined(__polyspace__XA_COMPOUND_TEXT) && !defined(__polyspace_no__XA_COMPOUND_TEXT)
#include <X11/Xmu/Atoms.h>
#undef _XA_COMPOUND_TEXT
  extern AtomPtr   _XA_COMPOUND_TEXT;
#endif

#if defined(__polyspace__XA_DECNET_ADDRESS) && !defined(__polyspace_no__XA_DECNET_ADDRESS)
#include <X11/Xmu/Atoms.h>
#undef _XA_DECNET_ADDRESS
  extern AtomPtr   _XA_DECNET_ADDRESS;
#endif

#if defined(__polyspace__XA_DELETE) && !defined(__polyspace_no__XA_DELETE)
#include <X11/Xmu/Atoms.h>
#undef _XA_DELETE
  extern AtomPtr   _XA_DELETE;
#endif

#if defined(__polyspace__XA_FILENAME) && !defined(__polyspace_no__XA_FILENAME)
#include <X11/Xmu/Atoms.h>
#undef _XA_FILENAME
  extern AtomPtr   _XA_FILENAME;
#endif

#if defined(__polyspace__XA_HOSTNAME) && !defined(__polyspace_no__XA_HOSTNAME)
#include <X11/Xmu/Atoms.h>
#undef _XA_HOSTNAME
  extern AtomPtr   _XA_HOSTNAME;
#endif

#if defined(__polyspace__XA_IP_ADDRESS) && !defined(__polyspace_no__XA_IP_ADDRESS)
#include <X11/Xmu/Atoms.h>
#undef _XA_IP_ADDRESS
  extern AtomPtr   _XA_IP_ADDRESS;
#endif

#if defined(__polyspace__XA_LENGTH) && !defined(__polyspace_no__XA_LENGTH)
#include <X11/Xmu/Atoms.h>
#undef _XA_LENGTH
  extern AtomPtr   _XA_LENGTH;
#endif

#if defined(__polyspace__XA_LIST_LENGTH) && !defined(__polyspace_no__XA_LIST_LENGTH)
#include <X11/Xmu/Atoms.h>
#undef _XA_LIST_LENGTH
  extern AtomPtr   _XA_LIST_LENGTH;
#endif

#if defined(__polyspace__XA_NAME) && !defined(__polyspace_no__XA_NAME)
#include <X11/Xmu/Atoms.h>
#undef _XA_NAME
  extern AtomPtr   _XA_NAME;
#endif

#if defined(__polyspace__XA_NET_ADDRESS) && !defined(__polyspace_no__XA_NET_ADDRESS)
#include <X11/Xmu/Atoms.h>
#undef _XA_NET_ADDRESS
  extern AtomPtr   _XA_NET_ADDRESS;
#endif

#if defined(__polyspace__XA_NULL) && !defined(__polyspace_no__XA_NULL)
#include <X11/Xmu/Atoms.h>
#undef _XA_NULL
  extern AtomPtr   _XA_NULL;
#endif

#if defined(__polyspace__XA_OWNER_OS) && !defined(__polyspace_no__XA_OWNER_OS)
#include <X11/Xmu/Atoms.h>
#undef _XA_OWNER_OS
  extern AtomPtr   _XA_OWNER_OS;
#endif

#if defined(__polyspace__XA_SPAN) && !defined(__polyspace_no__XA_SPAN)
#include <X11/Xmu/Atoms.h>
#undef _XA_SPAN
  extern AtomPtr   _XA_SPAN;
#endif

#if defined(__polyspace__XA_TARGETS) && !defined(__polyspace_no__XA_TARGETS)
#include <X11/Xmu/Atoms.h>
#undef _XA_TARGETS
  extern AtomPtr   _XA_TARGETS;
#endif

#if defined(__polyspace__XA_TEXT) && !defined(__polyspace_no__XA_TEXT)
#include <X11/Xmu/Atoms.h>
#undef _XA_TEXT
  extern AtomPtr   _XA_TEXT;
#endif

#if defined(__polyspace__XA_TIMESTAMP) && !defined(__polyspace_no__XA_TIMESTAMP)
#include <X11/Xmu/Atoms.h>
#undef _XA_TIMESTAMP
  extern AtomPtr   _XA_TIMESTAMP;
#endif

#if defined(__polyspace__XA_USER) && !defined(__polyspace_no__XA_USER)
#include <X11/Xmu/Atoms.h>
#undef _XA_USER
  extern AtomPtr   _XA_USER;
#endif

#if defined(__polyspace_MultibufferScreenIndex) && !defined(__polyspace_no_MultibufferScreenIndex)
#include <X11/extensions/multibufst.h>
#undef MultibufferScreenIndex
  extern int MultibufferScreenIndex;
#endif

#if defined(__polyspace_MultibufferWindowIndex) && !defined(__polyspace_no_MultibufferWindowIndex)
#include <X11/extensions/multibufst.h>
#undef MultibufferWindowIndex
  extern int MultibufferWindowIndex;
#endif

#if defined(__polyspace_MultibufferDrawableResType) && !defined(__polyspace_no_MultibufferDrawableResType)
#include <X11/extensions/multibufst.h>
#undef MultibufferDrawableResType
  extern RESTYPE MultibufferDrawableResType;
#endif

#if defined(__polyspace_frameWindowPrivateIndex) && !defined(__polyspace_no_frameWindowPrivateIndex)
#include <X11/extensions/multibufst.h>
#undef frameWindowPrivateIndex
  extern int frameWindowPrivateIndex;
#endif

#if defined(__polyspace_compositeWidgetClass) && !defined(__polyspace_no_compositeWidgetClass)
#include <X11/Composite.h>
#undef compositeWidgetClass
  externalref WidgetClass compositeWidgetClass;
#endif

#if defined(__polyspace_compositeClassRec) && !defined(__polyspace_no_compositeClassRec)
#include <X11/CompositeP.h>
#undef compositeClassRec
  externalref CompositeClassRec compositeClassRec;
#endif

#if defined(__polyspace_constraintClassRec) && !defined(__polyspace_no_constraintClassRec)
#include <X11/ConstrainP.h>
#undef constraintClassRec
  externalref ConstraintClassRec constraintClassRec;
#endif

#if defined(__polyspace_constraintWidgetClass) && !defined(__polyspace_no_constraintWidgetClass)
#include <X11/Constraint.h>
#undef constraintWidgetClass
  externalref WidgetClass constraintWidgetClass;
#endif

#if defined(__polyspace_coreWidgetClass) && !defined(__polyspace_no_coreWidgetClass)
#include <X11/Core.h>
#undef coreWidgetClass
  externalref WidgetClass coreWidgetClass;
#endif

#if defined(__polyspace_widgetClass) && !defined(__polyspace_no_widgetClass)
#include <X11/Core.h>
#undef widgetClass
  externalref WidgetClass widgetClass;
#endif

#if defined(__polyspace__XtInheritTranslations) && !defined(__polyspace_no__XtInheritTranslations)
#include <X11/CoreP.h>
#undef _XtInheritTranslations
  externalref int _XtInheritTranslations;
#endif

#if defined(__polyspace_widgetClassRec) && !defined(__polyspace_no_widgetClassRec)
#include <X11/CoreP.h>
#undef widgetClassRec
  externalref WidgetClassRec widgetClassRec;
#endif

#if defined(__polyspace_colorConvertArgs) && !defined(__polyspace_no_colorConvertArgs)
#include <X11/Intrinsic.h>
#undef colorConvertArgs
  externalref XtConvertArgRec const colorConvertArgs[];
#endif

#if defined(__polyspace_screenConvertArg) && !defined(__polyspace_no_screenConvertArg)
#include <X11/Intrinsic.h>
#undef screenConvertArg
  externalref XtConvertArgRec const screenConvertArg[];
#endif

#if defined(__polyspace_objectClass) && !defined(__polyspace_no_objectClass)
#include <X11/Object.h>
#undef objectClass
  externalref WidgetClass objectClass;
#endif

#if defined(__polyspace_objectClassRec) && !defined(__polyspace_no_objectClassRec)
#include <X11/ObjectP.h>
#undef objectClassRec
  externalref ObjectClassRec objectClassRec;
#endif

#if defined(__polyspace_rectObjClass) && !defined(__polyspace_no_rectObjClass)
#include <X11/RectObj.h>
#undef rectObjClass
  externalref WidgetClass rectObjClass;
#endif

#if defined(__polyspace_rectObjClassRec) && !defined(__polyspace_no_rectObjClassRec)
#include <X11/RectObjP.h>
#undef rectObjClassRec
  externalref RectObjClassRec rectObjClassRec;
#endif

#if defined(__polyspace_XtShellStrings) && !defined(__polyspace_no_XtShellStrings)
#include <X11/Shell.h>
#undef XtShellStrings
  extern _XtConst_ char XtShellStrings[];
#endif

#if defined(__polyspace_XtR6ShellStrings) && !defined(__polyspace_no_XtR6ShellStrings)
#include <X11/Shell.h>
#undef XtR6ShellStrings
  extern _XtConst_ char XtR6ShellStrings[];
#endif

#if defined(__polyspace_shellWidgetClass) && !defined(__polyspace_no_shellWidgetClass)
#include <X11/Shell.h>
#undef shellWidgetClass
  externalref WidgetClass shellWidgetClass;
#endif

#if defined(__polyspace_overrideShellWidgetClass) && !defined(__polyspace_no_overrideShellWidgetClass)
#include <X11/Shell.h>
#undef overrideShellWidgetClass
  externalref WidgetClass overrideShellWidgetClass;
#endif

#if defined(__polyspace_wmShellWidgetClass) && !defined(__polyspace_no_wmShellWidgetClass)
#include <X11/Shell.h>
#undef wmShellWidgetClass
  externalref WidgetClass wmShellWidgetClass;
#endif

#if defined(__polyspace_transientShellWidgetClass) && !defined(__polyspace_no_transientShellWidgetClass)
#include <X11/Shell.h>
#undef transientShellWidgetClass
  externalref WidgetClass transientShellWidgetClass;
#endif

#if defined(__polyspace_topLevelShellWidgetClass) && !defined(__polyspace_no_topLevelShellWidgetClass)
#include <X11/Shell.h>
#undef topLevelShellWidgetClass
  externalref WidgetClass topLevelShellWidgetClass;
#endif

#if defined(__polyspace_applicationShellWidgetClass) && !defined(__polyspace_no_applicationShellWidgetClass)
#include <X11/Shell.h>
#undef applicationShellWidgetClass
  externalref WidgetClass applicationShellWidgetClass;
#endif

#if defined(__polyspace_sessionShellWidgetClass) && !defined(__polyspace_no_sessionShellWidgetClass)
#include <X11/Shell.h>
#undef sessionShellWidgetClass
  externalref WidgetClass sessionShellWidgetClass;
#endif

#if defined(__polyspace_shellClassRec) && !defined(__polyspace_no_shellClassRec)
#include <X11/ShellP.h>
#undef shellClassRec
  externalref ShellClassRec shellClassRec;
#endif

#if defined(__polyspace_overrideShellClassRec) && !defined(__polyspace_no_overrideShellClassRec)
#include <X11/ShellP.h>
#undef overrideShellClassRec
  externalref OverrideShellClassRec overrideShellClassRec;
#endif

#if defined(__polyspace_wmShellClassRec) && !defined(__polyspace_no_wmShellClassRec)
#include <X11/ShellP.h>
#undef wmShellClassRec
  externalref WMShellClassRec wmShellClassRec;
#endif

#if defined(__polyspace_transientShellClassRec) && !defined(__polyspace_no_transientShellClassRec)
#include <X11/ShellP.h>
#undef transientShellClassRec
  externalref TransientShellClassRec transientShellClassRec;
#endif

#if defined(__polyspace_topLevelShellClassRec) && !defined(__polyspace_no_topLevelShellClassRec)
#include <X11/ShellP.h>
#undef topLevelShellClassRec
  externalref TopLevelShellClassRec topLevelShellClassRec;
#endif

#if defined(__polyspace_applicationShellClassRec) && !defined(__polyspace_no_applicationShellClassRec)
#include <X11/ShellP.h>
#undef applicationShellClassRec
  externalref ApplicationShellClassRec applicationShellClassRec;
#endif

#if defined(__polyspace_sessionShellClassRec) && !defined(__polyspace_no_sessionShellClassRec)
#include <X11/ShellP.h>
#undef sessionShellClassRec
  externalref SessionShellClassRec sessionShellClassRec;
#endif

#if defined(__polyspace_XtStrings) && !defined(__polyspace_no_XtStrings)
#include <X11/StringDefs.h>
#undef XtStrings
  extern _XtConst_ char XtStrings[];
#endif

#if defined(__polyspace_XtR6Strings) && !defined(__polyspace_no_XtR6Strings)
#include <X11/StringDefs.h>
#undef XtR6Strings
  extern _XtConst_ char XtR6Strings[];
#endif

#if defined(__polyspace_vendorShellWidgetClass) && !defined(__polyspace_no_vendorShellWidgetClass)
#include <X11/Vendor.h>
#undef vendorShellWidgetClass
  externalref WidgetClass vendorShellWidgetClass;
#endif

#if defined(__polyspace_vendorShellClassRec) && !defined(__polyspace_no_vendorShellClassRec)
#include <X11/VendorP.h>
#undef vendorShellClassRec
  externalref VendorShellClassRec vendorShellClassRec;
#endif

#if defined(__polyspace__Xdebug) && !defined(__polyspace_no__Xdebug)
#include <X11/Xlib.h>
#undef _Xdebug
  extern int _Xdebug;
#endif

#if defined(__polyspace__Xglobal_lock) && !defined(__polyspace_no__Xglobal_lock)
#include <X11/Xlibint.h>
#undef _Xglobal_lock
  extern LockInfoPtr _Xglobal_lock;
#endif

#if defined(__polyspace_errno) && !defined(__polyspace_no_errno)
#include <X11/Xlibint.h>
#undef errno
  extern int errno;
#endif

#if defined(__polyspace_sys_errlist) && !defined(__polyspace_no_sys_errlist)
#include <X11/Xos.h>
#undef sys_errlist
  extern char *sys_errlist[];
#endif

#if defined(__polyspace_sys_nerr) && !defined(__polyspace_no_sys_nerr)
#include <X11/Xos.h>
#undef sys_nerr
  extern int sys_nerr;
#endif

#if defined(__polyspace__XsStream) && !defined(__polyspace_no__XsStream)
#include <X11/Xstreams.h>
#undef _XsStream
  extern Xstream _XsStream[];
#endif

#if defined(__polyspace_jpeg_zigzag_order) && !defined(__polyspace_no_jpeg_zigzag_order)
#include <X11/jpegint.h>
#undef jpeg_zigzag_order
  extern const int jpeg_zigzag_order[];
#endif

#if defined(__polyspace_jpeg_natural_order) && !defined(__polyspace_no_jpeg_natural_order)
#include <X11/jpegint.h>
#undef jpeg_natural_order
  extern const int jpeg_natural_order[];
#endif

#if defined(__polyspace_xmArrowButtonGadgetClassRec) && !defined(__polyspace_no_xmArrowButtonGadgetClassRec)
#include <Xm/ArrowBGP.h>
#undef xmArrowButtonGadgetClassRec
  externalref XmArrowButtonGadgetClassRec xmArrowButtonGadgetClassRec;
#endif

#if defined(__polyspace_xmArrowButtonClassRec) && !defined(__polyspace_no_xmArrowButtonClassRec)
#include <Xm/ArrowBP.h>
#undef xmArrowButtonClassRec
  externalref XmArrowButtonClassRec xmArrowButtonClassRec;
#endif

#if defined(__polyspace_XmQmotif) && !defined(__polyspace_no_XmQmotif)
#include <Xm/BaseClassP.h>
#undef XmQmotif
  externalref XrmQuark  XmQmotif;
#endif

#if defined(__polyspace__XmInheritClass) && !defined(__polyspace_no__XmInheritClass)
#include <Xm/BaseClassP.h>
#undef _XmInheritClass
  externalref int  _XmInheritClass;
#endif

#if defined(__polyspace__Xm_fastPtr) && !defined(__polyspace_no__Xm_fastPtr)
#include <Xm/BaseClassP.h>
#undef _Xm_fastPtr
  externalref XmBaseClassExt * _Xm_fastPtr;
#endif

#if defined(__polyspace_xmBulletinBoardClassRec) && !defined(__polyspace_no_xmBulletinBoardClassRec)
#include <Xm/BulletinBP.h>
#undef xmBulletinBoardClassRec
  externalref XmBulletinBoardClassRec xmBulletinBoardClassRec;
#endif

#if defined(__polyspace_xmCascadeButtonGCacheObjClassRec) && !defined(__polyspace_no_xmCascadeButtonGCacheObjClassRec)
#include <Xm/CascadeBGP.h>
#undef xmCascadeButtonGCacheObjClassRec
  externalref XmCascadeButtonGCacheObjClassRec xmCascadeButtonGCacheObjClassRec;
#endif

#if defined(__polyspace_xmCascadeButtonGadgetClassRec) && !defined(__polyspace_no_xmCascadeButtonGadgetClassRec)
#include <Xm/CascadeBGP.h>
#undef xmCascadeButtonGadgetClassRec
  externalref XmCascadeButtonGadgetClassRec xmCascadeButtonGadgetClassRec;
#endif

#if defined(__polyspace_xmCascadeButtonClassRec) && !defined(__polyspace_no_xmCascadeButtonClassRec)
#include <Xm/CascadeBP.h>
#undef xmCascadeButtonClassRec
  externalref XmCascadeButtonClassRec xmCascadeButtonClassRec;
#endif

#if defined(__polyspace_xmClipWindowClassRec) && !defined(__polyspace_no_xmClipWindowClassRec)
#include <Xm/ClipWindowP.h>
#undef xmClipWindowClassRec
  externalref XmClipWindowClassRec xmClipWindowClassRec;
#endif

#if defined(__polyspace_xmColorObjClassRec) && !defined(__polyspace_no_xmColorObjClassRec)
#include <Xm/ColorObjP.h>
#undef xmColorObjClassRec
  externalref XmColorObjClassRec xmColorObjClassRec;
#endif

#if defined(__polyspace_xmColorObjClass) && !defined(__polyspace_no_xmColorObjClass)
#include <Xm/ColorObjP.h>
#undef xmColorObjClass
  externalref WidgetClass xmColorObjClass;
#endif

#if defined(__polyspace_xmComboBoxClassRec) && !defined(__polyspace_no_xmComboBoxClassRec)
#include <Xm/ComboBoxP.h>
#undef xmComboBoxClassRec
  externalref XmComboBoxClassRec xmComboBoxClassRec;
#endif

#if defined(__polyspace_xmCommandClassRec) && !defined(__polyspace_no_xmCommandClassRec)
#include <Xm/CommandP.h>
#undef xmCommandClassRec
  externalref XmCommandClassRec xmCommandClassRec;
#endif

#if defined(__polyspace_xmContainerClassRec) && !defined(__polyspace_no_xmContainerClassRec)
#include <Xm/ContainerP.h>
#undef xmContainerClassRec
  externalref XmContainerClassRec xmContainerClassRec;
#endif

#if defined(__polyspace_xmDesktopClass) && !defined(__polyspace_no_xmDesktopClass)
#include <Xm/DesktopP.h>
#undef xmDesktopClass
  externalref WidgetClass xmDesktopClass;
#endif

#if defined(__polyspace_xmDesktopClassRec) && !defined(__polyspace_no_xmDesktopClassRec)
#include <Xm/DesktopP.h>
#undef xmDesktopClassRec
  externalref XmDesktopClassRec xmDesktopClassRec;
#endif

#if defined(__polyspace_xmDialogShellExtClassRec) && !defined(__polyspace_no_xmDialogShellExtClassRec)
#include <Xm/DialogSEP.h>
#undef xmDialogShellExtClassRec
  externalref XmDialogShellExtClassRec xmDialogShellExtClassRec;
#endif

#if defined(__polyspace_xmDialogShellClassRec) && !defined(__polyspace_no_xmDialogShellClassRec)
#include <Xm/DialogSP.h>
#undef xmDialogShellClassRec
  externalref XmDialogShellClassRec xmDialogShellClassRec;
#endif

#if defined(__polyspace_xmDisplayClass) && !defined(__polyspace_no_xmDisplayClass)
#include <Xm/Display.h>
#undef xmDisplayClass
  externalref WidgetClass xmDisplayClass;
#endif

#if defined(__polyspace_xmDisplayClassRec) && !defined(__polyspace_no_xmDisplayClassRec)
#include <Xm/DisplayP.h>
#undef xmDisplayClassRec
  externalref XmDisplayClassRec xmDisplayClassRec;
#endif

#if defined(__polyspace__Xm_MOTIF_DRAG_AND_DROP_MESSAGE) && !defined(__polyspace_no__Xm_MOTIF_DRAG_AND_DROP_MESSAGE)
#include <Xm/DisplayP.h>
#undef _Xm_MOTIF_DRAG_AND_DROP_MESSAGE
  externalref String _Xm_MOTIF_DRAG_AND_DROP_MESSAGE;
#endif

#if defined(__polyspace_xmDragContextClass) && !defined(__polyspace_no_xmDragContextClass)
#include <Xm/DragC.h>
#undef xmDragContextClass
  externalref WidgetClass xmDragContextClass;
#endif

#if defined(__polyspace_xmDragContextClassRec) && !defined(__polyspace_no_xmDragContextClassRec)
#include <Xm/DragCP.h>
#undef xmDragContextClassRec
  externalref XmDragContextClassRec xmDragContextClassRec;
#endif

#if defined(__polyspace_xmDragIconObjectClass) && !defined(__polyspace_no_xmDragIconObjectClass)
#include <Xm/DragIcon.h>
#undef xmDragIconObjectClass
  externalref WidgetClass xmDragIconObjectClass;
#endif

#if defined(__polyspace_xmDragIconClassRec) && !defined(__polyspace_no_xmDragIconClassRec)
#include <Xm/DragIconP.h>
#undef xmDragIconClassRec
  externalref XmDragIconClassRec xmDragIconClassRec;
#endif

#if defined(__polyspace_xmDragOverShellWidgetClass) && !defined(__polyspace_no_xmDragOverShellWidgetClass)
#include <Xm/DragOverS.h>
#undef xmDragOverShellWidgetClass
  externalref WidgetClass xmDragOverShellWidgetClass;
#endif

#if defined(__polyspace_xmDragOverShellClassRec) && !defined(__polyspace_no_xmDragOverShellClassRec)
#include <Xm/DragOverSP.h>
#undef xmDragOverShellClassRec
  externalref XmDragOverShellClassRec xmDragOverShellClassRec;
#endif

#if defined(__polyspace_xmDrawingAreaClassRec) && !defined(__polyspace_no_xmDrawingAreaClassRec)
#include <Xm/DrawingAP.h>
#undef xmDrawingAreaClassRec
  externalref XmDrawingAreaClassRec xmDrawingAreaClassRec;
#endif

#if defined(__polyspace_xmDrawnButtonClassRec) && !defined(__polyspace_no_xmDrawnButtonClassRec)
#include <Xm/DrawnBP.h>
#undef xmDrawnButtonClassRec
  externalref XmDrawnButtonClassRec xmDrawnButtonClassRec;
#endif

#if defined(__polyspace_xmDropSiteManagerObjectClass) && !defined(__polyspace_no_xmDropSiteManagerObjectClass)
#include <Xm/DropSMgr.h>
#undef xmDropSiteManagerObjectClass
  externalref WidgetClass xmDropSiteManagerObjectClass;
#endif

#if defined(__polyspace_xmDropSiteManagerClassRec) && !defined(__polyspace_no_xmDropSiteManagerClassRec)
#include <Xm/DropSMgrP.h>
#undef xmDropSiteManagerClassRec
  externalref XmDropSiteManagerClassRec xmDropSiteManagerClassRec;
#endif

#if defined(__polyspace_xmDropTransferClassRec) && !defined(__polyspace_no_xmDropTransferClassRec)
#include <Xm/DropTransP.h>
#undef xmDropTransferClassRec
  externalref XmDropTransferClassRec xmDropTransferClassRec;
#endif

#if defined(__polyspace_xmExtObjectClass) && !defined(__polyspace_no_xmExtObjectClass)
#include <Xm/ExtObjectP.h>
#undef xmExtObjectClass
  externalref WidgetClass xmExtObjectClass;
#endif

#if defined(__polyspace_xmExtClassRec) && !defined(__polyspace_no_xmExtClassRec)
#include <Xm/ExtObjectP.h>
#undef xmExtClassRec
  externalref XmExtClassRec xmExtClassRec;
#endif

#if defined(__polyspace_xmFileSelectionBoxWidgetClass) && !defined(__polyspace_no_xmFileSelectionBoxWidgetClass)
#include <Xm/FileSB.h>
#undef xmFileSelectionBoxWidgetClass
  externalref WidgetClass xmFileSelectionBoxWidgetClass;
#endif

#if defined(__polyspace_xmFileSelectionBoxClassRec) && !defined(__polyspace_no_xmFileSelectionBoxClassRec)
#include <Xm/FileSBP.h>
#undef xmFileSelectionBoxClassRec
  externalref XmFileSelectionBoxClassRec xmFileSelectionBoxClassRec;
#endif

#if defined(__polyspace_xmFormClassRec) && !defined(__polyspace_no_xmFormClassRec)
#include <Xm/FormP.h>
#undef xmFormClassRec
  externalref XmFormClassRec xmFormClassRec;
#endif

#if defined(__polyspace_xmFrameClassRec) && !defined(__polyspace_no_xmFrameClassRec)
#include <Xm/FrameP.h>
#undef xmFrameClassRec
  externalref XmFrameClassRec xmFrameClassRec;
#endif

#if defined(__polyspace_xmGadgetClassRec) && !defined(__polyspace_no_xmGadgetClassRec)
#include <Xm/GadgetP.h>
#undef xmGadgetClassRec
  externalref XmGadgetClassRec xmGadgetClassRec;
#endif

#if defined(__polyspace_xmGrabShellClassRec) && !defined(__polyspace_no_xmGrabShellClassRec)
#include <Xm/GrabShellP.h>
#undef xmGrabShellClassRec
  externalref XmGrabShellClassRec xmGrabShellClassRec;
#endif

#if defined(__polyspace_xmIconGadgetClassRec) && !defined(__polyspace_no_xmIconGadgetClassRec)
#include <Xm/IconGP.h>
#undef xmIconGadgetClassRec
  extern XmIconGadgetClassRec xmIconGadgetClassRec;
#endif

#if defined(__polyspace_xmIconGCacheObjClassRec) && !defined(__polyspace_no_xmIconGCacheObjClassRec)
#include <Xm/IconGP.h>
#undef xmIconGCacheObjClassRec
  externalref XmIconGCacheObjClassRec xmIconGCacheObjClassRec;
#endif

#if defined(__polyspace_xmIconHeaderClassRec) && !defined(__polyspace_no_xmIconHeaderClassRec)
#include <Xm/IconHP.h>
#undef xmIconHeaderClassRec
  extern XmIconHeaderClassRec xmIconHeaderClassRec;
#endif

#if defined(__polyspace_xmLabelGCacheObjClassRec) && !defined(__polyspace_no_xmLabelGCacheObjClassRec)
#include <Xm/LabelGP.h>
#undef xmLabelGCacheObjClassRec
  externalref XmLabelGCacheObjClassRec xmLabelGCacheObjClassRec;
#endif

#if defined(__polyspace_xmLabelGadgetClassRec) && !defined(__polyspace_no_xmLabelGadgetClassRec)
#include <Xm/LabelGP.h>
#undef xmLabelGadgetClassRec
  externalref XmLabelGadgetClassRec xmLabelGadgetClassRec;
#endif

#if defined(__polyspace_xmLabelClassRec) && !defined(__polyspace_no_xmLabelClassRec)
#include <Xm/LabelP.h>
#undef xmLabelClassRec
  externalref XmLabelClassRec xmLabelClassRec;
#endif

#if defined(__polyspace_xmListClassRec) && !defined(__polyspace_no_xmListClassRec)
#include <Xm/ListP.h>
#undef xmListClassRec
  externalref XmListClassRec xmListClassRec;
#endif

#if defined(__polyspace_xmMainWindowClassRec) && !defined(__polyspace_no_xmMainWindowClassRec)
#include <Xm/MainWP.h>
#undef xmMainWindowClassRec
  externalref XmMainWindowClassRec xmMainWindowClassRec;
#endif

#if defined(__polyspace_xmManagerClassRec) && !defined(__polyspace_no_xmManagerClassRec)
#include <Xm/ManagerP.h>
#undef xmManagerClassRec
  externalref XmManagerClassRec xmManagerClassRec;
#endif

#if defined(__polyspace_xmMenuShellClassRec) && !defined(__polyspace_no_xmMenuShellClassRec)
#include <Xm/MenuShellP.h>
#undef xmMenuShellClassRec
  externalref XmMenuShellClassRec xmMenuShellClassRec;
#endif

#if defined(__polyspace_XmQTmenuSavvy) && !defined(__polyspace_no_XmQTmenuSavvy)
#include <Xm/MenuT.h>
#undef XmQTmenuSavvy
  externalref XrmQuark XmQTmenuSavvy;
#endif

#if defined(__polyspace_xmMessageBoxClassRec) && !defined(__polyspace_no_xmMessageBoxClassRec)
#include <Xm/MessageBP.h>
#undef xmMessageBoxClassRec
  externalref XmMessageBoxClassRec xmMessageBoxClassRec;
#endif

#if defined(__polyspace_xmNotebookClassRec) && !defined(__polyspace_no_xmNotebookClassRec)
#include <Xm/NotebookP.h>
#undef xmNotebookClassRec
  externalref XmNotebookClassRec xmNotebookClassRec;
#endif

#if defined(__polyspace_xmPanedWindowClassRec) && !defined(__polyspace_no_xmPanedWindowClassRec)
#include <Xm/PanedWP.h>
#undef xmPanedWindowClassRec
  externalref XmPanedWindowClassRec xmPanedWindowClassRec;
#endif

#if defined(__polyspace_xmPrimitiveClassRec) && !defined(__polyspace_no_xmPrimitiveClassRec)
#include <Xm/PrimitiveP.h>
#undef xmPrimitiveClassRec
  externalref XmPrimitiveClassRec xmPrimitiveClassRec;
#endif

#if defined(__polyspace_XmPrimLayoutDir) && !defined(__polyspace_no_XmPrimLayoutDir)
#include <Xm/PrimitiveP.h>
#undef XmPrimLayoutDir
  extern XmDirection XmPrimLayoutDir;
#endif

#if defined(__polyspace_xmProtocolClassRec) && !defined(__polyspace_no_xmProtocolClassRec)
#include <Xm/ProtocolsP.h>
#undef xmProtocolClassRec
  externalref XmProtocolClassRec xmProtocolClassRec;
#endif

#if defined(__polyspace_xmProtocolObjectClass) && !defined(__polyspace_no_xmProtocolObjectClass)
#include <Xm/ProtocolsP.h>
#undef xmProtocolObjectClass
  externalref WidgetClass xmProtocolObjectClass;
#endif

#if defined(__polyspace_xmPushButtonGCacheObjClassRec) && !defined(__polyspace_no_xmPushButtonGCacheObjClassRec)
#include <Xm/PushBGP.h>
#undef xmPushButtonGCacheObjClassRec
  externalref XmPushButtonGCacheObjClassRec xmPushButtonGCacheObjClassRec;
#endif

#if defined(__polyspace_xmPushButtonGadgetClassRec) && !defined(__polyspace_no_xmPushButtonGadgetClassRec)
#include <Xm/PushBGP.h>
#undef xmPushButtonGadgetClassRec
  externalref XmPushButtonGadgetClassRec xmPushButtonGadgetClassRec;
#endif

#if defined(__polyspace_xmPushButtonClassRec) && !defined(__polyspace_no_xmPushButtonClassRec)
#include <Xm/PushBP.h>
#undef xmPushButtonClassRec
  externalref XmPushButtonClassRec xmPushButtonClassRec;
#endif

#if defined(__polyspace_xmRowColumnClassRec) && !defined(__polyspace_no_xmRowColumnClassRec)
#include <Xm/RowColumnP.h>
#undef xmRowColumnClassRec
  externalref XmRowColumnClassRec  xmRowColumnClassRec;
#endif

#if defined(__polyspace_xmSimpleSpinBoxClassRec) && !defined(__polyspace_no_xmSimpleSpinBoxClassRec)
#include <Xm/SSpinBP.h>
#undef xmSimpleSpinBoxClassRec
  externalref XmSimpleSpinBoxClassRec xmSimpleSpinBoxClassRec;
#endif

#if defined(__polyspace_xmSashClassRec) && !defined(__polyspace_no_xmSashClassRec)
#include <Xm/SashP.h>
#undef xmSashClassRec
  externalref XmSashClassRec xmSashClassRec;
#endif

#if defined(__polyspace_xmSashWidgetClass) && !defined(__polyspace_no_xmSashWidgetClass)
#include <Xm/SashP.h>
#undef xmSashWidgetClass
  externalref WidgetClass xmSashWidgetClass;
#endif

#if defined(__polyspace_xmScaleClassRec) && !defined(__polyspace_no_xmScaleClassRec)
#include <Xm/ScaleP.h>
#undef xmScaleClassRec
  externalref XmScaleClassRec xmScaleClassRec;
#endif

#if defined(__polyspace_xmScreenClass) && !defined(__polyspace_no_xmScreenClass)
#include <Xm/Screen.h>
#undef xmScreenClass
  externalref WidgetClass xmScreenClass;
#endif

#if defined(__polyspace_xmScreenClassRec) && !defined(__polyspace_no_xmScreenClassRec)
#include <Xm/ScreenP.h>
#undef xmScreenClassRec
  externalref XmScreenClassRec xmScreenClassRec;
#endif

#if defined(__polyspace_xmScrollBarClassRec) && !defined(__polyspace_no_xmScrollBarClassRec)
#include <Xm/ScrollBarP.h>
#undef xmScrollBarClassRec
  externalref XmScrollBarClassRec xmScrollBarClassRec;
#endif

#if defined(__polyspace_xmScrolledWindowClassRec) && !defined(__polyspace_no_xmScrolledWindowClassRec)
#include <Xm/ScrolledWP.h>
#undef xmScrolledWindowClassRec
  externalref XmScrolledWindowClassRec xmScrolledWindowClassRec;
#endif

#if defined(__polyspace_xmSelectionBoxClassRec) && !defined(__polyspace_no_xmSelectionBoxClassRec)
#include <Xm/SelectioBP.h>
#undef xmSelectionBoxClassRec
  externalref XmSelectionBoxClassRec xmSelectionBoxClassRec;
#endif

#if defined(__polyspace_xmSeparatorGCacheObjClassRec) && !defined(__polyspace_no_xmSeparatorGCacheObjClassRec)
#include <Xm/SeparatoGP.h>
#undef xmSeparatorGCacheObjClassRec
  externalref XmSeparatorGCacheObjClassRec xmSeparatorGCacheObjClassRec;
#endif

#if defined(__polyspace_xmSeparatorGadgetClassRec) && !defined(__polyspace_no_xmSeparatorGadgetClassRec)
#include <Xm/SeparatoGP.h>
#undef xmSeparatorGadgetClassRec
  externalref XmSeparatorGadgetClassRec xmSeparatorGadgetClassRec;
#endif

#if defined(__polyspace_xmSeparatorClassRec) && !defined(__polyspace_no_xmSeparatorClassRec)
#include <Xm/SeparatorP.h>
#undef xmSeparatorClassRec
  externalref XmSeparatorClassRec xmSeparatorClassRec;
#endif

#if defined(__polyspace_xmShellExtObjectClass) && !defined(__polyspace_no_xmShellExtObjectClass)
#include <Xm/ShellEP.h>
#undef xmShellExtObjectClass
  externalref WidgetClass xmShellExtObjectClass;
#endif

#if defined(__polyspace_xmShellExtClassRec) && !defined(__polyspace_no_xmShellExtClassRec)
#include <Xm/ShellEP.h>
#undef xmShellExtClassRec
  externalref XmShellExtClassRec xmShellExtClassRec;
#endif

#if defined(__polyspace_xmSpinBoxClassRec) && !defined(__polyspace_no_xmSpinBoxClassRec)
#include <Xm/SpinBP.h>
#undef xmSpinBoxClassRec
  externalref XmSpinBoxClassRec xmSpinBoxClassRec;
#endif

#if defined(__polyspace_xmTearOffButtonClassRec) && !defined(__polyspace_no_xmTearOffButtonClassRec)
#include <Xm/TearOffBP.h>
#undef xmTearOffButtonClassRec
  externalref XmTearOffButtonClassRec xmTearOffButtonClassRec;
#endif

#if defined(__polyspace_xmTearOffButtonWidgetClass) && !defined(__polyspace_no_xmTearOffButtonWidgetClass)
#include <Xm/TearOffBP.h>
#undef xmTearOffButtonWidgetClass
  externalref WidgetClass xmTearOffButtonWidgetClass;
#endif

#if defined(__polyspace__XmExcludedParentPane) && !defined(__polyspace_no__XmExcludedParentPane)
#include <Xm/TearOffP.h>
#undef _XmExcludedParentPane
  externalref XmExcludedParentPaneRec _XmExcludedParentPane;
#endif

#if defined(__polyspace_xmTextWidgetClass) && !defined(__polyspace_no_xmTextWidgetClass)
#include <Xm/Text.h>
#undef xmTextWidgetClass
  externalref WidgetClass  xmTextWidgetClass;
#endif

#if defined(__polyspace_xmTextFieldWidgetClass) && !defined(__polyspace_no_xmTextFieldWidgetClass)
#include <Xm/TextF.h>
#undef xmTextFieldWidgetClass
  externalref WidgetClass  xmTextFieldWidgetClass;
#endif

#if defined(__polyspace_xmTextFieldClassRec) && !defined(__polyspace_no_xmTextFieldClassRec)
#include <Xm/TextFP.h>
#undef xmTextFieldClassRec
  externalref XmTextFieldClassRec xmTextFieldClassRec;
#endif

#if defined(__polyspace__XmdefaultTextActionsTable) && !defined(__polyspace_no__XmdefaultTextActionsTable)
#include <Xm/TextInP.h>
#undef _XmdefaultTextActionsTable
  externalref XtPointer _XmdefaultTextActionsTable;
#endif

#if defined(__polyspace__XmdefaultTextActionsTableSize) && !defined(__polyspace_no__XmdefaultTextActionsTableSize)
#include <Xm/TextInP.h>
#undef _XmdefaultTextActionsTableSize
  externalref Cardinal _XmdefaultTextActionsTableSize;
#endif

#if defined(__polyspace_xmTextClassRec) && !defined(__polyspace_no_xmTextClassRec)
#include <Xm/TextP.h>
#undef xmTextClassRec
  externalref XmTextClassRec xmTextClassRec;
#endif

#if defined(__polyspace_xmToggleButtonGCacheObjClassRec) && !defined(__polyspace_no_xmToggleButtonGCacheObjClassRec)
#include <Xm/ToggleBGP.h>
#undef xmToggleButtonGCacheObjClassRec
  externalref XmToggleButtonGCacheObjClassRec xmToggleButtonGCacheObjClassRec;
#endif

#if defined(__polyspace_xmToggleButtonGadgetClassRec) && !defined(__polyspace_no_xmToggleButtonGadgetClassRec)
#include <Xm/ToggleBGP.h>
#undef xmToggleButtonGadgetClassRec
  externalref XmToggleButtonGadgetClassRec xmToggleButtonGadgetClassRec;
#endif

#if defined(__polyspace_xmToggleButtonClassRec) && !defined(__polyspace_no_xmToggleButtonClassRec)
#include <Xm/ToggleBP.h>
#undef xmToggleButtonClassRec
  externalref XmToggleButtonClassRec xmToggleButtonClassRec;
#endif

#if defined(__polyspace__XmBulletinB_defaultTranslations) && !defined(__polyspace_no__XmBulletinB_defaultTranslations)
#include <Xm/TransltnsP.h>
#undef _XmBulletinB_defaultTranslations
  externalref _XmConst char _XmBulletinB_defaultTranslations[];
#endif

#if defined(__polyspace__XmCascadeB_menubar_events) && !defined(__polyspace_no__XmCascadeB_menubar_events)
#include <Xm/TransltnsP.h>
#undef _XmCascadeB_menubar_events
  externalref _XmConst char _XmCascadeB_menubar_events[];
#endif

#if defined(__polyspace__XmCascadeB_p_events) && !defined(__polyspace_no__XmCascadeB_p_events)
#include <Xm/TransltnsP.h>
#undef _XmCascadeB_p_events
  externalref _XmConst char _XmCascadeB_p_events[];
#endif

#if defined(__polyspace__XmComboBox_defaultTranslations) && !defined(__polyspace_no__XmComboBox_defaultTranslations)
#include <Xm/TransltnsP.h>
#undef _XmComboBox_defaultTranslations
  externalref _XmConst char _XmComboBox_defaultTranslations[];
#endif

#if defined(__polyspace__XmComboBox_defaultAccelerators) && !defined(__polyspace_no__XmComboBox_defaultAccelerators)
#include <Xm/TransltnsP.h>
#undef _XmComboBox_defaultAccelerators
  externalref _XmConst char _XmComboBox_defaultAccelerators[];
#endif

#if defined(__polyspace__XmComboBox_dropDownComboBoxAccelerators) && !defined(__polyspace_no__XmComboBox_dropDownComboBoxAccelerators)
#include <Xm/TransltnsP.h>
#undef _XmComboBox_dropDownComboBoxAccelerators
  externalref _XmConst char _XmComboBox_dropDownComboBoxAccelerators[];
#endif

#if defined(__polyspace__XmComboBox_dropDownListTranslations) && !defined(__polyspace_no__XmComboBox_dropDownListTranslations)
#include <Xm/TransltnsP.h>
#undef _XmComboBox_dropDownListTranslations
  externalref _XmConst char _XmComboBox_dropDownListTranslations[];
#endif

#if defined(__polyspace__XmComboBox_textFocusTranslations) && !defined(__polyspace_no__XmComboBox_textFocusTranslations)
#include <Xm/TransltnsP.h>
#undef _XmComboBox_textFocusTranslations
  externalref _XmConst char _XmComboBox_textFocusTranslations[];
#endif

#if defined(__polyspace__XmContainer_defaultTranslations) && !defined(__polyspace_no__XmContainer_defaultTranslations)
#include <Xm/TransltnsP.h>
#undef _XmContainer_defaultTranslations
  externalref _XmConst char _XmContainer_defaultTranslations[];
#endif

#if defined(__polyspace__XmContainer_traversalTranslations) && !defined(__polyspace_no__XmContainer_traversalTranslations)
#include <Xm/TransltnsP.h>
#undef _XmContainer_traversalTranslations
  externalref _XmConst char _XmContainer_traversalTranslations[];
#endif

#if defined(__polyspace__XmDisplay_baseTranslations) && !defined(__polyspace_no__XmDisplay_baseTranslations)
#include <Xm/TransltnsP.h>
#undef _XmDisplay_baseTranslations
  externalref _XmConst char _XmDisplay_baseTranslations[];
#endif

#if defined(__polyspace__XmDragC_defaultTranslations) && !defined(__polyspace_no__XmDragC_defaultTranslations)
#include <Xm/TransltnsP.h>
#undef _XmDragC_defaultTranslations
  externalref _XmConst char _XmDragC_defaultTranslations[];
#endif

#if defined(__polyspace__XmDrawingA_defaultTranslations) && !defined(__polyspace_no__XmDrawingA_defaultTranslations)
#include <Xm/TransltnsP.h>
#undef _XmDrawingA_defaultTranslations
  externalref _XmConst char _XmDrawingA_defaultTranslations[];
#endif

#if defined(__polyspace__XmDrawingA_traversalTranslations) && !defined(__polyspace_no__XmDrawingA_traversalTranslations)
#include <Xm/TransltnsP.h>
#undef _XmDrawingA_traversalTranslations
  externalref _XmConst char _XmDrawingA_traversalTranslations[];
#endif

#if defined(__polyspace__XmDrawnB_defaultTranslations) && !defined(__polyspace_no__XmDrawnB_defaultTranslations)
#include <Xm/TransltnsP.h>
#undef _XmDrawnB_defaultTranslations
  externalref _XmConst char _XmDrawnB_defaultTranslations[];
#endif

#if defined(__polyspace__XmFrame_defaultTranslations) && !defined(__polyspace_no__XmFrame_defaultTranslations)
#include <Xm/TransltnsP.h>
#undef _XmFrame_defaultTranslations
  externalref _XmConst char _XmFrame_defaultTranslations[];
#endif

#if defined(__polyspace_) && !defined(__polyspace_no_)
#include <Xm/TransltnsP.h>
#undef 
  externalref _XmConst char _XmGrabShell_translations [];
#endif

#if defined(__polyspace__XmLabel_defaultTranslations) && !defined(__polyspace_no__XmLabel_defaultTranslations)
#include <Xm/TransltnsP.h>
#undef _XmLabel_defaultTranslations
  externalref _XmConst char _XmLabel_defaultTranslations[];
#endif

#if defined(__polyspace__XmLabel_menuTranslations) && !defined(__polyspace_no__XmLabel_menuTranslations)
#include <Xm/TransltnsP.h>
#undef _XmLabel_menuTranslations
  externalref _XmConst char _XmLabel_menuTranslations[];
#endif

#if defined(__polyspace__XmLabel_menu_traversal_events) && !defined(__polyspace_no__XmLabel_menu_traversal_events)
#include <Xm/TransltnsP.h>
#undef _XmLabel_menu_traversal_events
  externalref _XmConst char _XmLabel_menu_traversal_events[];
#endif

#if defined(__polyspace__XmList_ListXlations1) && !defined(__polyspace_no__XmList_ListXlations1)
#include <Xm/TransltnsP.h>
#undef _XmList_ListXlations1
  externalref _XmConst char _XmList_ListXlations1[];
#endif

#if defined(__polyspace__XmList_ListXlations2) && !defined(__polyspace_no__XmList_ListXlations2)
#include <Xm/TransltnsP.h>
#undef _XmList_ListXlations2
  externalref _XmConst char _XmList_ListXlations2[];
#endif

#if defined(__polyspace__XmManager_managerTraversalTranslations) && !defined(__polyspace_no__XmManager_managerTraversalTranslations)
#include <Xm/TransltnsP.h>
#undef _XmManager_managerTraversalTranslations
  externalref _XmConst char _XmManager_managerTraversalTranslations[];
#endif

#if defined(__polyspace__XmManager_defaultTranslations) && !defined(__polyspace_no__XmManager_defaultTranslations)
#include <Xm/TransltnsP.h>
#undef _XmManager_defaultTranslations
  externalref _XmConst char _XmManager_defaultTranslations[];
#endif

#if defined(__polyspace__XmNotebook_manager_translations) && !defined(__polyspace_no__XmNotebook_manager_translations)
#include <Xm/TransltnsP.h>
#undef _XmNotebook_manager_translations
  externalref _XmConst char _XmNotebook_manager_translations[];
#endif

#if defined(__polyspace__XmNotebook_TabAccelerators) && !defined(__polyspace_no__XmNotebook_TabAccelerators)
#include <Xm/TransltnsP.h>
#undef _XmNotebook_TabAccelerators
  externalref _XmConst char _XmNotebook_TabAccelerators[];
#endif

#if defined(__polyspace__XmPrimitive_defaultTranslations) && !defined(__polyspace_no__XmPrimitive_defaultTranslations)
#include <Xm/TransltnsP.h>
#undef _XmPrimitive_defaultTranslations
  externalref _XmConst char _XmPrimitive_defaultTranslations[];
#endif

#if defined(__polyspace__XmPushB_defaultTranslations) && !defined(__polyspace_no__XmPushB_defaultTranslations)
#include <Xm/TransltnsP.h>
#undef _XmPushB_defaultTranslations
  externalref _XmConst char _XmPushB_defaultTranslations[];
#endif

#if defined(__polyspace__XmPushB_menuTranslations) && !defined(__polyspace_no__XmPushB_menuTranslations)
#include <Xm/TransltnsP.h>
#undef _XmPushB_menuTranslations
  externalref _XmConst char _XmPushB_menuTranslations[];
#endif

#if defined(__polyspace__XmRowColumn_menu_traversal_table) && !defined(__polyspace_no__XmRowColumn_menu_traversal_table)
#include <Xm/TransltnsP.h>
#undef _XmRowColumn_menu_traversal_table
  externalref _XmConst char _XmRowColumn_menu_traversal_table[];
#endif

#if defined(__polyspace__XmRowColumn_bar_table) && !defined(__polyspace_no__XmRowColumn_bar_table)
#include <Xm/TransltnsP.h>
#undef _XmRowColumn_bar_table
  externalref _XmConst char _XmRowColumn_bar_table[];
#endif

#if defined(__polyspace__XmRowColumn_option_table) && !defined(__polyspace_no__XmRowColumn_option_table)
#include <Xm/TransltnsP.h>
#undef _XmRowColumn_option_table
  externalref _XmConst char _XmRowColumn_option_table[];
#endif

#if defined(__polyspace__XmRowColumn_menu_table) && !defined(__polyspace_no__XmRowColumn_menu_table)
#include <Xm/TransltnsP.h>
#undef _XmRowColumn_menu_table
  externalref _XmConst char _XmRowColumn_menu_table[];
#endif

#if defined(__polyspace__XmSash_defTranslations) && !defined(__polyspace_no__XmSash_defTranslations)
#include <Xm/TransltnsP.h>
#undef _XmSash_defTranslations
  externalref _XmConst char _XmSash_defTranslations[];
#endif

#if defined(__polyspace__XmScrollBar_defaultTranslations) && !defined(__polyspace_no__XmScrollBar_defaultTranslations)
#include <Xm/TransltnsP.h>
#undef _XmScrollBar_defaultTranslations
  externalref _XmConst char _XmScrollBar_defaultTranslations[];
#endif

#if defined(__polyspace__XmScrolledW_ScrolledWindowXlations) && !defined(__polyspace_no__XmScrolledW_ScrolledWindowXlations)
#include <Xm/TransltnsP.h>
#undef _XmScrolledW_ScrolledWindowXlations
  externalref _XmConst char _XmScrolledW_ScrolledWindowXlations[];
#endif

#if defined(__polyspace__XmClipWindowTranslationTable) && !defined(__polyspace_no__XmClipWindowTranslationTable)
#include <Xm/TransltnsP.h>
#undef _XmClipWindowTranslationTable
  externalref _XmConst char _XmClipWindowTranslationTable[];
#endif

#if defined(__polyspace__XmScrolledW_WorkWindowTranslationTable) && !defined(__polyspace_no__XmScrolledW_WorkWindowTranslationTable)
#include <Xm/TransltnsP.h>
#undef _XmScrolledW_WorkWindowTranslationTable
  externalref _XmConst char _XmScrolledW_WorkWindowTranslationTable[];
#endif

#if defined(__polyspace__XmSelectioB_defaultTextAccelerators) && !defined(__polyspace_no__XmSelectioB_defaultTextAccelerators)
#include <Xm/TransltnsP.h>
#undef _XmSelectioB_defaultTextAccelerators
  externalref _XmConst char _XmSelectioB_defaultTextAccelerators[];
#endif

#if defined(__polyspace__XmSpinB_defaultTranslations) && !defined(__polyspace_no__XmSpinB_defaultTranslations)
#include <Xm/TransltnsP.h>
#undef _XmSpinB_defaultTranslations
  externalref _XmConst char _XmSpinB_defaultTranslations[];
#endif

#if defined(__polyspace__XmSpinB_defaultAccelerators) && !defined(__polyspace_no__XmSpinB_defaultAccelerators)
#include <Xm/TransltnsP.h>
#undef _XmSpinB_defaultAccelerators
  externalref _XmConst char _XmSpinB_defaultAccelerators[];
#endif

#if defined(__polyspace__XmTearOffB_overrideTranslations) && !defined(__polyspace_no__XmTearOffB_overrideTranslations)
#include <Xm/TransltnsP.h>
#undef _XmTearOffB_overrideTranslations
  externalref _XmConst char _XmTearOffB_overrideTranslations[];
#endif

#if defined(__polyspace__XmTextF_EventBindings1) && !defined(__polyspace_no__XmTextF_EventBindings1)
#include <Xm/TransltnsP.h>
#undef _XmTextF_EventBindings1
  externalref _XmConst char _XmTextF_EventBindings1[];
#endif

#if defined(__polyspace__XmTextF_EventBindings2) && !defined(__polyspace_no__XmTextF_EventBindings2)
#include <Xm/TransltnsP.h>
#undef _XmTextF_EventBindings2
  externalref _XmConst char _XmTextF_EventBindings2[];
#endif

#if defined(__polyspace__XmTextF_EventBindings3) && !defined(__polyspace_no__XmTextF_EventBindings3)
#include <Xm/TransltnsP.h>
#undef _XmTextF_EventBindings3
  externalref _XmConst char _XmTextF_EventBindings3[];
#endif

#if defined(__polyspace__XmTextIn_XmTextEventBindings1) && !defined(__polyspace_no__XmTextIn_XmTextEventBindings1)
#include <Xm/TransltnsP.h>
#undef _XmTextIn_XmTextEventBindings1
  externalref _XmConst char _XmTextIn_XmTextEventBindings1[];
#endif

#if defined(__polyspace__XmTextIn_XmTextEventBindings2) && !defined(__polyspace_no__XmTextIn_XmTextEventBindings2)
#include <Xm/TransltnsP.h>
#undef _XmTextIn_XmTextEventBindings2
  externalref _XmConst char _XmTextIn_XmTextEventBindings2[];
#endif

#if defined(__polyspace__XmTextIn_XmTextEventBindings3) && !defined(__polyspace_no__XmTextIn_XmTextEventBindings3)
#include <Xm/TransltnsP.h>
#undef _XmTextIn_XmTextEventBindings3
  externalref _XmConst char _XmTextIn_XmTextEventBindings3[];
#endif

#if defined(__polyspace__XmTextIn_XmTextVEventBindings) && !defined(__polyspace_no__XmTextIn_XmTextVEventBindings)
#include <Xm/TransltnsP.h>
#undef _XmTextIn_XmTextVEventBindings
  externalref _XmConst char _XmTextIn_XmTextVEventBindings[];
#endif

#if defined(__polyspace__XmToggleB_defaultTranslations) && !defined(__polyspace_no__XmToggleB_defaultTranslations)
#include <Xm/TransltnsP.h>
#undef _XmToggleB_defaultTranslations
  externalref _XmConst char _XmToggleB_defaultTranslations[];
#endif

#if defined(__polyspace__XmToggleB_menuTranslations) && !defined(__polyspace_no__XmToggleB_menuTranslations)
#include <Xm/TransltnsP.h>
#undef _XmToggleB_menuTranslations
  externalref _XmConst char _XmToggleB_menuTranslations[];
#endif

#if defined(__polyspace__XmVirtKeys_fallbackBindingString) && !defined(__polyspace_no__XmVirtKeys_fallbackBindingString)
#include <Xm/TransltnsP.h>
#undef _XmVirtKeys_fallbackBindingString
  externalref _XmConst char _XmVirtKeys_fallbackBindingString[];
#endif

#if defined(__polyspace__XmVirtKeys_acornFallbackBindingString) && !defined(__polyspace_no__XmVirtKeys_acornFallbackBindingString)
#include <Xm/TransltnsP.h>
#undef _XmVirtKeys_acornFallbackBindingString
  externalref _XmConst char _XmVirtKeys_acornFallbackBindingString[];
#endif

#if defined(__polyspace__XmVirtKeys_apolloFallbackBindingString) && !defined(__polyspace_no__XmVirtKeys_apolloFallbackBindingString)
#include <Xm/TransltnsP.h>
#undef _XmVirtKeys_apolloFallbackBindingString
  externalref _XmConst char _XmVirtKeys_apolloFallbackBindingString[];
#endif

#if defined(__polyspace__XmVirtKeys_dgFallbackBindingString) && !defined(__polyspace_no__XmVirtKeys_dgFallbackBindingString)
#include <Xm/TransltnsP.h>
#undef _XmVirtKeys_dgFallbackBindingString
  externalref _XmConst char _XmVirtKeys_dgFallbackBindingString[];
#endif

#if defined(__polyspace__XmVirtKeys_decFallbackBindingString) && !defined(__polyspace_no__XmVirtKeys_decFallbackBindingString)
#include <Xm/TransltnsP.h>
#undef _XmVirtKeys_decFallbackBindingString
  externalref _XmConst char _XmVirtKeys_decFallbackBindingString[];
#endif

#if defined(__polyspace__XmVirtKeys_dblclkFallbackBindingString) && !defined(__polyspace_no__XmVirtKeys_dblclkFallbackBindingString)
#include <Xm/TransltnsP.h>
#undef _XmVirtKeys_dblclkFallbackBindingString
  externalref _XmConst char _XmVirtKeys_dblclkFallbackBindingString[];
#endif

#if defined(__polyspace__XmVirtKeys_hpFallbackBindingString) && !defined(__polyspace_no__XmVirtKeys_hpFallbackBindingString)
#include <Xm/TransltnsP.h>
#undef _XmVirtKeys_hpFallbackBindingString
  externalref _XmConst char _XmVirtKeys_hpFallbackBindingString[];
#endif

#if defined(__polyspace__XmVirtKeys_ibmFallbackBindingString) && !defined(__polyspace_no__XmVirtKeys_ibmFallbackBindingString)
#include <Xm/TransltnsP.h>
#undef _XmVirtKeys_ibmFallbackBindingString
  externalref _XmConst char _XmVirtKeys_ibmFallbackBindingString[];
#endif

#if defined(__polyspace__XmVirtKeys_ingrFallbackBindingString) && !defined(__polyspace_no__XmVirtKeys_ingrFallbackBindingString)
#include <Xm/TransltnsP.h>
#undef _XmVirtKeys_ingrFallbackBindingString
  externalref _XmConst char _XmVirtKeys_ingrFallbackBindingString[];
#endif

#if defined(__polyspace__XmVirtKeys_megatekFallbackBindingString) && !defined(__polyspace_no__XmVirtKeys_megatekFallbackBindingString)
#include <Xm/TransltnsP.h>
#undef _XmVirtKeys_megatekFallbackBindingString
  externalref _XmConst char _XmVirtKeys_megatekFallbackBindingString[];
#endif

#if defined(__polyspace__XmVirtKeys_motorolaFallbackBindingString) && !defined(__polyspace_no__XmVirtKeys_motorolaFallbackBindingString)
#include <Xm/TransltnsP.h>
#undef _XmVirtKeys_motorolaFallbackBindingString
  externalref _XmConst char _XmVirtKeys_motorolaFallbackBindingString[];
#endif

#if defined(__polyspace__XmVirtKeys_sgiFallbackBindingString) && !defined(__polyspace_no__XmVirtKeys_sgiFallbackBindingString)
#include <Xm/TransltnsP.h>
#undef _XmVirtKeys_sgiFallbackBindingString
  externalref _XmConst char _XmVirtKeys_sgiFallbackBindingString[];
#endif

#if defined(__polyspace__XmVirtKeys_siemensWx200FallbackBindingString) && !defined(__polyspace_no__XmVirtKeys_siemensWx200FallbackBindingString)
#include <Xm/TransltnsP.h>
#undef _XmVirtKeys_siemensWx200FallbackBindingString
  externalref _XmConst char _XmVirtKeys_siemensWx200FallbackBindingString[];
#endif

#if defined(__polyspace__XmVirtKeys_siemens9733FallbackBindingString) && !defined(__polyspace_no__XmVirtKeys_siemens9733FallbackBindingString)
#include <Xm/TransltnsP.h>
#undef _XmVirtKeys_siemens9733FallbackBindingString
  externalref _XmConst char _XmVirtKeys_siemens9733FallbackBindingString[];
#endif

#if defined(__polyspace__XmVirtKeys_sunFallbackBindingString) && !defined(__polyspace_no__XmVirtKeys_sunFallbackBindingString)
#include <Xm/TransltnsP.h>
#undef _XmVirtKeys_sunFallbackBindingString
  externalref _XmConst char _XmVirtKeys_sunFallbackBindingString[];
#endif

#if defined(__polyspace__XmVirtKeys_tekFallbackBindingString) && !defined(__polyspace_no__XmVirtKeys_tekFallbackBindingString)
#include <Xm/TransltnsP.h>
#undef _XmVirtKeys_tekFallbackBindingString
  externalref _XmConst char _XmVirtKeys_tekFallbackBindingString[];
#endif

#if defined(__polyspace_xmVendorShellExtObjectClass) && !defined(__polyspace_no_xmVendorShellExtObjectClass)
#include <Xm/VendorSEP.h>
#undef xmVendorShellExtObjectClass
  externalref WidgetClass xmVendorShellExtObjectClass;
#endif

#if defined(__polyspace_xmVendorShellExtClassRec) && !defined(__polyspace_no_xmVendorShellExtClassRec)
#include <Xm/VendorSEP.h>
#undef xmVendorShellExtClassRec
  externalref XmVendorShellExtClassRec xmVendorShellExtClassRec;
#endif

#if defined(__polyspace__XmSDEFAULT_FONT) && !defined(__polyspace_no__XmSDEFAULT_FONT)
#include <Xm/Xm.h>
#undef _XmSDEFAULT_FONT
  externalref char _XmSDEFAULT_FONT[];
#endif

#if defined(__polyspace__XmSDEFAULT_BACKGROUND) && !defined(__polyspace_no__XmSDEFAULT_BACKGROUND)
#include <Xm/Xm.h>
#undef _XmSDEFAULT_BACKGROUND
  externalref char _XmSDEFAULT_BACKGROUND[];
#endif

#if defined(__polyspace__XmStrings21) && !defined(__polyspace_no__XmStrings21)
#include <Xm/XmStrDefs.h>
#undef _XmStrings21
  externalref _XmConst char _XmStrings21[];
#endif

#if defined(__polyspace_xpmDataTypes) && !defined(__polyspace_no_xpmDataTypes)
#include <Xm/XpmI.h>
#undef xpmDataTypes
  extern xpmDataType xpmDataTypes[];
#endif

#if defined(__polyspace_xpmColorKeys) && !defined(__polyspace_no_xpmColorKeys)
#include <Xm/XpmI.h>
#undef xpmColorKeys
  extern char *xpmColorKeys[];
#endif

#if defined(__polyspace__XmxpmColorKeys) && !defined(__polyspace_no__XmxpmColorKeys)
#include <Xm/XpmI.h>
#undef _XmxpmColorKeys
  extern char *_XmxpmColorKeys[];
#endif

#if defined(__polyspace_constraint_tab) && !defined(__polyspace_no_constraint_tab)
#include <uil/UilSymGl.h>
#undef constraint_tab
  externalref unsigned char *constraint_tab;
#endif

#if defined(__polyspace_key_table) && !defined(__polyspace_no_key_table)
#include <uil/UilSymGl.h>
#undef key_table
  externalref key_keytable_entry_type *key_table;
#endif

#if defined(__polyspace_key_k_keyword_max_length) && !defined(__polyspace_no_key_k_keyword_max_length)
#include <uil/UilSymGl.h>
#undef key_k_keyword_max_length
  externalref int key_k_keyword_max_length;
#endif

#if defined(__polyspace_key_k_keyword_count) && !defined(__polyspace_no_key_k_keyword_count)
#include <uil/UilSymGl.h>
#undef key_k_keyword_count
  externalref int key_k_keyword_count;
#endif

#if defined(__polyspace_key_table_case_ins) && !defined(__polyspace_no_key_table_case_ins)
#include <uil/UilSymGl.h>
#undef key_table_case_ins
  externalref key_keytable_entry_type *key_table_case_ins;
#endif

#if defined(__polyspace_allowed_argument_table) && !defined(__polyspace_no_allowed_argument_table)
#include <uil/UilSymGl.h>
#undef allowed_argument_table
  externalref unsigned char **allowed_argument_table;
#endif

#if defined(__polyspace_argument_type_table) && !defined(__polyspace_no_argument_type_table)
#include <uil/UilSymGl.h>
#undef argument_type_table
  externalref unsigned char *argument_type_table;
#endif

#if defined(__polyspace_allowed_child_table) && !defined(__polyspace_no_allowed_child_table)
#include <uil/UilSymGl.h>
#undef allowed_child_table
  externalref unsigned char **allowed_child_table;
#endif

#if defined(__polyspace_child_class_table) && !defined(__polyspace_no_child_class_table)
#include <uil/UilSymGl.h>
#undef child_class_table
  externalref unsigned char *child_class_table;
#endif

#if defined(__polyspace_charset_xmstring_names_table) && !defined(__polyspace_no_charset_xmstring_names_table)
#include <uil/UilSymGl.h>
#undef charset_xmstring_names_table
  externalref char **charset_xmstring_names_table;
#endif

#if defined(__polyspace_charset_writing_direction_table) && !defined(__polyspace_no_charset_writing_direction_table)
#include <uil/UilSymGl.h>
#undef charset_writing_direction_table
  externalref unsigned char *charset_writing_direction_table;
#endif

#if defined(__polyspace_charset_parsing_direction_table) && !defined(__polyspace_no_charset_parsing_direction_table)
#include <uil/UilSymGl.h>
#undef charset_parsing_direction_table
  externalref unsigned char *charset_parsing_direction_table;
#endif

#if defined(__polyspace_charset_character_size_table) && !defined(__polyspace_no_charset_character_size_table)
#include <uil/UilSymGl.h>
#undef charset_character_size_table
  externalref unsigned char *charset_character_size_table;
#endif

#if defined(__polyspace_charset_lang_names_table) && !defined(__polyspace_no_charset_lang_names_table)
#include <uil/UilSymGl.h>
#undef charset_lang_names_table
  externalref char **charset_lang_names_table;
#endif

#if defined(__polyspace_charset_lang_codes_table) && !defined(__polyspace_no_charset_lang_codes_table)
#include <uil/UilSymGl.h>
#undef charset_lang_codes_table
  externalref unsigned short int *charset_lang_codes_table;
#endif

#if defined(__polyspace_charset_lang_table_max) && !defined(__polyspace_no_charset_lang_table_max)
#include <uil/UilSymGl.h>
#undef charset_lang_table_max
  externalref unsigned short int charset_lang_table_max;
#endif

#if defined(__polyspace_allowed_control_table) && !defined(__polyspace_no_allowed_control_table)
#include <uil/UilSymGl.h>
#undef allowed_control_table
  externalref unsigned char **allowed_control_table;
#endif

#if defined(__polyspace_enum_set_table) && !defined(__polyspace_no_enum_set_table)
#include <uil/UilSymGl.h>
#undef enum_set_table
  externalref UilEnumSetDescDef *enum_set_table;
#endif

#if defined(__polyspace_argument_enumset_table) && !defined(__polyspace_no_argument_enumset_table)
#include <uil/UilSymGl.h>
#undef argument_enumset_table
  externalref unsigned short int *argument_enumset_table;
#endif

#if defined(__polyspace_enumval_values_table) && !defined(__polyspace_no_enumval_values_table)
#include <uil/UilSymGl.h>
#undef enumval_values_table
  externalref int *enumval_values_table;
#endif

#if defined(__polyspace_uil_max_object) && !defined(__polyspace_no_uil_max_object)
#include <uil/UilSymGl.h>
#undef uil_max_object
  externalref int uil_max_object;
#endif

#if defined(__polyspace_uil_widget_names) && !defined(__polyspace_no_uil_widget_names)
#include <uil/UilSymGl.h>
#undef uil_widget_names
  externalref char **uil_widget_names;
#endif

#if defined(__polyspace_uil_max_arg) && !defined(__polyspace_no_uil_max_arg)
#include <uil/UilSymGl.h>
#undef uil_max_arg
  externalref int uil_max_arg;
#endif

#if defined(__polyspace_uil_argument_names) && !defined(__polyspace_no_uil_argument_names)
#include <uil/UilSymGl.h>
#undef uil_argument_names
  externalref char **uil_argument_names;
#endif

#if defined(__polyspace_uil_max_child) && !defined(__polyspace_no_uil_max_child)
#include <uil/UilSymGl.h>
#undef uil_max_child
  externalref int uil_max_child;
#endif

#if defined(__polyspace_uil_child_names) && !defined(__polyspace_no_uil_child_names)
#include <uil/UilSymGl.h>
#undef uil_child_names
  externalref char **uil_child_names;
#endif

#if defined(__polyspace_uil_max_reason) && !defined(__polyspace_no_uil_max_reason)
#include <uil/UilSymGl.h>
#undef uil_max_reason
  externalref int uil_max_reason;
#endif

#if defined(__polyspace_uil_reason_names) && !defined(__polyspace_no_uil_reason_names)
#include <uil/UilSymGl.h>
#undef uil_reason_names
  externalref char **uil_reason_names;
#endif

#if defined(__polyspace_uil_max_enumset) && !defined(__polyspace_no_uil_max_enumset)
#include <uil/UilSymGl.h>
#undef uil_max_enumset
  externalref int uil_max_enumset;
#endif

#if defined(__polyspace_uil_max_enumval) && !defined(__polyspace_no_uil_max_enumval)
#include <uil/UilSymGl.h>
#undef uil_max_enumval
  externalref int uil_max_enumval;
#endif

#if defined(__polyspace_uil_enumval_names) && !defined(__polyspace_no_uil_enumval_names)
#include <uil/UilSymGl.h>
#undef uil_enumval_names
  externalref char **uil_enumval_names;
#endif

#if defined(__polyspace_uil_max_charset) && !defined(__polyspace_no_uil_max_charset)
#include <uil/UilSymGl.h>
#undef uil_max_charset
  externalref int uil_max_charset;
#endif

#if defined(__polyspace_uil_charset_names) && !defined(__polyspace_no_uil_charset_names)
#include <uil/UilSymGl.h>
#undef uil_charset_names
  externalref char **uil_charset_names;
#endif

#if defined(__polyspace_related_argument_table) && !defined(__polyspace_no_related_argument_table)
#include <uil/UilSymGl.h>
#undef related_argument_table
  externalref unsigned short int *related_argument_table;
#endif

#if defined(__polyspace_allowed_reason_table) && !defined(__polyspace_no_allowed_reason_table)
#include <uil/UilSymGl.h>
#undef allowed_reason_table
  externalref unsigned char **allowed_reason_table;
#endif

#if defined(__polyspace_tok_token_name_table) && !defined(__polyspace_no_tok_token_name_table)
#include <uil/UilSymGl.h>
#undef tok_token_name_table
  externalref char **tok_token_name_table;
#endif

#if defined(__polyspace_tok_num_tokens) && !defined(__polyspace_no_tok_num_tokens)
#include <uil/UilSymGl.h>
#undef tok_num_tokens
  externalref int tok_num_tokens;
#endif

#if defined(__polyspace_uil_widget_funcs) && !defined(__polyspace_no_uil_widget_funcs)
#include <uil/UilSymGl.h>
#undef uil_widget_funcs
  externalref char **uil_widget_funcs;
#endif

#if defined(__polyspace_uil_gadget_variants) && !defined(__polyspace_no_uil_gadget_variants)
#include <uil/UilSymGl.h>
#undef uil_gadget_variants
  externalref unsigned short int *uil_gadget_variants;
#endif

#if defined(__polyspace_uil_urm_nondialog_class) && !defined(__polyspace_no_uil_urm_nondialog_class)
#include <uil/UilSymGl.h>
#undef uil_urm_nondialog_class
  externalref unsigned short int *uil_urm_nondialog_class;
#endif

#if defined(__polyspace_uil_urm_subtree_resource) && !defined(__polyspace_no_uil_urm_subtree_resource)
#include <uil/UilSymGl.h>
#undef uil_urm_subtree_resource
  externalref unsigned short int *uil_urm_subtree_resource;
#endif

#if defined(__polyspace_uil_argument_toolkit_names) && !defined(__polyspace_no_uil_argument_toolkit_names)
#include <uil/UilSymGl.h>
#undef uil_argument_toolkit_names
  externalref char **uil_argument_toolkit_names;
#endif

#if defined(__polyspace_uil_reason_toolkit_names) && !defined(__polyspace_no_uil_reason_toolkit_names)
#include <uil/UilSymGl.h>
#undef uil_reason_toolkit_names
  externalref char **uil_reason_toolkit_names;
#endif

#if defined(__polyspace_uil_sym_user_defined_object) && !defined(__polyspace_no_uil_sym_user_defined_object)
#include <uil/UilSymGl.h>
#undef uil_sym_user_defined_object
  externalref unsigned short int uil_sym_user_defined_object;
#endif

#if defined(__polyspace_uil_sym_default_charset) && !defined(__polyspace_no_uil_sym_default_charset)
#include <uil/UilSymGl.h>
#undef uil_sym_default_charset
  externalref unsigned short int uil_sym_default_charset;
#endif

#if defined(__polyspace_uil_sym_isolatin1_charset) && !defined(__polyspace_no_uil_sym_isolatin1_charset)
#include <uil/UilSymGl.h>
#undef uil_sym_isolatin1_charset
  externalref unsigned short int uil_sym_isolatin1_charset;
#endif

#if defined(__polyspace_uil_max_value) && !defined(__polyspace_no_uil_max_value)
#include <uil/UilSymGl.h>
#undef uil_max_value
  externalref int uil_max_value;
#endif

#if defined(__polyspace_uil_datatype_names) && !defined(__polyspace_no_uil_datatype_names)
#include <uil/UilSymGl.h>
#undef uil_datatype_names
  externalref char *uil_datatype_names[];
#endif

#if defined(__polyspace_cg6_ops) && !defined(__polyspace_no_cg6_ops)
#include <sys/cg6var.h>
#undef cg6_ops
  extern struct pixrectops cg6_ops;
#endif

#if defined(__polyspace_cg6_rop_table) && !defined(__polyspace_no_cg6_rop_table)
#include <sys/cg6var.h>
#undef cg6_rop_table
  extern uint_t cg6_rop_table[];
#endif

#if defined(__polyspace_dvec) && !defined(__polyspace_no_dvec)
#include <sys/debug/debug.h>
#undef dvec
  extern struct debugvec *dvec;
#endif

#if defined(__polyspace_fpu_exists) && !defined(__polyspace_no_fpu_exists)
#include <sys/fpu/fpusystm.h>
#undef fpu_exists
  extern int fpu_exists;
#endif

#if defined(__polyspace_fpu_version) && !defined(__polyspace_no_fpu_version)
#include <sys/fpu/fpusystm.h>
#undef fpu_version
  extern int fpu_version;
#endif

#if defined(__polyspace_fpdispr) && !defined(__polyspace_no_fpdispr)
#include <sys/fpu/fpusystm.h>
#undef fpdispr
  extern int fpdispr;
#endif

#if defined(__polyspace_fnnode_list) && !defined(__polyspace_no_fnnode_list)
#include <sys/fs/autofs.h>
#undef fnnode_list
  extern fnnode_t *fnnode_list;
#endif

#if defined(__polyspace_fnnode_list_lock) && !defined(__polyspace_no_fnnode_list_lock)
#include <sys/fs/autofs.h>
#undef fnnode_list_lock
  extern kmutex_t fnnode_list_lock;
#endif

#if defined(__polyspace_fnnode_count_lock) && !defined(__polyspace_no_fnnode_count_lock)
#include <sys/fs/autofs.h>
#undef fnnode_count_lock
  extern kmutex_t fnnode_count_lock;
#endif

#if defined(__polyspace_auto_vnodeops) && !defined(__polyspace_no_auto_vnodeops)
#include <sys/fs/autofs.h>
#undef auto_vnodeops
  extern struct vnodeops auto_vnodeops;
#endif

#if defined(__polyspace_cachefs_filegrp_cache) && !defined(__polyspace_no_cachefs_filegrp_cache)
#include <sys/fs/cachefs_filegrp.h>
#undef cachefs_filegrp_cache
  extern struct kmem_cache *cachefs_filegrp_cache;
#endif

#if defined(__polyspace_cachefs_dbvalid) && !defined(__polyspace_no_cachefs_dbvalid)
#include <sys/fs/cachefs_fs.h>
#undef cachefs_dbvalid
  extern time_t cachefs_dbvalid;
#endif

#if defined(__polyspace_cachefs_rl_debug_cache) && !defined(__polyspace_no_cachefs_rl_debug_cache)
#include <sys/fs/cachefs_fs.h>
#undef cachefs_rl_debug_cache
  extern struct kmem_cache *cachefs_rl_debug_cache;
#endif

#if defined(__polyspace_cachefs_rl_debug_mutex) && !defined(__polyspace_no_cachefs_rl_debug_mutex)
#include <sys/fs/cachefs_fs.h>
#undef cachefs_rl_debug_mutex
  extern kmutex_t cachefs_rl_debug_mutex;
#endif

#if defined(__polyspace_cachefs_cache_kmcache) && !defined(__polyspace_no_cachefs_cache_kmcache)
#include <sys/fs/cachefs_fs.h>
#undef cachefs_cache_kmcache
  extern struct kmem_cache *cachefs_cache_kmcache;
#endif

#if defined(__polyspace_cachefs_max_apop_inqueue) && !defined(__polyspace_no_cachefs_max_apop_inqueue)
#include <sys/fs/cachefs_fs.h>
#undef cachefs_max_apop_inqueue
  extern uint_t cachefs_max_apop_inqueue;
#endif

#if defined(__polyspace_cachefs_cnode_cache) && !defined(__polyspace_no_cachefs_cnode_cache)
#include <sys/fs/cachefs_fs.h>
#undef cachefs_cnode_cache
  extern struct kmem_cache *cachefs_cnode_cache;
#endif

#if defined(__polyspace_cachefs_req_cache) && !defined(__polyspace_no_cachefs_req_cache)
#include <sys/fs/cachefs_fs.h>
#undef cachefs_req_cache
  extern struct kmem_cache *cachefs_req_cache;
#endif

#if defined(__polyspace_cachefs_kstat_key) && !defined(__polyspace_no_cachefs_kstat_key)
#include <sys/fs/cachefs_fs.h>
#undef cachefs_kstat_key
  extern cachefs_kstat_key_t *cachefs_kstat_key;
#endif

#if defined(__polyspace_cachefs_kstat_key_n) && !defined(__polyspace_no_cachefs_kstat_key_n)
#include <sys/fs/cachefs_fs.h>
#undef cachefs_kstat_key_n
  extern int cachefs_kstat_key_n;
#endif

#if defined(__polyspace_cachefs_hash_sizes) && !defined(__polyspace_no_cachefs_hash_sizes)
#include <sys/fs/cachefs_fscache.h>
#undef cachefs_hash_sizes
  extern int cachefs_hash_sizes[];
#endif

#if defined(__polyspace_cachefs_fscache_cache) && !defined(__polyspace_no_cachefs_fscache_cache)
#include <sys/fs/cachefs_fscache.h>
#undef cachefs_fscache_cache
  extern struct kmem_cache *cachefs_fscache_cache;
#endif

#if defined(__polyspace_Fifohiwat) && !defined(__polyspace_no_Fifohiwat)
#include <sys/fs/fifonode.h>
#undef Fifohiwat
  extern int Fifohiwat;
#endif

#if defined(__polyspace_fifo_vnodeops) && !defined(__polyspace_no_fifo_vnodeops)
#include <sys/fs/fifonode.h>
#undef fifo_vnodeops
  extern struct vnodeops fifo_vnodeops;
#endif

#if defined(__polyspace_fnode_cache) && !defined(__polyspace_no_fnode_cache)
#include <sys/fs/fifonode.h>
#undef fnode_cache
  extern struct kmem_cache *fnode_cache;
#endif

#if defined(__polyspace_pipe_cache) && !defined(__polyspace_no_pipe_cache)
#include <sys/fs/fifonode.h>
#undef pipe_cache
  extern struct kmem_cache *pipe_cache;
#endif

#if defined(__polyspace_rrip_signature_table) && !defined(__polyspace_no_rrip_signature_table)
#include <sys/fs/hsfs_susp.h>
#undef rrip_signature_table
  extern ext_signature_t rrip_signature_table[];
#endif

#if defined(__polyspace_susp_signature_table) && !defined(__polyspace_no_susp_signature_table)
#include <sys/fs/hsfs_susp.h>
#undef susp_signature_table
  extern ext_signature_t susp_signature_table[];
#endif

#if defined(__polyspace_extension_name_table) && !defined(__polyspace_no_extension_name_table)
#include <sys/fs/hsfs_susp.h>
#undef extension_name_table
  extern extension_name_t extension_name_table[];
#endif

#if defined(__polyspace_susp_sp) && !defined(__polyspace_no_susp_sp)
#include <sys/fs/hsfs_susp.h>
#undef susp_sp
  extern ext_signature_t *susp_sp;
#endif

#if defined(__polyspace_lo_vnodeops) && !defined(__polyspace_no_lo_vnodeops)
#include <sys/fs/lofs_info.h>
#undef lo_vnodeops
  extern struct vnodeops lo_vnodeops;
#endif

#if defined(__polyspace_lofs_ltable_lock) && !defined(__polyspace_no_lofs_ltable_lock)
#include <sys/fs/lofs_info.h>
#undef lofs_ltable_lock
  extern kmutex_t lofs_ltable_lock;
#endif

#if defined(__polyspace_lofs_minor_lock) && !defined(__polyspace_no_lofs_minor_lock)
#include <sys/fs/lofs_info.h>
#undef lofs_minor_lock
  extern kmutex_t lofs_minor_lock;
#endif

#if defined(__polyspace_lo_vfsops) && !defined(__polyspace_no_lo_vfsops)
#include <sys/fs/lofs_info.h>
#undef lo_vfsops
  extern struct vfsops lo_vfsops;
#endif

#if defined(__polyspace_mod_fsops) && !defined(__polyspace_no_mod_fsops)
#include <sys/fs/lofs_info.h>
#undef mod_fsops
  extern struct mod_ops mod_fsops;
#endif

#if defined(__polyspace_lofs_major) && !defined(__polyspace_no_lofs_major)
#include <sys/fs/lofs_info.h>
#undef lofs_major
  extern major_t lofs_major;
#endif

#if defined(__polyspace_lofs_minor) && !defined(__polyspace_no_lofs_minor)
#include <sys/fs/lofs_info.h>
#undef lofs_minor
  extern minor_t lofs_minor;
#endif

#if defined(__polyspace_kvp) && !defined(__polyspace_no_kvp)
#include <sys/fs/lofs_node.h>
#undef kvp
  extern struct vnode kvp;
#endif

#if defined(__polyspace_nm_filevp_hash) && !defined(__polyspace_no_nm_filevp_hash)
#include <sys/fs/namenode.h>
#undef nm_filevp_hash
  extern struct namenode *nm_filevp_hash[NM_FILEVP_HASH_SIZE];
#endif

#if defined(__polyspace_namevfs) && !defined(__polyspace_no_namevfs)
#include <sys/fs/namenode.h>
#undef namevfs
  extern struct vfs namevfs;
#endif

#if defined(__polyspace_nm_vnodeops) && !defined(__polyspace_no_nm_vnodeops)
#include <sys/fs/namenode.h>
#undef nm_vnodeops
  extern struct vnodeops nm_vnodeops;
#endif

#if defined(__polyspace_ntable_lock) && !defined(__polyspace_no_ntable_lock)
#include <sys/fs/namenode.h>
#undef ntable_lock
  extern kmutex_t ntable_lock;
#endif

#if defined(__polyspace_enable_long_filenames) && !defined(__polyspace_no_enable_long_filenames)
#include <sys/fs/pc_dir.h>
#undef enable_long_filenames
  extern int enable_long_filenames;
#endif

#if defined(__polyspace_pcfsdebuglevel) && !defined(__polyspace_no_pcfsdebuglevel)
#include <sys/fs/pc_fs.h>
#undef pcfsdebuglevel
  extern int pcfsdebuglevel;
#endif

#if defined(__polyspace_pcfs_fvnodeops) && !defined(__polyspace_no_pcfs_fvnodeops)
#include <sys/fs/pc_node.h>
#undef pcfs_fvnodeops
  extern struct vnodeops pcfs_fvnodeops;
#endif

#if defined(__polyspace_pcfs_dvnodeops) && !defined(__polyspace_no_pcfs_dvnodeops)
#include <sys/fs/pc_node.h>
#undef pcfs_dvnodeops
  extern struct vnodeops pcfs_dvnodeops;
#endif

#if defined(__polyspace_pcfhead) && !defined(__polyspace_no_pcfhead)
#include <sys/fs/pc_node.h>
#undef pcfhead
  extern struct pchead pcfhead[];
#endif

#if defined(__polyspace_pcdhead) && !defined(__polyspace_no_pcdhead)
#include <sys/fs/pc_node.h>
#undef pcdhead
  extern struct pchead pcdhead[];
#endif

#if defined(__polyspace_spec_vfsops) && !defined(__polyspace_no_spec_vfsops)
#include <sys/fs/snode.h>
#undef spec_vfsops
  extern struct vfsops spec_vfsops;
#endif

#if defined(__polyspace_snode_cache) && !defined(__polyspace_no_snode_cache)
#include <sys/fs/snode.h>
#undef snode_cache
  extern struct kmem_cache *snode_cache;
#endif

#if defined(__polyspace_stable) && !defined(__polyspace_no_stable)
#include <sys/fs/snode.h>
#undef stable
  extern struct snode *stable[];
#endif

#if defined(__polyspace_stable_lock) && !defined(__polyspace_no_stable_lock)
#include <sys/fs/snode.h>
#undef stable_lock
  extern kmutex_t stable_lock;
#endif

#if defined(__polyspace_spec_syncbusy) && !defined(__polyspace_no_spec_syncbusy)
#include <sys/fs/snode.h>
#undef spec_syncbusy
  extern kmutex_t spec_syncbusy;
#endif

#if defined(__polyspace_spec_async_reqs) && !defined(__polyspace_no_spec_async_reqs)
#include <sys/fs/snode.h>
#undef spec_async_reqs
  extern struct async_reqs *spec_async_reqs;
#endif

#if defined(__polyspace_spec_async_lock) && !defined(__polyspace_no_spec_async_lock)
#include <sys/fs/snode.h>
#undef spec_async_lock
  extern kmutex_t spec_async_lock;
#endif

#if defined(__polyspace_tmpfs_minfree) && !defined(__polyspace_no_tmpfs_minfree)
#include <sys/fs/tmp.h>
#undef tmpfs_minfree
  extern long tmpfs_minfree;
#endif

#if defined(__polyspace_tmp_kmemspace) && !defined(__polyspace_no_tmp_kmemspace)
#include <sys/fs/tmp.h>
#undef tmp_kmemspace
  extern size_t tmp_kmemspace;
#endif

#if defined(__polyspace_tmpfs_maxkmem) && !defined(__polyspace_no_tmpfs_maxkmem)
#include <sys/fs/tmp.h>
#undef tmpfs_maxkmem
  extern size_t tmpfs_maxkmem;
#endif

#if defined(__polyspace_swapfs_minfree) && !defined(__polyspace_no_swapfs_minfree)
#include <sys/fs/swapnode.h>
#undef swapfs_minfree
  extern pgcnt_t swapfs_minfree;
#endif

#if defined(__polyspace_swapfs_desfree) && !defined(__polyspace_no_swapfs_desfree)
#include <sys/fs/swapnode.h>
#undef swapfs_desfree
  extern pgcnt_t swapfs_desfree;
#endif

#if defined(__polyspace_swapfs_reserve) && !defined(__polyspace_no_swapfs_reserve)
#include <sys/fs/swapnode.h>
#undef swapfs_reserve
  extern pgcnt_t swapfs_reserve;
#endif

#if defined(__polyspace_swap_vnodeops) && !defined(__polyspace_no_swap_vnodeops)
#include <sys/fs/swapnode.h>
#undef swap_vnodeops
  extern struct vnodeops swap_vnodeops;
#endif

#if defined(__polyspace_swap_vfsops) && !defined(__polyspace_no_swap_vfsops)
#include <sys/fs/swapnode.h>
#undef swap_vfsops
  extern struct vfsops swap_vfsops;
#endif

#if defined(__polyspace_swapfs_debug) && !defined(__polyspace_no_swapfs_debug)
#include <sys/fs/swapnode.h>
#undef swapfs_debug
  extern int swapfs_debug;
#endif

#if defined(__polyspace_tmp_vnodeops) && !defined(__polyspace_no_tmp_vnodeops)
#include <sys/fs/tmpnode.h>
#undef tmp_vnodeops
  extern struct vnodeops tmp_vnodeops;
#endif

#if defined(__polyspace_ub) && !defined(__polyspace_no_ub)
#include <sys/fs/ufs_bio.h>
#undef ub
  extern struct ufsbiostats ub;
#endif

#if defined(__polyspace_ufs_ninode) && !defined(__polyspace_no_ufs_ninode)
#include <sys/fs/ufs_inode.h>
#undef ufs_ninode
  extern int ufs_ninode;
#endif

#if defined(__polyspace_ufs_vnodeops) && !defined(__polyspace_no_ufs_vnodeops)
#include <sys/fs/ufs_inode.h>
#undef ufs_vnodeops
  extern struct vnodeops ufs_vnodeops;
#endif

#if defined(__polyspace_iftovt_tab) && !defined(__polyspace_no_iftovt_tab)
#include <sys/fs/ufs_inode.h>
#undef iftovt_tab
  extern enum vtype iftovt_tab[];
#endif

#if defined(__polyspace_vttoif_tab) && !defined(__polyspace_no_vttoif_tab)
#include <sys/fs/ufs_inode.h>
#undef vttoif_tab
  extern int vttoif_tab[];
#endif

#if defined(__polyspace_ufs_idle_q) && !defined(__polyspace_no_ufs_idle_q)
#include <sys/fs/ufs_inode.h>
#undef ufs_idle_q
  extern struct ufs_q ufs_idle_q;
#endif

#if defined(__polyspace_ufs_hlock) && !defined(__polyspace_no_ufs_hlock)
#include <sys/fs/ufs_inode.h>
#undef ufs_hlock
  extern struct ufs_q ufs_hlock;
#endif

#if defined(__polyspace_ihead) && !defined(__polyspace_no_ihead)
#include <sys/fs/ufs_inode.h>
#undef ihead
  extern union ihead *ihead;
#endif

#if defined(__polyspace_ih_lock) && !defined(__polyspace_no_ih_lock)
#include <sys/fs/ufs_inode.h>
#undef ih_lock
  extern kmutex_t *ih_lock;
#endif

#if defined(__polyspace_ih_ne) && !defined(__polyspace_no_ih_ne)
#include <sys/fs/ufs_inode.h>
#undef ih_ne
  extern int *ih_ne;
#endif

#if defined(__polyspace_inohsz) && !defined(__polyspace_no_inohsz)
#include <sys/fs/ufs_inode.h>
#undef inohsz
  extern int inohsz;
#endif

#if defined(__polyspace_lufsops) && !defined(__polyspace_no_lufsops)
#include <sys/fs/ufs_log.h>
#undef lufsops
  extern lufsops_t lufsops;
#endif

#if defined(__polyspace_ufs_fix) && !defined(__polyspace_no_ufs_fix)
#include <sys/fs/ufs_panic.h>
#undef ufs_fix
  extern struct ufs_q ufs_fix;
#endif

#if defined(__polyspace_dqhead) && !defined(__polyspace_no_dqhead)
#include <sys/fs/ufs_quota.h>
#undef dqhead
  extern struct dqhead dqhead[NDQHASH];
#endif

#if defined(__polyspace_ndquot) && !defined(__polyspace_no_ndquot)
#include <sys/fs/ufs_quota.h>
#undef ndquot
  extern int ndquot;
#endif

#if defined(__polyspace_dq_rwlock) && !defined(__polyspace_no_dq_rwlock)
#include <sys/fs/ufs_quota.h>
#undef dq_rwlock
  extern krwlock_t dq_rwlock;
#endif

#if defined(__polyspace_quotas_initialized) && !defined(__polyspace_no_quotas_initialized)
#include <sys/fs/ufs_quota.h>
#undef quotas_initialized
  extern int quotas_initialized;
#endif

#if defined(__polyspace_prnwatch) && !defined(__polyspace_no_prnwatch)
#include <sys/proc/prdata.h>
#undef prnwatch
  extern int prnwatch;
#endif

#if defined(__polyspace_nproc_highbit) && !defined(__polyspace_no_nproc_highbit)
#include <sys/proc/prdata.h>
#undef nproc_highbit
  extern int nproc_highbit;
#endif

#if defined(__polyspace_prvnodeops) && !defined(__polyspace_no_prvnodeops)
#include <sys/proc/prdata.h>
#undef prvnodeops
  extern struct vnodeops prvnodeops;
#endif

#if defined(__polyspace_scsi_watchdog_tick) && !defined(__polyspace_no_scsi_watchdog_tick)
#include <sys/scsi/conf/autoconf.h>
#undef scsi_watchdog_tick
  extern int scsi_watchdog_tick;
#endif

#if defined(__polyspace_scsi_options) && !defined(__polyspace_no_scsi_options)
#include <sys/scsi/conf/autoconf.h>
#undef scsi_options
  extern int scsi_options;
#endif

#if defined(__polyspace_scsi_reset_delay) && !defined(__polyspace_no_scsi_reset_delay)
#include <sys/scsi/conf/autoconf.h>
#undef scsi_reset_delay
  extern unsigned int scsi_reset_delay;
#endif

#if defined(__polyspace_scsi_state_bits) && !defined(__polyspace_no_scsi_state_bits)
#include <sys/scsi/impl/services.h>
#undef scsi_state_bits
  extern char *scsi_state_bits;
#endif

#if defined(__polyspace_ses_debug) && !defined(__polyspace_no_ses_debug)
#include <sys/scsi/targets/ses.h>
#undef ses_debug
  extern int ses_debug;
#endif

#if defined(__polyspace_ses_io_time) && !defined(__polyspace_no_ses_io_time)
#include <sys/scsi/targets/ses.h>
#undef ses_io_time
  extern int ses_io_time;
#endif

#if defined(__polyspace_ses_max_retry_count) && !defined(__polyspace_no_ses_max_retry_count)
#include <sys/scsi/targets/ses.h>
#undef ses_max_retry_count
  extern int ses_max_retry_count;
#endif

#if defined(__polyspace_shm_alignment) && !defined(__polyspace_no_shm_alignment)
#include <sys/archsystm.h>
#undef shm_alignment
  extern uintptr_t shm_alignment;
#endif

#if defined(__polyspace_enable_mixed_bcp) && !defined(__polyspace_no_enable_mixed_bcp)
#include <sys/archsystm.h>
#undef enable_mixed_bcp
  extern int enable_mixed_bcp;
#endif

#if defined(__polyspace_auxv_hwcap) && !defined(__polyspace_no_auxv_hwcap)
#include <sys/auxv.h>
#undef auxv_hwcap
  extern int auxv_hwcap;
#endif

#if defined(__polyspace_kauxv_hwcap) && !defined(__polyspace_no_kauxv_hwcap)
#include <sys/auxv.h>
#undef kauxv_hwcap
  extern int kauxv_hwcap;
#endif

#if defined(__polyspace_audio_4231_apcdma_ops) && !defined(__polyspace_no_audio_4231_apcdma_ops)
#include <sys/audio_4231.h>
#undef audio_4231_apcdma_ops
  extern ops_t audio_4231_apcdma_ops;
#endif

#if defined(__polyspace_audio_4231_eb2dma_ops) && !defined(__polyspace_no_audio_4231_eb2dma_ops)
#include <sys/audio_4231.h>
#undef audio_4231_eb2dma_ops
  extern ops_t audio_4231_eb2dma_ops;
#endif

#if defined(__polyspace_audio_4231_8237dma_ops) && !defined(__polyspace_no_audio_4231_8237dma_ops)
#include <sys/audio_4231.h>
#undef audio_4231_8237dma_ops
  extern ops_t audio_4231_8237dma_ops;
#endif

#if defined(__polyspace_aud_apcdma_attr) && !defined(__polyspace_no_aud_apcdma_attr)
#include <sys/audio_4231.h>
#undef aud_apcdma_attr
  extern ddi_dma_attr_t aud_apcdma_attr;
#endif

#if defined(__polyspace_aud_eb2dma_attr) && !defined(__polyspace_no_aud_eb2dma_attr)
#include <sys/audio_4231.h>
#undef aud_eb2dma_attr
  extern ddi_dma_attr_t aud_eb2dma_attr;
#endif

#if defined(__polyspace_aud_8237dma_attr) && !defined(__polyspace_no_aud_8237dma_attr)
#include <sys/audio_4231.h>
#undef aud_8237dma_attr
  extern ddi_dma_attr_t aud_8237dma_attr;
#endif

#if defined(__polyspace_audiotrace_buffer) && !defined(__polyspace_no_audiotrace_buffer)
#include <sys/audiodebug.h>
#undef audiotrace_buffer
  extern struct audiotrace audiotrace_buffer[];
#endif

#if defined(__polyspace_audiotrace_ptr) && !defined(__polyspace_no_audiotrace_ptr)
#include <sys/audiodebug.h>
#undef audiotrace_ptr
  extern struct audiotrace *audiotrace_ptr;
#endif

#if defined(__polyspace_audiotrace_count) && !defined(__polyspace_no_audiotrace_count)
#include <sys/audiodebug.h>
#undef audiotrace_count
  extern int audiotrace_count;
#endif

#if defined(__polyspace_devnamesp) && !defined(__polyspace_no_devnamesp)
#include <sys/autoconf.h>
#undef devnamesp
  extern struct devnames *devnamesp;
#endif

#if defined(__polyspace_orphanlist) && !defined(__polyspace_no_orphanlist)
#include <sys/autoconf.h>
#undef orphanlist
  extern struct devnames orphanlist;
#endif

#if defined(__polyspace_nullstr) && !defined(__polyspace_no_nullstr)
#include <sys/autoconf.h>
#undef nullstr
  extern char *nullstr;
#endif

#if defined(__polyspace_nodev_ops) && !defined(__polyspace_no_nodev_ops)
#include <sys/autoconf.h>
#undef nodev_ops
  extern struct dev_ops nodev_ops;
#endif

#if defined(__polyspace_mod_nodev_ops) && !defined(__polyspace_no_mod_nodev_ops)
#include <sys/autoconf.h>
#undef mod_nodev_ops
  extern struct dev_ops mod_nodev_ops;
#endif

#if defined(__polyspace_devinfo_tree_lock) && !defined(__polyspace_no_devinfo_tree_lock)
#include <sys/autoconf.h>
#undef devinfo_tree_lock
  extern krwlock_t devinfo_tree_lock;
#endif

#if defined(__polyspace_top_devinfo) && !defined(__polyspace_no_top_devinfo)
#include <sys/autoconf.h>
#undef top_devinfo
  extern dev_info_t *top_devinfo;
#endif

#if defined(__polyspace_configdebug) && !defined(__polyspace_no_configdebug)
#include <sys/autoconf.h>
#undef configdebug
  extern int configdebug;
#endif

#if defined(__polyspace_maxautovec) && !defined(__polyspace_no_maxautovec)
#include <sys/avintr.h>
#undef maxautovec
  extern const uint_t maxautovec;
#endif

#if defined(__polyspace_vectorlist) && !defined(__polyspace_no_vectorlist)
#include <sys/avintr.h>
#undef vectorlist
  extern struct autovec * const vectorlist[];
#endif

#if defined(__polyspace_av_lock) && !defined(__polyspace_no_av_lock)
#include <sys/avintr.h>
#undef av_lock
  extern kmutex_t av_lock;
#endif

#if defined(__polyspace_rootfs) && !defined(__polyspace_no_rootfs)
#include <sys/bootconf.h>
#undef rootfs
  extern struct bootobj rootfs;
#endif

#if defined(__polyspace_frontfs) && !defined(__polyspace_no_frontfs)
#include <sys/bootconf.h>
#undef frontfs
  extern struct bootobj frontfs;
#endif

#if defined(__polyspace_backfs) && !defined(__polyspace_no_backfs)
#include <sys/bootconf.h>
#undef backfs
  extern struct bootobj backfs;
#endif

#if defined(__polyspace_swapfile) && !defined(__polyspace_no_swapfile)
#include <sys/bootconf.h>
#undef swapfile
  extern struct bootobj swapfile;
#endif

#if defined(__polyspace_bootops) && !defined(__polyspace_no_bootops)
#include <sys/bootconf.h>
#undef bootops
  extern struct bootops *bootops;
#endif

#if defined(__polyspace_phys_install) && !defined(__polyspace_no_phys_install)
#include <sys/bootconf.h>
#undef phys_install
  extern struct memlist *phys_install;
#endif

#if defined(__polyspace_netboot) && !defined(__polyspace_no_netboot)
#include <sys/bootconf.h>
#undef netboot
  extern int netboot;
#endif

#if defined(__polyspace_swaploaded) && !defined(__polyspace_no_swaploaded)
#include <sys/bootconf.h>
#undef swaploaded
  extern int swaploaded;
#endif

#if defined(__polyspace_modrootloaded) && !defined(__polyspace_no_modrootloaded)
#include <sys/bootconf.h>
#undef modrootloaded
  extern int modrootloaded;
#endif

#if defined(__polyspace_kern_bootargs) && !defined(__polyspace_no_kern_bootargs)
#include <sys/bootconf.h>
#undef kern_bootargs
  extern char kern_bootargs[];
#endif

#if defined(__polyspace_default_path) && !defined(__polyspace_no_default_path)
#include <sys/bootconf.h>
#undef default_path
  extern char *default_path;
#endif

#if defined(__polyspace_hbuf) && !defined(__polyspace_no_hbuf)
#include <sys/buf.h>
#undef hbuf
  extern struct hbuf *hbuf;
#endif

#if defined(__polyspace_dwbuf) && !defined(__polyspace_no_dwbuf)
#include <sys/buf.h>
#undef dwbuf
  extern struct dwbuf *dwbuf;
#endif

#if defined(__polyspace_buf) && !defined(__polyspace_no_buf)
#include <sys/buf.h>
#undef buf
  extern struct buf *buf;
#endif

#if defined(__polyspace_bfreelist) && !defined(__polyspace_no_bfreelist)
#include <sys/buf.h>
#undef bfreelist
  extern struct buf bfreelist;
#endif

#if defined(__polyspace_callb_cprinfo_safe) && !defined(__polyspace_no_callb_cprinfo_safe)
#include <sys/callb.h>
#undef callb_cprinfo_safe
  extern callb_cpr_t callb_cprinfo_safe;
#endif

#if defined(__polyspace_maxclsyspri) && !defined(__polyspace_no_maxclsyspri)
#include <sys/callo.h>
#undef maxclsyspri
  extern pri_t maxclsyspri;
#endif

#if defined(__polyspace_mainstore) && !defined(__polyspace_no_mainstore)
#include <sys/cdump.h>
#undef mainstore
  extern int mainstore;
#endif

#if defined(__polyspace_sizofmem) && !defined(__polyspace_no_sizofmem)
#include <sys/cdump.h>
#undef sizofmem
  extern int sizofmem;
#endif

#if defined(__polyspace_cg3_ops) && !defined(__polyspace_no_cg3_ops)
#include <sys/cg3var.h>
#undef cg3_ops
  extern struct pixrectops cg3_ops;
#endif

#if defined(__polyspace_nclass) && !defined(__polyspace_no_nclass)
#include <sys/class.h>
#undef nclass
  extern int nclass;
#endif

#if defined(__polyspace_initclass) && !defined(__polyspace_no_initclass)
#include <sys/class.h>
#undef initclass
  extern char *initclass;
#endif

#if defined(__polyspace_defaultclass) && !defined(__polyspace_no_defaultclass)
#include <sys/class.h>
#undef defaultclass
  extern char *defaultclass;
#endif

#if defined(__polyspace_extraclass) && !defined(__polyspace_no_extraclass)
#include <sys/class.h>
#undef extraclass
  extern char *extraclass;
#endif

#if defined(__polyspace_sclass) && !defined(__polyspace_no_sclass)
#include <sys/class.h>
#undef sclass
  extern struct sclass sclass[];
#endif

#if defined(__polyspace_post_consoleconfig) && !defined(__polyspace_no_post_consoleconfig)
#include <sys/cmn_err.h>
#undef post_consoleconfig
  extern int post_consoleconfig;
#endif

#if defined(__polyspace_romp) && !defined(__polyspace_no_romp)
#include <sys/comvec.h>
#undef romp
  extern union sunromvec *romp;
#endif

#if defined(__polyspace_fmodsw_lock) && !defined(__polyspace_no_fmodsw_lock)
#include <sys/conf.h>
#undef fmodsw_lock
  extern kmutex_t fmodsw_lock;
#endif

#if defined(__polyspace_fmodsw) && !defined(__polyspace_no_fmodsw)
#include <sys/conf.h>
#undef fmodsw
  extern fmodsw_impl_t fmodsw[];
#endif

#if defined(__polyspace_devcnt) && !defined(__polyspace_no_devcnt)
#include <sys/conf.h>
#undef devcnt
  extern int devcnt;
#endif

#if defined(__polyspace_fmodcnt) && !defined(__polyspace_no_fmodcnt)
#include <sys/conf.h>
#undef fmodcnt
  extern int fmodcnt;
#endif

#if defined(__polyspace_linesw) && !defined(__polyspace_no_linesw)
#include <sys/conf.h>
#undef linesw
  extern struct linesw linesw[];
#endif

#if defined(__polyspace_linecnt) && !defined(__polyspace_no_linecnt)
#include <sys/conf.h>
#undef linecnt
  extern int linecnt;
#endif

#if defined(__polyspace_termsw) && !defined(__polyspace_no_termsw)
#include <sys/conf.h>
#undef termsw
  extern struct termsw termsw[];
#endif

#if defined(__polyspace_termcnt) && !defined(__polyspace_no_termcnt)
#include <sys/conf.h>
#undef termcnt
  extern int termcnt;
#endif

#if defined(__polyspace_rconsvp) && !defined(__polyspace_no_rconsvp)
#include <sys/consdev.h>
#undef rconsvp
  extern struct vnode *rconsvp;
#endif

#if defined(__polyspace_mousedev) && !defined(__polyspace_no_mousedev)
#include <sys/consdev.h>
#undef mousedev
  extern dev_t mousedev;
#endif

#if defined(__polyspace_kbddev) && !defined(__polyspace_no_kbddev)
#include <sys/consdev.h>
#undef kbddev
  extern dev_t kbddev;
#endif

#if defined(__polyspace_stdindev) && !defined(__polyspace_no_stdindev)
#include <sys/consdev.h>
#undef stdindev
  extern dev_t stdindev;
#endif

#if defined(__polyspace_fbdev) && !defined(__polyspace_no_fbdev)
#include <sys/consdev.h>
#undef fbdev
  extern dev_t fbdev;
#endif

#if defined(__polyspace_fbvp) && !defined(__polyspace_no_fbvp)
#include <sys/consdev.h>
#undef fbvp
  extern struct vnode *fbvp;
#endif

#if defined(__polyspace_wsconsvp) && !defined(__polyspace_no_wsconsvp)
#include <sys/consdev.h>
#undef wsconsvp
  extern struct vnode *wsconsvp;
#endif

#if defined(__polyspace_rwsconsvp) && !defined(__polyspace_no_rwsconsvp)
#include <sys/consdev.h>
#undef rwsconsvp
  extern struct vnode *rwsconsvp;
#endif

#if defined(__polyspace_cn_conf) && !defined(__polyspace_no_cn_conf)
#include <sys/consdev.h>
#undef cn_conf
  extern int cn_conf;
#endif

#if defined(__polyspace_default_copyops) && !defined(__polyspace_no_default_copyops)
#include <sys/copyops.h>
#undef default_copyops
  extern struct copyops default_copyops;
#endif

#if defined(__polyspace_cpr_debug) && !defined(__polyspace_no_cpr_debug)
#include <sys/cpr.h>
#undef cpr_debug
  extern int cpr_debug;
#endif

#if defined(__polyspace_cpr_state) && !defined(__polyspace_no_cpr_state)
#include <sys/cpr.h>
#undef cpr_state
  extern cpr_t cpr_state;
#endif

#if defined(__polyspace_wholecycle_tv) && !defined(__polyspace_no_wholecycle_tv)
#include <sys/cpr.h>
#undef wholecycle_tv
  extern cpr_time_t wholecycle_tv;
#endif

#if defined(__polyspace_cpr_reusable_mode) && !defined(__polyspace_no_cpr_reusable_mode)
#include <sys/cpr.h>
#undef cpr_reusable_mode
  extern int cpr_reusable_mode;
#endif

#if defined(__polyspace_dvmasize) && !defined(__polyspace_no_dvmasize)
#include <sys/cpu.h>
#undef dvmasize
  extern int dvmasize;
#endif

#if defined(__polyspace_cache) && !defined(__polyspace_no_cache)
#include <sys/cpu.h>
#undef cache
  extern int cache;
#endif

#if defined(__polyspace_vac) && !defined(__polyspace_no_vac)
#include <sys/cpu.h>
#undef vac
  extern int vac;
#endif

#if defined(__polyspace_ioc) && !defined(__polyspace_no_ioc)
#include <sys/cpu.h>
#undef ioc
  extern int ioc;
#endif

#if defined(__polyspace_bcopy_buf) && !defined(__polyspace_no_bcopy_buf)
#include <sys/cpu.h>
#undef bcopy_buf
  extern int bcopy_buf;
#endif

#if defined(__polyspace_cp_default) && !defined(__polyspace_no_cp_default)
#include <sys/cpupart.h>
#undef cp_default
  extern cpupart_t cp_default;
#endif

#if defined(__polyspace_cp_list_head) && !defined(__polyspace_no_cp_list_head)
#include <sys/cpupart.h>
#undef cp_list_head
  extern cpupart_t *cp_list_head;
#endif

#if defined(__polyspace_cp_list_lock) && !defined(__polyspace_no_cp_list_lock)
#include <sys/cpupart.h>
#undef cp_list_lock
  extern kmutex_t cp_list_lock;
#endif

#if defined(__polyspace_num_partitions) && !defined(__polyspace_no_num_partitions)
#include <sys/cpupart.h>
#undef num_partitions
  extern int num_partitions;
#endif

#if defined(__polyspace_cpu) && !defined(__polyspace_no_cpu)
#include <sys/cpuvar.h>
#undef cpu
  extern struct cpu *cpu[];
#endif

#if defined(__polyspace_cpu_list) && !defined(__polyspace_no_cpu_list)
#include <sys/cpuvar.h>
#undef cpu_list
  extern cpu_t *cpu_list;
#endif

#if defined(__polyspace_ncpus) && !defined(__polyspace_no_ncpus)
#include <sys/cpuvar.h>
#undef ncpus
  extern int ncpus;
#endif

#if defined(__polyspace_ncpus_online) && !defined(__polyspace_no_ncpus_online)
#include <sys/cpuvar.h>
#undef ncpus_online
  extern int ncpus_online;
#endif

#if defined(__polyspace_max_ncpus) && !defined(__polyspace_no_max_ncpus)
#include <sys/cpuvar.h>
#undef max_ncpus
  extern int max_ncpus;
#endif

#if defined(__polyspace_cpu_lock) && !defined(__polyspace_no_cpu_lock)
#include <sys/cpuvar.h>
#undef cpu_lock
  extern kmutex_t cpu_lock;
#endif

#if defined(__polyspace_ngroups_max) && !defined(__polyspace_no_ngroups_max)
#include <sys/cred.h>
#undef ngroups_max
  extern int ngroups_max;
#endif

#if defined(__polyspace_kcred) && !defined(__polyspace_no_kcred)
#include <sys/cred.h>
#undef kcred
  extern struct cred *kcred;
#endif

#if defined(__polyspace_cs_socket_services) && !defined(__polyspace_no_cs_socket_services)
#include <sys/cs_priv.h>
#undef cs_socket_services
  extern csfunction_t *cs_socket_services;
#endif

#if defined(__polyspace_dbri_dma_limits) && !defined(__polyspace_no_dbri_dma_limits)
#include <sys/dbrivar.h>
#undef dbri_dma_limits
  extern ddi_dma_lim_t dbri_dma_limits;
#endif

#if defined(__polyspace_kas) && !defined(__polyspace_no_kas)
#include <sys/dbrivar.h>
#undef kas
  extern struct as kas;
#endif

#if defined(__polyspace_Dbri_nstreams) && !defined(__polyspace_no_Dbri_nstreams)
#include <sys/dbrivar.h>
#undef Dbri_nstreams
  extern int Dbri_nstreams;
#endif

#if defined(__polyspace_Default_DBRI_nbf) && !defined(__polyspace_no_Default_DBRI_nbf)
#include <sys/dbrivar.h>
#undef Default_DBRI_nbf
  extern int Default_DBRI_nbf;
#endif

#if defined(__polyspace_Default_DBRI_f) && !defined(__polyspace_no_Default_DBRI_f)
#include <sys/dbrivar.h>
#undef Default_DBRI_f
  extern int Default_DBRI_f;
#endif

#if defined(__polyspace_Default_T101_timer) && !defined(__polyspace_no_Default_T101_timer)
#include <sys/dbrivar.h>
#undef Default_T101_timer
  extern int Default_T101_timer;
#endif

#if defined(__polyspace_Default_T102_timer) && !defined(__polyspace_no_Default_T102_timer)
#include <sys/dbrivar.h>
#undef Default_T102_timer
  extern int Default_T102_timer;
#endif

#if defined(__polyspace_Default_T103_timer) && !defined(__polyspace_no_Default_T103_timer)
#include <sys/dbrivar.h>
#undef Default_T103_timer
  extern int Default_T103_timer;
#endif

#if defined(__polyspace_Default_T104_timer) && !defined(__polyspace_no_Default_T104_timer)
#include <sys/dbrivar.h>
#undef Default_T104_timer
  extern int Default_T104_timer;
#endif

#if defined(__polyspace_Default_asmb) && !defined(__polyspace_no_Default_asmb)
#include <sys/dbrivar.h>
#undef Default_asmb
  extern enum isdn_param_asmb Default_asmb;
#endif

#if defined(__polyspace_Default_power) && !defined(__polyspace_no_Default_power)
#include <sys/dbrivar.h>
#undef Default_power
  extern int Default_power;
#endif

#if defined(__polyspace_Keepalive_timer) && !defined(__polyspace_no_Keepalive_timer)
#include <sys/dbrivar.h>
#undef Keepalive_timer
  extern int Keepalive_timer;
#endif

#if defined(__polyspace_Dbri_panic) && !defined(__polyspace_no_Dbri_panic)
#include <sys/dbrivar.h>
#undef Dbri_panic
  extern boolean_t Dbri_panic;
#endif

#if defined(__polyspace_Dbri_state) && !defined(__polyspace_no_Dbri_state)
#include <sys/dbrivar.h>
#undef Dbri_state
  extern void *Dbri_state;
#endif

#if defined(__polyspace_Dbri_keepcnt) && !defined(__polyspace_no_Dbri_keepcnt)
#include <sys/dbrivar.h>
#undef Dbri_keepcnt
  extern int Dbri_keepcnt;
#endif

#if defined(__polyspace_nswapped) && !defined(__polyspace_no_nswapped)
#include <sys/disp.h>
#undef nswapped
  extern int nswapped;
#endif

#if defined(__polyspace_minclsyspri) && !defined(__polyspace_no_minclsyspri)
#include <sys/disp.h>
#undef minclsyspri
  extern pri_t minclsyspri;
#endif

#if defined(__polyspace_kpreemptpri) && !defined(__polyspace_no_kpreemptpri)
#include <sys/disp.h>
#undef kpreemptpri
  extern pri_t kpreemptpri;
#endif

#if defined(__polyspace_lzero) && !defined(__polyspace_no_lzero)
#include <sys/dl.h>
#undef lzero
  extern dl_t lzero;
#endif

#if defined(__polyspace_lone) && !defined(__polyspace_no_lone)
#include <sys/dl.h>
#undef lone
  extern dl_t lone;
#endif

#if defined(__polyspace_lten) && !defined(__polyspace_no_lten)
#include <sys/dl.h>
#undef lten
  extern dl_t lten;
#endif

#if defined(__polyspace_ncsize) && !defined(__polyspace_no_ncsize)
#include <sys/dnlc.h>
#undef ncsize
  extern int ncsize;
#endif

#if defined(__polyspace_door_knob) && !defined(__polyspace_no_door_knob)
#include <sys/door.h>
#undef door_knob
  extern kmutex_t door_knob;
#endif

#if defined(__polyspace_door_cv) && !defined(__polyspace_no_door_cv)
#include <sys/door.h>
#undef door_cv
  extern kcondvar_t door_cv;
#endif

#if defined(__polyspace_door_max_arg) && !defined(__polyspace_no_door_max_arg)
#include <sys/door.h>
#undef door_max_arg
  extern size_t door_max_arg;
#endif

#if defined(__polyspace_dump_lock) && !defined(__polyspace_no_dump_lock)
#include <sys/dumphdr.h>
#undef dump_lock
  extern kmutex_t dump_lock;
#endif

#if defined(__polyspace_dumpvp) && !defined(__polyspace_no_dumpvp)
#include <sys/dumphdr.h>
#undef dumpvp
  extern struct vnode *dumpvp;
#endif

#if defined(__polyspace_dumpvp_size) && !defined(__polyspace_no_dumpvp_size)
#include <sys/dumphdr.h>
#undef dumpvp_size
  extern u_offset_t dumpvp_size;
#endif

#if defined(__polyspace_dumphdr) && !defined(__polyspace_no_dumphdr)
#include <sys/dumphdr.h>
#undef dumphdr
  extern struct dumphdr *dumphdr;
#endif

#if defined(__polyspace_dump_conflags) && !defined(__polyspace_no_dump_conflags)
#include <sys/dumphdr.h>
#undef dump_conflags
  extern int dump_conflags;
#endif

#if defined(__polyspace_dumppath) && !defined(__polyspace_no_dumppath)
#include <sys/dumphdr.h>
#undef dumppath
  extern char *dumppath;
#endif

#if defined(__polyspace_dump_timeleft) && !defined(__polyspace_no_dump_timeleft)
#include <sys/dumphdr.h>
#undef dump_timeleft
  extern int dump_timeleft;
#endif

#if defined(__polyspace_sync_timeleft) && !defined(__polyspace_no_sync_timeleft)
#include <sys/dumphdr.h>
#undef sync_timeleft
  extern int sync_timeleft;
#endif

#if defined(__polyspace_in_sync) && !defined(__polyspace_no_in_sync)
#include <sys/dumphdr.h>
#undef in_sync
  extern int in_sync;
#endif

#if defined(__polyspace_postrace_buffer) && !defined(__polyspace_no_postrace_buffer)
#include <sys/ecppvar.h>
#undef postrace_buffer
  extern struct postrace postrace_buffer[];
#endif

#if defined(__polyspace_postrace_ptr) && !defined(__polyspace_no_postrace_ptr)
#include <sys/ecppvar.h>
#undef postrace_ptr
  extern struct postrace *postrace_ptr;
#endif

#if defined(__polyspace_postrace_count) && !defined(__polyspace_no_postrace_count)
#include <sys/ecppvar.h>
#undef postrace_count
  extern int postrace_count;
#endif

#if defined(__polyspace_err) && !defined(__polyspace_no_err)
#include <sys/err.h>
#undef err
  extern struct err err;
#endif

#if defined(__polyspace_nexectype) && !defined(__polyspace_no_nexectype)
#include <sys/exec.h>
#undef nexectype
  extern int nexectype;
#endif

#if defined(__polyspace_execsw) && !defined(__polyspace_no_execsw)
#include <sys/exec.h>
#undef execsw
  extern struct execsw execsw[];
#endif

#if defined(__polyspace_execsw_lock) && !defined(__polyspace_no_execsw_lock)
#include <sys/exec.h>
#undef execsw_lock
  extern kmutex_t execsw_lock;
#endif

#if defined(__polyspace_elfmagic) && !defined(__polyspace_no_elfmagic)
#include <sys/exec.h>
#undef elfmagic
  extern short elfmagic;
#endif

#if defined(__polyspace_intpmagic) && !defined(__polyspace_no_intpmagic)
#include <sys/exec.h>
#undef intpmagic
  extern short intpmagic;
#endif

#if defined(__polyspace_javamagic) && !defined(__polyspace_no_javamagic)
#include <sys/exec.h>
#undef javamagic
  extern short javamagic;
#endif

#if defined(__polyspace_aout_zmagic) && !defined(__polyspace_no_aout_zmagic)
#include <sys/exec.h>
#undef aout_zmagic
  extern short aout_zmagic;
#endif

#if defined(__polyspace_aout_nmagic) && !defined(__polyspace_no_aout_nmagic)
#include <sys/exec.h>
#undef aout_nmagic
  extern short aout_nmagic;
#endif

#if defined(__polyspace_aout_omagic) && !defined(__polyspace_no_aout_omagic)
#include <sys/exec.h>
#undef aout_omagic
  extern short aout_omagic;
#endif

#if defined(__polyspace_coffmagic) && !defined(__polyspace_no_coffmagic)
#include <sys/exec.h>
#undef coffmagic
  extern short coffmagic;
#endif

#if defined(__polyspace_nomagic) && !defined(__polyspace_no_nomagic)
#include <sys/exec.h>
#undef nomagic
  extern short nomagic;
#endif

#if defined(__polyspace_elf32magicstr) && !defined(__polyspace_no_elf32magicstr)
#include <sys/exec.h>
#undef elf32magicstr
  extern char elf32magicstr[];
#endif

#if defined(__polyspace_elf64magicstr) && !defined(__polyspace_no_elf64magicstr)
#include <sys/exec.h>
#undef elf64magicstr
  extern char elf64magicstr[];
#endif

#if defined(__polyspace_intpmagicstr) && !defined(__polyspace_no_intpmagicstr)
#include <sys/exec.h>
#undef intpmagicstr
  extern char intpmagicstr[];
#endif

#if defined(__polyspace_javamagicstr) && !defined(__polyspace_no_javamagicstr)
#include <sys/exec.h>
#undef javamagicstr
  extern char javamagicstr[];
#endif

#if defined(__polyspace_aout_nmagicstr) && !defined(__polyspace_no_aout_nmagicstr)
#include <sys/exec.h>
#undef aout_nmagicstr
  extern char aout_nmagicstr[];
#endif

#if defined(__polyspace_aout_zmagicstr) && !defined(__polyspace_no_aout_zmagicstr)
#include <sys/exec.h>
#undef aout_zmagicstr
  extern char aout_zmagicstr[];
#endif

#if defined(__polyspace_aout_omagicstr) && !defined(__polyspace_no_aout_omagicstr)
#include <sys/exec.h>
#undef aout_omagicstr
  extern char aout_omagicstr[];
#endif

#if defined(__polyspace_coffmagicstr) && !defined(__polyspace_no_coffmagicstr)
#include <sys/exec.h>
#undef coffmagicstr
  extern char coffmagicstr[];
#endif

#if defined(__polyspace_nomagicstr) && !defined(__polyspace_no_nomagicstr)
#include <sys/exec.h>
#undef nomagicstr
  extern char nomagicstr[];
#endif

#if defined(__polyspace_lock_graph) && !defined(__polyspace_no_lock_graph)
#include <sys/flock_impl.h>
#undef lock_graph
  extern struct graph *lock_graph[HASH_SIZE];
#endif

#if defined(__polyspace_flk_edge_cache) && !defined(__polyspace_no_flk_edge_cache)
#include <sys/flock_impl.h>
#undef flk_edge_cache
  extern struct kmem_cache *flk_edge_cache;
#endif

#if defined(__polyspace_flk_lockmgr_status) && !defined(__polyspace_no_flk_lockmgr_status)
#include <sys/flock_impl.h>
#undef flk_lockmgr_status
  extern flk_lockmgr_status_t flk_lockmgr_status;
#endif

#if defined(__polyspace_pgraph) && !defined(__polyspace_no_pgraph)
#include <sys/flock_impl.h>
#undef pgraph
  extern struct proc_graph pgraph;
#endif

#if defined(__polyspace_have_fast_profile_intr) && !defined(__polyspace_no_have_fast_profile_intr)
#include <sys/gprof.h>
#undef have_fast_profile_intr
  extern int have_fast_profile_intr;
#endif

#if defined(__polyspace_etext) && !defined(__polyspace_no_etext)
#include <sys/gprof.h>
#undef etext
  extern char etext[];
#endif

#if defined(__polyspace_mb_hashtab) && !defined(__polyspace_no_mb_hashtab)
#include <sys/hwconf.h>
#undef mb_hashtab
  extern struct bind *mb_hashtab[];
#endif

#if defined(__polyspace_sb_hashtab) && !defined(__polyspace_no_sb_hashtab)
#include <sys/hwconf.h>
#undef sb_hashtab
  extern struct bind *sb_hashtab[];
#endif

#if defined(__polyspace_e_ddi_inst_state) && !defined(__polyspace_no_e_ddi_inst_state)
#include <sys/instance.h>
#undef e_ddi_inst_state
  extern in_softstate_t e_ddi_inst_state;
#endif

#if defined(__polyspace_ipd_debug) && !defined(__polyspace_no_ipd_debug)
#include <sys/ipd_extern.h>
#undef ipd_debug
  extern int ipd_debug;
#endif

#if defined(__polyspace_hrestime) && !defined(__polyspace_no_hrestime)
#include <sys/ipd_extern.h>
#undef hrestime
  extern timestruc_t hrestime;
#endif

#if defined(__polyspace_ipd_cm) && !defined(__polyspace_no_ipd_cm)
#include <sys/ipd_extern.h>
#undef ipd_cm
  extern queue_t *ipd_cm;
#endif

#if defined(__polyspace_lwp_default_stksize) && !defined(__polyspace_no_lwp_default_stksize)
#include <sys/klwp.h>
#undef lwp_default_stksize
  extern int lwp_default_stksize;
#endif

#if defined(__polyspace_lwp_reapcnt) && !defined(__polyspace_no_lwp_reapcnt)
#include <sys/klwp.h>
#undef lwp_reapcnt
  extern int lwp_reapcnt;
#endif

#if defined(__polyspace_lwp_deathrow) && !defined(__polyspace_no_lwp_deathrow)
#include <sys/klwp.h>
#undef lwp_deathrow
  extern struct _kthread *lwp_deathrow;
#endif

#if defined(__polyspace_reaplock) && !defined(__polyspace_no_reaplock)
#include <sys/klwp.h>
#undef reaplock
  extern kmutex_t reaplock;
#endif

#if defined(__polyspace_lwp_cache) && !defined(__polyspace_no_lwp_cache)
#include <sys/klwp.h>
#undef lwp_cache
  extern struct kmem_cache *lwp_cache;
#endif

#if defined(__polyspace_segkp_lwp) && !defined(__polyspace_no_segkp_lwp)
#include <sys/klwp.h>
#undef segkp_lwp
  extern void *segkp_lwp;
#endif

#if defined(__polyspace_kmem_ready) && !defined(__polyspace_no_kmem_ready)
#include <sys/kmem.h>
#undef kmem_ready
  extern int kmem_ready;
#endif

#if defined(__polyspace_kmem_reapahead) && !defined(__polyspace_no_kmem_reapahead)
#include <sys/kmem.h>
#undef kmem_reapahead
  extern pgcnt_t kmem_reapahead;
#endif

#if defined(__polyspace_kobj_debug) && !defined(__polyspace_no_kobj_debug)
#include <sys/kobj_impl.h>
#undef kobj_debug
  extern int kobj_debug;
#endif

#if defined(__polyspace_ops) && !defined(__polyspace_no_ops)
#include <sys/kobj_impl.h>
#undef ops
  extern struct bootops *ops;
#endif

#if defined(__polyspace_kstat_chain) && !defined(__polyspace_no_kstat_chain)
#include <sys/kstat.h>
#undef kstat_chain
  extern kstat_t *kstat_chain;
#endif

#if defined(__polyspace_kstat_chain_lock) && !defined(__polyspace_no_kstat_chain_lock)
#include <sys/kstat.h>
#undef kstat_chain_lock
  extern kmutex_t kstat_chain_lock;
#endif

#if defined(__polyspace_kstat_chain_id) && !defined(__polyspace_no_kstat_chain_id)
#include <sys/kstat.h>
#undef kstat_chain_id
  extern kid_t kstat_chain_id;
#endif

#if defined(__polyspace_kstat_active) && !defined(__polyspace_no_kstat_active)
#include <sys/kstat.h>
#undef kstat_active
  extern int kstat_active;
#endif

#if defined(__polyspace_ksyms_table) && !defined(__polyspace_no_ksyms_table)
#include <sys/ksyms.h>
#undef ksyms_table
  extern ksyms_table_t *ksyms_table;
#endif

#if defined(__polyspace_ksyms_update_lock) && !defined(__polyspace_no_ksyms_update_lock)
#include <sys/ksyms.h>
#undef ksyms_update_lock
  extern kmutex_t ksyms_update_lock;
#endif

#if defined(__polyspace___lc_collate) && !defined(__polyspace_no___lc_collate)
#include <sys/localedef.h>
#undef __lc_collate
  extern _LC_collate_t *__lc_collate;
#endif

#if defined(__polyspace___lc_ctype) && !defined(__polyspace_no___lc_ctype)
#include <sys/localedef.h>
#undef __lc_ctype
  extern _LC_ctype_t *__lc_ctype;
#endif

#if defined(__polyspace___lc_monetary) && !defined(__polyspace_no___lc_monetary)
#include <sys/localedef.h>
#undef __lc_monetary
  extern _LC_monetary_t *__lc_monetary;
#endif

#if defined(__polyspace___lc_numeric) && !defined(__polyspace_no___lc_numeric)
#include <sys/localedef.h>
#undef __lc_numeric
  extern _LC_numeric_t *__lc_numeric;
#endif

#if defined(__polyspace___lc_messages) && !defined(__polyspace_no___lc_messages)
#include <sys/localedef.h>
#undef __lc_messages
  extern _LC_messages_t *__lc_messages;
#endif

#if defined(__polyspace___lc_time) && !defined(__polyspace_no___lc_time)
#include <sys/localedef.h>
#undef __lc_time
  extern _LC_time_t *__lc_time;
#endif

#if defined(__polyspace___lc_locale) && !defined(__polyspace_no___lc_locale)
#include <sys/localedef.h>
#undef __lc_locale
  extern _LC_locale_t *__lc_locale;
#endif

#if defined(__polyspace_lockstat_event) && !defined(__polyspace_no_lockstat_event)
#include <sys/lockstat.h>
#undef lockstat_event
  extern uchar_t lockstat_event[LS_MAX_EVENTS];
#endif

#if defined(__polyspace_log_log) && !defined(__polyspace_no_log_log)
#include <sys/log.h>
#undef log_log
  extern struct log log_log[];
#endif

#if defined(__polyspace_log_cnt) && !defined(__polyspace_no_log_cnt)
#include <sys/log.h>
#undef log_cnt
  extern int log_cnt;
#endif

#if defined(__polyspace_hres_lock) && !defined(__polyspace_no_hres_lock)
#include <sys/machlock.h>
#undef hres_lock
  extern int hres_lock;
#endif

#if defined(__polyspace_clock_res) && !defined(__polyspace_no_clock_res)
#include <sys/machlock.h>
#undef clock_res
  extern int clock_res;
#endif

#if defined(__polyspace_kernelmap) && !defined(__polyspace_no_kernelmap)
#include <sys/map.h>
#undef kernelmap
  extern struct map *kernelmap;
#endif

#if defined(__polyspace_ekernelmap) && !defined(__polyspace_no_ekernelmap)
#include <sys/map.h>
#undef ekernelmap
  extern struct map *ekernelmap;
#endif

#if defined(__polyspace_mod_driverops) && !defined(__polyspace_no_mod_driverops)
#include <sys/modctl.h>
#undef mod_driverops
  extern struct mod_ops mod_driverops;
#endif

#if defined(__polyspace_mod_execops) && !defined(__polyspace_no_mod_execops)
#include <sys/modctl.h>
#undef mod_execops
  extern struct mod_ops mod_execops;
#endif

#if defined(__polyspace_mod_miscops) && !defined(__polyspace_no_mod_miscops)
#include <sys/modctl.h>
#undef mod_miscops
  extern struct mod_ops mod_miscops;
#endif

#if defined(__polyspace_mod_schedops) && !defined(__polyspace_no_mod_schedops)
#include <sys/modctl.h>
#undef mod_schedops
  extern struct mod_ops mod_schedops;
#endif

#if defined(__polyspace_mod_strmodops) && !defined(__polyspace_no_mod_strmodops)
#include <sys/modctl.h>
#undef mod_strmodops
  extern struct mod_ops mod_strmodops;
#endif

#if defined(__polyspace_mod_syscallops) && !defined(__polyspace_no_mod_syscallops)
#include <sys/modctl.h>
#undef mod_syscallops
  extern struct mod_ops mod_syscallops;
#endif

#if defined(__polyspace_mod_syscallops32) && !defined(__polyspace_no_mod_syscallops32)
#include <sys/modctl.h>
#undef mod_syscallops32
  extern struct mod_ops mod_syscallops32;
#endif

#if defined(__polyspace_mod_lock) && !defined(__polyspace_no_mod_lock)
#include <sys/modctl.h>
#undef mod_lock
  extern kmutex_t mod_lock;
#endif

#if defined(__polyspace_instub_lock) && !defined(__polyspace_no_instub_lock)
#include <sys/modctl.h>
#undef instub_lock
  extern kmutex_t instub_lock;
#endif

#if defined(__polyspace_systemfile) && !defined(__polyspace_no_systemfile)
#include <sys/modctl.h>
#undef systemfile
  extern char *systemfile;
#endif

#if defined(__polyspace_syscallnames) && !defined(__polyspace_no_syscallnames)
#include <sys/modctl.h>
#undef syscallnames
  extern char **syscallnames;
#endif

#if defined(__polyspace_mod_mix_cv) && !defined(__polyspace_no_mod_mix_cv)
#include <sys/modctl.h>
#undef mod_mix_cv
  extern kcondvar_t mod_mix_cv;
#endif

#if defined(__polyspace_mod_mix_changed) && !defined(__polyspace_no_mod_mix_changed)
#include <sys/modctl.h>
#undef mod_mix_changed
  extern int mod_mix_changed;
#endif

#if defined(__polyspace_moddebug) && !defined(__polyspace_no_moddebug)
#include <sys/modctl.h>
#undef moddebug
  extern int moddebug;
#endif

#if defined(__polyspace_in_modprintf) && !defined(__polyspace_no_in_modprintf)
#include <sys/modctl.h>
#undef in_modprintf
  extern int in_modprintf;
#endif

#if defined(__polyspace_instubs) && !defined(__polyspace_no_instubs)
#include <sys/modctl.h>
#undef instubs
  extern int instubs;
#endif

#if defined(__polyspace_modules) && !defined(__polyspace_no_modules)
#include <sys/modctl.h>
#undef modules
  extern struct modctl modules;
#endif

#if defined(__polyspace_msg) && !defined(__polyspace_no_msg)
#include <sys/msg.h>
#undef msg
  extern caddr_t msg;
#endif

#if defined(__polyspace_msgmap) && !defined(__polyspace_no_msgmap)
#include <sys/msg.h>
#undef msgmap
  extern struct map *msgmap;
#endif

#if defined(__polyspace_msgh) && !defined(__polyspace_no_msgh)
#include <sys/msg.h>
#undef msgh
  extern struct msg *msgh;
#endif

#if defined(__polyspace_msgque) && !defined(__polyspace_no_msgque)
#include <sys/msg.h>
#undef msgque
  extern struct msqid_ds *msgque;
#endif

#if defined(__polyspace_msglock) && !defined(__polyspace_no_msglock)
#include <sys/msg.h>
#undef msglock
  extern struct msglock *msglock;
#endif

#if defined(__polyspace_msgfp) && !defined(__polyspace_no_msgfp)
#include <sys/msg.h>
#undef msgfp
  extern struct msg *msgfp;
#endif

#if defined(__polyspace_msginfo) && !defined(__polyspace_no_msginfo)
#include <sys/msg.h>
#undef msginfo
  extern struct msginfo msginfo;
#endif

#if defined(__polyspace_msgbuf) && !defined(__polyspace_no_msgbuf)
#include <sys/msgbuf.h>
#undef msgbuf
  extern struct msgbuf msgbuf;
#endif

#if defined(__polyspace_cpu_decay_factor) && !defined(__polyspace_no_cpu_decay_factor)
#include <sys/param.h>
#undef cpu_decay_factor
  extern int cpu_decay_factor;
#endif

#if defined(__polyspace_maxpid) && !defined(__polyspace_no_maxpid)
#include <sys/param.h>
#undef maxpid
  extern pid_t maxpid;
#endif

#if defined(__polyspace__pagesize) && !defined(__polyspace_no__pagesize)
#include <sys/param.h>
#undef _pagesize
  extern const unsigned long _pagesize;
#endif

#if defined(__polyspace__pageshift) && !defined(__polyspace_no__pageshift)
#include <sys/param.h>
#undef _pageshift
  extern const unsigned int _pageshift;
#endif

#if defined(__polyspace__pageoffset) && !defined(__polyspace_no__pageoffset)
#include <sys/param.h>
#undef _pageoffset
  extern const unsigned long _pageoffset;
#endif

#if defined(__polyspace__pagemask) && !defined(__polyspace_no__pagemask)
#include <sys/param.h>
#undef _pagemask
  extern const unsigned long long _pagemask;
#endif

#if defined(__polyspace__mmu_pagesize) && !defined(__polyspace_no__mmu_pagesize)
#include <sys/param.h>
#undef _mmu_pagesize
  extern const unsigned long _mmu_pagesize;
#endif

#if defined(__polyspace__mmu_pageshift) && !defined(__polyspace_no__mmu_pageshift)
#include <sys/param.h>
#undef _mmu_pageshift
  extern const unsigned int _mmu_pageshift;
#endif

#if defined(__polyspace__mmu_pageoffset) && !defined(__polyspace_no__mmu_pageoffset)
#include <sys/param.h>
#undef _mmu_pageoffset
  extern const unsigned long _mmu_pageoffset;
#endif

#if defined(__polyspace__mmu_pagemask) && !defined(__polyspace_no__mmu_pagemask)
#include <sys/param.h>
#undef _mmu_pagemask
  extern const unsigned long _mmu_pagemask;
#endif

#if defined(__polyspace__kernelbase) && !defined(__polyspace_no__kernelbase)
#include <sys/param.h>
#undef _kernelbase
  extern const uintptr_t _kernelbase;
#endif

#if defined(__polyspace__userlimit) && !defined(__polyspace_no__userlimit)
#include <sys/param.h>
#undef _userlimit
  extern const uintptr_t _userlimit;
#endif

#if defined(__polyspace__userlimit32) && !defined(__polyspace_no__userlimit32)
#include <sys/param.h>
#undef _userlimit32
  extern const uintptr_t _userlimit32;
#endif

#if defined(__polyspace__argsbase) && !defined(__polyspace_no__argsbase)
#include <sys/param.h>
#undef _argsbase
  extern const uintptr_t _argsbase;
#endif

#if defined(__polyspace__msg_bsize) && !defined(__polyspace_no__msg_bsize)
#include <sys/param.h>
#undef _msg_bsize
  extern const unsigned long _msg_bsize;
#endif

#if defined(__polyspace__defaultstksz) && !defined(__polyspace_no__defaultstksz)
#include <sys/param.h>
#undef _defaultstksz
  extern const unsigned long _defaultstksz;
#endif

#if defined(__polyspace__nbpg) && !defined(__polyspace_no__nbpg)
#include <sys/param.h>
#undef _nbpg
  extern const unsigned int _nbpg;
#endif

#if defined(__polyspace__ncpu) && !defined(__polyspace_no__ncpu)
#include <sys/param.h>
#undef _ncpu
  extern const int _ncpu;
#endif

#if defined(__polyspace__clsize) && !defined(__polyspace_no__clsize)
#include <sys/param.h>
#undef _clsize
  extern const int _clsize;
#endif

#if defined(__polyspace_ra_map_list) && !defined(__polyspace_no_ra_map_list)
#include <sys/pcalloc.h>
#undef ra_map_list
  extern struct ra_map_list *ra_map_list;
#endif

#if defined(__polyspace_ra_freelist) && !defined(__polyspace_no_ra_freelist)
#include <sys/pcalloc.h>
#undef ra_freelist
  extern struct ramap *ra_freelist;
#endif

#if defined(__polyspace_ra_intr) && !defined(__polyspace_no_ra_intr)
#include <sys/pcalloc.h>
#undef ra_intr
  extern uint_t ra_intr;
#endif

#if defined(__polyspace_ra_num_intr) && !defined(__polyspace_no_ra_num_intr)
#include <sys/pcalloc.h>
#undef ra_num_intr
  extern uint_t ra_num_intr;
#endif

#if defined(__polyspace_ppp_debug) && !defined(__polyspace_no_ppp_debug)
#include <sys/ppp_sys.h>
#undef ppp_debug
  extern int ppp_debug;
#endif

#if defined(__polyspace_hz) && !defined(__polyspace_no_hz)
#include <sys/ppp_sys.h>
#undef hz
  extern int hz;
#endif

#if defined(__polyspace_practive) && !defined(__polyspace_no_practive)
#include <sys/proc.h>
#undef practive
  extern proc_t *practive;
#endif

#if defined(__polyspace_proc_sched) && !defined(__polyspace_no_proc_sched)
#include <sys/proc.h>
#undef proc_sched
  extern proc_t *proc_sched;
#endif

#if defined(__polyspace_proc_init) && !defined(__polyspace_no_proc_init)
#include <sys/proc.h>
#undef proc_init
  extern proc_t *proc_init;
#endif

#if defined(__polyspace_proc_pageout) && !defined(__polyspace_no_proc_pageout)
#include <sys/proc.h>
#undef proc_pageout
  extern proc_t *proc_pageout;
#endif

#if defined(__polyspace_proc_fsflush) && !defined(__polyspace_no_proc_fsflush)
#include <sys/proc.h>
#undef proc_fsflush
  extern proc_t *proc_fsflush;
#endif

#if defined(__polyspace_p0) && !defined(__polyspace_no_p0)
#include <sys/proc.h>
#undef p0
  extern proc_t p0;
#endif

#if defined(__polyspace_pid0) && !defined(__polyspace_no_pid0)
#include <sys/proc.h>
#undef pid0
  extern struct pid pid0;
#endif

#if defined(__polyspace_promif_debug) && !defined(__polyspace_no_promif_debug)
#include <sys/promimpl.h>
#undef promif_debug
  extern int promif_debug;
#endif

#if defined(__polyspace_prom_aligned_allocator) && !defined(__polyspace_no_prom_aligned_allocator)
#include <sys/promimpl.h>
#undef prom_aligned_allocator
  extern int prom_aligned_allocator;
#endif

#if defined(__polyspace_p1275cif) && !defined(__polyspace_no_p1275cif)
#include <sys/promimpl.h>
#undef p1275cif
  extern void *p1275cif;
#endif

#if defined(__polyspace_promif_clntname) && !defined(__polyspace_no_promif_clntname)
#include <sys/promimpl.h>
#undef promif_clntname
  extern char promif_clntname[];
#endif

#if defined(__polyspace_pr_pid_cv) && !defined(__polyspace_no_pr_pid_cv)
#include <sys/prsystm.h>
#undef pr_pid_cv
  extern kcondvar_t *pr_pid_cv;
#endif

#if defined(__polyspace_ptms_tty) && !defined(__polyspace_no_ptms_tty)
#include <sys/ptms.h>
#undef ptms_tty
  extern struct pt_ttys *ptms_tty;
#endif

#if defined(__polyspace_pt_cnt) && !defined(__polyspace_no_pt_cnt)
#include <sys/ptms.h>
#undef pt_cnt
  extern int pt_cnt;
#endif

#if defined(__polyspace_pt_lock) && !defined(__polyspace_no_pt_lock)
#include <sys/ptms.h>
#undef pt_lock
  extern kmutex_t pt_lock;
#endif

#if defined(__polyspace_npty) && !defined(__polyspace_no_npty)
#include <sys/ptyvar.h>
#undef npty
  extern int npty;
#endif

#if defined(__polyspace_pty_softc) && !defined(__polyspace_no_pty_softc)
#include <sys/ptyvar.h>
#undef pty_softc
  extern struct pty *pty_softc;
#endif

#if defined(__polyspace_ptcph) && !defined(__polyspace_no_ptcph)
#include <sys/ptyvar.h>
#undef ptcph
  extern struct pollhead ptcph;
#endif

#if defined(__polyspace_boothowto) && !defined(__polyspace_no_boothowto)
#include <sys/reboot.h>
#undef boothowto
  extern int boothowto;
#endif

#if defined(__polyspace_rlimits) && !defined(__polyspace_no_rlimits)
#include <sys/resource.h>
#undef rlimits
  extern struct rlimit64 rlimits[];
#endif

#if defined(__polyspace_rlim_infinity_map) && !defined(__polyspace_no_rlim_infinity_map)
#include <sys/resource.h>
#undef rlim_infinity_map
  extern rlim64_t rlim_infinity_map[];
#endif

#if defined(__polyspace_rlim_infinity_map_32) && !defined(__polyspace_no_rlim_infinity_map_32)
#include <sys/resource.h>
#undef rlim_infinity_map_32
  extern rlim64_t rlim_infinity_map_32[];
#endif

#if defined(__polyspace_saddev) && !defined(__polyspace_no_saddev)
#include <sys/sad.h>
#undef saddev
  extern struct saddev *saddev;
#endif

#if defined(__polyspace_sadcnt) && !defined(__polyspace_no_sadcnt)
#include <sys/sad.h>
#undef sadcnt
  extern int sadcnt;
#endif

#if defined(__polyspace_autopush) && !defined(__polyspace_no_autopush)
#include <sys/sad.h>
#undef autopush
  extern struct autopush *autopush;
#endif

#if defined(__polyspace_nautopush) && !defined(__polyspace_no_nautopush)
#include <sys/sad.h>
#undef nautopush
  extern int nautopush;
#endif

#if defined(__polyspace_strpfreep) && !defined(__polyspace_no_strpfreep)
#include <sys/sad.h>
#undef strpfreep
  extern struct autopush *strpfreep;
#endif

#if defined(__polyspace_strpcache) && !defined(__polyspace_no_strpcache)
#include <sys/sad.h>
#undef strpcache
  extern struct autopush **strpcache;
#endif

#if defined(__polyspace_nstrphash) && !defined(__polyspace_no_nstrphash)
#include <sys/sad.h>
#undef nstrphash
  extern int nstrphash;
#endif

#if defined(__polyspace_strpmask) && !defined(__polyspace_no_strpmask)
#include <sys/sad.h>
#undef strpmask
  extern int strpmask;
#endif

#if defined(__polyspace_sadminqp) && !defined(__polyspace_no_sadminqp)
#include <sys/sad.h>
#undef sadminqp
  extern queue_t *sadminqp;
#endif

#if defined(__polyspace_sema) && !defined(__polyspace_no_sema)
#include <sys/sem.h>
#undef sema
  extern struct semid_ds *sema;
#endif

#if defined(__polyspace_sem) && !defined(__polyspace_no_sem)
#include <sys/sem.h>
#undef sem
  extern struct sem *sem;
#endif

#if defined(__polyspace_semmap) && !defined(__polyspace_no_semmap)
#include <sys/sem.h>
#undef semmap
  extern struct map *semmap;
#endif

#if defined(__polyspace_sem_undo) && !defined(__polyspace_no_sem_undo)
#include <sys/sem.h>
#undef sem_undo
  extern struct sem_undo **sem_undo;
#endif

#if defined(__polyspace_semunp) && !defined(__polyspace_no_semunp)
#include <sys/sem.h>
#undef semunp
  extern struct sem_undo *semunp;
#endif

#if defined(__polyspace_semfup) && !defined(__polyspace_no_semfup)
#include <sys/sem.h>
#undef semfup
  extern struct sem_undo *semfup;
#endif

#if defined(__polyspace_semu) && !defined(__polyspace_no_semu)
#include <sys/sem.h>
#undef semu
  extern int *semu;
#endif

#if defined(__polyspace_seminfo) && !defined(__polyspace_no_seminfo)
#include <sys/sem.h>
#undef seminfo
  extern struct seminfo seminfo;
#endif

#if defined(__polyspace_session0) && !defined(__polyspace_no_session0)
#include <sys/session.h>
#undef session0
  extern sess_t session0;
#endif

#if defined(__polyspace_shmem) && !defined(__polyspace_no_shmem)
#include <sys/shm.h>
#undef shmem
  extern struct shmid_ds *shmem;
#endif

#if defined(__polyspace_shminfo) && !defined(__polyspace_no_shminfo)
#include <sys/shm.h>
#undef shminfo
  extern struct shminfo shminfo;
#endif

#if defined(__polyspace_sleepq_head) && !defined(__polyspace_no_sleepq_head)
#include <sys/sleepq.h>
#undef sleepq_head
  extern sleepq_head_t sleepq_head[NSLEEPQ];
#endif

#if defined(__polyspace_sphead) && !defined(__polyspace_no_sphead)
#include <sys/socketvar.h>
#undef sphead
  extern struct sockparams *sphead;
#endif

#if defined(__polyspace_socklist) && !defined(__polyspace_no_socklist)
#include <sys/socketvar.h>
#undef socklist
  extern struct socklist socklist;
#endif

#if defined(__polyspace_so_default_version) && !defined(__polyspace_no_so_default_version)
#include <sys/socketvar.h>
#undef so_default_version
  extern int so_default_version;
#endif

#if defined(__polyspace_sockdebug) && !defined(__polyspace_no_sockdebug)
#include <sys/socketvar.h>
#undef sockdebug
  extern int sockdebug;
#endif

#if defined(__polyspace_sockprinterr) && !defined(__polyspace_no_sockprinterr)
#include <sys/socketvar.h>
#undef sockprinterr
  extern int sockprinterr;
#endif

#if defined(__polyspace_sock_vfsops) && !defined(__polyspace_no_sock_vfsops)
#include <sys/socketvar.h>
#undef sock_vfsops
  extern struct vfsops sock_vfsops;
#endif

#if defined(__polyspace_sock_cache) && !defined(__polyspace_no_sock_cache)
#include <sys/socketvar.h>
#undef sock_cache
  extern struct kmem_cache *sock_cache;
#endif

#if defined(__polyspace__s_sockdebug) && !defined(__polyspace_no__s_sockdebug)
#include <sys/sockmod.h>
#undef _s_sockdebug
  extern int _s_sockdebug;
#endif

#if defined(__polyspace_nstrpush) && !defined(__polyspace_no_nstrpush)
#include <sys/stream.h>
#undef nstrpush
  extern int nstrpush;
#endif

#if defined(__polyspace_zcdebug) && !defined(__polyspace_no_zcdebug)
#include <sys/strsubr.h>
#undef zcdebug
  extern int zcdebug;
#endif

#if defined(__polyspace_zcperf) && !defined(__polyspace_no_zcperf)
#include <sys/strsubr.h>
#undef zcperf
  extern int zcperf;
#endif

#if defined(__polyspace_zcslice) && !defined(__polyspace_no_zcslice)
#include <sys/strsubr.h>
#undef zcslice
  extern int zcslice;
#endif

#if defined(__polyspace_syncstream) && !defined(__polyspace_no_syncstream)
#include <sys/strsubr.h>
#undef syncstream
  extern int syncstream;
#endif

#if defined(__polyspace_strmsgsz) && !defined(__polyspace_no_strmsgsz)
#include <sys/strsubr.h>
#undef strmsgsz
  extern ssize_t strmsgsz;
#endif

#if defined(__polyspace_strctlsz) && !defined(__polyspace_no_strctlsz)
#include <sys/strsubr.h>
#undef strctlsz
  extern ssize_t strctlsz;
#endif

#if defined(__polyspace_strzc_on) && !defined(__polyspace_no_strzc_on)
#include <sys/strsubr.h>
#undef strzc_on
  extern int strzc_on;
#endif

#if defined(__polyspace_strzc_minblk) && !defined(__polyspace_no_strzc_minblk)
#include <sys/strsubr.h>
#undef strzc_minblk
  extern uint_t strzc_minblk;
#endif

#if defined(__polyspace_strzc_write_threshold) && !defined(__polyspace_no_strzc_write_threshold)
#include <sys/strsubr.h>
#undef strzc_write_threshold
  extern uint_t strzc_write_threshold;
#endif

#if defined(__polyspace_strzc_cow_check_period) && !defined(__polyspace_no_strzc_cow_check_period)
#include <sys/strsubr.h>
#undef strzc_cow_check_period
  extern uint_t strzc_cow_check_period;
#endif

#if defined(__polyspace_strzc_cowfault_allowed) && !defined(__polyspace_no_strzc_cowfault_allowed)
#include <sys/strsubr.h>
#undef strzc_cowfault_allowed
  extern uint_t strzc_cowfault_allowed;
#endif

#if defined(__polyspace_qhead) && !defined(__polyspace_no_qhead)
#include <sys/strsubr.h>
#undef qhead
  extern queue_t *qhead;
#endif

#if defined(__polyspace_qtail) && !defined(__polyspace_no_qtail)
#include <sys/strsubr.h>
#undef qtail
  extern queue_t *qtail;
#endif

#if defined(__polyspace_service_queue) && !defined(__polyspace_no_service_queue)
#include <sys/strsubr.h>
#undef service_queue
  extern kmutex_t service_queue;
#endif

#if defined(__polyspace_strbcalls) && !defined(__polyspace_no_strbcalls)
#include <sys/strsubr.h>
#undef strbcalls
  extern struct bclist strbcalls;
#endif

#if defined(__polyspace_strbcflag) && !defined(__polyspace_no_strbcflag)
#include <sys/strsubr.h>
#undef strbcflag
  extern char strbcflag;
#endif

#if defined(__polyspace_qrunflag) && !defined(__polyspace_no_qrunflag)
#include <sys/strsubr.h>
#undef qrunflag
  extern char qrunflag;
#endif

#if defined(__polyspace_bcall_cv) && !defined(__polyspace_no_bcall_cv)
#include <sys/strsubr.h>
#undef bcall_cv
  extern kcondvar_t bcall_cv;
#endif

#if defined(__polyspace_run_queues) && !defined(__polyspace_no_run_queues)
#include <sys/strsubr.h>
#undef run_queues
  extern int run_queues;
#endif

#if defined(__polyspace_services_to_run) && !defined(__polyspace_no_services_to_run)
#include <sys/strsubr.h>
#undef services_to_run
  extern kcondvar_t services_to_run;
#endif

#if defined(__polyspace_frnop) && !defined(__polyspace_no_frnop)
#include <sys/strsubr.h>
#undef frnop
  extern frtn_t frnop;
#endif

#if defined(__polyspace_enqueued) && !defined(__polyspace_no_enqueued)
#include <sys/strsubr.h>
#undef enqueued
  extern int enqueued;
#endif

#if defined(__polyspace_strsig_cache) && !defined(__polyspace_no_strsig_cache)
#include <sys/strsubr.h>
#undef strsig_cache
  extern struct kmem_cache *strsig_cache;
#endif

#if defined(__polyspace_bufcall_cache) && !defined(__polyspace_no_bufcall_cache)
#include <sys/strsubr.h>
#undef bufcall_cache
  extern struct kmem_cache *bufcall_cache;
#endif

#if defined(__polyspace_callbparams_cache) && !defined(__polyspace_no_callbparams_cache)
#include <sys/strsubr.h>
#undef callbparams_cache
  extern struct kmem_cache *callbparams_cache;
#endif

#if defined(__polyspace_permod_syncq) && !defined(__polyspace_no_permod_syncq)
#include <sys/strsubr.h>
#undef permod_syncq
  extern perdm_t *permod_syncq;
#endif

#if defined(__polyspace_perdev_syncq) && !defined(__polyspace_no_perdev_syncq)
#include <sys/strsubr.h>
#undef perdev_syncq
  extern perdm_t *perdev_syncq;
#endif

#if defined(__polyspace_zckstat) && !defined(__polyspace_no_zckstat)
#include <sys/strsubr.h>
#undef zckstat
  extern struct zero_copy_kstat *zckstat;
#endif

#if defined(__polyspace_maxphys) && !defined(__polyspace_no_maxphys)
#include <sys/sunddi.h>
#undef maxphys
  extern int maxphys;
#endif

#if defined(__polyspace_swapinfo) && !defined(__polyspace_no_swapinfo)
#include <sys/swap.h>
#undef swapinfo
  extern struct swapinfo *swapinfo;
#endif

#if defined(__polyspace_swap_debug) && !defined(__polyspace_no_swap_debug)
#include <sys/swap.h>
#undef swap_debug
  extern int swap_debug;
#endif

#if defined(__polyspace_bcd_to_byte) && !defined(__polyspace_no_bcd_to_byte)
#include <sys/sysmacros.h>
#undef bcd_to_byte
  extern unsigned char bcd_to_byte[256];
#endif

#if defined(__polyspace_hw_serial) && !defined(__polyspace_no_hw_serial)
#include <sys/systeminfo.h>
#undef hw_serial
  extern char hw_serial[];
#endif

#if defined(__polyspace_hw_provider) && !defined(__polyspace_no_hw_provider)
#include <sys/systeminfo.h>
#undef hw_provider
  extern char hw_provider[];
#endif

#if defined(__polyspace_srpc_domain) && !defined(__polyspace_no_srpc_domain)
#include <sys/systeminfo.h>
#undef srpc_domain
  extern char srpc_domain[];
#endif

#if defined(__polyspace_kerb_realm) && !defined(__polyspace_no_kerb_realm)
#include <sys/systeminfo.h>
#undef kerb_realm
  extern char kerb_realm[];
#endif

#if defined(__polyspace_platform) && !defined(__polyspace_no_platform)
#include <sys/systeminfo.h>
#undef platform
  extern char platform[];
#endif

#if defined(__polyspace_rootdir) && !defined(__polyspace_no_rootdir)
#include <sys/systm.h>
#undef rootdir
  extern struct vnode *rootdir;
#endif

#if defined(__polyspace_lbolt) && !defined(__polyspace_no_lbolt)
#include <sys/systm.h>
#undef lbolt
  extern volatile clock_t lbolt;
#endif

#if defined(__polyspace_lbolt64) && !defined(__polyspace_no_lbolt64)
#include <sys/systm.h>
#undef lbolt64
  extern volatile int64_t lbolt64;
#endif

#if defined(__polyspace_runin) && !defined(__polyspace_no_runin)
#include <sys/systm.h>
#undef runin
  extern char runin;
#endif

#if defined(__polyspace_runout) && !defined(__polyspace_no_runout)
#include <sys/systm.h>
#undef runout
  extern char runout;
#endif

#if defined(__polyspace_wake_sched) && !defined(__polyspace_no_wake_sched)
#include <sys/systm.h>
#undef wake_sched
  extern char wake_sched;
#endif

#if defined(__polyspace_wake_sched_sec) && !defined(__polyspace_no_wake_sched_sec)
#include <sys/systm.h>
#undef wake_sched_sec
  extern char wake_sched_sec;
#endif

#if defined(__polyspace_maxmem) && !defined(__polyspace_no_maxmem)
#include <sys/systm.h>
#undef maxmem
  extern pgcnt_t maxmem;
#endif

#if defined(__polyspace_physmem) && !defined(__polyspace_no_physmem)
#include <sys/systm.h>
#undef physmem
  extern pgcnt_t physmem;
#endif

#if defined(__polyspace_physmax) && !defined(__polyspace_no_physmax)
#include <sys/systm.h>
#undef physmax
  extern pfn_t physmax;
#endif

#if defined(__polyspace_physinstalled) && !defined(__polyspace_no_physinstalled)
#include <sys/systm.h>
#undef physinstalled
  extern pgcnt_t physinstalled;
#endif

#if defined(__polyspace_s_text) && !defined(__polyspace_no_s_text)
#include <sys/systm.h>
#undef s_text
  extern caddr_t s_text;
#endif

#if defined(__polyspace_e_text) && !defined(__polyspace_no_e_text)
#include <sys/systm.h>
#undef e_text
  extern caddr_t e_text;
#endif

#if defined(__polyspace_s_data) && !defined(__polyspace_no_s_data)
#include <sys/systm.h>
#undef s_data
  extern caddr_t s_data;
#endif

#if defined(__polyspace_e_data) && !defined(__polyspace_no_e_data)
#include <sys/systm.h>
#undef e_data
  extern caddr_t e_data;
#endif

#if defined(__polyspace_kernelheap) && !defined(__polyspace_no_kernelheap)
#include <sys/systm.h>
#undef kernelheap
  extern caddr_t kernelheap;
#endif

#if defined(__polyspace_ekernelheap) && !defined(__polyspace_no_ekernelheap)
#include <sys/systm.h>
#undef ekernelheap
  extern caddr_t ekernelheap;
#endif

#if defined(__polyspace_availrmem) && !defined(__polyspace_no_availrmem)
#include <sys/systm.h>
#undef availrmem
  extern pgcnt_t availrmem;
#endif

#if defined(__polyspace_availrmem_initial) && !defined(__polyspace_no_availrmem_initial)
#include <sys/systm.h>
#undef availrmem_initial
  extern pgcnt_t availrmem_initial;
#endif

#if defined(__polyspace_segspt_minfree) && !defined(__polyspace_no_segspt_minfree)
#include <sys/systm.h>
#undef segspt_minfree
  extern pgcnt_t segspt_minfree;
#endif

#if defined(__polyspace_freemem) && !defined(__polyspace_no_freemem)
#include <sys/systm.h>
#undef freemem
  extern pgcnt_t freemem;
#endif

#if defined(__polyspace_nswap) && !defined(__polyspace_no_nswap)
#include <sys/systm.h>
#undef nswap
  extern nswap;
#endif

#if defined(__polyspace_rootdev) && !defined(__polyspace_no_rootdev)
#include <sys/systm.h>
#undef rootdev
  extern dev_t rootdev;
#endif

#if defined(__polyspace_rootvp) && !defined(__polyspace_no_rootvp)
#include <sys/systm.h>
#undef rootvp
  extern struct vnode *rootvp;
#endif

#if defined(__polyspace_panicstr) && !defined(__polyspace_no_panicstr)
#include <sys/systm.h>
#undef panicstr
  extern char *volatile panicstr;
#endif

#if defined(__polyspace_panicargs) && !defined(__polyspace_no_panicargs)
#include <sys/systm.h>
#undef panicargs
  extern va_list panicargs;
#endif

#if defined(__polyspace_rstchown) && !defined(__polyspace_no_rstchown)
#include <sys/systm.h>
#undef rstchown
  extern int rstchown;
#endif

#if defined(__polyspace_klustsize) && !defined(__polyspace_no_klustsize)
#include <sys/systm.h>
#undef klustsize
  extern int klustsize;
#endif

#if defined(__polyspace_conslogging) && !defined(__polyspace_no_conslogging)
#include <sys/systm.h>
#undef conslogging
  extern int conslogging;
#endif

#if defined(__polyspace_abort_enable) && !defined(__polyspace_no_abort_enable)
#include <sys/systm.h>
#undef abort_enable
  extern int abort_enable;
#endif

#if defined(__polyspace_audit_active) && !defined(__polyspace_no_audit_active)
#include <sys/systm.h>
#undef audit_active
  extern int audit_active;
#endif

#if defined(__polyspace_avenrun) && !defined(__polyspace_no_avenrun)
#include <sys/systm.h>
#undef avenrun
  extern int avenrun[];
#endif

#if defined(__polyspace_isa_list) && !defined(__polyspace_no_isa_list)
#include <sys/systm.h>
#undef isa_list
  extern char *isa_list;
#endif

#if defined(__polyspace_noexec_user_stack) && !defined(__polyspace_no_noexec_user_stack)
#include <sys/systm.h>
#undef noexec_user_stack
  extern int noexec_user_stack;
#endif

#if defined(__polyspace_noexec_user_stack_log) && !defined(__polyspace_no_noexec_user_stack_log)
#include <sys/systm.h>
#undef noexec_user_stack_log
  extern int noexec_user_stack_log;
#endif

#if defined(__polyspace_maxusers) && !defined(__polyspace_no_maxusers)
#include <sys/systm.h>
#undef maxusers
  extern int maxusers;
#endif

#if defined(__polyspace_pidmax) && !defined(__polyspace_no_pidmax)
#include <sys/systm.h>
#undef pidmax
  extern int pidmax;
#endif

#if defined(__polyspace_sysent) && !defined(__polyspace_no_sysent)
#include <sys/systm.h>
#undef sysent
  extern struct sysent sysent[];
#endif

#if defined(__polyspace_sysent32) && !defined(__polyspace_no_sysent32)
#include <sys/systm.h>
#undef sysent32
  extern struct sysent sysent32[];
#endif

#if defined(__polyspace_nosys_ent) && !defined(__polyspace_no_nosys_ent)
#include <sys/systm.h>
#undef nosys_ent
  extern struct sysent nosys_ent;
#endif

#if defined(__polyspace___lintzero) && !defined(__polyspace_no___lintzero)
#include <sys/systm.h>
#undef __lintzero
  extern int __lintzero;
#endif

#if defined(__polyspace_ktlilog) && !defined(__polyspace_no_ktlilog)
#include <sys/t_kuser.h>
#undef ktlilog
  extern int ktlilog;
#endif

#if defined(__polyspace_t0) && !defined(__polyspace_no_t0)
#include <sys/thread.h>
#undef t0
  extern struct _kthread t0;
#endif

#if defined(__polyspace_pidlock) && !defined(__polyspace_no_pidlock)
#include <sys/thread.h>
#undef pidlock
  extern kmutex_t pidlock;
#endif

#if defined(__polyspace_thread_free_lock) && !defined(__polyspace_no_thread_free_lock)
#include <sys/thread.h>
#undef thread_free_lock
  extern kmutex_t thread_free_lock;
#endif

#if defined(__polyspace_transition_lock) && !defined(__polyspace_no_transition_lock)
#include <sys/thread.h>
#undef transition_lock
  extern disp_lock_t transition_lock;
#endif

#if defined(__polyspace_stop_lock) && !defined(__polyspace_no_stop_lock)
#include <sys/thread.h>
#undef stop_lock
  extern disp_lock_t stop_lock;
#endif

#if defined(__polyspace_tick_per_msec) && !defined(__polyspace_no_tick_per_msec)
#include <sys/time.h>
#undef tick_per_msec
  extern int tick_per_msec;
#endif

#if defined(__polyspace_msec_per_tick) && !defined(__polyspace_no_msec_per_tick)
#include <sys/time.h>
#undef msec_per_tick
  extern int msec_per_tick;
#endif

#if defined(__polyspace_usec_per_tick) && !defined(__polyspace_no_usec_per_tick)
#include <sys/time.h>
#undef usec_per_tick
  extern int usec_per_tick;
#endif

#if defined(__polyspace_nsec_per_tick) && !defined(__polyspace_no_nsec_per_tick)
#include <sys/time.h>
#undef nsec_per_tick
  extern int nsec_per_tick;
#endif

#if defined(__polyspace_timedelta) && !defined(__polyspace_no_timedelta)
#include <sys/time.h>
#undef timedelta
  extern int64_t timedelta;
#endif

#if defined(__polyspace_tod_needsync) && !defined(__polyspace_no_tod_needsync)
#include <sys/time.h>
#undef tod_needsync
  extern int tod_needsync;
#endif

#if defined(__polyspace_tod_lock) && !defined(__polyspace_no_tod_lock)
#include <sys/time.h>
#undef tod_lock
  extern kmutex_t tod_lock;
#endif

#if defined(__polyspace_time_state) && !defined(__polyspace_no_time_state)
#include <sys/timex.h>
#undef time_state
  extern int32_t time_state;
#endif

#if defined(__polyspace_time_status) && !defined(__polyspace_no_time_status)
#include <sys/timex.h>
#undef time_status
  extern int32_t time_status;
#endif

#if defined(__polyspace_time_offset) && !defined(__polyspace_no_time_offset)
#include <sys/timex.h>
#undef time_offset
  extern int32_t time_offset;
#endif

#if defined(__polyspace_time_freq) && !defined(__polyspace_no_time_freq)
#include <sys/timex.h>
#undef time_freq
  extern int32_t time_freq;
#endif

#if defined(__polyspace_time_maxerror) && !defined(__polyspace_no_time_maxerror)
#include <sys/timex.h>
#undef time_maxerror
  extern int32_t time_maxerror;
#endif

#if defined(__polyspace_time_esterror) && !defined(__polyspace_no_time_esterror)
#include <sys/timex.h>
#undef time_esterror
  extern int32_t time_esterror;
#endif

#if defined(__polyspace_time_constant) && !defined(__polyspace_no_time_constant)
#include <sys/timex.h>
#undef time_constant
  extern int32_t time_constant;
#endif

#if defined(__polyspace_time_precision) && !defined(__polyspace_no_time_precision)
#include <sys/timex.h>
#undef time_precision
  extern int32_t time_precision;
#endif

#if defined(__polyspace_time_tolerance) && !defined(__polyspace_no_time_tolerance)
#include <sys/timex.h>
#undef time_tolerance
  extern int32_t time_tolerance;
#endif

#if defined(__polyspace_pps_shift) && !defined(__polyspace_no_pps_shift)
#include <sys/timex.h>
#undef pps_shift
  extern int32_t pps_shift;
#endif

#if defined(__polyspace_pps_freq) && !defined(__polyspace_no_pps_freq)
#include <sys/timex.h>
#undef pps_freq
  extern int32_t pps_freq;
#endif

#if defined(__polyspace_pps_jitter) && !defined(__polyspace_no_pps_jitter)
#include <sys/timex.h>
#undef pps_jitter
  extern int32_t pps_jitter;
#endif

#if defined(__polyspace_pps_stabil) && !defined(__polyspace_no_pps_stabil)
#include <sys/timex.h>
#undef pps_stabil
  extern int32_t pps_stabil;
#endif

#if defined(__polyspace_pps_jitcnt) && !defined(__polyspace_no_pps_jitcnt)
#include <sys/timex.h>
#undef pps_jitcnt
  extern int32_t pps_jitcnt;
#endif

#if defined(__polyspace_pps_calcnt) && !defined(__polyspace_no_pps_calcnt)
#include <sys/timex.h>
#undef pps_calcnt
  extern int32_t pps_calcnt;
#endif

#if defined(__polyspace_pps_errcnt) && !defined(__polyspace_no_pps_errcnt)
#include <sys/timex.h>
#undef pps_errcnt
  extern int32_t pps_errcnt;
#endif

#if defined(__polyspace_pps_stbcnt) && !defined(__polyspace_no_pps_stbcnt)
#include <sys/timex.h>
#undef pps_stbcnt
  extern int32_t pps_stbcnt;
#endif

#if defined(__polyspace_t_errlist) && !defined(__polyspace_no_t_errlist)
#include <sys/tiuser.h>
#undef t_errlist
  extern char *t_errlist[];
#endif

#if defined(__polyspace_t_nerr) && !defined(__polyspace_no_t_nerr)
#include <sys/tiuser.h>
#undef t_nerr
  extern int t_nerr;
#endif

#if defined(__polyspace_tnf_tracing_active) && !defined(__polyspace_no_tnf_tracing_active)
#include <sys/tnf.h>
#undef tnf_tracing_active
  extern volatile int tnf_tracing_active;
#endif

#if defined(__polyspace___tnf_probe_version_1) && !defined(__polyspace_no___tnf_probe_version_1)
#include <sys/tnf_probe.h>
#undef __tnf_probe_version_1
  extern struct tnf_probe_version __tnf_probe_version_1;
#endif

#if defined(__polyspace___tnf_tag_version_1_info) && !defined(__polyspace_no___tnf_tag_version_1_info)
#include <sys/tnf_writer.h>
#undef __tnf_tag_version_1_info
  extern tnf_tag_version_t __tnf_tag_version_1_info;
#endif

#if defined(__polyspace___tnf_tag_version_1) && !defined(__polyspace_no___tnf_tag_version_1)
#include <sys/tnf_writer.h>
#undef __tnf_tag_version_1
  extern tnf_tag_version_t __tnf_tag_version_1;
#endif

#if defined(__polyspace_tnf_char_tag_data) && !defined(__polyspace_no_tnf_char_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_char_tag_data
  extern tnf_tag_data_t *tnf_char_tag_data;
#endif

#if defined(__polyspace_tnf_int8_tag_data) && !defined(__polyspace_no_tnf_int8_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_int8_tag_data
  extern tnf_tag_data_t *tnf_int8_tag_data;
#endif

#if defined(__polyspace_tnf_uint8_tag_data) && !defined(__polyspace_no_tnf_uint8_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_uint8_tag_data
  extern tnf_tag_data_t *tnf_uint8_tag_data;
#endif

#if defined(__polyspace_tnf_int16_tag_data) && !defined(__polyspace_no_tnf_int16_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_int16_tag_data
  extern tnf_tag_data_t *tnf_int16_tag_data;
#endif

#if defined(__polyspace_tnf_uint16_tag_data) && !defined(__polyspace_no_tnf_uint16_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_uint16_tag_data
  extern tnf_tag_data_t *tnf_uint16_tag_data;
#endif

#if defined(__polyspace_tnf_int32_tag_data) && !defined(__polyspace_no_tnf_int32_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_int32_tag_data
  extern tnf_tag_data_t *tnf_int32_tag_data;
#endif

#if defined(__polyspace_tnf_uint32_tag_data) && !defined(__polyspace_no_tnf_uint32_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_uint32_tag_data
  extern tnf_tag_data_t *tnf_uint32_tag_data;
#endif

#if defined(__polyspace_tnf_int64_tag_data) && !defined(__polyspace_no_tnf_int64_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_int64_tag_data
  extern tnf_tag_data_t *tnf_int64_tag_data;
#endif

#if defined(__polyspace_tnf_uint64_tag_data) && !defined(__polyspace_no_tnf_uint64_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_uint64_tag_data
  extern tnf_tag_data_t *tnf_uint64_tag_data;
#endif

#if defined(__polyspace_tnf_float32_tag_data) && !defined(__polyspace_no_tnf_float32_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_float32_tag_data
  extern tnf_tag_data_t *tnf_float32_tag_data;
#endif

#if defined(__polyspace_tnf_float64_tag_data) && !defined(__polyspace_no_tnf_float64_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_float64_tag_data
  extern tnf_tag_data_t *tnf_float64_tag_data;
#endif

#if defined(__polyspace_tnf_tag_tag_data) && !defined(__polyspace_no_tnf_tag_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_tag_tag_data
  extern tnf_tag_data_t *tnf_tag_tag_data;
#endif

#if defined(__polyspace_tnf_string_tag_data) && !defined(__polyspace_no_tnf_string_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_string_tag_data
  extern tnf_tag_data_t *tnf_string_tag_data;
#endif

#if defined(__polyspace_tnf_name_tag_data) && !defined(__polyspace_no_tnf_name_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_name_tag_data
  extern tnf_tag_data_t *tnf_name_tag_data;
#endif

#if defined(__polyspace_tnf_size_tag_data) && !defined(__polyspace_no_tnf_size_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_size_tag_data
  extern tnf_tag_data_t *tnf_size_tag_data;
#endif

#if defined(__polyspace_tnf_opaque_tag_data) && !defined(__polyspace_no_tnf_opaque_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_opaque_tag_data
  extern tnf_tag_data_t *tnf_opaque_tag_data;
#endif

#if defined(__polyspace_tnf_time_base_tag_data) && !defined(__polyspace_no_tnf_time_base_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_time_base_tag_data
  extern tnf_tag_data_t *tnf_time_base_tag_data;
#endif

#if defined(__polyspace_tnf_time_delta_tag_data) && !defined(__polyspace_no_tnf_time_delta_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_time_delta_tag_data
  extern tnf_tag_data_t *tnf_time_delta_tag_data;
#endif

#if defined(__polyspace_tnf_probe_event_tag_data) && !defined(__polyspace_no_tnf_probe_event_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_probe_event_tag_data
  extern tnf_tag_data_t *tnf_probe_event_tag_data;
#endif

#if defined(__polyspace_tnf_pid_tag_data) && !defined(__polyspace_no_tnf_pid_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_pid_tag_data
  extern tnf_tag_data_t *tnf_pid_tag_data;
#endif

#if defined(__polyspace_tnf_lwpid_tag_data) && !defined(__polyspace_no_tnf_lwpid_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_lwpid_tag_data
  extern tnf_tag_data_t *tnf_lwpid_tag_data;
#endif

#if defined(__polyspace_tnf_kthread_id_tag_data) && !defined(__polyspace_no_tnf_kthread_id_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_kthread_id_tag_data
  extern tnf_tag_data_t *tnf_kthread_id_tag_data;
#endif

#if defined(__polyspace_tnf_cpuid_tag_data) && !defined(__polyspace_no_tnf_cpuid_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_cpuid_tag_data
  extern tnf_tag_data_t *tnf_cpuid_tag_data;
#endif

#if defined(__polyspace_tnf_device_tag_data) && !defined(__polyspace_no_tnf_device_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_device_tag_data
  extern tnf_tag_data_t *tnf_device_tag_data;
#endif

#if defined(__polyspace_tnf_symbol_tag_data) && !defined(__polyspace_no_tnf_symbol_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_symbol_tag_data
  extern tnf_tag_data_t *tnf_symbol_tag_data;
#endif

#if defined(__polyspace_tnf_symbols_tag_data) && !defined(__polyspace_no_tnf_symbols_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_symbols_tag_data
  extern tnf_tag_data_t *tnf_symbols_tag_data;
#endif

#if defined(__polyspace_tnf_sysnum_tag_data) && !defined(__polyspace_no_tnf_sysnum_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_sysnum_tag_data
  extern tnf_tag_data_t *tnf_sysnum_tag_data;
#endif

#if defined(__polyspace_tnf_microstate_tag_data) && !defined(__polyspace_no_tnf_microstate_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_microstate_tag_data
  extern tnf_tag_data_t *tnf_microstate_tag_data;
#endif

#if defined(__polyspace_tnf_offset_tag_data) && !defined(__polyspace_no_tnf_offset_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_offset_tag_data
  extern tnf_tag_data_t *tnf_offset_tag_data;
#endif

#if defined(__polyspace_tnf_fault_type_tag_data) && !defined(__polyspace_no_tnf_fault_type_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_fault_type_tag_data
  extern tnf_tag_data_t *tnf_fault_type_tag_data;
#endif

#if defined(__polyspace_tnf_seg_access_tag_data) && !defined(__polyspace_no_tnf_seg_access_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_seg_access_tag_data
  extern tnf_tag_data_t *tnf_seg_access_tag_data;
#endif

#if defined(__polyspace_tnf_bioflags_tag_data) && !defined(__polyspace_no_tnf_bioflags_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_bioflags_tag_data
  extern tnf_tag_data_t *tnf_bioflags_tag_data;
#endif

#if defined(__polyspace_tnf_diskaddr_tag_data) && !defined(__polyspace_no_tnf_diskaddr_tag_data)
#include <sys/tnf_writer.h>
#undef tnf_diskaddr_tag_data
  extern tnf_tag_data_t *tnf_diskaddr_tag_data;
#endif

#if defined(__polyspace_tnf_user_struct_properties) && !defined(__polyspace_no_tnf_user_struct_properties)
#include <sys/tnf_writer.h>
#undef tnf_user_struct_properties
  extern tnf_tag_data_t ***tnf_user_struct_properties;
#endif

#if defined(__polyspace_tune) && !defined(__polyspace_no_tune)
#include <sys/tuneable.h>
#undef tune
  extern tune_t tune;
#endif

#if defined(__polyspace_utsname) && !defined(__polyspace_no_utsname)
#include <sys/utsname.h>
#undef utsname
  extern struct utsname utsname;
#endif

#if defined(__polyspace_v) && !defined(__polyspace_no_v)
#include <sys/var.h>
#undef v
  extern struct var v;
#endif

#if defined(__polyspace_vfssw) && !defined(__polyspace_no_vfssw)
#include <sys/vfs.h>
#undef vfssw
  extern struct vfssw vfssw[];
#endif

#if defined(__polyspace_vfssw_lock) && !defined(__polyspace_no_vfssw_lock)
#include <sys/vfs.h>
#undef vfssw_lock
  extern krwlock_t vfssw_lock;
#endif

#if defined(__polyspace_rootfstype) && !defined(__polyspace_no_rootfstype)
#include <sys/vfs.h>
#undef rootfstype
  extern char rootfstype[];
#endif

#if defined(__polyspace_nfstype) && !defined(__polyspace_no_nfstype)
#include <sys/vfs.h>
#undef nfstype
  extern int nfstype;
#endif

#if defined(__polyspace_rootvfs) && !defined(__polyspace_no_rootvfs)
#include <sys/vfs.h>
#undef rootvfs
  extern struct vfs *rootvfs;
#endif

#if defined(__polyspace_rvfs_head) && !defined(__polyspace_no_rvfs_head)
#include <sys/vfs.h>
#undef rvfs_head
  extern struct vfs **rvfs_head;
#endif

#if defined(__polyspace_rvfs_lock) && !defined(__polyspace_no_rvfs_lock)
#include <sys/vfs.h>
#undef rvfs_lock
  extern kmutex_t *rvfs_lock;
#endif

#if defined(__polyspace_vfshsz) && !defined(__polyspace_no_vfshsz)
#include <sys/vfs.h>
#undef vfshsz
  extern int vfshsz;
#endif

#if defined(__polyspace__dsize_limit) && !defined(__polyspace_no__dsize_limit)
#include <sys/vmparam.h>
#undef _dsize_limit
  extern const unsigned long _dsize_limit;
#endif

#if defined(__polyspace__ssize_limit) && !defined(__polyspace_no__ssize_limit)
#include <sys/vmparam.h>
#undef _ssize_limit
  extern const unsigned long _ssize_limit;
#endif

#if defined(__polyspace__pgthresh) && !defined(__polyspace_no__pgthresh)
#include <sys/vmparam.h>
#undef _pgthresh
  extern const unsigned long _pgthresh;
#endif

#if defined(__polyspace__maxslp) && !defined(__polyspace_no__maxslp)
#include <sys/vmparam.h>
#undef _maxslp
  extern const unsigned int _maxslp;
#endif

#if defined(__polyspace__maxhandspreadpages) && !defined(__polyspace_no__maxhandspreadpages)
#include <sys/vmparam.h>
#undef _maxhandspreadpages
  extern const unsigned long _maxhandspreadpages;
#endif

#if defined(__polyspace_avefree) && !defined(__polyspace_no_avefree)
#include <sys/vmsystm.h>
#undef avefree
  extern pgcnt_t avefree;
#endif

#if defined(__polyspace_avefree30) && !defined(__polyspace_no_avefree30)
#include <sys/vmsystm.h>
#undef avefree30
  extern pgcnt_t avefree30;
#endif

#if defined(__polyspace_deficit) && !defined(__polyspace_no_deficit)
#include <sys/vmsystm.h>
#undef deficit
  extern pgcnt_t deficit;
#endif

#if defined(__polyspace_nscan) && !defined(__polyspace_no_nscan)
#include <sys/vmsystm.h>
#undef nscan
  extern pgcnt_t nscan;
#endif

#if defined(__polyspace_desscan) && !defined(__polyspace_no_desscan)
#include <sys/vmsystm.h>
#undef desscan
  extern pgcnt_t desscan;
#endif

#if defined(__polyspace_slowscan) && !defined(__polyspace_no_slowscan)
#include <sys/vmsystm.h>
#undef slowscan
  extern pgcnt_t slowscan;
#endif

#if defined(__polyspace_fastscan) && !defined(__polyspace_no_fastscan)
#include <sys/vmsystm.h>
#undef fastscan
  extern pgcnt_t fastscan;
#endif

#if defined(__polyspace_pushes) && !defined(__polyspace_no_pushes)
#include <sys/vmsystm.h>
#undef pushes
  extern pgcnt_t pushes;
#endif

#if defined(__polyspace_maxpgio) && !defined(__polyspace_no_maxpgio)
#include <sys/vmsystm.h>
#undef maxpgio
  extern pgcnt_t maxpgio;
#endif

#if defined(__polyspace_lotsfree) && !defined(__polyspace_no_lotsfree)
#include <sys/vmsystm.h>
#undef lotsfree
  extern pgcnt_t lotsfree;
#endif

#if defined(__polyspace_desfree) && !defined(__polyspace_no_desfree)
#include <sys/vmsystm.h>
#undef desfree
  extern pgcnt_t desfree;
#endif

#if defined(__polyspace_minfree) && !defined(__polyspace_no_minfree)
#include <sys/vmsystm.h>
#undef minfree
  extern pgcnt_t minfree;
#endif

#if defined(__polyspace_needfree) && !defined(__polyspace_no_needfree)
#include <sys/vmsystm.h>
#undef needfree
  extern pgcnt_t needfree;
#endif

#if defined(__polyspace_throttlefree) && !defined(__polyspace_no_throttlefree)
#include <sys/vmsystm.h>
#undef throttlefree
  extern pgcnt_t throttlefree;
#endif

#if defined(__polyspace_pageout_reserve) && !defined(__polyspace_no_pageout_reserve)
#include <sys/vmsystm.h>
#undef pageout_reserve
  extern pgcnt_t pageout_reserve;
#endif

#if defined(__polyspace_pages_before_pager) && !defined(__polyspace_no_pages_before_pager)
#include <sys/vmsystm.h>
#undef pages_before_pager
  extern pgcnt_t pages_before_pager;
#endif

#if defined(__polyspace_maxslp) && !defined(__polyspace_no_maxslp)
#include <sys/vmsystm.h>
#undef maxslp
  extern int maxslp;
#endif

#if defined(__polyspace_pginrate) && !defined(__polyspace_no_pginrate)
#include <sys/vmsystm.h>
#undef pginrate
  extern ulong_t pginrate;
#endif

#if defined(__polyspace_pgoutrate) && !defined(__polyspace_no_pgoutrate)
#include <sys/vmsystm.h>
#undef pgoutrate
  extern ulong_t pgoutrate;
#endif

#if defined(__polyspace_null_event_map) && !defined(__polyspace_no_null_event_map)
#include <sys/vtrace.h>
#undef null_event_map
  extern uchar_t null_event_map[];
#endif

#if defined(__polyspace_bytes2data) && !defined(__polyspace_no_bytes2data)
#include <sys/vtrace.h>
#undef bytes2data
  extern ulong_t bytes2data[];
#endif

#if defined(__polyspace_tracing_state) && !defined(__polyspace_no_tracing_state)
#include <sys/vtrace.h>
#undef tracing_state
  extern int tracing_state;
#endif

#if defined(__polyspace_watch_copyops) && !defined(__polyspace_no_watch_copyops)
#include <sys/watchpoint.h>
#undef watch_copyops
  extern struct copyops watch_copyops;
#endif

#if defined(__polyspace_zs_soft_lock) && !defined(__polyspace_no_zs_soft_lock)
#include <sys/zsdev.h>
#undef zs_soft_lock
  extern kmutex_t zs_soft_lock;
#endif

#if defined(__polyspace_zssoftpend) && !defined(__polyspace_no_zssoftpend)
#include <sys/zsdev.h>
#undef zssoftpend
  extern int zssoftpend;
#endif

#if defined(__polyspace_zs_softintr_id) && !defined(__polyspace_no_zs_softintr_id)
#include <sys/zsdev.h>
#undef zs_softintr_id
  extern ddi_softintr_t zs_softintr_id;
#endif

#if defined(__polyspace__ns_flagdata) && !defined(__polyspace_no__ns_flagdata)
#include <arpa/nameser.h>
#undef _ns_flagdata
  extern struct _ns_flagdata _ns_flagdata[];
#endif

#if defined(__polyspace_slc_names) && !defined(__polyspace_no_slc_names)
#include <arpa/telnet.h>
#undef slc_names
  extern char *slc_names[];
#endif

#if defined(__polyspace_audit_statistics) && !defined(__polyspace_no_audit_statistics)
#include <bsm/audit.h>
#undef audit_statistics
  extern au_stat_t audit_statistics;
#endif

#if defined(__polyspace_audit_file_stat) && !defined(__polyspace_no_audit_file_stat)
#include <bsm/audit.h>
#undef audit_file_stat
  extern au_fstat_t audit_file_stat;
#endif

#if defined(__polyspace_audit_s2e) && !defined(__polyspace_no_audit_s2e)
#include <bsm/audit_kernel.h>
#undef audit_s2e
  extern struct audit_s2e audit_s2e[];
#endif

#if defined(__polyspace_audit_ets) && !defined(__polyspace_no_audit_ets)
#include <bsm/audit_kernel.h>
#undef audit_ets
  extern au_state_t audit_ets[];
#endif

#if defined(__polyspace_au_wait) && !defined(__polyspace_no_au_wait)
#include <bsm/audit_kernel.h>
#undef au_wait
  extern int au_wait;
#endif

#if defined(__polyspace_aproc) && !defined(__polyspace_no_aproc)
#include <bsm/audit_kernel.h>
#undef aproc
  extern caddr_t *aproc;
#endif

#if defined(__polyspace_afile) && !defined(__polyspace_no_afile)
#include <bsm/audit_kernel.h>
#undef afile
  extern caddr_t *afile;
#endif

#if defined(__polyspace_bsm_dom) && !defined(__polyspace_no_bsm_dom)
#include <bsm/libbsm.h>
#undef bsm_dom
  extern char *bsm_dom;
#endif

#if defined(__polyspace_GSS_C_NT_USER_NAME) && !defined(__polyspace_no_GSS_C_NT_USER_NAME)
#include <gssapi/gssapi.h>
#undef GSS_C_NT_USER_NAME
  extern const gss_OID GSS_C_NT_USER_NAME;
#endif

#if defined(__polyspace_GSS_C_NT_MACHINE_UID_NAME) && !defined(__polyspace_no_GSS_C_NT_MACHINE_UID_NAME)
#include <gssapi/gssapi.h>
#undef GSS_C_NT_MACHINE_UID_NAME
  extern const gss_OID GSS_C_NT_MACHINE_UID_NAME;
#endif

#if defined(__polyspace_GSS_C_NT_STRING_UID_NAME) && !defined(__polyspace_no_GSS_C_NT_STRING_UID_NAME)
#include <gssapi/gssapi.h>
#undef GSS_C_NT_STRING_UID_NAME
  extern const gss_OID GSS_C_NT_STRING_UID_NAME;
#endif

#if defined(__polyspace_GSS_C_NT_HOSTBASED_SERVICE) && !defined(__polyspace_no_GSS_C_NT_HOSTBASED_SERVICE)
#include <gssapi/gssapi.h>
#undef GSS_C_NT_HOSTBASED_SERVICE
  extern const gss_OID GSS_C_NT_HOSTBASED_SERVICE;
#endif

#if defined(__polyspace_GSS_C_NT_ANONYMOUS) && !defined(__polyspace_no_GSS_C_NT_ANONYMOUS)
#include <gssapi/gssapi.h>
#undef GSS_C_NT_ANONYMOUS
  extern const gss_OID GSS_C_NT_ANONYMOUS;
#endif

#if defined(__polyspace_GSS_C_NT_EXPORT_NAME) && !defined(__polyspace_no_GSS_C_NT_EXPORT_NAME)
#include <gssapi/gssapi.h>
#undef GSS_C_NT_EXPORT_NAME
  extern const gss_OID GSS_C_NT_EXPORT_NAME;
#endif

#if defined(__polyspace_arpdevflag) && !defined(__polyspace_no_arpdevflag)
#include <inet/arp.h>
#undef arpdevflag
  extern int arpdevflag;
#endif

#if defined(__polyspace_ill_g_head) && !defined(__polyspace_no_ill_g_head)
#include <inet/ip.h>
#undef ill_g_head
  extern struct ill_s *ill_g_head;
#endif

#if defined(__polyspace_ip_timer_ill) && !defined(__polyspace_no_ip_timer_ill)
#include <inet/ip.h>
#undef ip_timer_ill
  extern ill_t *ip_timer_ill;
#endif

#if defined(__polyspace_ip_timer_mp) && !defined(__polyspace_no_ip_timer_mp)
#include <inet/ip.h>
#undef ip_timer_mp
  extern mblk_t *ip_timer_mp;
#endif

#if defined(__polyspace_ip_ire_time_elapsed) && !defined(__polyspace_no_ip_ire_time_elapsed)
#include <inet/ip.h>
#undef ip_ire_time_elapsed
  extern time_t ip_ire_time_elapsed;
#endif

#if defined(__polyspace_igmp_timer_ill) && !defined(__polyspace_no_igmp_timer_ill)
#include <inet/ip.h>
#undef igmp_timer_ill
  extern ill_t *igmp_timer_ill;
#endif

#if defined(__polyspace_igmp_timer_mp) && !defined(__polyspace_no_igmp_timer_mp)
#include <inet/ip.h>
#undef igmp_timer_mp
  extern mblk_t *igmp_timer_mp;
#endif

#if defined(__polyspace_igmp_timer_interval) && !defined(__polyspace_no_igmp_timer_interval)
#include <inet/ip.h>
#undef igmp_timer_interval
  extern int igmp_timer_interval;
#endif

#if defined(__polyspace_proxy_frag_ill) && !defined(__polyspace_no_proxy_frag_ill)
#include <inet/ip.h>
#undef proxy_frag_ill
  extern ill_t *proxy_frag_ill;
#endif

#if defined(__polyspace_ip_def_gateway_count) && !defined(__polyspace_no_ip_def_gateway_count)
#include <inet/ip.h>
#undef ip_def_gateway_count
  extern uint_t ip_def_gateway_count;
#endif

#if defined(__polyspace_ip_def_gateway_index) && !defined(__polyspace_no_ip_def_gateway_index)
#include <inet/ip.h>
#undef ip_def_gateway_index
  extern uint_t ip_def_gateway_index;
#endif

#if defined(__polyspace_ip_g_all_ones) && !defined(__polyspace_no_ip_g_all_ones)
#include <inet/ip.h>
#undef ip_g_all_ones
  extern ipaddr_t ip_g_all_ones;
#endif

#if defined(__polyspace_ip_g_nd) && !defined(__polyspace_no_ip_g_nd)
#include <inet/ip.h>
#undef ip_g_nd
  extern caddr_t ip_g_nd;
#endif

#if defined(__polyspace_ip_max_mtu) && !defined(__polyspace_no_ip_max_mtu)
#include <inet/ip.h>
#undef ip_max_mtu
  extern int ip_max_mtu;
#endif

#if defined(__polyspace_ip_param_arr) && !defined(__polyspace_no_ip_param_arr)
#include <inet/ip.h>
#undef ip_param_arr
  extern ipparam_t *ip_param_arr;
#endif

#if defined(__polyspace_ip_enable_group_ifs) && !defined(__polyspace_no_ip_enable_group_ifs)
#include <inet/ip.h>
#undef ip_enable_group_ifs
  extern int ip_enable_group_ifs;
#endif

#if defined(__polyspace_dohwcksum) && !defined(__polyspace_no_dohwcksum)
#include <inet/ip.h>
#undef dohwcksum
  extern int dohwcksum;
#endif

#if defined(__polyspace_ipif_g_count) && !defined(__polyspace_no_ipif_g_count)
#include <inet/ip.h>
#undef ipif_g_count
  extern uint_t ipif_g_count;
#endif

#if defined(__polyspace_ire_nv_tbl) && !defined(__polyspace_no_ire_nv_tbl)
#include <inet/ip.h>
#undef ire_nv_tbl
  extern nv_t *ire_nv_tbl;
#endif

#if defined(__polyspace_ipdevflag) && !defined(__polyspace_no_ipdevflag)
#include <inet/ip.h>
#undef ipdevflag
  extern int ipdevflag;
#endif

#if defined(__polyspace_tcpdevflag) && !defined(__polyspace_no_tcpdevflag)
#include <inet/tcp.h>
#undef tcpdevflag
  extern int tcpdevflag;
#endif

#if defined(__polyspace__et_list) && !defined(__polyspace_no__et_list)
#include <kerberos/error_table.h>
#undef _et_list
  extern error_table **_et_list;
#endif

#if defined(__polyspace_LineNbr) && !defined(__polyspace_no_LineNbr)
#include <kerberos/kparse.h>
#undef LineNbr
  extern int LineNbr;
#endif

#if defined(__polyspace_ErrorMsg) && !defined(__polyspace_no_ErrorMsg)
#include <kerberos/kparse.h>
#undef ErrorMsg
  extern char ErrorMsg[];
#endif

#if defined(__polyspace_ip_g_mrouter) && !defined(__polyspace_no_ip_g_mrouter)
#include <netinet/ip_mroute.h>
#undef ip_g_mrouter
  extern queue_t *ip_g_mrouter;
#endif

#if defined(__polyspace_exi_public) && !defined(__polyspace_no_exi_public)
#include <nfs/export.h>
#undef exi_public
  extern struct exportinfo *exi_public;
#endif

#if defined(__polyspace_exi_root) && !defined(__polyspace_no_exi_root)
#include <nfs/export.h>
#undef exi_root
  extern struct exportinfo *exi_root;
#endif

#if defined(__polyspace_nullfh2) && !defined(__polyspace_no_nullfh2)
#include <nfs/export.h>
#undef nullfh2
  extern fhandle_t nullfh2;
#endif

#if defined(__polyspace_lm_sysids_lock) && !defined(__polyspace_no_lm_sysids_lock)
#include <nfs/lm.h>
#undef lm_sysids_lock
  extern krwlock_t lm_sysids_lock;
#endif

#if defined(__polyspace_lm_sa) && !defined(__polyspace_no_lm_sa)
#include <nfs/lm.h>
#undef lm_sa
  extern struct lm_svc_args lm_sa;
#endif

#if defined(__polyspace_lm_stat) && !defined(__polyspace_no_lm_stat)
#include <nfs/lm.h>
#undef lm_stat
  extern struct lm_stat lm_stat;
#endif

#if defined(__polyspace_lm_sysids) && !defined(__polyspace_no_lm_sysids)
#include <nfs/lm.h>
#undef lm_sysids
  extern struct lm_sysid *lm_sysids;
#endif

#if defined(__polyspace_lm_status_cv) && !defined(__polyspace_no_lm_status_cv)
#include <nfs/lm.h>
#undef lm_status_cv
  extern kcondvar_t lm_status_cv;
#endif

#if defined(__polyspace_lm_caches_created) && !defined(__polyspace_no_lm_caches_created)
#include <nfs/lm.h>
#undef lm_caches_created
  extern bool_t  lm_caches_created;
#endif

#if defined(__polyspace_lm_num_outstanding) && !defined(__polyspace_no_lm_num_outstanding)
#include <nfs/lm.h>
#undef lm_num_outstanding
  extern unsigned int lm_num_outstanding;
#endif

#if defined(__polyspace_lm_numconfigs) && !defined(__polyspace_no_lm_numconfigs)
#include <nfs/lm.h>
#undef lm_numconfigs
  extern unsigned int lm_numconfigs;
#endif

#if defined(__polyspace_lm_sysid_len) && !defined(__polyspace_no_lm_sysid_len)
#include <nfs/lm.h>
#undef lm_sysid_len
  extern unsigned int lm_sysid_len;
#endif

#if defined(__polyspace_lm_owner_handle_sys) && !defined(__polyspace_no_lm_owner_handle_sys)
#include <nfs/lm.h>
#undef lm_owner_handle_sys
  extern int lm_owner_handle_sys;
#endif

#if defined(__polyspace_lm_gc_sysids) && !defined(__polyspace_no_lm_gc_sysids)
#include <nfs/lm.h>
#undef lm_gc_sysids
  extern int  lm_gc_sysids;
#endif

#if defined(__polyspace_lm_server_status) && !defined(__polyspace_no_lm_server_status)
#include <nfs/lm_server.h>
#undef lm_server_status
  extern lm_server_status_t lm_server_status;
#endif

#if defined(__polyspace_lm_vnodes_lock) && !defined(__polyspace_no_lm_vnodes_lock)
#include <nfs/lm_server.h>
#undef lm_vnodes_lock
  extern kmutex_t lm_vnodes_lock;
#endif

#if defined(__polyspace_lm_vnode_cache) && !defined(__polyspace_no_lm_vnode_cache)
#include <nfs/lm_server.h>
#undef lm_vnode_cache
  extern struct kmem_cache *lm_vnode_cache;
#endif

#if defined(__polyspace_lm_vnode_len) && !defined(__polyspace_no_lm_vnode_len)
#include <nfs/lm_server.h>
#undef lm_vnode_len
  extern unsigned int lm_vnode_len;
#endif

#if defined(__polyspace_nfs_32_time_ok) && !defined(__polyspace_no_nfs_32_time_ok)
#include <nfs/nfs.h>
#undef nfs_32_time_ok
  extern uint32_t nfs_32_time_ok;
#endif

#if defined(__polyspace_nfs_kstat_lock) && !defined(__polyspace_no_nfs_kstat_lock)
#include <nfs/nfs.h>
#undef nfs_kstat_lock
  extern kmutex_t nfs_kstat_lock;
#endif

#if defined(__polyspace_svstat_ptr) && !defined(__polyspace_no_svstat_ptr)
#include <nfs/nfs.h>
#undef svstat_ptr
  extern kstat_named_t *svstat_ptr;
#endif

#if defined(__polyspace_svstat_ndata) && !defined(__polyspace_no_svstat_ndata)
#include <nfs/nfs.h>
#undef svstat_ndata
  extern uint_t svstat_ndata;
#endif

#if defined(__polyspace_rroklock) && !defined(__polyspace_no_rroklock)
#include <nfs/nfs.h>
#undef rroklock
  extern krwlock_t rroklock;
#endif

#if defined(__polyspace_nf_to_vt) && !defined(__polyspace_no_nf_to_vt)
#include <nfs/nfs.h>
#undef nf_to_vt
  extern vtype_t nf_to_vt[];
#endif

#if defined(__polyspace_rfsproccnt_v2_ptr) && !defined(__polyspace_no_rfsproccnt_v2_ptr)
#include <nfs/nfs.h>
#undef rfsproccnt_v2_ptr
  extern kstat_named_t *rfsproccnt_v2_ptr;
#endif

#if defined(__polyspace_rfsproccnt_v2_ndata) && !defined(__polyspace_no_rfsproccnt_v2_ndata)
#include <nfs/nfs.h>
#undef rfsproccnt_v2_ndata
  extern uint_t rfsproccnt_v2_ndata;
#endif

#if defined(__polyspace_nfs_rtable_lock) && !defined(__polyspace_no_nfs_rtable_lock)
#include <nfs/nfs.h>
#undef nfs_rtable_lock
  extern kmutex_t nfs_rtable_lock;
#endif

#if defined(__polyspace_nfs_minor_lock) && !defined(__polyspace_no_nfs_minor_lock)
#include <nfs/nfs.h>
#undef nfs_minor_lock
  extern kmutex_t nfs_minor_lock;
#endif

#if defined(__polyspace_nfs_major) && !defined(__polyspace_no_nfs_major)
#include <nfs/nfs.h>
#undef nfs_major
  extern int nfs_major;
#endif

#if defined(__polyspace_nfs_minor) && !defined(__polyspace_no_nfs_minor)
#include <nfs/nfs.h>
#undef nfs_minor
  extern int nfs_minor;
#endif

#if defined(__polyspace_clstat_ptr) && !defined(__polyspace_no_clstat_ptr)
#include <nfs/nfs.h>
#undef clstat_ptr
  extern kstat_named_t *clstat_ptr;
#endif

#if defined(__polyspace_clstat_ndata) && !defined(__polyspace_no_clstat_ndata)
#include <nfs/nfs.h>
#undef clstat_ndata
  extern uint_t clstat_ndata;
#endif

#if defined(__polyspace_nfs_client_kstat) && !defined(__polyspace_no_nfs_client_kstat)
#include <nfs/nfs.h>
#undef nfs_client_kstat
  extern kstat_t *nfs_client_kstat;
#endif

#if defined(__polyspace_nfs_server_kstat) && !defined(__polyspace_no_nfs_server_kstat)
#include <nfs/nfs.h>
#undef nfs_server_kstat
  extern kstat_t *nfs_server_kstat;
#endif

#if defined(__polyspace_nfs_vfsops) && !defined(__polyspace_no_nfs_vfsops)
#include <nfs/nfs.h>
#undef nfs_vfsops
  extern struct vfsops nfs_vfsops;
#endif

#if defined(__polyspace_nfs_vnodeops) && !defined(__polyspace_no_nfs_vnodeops)
#include <nfs/nfs.h>
#undef nfs_vnodeops
  extern struct vnodeops nfs_vnodeops;
#endif

#if defined(__polyspace_nfs_notfound) && !defined(__polyspace_no_nfs_notfound)
#include <nfs/nfs.h>
#undef nfs_notfound
  extern vnode_t nfs_notfound;
#endif

#if defined(__polyspace_nfsfstyp) && !defined(__polyspace_no_nfsfstyp)
#include <nfs/nfs.h>
#undef nfsfstyp
  extern int nfsfstyp;
#endif

#if defined(__polyspace_nf3_to_vt) && !defined(__polyspace_no_nf3_to_vt)
#include <nfs/nfs.h>
#undef nf3_to_vt
  extern vtype_t nf3_to_vt[];
#endif

#if defined(__polyspace_rfsproccnt_v3_ptr) && !defined(__polyspace_no_rfsproccnt_v3_ptr)
#include <nfs/nfs.h>
#undef rfsproccnt_v3_ptr
  extern kstat_named_t *rfsproccnt_v3_ptr;
#endif

#if defined(__polyspace_rfsproccnt_v3_ndata) && !defined(__polyspace_no_rfsproccnt_v3_ndata)
#include <nfs/nfs.h>
#undef rfsproccnt_v3_ndata
  extern uint_t rfsproccnt_v3_ndata;
#endif

#if defined(__polyspace_nfs3_vfsops) && !defined(__polyspace_no_nfs3_vfsops)
#include <nfs/nfs.h>
#undef nfs3_vfsops
  extern struct vfsops nfs3_vfsops;
#endif

#if defined(__polyspace_nfs3_vnodeops) && !defined(__polyspace_no_nfs3_vnodeops)
#include <nfs/nfs.h>
#undef nfs3_vnodeops
  extern struct vnodeops nfs3_vnodeops;
#endif

#if defined(__polyspace_nfs3_notfound) && !defined(__polyspace_no_nfs3_notfound)
#include <nfs/nfs.h>
#undef nfs3_notfound
  extern vnode_t nfs3_notfound;
#endif

#if defined(__polyspace_rfs3_do_pre_op_attr) && !defined(__polyspace_no_rfs3_do_pre_op_attr)
#include <nfs/nfs.h>
#undef rfs3_do_pre_op_attr
  extern int rfs3_do_pre_op_attr;
#endif

#if defined(__polyspace_rfs3_do_post_op_attr) && !defined(__polyspace_no_rfs3_do_post_op_attr)
#include <nfs/nfs.h>
#undef rfs3_do_post_op_attr
  extern int rfs3_do_post_op_attr;
#endif

#if defined(__polyspace_nfs_disable_rddir_cache) && !defined(__polyspace_no_nfs_disable_rddir_cache)
#include <nfs/nfs.h>
#undef nfs_disable_rddir_cache
  extern int nfs_disable_rddir_cache;
#endif

#if defined(__polyspace_aclproccnt_v2_ptr) && !defined(__polyspace_no_aclproccnt_v2_ptr)
#include <nfs/nfs_acl.h>
#undef aclproccnt_v2_ptr
  extern kstat_named_t *aclproccnt_v2_ptr;
#endif

#if defined(__polyspace_aclproccnt_v2_ndata) && !defined(__polyspace_no_aclproccnt_v2_ndata)
#include <nfs/nfs_acl.h>
#undef aclproccnt_v2_ndata
  extern uint_t aclproccnt_v2_ndata;
#endif

#if defined(__polyspace_aclproccnt_v3_ptr) && !defined(__polyspace_no_aclproccnt_v3_ptr)
#include <nfs/nfs_acl.h>
#undef aclproccnt_v3_ptr
  extern kstat_named_t *aclproccnt_v3_ptr;
#endif

#if defined(__polyspace_aclproccnt_v3_ndata) && !defined(__polyspace_no_aclproccnt_v3_ndata)
#include <nfs/nfs_acl.h>
#undef aclproccnt_v3_ndata
  extern uint_t aclproccnt_v3_ndata;
#endif

#if defined(__polyspace_aclreqcnt_v2_ptr) && !defined(__polyspace_no_aclreqcnt_v2_ptr)
#include <nfs/nfs_acl.h>
#undef aclreqcnt_v2_ptr
  extern kstat_named_t *aclreqcnt_v2_ptr;
#endif

#if defined(__polyspace_aclreqcnt_v2_ndata) && !defined(__polyspace_no_aclreqcnt_v2_ndata)
#include <nfs/nfs_acl.h>
#undef aclreqcnt_v2_ndata
  extern uint_t aclreqcnt_v2_ndata;
#endif

#if defined(__polyspace_aclnames_v2) && !defined(__polyspace_no_aclnames_v2)
#include <nfs/nfs_acl.h>
#undef aclnames_v2
  extern char *aclnames_v2[];
#endif

#if defined(__polyspace_acl_call_type_v2) && !defined(__polyspace_no_acl_call_type_v2)
#include <nfs/nfs_acl.h>
#undef acl_call_type_v2
  extern char acl_call_type_v2[];
#endif

#if defined(__polyspace_acl_ss_call_type_v2) && !defined(__polyspace_no_acl_ss_call_type_v2)
#include <nfs/nfs_acl.h>
#undef acl_ss_call_type_v2
  extern char acl_ss_call_type_v2[];
#endif

#if defined(__polyspace_acl_timer_type_v2) && !defined(__polyspace_no_acl_timer_type_v2)
#include <nfs/nfs_acl.h>
#undef acl_timer_type_v2
  extern char acl_timer_type_v2[];
#endif

#if defined(__polyspace_aclreqcnt_v3_ptr) && !defined(__polyspace_no_aclreqcnt_v3_ptr)
#include <nfs/nfs_acl.h>
#undef aclreqcnt_v3_ptr
  extern kstat_named_t *aclreqcnt_v3_ptr;
#endif

#if defined(__polyspace_aclreqcnt_v3_ndata) && !defined(__polyspace_no_aclreqcnt_v3_ndata)
#include <nfs/nfs_acl.h>
#undef aclreqcnt_v3_ndata
  extern uint_t aclreqcnt_v3_ndata;
#endif

#if defined(__polyspace_aclnames_v3) && !defined(__polyspace_no_aclnames_v3)
#include <nfs/nfs_acl.h>
#undef aclnames_v3
  extern char *aclnames_v3[];
#endif

#if defined(__polyspace_acl_call_type_v3) && !defined(__polyspace_no_acl_call_type_v3)
#include <nfs/nfs_acl.h>
#undef acl_call_type_v3
  extern char acl_call_type_v3[];
#endif

#if defined(__polyspace_acl_ss_call_type_v3) && !defined(__polyspace_no_acl_ss_call_type_v3)
#include <nfs/nfs_acl.h>
#undef acl_ss_call_type_v3
  extern char acl_ss_call_type_v3[];
#endif

#if defined(__polyspace_acl_timer_type_v3) && !defined(__polyspace_no_acl_timer_type_v3)
#include <nfs/nfs_acl.h>
#undef acl_timer_type_v3
  extern char acl_timer_type_v3[];
#endif

#if defined(__polyspace__null_auth) && !defined(__polyspace_no__null_auth)
#include <rpc/auth.h>
#undef _null_auth
  extern struct opaque_auth _null_auth;
#endif

#if defined(__polyspace_authkern_cache) && !defined(__polyspace_no_authkern_cache)
#include <rpc/auth.h>
#undef authkern_cache
  extern struct kmem_cache *authkern_cache;
#endif

#if defined(__polyspace_authloopback_cache) && !defined(__polyspace_no_authloopback_cache)
#include <rpc/auth.h>
#undef authloopback_cache
  extern struct kmem_cache *authloopback_cache;
#endif

#if defined(__polyspace_loopback_name) && !defined(__polyspace_no_loopback_name)
#include <rpc/auth.h>
#undef loopback_name
  extern char loopback_name[];
#endif

#if defined(__polyspace_authdes_lock) && !defined(__polyspace_no_authdes_lock)
#include <rpc/auth_des.h>
#undef authdes_lock
  extern kmutex_t authdes_lock;
#endif

#if defined(__polyspace_authdes_ops_lock) && !defined(__polyspace_no_authdes_ops_lock)
#include <rpc/auth_des.h>
#undef authdes_ops_lock
  extern kmutex_t authdes_ops_lock;
#endif

#if defined(__polyspace_svcauthdesstats_lock) && !defined(__polyspace_no_svcauthdesstats_lock)
#include <rpc/auth_des.h>
#undef svcauthdesstats_lock
  extern kmutex_t svcauthdesstats_lock;
#endif

#if defined(__polyspace_authkerb_lock) && !defined(__polyspace_no_authkerb_lock)
#include <rpc/auth_kerb.h>
#undef authkerb_lock
  extern kmutex_t authkerb_lock;
#endif

#if defined(__polyspace_svcauthkerbstats_lock) && !defined(__polyspace_no_svcauthkerbstats_lock)
#include <rpc/auth_kerb.h>
#undef svcauthkerbstats_lock
  extern kmutex_t svcauthkerbstats_lock;
#endif

#if defined(__polyspace_rpc_createerr) && !defined(__polyspace_no_rpc_createerr)
#include <rpc/clnt.h>
#undef rpc_createerr
  extern struct rpc_createerr rpc_createerr;
#endif

#if defined(__polyspace_rpc_callerr) && !defined(__polyspace_no_rpc_callerr)
#include <rpc/clnt.h>
#undef rpc_callerr
  extern struct rpc_err rpc_callerr;
#endif

#if defined(__polyspace_krb_err_txt) && !defined(__polyspace_no_krb_err_txt)
#include <rpc/kerb_private.h>
#undef krb_err_txt
  extern char *krb_err_txt[];
#endif

#if defined(__polyspace_rac_senderr) && !defined(__polyspace_no_rac_senderr)
#include <rpc/rac.h>
#undef rac_senderr
  extern struct rpc_err rac_senderr;
#endif

#if defined(__polyspace_svc_pollfd) && !defined(__polyspace_no_svc_pollfd)
#include <rpc/svc.h>
#undef svc_pollfd
  extern pollfd_t *svc_pollfd;
#endif

#if defined(__polyspace_svc_max_pollfd) && !defined(__polyspace_no_svc_max_pollfd)
#include <rpc/svc.h>
#undef svc_max_pollfd
  extern int svc_max_pollfd;
#endif

#if defined(__polyspace_svc_fdset) && !defined(__polyspace_no_svc_fdset)
#include <rpc/svc.h>
#undef svc_fdset
  extern fd_set svc_fdset;
#endif

#if defined(__polyspace__new_svc_fdset) && !defined(__polyspace_no__new_svc_fdset)
#include <rpc/svc.h>
#undef _new_svc_fdset
  extern fd_set _new_svc_fdset;
#endif

#if defined(__polyspace_svc_xports) && !defined(__polyspace_no_svc_xports)
#include <rpc/svc_mt.h>
#undef svc_xports
  extern SVCXPRT **svc_xports;
#endif

#if defined(__polyspace_svc_xdrs) && !defined(__polyspace_no_svc_xdrs)
#include <rpc/svc_mt.h>
#undef svc_xdrs
  extern XDR **svc_xdrs;
#endif

#if defined(__polyspace_svc_mt_mode) && !defined(__polyspace_no_svc_mt_mode)
#include <rpc/svc_mt.h>
#undef svc_mt_mode
  extern int svc_mt_mode;
#endif

#if defined(__polyspace_svc_thr_mutex) && !defined(__polyspace_no_svc_thr_mutex)
#include <rpc/svc_mt.h>
#undef svc_thr_mutex
  extern mutex_t svc_thr_mutex;
#endif

#if defined(__polyspace_svc_thr_fdwait) && !defined(__polyspace_no_svc_thr_fdwait)
#include <rpc/svc_mt.h>
#undef svc_thr_fdwait
  extern cond_t svc_thr_fdwait;
#endif

#if defined(__polyspace_svc_nfds) && !defined(__polyspace_no_svc_nfds)
#include <rpc/svc_mt.h>
#undef svc_nfds
  extern int svc_nfds;
#endif

#if defined(__polyspace_svc_nfds_set) && !defined(__polyspace_no_svc_nfds_set)
#include <rpc/svc_mt.h>
#undef svc_nfds_set
  extern int svc_nfds_set;
#endif

#if defined(__polyspace_svc_max_fd) && !defined(__polyspace_no_svc_max_fd)
#include <rpc/svc_mt.h>
#undef svc_max_fd
  extern int svc_max_fd;
#endif

#if defined(__polyspace_svc_mutex) && !defined(__polyspace_no_svc_mutex)
#include <rpc/svc_mt.h>
#undef svc_mutex
  extern mutex_t svc_mutex;
#endif

#if defined(__polyspace_svc_exit_mutex) && !defined(__polyspace_no_svc_exit_mutex)
#include <rpc/svc_mt.h>
#undef svc_exit_mutex
  extern mutex_t svc_exit_mutex;
#endif

#if defined(__polyspace_svc_pipe) && !defined(__polyspace_no_svc_pipe)
#include <rpc/svc_mt.h>
#undef svc_pipe
  extern int svc_pipe[2];
#endif

#if defined(__polyspace_svc_polling) && !defined(__polyspace_no_svc_polling)
#include <rpc/svc_mt.h>
#undef svc_polling
  extern bool_t svc_polling;
#endif

#if defined(__polyspace_rpc_door_mutex) && !defined(__polyspace_no_rpc_door_mutex)
#include <rpc/svc_mt.h>
#undef rpc_door_mutex
  extern mutex_t rpc_door_mutex;
#endif

#if defined(__polyspace_rpcdrc) && !defined(__polyspace_no_rpcdrc)
#include <rpc/svc_mt.h>
#undef rpcdrc
  extern rpc_doorcalls_t rpcdrc;
#endif

#if defined(__polyspace_rpclog) && !defined(__polyspace_no_rpclog)
#include <rpc/types.h>
#undef rpclog
  extern uint_t rpclog;
#endif

#if defined(__polyspace___nsl_dom) && !defined(__polyspace_no___nsl_dom)
#include <rpc/types.h>
#undef __nsl_dom
  extern const char __nsl_dom[];
#endif

#if defined(__polyspace_xdrmblk_ops) && !defined(__polyspace_no_xdrmblk_ops)
#include <rpc/xdr.h>
#undef xdrmblk_ops
  extern struct xdr_ops xdrmblk_ops;
#endif

#if defined(__polyspace_SKI_MD4_OID) && !defined(__polyspace_no_SKI_MD4_OID)
#include <security/ski.h>
#undef SKI_MD4_OID
  extern ski_oid *SKI_MD4_OID;
#endif

#if defined(__polyspace_SKI_MD5_OID) && !defined(__polyspace_no_SKI_MD5_OID)
#include <security/ski.h>
#undef SKI_MD5_OID
  extern ski_oid *SKI_MD5_OID;
#endif

#if defined(__polyspace_SKI_SHA_1_OID) && !defined(__polyspace_no_SKI_SHA_1_OID)
#include <security/ski.h>
#undef SKI_SHA_1_OID
  extern ski_oid *SKI_SHA_1_OID;
#endif

#if defined(__polyspace_SKI_RSA_ENCR_OID) && !defined(__polyspace_no_SKI_RSA_ENCR_OID)
#include <security/ski.h>
#undef SKI_RSA_ENCR_OID
  extern ski_oid *SKI_RSA_ENCR_OID;
#endif

#if defined(__polyspace_SKI_MD2WithRSAEncryption_OID) && !defined(__polyspace_no_SKI_MD2WithRSAEncryption_OID)
#include <security/ski.h>
#undef SKI_MD2WithRSAEncryption_OID
  extern ski_oid *SKI_MD2WithRSAEncryption_OID;
#endif

#if defined(__polyspace_SKI_MD5WithRSAEncryption_OID) && !defined(__polyspace_no_SKI_MD5WithRSAEncryption_OID)
#include <security/ski.h>
#undef SKI_MD5WithRSAEncryption_OID
  extern ski_oid *SKI_MD5WithRSAEncryption_OID;
#endif

#if defined(__polyspace_SKI_DES_ECB_OID) && !defined(__polyspace_no_SKI_DES_ECB_OID)
#include <security/ski.h>
#undef SKI_DES_ECB_OID
  extern ski_oid *SKI_DES_ECB_OID;
#endif

#if defined(__polyspace_SKI_DES_CBC_OID) && !defined(__polyspace_no_SKI_DES_CBC_OID)
#include <security/ski.h>
#undef SKI_DES_CBC_OID
  extern ski_oid *SKI_DES_CBC_OID;
#endif

#if defined(__polyspace_SKI_DES3_CBC_OID) && !defined(__polyspace_no_SKI_DES3_CBC_OID)
#include <security/ski.h>
#undef SKI_DES3_CBC_OID
  extern ski_oid *SKI_DES3_CBC_OID;
#endif

#if defined(__polyspace_SKI_DES_MAC_OID) && !defined(__polyspace_no_SKI_DES_MAC_OID)
#include <security/ski.h>
#undef SKI_DES_MAC_OID
  extern ski_oid *SKI_DES_MAC_OID;
#endif

#if defined(__polyspace_SKI_RC2_CBC_OID) && !defined(__polyspace_no_SKI_RC2_CBC_OID)
#include <security/ski.h>
#undef SKI_RC2_CBC_OID
  extern ski_oid *SKI_RC2_CBC_OID;
#endif

#if defined(__polyspace_SKI_RC4_OID) && !defined(__polyspace_no_SKI_RC4_OID)
#include <security/ski.h>
#undef SKI_RC4_OID
  extern ski_oid *SKI_RC4_OID;
#endif

#if defined(__polyspace_SKI_PbeWithMD2AndDES_CBC_OID) && !defined(__polyspace_no_SKI_PbeWithMD2AndDES_CBC_OID)
#include <security/ski.h>
#undef SKI_PbeWithMD2AndDES_CBC_OID
  extern ski_oid *SKI_PbeWithMD2AndDES_CBC_OID;
#endif

#if defined(__polyspace_SKI_PbeWithMD5AndDES_CBC_OID) && !defined(__polyspace_no_SKI_PbeWithMD5AndDES_CBC_OID)
#include <security/ski.h>
#undef SKI_PbeWithMD5AndDES_CBC_OID
  extern ski_oid *SKI_PbeWithMD5AndDES_CBC_OID;
#endif

#if defined(__polyspace_SKI_RSA_ENCR_AID) && !defined(__polyspace_no_SKI_RSA_ENCR_AID)
#include <security/ski.h>
#undef SKI_RSA_ENCR_AID
  extern struct ski_algid *SKI_RSA_ENCR_AID;
#endif

#if defined(__polyspace_SKI_MD2WithRSAEncryption_AID) && !defined(__polyspace_no_SKI_MD2WithRSAEncryption_AID)
#include <security/ski.h>
#undef SKI_MD2WithRSAEncryption_AID
  extern struct ski_algid *SKI_MD2WithRSAEncryption_AID;
#endif

#if defined(__polyspace_SKI_MD5WithRSAEncryption_AID) && !defined(__polyspace_no_SKI_MD5WithRSAEncryption_AID)
#include <security/ski.h>
#undef SKI_MD5WithRSAEncryption_AID
  extern struct ski_algid *SKI_MD5WithRSAEncryption_AID;
#endif

#if defined(__polyspace_SKI_MD2_AID) && !defined(__polyspace_no_SKI_MD2_AID)
#include <security/ski.h>
#undef SKI_MD2_AID
  extern struct ski_algid *SKI_MD2_AID;
#endif

#if defined(__polyspace_SKI_MD4_AID) && !defined(__polyspace_no_SKI_MD4_AID)
#include <security/ski.h>
#undef SKI_MD4_AID
  extern struct ski_algid *SKI_MD4_AID;
#endif

#if defined(__polyspace_SKI_MD5_AID) && !defined(__polyspace_no_SKI_MD5_AID)
#include <security/ski.h>
#undef SKI_MD5_AID
  extern struct ski_algid *SKI_MD5_AID;
#endif

#if defined(__polyspace_SKI_RC4_AID) && !defined(__polyspace_no_SKI_RC4_AID)
#include <security/ski.h>
#undef SKI_RC4_AID
  extern struct ski_algid *SKI_RC4_AID;
#endif

#if defined(__polyspace_trap_trace_ctl) && !defined(__polyspace_no_trap_trace_ctl)
#include <v9/sys/traptrace.h>
#undef trap_trace_ctl
  extern TRAP_TRACE_CTL trap_trace_ctl[];
#endif

#if defined(__polyspace_trap_trace_bufsize) && !defined(__polyspace_no_trap_trace_bufsize)
#include <v9/sys/traptrace.h>
#undef trap_trace_bufsize
  extern int trap_trace_bufsize;
#endif

#if defined(__polyspace_trap_tr0) && !defined(__polyspace_no_trap_tr0)
#include <v9/sys/traptrace.h>
#undef trap_tr0
  extern char trap_tr0[];
#endif

#if defined(__polyspace_trap_freeze) && !defined(__polyspace_no_trap_freeze)
#include <v9/sys/traptrace.h>
#undef trap_freeze
  extern int trap_freeze;
#endif

#if defined(__polyspace_ttrace_buf) && !defined(__polyspace_no_ttrace_buf)
#include <v9/sys/traptrace.h>
#undef ttrace_buf
  extern caddr_t ttrace_buf;
#endif

#if defined(__polyspace_ttrace_index) && !defined(__polyspace_no_ttrace_index)
#include <v9/sys/traptrace.h>
#undef ttrace_index
  extern int ttrace_index;
#endif

#if defined(__polyspace_anoninfo_lock) && !defined(__polyspace_no_anoninfo_lock)
#include <vm/anon.h>
#undef anoninfo_lock
  extern kmutex_t anoninfo_lock;
#endif

#if defined(__polyspace_swapinfo_lock) && !defined(__polyspace_no_swapinfo_lock)
#include <vm/anon.h>
#undef swapinfo_lock
  extern kmutex_t swapinfo_lock;
#endif

#if defined(__polyspace_anonhash_lock) && !defined(__polyspace_no_anonhash_lock)
#include <vm/anon.h>
#undef anonhash_lock
  extern kmutex_t anonhash_lock[];
#endif

#if defined(__polyspace_anon_hash_size) && !defined(__polyspace_no_anon_hash_size)
#include <vm/anon.h>
#undef anon_hash_size
  extern size_t anon_hash_size;
#endif

#if defined(__polyspace_anon_hash) && !defined(__polyspace_no_anon_hash)
#include <vm/anon.h>
#undef anon_hash
  extern struct anon **anon_hash;
#endif

#if defined(__polyspace_ani_free_pool) && !defined(__polyspace_no_ani_free_pool)
#include <vm/anon.h>
#undef ani_free_pool
  extern ani_free_t ani_free_pool[];
#endif

#if defined(__polyspace_k_anoninfo) && !defined(__polyspace_no_k_anoninfo)
#include <vm/anon.h>
#undef k_anoninfo
  extern struct k_anoninfo k_anoninfo;
#endif

#if defined(__polyspace_anon_debug) && !defined(__polyspace_no_anon_debug)
#include <vm/anon.h>
#undef anon_debug
  extern int anon_debug;
#endif

#if defined(__polyspace_ph_mutex) && !defined(__polyspace_no_ph_mutex)
#include <vm/page.h>
#undef ph_mutex
  extern kmutex_t ph_mutex[];
#endif

#if defined(__polyspace_ph_mutex_shift) && !defined(__polyspace_no_ph_mutex_shift)
#include <vm/page.h>
#undef ph_mutex_shift
  extern uint_t ph_mutex_shift;
#endif

#if defined(__polyspace_page_hashsz) && !defined(__polyspace_no_page_hashsz)
#include <vm/page.h>
#undef page_hashsz
  extern long page_hashsz;
#endif

#if defined(__polyspace_page_hash) && !defined(__polyspace_no_page_hash)
#include <vm/page.h>
#undef page_hash
  extern page_t **page_hash;
#endif

#if defined(__polyspace_page_llock) && !defined(__polyspace_no_page_llock)
#include <vm/page.h>
#undef page_llock
  extern kmutex_t page_llock;
#endif

#if defined(__polyspace_freemem_lock) && !defined(__polyspace_no_freemem_lock)
#include <vm/page.h>
#undef freemem_lock
  extern kmutex_t freemem_lock;
#endif

#if defined(__polyspace_total_pages) && !defined(__polyspace_no_total_pages)
#include <vm/page.h>
#undef total_pages
  extern pgcnt_t total_pages;
#endif

#if defined(__polyspace_pages_pp_maximum) && !defined(__polyspace_no_pages_pp_maximum)
#include <vm/page.h>
#undef pages_pp_maximum
  extern pgcnt_t pages_pp_maximum;
#endif

#if defined(__polyspace_seg_preapahead) && !defined(__polyspace_no_seg_preapahead)
#include <vm/seg.h>
#undef seg_preapahead
  extern int seg_preapahead;
#endif

#if defined(__polyspace_segplckstat) && !defined(__polyspace_no_segplckstat)
#include <vm/seg.h>
#undef segplckstat
  extern segplckstat_t segplckstat;
#endif

#if defined(__polyspace_segkp) && !defined(__polyspace_no_segkp)
#include <vm/seg_kp.h>
#undef segkp
  extern struct seg *segkp;
#endif

#if defined(__polyspace_segkmap) && !defined(__polyspace_no_segkmap)
#include <vm/seg_map.h>
#undef segkmap
  extern struct seg *segkmap;
#endif

#if defined(__polyspace_segvn_ops) && !defined(__polyspace_no_segvn_ops)
#include <vm/seg_vn.h>
#undef segvn_ops
  extern struct seg_ops segvn_ops;
#endif

#if defined(__polyspace_zfod_argsp) && !defined(__polyspace_no_zfod_argsp)
#include <vm/seg_vn.h>
#undef zfod_argsp
  extern caddr_t zfod_argsp;
#endif

#if defined(__polyspace_kzfod_argsp) && !defined(__polyspace_no_kzfod_argsp)
#include <vm/seg_vn.h>
#undef kzfod_argsp
  extern caddr_t kzfod_argsp;
#endif

#if defined(__polyspace_LINES) && !defined(__polyspace_no_LINES)
#include <curses.h>
#undef LINES
  extern int LINES;
#endif

#if defined(__polyspace_COLS) && !defined(__polyspace_no_COLS)
#include <curses.h>
#undef COLS
  extern int COLS;
#endif

#if defined(__polyspace_TABSIZE) && !defined(__polyspace_no_TABSIZE)
#include <curses.h>
#undef TABSIZE
  extern int TABSIZE;
#endif

#if defined(__polyspace_COLORS) && !defined(__polyspace_no_COLORS)
#include <curses.h>
#undef COLORS
  extern int COLORS;
#endif

#if defined(__polyspace_COLOR_PAIRS) && !defined(__polyspace_no_COLOR_PAIRS)
#include <curses.h>
#undef COLOR_PAIRS
  extern int COLOR_PAIRS;
#endif

#if defined(__polyspace_curs_errno) && !defined(__polyspace_no_curs_errno)
#include <curses.h>
#undef curs_errno
  extern short curs_errno;
#endif

#if defined(__polyspace_stdscr) && !defined(__polyspace_no_stdscr)
#include <curses.h>
#undef stdscr
  extern WINDOW *stdscr;
#endif

#if defined(__polyspace_curscr) && !defined(__polyspace_no_curscr)
#include <curses.h>
#undef curscr
  extern WINDOW *curscr;
#endif

#if defined(__polyspace_Mouse_status) && !defined(__polyspace_no_Mouse_status)
#include <curses.h>
#undef Mouse_status
  extern MOUSE_STATUS Mouse_status;
#endif

#if defined(__polyspace_ttytype) && !defined(__polyspace_no_ttytype)
#include <curses.h>
#undef ttytype
  extern char ttytype[];
#endif

#if defined(__polyspace_curs_parm_err) && !defined(__polyspace_no_curs_parm_err)
#include <curses.h>
#undef curs_parm_err
  extern char curs_parm_err[];
#endif

#if defined(__polyspace_curs_err_strings) && !defined(__polyspace_no_curs_err_strings)
#include <curses.h>
#undef curs_err_strings
  extern char *curs_err_strings[];
#endif

#if defined(__polyspace_acs_map) && !defined(__polyspace_no_acs_map)
#include <curses.h>
#undef acs_map
  extern _ochtype *acs_map;
#endif

#if defined(__polyspace_acs32map) && !defined(__polyspace_no_acs32map)
#include <curses.h>
#undef acs32map
  extern chtype *acs32map;
#endif

#if defined(__polyspace_Ffile) && !defined(__polyspace_no_Ffile)
#include <fatal.h>
#undef Ffile
  extern char *Ffile;
#endif

#if defined(__polyspace_Fvalue) && !defined(__polyspace_no_Fvalue)
#include <fatal.h>
#undef Fvalue
  extern int Fvalue;
#endif

#if defined(__polyspace_Fjmp) && !defined(__polyspace_no_Fjmp)
#include <fatal.h>
#undef Fjmp
  extern int Fjmp[10];
#endif

#if defined(__polyspace_TYPE_ALPHA) && !defined(__polyspace_no_TYPE_ALPHA)
#include <form.h>
#undef TYPE_ALPHA
  extern FIELDTYPE * TYPE_ALPHA;
#endif

#if defined(__polyspace_TYPE_ALNUM) && !defined(__polyspace_no_TYPE_ALNUM)
#include <form.h>
#undef TYPE_ALNUM
  extern FIELDTYPE * TYPE_ALNUM;
#endif

#if defined(__polyspace_TYPE_ENUM) && !defined(__polyspace_no_TYPE_ENUM)
#include <form.h>
#undef TYPE_ENUM
  extern FIELDTYPE * TYPE_ENUM;
#endif

#if defined(__polyspace_TYPE_INTEGER) && !defined(__polyspace_no_TYPE_INTEGER)
#include <form.h>
#undef TYPE_INTEGER
  extern FIELDTYPE * TYPE_INTEGER;
#endif

#if defined(__polyspace_TYPE_NUMERIC) && !defined(__polyspace_no_TYPE_NUMERIC)
#include <form.h>
#undef TYPE_NUMERIC
  extern FIELDTYPE * TYPE_NUMERIC;
#endif

#if defined(__polyspace_TYPE_REGEXP) && !defined(__polyspace_no_TYPE_REGEXP)
#include <form.h>
#undef TYPE_REGEXP
  extern FIELDTYPE * TYPE_REGEXP;
#endif

#if defined(__polyspace__DEFAULT_FORM) && !defined(__polyspace_no__DEFAULT_FORM)
#include <form.h>
#undef _DEFAULT_FORM
  extern FORM * _DEFAULT_FORM;
#endif

#if defined(__polyspace__DEFAULT_FIELD) && !defined(__polyspace_no__DEFAULT_FIELD)
#include <form.h>
#undef _DEFAULT_FIELD
  extern FIELD * _DEFAULT_FIELD;
#endif

#if defined(__polyspace___loc1) && !defined(__polyspace_no___loc1)
#include <libgen.h>
#undef __loc1
  extern char *__loc1;
#endif

#if defined(__polyspace___i_size) && !defined(__polyspace_no___i_size)
#include <libgen.h>
#undef __i_size
  extern int __i_size;
#endif

#if defined(__polyspace_Null) && !defined(__polyspace_no_Null)
#include <macros.h>
#undef Null
  extern char Null[1];
#endif

#if defined(__polyspace_Error) && !defined(__polyspace_no_Error)
#include <macros.h>
#undef Error
  extern char Error[128];
#endif

#if defined(__polyspace_h_errno) && !defined(__polyspace_no_h_errno)
#include <netdb.h>
#undef h_errno
  extern int h_errno;
#endif

#if defined(__polyspace__nderror) && !defined(__polyspace_no__nderror)
#include <netdir.h>
#undef _nderror
  extern int _nderror;
#endif

#if defined(__polyspace_nss_default_finders) && !defined(__polyspace_no_nss_default_finders)
#include <nss_common.h>
#undef nss_default_finders
  extern nss_backend_finder_t *nss_default_finders;
#endif

#if defined(__polyspace_pkgdir) && !defined(__polyspace_no_pkgdir)
#include <pkginfo.h>
#undef pkgdir
  extern char *pkgdir;
#endif

#if defined(__polyspace_braslist) && !defined(__polyspace_no_braslist)
#include <regexpr.h>
#undef braslist
  extern char *braslist[NBRA];
#endif

#if defined(__polyspace_braelist) && !defined(__polyspace_no_braelist)
#include <regexpr.h>
#undef braelist
  extern char *braelist[NBRA];
#endif

#if defined(__polyspace_nbra) && !defined(__polyspace_no_nbra)
#include <regexpr.h>
#undef nbra
  extern int nbra;
#endif

#if defined(__polyspace_regerrno) && !defined(__polyspace_no_regerrno)
#include <regexpr.h>
#undef regerrno
  extern int regerrno;
#endif

#if defined(__polyspace_reglength) && !defined(__polyspace_no_reglength)
#include <regexpr.h>
#undef reglength
  extern int reglength;
#endif

#if defined(__polyspace_loc1) && !defined(__polyspace_no_loc1)
#include <regexpr.h>
#undef loc1
  extern char *loc1;
#endif

#if defined(__polyspace_loc2) && !defined(__polyspace_no_loc2)
#include <regexpr.h>
#undef loc2
  extern char *loc2;
#endif

#if defined(__polyspace_locs) && !defined(__polyspace_no_locs)
#include <regexpr.h>
#undef locs
  extern char *locs;
#endif

#if defined(__polyspace__res) && !defined(__polyspace_no__res)
#include <resolv.h>
#undef _res
  extern struct __res_state _res;
#endif

#if defined(__polyspace___p_class_syms) && !defined(__polyspace_no___p_class_syms)
#include <resolv.h>
#undef __p_class_syms
  extern const struct res_sym __p_class_syms[];
#endif

#if defined(__polyspace___p_type_syms) && !defined(__polyspace_no___p_type_syms)
#include <resolv.h>
#undef __p_type_syms
  extern const struct res_sym __p_type_syms[];
#endif

#if defined(__polyspace__sys_illlist) && !defined(__polyspace_no__sys_illlist)
#include <siginfo.h>
#undef _sys_illlist
  extern const char * _sys_illlist[];
#endif

#if defined(__polyspace__sys_fpelist) && !defined(__polyspace_no__sys_fpelist)
#include <siginfo.h>
#undef _sys_fpelist
  extern const char * _sys_fpelist[];
#endif

#if defined(__polyspace__sys_segvlist) && !defined(__polyspace_no__sys_segvlist)
#include <siginfo.h>
#undef _sys_segvlist
  extern const char * _sys_segvlist[];
#endif

#if defined(__polyspace__sys_buslist) && !defined(__polyspace_no__sys_buslist)
#include <siginfo.h>
#undef _sys_buslist
  extern const char * _sys_buslist[];
#endif

#if defined(__polyspace__sys_traplist) && !defined(__polyspace_no__sys_traplist)
#include <siginfo.h>
#undef _sys_traplist
  extern const char * _sys_traplist[];
#endif

#if defined(__polyspace__sys_cldlist) && !defined(__polyspace_no__sys_cldlist)
#include <siginfo.h>
#undef _sys_cldlist
  extern const char * _sys_cldlist[];
#endif

#if defined(__polyspace__sys_siginfolistp) && !defined(__polyspace_no__sys_siginfolistp)
#include <siginfo.h>
#undef _sys_siginfolistp
  extern const struct siginfolist *_sys_siginfolistp;
#endif

#if defined(__polyspace_nullsmask) && !defined(__polyspace_no_nullsmask)
#include <sys/signal.h>
#undef nullsmask
  extern k_sigset_t nullsmask;
#endif

#if defined(__polyspace_fillset) && !defined(__polyspace_no_fillset)
#include <sys/signal.h>
#undef fillset
  extern k_sigset_t  fillset;
#endif

#if defined(__polyspace_holdvfork) && !defined(__polyspace_no_holdvfork)
#include <sys/signal.h>
#undef holdvfork
  extern k_sigset_t  holdvfork;
#endif

#if defined(__polyspace_cantmask) && !defined(__polyspace_no_cantmask)
#include <sys/signal.h>
#undef cantmask
  extern k_sigset_t  cantmask;
#endif

#if defined(__polyspace_cantreset) && !defined(__polyspace_no_cantreset)
#include <sys/signal.h>
#undef cantreset
  extern k_sigset_t  cantreset;
#endif

#if defined(__polyspace_ignoredefault) && !defined(__polyspace_no_ignoredefault)
#include <sys/signal.h>
#undef ignoredefault
  extern k_sigset_t  ignoredefault;
#endif

#if defined(__polyspace_stopdefault) && !defined(__polyspace_no_stopdefault)
#include <sys/signal.h>
#undef stopdefault
  extern k_sigset_t  stopdefault;
#endif

#if defined(__polyspace_coredefault) && !defined(__polyspace_no_coredefault)
#include <sys/signal.h>
#undef coredefault
  extern k_sigset_t  coredefault;
#endif

#if defined(__polyspace_cur_term) && !defined(__polyspace_no_cur_term)
#include <term.h>
#undef cur_term
  extern TERMINAL *cur_term;
#endif

#if defined(__polyspace_cur_bools) && !defined(__polyspace_no_cur_bools)
#include <term.h>
#undef cur_bools
  extern struct _bool_struct *cur_bools;
#endif

#if defined(__polyspace_cur_nums) && !defined(__polyspace_no_cur_nums)
#include <term.h>
#undef cur_nums
  extern struct _num_struct *cur_nums;
#endif

#if defined(__polyspace_cur_strs) && !defined(__polyspace_no_cur_strs)
#include <term.h>
#undef cur_strs
  extern struct _str_struct *cur_strs;
#endif

#if defined(__polyspace__first_term) && !defined(__polyspace_no__first_term)
#include <term.h>
#undef _first_term
  extern TERMINAL _first_term;
#endif

#if defined(__polyspace__frst_bools) && !defined(__polyspace_no__frst_bools)
#include <term.h>
#undef _frst_bools
  extern struct _bool_struct _frst_bools;
#endif

#if defined(__polyspace__frst_nums) && !defined(__polyspace_no__frst_nums)
#include <term.h>
#undef _frst_nums
  extern struct _num_struct _frst_nums;
#endif

#if defined(__polyspace__frst_strs) && !defined(__polyspace_no__frst_strs)
#include <term.h>
#undef _frst_strs
  extern struct _str_struct _frst_strs;
#endif

#if defined(__polyspace_term_errno) && !defined(__polyspace_no_term_errno)
#include <term.h>
#undef term_errno
  extern short term_errno;
#endif

#if defined(__polyspace_prog_istermios) && !defined(__polyspace_no_prog_istermios)
#include <term.h>
#undef prog_istermios
  extern int prog_istermios;
#endif

#if defined(__polyspace_shell_istermios) && !defined(__polyspace_no_shell_istermios)
#include <term.h>
#undef shell_istermios
  extern int shell_istermios;
#endif

#if defined(__polyspace_term_parm_err) && !defined(__polyspace_no_term_parm_err)
#include <term.h>
#undef term_parm_err
  extern char term_parm_err[];
#endif

#if defined(__polyspace_term_err_strings) && !defined(__polyspace_no_term_err_strings)
#include <term.h>
#undef term_err_strings
  extern char *term_err_strings[];
#endif

#if defined(__polyspace_Def_term) && !defined(__polyspace_no_Def_term)
#include <term.h>
#undef Def_term
  extern char *Def_term;
#endif

#if defined(__polyspace_boolnames) && !defined(__polyspace_no_boolnames)
#include <term.h>
#undef boolnames
  extern char *boolnames[];
#endif

#if defined(__polyspace_boolcodes) && !defined(__polyspace_no_boolcodes)
#include <term.h>
#undef boolcodes
  extern char *boolcodes[];
#endif

#if defined(__polyspace_boolfnames) && !defined(__polyspace_no_boolfnames)
#include <term.h>
#undef boolfnames
  extern char *boolfnames[];
#endif

#if defined(__polyspace_numnames) && !defined(__polyspace_no_numnames)
#include <term.h>
#undef numnames
  extern char *numnames[];
#endif

#if defined(__polyspace_numcodes) && !defined(__polyspace_no_numcodes)
#include <term.h>
#undef numcodes
  extern char *numcodes[];
#endif

#if defined(__polyspace_numfnames) && !defined(__polyspace_no_numfnames)
#include <term.h>
#undef numfnames
  extern char *numfnames[];
#endif

#if defined(__polyspace_strnames) && !defined(__polyspace_no_strnames)
#include <term.h>
#undef strnames
  extern char *strnames[];
#endif

#if defined(__polyspace_strcodes) && !defined(__polyspace_no_strcodes)
#include <term.h>
#undef strcodes
  extern char *strcodes[];
#endif

#if defined(__polyspace_strfnames) && !defined(__polyspace_no_strfnames)
#include <term.h>
#undef strfnames
  extern char *strfnames[];
#endif

#if defined(__polyspace_t_errno) && !defined(__polyspace_no_t_errno)
#include <tiuser.h>
#undef t_errno
  extern int t_errno;
#endif

#if defined(__polyspace_lber_debug) && !defined(__polyspace_no_lber_debug)
#include <lber.h>
#undef lber_debug
  extern int lber_debug;
#endif

#if defined(__polyspace_slapdcat) && !defined(__polyspace_no_slapdcat)
#include <lber.h>
#undef slapdcat
  extern nl_catd slapdcat;
#endif

#if defined(__polyspace_ldap_debug) && !defined(__polyspace_no_ldap_debug)
#include <ldap.h>
#undef ldap_debug
  extern int ldap_debug;
#endif

#if defined(__polyspace_ldap_syslog) && !defined(__polyspace_no_ldap_syslog)
#include <ldap.h>
#undef ldap_syslog
  extern int ldap_syslog;
#endif

#if defined(__polyspace_ldap_syslog_level) && !defined(__polyspace_no_ldap_syslog_level)
#include <ldap.h>
#undef ldap_syslog_level
  extern int ldap_syslog_level;
#endif


/****************************************************************************
 *  NON-STD LIBRARIES - OS-TARGET VXWORKS
 ****************************************************************************/
#elif defined(__OS_VXWORKS)


#if defined(__polyspace_excExcepHook) && !defined(__polyspace_no_excExcepHook)
#include <arch/ppc/excPpcLib.h>
#undef excExcepHook
  extern FUNCPTR excExcepHook;
#endif

#if defined(__polyspace_fpRegName) && !defined(__polyspace_no_fpRegName)
#include <arch/ppc/fppPpcLib.h>
#undef fpRegName
  extern REG_INDEX fpRegName[];
#endif

#if defined(__polyspace_fpCtlRegName) && !defined(__polyspace_no_fpCtlRegName)
#include <arch/ppc/fppPpcLib.h>
#undef fpCtlRegName
  extern REG_INDEX fpCtlRegName[];
#endif

#if defined(__polyspace_pFppTaskIdPrevious) && !defined(__polyspace_no_pFppTaskIdPrevious)
#include <arch/ppc/fppPpcLib.h>
#undef pFppTaskIdPrevious
  extern WIND_TCB *pFppTaskIdPrevious;
#endif

#if defined(__polyspace_fppCreateHookRtn) && !defined(__polyspace_no_fppCreateHookRtn)
#include <arch/ppc/fppPpcLib.h>
#undef fppCreateHookRtn
  extern FUNCPTR fppCreateHookRtn;
#endif

#if defined(__polyspace_fppDisplayHookRtn) && !defined(__polyspace_no_fppDisplayHookRtn)
#include <arch/ppc/fppPpcLib.h>
#undef fppDisplayHookRtn
  extern FUNCPTR fppDisplayHookRtn;
#endif

#if defined(__polyspace_) && !defined(__polyspace_no_)
#include <arch/mc68k/excMc68kLib.h>
#undef 
  extern int excBsrTbl [];
#endif

#if defined(__polyspace_classClassId) && !defined(__polyspace_no_classClassId)
#include <classLib.h>
#undef classClassId
  extern CLASS_ID classClassId;
#endif

#if defined(__polyspace_nbind) && !defined(__polyspace_no_nbind)
#include <dhcp/common.h>
#undef nbind
  extern int nbind;
#endif

#if defined(__polyspace_dhcps_port) && !defined(__polyspace_no_dhcps_port)
#include <dhcp/common.h>
#undef dhcps_port
  extern u_short dhcps_port;
#endif

#if defined(__polyspace_dhcpc_port) && !defined(__polyspace_no_dhcpc_port)
#include <dhcp/common.h>
#undef dhcpc_port
  extern u_short dhcpc_port;
#endif

#if defined(__polyspace_rbpf) && !defined(__polyspace_no_rbpf)
#include <dhcp/common.h>
#undef rbpf
  extern struct bpf_hdr *rbpf;
#endif

#if defined(__polyspace_reslist) && !defined(__polyspace_no_reslist)
#include <dhcp/dhcps.h>
#undef reslist
  extern struct hash_member *reslist;
#endif

#if defined(__polyspace_bindlist) && !defined(__polyspace_no_bindlist)
#include <dhcp/dhcps.h>
#undef bindlist
  extern struct hash_member *bindlist;
#endif

#if defined(__polyspace_cidhashtable) && !defined(__polyspace_no_cidhashtable)
#include <dhcp/dhcps.h>
#undef cidhashtable
  extern struct hash_tbl  cidhashtable;
#endif

#if defined(__polyspace_iphashtable) && !defined(__polyspace_no_iphashtable)
#include <dhcp/dhcps.h>
#undef iphashtable
  extern struct hash_tbl  iphashtable;
#endif

#if defined(__polyspace_relayhashtable) && !defined(__polyspace_no_relayhashtable)
#include <dhcp/dhcps.h>
#undef relayhashtable
  extern struct hash_tbl  relayhashtable;
#endif

#if defined(__polyspace_paramhashtable) && !defined(__polyspace_no_paramhashtable)
#include <dhcp/dhcps.h>
#undef paramhashtable
  extern struct hash_tbl  paramhashtable;
#endif

#if defined(__polyspace_dosFsUserId) && !defined(__polyspace_no_dosFsUserId)
#include <dosFsLib.h>
#undef dosFsUserId
  extern int  dosFsUserId;
#endif

#if defined(__polyspace_dosFsGroupId) && !defined(__polyspace_no_dosFsGroupId)
#include <dosFsLib.h>
#undef dosFsGroupId
  extern int  dosFsGroupId;
#endif

#if defined(__polyspace_pNcr5390IfTbl) && !defined(__polyspace_no_pNcr5390IfTbl)
#include <drv/scsi/ncr5390_1.h>
#undef pNcr5390IfTbl
  extern SCSIDRV_FUNC_TBL *pNcr5390IfTbl;
#endif

#if defined(__polyspace_ncr710InitStart) && !defined(__polyspace_no_ncr710InitStart)
#include <drv/scsi/ncr710Script2.h>
#undef ncr710InitStart
  extern ULONG ncr710InitStart[];
#endif

#if defined(__polyspace_ncr710InitContinue) && !defined(__polyspace_no_ncr710InitContinue)
#include <drv/scsi/ncr710Script2.h>
#undef ncr710InitContinue
  extern ULONG ncr710InitContinue[];
#endif

#if defined(__polyspace_ncr710TgtDisconnect) && !defined(__polyspace_no_ncr710TgtDisconnect)
#include <drv/scsi/ncr710Script2.h>
#undef ncr710TgtDisconnect
  extern ULONG ncr710TgtDisconnect[];
#endif

#if defined(__polyspace_ncr810InitStart) && !defined(__polyspace_no_ncr810InitStart)
#include <drv/scsi/ncr810Script.h>
#undef ncr810InitStart
  extern ULONG ncr810InitStart[];
#endif

#if defined(__polyspace_ncr810InitContinue) && !defined(__polyspace_no_ncr810InitContinue)
#include <drv/scsi/ncr810Script.h>
#undef ncr810InitContinue
  extern ULONG ncr810InitContinue[];
#endif

#if defined(__polyspace_ncr810TgtDisconnect) && !defined(__polyspace_no_ncr810TgtDisconnect)
#include <drv/scsi/ncr810Script.h>
#undef ncr810TgtDisconnect
  extern ULONG ncr810TgtDisconnect[];
#endif

#if defined(__polyspace_pSysScsiCtrl) && !defined(__polyspace_no_pSysScsiCtrl)
#include <drv/scsi/wd33c93_1.h>
#undef pSysScsiCtrl
  extern SCSI_CTRL *pSysScsiCtrl;
#endif

#if defined(__polyspace_pWd33c93IfTbl) && !defined(__polyspace_no_pWd33c93IfTbl)
#include <drv/scsi/wd33c93_1.h>
#undef pWd33c93IfTbl
  extern SCSIDRV_FUNC_TBL *pWd33c93IfTbl;
#endif

#if defined(__polyspace_ioMaxLinkLevels) && !defined(__polyspace_no_ioMaxLinkLevels)
#include <ioLib.h>
#undef ioMaxLinkLevels
  extern int ioMaxLinkLevels;
#endif

#if defined(__polyspace_cin) && !defined(__polyspace_no_cin)
#include <iostream.h>
#undef cin
  extern istream_withassign cin;
#endif

#if defined(__polyspace_cout) && !defined(__polyspace_no_cout)
#include <iostream.h>
#undef cout
  extern ostream_withassign cout;
#endif

#if defined(__polyspace_cerr) && !defined(__polyspace_no_cerr)
#include <iostream.h>
#undef cerr
  extern ostream_withassign cerr;
#endif

#if defined(__polyspace_clog) && !defined(__polyspace_no_clog)
#include <iostream.h>
#undef clog
  extern ostream_withassign clog;
#endif

#if defined(__polyspace_ipDrvCtrl) && !defined(__polyspace_no_ipDrvCtrl)
#include <ipProto.h>
#undef ipDrvCtrl
  extern IP_DRV_CTRL ipDrvCtrl[];
#endif

#if defined(__polyspace_syncLoadRtn) && !defined(__polyspace_no_syncLoadRtn)
#include <loadLib.h>
#undef syncLoadRtn
  extern FUNCPTR syncLoadRtn;
#endif

#if defined(__polyspace__mbufIdHead) && !defined(__polyspace_no__mbufIdHead)
#include <mbufLib.h>
#undef _mbufIdHead
  extern struct mbufId * _mbufIdHead;
#endif

#if defined(__polyspace_memSysPartId) && !defined(__polyspace_no_memSysPartId)
#include <memLib.h>
#undef memSysPartId
  extern PART_ID memSysPartId;
#endif

#if defined(__polyspace_smMemPartOptionsSetRtn) && !defined(__polyspace_no_smMemPartOptionsSetRtn)
#include <memLib.h>
#undef smMemPartOptionsSetRtn
  extern FUNCPTR smMemPartOptionsSetRtn;
#endif

#if defined(__polyspace_smMemPartFindMaxRtn) && !defined(__polyspace_no_smMemPartFindMaxRtn)
#include <memLib.h>
#undef smMemPartFindMaxRtn
  extern FUNCPTR smMemPartFindMaxRtn;
#endif

#if defined(__polyspace_smMemPartReallocRtn) && !defined(__polyspace_no_smMemPartReallocRtn)
#include <memLib.h>
#undef smMemPartReallocRtn
  extern FUNCPTR smMemPartReallocRtn;
#endif

#if defined(__polyspace_smMemPartShowRtn) && !defined(__polyspace_no_smMemPartShowRtn)
#include <memLib.h>
#undef smMemPartShowRtn
  extern FUNCPTR smMemPartShowRtn;
#endif

#if defined(__polyspace_rawcb) && !defined(__polyspace_no_rawcb)
#include <net/raw_cb.h>
#undef rawcb
  extern struct rawcb rawcb;
#endif

#if defined(__polyspace_sb_max) && !defined(__polyspace_no_sb_max)
#include <net/socketvar.h>
#undef sb_max
  extern u_long sb_max;
#endif

#if defined(__polyspace_netio) && !defined(__polyspace_no_netio)
#include <net/socketvar.h>
#undef netio
  extern char netio[];
#endif

#if defined(__polyspace_netcon) && !defined(__polyspace_no_netcon)
#include <net/socketvar.h>
#undef netcon
  extern char netcon[];
#endif

#if defined(__polyspace_netcls) && !defined(__polyspace_no_netcls)
#include <net/socketvar.h>
#undef netcls
  extern char netcls[];
#endif

#if defined(__polyspace_domains) && !defined(__polyspace_no_domains)
#include <net/domain.h>
#undef domains
  extern struct domain *domains;
#endif

#if defined(__polyspace_af_max) && !defined(__polyspace_no_af_max)
#include <net/af.h>
#undef af_max
  extern int af_max;
#endif

#if defined(__polyspace_max_linkhdr) && !defined(__polyspace_no_max_linkhdr)
#include <net/mbuf.h>
#undef max_linkhdr
  extern int max_linkhdr;
#endif

#if defined(__polyspace_max_protohdr) && !defined(__polyspace_no_max_protohdr)
#include <net/mbuf.h>
#undef max_protohdr
  extern int max_protohdr;
#endif

#if defined(__polyspace_max_hdr) && !defined(__polyspace_no_max_hdr)
#include <net/mbuf.h>
#undef max_hdr
  extern int max_hdr;
#endif

#if defined(__polyspace_max_datalen) && !defined(__polyspace_no_max_datalen)
#include <net/mbuf.h>
#undef max_datalen
  extern int max_datalen;
#endif

#if defined(__polyspace_route_cb) && !defined(__polyspace_no_route_cb)
#include <net/route.h>
#undef route_cb
  extern struct route_cb route_cb;
#endif

#if defined(__polyspace_rtstat) && !defined(__polyspace_no_rtstat)
#include <net/route.h>
#undef rtstat
  extern struct rtstat rtstat;
#endif

#if defined(__polyspace_rt_tables) && !defined(__polyspace_no_rt_tables)
#include <net/route.h>
#undef rt_tables
  extern struct radix_node_head *rt_tables[];
#endif

#if defined(__polyspace_rtmodified) && !defined(__polyspace_no_rtmodified)
#include <net/route.h>
#undef rtmodified
  extern int rtmodified;
#endif

#if defined(__polyspace_ifnet) && !defined(__polyspace_no_ifnet)
#include <net/if.h>
#undef ifnet
  extern struct ifnet * ifnet;
#endif

#if defined(__polyspace_rawintrq) && !defined(__polyspace_no_rawintrq)
#include <net/if.h>
#undef rawintrq
  extern struct ifqueue rawintrq;
#endif

#if defined(__polyspace_lcp_warnloops) && !defined(__polyspace_no_lcp_warnloops)
#include <netinet/ppp/lcp.h>
#undef lcp_warnloops
  extern int lcp_warnloops;
#endif

#if defined(__polyspace_pppSecretHead) && !defined(__polyspace_no_pppSecretHead)
#include <netinet/ppp/pppSecretLib.h>
#undef pppSecretHead
  extern PPP_SECRET * pppSecretHead;
#endif

#if defined(__polyspace_ppp_unit) && !defined(__polyspace_no_ppp_unit)
#include <netinet/ppp/pppd.h>
#undef ppp_unit
  extern int ppp_unit;
#endif

#if defined(__polyspace_ppp_if) && !defined(__polyspace_no_ppp_if)
#include <netinet/ppp/pppd.h>
#undef ppp_if
  extern PPP_TASK_VARS *ppp_if[];
#endif

#if defined(__polyspace_pppConnectHook) && !defined(__polyspace_no_pppConnectHook)
#include <netinet/ppp/pppd.h>
#undef pppConnectHook
  extern FUNCPTR pppConnectHook;
#endif

#if defined(__polyspace_pppDisconnectHook) && !defined(__polyspace_no_pppDisconnectHook)
#include <netinet/ppp/pppd.h>
#undef pppDisconnectHook
  extern FUNCPTR pppDisconnectHook;
#endif

#if defined(__polyspace_tcpOutRsts) && !defined(__polyspace_no_tcpOutRsts)
#include <netinet/tcp_var.h>
#undef tcpOutRsts
  extern long tcpOutRsts;
#endif

#if defined(__polyspace_tcb) && !defined(__polyspace_no_tcb)
#include <netinet/tcp_var.h>
#undef tcb
  extern struct inpcbhead tcb;
#endif

#if defined(__polyspace_tcbinfo) && !defined(__polyspace_no_tcbinfo)
#include <netinet/tcp_var.h>
#undef tcbinfo
  extern struct inpcbinfo tcbinfo;
#endif

#if defined(__polyspace_tcp_now) && !defined(__polyspace_no_tcp_now)
#include <netinet/tcp_var.h>
#undef tcp_now
  extern u_long tcp_now;
#endif

#if defined(__polyspace_ipforwarding) && !defined(__polyspace_no_ipforwarding)
#include <netinet/ip_var.h>
#undef ipforwarding
  extern int ipforwarding;
#endif

#if defined(__polyspace_ipstat) && !defined(__polyspace_no_ipstat)
#include <netinet/ip_var.h>
#undef ipstat
  extern struct ipstat ipstat;
#endif

#if defined(__polyspace_ipq) && !defined(__polyspace_no_ipq)
#include <netinet/ip_var.h>
#undef ipq
  extern struct ipq ipq;
#endif

#if defined(__polyspace_ip_id) && !defined(__polyspace_no_ip_id)
#include <netinet/ip_var.h>
#undef ip_id
  extern u_short ip_id;
#endif

#if defined(__polyspace_ip_defttl) && !defined(__polyspace_no_ip_defttl)
#include <netinet/ip_var.h>
#undef ip_defttl
  extern int ip_defttl;
#endif

#if defined(__polyspace_etherbroadcastaddr) && !defined(__polyspace_no_etherbroadcastaddr)
#include <netinet/if_ether.h>
#undef etherbroadcastaddr
  extern u_char etherbroadcastaddr[6];
#endif

#if defined(__polyspace_ether_ipmulticast_min) && !defined(__polyspace_no_ether_ipmulticast_min)
#include <netinet/if_ether.h>
#undef ether_ipmulticast_min
  extern u_char ether_ipmulticast_min[6];
#endif

#if defined(__polyspace_ether_ipmulticast_max) && !defined(__polyspace_no_ether_ipmulticast_max)
#include <netinet/if_ether.h>
#undef ether_ipmulticast_max
  extern u_char ether_ipmulticast_max[6];
#endif

#if defined(__polyspace_arpintrq) && !defined(__polyspace_no_arpintrq)
#include <netinet/if_ether.h>
#undef arpintrq
  extern struct ifqueue arpintrq;
#endif

#if defined(__polyspace_llinfo_arp) && !defined(__polyspace_no_llinfo_arp)
#include <netinet/if_ether.h>
#undef llinfo_arp
  extern struct llinfo_arp llinfo_arp;
#endif

#if defined(__polyspace_tcp_keepidle) && !defined(__polyspace_no_tcp_keepidle)
#include <netinet/tcp_timer.h>
#undef tcp_keepidle
  extern int tcp_keepidle;
#endif

#if defined(__polyspace_tcp_keepintvl) && !defined(__polyspace_no_tcp_keepintvl)
#include <netinet/tcp_timer.h>
#undef tcp_keepintvl
  extern int tcp_keepintvl;
#endif

#if defined(__polyspace_tcp_maxidle) && !defined(__polyspace_no_tcp_maxidle)
#include <netinet/tcp_timer.h>
#undef tcp_maxidle
  extern int tcp_maxidle;
#endif

#if defined(__polyspace_tcp_ttl) && !defined(__polyspace_no_tcp_ttl)
#include <netinet/tcp_timer.h>
#undef tcp_ttl
  extern int tcp_ttl;
#endif

#if defined(__polyspace_tcp_backoff) && !defined(__polyspace_no_tcp_backoff)
#include <netinet/tcp_timer.h>
#undef tcp_backoff
  extern int tcp_backoff[];
#endif

#if defined(__polyspace_icmpstat) && !defined(__polyspace_no_icmpstat)
#include <netinet/icmp_var.h>
#undef icmpstat
  extern struct icmpstat icmpstat;
#endif

#if defined(__polyspace_inetdomain) && !defined(__polyspace_no_inetdomain)
#include <netinet/in.h>
#undef inetdomain
  extern struct domain inetdomain;
#endif

#if defined(__polyspace_udpNoPorts) && !defined(__polyspace_no_udpNoPorts)
#include <netinet/udp_var.h>
#undef udpNoPorts
  extern long udpNoPorts;
#endif

#if defined(__polyspace_igmpstat) && !defined(__polyspace_no_igmpstat)
#include <netinet/igmp_var.h>
#undef igmpstat
  extern struct igmpstat igmpstat;
#endif

#if defined(__polyspace_in_ifaddr) && !defined(__polyspace_no_in_ifaddr)
#include <netinet/in_var.h>
#undef in_ifaddr
  extern struct in_ifaddr *in_ifaddr;
#endif

#if defined(__polyspace_ipintrq) && !defined(__polyspace_no_ipintrq)
#include <netinet/in_var.h>
#undef ipintrq
  extern struct ifqueue ipintrq;
#endif

#if defined(__polyspace_inetctlerrmap) && !defined(__polyspace_no_inetctlerrmap)
#include <netinet/in_var.h>
#undef inetctlerrmap
  extern u_char inetctlerrmap[];
#endif

#if defined(__polyspace_mCastHashInfo) && !defined(__polyspace_no_mCastHashInfo)
#include <netinet/in_var.h>
#undef mCastHashInfo
  extern struct mcastHashInfo mCastHashInfo;
#endif

#if defined(__polyspace_ospfNode) && !defined(__polyspace_no_ospfNode)
#include <ospf/os_exter.h>
#undef ospfNode
  extern OSPF_NODE *ospfNode;
#endif

#if defined(__polyspace_ospfNode_tpl) && !defined(__polyspace_no_ospfNode_tpl)
#include <ospf/os_exter.h>
#undef ospfNode_tpl
  extern OSPF_NODE ospfNode_tpl;
#endif

#if defined(__polyspace_ospfStatLsa) && !defined(__polyspace_no_ospfStatLsa)
#include <ospf/os_exter.h>
#undef ospfStatLsa
  extern byte  ospfStatLsa[];
#endif

#if defined(__polyspace_ospfTrace) && !defined(__polyspace_no_ospfTrace)
#include <ospf/os_port.h>
#undef ospfTrace
  extern int ospfTrace;
#endif

#if defined(__polyspace_aioPrintRtn) && !defined(__polyspace_no_aioPrintRtn)
#include <private/aioPxLibP.h>
#undef aioPrintRtn
  extern FUNCPTR aioPrintRtn;
#endif

#if defined(__polyspace__func_logMsg) && !defined(__polyspace_no__func_logMsg)
#include <private/cplusLibP.h>
#undef _func_logMsg
  extern FUNCPTR_ARGS _func_logMsg;
#endif

#if defined(__polyspace_cplusDemanglerMode) && !defined(__polyspace_no_cplusDemanglerMode)
#include <private/cplusLibP.h>
#undef cplusDemanglerMode
  extern CPLUS_DEMANGLER_MODES cplusDemanglerMode;
#endif

#if defined(__polyspace_cplusXtorStrategy) && !defined(__polyspace_no_cplusXtorStrategy)
#include <private/cplusLibP.h>
#undef cplusXtorStrategy
  extern CPLUS_XTOR_STRATEGIES cplusXtorStrategy;
#endif

#if defined(__polyspace_cplusNewHdlMutex) && !defined(__polyspace_no_cplusNewHdlMutex)
#include <private/cplusLibP.h>
#undef cplusNewHdlMutex
  extern SEM_ID    cplusNewHdlMutex;
#endif

#if defined(__polyspace__archHelp_msg) && !defined(__polyspace_no__archHelp_msg)
#include <private/dbgLibP.h>
#undef _archHelp_msg
  extern char * _archHelp_msg;
#endif

#if defined(__polyspace_trcDefaultArgs) && !defined(__polyspace_no_trcDefaultArgs)
#include <private/dbgLibP.h>
#undef trcDefaultArgs
  extern int  trcDefaultArgs;
#endif

#if defined(__polyspace__dbgDsmInstRtn) && !defined(__polyspace_no__dbgDsmInstRtn)
#include <private/dbgLibP.h>
#undef _dbgDsmInstRtn
  extern FUNCPTR _dbgDsmInstRtn;
#endif

#if defined(__polyspace__dbgAdrsChkRtn) && !defined(__polyspace_no__dbgAdrsChkRtn)
#include <private/dbgLibP.h>
#undef _dbgAdrsChkRtn
  extern FUNCPTR _dbgAdrsChkRtn;
#endif

#if defined(__polyspace__dbgHwParmGetRtn) && !defined(__polyspace_no__dbgHwParmGetRtn)
#include <private/dbgLibP.h>
#undef _dbgHwParmGetRtn
  extern FUNCPTR _dbgHwParmGetRtn;
#endif

#if defined(__polyspace_evtBufferSize) && !defined(__polyspace_no_evtBufferSize)
#include <private/evtBufferLibP.h>
#undef evtBufferSize
  extern size_t evtBufferSize;
#endif

#if defined(__polyspace_pEvtBufEnd) && !defined(__polyspace_no_pEvtBufEnd)
#include <private/evtBufferLibP.h>
#undef pEvtBufEnd
  extern char * pEvtBufEnd;
#endif

#if defined(__polyspace_iosDvList) && !defined(__polyspace_no_iosDvList)
#include <private/iosLibP.h>
#undef iosDvList
  extern DL_LIST iosDvList;
#endif

#if defined(__polyspace_drvTable) && !defined(__polyspace_no_drvTable)
#include <private/iosLibP.h>
#undef drvTable
  extern DRV_ENTRY * drvTable;
#endif

#if defined(__polyspace_fdTable) && !defined(__polyspace_no_fdTable)
#include <private/iosLibP.h>
#undef fdTable
  extern FD_ENTRY * fdTable;
#endif

#if defined(__polyspace_maxDrivers) && !defined(__polyspace_no_maxDrivers)
#include <private/iosLibP.h>
#undef maxDrivers
  extern int maxDrivers;
#endif

#if defined(__polyspace_maxFiles) && !defined(__polyspace_no_maxFiles)
#include <private/iosLibP.h>
#undef maxFiles
  extern int maxFiles;
#endif

#if defined(__polyspace_iosFdNewHookRtn) && !defined(__polyspace_no_iosFdNewHookRtn)
#include <private/iosLibP.h>
#undef iosFdNewHookRtn
  extern VOIDFUNCPTR iosFdNewHookRtn;
#endif

#if defined(__polyspace_iosFdFreeHookRtn) && !defined(__polyspace_no_iosFdFreeHookRtn)
#include <private/iosLibP.h>
#undef iosFdFreeHookRtn
  extern VOIDFUNCPTR iosFdFreeHookRtn;
#endif

#if defined(__polyspace_kernelIsIdle) && !defined(__polyspace_no_kernelIsIdle)
#include <private/kernelLibP.h>
#undef kernelIsIdle
  extern BOOL kernelIsIdle;
#endif

#if defined(__polyspace_roundRobinOn) && !defined(__polyspace_no_roundRobinOn)
#include <private/kernelLibP.h>
#undef roundRobinOn
  extern BOOL roundRobinOn;
#endif

#if defined(__polyspace_roundRobinSlice) && !defined(__polyspace_no_roundRobinSlice)
#include <private/kernelLibP.h>
#undef roundRobinSlice
  extern ULONG roundRobinSlice;
#endif

#if defined(__polyspace_rootTaskId) && !defined(__polyspace_no_rootTaskId)
#include <private/kernelLibP.h>
#undef rootTaskId
  extern int rootTaskId;
#endif

#if defined(__polyspace_pRootMemStart) && !defined(__polyspace_no_pRootMemStart)
#include <private/kernelLibP.h>
#undef pRootMemStart
  extern char * pRootMemStart;
#endif

#if defined(__polyspace_rootMemNBytes) && !defined(__polyspace_no_rootMemNBytes)
#include <private/kernelLibP.h>
#undef rootMemNBytes
  extern unsigned rootMemNBytes;
#endif

#if defined(__polyspace_tickQHead) && !defined(__polyspace_no_tickQHead)
#include <private/kernelLibP.h>
#undef tickQHead
  extern Q_HEAD tickQHead;
#endif

#if defined(__polyspace_readyQHead) && !defined(__polyspace_no_readyQHead)
#include <private/kernelLibP.h>
#undef readyQHead
  extern Q_HEAD readyQHead;
#endif

#if defined(__polyspace_activeQHead) && !defined(__polyspace_no_activeQHead)
#include <private/kernelLibP.h>
#undef activeQHead
  extern Q_HEAD activeQHead;
#endif

#if defined(__polyspace_ifAttachChange) && !defined(__polyspace_no_ifAttachChange)
#include <private/m2LibP.h>
#undef ifAttachChange
  extern int    ifAttachChange;
#endif

#if defined(__polyspace_pm2IfTable) && !defined(__polyspace_no_pm2IfTable)
#include <private/m2LibP.h>
#undef pm2IfTable
  extern NET_IF_TBL * pm2IfTable;
#endif

#if defined(__polyspace_m2IfCount) && !defined(__polyspace_no_m2IfCount)
#include <private/m2LibP.h>
#undef m2IfCount
  extern int  m2IfCount;
#endif

#if defined(__polyspace_zeroObjectId) && !defined(__polyspace_no_zeroObjectId)
#include <private/m2LibP.h>
#undef zeroObjectId
  extern M2_OBJECTID zeroObjectId;
#endif

#if defined(__polyspace_memPartClassId) && !defined(__polyspace_no_memPartClassId)
#include <private/memPartLibP.h>
#undef memPartClassId
  extern CLASS_ID memPartClassId;
#endif

#if defined(__polyspace_memPartBlockErrorRtn) && !defined(__polyspace_no_memPartBlockErrorRtn)
#include <private/memPartLibP.h>
#undef memPartBlockErrorRtn
  extern FUNCPTR memPartBlockErrorRtn;
#endif

#if defined(__polyspace_memPartAllocErrorRtn) && !defined(__polyspace_no_memPartAllocErrorRtn)
#include <private/memPartLibP.h>
#undef memPartAllocErrorRtn
  extern FUNCPTR memPartAllocErrorRtn;
#endif

#if defined(__polyspace_memPartSemInitRtn) && !defined(__polyspace_no_memPartSemInitRtn)
#include <private/memPartLibP.h>
#undef memPartSemInitRtn
  extern FUNCPTR memPartSemInitRtn;
#endif

#if defined(__polyspace_memPartOptionsDefault) && !defined(__polyspace_no_memPartOptionsDefault)
#include <private/memPartLibP.h>
#undef memPartOptionsDefault
  extern unsigned memPartOptionsDefault;
#endif

#if defined(__polyspace_memDefaultAlignment) && !defined(__polyspace_no_memDefaultAlignment)
#include <private/memPartLibP.h>
#undef memDefaultAlignment
  extern UINT memDefaultAlignment;
#endif

#if defined(__polyspace_mutexOptionsMemLib) && !defined(__polyspace_no_mutexOptionsMemLib)
#include <private/memPartLibP.h>
#undef mutexOptionsMemLib
  extern int mutexOptionsMemLib;
#endif

#if defined(__polyspace_smMemPartAddToPoolRtn) && !defined(__polyspace_no_smMemPartAddToPoolRtn)
#include <private/memPartLibP.h>
#undef smMemPartAddToPoolRtn
  extern FUNCPTR smMemPartAddToPoolRtn;
#endif

#if defined(__polyspace_smMemPartFreeRtn) && !defined(__polyspace_no_smMemPartFreeRtn)
#include <private/memPartLibP.h>
#undef smMemPartFreeRtn
  extern FUNCPTR smMemPartFreeRtn;
#endif

#if defined(__polyspace_smMemPartAllocRtn) && !defined(__polyspace_no_smMemPartAllocRtn)
#include <private/memPartLibP.h>
#undef smMemPartAllocRtn
  extern FUNCPTR smMemPartAllocRtn;
#endif

#if defined(__polyspace_msgQClassId) && !defined(__polyspace_no_msgQClassId)
#include <private/msgQLibP.h>
#undef msgQClassId
  extern CLASS_ID msgQClassId;
#endif

#if defined(__polyspace_msgQInstClassId) && !defined(__polyspace_no_msgQInstClassId)
#include <private/msgQLibP.h>
#undef msgQInstClassId
  extern CLASS_ID msgQInstClassId;
#endif

#if defined(__polyspace_msgQSmSendRtn) && !defined(__polyspace_no_msgQSmSendRtn)
#include <private/msgQLibP.h>
#undef msgQSmSendRtn
  extern FUNCPTR msgQSmSendRtn;
#endif

#if defined(__polyspace_msgQSmReceiveRtn) && !defined(__polyspace_no_msgQSmReceiveRtn)
#include <private/msgQLibP.h>
#undef msgQSmReceiveRtn
  extern FUNCPTR msgQSmReceiveRtn;
#endif

#if defined(__polyspace_msgQSmNumMsgsRtn) && !defined(__polyspace_no_msgQSmNumMsgsRtn)
#include <private/msgQLibP.h>
#undef msgQSmNumMsgsRtn
  extern FUNCPTR msgQSmNumMsgsRtn;
#endif

#if defined(__polyspace_msgQSmShowRtn) && !defined(__polyspace_no_msgQSmShowRtn)
#include <private/msgQLibP.h>
#undef msgQSmShowRtn
  extern FUNCPTR msgQSmShowRtn;
#endif

#if defined(__polyspace_msgQSmInfoGetRtn) && !defined(__polyspace_no_msgQSmInfoGetRtn)
#include <private/msgQSmLibP.h>
#undef msgQSmInfoGetRtn
  extern FUNCPTR msgQSmInfoGetRtn;
#endif

#if defined(__polyspace_semClass) && !defined(__polyspace_no_semClass)
#include <private/semLibP.h>
#undef semClass
  extern OBJ_CLASS semClass;
#endif

#if defined(__polyspace_semInstClass) && !defined(__polyspace_no_semInstClass)
#include <private/semLibP.h>
#undef semInstClass
  extern OBJ_CLASS semInstClass;
#endif

#if defined(__polyspace_semClassId) && !defined(__polyspace_no_semClassId)
#include <private/semLibP.h>
#undef semClassId
  extern CLASS_ID semClassId;
#endif

#if defined(__polyspace_semInstClassId) && !defined(__polyspace_no_semInstClassId)
#include <private/semLibP.h>
#undef semInstClassId
  extern CLASS_ID semInstClassId;
#endif

#if defined(__polyspace_semMGiveKernWork) && !defined(__polyspace_no_semMGiveKernWork)
#include <private/semLibP.h>
#undef semMGiveKernWork
  extern int semMGiveKernWork;
#endif

#if defined(__polyspace_semSmShowRtn) && !defined(__polyspace_no_semSmShowRtn)
#include <private/semLibP.h>
#undef semSmShowRtn
  extern FUNCPTR semSmShowRtn;
#endif

#if defined(__polyspace_semSmInfoRtn) && !defined(__polyspace_no_semSmInfoRtn)
#include <private/semLibP.h>
#undef semSmInfoRtn
  extern FUNCPTR semSmInfoRtn;
#endif

#if defined(__polyspace_sigEvtRtn) && !defined(__polyspace_no_sigEvtRtn)
#include <private/sigLibP.h>
#undef sigEvtRtn
  extern VOIDFUNCPTR  sigEvtRtn;
#endif

#if defined(__polyspace_pSmNameDb) && !defined(__polyspace_no_pSmNameDb)
#include <private/smNameLibP.h>
#undef pSmNameDb
  extern SM_OBJ_NAME_DB * pSmNameDb;
#endif

#if defined(__polyspace_smTcbPartId) && !defined(__polyspace_no_smTcbPartId)
#include <private/smObjLibP.h>
#undef smTcbPartId
  extern SM_FIX_BLK_PART_ID smTcbPartId;
#endif

#if defined(__polyspace_smObjTcbFreeRtn) && !defined(__polyspace_no_smObjTcbFreeRtn)
#include <private/smObjLibP.h>
#undef smObjTcbFreeRtn
  extern FUNCPTR smObjTcbFreeRtn;
#endif

#if defined(__polyspace_smObjTcbFreeFailRtn) && !defined(__polyspace_no_smObjTcbFreeFailRtn)
#include <private/smObjLibP.h>
#undef smObjTcbFreeFailRtn
  extern FUNCPTR smObjTcbFreeFailRtn;
#endif

#if defined(__polyspace_smObjTaskDeleteFailRtn) && !defined(__polyspace_no_smObjTaskDeleteFailRtn)
#include <private/smObjLibP.h>
#undef smObjTaskDeleteFailRtn
  extern FUNCPTR smObjTaskDeleteFailRtn;
#endif

#if defined(__polyspace___costate) && !defined(__polyspace_no___costate)
#include <private/strStateP.h>
#undef __costate
  extern __statetable __costate;
#endif

#if defined(__polyspace___mbstate) && !defined(__polyspace_no___mbstate)
#include <private/strStateP.h>
#undef __mbstate
  extern __statetable __mbstate;
#endif

#if defined(__polyspace___wcstate) && !defined(__polyspace_no___wcstate)
#include <private/strStateP.h>
#undef __wcstate
  extern __statetable __wcstate;
#endif

#if defined(__polyspace_taskBpHook) && !defined(__polyspace_no_taskBpHook)
#include <private/taskLibP.h>
#undef taskBpHook
  extern FUNCPTR taskBpHook;
#endif

#if defined(__polyspace_pTaskLastFpTcb) && !defined(__polyspace_no_pTaskLastFpTcb)
#include <private/taskLibP.h>
#undef pTaskLastFpTcb
  extern WIND_TCB * pTaskLastFpTcb;
#endif

#if defined(__polyspace__clockRealtime) && !defined(__polyspace_no__clockRealtime)
#include <private/timerLibP.h>
#undef _clockRealtime
  extern struct clock _clockRealtime;
#endif

#if defined(__polyspace_vxmIfOps) && !defined(__polyspace_no_vxmIfOps)
#include <private/vxmIfLibP.h>
#undef vxmIfOps
  extern VXM_IF_OPS vxmIfOps;
#endif

#if defined(__polyspace_wdClassId) && !defined(__polyspace_no_wdClassId)
#include <private/wdLibP.h>
#undef wdClassId
  extern CLASS_ID wdClassId;
#endif

#if defined(__polyspace_wdInstClassId) && !defined(__polyspace_no_wdInstClassId)
#include <private/wdLibP.h>
#undef wdInstClassId
  extern CLASS_ID wdInstClassId;
#endif

#if defined(__polyspace_workQReadIx) && !defined(__polyspace_no_workQReadIx)
#include <private/workQLibP.h>
#undef workQReadIx
  extern UINT8 workQReadIx;
#endif

#if defined(__polyspace_workQWriteIx) && !defined(__polyspace_no_workQWriteIx)
#include <private/workQLibP.h>
#undef workQWriteIx
  extern UINT8 workQWriteIx;
#endif

#if defined(__polyspace_workQIsEmpty) && !defined(__polyspace_no_workQIsEmpty)
#include <private/workQLibP.h>
#undef workQIsEmpty
  extern BOOL workQIsEmpty;
#endif

#if defined(__polyspace_pJobPool) && !defined(__polyspace_no_pJobPool)
#include <private/workQLibP.h>
#undef pJobPool
  extern int pJobPool[];
#endif

#if defined(__polyspace_pHostInfo) && !defined(__polyspace_no_pHostInfo)
#include <private/wvHostLibP.h>
#undef pHostInfo
  extern HOSTINFO * pHostInfo;
#endif

#if defined(__polyspace__func_excBaseHook) && !defined(__polyspace_no__func_excBaseHook)
#include <private/funcBindP.h>
#undef _func_excBaseHook
  extern FUNCPTR  _func_excBaseHook;
#endif

#if defined(__polyspace__func_excInfoShow) && !defined(__polyspace_no__func_excInfoShow)
#include <private/funcBindP.h>
#undef _func_excInfoShow
  extern FUNCPTR  _func_excInfoShow;
#endif

#if defined(__polyspace__func_excIntHook) && !defined(__polyspace_no__func_excIntHook)
#include <private/funcBindP.h>
#undef _func_excIntHook
  extern FUNCPTR  _func_excIntHook;
#endif

#if defined(__polyspace__func_excJobAdd) && !defined(__polyspace_no__func_excJobAdd)
#include <private/funcBindP.h>
#undef _func_excJobAdd
  extern FUNCPTR  _func_excJobAdd;
#endif

#if defined(__polyspace__func_excPanicHook) && !defined(__polyspace_no__func_excPanicHook)
#include <private/funcBindP.h>
#undef _func_excPanicHook
  extern FUNCPTR  _func_excPanicHook;
#endif

#if defined(__polyspace__func_fclose) && !defined(__polyspace_no__func_fclose)
#include <private/funcBindP.h>
#undef _func_fclose
  extern FUNCPTR  _func_fclose;
#endif

#if defined(__polyspace__func_fppTaskRegsShow) && !defined(__polyspace_no__func_fppTaskRegsShow)
#include <private/funcBindP.h>
#undef _func_fppTaskRegsShow
  extern FUNCPTR  _func_fppTaskRegsShow;
#endif

#if defined(__polyspace__func_ftpLs) && !defined(__polyspace_no__func_ftpLs)
#include <private/funcBindP.h>
#undef _func_ftpLs
  extern FUNCPTR  _func_ftpLs;
#endif

#if defined(__polyspace__func_netLsByName) && !defined(__polyspace_no__func_netLsByName)
#include <private/funcBindP.h>
#undef _func_netLsByName
  extern FUNCPTR  _func_netLsByName;
#endif

#if defined(__polyspace__func_printErr) && !defined(__polyspace_no__func_printErr)
#include <private/funcBindP.h>
#undef _func_printErr
  extern FUNCPTR  _func_printErr;
#endif

#if defined(__polyspace__func_memalign) && !defined(__polyspace_no__func_memalign)
#include <private/funcBindP.h>
#undef _func_memalign
  extern FUNCPTR  _func_memalign;
#endif

#if defined(__polyspace__func_selTyAdd) && !defined(__polyspace_no__func_selTyAdd)
#include <private/funcBindP.h>
#undef _func_selTyAdd
  extern FUNCPTR  _func_selTyAdd;
#endif

#if defined(__polyspace__func_selTyDelete) && !defined(__polyspace_no__func_selTyDelete)
#include <private/funcBindP.h>
#undef _func_selTyDelete
  extern FUNCPTR  _func_selTyDelete;
#endif

#if defined(__polyspace__func_selWakeupAll) && !defined(__polyspace_no__func_selWakeupAll)
#include <private/funcBindP.h>
#undef _func_selWakeupAll
  extern FUNCPTR  _func_selWakeupAll;
#endif

#if defined(__polyspace__func_selWakeupListInit) && !defined(__polyspace_no__func_selWakeupListInit)
#include <private/funcBindP.h>
#undef _func_selWakeupListInit
  extern FUNCPTR  _func_selWakeupListInit;
#endif

#if defined(__polyspace__func_sigExcKill) && !defined(__polyspace_no__func_sigExcKill)
#include <private/funcBindP.h>
#undef _func_sigExcKill
  extern VOIDFUNCPTR _func_sigExcKill;
#endif

#if defined(__polyspace__func_sigprocmask) && !defined(__polyspace_no__func_sigprocmask)
#include <private/funcBindP.h>
#undef _func_sigprocmask
  extern FUNCPTR  _func_sigprocmask;
#endif

#if defined(__polyspace__func_sigTimeoutRecalc) && !defined(__polyspace_no__func_sigTimeoutRecalc)
#include <private/funcBindP.h>
#undef _func_sigTimeoutRecalc
  extern FUNCPTR  _func_sigTimeoutRecalc;
#endif

#if defined(__polyspace__func_smObjObjShow) && !defined(__polyspace_no__func_smObjObjShow)
#include <private/funcBindP.h>
#undef _func_smObjObjShow
  extern FUNCPTR  _func_smObjObjShow;
#endif

#if defined(__polyspace__func_spy) && !defined(__polyspace_no__func_spy)
#include <private/funcBindP.h>
#undef _func_spy
  extern FUNCPTR  _func_spy;
#endif

#if defined(__polyspace__func_spyStop) && !defined(__polyspace_no__func_spyStop)
#include <private/funcBindP.h>
#undef _func_spyStop
  extern FUNCPTR  _func_spyStop;
#endif

#if defined(__polyspace__func_spyClkStart) && !defined(__polyspace_no__func_spyClkStart)
#include <private/funcBindP.h>
#undef _func_spyClkStart
  extern FUNCPTR  _func_spyClkStart;
#endif

#if defined(__polyspace__func_spyClkStop) && !defined(__polyspace_no__func_spyClkStop)
#include <private/funcBindP.h>
#undef _func_spyClkStop
  extern FUNCPTR  _func_spyClkStop;
#endif

#if defined(__polyspace__func_spyReport) && !defined(__polyspace_no__func_spyReport)
#include <private/funcBindP.h>
#undef _func_spyReport
  extern FUNCPTR  _func_spyReport;
#endif

#if defined(__polyspace__func_spyTask) && !defined(__polyspace_no__func_spyTask)
#include <private/funcBindP.h>
#undef _func_spyTask
  extern FUNCPTR  _func_spyTask;
#endif

#if defined(__polyspace__func_symFindByValueAndType) && !defined(__polyspace_no__func_symFindByValueAndType)
#include <private/funcBindP.h>
#undef _func_symFindByValueAndType
  extern FUNCPTR  _func_symFindByValueAndType;
#endif

#if defined(__polyspace__func_symFindByValue) && !defined(__polyspace_no__func_symFindByValue)
#include <private/funcBindP.h>
#undef _func_symFindByValue
  extern FUNCPTR  _func_symFindByValue;
#endif

#if defined(__polyspace__func_taskCreateHookAdd) && !defined(__polyspace_no__func_taskCreateHookAdd)
#include <private/funcBindP.h>
#undef _func_taskCreateHookAdd
  extern FUNCPTR  _func_taskCreateHookAdd;
#endif

#if defined(__polyspace__func_taskDeleteHookAdd) && !defined(__polyspace_no__func_taskDeleteHookAdd)
#include <private/funcBindP.h>
#undef _func_taskDeleteHookAdd
  extern FUNCPTR  _func_taskDeleteHookAdd;
#endif

#if defined(__polyspace__func_valloc) && !defined(__polyspace_no__func_valloc)
#include <private/funcBindP.h>
#undef _func_valloc
  extern FUNCPTR  _func_valloc;
#endif

#if defined(__polyspace__func_remCurIdGet) && !defined(__polyspace_no__func_remCurIdGet)
#include <private/funcBindP.h>
#undef _func_remCurIdGet
  extern FUNCPTR  _func_remCurIdGet;
#endif

#if defined(__polyspace__func_remCurIdSet) && !defined(__polyspace_no__func_remCurIdSet)
#include <private/funcBindP.h>
#undef _func_remCurIdSet
  extern FUNCPTR  _func_remCurIdSet;
#endif

#if defined(__polyspace_ftpErrorSuppress) && !defined(__polyspace_no_ftpErrorSuppress)
#include <private/funcBindP.h>
#undef ftpErrorSuppress
  extern BOOL ftpErrorSuppress;
#endif

#if defined(__polyspace__procNumWasSet) && !defined(__polyspace_no__procNumWasSet)
#include <private/funcBindP.h>
#undef _procNumWasSet
  extern BOOL _procNumWasSet;
#endif

#if defined(__polyspace__func_evtLogO) && !defined(__polyspace_no__func_evtLogO)
#include <private/funcBindP.h>
#undef _func_evtLogO
  extern VOIDFUNCPTR _func_evtLogO;
#endif

#if defined(__polyspace__func_evtLogOIntLock) && !defined(__polyspace_no__func_evtLogOIntLock)
#include <private/funcBindP.h>
#undef _func_evtLogOIntLock
  extern VOIDFUNCPTR _func_evtLogOIntLock;
#endif

#if defined(__polyspace__func_evtLogM0) && !defined(__polyspace_no__func_evtLogM0)
#include <private/funcBindP.h>
#undef _func_evtLogM0
  extern VOIDFUNCPTR _func_evtLogM0;
#endif

#if defined(__polyspace__func_evtLogM1) && !defined(__polyspace_no__func_evtLogM1)
#include <private/funcBindP.h>
#undef _func_evtLogM1
  extern VOIDFUNCPTR _func_evtLogM1;
#endif

#if defined(__polyspace__func_evtLogM2) && !defined(__polyspace_no__func_evtLogM2)
#include <private/funcBindP.h>
#undef _func_evtLogM2
  extern VOIDFUNCPTR _func_evtLogM2;
#endif

#if defined(__polyspace__func_evtLogM3) && !defined(__polyspace_no__func_evtLogM3)
#include <private/funcBindP.h>
#undef _func_evtLogM3
  extern VOIDFUNCPTR _func_evtLogM3;
#endif

#if defined(__polyspace__func_evtLogT0) && !defined(__polyspace_no__func_evtLogT0)
#include <private/funcBindP.h>
#undef _func_evtLogT0
  extern VOIDFUNCPTR _func_evtLogT0;
#endif

#if defined(__polyspace__func_evtLogT0_noInt) && !defined(__polyspace_no__func_evtLogT0_noInt)
#include <private/funcBindP.h>
#undef _func_evtLogT0_noInt
  extern VOIDFUNCPTR _func_evtLogT0_noInt;
#endif

#if defined(__polyspace__func_evtLogT1) && !defined(__polyspace_no__func_evtLogT1)
#include <private/funcBindP.h>
#undef _func_evtLogT1
  extern VOIDFUNCPTR _func_evtLogT1;
#endif

#if defined(__polyspace__func_evtLogT1_noTS) && !defined(__polyspace_no__func_evtLogT1_noTS)
#include <private/funcBindP.h>
#undef _func_evtLogT1_noTS
  extern VOIDFUNCPTR _func_evtLogT1_noTS;
#endif

#if defined(__polyspace__func_evtLogTSched) && !defined(__polyspace_no__func_evtLogTSched)
#include <private/funcBindP.h>
#undef _func_evtLogTSched
  extern VOIDFUNCPTR _func_evtLogTSched;
#endif

#if defined(__polyspace__func_evtLogString) && !defined(__polyspace_no__func_evtLogString)
#include <private/funcBindP.h>
#undef _func_evtLogString
  extern VOIDFUNCPTR _func_evtLogString;
#endif

#if defined(__polyspace__func_evtLogPoint) && !defined(__polyspace_no__func_evtLogPoint)
#include <private/funcBindP.h>
#undef _func_evtLogPoint
  extern FUNCPTR  _func_evtLogPoint;
#endif

#if defined(__polyspace__func_evtLogReserveTaskName) && !defined(__polyspace_no__func_evtLogReserveTaskName)
#include <private/funcBindP.h>
#undef _func_evtLogReserveTaskName
  extern FUNCPTR _func_evtLogReserveTaskName;
#endif

#if defined(__polyspace__func_scrPadToBuffer) && !defined(__polyspace_no__func_scrPadToBuffer)
#include <private/funcBindP.h>
#undef _func_scrPadToBuffer
  extern VOIDFUNCPTR _func_scrPadToBuffer;
#endif

#if defined(__polyspace__func_evtBufferCheck) && !defined(__polyspace_no__func_evtBufferCheck)
#include <private/funcBindP.h>
#undef _func_evtBufferCheck
  extern VOIDFUNCPTR _func_evtBufferCheck;
#endif

#if defined(__polyspace_evtLogTIsOn) && !defined(__polyspace_no_evtLogTIsOn)
#include <private/funcBindP.h>
#undef evtLogTIsOn
  extern BOOL evtLogTIsOn;
#endif

#if defined(__polyspace_evtLogOIsOn) && !defined(__polyspace_no_evtLogOIsOn)
#include <private/funcBindP.h>
#undef evtLogOIsOn
  extern BOOL evtLogOIsOn;
#endif

#if defined(__polyspace_evtBufPostMortem) && !defined(__polyspace_no_evtBufPostMortem)
#include <private/funcBindP.h>
#undef evtBufPostMortem
  extern BOOL evtBufPostMortem;
#endif

#if defined(__polyspace_evtBufOverflow) && !defined(__polyspace_no_evtBufOverflow)
#include <private/funcBindP.h>
#undef evtBufOverflow
  extern BOOL evtBufOverflow;
#endif

#if defined(__polyspace_evtBufIsEmpty) && !defined(__polyspace_no_evtBufIsEmpty)
#include <private/funcBindP.h>
#undef evtBufIsEmpty
  extern BOOL evtBufIsEmpty;
#endif

#if defined(__polyspace_evtBufSem) && !defined(__polyspace_no_evtBufSem)
#include <private/funcBindP.h>
#undef evtBufSem
  extern SEM_ID evtBufSem;
#endif

#if defined(__polyspace_pScrPad) && !defined(__polyspace_no_pScrPad)
#include <private/funcBindP.h>
#undef pScrPad
  extern char * pScrPad;
#endif

#if defined(__polyspace_pScrPadIndex) && !defined(__polyspace_no_pScrPadIndex)
#include <private/funcBindP.h>
#undef pScrPadIndex
  extern char * pScrPadIndex;
#endif

#if defined(__polyspace_pEvtDblBuffers) && !defined(__polyspace_no_pEvtDblBuffers)
#include <private/funcBindP.h>
#undef pEvtDblBuffers
  extern char * pEvtDblBuffers;
#endif

#if defined(__polyspace__func_tmrStamp) && !defined(__polyspace_no__func_tmrStamp)
#include <private/funcBindP.h>
#undef _func_tmrStamp
  extern FUNCPTR  _func_tmrStamp;
#endif

#if defined(__polyspace__func_tmrStampLock) && !defined(__polyspace_no__func_tmrStampLock)
#include <private/funcBindP.h>
#undef _func_tmrStampLock
  extern FUNCPTR  _func_tmrStampLock;
#endif

#if defined(__polyspace__func_tmrFreq) && !defined(__polyspace_no__func_tmrFreq)
#include <private/funcBindP.h>
#undef _func_tmrFreq
  extern FUNCPTR  _func_tmrFreq;
#endif

#if defined(__polyspace__func_tmrPeriod) && !defined(__polyspace_no__func_tmrPeriod)
#include <private/funcBindP.h>
#undef _func_tmrPeriod
  extern FUNCPTR  _func_tmrPeriod;
#endif

#if defined(__polyspace__func_tmrConnect) && !defined(__polyspace_no__func_tmrConnect)
#include <private/funcBindP.h>
#undef _func_tmrConnect
  extern FUNCPTR  _func_tmrConnect;
#endif

#if defined(__polyspace__func_tmrEnable) && !defined(__polyspace_no__func_tmrEnable)
#include <private/funcBindP.h>
#undef _func_tmrEnable
  extern FUNCPTR  _func_tmrEnable;
#endif

#if defined(__polyspace__func_tmrDisable) && !defined(__polyspace_no__func_tmrDisable)
#include <private/funcBindP.h>
#undef _func_tmrDisable
  extern FUNCPTR  _func_tmrDisable;
#endif

#if defined(__polyspace__func_trgCheck) && !defined(__polyspace_no__func_trgCheck)
#include <private/funcBindP.h>
#undef _func_trgCheck
  extern VOIDFUNCPTR _func_trgCheck;
#endif

#if defined(__polyspace_evtAction) && !defined(__polyspace_no_evtAction)
#include <private/funcBindP.h>
#undef evtAction
  extern UINT32 evtAction;
#endif

#if defined(__polyspace_wvEvtClass) && !defined(__polyspace_no_wvEvtClass)
#include <private/funcBindP.h>
#undef wvEvtClass
  extern UINT32 wvEvtClass;
#endif

#if defined(__polyspace_trgEvtClass) && !defined(__polyspace_no_trgEvtClass)
#include <private/funcBindP.h>
#undef trgEvtClass
  extern UINT32 trgEvtClass;
#endif

#if defined(__polyspace_wvInstIsOn) && !defined(__polyspace_no_wvInstIsOn)
#include <private/funcBindP.h>
#undef wvInstIsOn
  extern BOOL wvInstIsOn;
#endif

#if defined(__polyspace_wvObjIsEnabled) && !defined(__polyspace_no_wvObjIsEnabled)
#include <private/funcBindP.h>
#undef wvObjIsEnabled
  extern BOOL wvObjIsEnabled;
#endif

#if defined(__polyspace_qFifoGClassId) && !defined(__polyspace_no_qFifoGClassId)
#include <qFifoGLib.h>
#undef qFifoGClassId
  extern Q_CLASS_ID qFifoGClassId;
#endif

#if defined(__polyspace__res) && !defined(__polyspace_no__res)
#include <resolv/resolv.h>
#undef _res
  extern struct __res_state _res;
#endif

#if defined(__polyspace__null_auth) && !defined(__polyspace_no__null_auth)
#include <rpc/auth.h>
#undef _null_auth
  extern struct opaque_auth _null_auth;
#endif

#if defined(__polyspace_svc_fdset) && !defined(__polyspace_no_svc_fdset)
#include <rpc/svc.h>
#undef svc_fdset
  extern fd_set svc_fdset;
#endif

#if defined(__polyspace_svc_fds) && !defined(__polyspace_no_svc_fds)
#include <rpc/svc.h>
#undef svc_fds
  extern int svc_fds;
#endif

#if defined(__polyspace_pScsiIfTbl) && !defined(__polyspace_no_pScsiIfTbl)
#include <scsi2Lib.h>
#undef pScsiIfTbl
  extern SCSI_FUNC_TBL * pScsiIfTbl;
#endif

#if defined(__polyspace_scsiErrors) && !defined(__polyspace_no_scsiErrors)
#include <scsi2Lib.h>
#undef scsiErrors
  extern BOOL scsiErrors;
#endif

#if defined(__polyspace_scsiMgrActionSemOptions) && !defined(__polyspace_no_scsiMgrActionSemOptions)
#include <scsi2Lib.h>
#undef scsiMgrActionSemOptions
  extern int scsiMgrActionSemOptions;
#endif

#if defined(__polyspace_scsiThreadReplyQOptions) && !defined(__polyspace_no_scsiThreadReplyQOptions)
#include <scsi2Lib.h>
#undef scsiThreadReplyQOptions
  extern int scsiThreadReplyQOptions;
#endif

#if defined(__polyspace_scsiMgrEventQSize) && !defined(__polyspace_no_scsiMgrEventQSize)
#include <scsi2Lib.h>
#undef scsiMgrEventQSize
  extern int scsiMgrEventQSize;
#endif

#if defined(__polyspace_scsiMgrTimeoutQSize) && !defined(__polyspace_no_scsiMgrTimeoutQSize)
#include <scsi2Lib.h>
#undef scsiMgrTimeoutQSize
  extern int scsiMgrTimeoutQSize;
#endif

#if defined(__polyspace_scsiMgrRequestQSize) && !defined(__polyspace_no_scsiMgrRequestQSize)
#include <scsi2Lib.h>
#undef scsiMgrRequestQSize
  extern int scsiMgrRequestQSize;
#endif

#if defined(__polyspace_scsiMgrReplyQSize) && !defined(__polyspace_no_scsiMgrReplyQSize)
#include <scsi2Lib.h>
#undef scsiMgrReplyQSize
  extern int scsiMgrReplyQSize;
#endif

#if defined(__polyspace_shellTaskId) && !defined(__polyspace_no_shellTaskId)
#include <shellLib.h>
#undef shellTaskId
  extern int shellTaskId;
#endif

#if defined(__polyspace_smCurMaxTries) && !defined(__polyspace_no_smCurMaxTries)
#include <smLib.h>
#undef smCurMaxTries
  extern int smCurMaxTries;
#endif

#if defined(__polyspace_smObjProcNum) && !defined(__polyspace_no_smObjProcNum)
#include <smObjLib.h>
#undef smObjProcNum
  extern int smObjProcNum;
#endif

#if defined(__polyspace_smObjPoolMinusOne) && !defined(__polyspace_no_smObjPoolMinusOne)
#include <smObjLib.h>
#undef smObjPoolMinusOne
  extern int smObjPoolMinusOne;
#endif

#if defined(__polyspace_localToGlobalOffset) && !defined(__polyspace_no_localToGlobalOffset)
#include <smObjLib.h>
#undef localToGlobalOffset
  extern int localToGlobalOffset;
#endif

#if defined(__polyspace_smObjTasRoutine) && !defined(__polyspace_no_smObjTasRoutine)
#include <smObjLib.h>
#undef smObjTasRoutine
  extern FUNCPTR smObjTasRoutine;
#endif

#if defined(__polyspace_smObjTasClearRoutine) && !defined(__polyspace_no_smObjTasClearRoutine)
#include <smObjLib.h>
#undef smObjTasClearRoutine
  extern FUNCPTR smObjTasClearRoutine;
#endif

#if defined(__polyspace_smObjSpinTries) && !defined(__polyspace_no_smObjSpinTries)
#include <smObjLib.h>
#undef smObjSpinTries
  extern int smObjSpinTries;
#endif

#if defined(__polyspace_pSmHdr) && !defined(__polyspace_no_pSmHdr)
#include <smObjLib.h>
#undef pSmHdr
  extern SM_HDR *   pSmHdr;
#endif

#if defined(__polyspace_pSmObjHdr) && !defined(__polyspace_no_pSmObjHdr)
#include <smObjLib.h>
#undef pSmObjHdr
  extern SM_OBJ_MEM_HDR * pSmObjHdr;
#endif

#if defined(__polyspace_smObjDesc) && !defined(__polyspace_no_smObjDesc)
#include <smObjLib.h>
#undef smObjDesc
  extern SM_OBJ_DESC  smObjDesc;
#endif

#if defined(__polyspace_qwillrun) && !defined(__polyspace_no_qwillrun)
#include <streams/led.h>
#undef qwillrun
  extern int qwillrun;
#endif

#if defined(__polyspace_strmRunSem) && !defined(__polyspace_no_strmRunSem)
#include <streams/led.h>
#undef strmRunSem
  extern SEM_ID strmRunSem;
#endif

#if defined(__polyspace_ticksASec) && !defined(__polyspace_no_ticksASec)
#include <streams/led.h>
#undef ticksASec
  extern int ticksASec;
#endif

#if defined(__polyspace_mpsTimerId) && !defined(__polyspace_no_mpsTimerId)
#include <streams/led.h>
#undef mpsTimerId
  extern WDOG_ID mpsTimerId;
#endif

#if defined(__polyspace_mis_TLI_error) && !defined(__polyspace_no_mis_TLI_error)
#include <streams/mis_common.h>
#undef mis_TLI_error
  extern int mis_TLI_error;
#endif

#if defined(__polyspace_strmTliSem) && !defined(__polyspace_no_strmTliSem)
#include <streams/libtli.h>
#undef strmTliSem
  extern SEM_ID strmTliSem;
#endif

#if defined(__polyspace__mitli_g_debug) && !defined(__polyspace_no__mitli_g_debug)
#include <streams/libtli.h>
#undef _mitli_g_debug
  extern long _mitli_g_debug;
#endif

#if defined(__polyspace_t_errno) && !defined(__polyspace_no_t_errno)
#include <streams/tiuser.h>
#undef t_errno
  extern int t_errno;
#endif

#if defined(__polyspace_t_errlist) && !defined(__polyspace_no_t_errlist)
#include <streams/tiuser.h>
#undef t_errlist
  extern char * t_errlist[];
#endif

#if defined(__polyspace_t_nerr) && !defined(__polyspace_no_t_nerr)
#include <streams/tiuser.h>
#undef t_nerr
  extern int t_nerr;
#endif

#if defined(__polyspace_sysBus) && !defined(__polyspace_no_sysBus)
#include <sysLib.h>
#undef sysBus
  extern int sysBus;
#endif

#if defined(__polyspace_sysCpu) && !defined(__polyspace_no_sysCpu)
#include <sysLib.h>
#undef sysCpu
  extern int sysCpu;
#endif

#if defined(__polyspace_sysProcNum) && !defined(__polyspace_no_sysProcNum)
#include <sysLib.h>
#undef sysProcNum
  extern int sysProcNum;
#endif

#if defined(__polyspace_sysBootLine) && !defined(__polyspace_no_sysBootLine)
#include <sysLib.h>
#undef sysBootLine
  extern char * sysBootLine;
#endif

#if defined(__polyspace_sysExcMsg) && !defined(__polyspace_no_sysExcMsg)
#include <sysLib.h>
#undef sysExcMsg
  extern char * sysExcMsg;
#endif

#if defined(__polyspace_sysFlags) && !defined(__polyspace_no_sysFlags)
#include <sysLib.h>
#undef sysFlags
  extern int sysFlags;
#endif

#if defined(__polyspace_sysBootParams) && !defined(__polyspace_no_sysBootParams)
#include <sysLib.h>
#undef sysBootParams
  extern BOOT_PARAMS sysBootParams;
#endif

#if defined(__polyspace_sysBootHost) && !defined(__polyspace_no_sysBootHost)
#include <sysLib.h>
#undef sysBootHost
  extern char sysBootHost[];
#endif

#if defined(__polyspace_sysBootFile) && !defined(__polyspace_no_sysBootFile)
#include <sysLib.h>
#undef sysBootFile
  extern char sysBootFile[];
#endif

#if defined(__polyspace_standTbl) && !defined(__polyspace_no_standTbl)
#include <sysSymTbl.h>
#undef standTbl
  extern SYMBOL standTbl[];
#endif

#if defined(__polyspace_standTblSize) && !defined(__polyspace_no_standTblSize)
#include <sysSymTbl.h>
#undef standTblSize
  extern ULONG standTblSize;
#endif

#if defined(__polyspace_statSymTbl) && !defined(__polyspace_no_statSymTbl)
#include <sysSymTbl.h>
#undef statSymTbl
  extern SYMTAB_ID statSymTbl;
#endif

#if defined(__polyspace_statTbl) && !defined(__polyspace_no_statTbl)
#include <sysSymTbl.h>
#undef statTbl
  extern SYMBOL statTbl[];
#endif

#if defined(__polyspace_statTblSize) && !defined(__polyspace_no_statTblSize)
#include <sysSymTbl.h>
#undef statTblSize
  extern ULONG statTblSize;
#endif

#if defined(__polyspace_taskClassId) && !defined(__polyspace_no_taskClassId)
#include <taskLib.h>
#undef taskClassId
  extern CLASS_ID taskClassId;
#endif

#if defined(__polyspace_taskInstClassId) && !defined(__polyspace_no_taskInstClassId)
#include <taskLib.h>
#undef taskInstClassId
  extern CLASS_ID taskInstClassId;
#endif

#if defined(__polyspace_taskIdCurrent) && !defined(__polyspace_no_taskIdCurrent)
#include <taskLib.h>
#undef taskIdCurrent
  extern WIND_TCB *taskIdCurrent;
#endif

#if defined(__polyspace_taskPriRangeCheck) && !defined(__polyspace_no_taskPriRangeCheck)
#include <taskLib.h>
#undef taskPriRangeCheck
  extern BOOL  taskPriRangeCheck;
#endif

#if defined(__polyspace_vxTicks) && !defined(__polyspace_no_vxTicks)
#include <tickLib.h>
#undef vxTicks
  extern ULONG vxTicks;
#endif

#if defined(__polyspace_vxAbsTicks) && !defined(__polyspace_no_vxAbsTicks)
#include <tickLib.h>
#undef vxAbsTicks
  extern TICK vxAbsTicks;
#endif

#if defined(__polyspace__func_vxMemProbeHook) && !defined(__polyspace_no__func_vxMemProbeHook)
#include <vxLib.h>
#undef _func_vxMemProbeHook
  extern FUNCPTR _func_vxMemProbeHook;
#endif

#if defined(__polyspace_bplist) && !defined(__polyspace_no_bplist)
#include <wdb/wdbBpLib.h>
#undef bplist
  extern dll_t bplist;
#endif

#if defined(__polyspace_bpFreeList) && !defined(__polyspace_no_bpFreeList)
#include <wdb/wdbBpLib.h>
#undef bpFreeList
  extern dll_t bpFreeList;
#endif

#if defined(__polyspace_wdbCommMtu) && !defined(__polyspace_no_wdbCommMtu)
#include <wdb/wdbLibP.h>
#undef wdbCommMtu
  extern uint_t wdbCommMtu;
#endif

#if defined(__polyspace_wdbTgtMemBase) && !defined(__polyspace_no_wdbTgtMemBase)
#include <wdb/wdbLibP.h>
#undef wdbTgtMemBase
  extern uint_t wdbTgtMemBase;
#endif

#if defined(__polyspace_wdbTgtMemSize) && !defined(__polyspace_no_wdbTgtMemSize)
#include <wdb/wdbLibP.h>
#undef wdbTgtMemSize
  extern uint_t wdbTgtMemSize;
#endif

#if defined(__polyspace_wdbTgtNumMemRegions) && !defined(__polyspace_no_wdbTgtNumMemRegions)
#include <wdb/wdbLibP.h>
#undef wdbTgtNumMemRegions
  extern uint_t wdbTgtNumMemRegions;
#endif

#if defined(__polyspace_pWdbTgtMemRegions) && !defined(__polyspace_no_pWdbTgtMemRegions)
#include <wdb/wdbLibP.h>
#undef pWdbTgtMemRegions
  extern WDB_MEM_REGION * pWdbTgtMemRegions;
#endif

#if defined(__polyspace_pWdbRtIf) && !defined(__polyspace_no_pWdbRtIf)
#include <wdb/wdbRtIfLib.h>
#undef pWdbRtIf
  extern WDB_RT_IF *  pWdbRtIf;
#endif

#if defined(__polyspace_WTX_EVT_SYM_ADDED) && !defined(__polyspace_no_WTX_EVT_SYM_ADDED)
#include <wtx.h>
#undef WTX_EVT_SYM_ADDED
  extern const char WTX_EVT_SYM_ADDED[];
#endif

#if defined(__polyspace_WTX_EVT_SYM_REMOVED) && !defined(__polyspace_no_WTX_EVT_SYM_REMOVED)
#include <wtx.h>
#undef WTX_EVT_SYM_REMOVED
  extern const char WTX_EVT_SYM_REMOVED[];
#endif

#if defined(__polyspace_WTX_EVT_OBJ_LOADED) && !defined(__polyspace_no_WTX_EVT_OBJ_LOADED)
#include <wtx.h>
#undef WTX_EVT_OBJ_LOADED
  extern const char WTX_EVT_OBJ_LOADED[];
#endif

#if defined(__polyspace_WTX_EVT_OBJ_UNLOADED) && !defined(__polyspace_no_WTX_EVT_OBJ_UNLOADED)
#include <wtx.h>
#undef WTX_EVT_OBJ_UNLOADED
  extern const char WTX_EVT_OBJ_UNLOADED[];
#endif

#if defined(__polyspace_WTX_EVT_CTX_START) && !defined(__polyspace_no_WTX_EVT_CTX_START)
#include <wtx.h>
#undef WTX_EVT_CTX_START
  extern const char WTX_EVT_CTX_START[];
#endif

#if defined(__polyspace_WTX_EVT_CTX_EXIT) && !defined(__polyspace_no_WTX_EVT_CTX_EXIT)
#include <wtx.h>
#undef WTX_EVT_CTX_EXIT
  extern const char WTX_EVT_CTX_EXIT[];
#endif

#if defined(__polyspace_WTX_EVT_EXCEPTION) && !defined(__polyspace_no_WTX_EVT_EXCEPTION)
#include <wtx.h>
#undef WTX_EVT_EXCEPTION
  extern const char WTX_EVT_EXCEPTION[];
#endif

#if defined(__polyspace_WTX_EVT_VIO_WRITE) && !defined(__polyspace_no_WTX_EVT_VIO_WRITE)
#include <wtx.h>
#undef WTX_EVT_VIO_WRITE
  extern const char WTX_EVT_VIO_WRITE[];
#endif

#if defined(__polyspace_WTX_EVT_TOOL_ATTACH) && !defined(__polyspace_no_WTX_EVT_TOOL_ATTACH)
#include <wtx.h>
#undef WTX_EVT_TOOL_ATTACH
  extern const char WTX_EVT_TOOL_ATTACH[];
#endif

#if defined(__polyspace_WTX_EVT_TOOL_DETACH) && !defined(__polyspace_no_WTX_EVT_TOOL_DETACH)
#include <wtx.h>
#undef WTX_EVT_TOOL_DETACH
  extern const char WTX_EVT_TOOL_DETACH[];
#endif

#if defined(__polyspace_WTX_EVT_TOOL_MSG) && !defined(__polyspace_no_WTX_EVT_TOOL_MSG)
#include <wtx.h>
#undef WTX_EVT_TOOL_MSG
  extern const char WTX_EVT_TOOL_MSG[];
#endif

#if defined(__polyspace_WTX_EVT_TEXT_ACCESS) && !defined(__polyspace_no_WTX_EVT_TEXT_ACCESS)
#include <wtx.h>
#undef WTX_EVT_TEXT_ACCESS
  extern const char WTX_EVT_TEXT_ACCESS[];
#endif

#if defined(__polyspace_WTX_EVT_DATA_ACCESS) && !defined(__polyspace_no_WTX_EVT_DATA_ACCESS)
#include <wtx.h>
#undef WTX_EVT_DATA_ACCESS
  extern const char WTX_EVT_DATA_ACCESS[];
#endif

#if defined(__polyspace_WTX_EVT_CALL_RETURN) && !defined(__polyspace_no_WTX_EVT_CALL_RETURN)
#include <wtx.h>
#undef WTX_EVT_CALL_RETURN
  extern const char WTX_EVT_CALL_RETURN[];
#endif

#if defined(__polyspace_WTX_EVT_UNKNOWN) && !defined(__polyspace_no_WTX_EVT_UNKNOWN)
#include <wtx.h>
#undef WTX_EVT_UNKNOWN
  extern const char WTX_EVT_UNKNOWN[];
#endif

#if defined(__polyspace_WTX_EVT_USER) && !defined(__polyspace_no_WTX_EVT_USER)
#include <wtx.h>
#undef WTX_EVT_USER
  extern const char WTX_EVT_USER[];
#endif


/****************************************************************************
 *  NON-STD LIBRARIES - OS-TARGET VISUAL
 ****************************************************************************/
#elif defined(__OS_VISUAL)


#if defined(__polyspace___MIDL_itf_activscp_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_activscp_0000_v0_0_c_ifspec)
#include <activscp.h>
#undef __MIDL_itf_activscp_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_activscp_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_activscp_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_activscp_0000_v0_0_s_ifspec)
#include <activscp.h>
#undef __MIDL_itf_activscp_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_activscp_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_activscp_0215_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_activscp_0215_v0_0_c_ifspec)
#include <activscp.h>
#undef __MIDL_itf_activscp_0215_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_activscp_0215_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_activscp_0215_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_activscp_0215_v0_0_s_ifspec)
#include <activscp.h>
#undef __MIDL_itf_activscp_0215_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_activscp_0215_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_activscp_0216_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_activscp_0216_v0_0_c_ifspec)
#include <activscp.h>
#undef __MIDL_itf_activscp_0216_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_activscp_0216_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_activscp_0216_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_activscp_0216_v0_0_s_ifspec)
#include <activscp.h>
#undef __MIDL_itf_activscp_0216_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_activscp_0216_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_activscp_0217_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_activscp_0217_v0_0_c_ifspec)
#include <activscp.h>
#undef __MIDL_itf_activscp_0217_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_activscp_0217_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_activscp_0217_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_activscp_0217_v0_0_s_ifspec)
#include <activscp.h>
#undef __MIDL_itf_activscp_0217_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_activscp_0217_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_activscp_0221_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_activscp_0221_v0_0_c_ifspec)
#include <activscp.h>
#undef __MIDL_itf_activscp_0221_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_activscp_0221_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_activscp_0221_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_activscp_0221_v0_0_s_ifspec)
#include <activscp.h>
#undef __MIDL_itf_activscp_0221_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_activscp_0221_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_admex_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_admex_0000_v0_0_c_ifspec)
#include <admex.h>
#undef __MIDL_itf_admex_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_admex_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_admex_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_admex_0000_v0_0_s_ifspec)
#include <admex.h>
#undef __MIDL_itf_admex_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_admex_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_admex_0213_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_admex_0213_v0_0_c_ifspec)
#include <admex.h>
#undef __MIDL_itf_admex_0213_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_admex_0213_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_admex_0213_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_admex_0213_v0_0_s_ifspec)
#include <admex.h>
#undef __MIDL_itf_admex_0213_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_admex_0213_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_admex_0214_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_admex_0214_v0_0_c_ifspec)
#include <admex.h>
#undef __MIDL_itf_admex_0214_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_admex_0214_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_admex_0214_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_admex_0214_v0_0_s_ifspec)
#include <admex.h>
#undef __MIDL_itf_admex_0214_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_admex_0214_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_m_bobj_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_m_bobj_0000_v0_0_c_ifspec)
#include <adoint.h>
#undef __MIDL_itf_m_bobj_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_m_bobj_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_m_bobj_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_m_bobj_0000_v0_0_s_ifspec)
#include <adoint.h>
#undef __MIDL_itf_m_bobj_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_m_bobj_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_ADOMD_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_ADOMD_0000_v0_0_c_ifspec)
#include <adomd.h>
#undef __MIDL_itf_ADOMD_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_ADOMD_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_ADOMD_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_ADOMD_0000_v0_0_s_ifspec)
#include <adomd.h>
#undef __MIDL_itf_ADOMD_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_ADOMD_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace_ADsMemList) && !defined(__polyspace_no_ADsMemList)
#include <adshlp.h>
#undef ADsMemList
  extern LIST_ENTRY ADsMemList;
#endif

#if defined(__polyspace_ADsMemCritSect) && !defined(__polyspace_no_ADsMemCritSect)
#include <adshlp.h>
#undef ADsMemCritSect
  extern CRITICAL_SECTION ADsMemCritSect;
#endif

#if defined(__polyspace_IID_IADs) && !defined(__polyspace_no_IID_IADs)
#include <adsiid.h>
#undef IID_IADs
  extern const GUID IID_IADs;
#endif

#if defined(__polyspace_IID_IADsContainer) && !defined(__polyspace_no_IID_IADsContainer)
#include <adsiid.h>
#undef IID_IADsContainer
  extern const GUID IID_IADsContainer;
#endif

#if defined(__polyspace_IID_IADsNamespaces) && !defined(__polyspace_no_IID_IADsNamespaces)
#include <adsiid.h>
#undef IID_IADsNamespaces
  extern const GUID IID_IADsNamespaces;
#endif

#if defined(__polyspace_IID_IADsDomain) && !defined(__polyspace_no_IID_IADsDomain)
#include <adsiid.h>
#undef IID_IADsDomain
  extern const GUID IID_IADsDomain;
#endif

#if defined(__polyspace_IID_IADsUser) && !defined(__polyspace_no_IID_IADsUser)
#include <adsiid.h>
#undef IID_IADsUser
  extern const GUID IID_IADsUser;
#endif

#if defined(__polyspace_IID_IADsComputerOperations) && !defined(__polyspace_no_IID_IADsComputerOperations)
#include <adsiid.h>
#undef IID_IADsComputerOperations
  extern const GUID IID_IADsComputerOperations;
#endif

#if defined(__polyspace_IID_IADsComputer) && !defined(__polyspace_no_IID_IADsComputer)
#include <adsiid.h>
#undef IID_IADsComputer
  extern const GUID IID_IADsComputer;
#endif

#if defined(__polyspace_IID_IADsGroup) && !defined(__polyspace_no_IID_IADsGroup)
#include <adsiid.h>
#undef IID_IADsGroup
  extern const GUID IID_IADsGroup;
#endif

#if defined(__polyspace_IID_IADsMembers) && !defined(__polyspace_no_IID_IADsMembers)
#include <adsiid.h>
#undef IID_IADsMembers
  extern const GUID IID_IADsMembers;
#endif

#if defined(__polyspace_IID_IADsPrintQueue) && !defined(__polyspace_no_IID_IADsPrintQueue)
#include <adsiid.h>
#undef IID_IADsPrintQueue
  extern const GUID IID_IADsPrintQueue;
#endif

#if defined(__polyspace_IID_IADsPrintQueueOperations) && !defined(__polyspace_no_IID_IADsPrintQueueOperations)
#include <adsiid.h>
#undef IID_IADsPrintQueueOperations
  extern const GUID IID_IADsPrintQueueOperations;
#endif

#if defined(__polyspace_IID_IADsPrintJobOperations) && !defined(__polyspace_no_IID_IADsPrintJobOperations)
#include <adsiid.h>
#undef IID_IADsPrintJobOperations
  extern const GUID IID_IADsPrintJobOperations;
#endif

#if defined(__polyspace_IID_IADsPrintJob) && !defined(__polyspace_no_IID_IADsPrintJob)
#include <adsiid.h>
#undef IID_IADsPrintJob
  extern const GUID IID_IADsPrintJob;
#endif

#if defined(__polyspace_IID_IADsCollection) && !defined(__polyspace_no_IID_IADsCollection)
#include <adsiid.h>
#undef IID_IADsCollection
  extern const GUID IID_IADsCollection;
#endif

#if defined(__polyspace_IID_IADsServiceOperations) && !defined(__polyspace_no_IID_IADsServiceOperations)
#include <adsiid.h>
#undef IID_IADsServiceOperations
  extern const GUID IID_IADsServiceOperations;
#endif

#if defined(__polyspace_IID_IADsService) && !defined(__polyspace_no_IID_IADsService)
#include <adsiid.h>
#undef IID_IADsService
  extern const GUID IID_IADsService;
#endif

#if defined(__polyspace_IID_IADsFileServiceOperations) && !defined(__polyspace_no_IID_IADsFileServiceOperations)
#include <adsiid.h>
#undef IID_IADsFileServiceOperations
  extern const GUID IID_IADsFileServiceOperations;
#endif

#if defined(__polyspace_IID_IADsFileService) && !defined(__polyspace_no_IID_IADsFileService)
#include <adsiid.h>
#undef IID_IADsFileService
  extern const GUID IID_IADsFileService;
#endif

#if defined(__polyspace_IID_IADsResource) && !defined(__polyspace_no_IID_IADsResource)
#include <adsiid.h>
#undef IID_IADsResource
  extern const GUID IID_IADsResource;
#endif

#if defined(__polyspace_IID_IADsSession) && !defined(__polyspace_no_IID_IADsSession)
#include <adsiid.h>
#undef IID_IADsSession
  extern const GUID IID_IADsSession;
#endif

#if defined(__polyspace_IID_IADsFileShare) && !defined(__polyspace_no_IID_IADsFileShare)
#include <adsiid.h>
#undef IID_IADsFileShare
  extern const GUID IID_IADsFileShare;
#endif

#if defined(__polyspace_IID_IADsSchema) && !defined(__polyspace_no_IID_IADsSchema)
#include <adsiid.h>
#undef IID_IADsSchema
  extern const GUID IID_IADsSchema;
#endif

#if defined(__polyspace_IID_IADsClass) && !defined(__polyspace_no_IID_IADsClass)
#include <adsiid.h>
#undef IID_IADsClass
  extern const GUID IID_IADsClass;
#endif

#if defined(__polyspace_IID_IADsProperty) && !defined(__polyspace_no_IID_IADsProperty)
#include <adsiid.h>
#undef IID_IADsProperty
  extern const GUID IID_IADsProperty;
#endif

#if defined(__polyspace_IID_IADsSyntax) && !defined(__polyspace_no_IID_IADsSyntax)
#include <adsiid.h>
#undef IID_IADsSyntax
  extern const GUID IID_IADsSyntax;
#endif

#if defined(__polyspace_IID_IADsLocality) && !defined(__polyspace_no_IID_IADsLocality)
#include <adsiid.h>
#undef IID_IADsLocality
  extern const GUID IID_IADsLocality;
#endif

#if defined(__polyspace_IID_IADsO) && !defined(__polyspace_no_IID_IADsO)
#include <adsiid.h>
#undef IID_IADsO
  extern const GUID IID_IADsO;
#endif

#if defined(__polyspace_IID_IADsOU) && !defined(__polyspace_no_IID_IADsOU)
#include <adsiid.h>
#undef IID_IADsOU
  extern const GUID IID_IADsOU;
#endif

#if defined(__polyspace_IID_IADsOpenDSObject) && !defined(__polyspace_no_IID_IADsOpenDSObject)
#include <adsiid.h>
#undef IID_IADsOpenDSObject
  extern const GUID IID_IADsOpenDSObject;
#endif

#if defined(__polyspace_IID_IADsSearch) && !defined(__polyspace_no_IID_IADsSearch)
#include <adsiid.h>
#undef IID_IADsSearch
  extern const GUID IID_IADsSearch;
#endif

#if defined(__polyspace_IID_IADsPropertyList) && !defined(__polyspace_no_IID_IADsPropertyList)
#include <adsiid.h>
#undef IID_IADsPropertyList
  extern const GUID IID_IADsPropertyList;
#endif

#if defined(__polyspace_IID_IDSObject) && !defined(__polyspace_no_IID_IDSObject)
#include <adsiid.h>
#undef IID_IDSObject
  extern const GUID IID_IDSObject;
#endif

#if defined(__polyspace_IID_IDSSearch) && !defined(__polyspace_no_IID_IDSSearch)
#include <adsiid.h>
#undef IID_IDSSearch
  extern const GUID IID_IDSSearch;
#endif

#if defined(__polyspace_IID_IDSAttrMgmt) && !defined(__polyspace_no_IID_IDSAttrMgmt)
#include <adsiid.h>
#undef IID_IDSAttrMgmt
  extern const GUID IID_IDSAttrMgmt;
#endif

#if defined(__polyspace_IID_IDirectorySearch) && !defined(__polyspace_no_IID_IDirectorySearch)
#include <adsiid.h>
#undef IID_IDirectorySearch
  extern const GUID IID_IDirectorySearch;
#endif

#if defined(__polyspace_IID_IDirectoryObject) && !defined(__polyspace_no_IID_IDirectoryObject)
#include <adsiid.h>
#undef IID_IDirectoryObject
  extern const GUID IID_IDirectoryObject;
#endif

#if defined(__polyspace_IID_IDirectoryAttrMgmt) && !defined(__polyspace_no_IID_IDirectoryAttrMgmt)
#include <adsiid.h>
#undef IID_IDirectoryAttrMgmt
  extern const GUID IID_IDirectoryAttrMgmt;
#endif

#if defined(__polyspace_CLSID_ADsDSOObject) && !defined(__polyspace_no_CLSID_ADsDSOObject)
#include <adsiid.h>
#undef CLSID_ADsDSOObject
  extern const GUID CLSID_ADsDSOObject;
#endif

#if defined(__polyspace_DBGUID_LDAPDialect) && !defined(__polyspace_no_DBGUID_LDAPDialect)
#include <adsiid.h>
#undef DBGUID_LDAPDialect
  extern const GUID DBGUID_LDAPDialect;
#endif

#if defined(__polyspace_DBPROPSET_ADSISEARCH) && !defined(__polyspace_no_DBPROPSET_ADSISEARCH)
#include <adsiid.h>
#undef DBPROPSET_ADSISEARCH
  extern const GUID DBPROPSET_ADSISEARCH;
#endif

#if defined(__polyspace___MIDL_itf_AgentControl_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_AgentControl_0000_v0_0_c_ifspec)
#include <agtctl.h>
#undef __MIDL_itf_AgentControl_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_AgentControl_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_AgentControl_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_AgentControl_0000_v0_0_s_ifspec)
#include <agtctl.h>
#undef __MIDL_itf_AgentControl_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_AgentControl_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_AgentServer_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_AgentServer_0000_v0_0_c_ifspec)
#include <agtsvr.h>
#undef __MIDL_itf_AgentServer_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_AgentServer_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_AgentServer_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_AgentServer_0000_v0_0_s_ifspec)
#include <agtsvr.h>
#undef __MIDL_itf_AgentServer_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_AgentServer_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_AgentServer_0147_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_AgentServer_0147_v0_0_c_ifspec)
#include <agtsvr.h>
#undef __MIDL_itf_AgentServer_0147_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_AgentServer_0147_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_AgentServer_0147_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_AgentServer_0147_v0_0_s_ifspec)
#include <agtsvr.h>
#undef __MIDL_itf_AgentServer_0147_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_AgentServer_0147_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_amrtpdmx_0296_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_amrtpdmx_0296_v0_0_c_ifspec)
#include <amrtpdmx.h>
#undef __MIDL_itf_amrtpdmx_0296_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_amrtpdmx_0296_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_amrtpdmx_0296_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_amrtpdmx_0296_v0_0_s_ifspec)
#include <amrtpdmx.h>
#undef __MIDL_itf_amrtpdmx_0296_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_amrtpdmx_0296_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_amrtpss_0094_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_amrtpss_0094_v0_0_c_ifspec)
#include <amrtpss.h>
#undef __MIDL_itf_amrtpss_0094_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_amrtpss_0094_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_amrtpss_0094_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_amrtpss_0094_v0_0_s_ifspec)
#include <amrtpss.h>
#undef __MIDL_itf_amrtpss_0094_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_amrtpss_0094_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_amstream_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_amstream_0000_v0_0_c_ifspec)
#include <amstream.h>
#undef __MIDL_itf_amstream_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_amstream_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_amstream_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_amstream_0000_v0_0_s_ifspec)
#include <amstream.h>
#undef __MIDL_itf_amstream_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_amstream_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_amstream_0239_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_amstream_0239_v0_0_c_ifspec)
#include <amstream.h>
#undef __MIDL_itf_amstream_0239_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_amstream_0239_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_amstream_0239_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_amstream_0239_v0_0_s_ifspec)
#include <amstream.h>
#undef __MIDL_itf_amstream_0239_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_amstream_0239_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_austream_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_austream_0000_v0_0_c_ifspec)
#include <austream.h>
#undef __MIDL_itf_austream_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_austream_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_austream_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_austream_0000_v0_0_s_ifspec)
#include <austream.h>
#undef __MIDL_itf_austream_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_austream_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace_g_strBaseRegKey) && !defined(__polyspace_no_g_strBaseRegKey)
#include <bpcreg.h>
#undef g_strBaseRegKey
  extern const LPCTSTR g_strBaseRegKey;
#endif

#if defined(__polyspace_g_strProductDir) && !defined(__polyspace_no_g_strProductDir)
#include <bpcreg.h>
#undef g_strProductDir
  extern const LPCTSTR g_strProductDir;
#endif

#if defined(__polyspace_g_strDBFile) && !defined(__polyspace_no_g_strDBFile)
#include <bpcreg.h>
#undef g_strDBFile
  extern const LPCTSTR g_strDBFile;
#endif

#if defined(__polyspace_g_strDBReplacementFile) && !defined(__polyspace_no_g_strDBReplacementFile)
#include <bpcreg.h>
#undef g_strDBReplacementFile
  extern const LPCTSTR g_strDBReplacementFile;
#endif

#if defined(__polyspace_g_strEPGDBFile) && !defined(__polyspace_no_g_strEPGDBFile)
#include <bpcreg.h>
#undef g_strEPGDBFile
  extern const LPCTSTR g_strEPGDBFile;
#endif

#if defined(__polyspace_g_strDefVBITS) && !defined(__polyspace_no_g_strDefVBITS)
#include <bpcreg.h>
#undef g_strDefVBITS
  extern const LPCTSTR g_strDefVBITS;
#endif

#if defined(__polyspace_g_strDefVBIChan) && !defined(__polyspace_no_g_strDefVBIChan)
#include <bpcreg.h>
#undef g_strDefVBIChan
  extern const LPCTSTR g_strDefVBIChan;
#endif

#if defined(__polyspace_g_strSysFile) && !defined(__polyspace_no_g_strSysFile)
#include <bpcreg.h>
#undef g_strSysFile
  extern const LPCTSTR g_strSysFile;
#endif

#if defined(__polyspace_g_strAMFilter) && !defined(__polyspace_no_g_strAMFilter)
#include <bpcreg.h>
#undef g_strAMFilter
  extern const LPCTSTR g_strAMFilter;
#endif

#if defined(__polyspace_g_strAMFClass) && !defined(__polyspace_no_g_strAMFClass)
#include <bpcreg.h>
#undef g_strAMFClass
  extern const LPCTSTR g_strAMFClass;
#endif

#if defined(__polyspace_g_strTSInputType) && !defined(__polyspace_no_g_strTSInputType)
#include <bpcreg.h>
#undef g_strTSInputType
  extern const LPCTSTR g_strTSInputType;
#endif

#if defined(__polyspace_g_strCountryCode) && !defined(__polyspace_no_g_strCountryCode)
#include <bpcreg.h>
#undef g_strCountryCode
  extern const LPCTSTR g_strCountryCode;
#endif

#if defined(__polyspace_g_strVolume) && !defined(__polyspace_no_g_strVolume)
#include <bpcreg.h>
#undef g_strVolume
  extern const LPCTSTR g_strVolume;
#endif

#if defined(__polyspace_g_strBalance) && !defined(__polyspace_no_g_strBalance)
#include <bpcreg.h>
#undef g_strBalance
  extern const LPCTSTR g_strBalance;
#endif

#if defined(__polyspace_g_strAudioPin) && !defined(__polyspace_no_g_strAudioPin)
#include <bpcreg.h>
#undef g_strAudioPin
  extern const LPCTSTR g_strAudioPin;
#endif

#if defined(__polyspace_g_strTVXRegKey) && !defined(__polyspace_no_g_strTVXRegKey)
#include <bpcreg.h>
#undef g_strTVXRegKey
  extern const LPCTSTR g_strTVXRegKey;
#endif

#if defined(__polyspace_g_strNTSC) && !defined(__polyspace_no_g_strNTSC)
#include <bpcreg.h>
#undef g_strNTSC
  extern const LPCTSTR g_strNTSC;
#endif

#if defined(__polyspace_g_strDistanceViewing) && !defined(__polyspace_no_g_strDistanceViewing)
#include <bpcreg.h>
#undef g_strDistanceViewing
  extern const LPCTSTR g_strDistanceViewing;
#endif

#if defined(__polyspace_g_strConfigRegKey) && !defined(__polyspace_no_g_strConfigRegKey)
#include <bpcreg.h>
#undef g_strConfigRegKey
  extern const LPCTSTR g_strConfigRegKey;
#endif

#if defined(__polyspace_g_strConfigLastPage) && !defined(__polyspace_no_g_strConfigLastPage)
#include <bpcreg.h>
#undef g_strConfigLastPage
  extern const LPCTSTR g_strConfigLastPage;
#endif

#if defined(__polyspace_g_strTuningSpaceRegKey) && !defined(__polyspace_no_g_strTuningSpaceRegKey)
#include <bpcreg.h>
#undef g_strTuningSpaceRegKey
  extern const LPCTSTR g_strTuningSpaceRegKey;
#endif

#if defined(__polyspace_g_strTuningSpaceName) && !defined(__polyspace_no_g_strTuningSpaceName)
#include <bpcreg.h>
#undef g_strTuningSpaceName
  extern const LPCTSTR g_strTuningSpaceName;
#endif

#if defined(__polyspace_g_strCurTVTuningSpace) && !defined(__polyspace_no_g_strCurTVTuningSpace)
#include <bpcreg.h>
#undef g_strCurTVTuningSpace
  extern const LPCTSTR g_strCurTVTuningSpace;
#endif

#if defined(__polyspace_g_strDSSTuningSpaceRegKey) && !defined(__polyspace_no_g_strDSSTuningSpaceRegKey)
#include <bpcreg.h>
#undef g_strDSSTuningSpaceRegKey
  extern const LPCTSTR g_strDSSTuningSpaceRegKey;
#endif

#if defined(__polyspace_g_strLCIDToSTYPE) && !defined(__polyspace_no_g_strLCIDToSTYPE)
#include <bpcreg.h>
#undef g_strLCIDToSTYPE
  extern const LPCTSTR g_strLCIDToSTYPE;
#endif

#if defined(__polyspace_g_strCAProviderRegKey) && !defined(__polyspace_no_g_strCAProviderRegKey)
#include <bpcreg.h>
#undef g_strCAProviderRegKey
  extern const LPCTSTR g_strCAProviderRegKey;
#endif

#if defined(__polyspace_g_strCAProviderName) && !defined(__polyspace_no_g_strCAProviderName)
#include <bpcreg.h>
#undef g_strCAProviderName
  extern const LPCTSTR g_strCAProviderName;
#endif

#if defined(__polyspace_g_strCAProviderDesc) && !defined(__polyspace_no_g_strCAProviderDesc)
#include <bpcreg.h>
#undef g_strCAProviderDesc
  extern const LPCTSTR g_strCAProviderDesc;
#endif

#if defined(__polyspace_g_strVenPrefix) && !defined(__polyspace_no_g_strVenPrefix)
#include <bpcreg.h>
#undef g_strVenPrefix
  extern const LPCTSTR g_strVenPrefix;
#endif

#if defined(__polyspace_g_strDevPrefix) && !defined(__polyspace_no_g_strDevPrefix)
#include <bpcreg.h>
#undef g_strDevPrefix
  extern const LPCTSTR g_strDevPrefix;
#endif

#if defined(__polyspace_g_strEPGRegKey) && !defined(__polyspace_no_g_strEPGRegKey)
#include <bpcreg.h>
#undef g_strEPGRegKey
  extern const LPCTSTR g_strEPGRegKey;
#endif

#if defined(__polyspace_g_strEPGLoadersRegKey) && !defined(__polyspace_no_g_strEPGLoadersRegKey)
#include <bpcreg.h>
#undef g_strEPGLoadersRegKey
  extern const LPCTSTR g_strEPGLoadersRegKey;
#endif

#if defined(__polyspace_g_strEPGLoaderAttempt) && !defined(__polyspace_no_g_strEPGLoaderAttempt)
#include <bpcreg.h>
#undef g_strEPGLoaderAttempt
  extern const LPCTSTR g_strEPGLoaderAttempt;
#endif

#if defined(__polyspace_g_strEPGLoaderAttemptTime) && !defined(__polyspace_no_g_strEPGLoaderAttemptTime)
#include <bpcreg.h>
#undef g_strEPGLoaderAttemptTime
  extern const LPCTSTR g_strEPGLoaderAttemptTime;
#endif

#if defined(__polyspace_g_strEPGLoaderCompletion) && !defined(__polyspace_no_g_strEPGLoaderCompletion)
#include <bpcreg.h>
#undef g_strEPGLoaderCompletion
  extern const LPCTSTR g_strEPGLoaderCompletion;
#endif

#if defined(__polyspace_g_strEPGLoaderCompletionTime) && !defined(__polyspace_no_g_strEPGLoaderCompletionTime)
#include <bpcreg.h>
#undef g_strEPGLoaderCompletionTime
  extern const LPCTSTR g_strEPGLoaderCompletionTime;
#endif

#if defined(__polyspace_g_strEPGLoaderCompletionResult) && !defined(__polyspace_no_g_strEPGLoaderCompletionResult)
#include <bpcreg.h>
#undef g_strEPGLoaderCompletionResult
  extern const LPCTSTR g_strEPGLoaderCompletionResult;
#endif

#if defined(__polyspace_g_strEPGLoaderName) && !defined(__polyspace_no_g_strEPGLoaderName)
#include <bpcreg.h>
#undef g_strEPGLoaderName
  extern const LPCTSTR g_strEPGLoaderName;
#endif

#if defined(__polyspace_g_strEPGLoaderTuningID) && !defined(__polyspace_no_g_strEPGLoaderTuningID)
#include <bpcreg.h>
#undef g_strEPGLoaderTuningID
  extern const LPCTSTR g_strEPGLoaderTuningID;
#endif

#if defined(__polyspace_g_strLoaderPostalCode) && !defined(__polyspace_no_g_strLoaderPostalCode)
#include <bpcreg.h>
#undef g_strLoaderPostalCode
  extern const LPCTSTR g_strLoaderPostalCode;
#endif

#if defined(__polyspace_g_strLoaderReadPrefix) && !defined(__polyspace_no_g_strLoaderReadPrefix)
#include <bpcreg.h>
#undef g_strLoaderReadPrefix
  extern const LPCTSTR g_strLoaderReadPrefix;
#endif

#if defined(__polyspace_g_strLoaderWritePrefix) && !defined(__polyspace_no_g_strLoaderWritePrefix)
#include <bpcreg.h>
#undef g_strLoaderWritePrefix
  extern const LPCTSTR g_strLoaderWritePrefix;
#endif

#if defined(__polyspace_g_strLoaderReadFile) && !defined(__polyspace_no_g_strLoaderReadFile)
#include <bpcreg.h>
#undef g_strLoaderReadFile
  extern const LPCTSTR g_strLoaderReadFile;
#endif

#if defined(__polyspace_g_strDTVLoaderCSSByte) && !defined(__polyspace_no_g_strDTVLoaderCSSByte)
#include <bpcreg.h>
#undef g_strDTVLoaderCSSByte
  extern const LPCTSTR g_strDTVLoaderCSSByte;
#endif

#if defined(__polyspace_g_strSSLoaderRegionID) && !defined(__polyspace_no_g_strSSLoaderRegionID)
#include <bpcreg.h>
#undef g_strSSLoaderRegionID
  extern const LPCTSTR g_strSSLoaderRegionID;
#endif

#if defined(__polyspace_g_strSSLoaderChannel) && !defined(__polyspace_no_g_strSSLoaderChannel)
#include <bpcreg.h>
#undef g_strSSLoaderChannel
  extern const LPCTSTR g_strSSLoaderChannel;
#endif

#if defined(__polyspace_g_strSSLoaderLine) && !defined(__polyspace_no_g_strSSLoaderLine)
#include <bpcreg.h>
#undef g_strSSLoaderLine
  extern const LPCTSTR g_strSSLoaderLine;
#endif

#if defined(__polyspace_g_strSSLoaderScanReturnCode) && !defined(__polyspace_no_g_strSSLoaderScanReturnCode)
#include <bpcreg.h>
#undef g_strSSLoaderScanReturnCode
  extern const LPCTSTR g_strSSLoaderScanReturnCode;
#endif

#if defined(__polyspace_g_strSSLoaderListenReturnCode) && !defined(__polyspace_no_g_strSSLoaderListenReturnCode)
#include <bpcreg.h>
#undef g_strSSLoaderListenReturnCode
  extern const LPCTSTR g_strSSLoaderListenReturnCode;
#endif

#if defined(__polyspace_g_strSSLoaderListenReturnCodeCount) && !defined(__polyspace_no_g_strSSLoaderListenReturnCodeCount)
#include <bpcreg.h>
#undef g_strSSLoaderListenReturnCodeCount
  extern const LPCTSTR g_strSSLoaderListenReturnCodeCount;
#endif

#if defined(__polyspace_g_strDEBUG) && !defined(__polyspace_no_g_strDEBUG)
#include <bpcreg.h>
#undef g_strDEBUG
  extern const LPCTSTR g_strDEBUG;
#endif

#if defined(__polyspace_g_strTrace) && !defined(__polyspace_no_g_strTrace)
#include <bpcreg.h>
#undef g_strTrace
  extern const LPCTSTR g_strTrace;
#endif

#if defined(__polyspace_g_BridgeCallbacks) && !defined(__polyspace_no_g_BridgeCallbacks)
#include <bridge.h>
#undef g_BridgeCallbacks
  extern MSBDN_BRIDGE_CALLBACKS g_BridgeCallbacks;
#endif

#if defined(__polyspace___MIDL_itf_certadm_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_certadm_0000_v0_0_c_ifspec)
#include <certadm.h>
#undef __MIDL_itf_certadm_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_certadm_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_certadm_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_certadm_0000_v0_0_s_ifspec)
#include <certadm.h>
#undef __MIDL_itf_certadm_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_certadm_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_certcli_0097_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_certcli_0097_v0_0_c_ifspec)
#include <certcli.h>
#undef __MIDL_itf_certcli_0097_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_certcli_0097_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_certcli_0097_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_certcli_0097_v0_0_s_ifspec)
#include <certcli.h>
#undef __MIDL_itf_certcli_0097_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_certcli_0097_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_certexit_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_certexit_0000_v0_0_c_ifspec)
#include <certexit.h>
#undef __MIDL_itf_certexit_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_certexit_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_certexit_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_certexit_0000_v0_0_s_ifspec)
#include <certexit.h>
#undef __MIDL_itf_certexit_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_certexit_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_certif_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_certif_0000_v0_0_c_ifspec)
#include <certif.h>
#undef __MIDL_itf_certif_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_certif_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_certif_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_certif_0000_v0_0_s_ifspec)
#include <certif.h>
#undef __MIDL_itf_certif_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_certif_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace_IID_IRpcChannel) && !defined(__polyspace_no_IID_IRpcChannel)
#include <cguid.h>
#undef IID_IRpcChannel
  extern const IID IID_IRpcChannel;
#endif

#if defined(__polyspace_IID_IRpcStub) && !defined(__polyspace_no_IID_IRpcStub)
#include <cguid.h>
#undef IID_IRpcStub
  extern const IID IID_IRpcStub;
#endif

#if defined(__polyspace_IID_IStubManager) && !defined(__polyspace_no_IID_IStubManager)
#include <cguid.h>
#undef IID_IStubManager
  extern const IID IID_IStubManager;
#endif

#if defined(__polyspace_IID_IRpcProxy) && !defined(__polyspace_no_IID_IRpcProxy)
#include <cguid.h>
#undef IID_IRpcProxy
  extern const IID IID_IRpcProxy;
#endif

#if defined(__polyspace_IID_IProxyManager) && !defined(__polyspace_no_IID_IProxyManager)
#include <cguid.h>
#undef IID_IProxyManager
  extern const IID IID_IProxyManager;
#endif

#if defined(__polyspace_IID_IPSFactory) && !defined(__polyspace_no_IID_IPSFactory)
#include <cguid.h>
#undef IID_IPSFactory
  extern const IID IID_IPSFactory;
#endif

#if defined(__polyspace_IID_IInternalMoniker) && !defined(__polyspace_no_IID_IInternalMoniker)
#include <cguid.h>
#undef IID_IInternalMoniker
  extern const IID IID_IInternalMoniker;
#endif

#if defined(__polyspace_IID_IDfReserved1) && !defined(__polyspace_no_IID_IDfReserved1)
#include <cguid.h>
#undef IID_IDfReserved1
  extern const IID IID_IDfReserved1;
#endif

#if defined(__polyspace_IID_IDfReserved2) && !defined(__polyspace_no_IID_IDfReserved2)
#include <cguid.h>
#undef IID_IDfReserved2
  extern const IID IID_IDfReserved2;
#endif

#if defined(__polyspace_IID_IDfReserved3) && !defined(__polyspace_no_IID_IDfReserved3)
#include <cguid.h>
#undef IID_IDfReserved3
  extern const IID IID_IDfReserved3;
#endif

#if defined(__polyspace_CLSID_StdMarshal) && !defined(__polyspace_no_CLSID_StdMarshal)
#include <cguid.h>
#undef CLSID_StdMarshal
  extern const CLSID CLSID_StdMarshal;
#endif

#if defined(__polyspace_CLSID_AggStdMarshal) && !defined(__polyspace_no_CLSID_AggStdMarshal)
#include <cguid.h>
#undef CLSID_AggStdMarshal
  extern const CLSID CLSID_AggStdMarshal;
#endif

#if defined(__polyspace_CLSID_StdAsyncActManager) && !defined(__polyspace_no_CLSID_StdAsyncActManager)
#include <cguid.h>
#undef CLSID_StdAsyncActManager
  extern const CLSID CLSID_StdAsyncActManager;
#endif

#if defined(__polyspace_IID_IStub) && !defined(__polyspace_no_IID_IStub)
#include <cguid.h>
#undef IID_IStub
  extern const IID IID_IStub;
#endif

#if defined(__polyspace_IID_IProxy) && !defined(__polyspace_no_IID_IProxy)
#include <cguid.h>
#undef IID_IProxy
  extern const IID IID_IProxy;
#endif

#if defined(__polyspace_IID_IEnumGeneric) && !defined(__polyspace_no_IID_IEnumGeneric)
#include <cguid.h>
#undef IID_IEnumGeneric
  extern const IID IID_IEnumGeneric;
#endif

#if defined(__polyspace_IID_IEnumHolder) && !defined(__polyspace_no_IID_IEnumHolder)
#include <cguid.h>
#undef IID_IEnumHolder
  extern const IID IID_IEnumHolder;
#endif

#if defined(__polyspace_IID_IEnumCallback) && !defined(__polyspace_no_IID_IEnumCallback)
#include <cguid.h>
#undef IID_IEnumCallback
  extern const IID IID_IEnumCallback;
#endif

#if defined(__polyspace_IID_IOleManager) && !defined(__polyspace_no_IID_IOleManager)
#include <cguid.h>
#undef IID_IOleManager
  extern const IID IID_IOleManager;
#endif

#if defined(__polyspace_IID_IOlePresObj) && !defined(__polyspace_no_IID_IOlePresObj)
#include <cguid.h>
#undef IID_IOlePresObj
  extern const IID IID_IOlePresObj;
#endif

#if defined(__polyspace_IID_IDebug) && !defined(__polyspace_no_IID_IDebug)
#include <cguid.h>
#undef IID_IDebug
  extern const IID IID_IDebug;
#endif

#if defined(__polyspace_IID_IDebugStream) && !defined(__polyspace_no_IID_IDebugStream)
#include <cguid.h>
#undef IID_IDebugStream
  extern const IID IID_IDebugStream;
#endif

#if defined(__polyspace_CLSID_PSGenObject) && !defined(__polyspace_no_CLSID_PSGenObject)
#include <cguid.h>
#undef CLSID_PSGenObject
  extern const CLSID CLSID_PSGenObject;
#endif

#if defined(__polyspace_CLSID_PSClientSite) && !defined(__polyspace_no_CLSID_PSClientSite)
#include <cguid.h>
#undef CLSID_PSClientSite
  extern const CLSID CLSID_PSClientSite;
#endif

#if defined(__polyspace_CLSID_PSClassObject) && !defined(__polyspace_no_CLSID_PSClassObject)
#include <cguid.h>
#undef CLSID_PSClassObject
  extern const CLSID CLSID_PSClassObject;
#endif

#if defined(__polyspace_CLSID_PSInPlaceActive) && !defined(__polyspace_no_CLSID_PSInPlaceActive)
#include <cguid.h>
#undef CLSID_PSInPlaceActive
  extern const CLSID CLSID_PSInPlaceActive;
#endif

#if defined(__polyspace_CLSID_PSInPlaceFrame) && !defined(__polyspace_no_CLSID_PSInPlaceFrame)
#include <cguid.h>
#undef CLSID_PSInPlaceFrame
  extern const CLSID CLSID_PSInPlaceFrame;
#endif

#if defined(__polyspace_CLSID_PSDragDrop) && !defined(__polyspace_no_CLSID_PSDragDrop)
#include <cguid.h>
#undef CLSID_PSDragDrop
  extern const CLSID CLSID_PSDragDrop;
#endif

#if defined(__polyspace_CLSID_PSBindCtx) && !defined(__polyspace_no_CLSID_PSBindCtx)
#include <cguid.h>
#undef CLSID_PSBindCtx
  extern const CLSID CLSID_PSBindCtx;
#endif

#if defined(__polyspace_CLSID_PSEnumerators) && !defined(__polyspace_no_CLSID_PSEnumerators)
#include <cguid.h>
#undef CLSID_PSEnumerators
  extern const CLSID CLSID_PSEnumerators;
#endif

#if defined(__polyspace_CLSID_StaticMetafile) && !defined(__polyspace_no_CLSID_StaticMetafile)
#include <cguid.h>
#undef CLSID_StaticMetafile
  extern const CLSID CLSID_StaticMetafile;
#endif

#if defined(__polyspace_CLSID_StaticDib) && !defined(__polyspace_no_CLSID_StaticDib)
#include <cguid.h>
#undef CLSID_StaticDib
  extern const CLSID CLSID_StaticDib;
#endif

#if defined(__polyspace_CID_CDfsVolume) && !defined(__polyspace_no_CID_CDfsVolume)
#include <cguid.h>
#undef CID_CDfsVolume
  extern const CLSID CID_CDfsVolume;
#endif

#if defined(__polyspace_CLSID_DCOMAccessControl) && !defined(__polyspace_no_CLSID_DCOMAccessControl)
#include <cguid.h>
#undef CLSID_DCOMAccessControl
  extern const CLSID CLSID_DCOMAccessControl;
#endif

#if defined(__polyspace_CLSID_StdGlobalInterfaceTable) && !defined(__polyspace_no_CLSID_StdGlobalInterfaceTable)
#include <cguid.h>
#undef CLSID_StdGlobalInterfaceTable
  extern const CLSID CLSID_StdGlobalInterfaceTable;
#endif

#if defined(__polyspace_CLSID_ComBinding) && !defined(__polyspace_no_CLSID_ComBinding)
#include <cguid.h>
#undef CLSID_ComBinding
  extern const CLSID CLSID_ComBinding;
#endif

#if defined(__polyspace_CLSID_CCDFormKrnl) && !defined(__polyspace_no_CLSID_CCDFormKrnl)
#include <cguid.h>
#undef CLSID_CCDFormKrnl
  extern const CLSID CLSID_CCDFormKrnl;
#endif

#if defined(__polyspace_CLSID_CCDPropertyPage) && !defined(__polyspace_no_CLSID_CCDPropertyPage)
#include <cguid.h>
#undef CLSID_CCDPropertyPage
  extern const CLSID CLSID_CCDPropertyPage;
#endif

#if defined(__polyspace_CLSID_CCDFormDialog) && !defined(__polyspace_no_CLSID_CCDFormDialog)
#include <cguid.h>
#undef CLSID_CCDFormDialog
  extern const CLSID CLSID_CCDFormDialog;
#endif

#if defined(__polyspace_CLSID_CCDCommandButton) && !defined(__polyspace_no_CLSID_CCDCommandButton)
#include <cguid.h>
#undef CLSID_CCDCommandButton
  extern const CLSID CLSID_CCDCommandButton;
#endif

#if defined(__polyspace_CLSID_CCDComboBox) && !defined(__polyspace_no_CLSID_CCDComboBox)
#include <cguid.h>
#undef CLSID_CCDComboBox
  extern const CLSID CLSID_CCDComboBox;
#endif

#if defined(__polyspace_CLSID_CCDTextBox) && !defined(__polyspace_no_CLSID_CCDTextBox)
#include <cguid.h>
#undef CLSID_CCDTextBox
  extern const CLSID CLSID_CCDTextBox;
#endif

#if defined(__polyspace_CLSID_CCDCheckBox) && !defined(__polyspace_no_CLSID_CCDCheckBox)
#include <cguid.h>
#undef CLSID_CCDCheckBox
  extern const CLSID CLSID_CCDCheckBox;
#endif

#if defined(__polyspace_CLSID_CCDLabel) && !defined(__polyspace_no_CLSID_CCDLabel)
#include <cguid.h>
#undef CLSID_CCDLabel
  extern const CLSID CLSID_CCDLabel;
#endif

#if defined(__polyspace_CLSID_CCDOptionButton) && !defined(__polyspace_no_CLSID_CCDOptionButton)
#include <cguid.h>
#undef CLSID_CCDOptionButton
  extern const CLSID CLSID_CCDOptionButton;
#endif

#if defined(__polyspace_CLSID_CCDListBox) && !defined(__polyspace_no_CLSID_CCDListBox)
#include <cguid.h>
#undef CLSID_CCDListBox
  extern const CLSID CLSID_CCDListBox;
#endif

#if defined(__polyspace_CLSID_CCDScrollBar) && !defined(__polyspace_no_CLSID_CCDScrollBar)
#include <cguid.h>
#undef CLSID_CCDScrollBar
  extern const CLSID CLSID_CCDScrollBar;
#endif

#if defined(__polyspace_CLSID_CCDGroupBox) && !defined(__polyspace_no_CLSID_CCDGroupBox)
#include <cguid.h>
#undef CLSID_CCDGroupBox
  extern const CLSID CLSID_CCDGroupBox;
#endif

#if defined(__polyspace_CLSID_CCDGeneralPropertyPage) && !defined(__polyspace_no_CLSID_CCDGeneralPropertyPage)
#include <cguid.h>
#undef CLSID_CCDGeneralPropertyPage
  extern const CLSID CLSID_CCDGeneralPropertyPage;
#endif

#if defined(__polyspace_CLSID_CCDGenericPropertyPage) && !defined(__polyspace_no_CLSID_CCDGenericPropertyPage)
#include <cguid.h>
#undef CLSID_CCDGenericPropertyPage
  extern const CLSID CLSID_CCDGenericPropertyPage;
#endif

#if defined(__polyspace_CLSID_CCDFontPropertyPage) && !defined(__polyspace_no_CLSID_CCDFontPropertyPage)
#include <cguid.h>
#undef CLSID_CCDFontPropertyPage
  extern const CLSID CLSID_CCDFontPropertyPage;
#endif

#if defined(__polyspace_CLSID_CCDColorPropertyPage) && !defined(__polyspace_no_CLSID_CCDColorPropertyPage)
#include <cguid.h>
#undef CLSID_CCDColorPropertyPage
  extern const CLSID CLSID_CCDColorPropertyPage;
#endif

#if defined(__polyspace_CLSID_CCDLabelPropertyPage) && !defined(__polyspace_no_CLSID_CCDLabelPropertyPage)
#include <cguid.h>
#undef CLSID_CCDLabelPropertyPage
  extern const CLSID CLSID_CCDLabelPropertyPage;
#endif

#if defined(__polyspace_CLSID_CCDCheckBoxPropertyPage) && !defined(__polyspace_no_CLSID_CCDCheckBoxPropertyPage)
#include <cguid.h>
#undef CLSID_CCDCheckBoxPropertyPage
  extern const CLSID CLSID_CCDCheckBoxPropertyPage;
#endif

#if defined(__polyspace_CLSID_CCDTextBoxPropertyPage) && !defined(__polyspace_no_CLSID_CCDTextBoxPropertyPage)
#include <cguid.h>
#undef CLSID_CCDTextBoxPropertyPage
  extern const CLSID CLSID_CCDTextBoxPropertyPage;
#endif

#if defined(__polyspace_CLSID_CCDOptionButtonPropertyPage) && !defined(__polyspace_no_CLSID_CCDOptionButtonPropertyPage)
#include <cguid.h>
#undef CLSID_CCDOptionButtonPropertyPage
  extern const CLSID CLSID_CCDOptionButtonPropertyPage;
#endif

#if defined(__polyspace_CLSID_CCDListBoxPropertyPage) && !defined(__polyspace_no_CLSID_CCDListBoxPropertyPage)
#include <cguid.h>
#undef CLSID_CCDListBoxPropertyPage
  extern const CLSID CLSID_CCDListBoxPropertyPage;
#endif

#if defined(__polyspace_CLSID_CCDCommandButtonPropertyPage) && !defined(__polyspace_no_CLSID_CCDCommandButtonPropertyPage)
#include <cguid.h>
#undef CLSID_CCDCommandButtonPropertyPage
  extern const CLSID CLSID_CCDCommandButtonPropertyPage;
#endif

#if defined(__polyspace_CLSID_CCDComboBoxPropertyPage) && !defined(__polyspace_no_CLSID_CCDComboBoxPropertyPage)
#include <cguid.h>
#undef CLSID_CCDComboBoxPropertyPage
  extern const CLSID CLSID_CCDComboBoxPropertyPage;
#endif

#if defined(__polyspace_CLSID_CCDScrollBarPropertyPage) && !defined(__polyspace_no_CLSID_CCDScrollBarPropertyPage)
#include <cguid.h>
#undef CLSID_CCDScrollBarPropertyPage
  extern const CLSID CLSID_CCDScrollBarPropertyPage;
#endif

#if defined(__polyspace_CLSID_CCDGroupBoxPropertyPage) && !defined(__polyspace_no_CLSID_CCDGroupBoxPropertyPage)
#include <cguid.h>
#undef CLSID_CCDGroupBoxPropertyPage
  extern const CLSID CLSID_CCDGroupBoxPropertyPage;
#endif

#if defined(__polyspace_CLSID_CCDXObjectPropertyPage) && !defined(__polyspace_no_CLSID_CCDXObjectPropertyPage)
#include <cguid.h>
#undef CLSID_CCDXObjectPropertyPage
  extern const CLSID CLSID_CCDXObjectPropertyPage;
#endif

#if defined(__polyspace_CLSID_CStdPropertyFrame) && !defined(__polyspace_no_CLSID_CStdPropertyFrame)
#include <cguid.h>
#undef CLSID_CStdPropertyFrame
  extern const CLSID CLSID_CStdPropertyFrame;
#endif

#if defined(__polyspace_CLSID_CFormPropertyPage) && !defined(__polyspace_no_CLSID_CFormPropertyPage)
#include <cguid.h>
#undef CLSID_CFormPropertyPage
  extern const CLSID CLSID_CFormPropertyPage;
#endif

#if defined(__polyspace_CLSID_CGridPropertyPage) && !defined(__polyspace_no_CLSID_CGridPropertyPage)
#include <cguid.h>
#undef CLSID_CGridPropertyPage
  extern const CLSID CLSID_CGridPropertyPage;
#endif

#if defined(__polyspace_CLSID_CWSJArticlePage) && !defined(__polyspace_no_CLSID_CWSJArticlePage)
#include <cguid.h>
#undef CLSID_CWSJArticlePage
  extern const CLSID CLSID_CWSJArticlePage;
#endif

#if defined(__polyspace_CLSID_CSystemPage) && !defined(__polyspace_no_CLSID_CSystemPage)
#include <cguid.h>
#undef CLSID_CSystemPage
  extern const CLSID CLSID_CSystemPage;
#endif

#if defined(__polyspace_CLSID_IdentityUnmarshal) && !defined(__polyspace_no_CLSID_IdentityUnmarshal)
#include <cguid.h>
#undef CLSID_IdentityUnmarshal
  extern const CLSID CLSID_IdentityUnmarshal;
#endif

#if defined(__polyspace_CLSID_InProcFreeMarshaler) && !defined(__polyspace_no_CLSID_InProcFreeMarshaler)
#include <cguid.h>
#undef CLSID_InProcFreeMarshaler
  extern const CLSID CLSID_InProcFreeMarshaler;
#endif

#if defined(__polyspace_CLSID_Picture_Metafile) && !defined(__polyspace_no_CLSID_Picture_Metafile)
#include <cguid.h>
#undef CLSID_Picture_Metafile
  extern const CLSID CLSID_Picture_Metafile;
#endif

#if defined(__polyspace_CLSID_Picture_EnhMetafile) && !defined(__polyspace_no_CLSID_Picture_EnhMetafile)
#include <cguid.h>
#undef CLSID_Picture_EnhMetafile
  extern const CLSID CLSID_Picture_EnhMetafile;
#endif

#if defined(__polyspace_CLSID_Picture_Dib) && !defined(__polyspace_no_CLSID_Picture_Dib)
#include <cguid.h>
#undef CLSID_Picture_Dib
  extern const CLSID CLSID_Picture_Dib;
#endif

#if defined(__polyspace_GUID_TRISTATE) && !defined(__polyspace_no_GUID_TRISTATE)
#include <cguid.h>
#undef GUID_TRISTATE
  extern const GUID GUID_TRISTATE;
#endif

#if defined(__polyspace___MIDL_itf_chanmgr_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_chanmgr_0000_v0_0_c_ifspec)
#include <chanmgr.h>
#undef __MIDL_itf_chanmgr_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_chanmgr_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_chanmgr_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_chanmgr_0000_v0_0_s_ifspec)
#include <chanmgr.h>
#undef __MIDL_itf_chanmgr_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_chanmgr_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL__intf_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL__intf_0000_v0_0_c_ifspec)
#include <cluadmex.h>
#undef __MIDL__intf_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL__intf_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL__intf_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL__intf_0000_v0_0_s_ifspec)
#include <cluadmex.h>
#undef __MIDL__intf_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL__intf_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_comcat_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_comcat_0000_v0_0_c_ifspec)
#include <comcat.h>
#undef __MIDL_itf_comcat_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_comcat_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_comcat_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_comcat_0000_v0_0_s_ifspec)
#include <comcat.h>
#undef __MIDL_itf_comcat_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_comcat_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_comcat_0006_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_comcat_0006_v0_0_c_ifspec)
#include <comcat.h>
#undef __MIDL_itf_comcat_0006_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_comcat_0006_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_comcat_0006_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_comcat_0006_v0_0_s_ifspec)
#include <comcat.h>
#undef __MIDL_itf_comcat_0006_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_comcat_0006_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_comcat_0007_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_comcat_0007_v0_0_c_ifspec)
#include <comcat.h>
#undef __MIDL_itf_comcat_0007_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_comcat_0007_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_comcat_0007_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_comcat_0007_v0_0_s_ifspec)
#include <comcat.h>
#undef __MIDL_itf_comcat_0007_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_comcat_0007_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_comcat_0008_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_comcat_0008_v0_0_c_ifspec)
#include <comcat.h>
#undef __MIDL_itf_comcat_0008_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_comcat_0008_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_comcat_0008_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_comcat_0008_v0_0_s_ifspec)
#include <comcat.h>
#undef __MIDL_itf_comcat_0008_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_comcat_0008_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_comcat_0009_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_comcat_0009_v0_0_c_ifspec)
#include <comcat.h>
#undef __MIDL_itf_comcat_0009_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_comcat_0009_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_comcat_0009_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_comcat_0009_v0_0_s_ifspec)
#include <comcat.h>
#undef __MIDL_itf_comcat_0009_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_comcat_0009_v0_0_s_ifspec;
#endif

#if defined(__polyspace_vtMissing) && !defined(__polyspace_no_vtMissing)
#include <comutil.h>
#undef vtMissing
  extern _variant_t vtMissing;
#endif

#if defined(__polyspace__crtAssertBusy) && !defined(__polyspace_no__crtAssertBusy)
#include <crtdbg.h>
#undef _crtAssertBusy
  extern long _crtAssertBusy;
#endif

#if defined(__polyspace__crtBreakAlloc) && !defined(__polyspace_no__crtBreakAlloc)
#include <crtdbg.h>
#undef _crtBreakAlloc
  extern long _crtBreakAlloc;
#endif

#if defined(__polyspace__crtDbgFlag) && !defined(__polyspace_no__crtDbgFlag)
#include <crtdbg.h>
#undef _crtDbgFlag
  extern int _crtDbgFlag;
#endif

#if defined(__polyspace___MIDL_itf_ddstream_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_ddstream_0000_v0_0_c_ifspec)
#include <ddstream.h>
#undef __MIDL_itf_ddstream_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_ddstream_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_ddstream_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_ddstream_0000_v0_0_s_ifspec)
#include <ddstream.h>
#undef __MIDL_itf_ddstream_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_ddstream_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___puiHead) && !defined(__polyspace_no___puiHead)
#include <delayimp.h>
#undef __puiHead
  extern PUnloadInfo __puiHead;
#endif

#if defined(__polyspace___pfnDliNotifyHook) && !defined(__polyspace_no___pfnDliNotifyHook)
#include <delayimp.h>
#undef __pfnDliNotifyHook
  extern PfnDliHook __pfnDliNotifyHook;
#endif

#if defined(__polyspace___pfnDliFailureHook) && !defined(__polyspace_no___pfnDliFailureHook)
#include <delayimp.h>
#undef __pfnDliFailureHook
  extern PfnDliHook __pfnDliFailureHook;
#endif

#if defined(__polyspace_c_dfDIMouse) && !defined(__polyspace_no_c_dfDIMouse)
#include <dinput.h>
#undef c_dfDIMouse
  extern const DIDATAFORMAT c_dfDIMouse;
#endif

#if defined(__polyspace_c_dfDIKeyboard) && !defined(__polyspace_no_c_dfDIKeyboard)
#include <dinput.h>
#undef c_dfDIKeyboard
  extern const DIDATAFORMAT c_dfDIKeyboard;
#endif

#if defined(__polyspace_c_dfDIJoystick) && !defined(__polyspace_no_c_dfDIJoystick)
#include <dinput.h>
#undef c_dfDIJoystick
  extern const DIDATAFORMAT c_dfDIJoystick;
#endif

#if defined(__polyspace_c_dfDIJoystick2) && !defined(__polyspace_no_c_dfDIJoystick2)
#include <dinput.h>
#undef c_dfDIJoystick2
  extern const DIDATAFORMAT c_dfDIJoystick2;
#endif

#if defined(__polyspace___MIDL_itf_dispex_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_dispex_0000_v0_0_c_ifspec)
#include <dispex.h>
#undef __MIDL_itf_dispex_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_dispex_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_dispex_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_dispex_0000_v0_0_s_ifspec)
#include <dispex.h>
#undef __MIDL_itf_dispex_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_dispex_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_dispex_0144_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_dispex_0144_v0_0_c_ifspec)
#include <dispex.h>
#undef __MIDL_itf_dispex_0144_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_dispex_0144_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_dispex_0144_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_dispex_0144_v0_0_s_ifspec)
#include <dispex.h>
#undef __MIDL_itf_dispex_0144_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_dispex_0144_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_docobj_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_docobj_0000_v0_0_c_ifspec)
#include <docobj.h>
#undef __MIDL_itf_docobj_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_docobj_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_docobj_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_docobj_0000_v0_0_s_ifspec)
#include <docobj.h>
#undef __MIDL_itf_docobj_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_docobj_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_docobj_0214_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_docobj_0214_v0_0_c_ifspec)
#include <docobj.h>
#undef __MIDL_itf_docobj_0214_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_docobj_0214_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_docobj_0214_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_docobj_0214_v0_0_s_ifspec)
#include <docobj.h>
#undef __MIDL_itf_docobj_0214_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_docobj_0214_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_docobj_0215_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_docobj_0215_v0_0_c_ifspec)
#include <docobj.h>
#undef __MIDL_itf_docobj_0215_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_docobj_0215_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_docobj_0215_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_docobj_0215_v0_0_s_ifspec)
#include <docobj.h>
#undef __MIDL_itf_docobj_0215_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_docobj_0215_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_docobj_0216_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_docobj_0216_v0_0_c_ifspec)
#include <docobj.h>
#undef __MIDL_itf_docobj_0216_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_docobj_0216_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_docobj_0216_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_docobj_0216_v0_0_s_ifspec)
#include <docobj.h>
#undef __MIDL_itf_docobj_0216_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_docobj_0216_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_docobj_0217_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_docobj_0217_v0_0_c_ifspec)
#include <docobj.h>
#undef __MIDL_itf_docobj_0217_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_docobj_0217_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_docobj_0217_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_docobj_0217_v0_0_s_ifspec)
#include <docobj.h>
#undef __MIDL_itf_docobj_0217_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_docobj_0217_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_docobj_0218_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_docobj_0218_v0_0_c_ifspec)
#include <docobj.h>
#undef __MIDL_itf_docobj_0218_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_docobj_0218_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_docobj_0218_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_docobj_0218_v0_0_s_ifspec)
#include <docobj.h>
#undef __MIDL_itf_docobj_0218_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_docobj_0218_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_docobj_0219_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_docobj_0219_v0_0_c_ifspec)
#include <docobj.h>
#undef __MIDL_itf_docobj_0219_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_docobj_0219_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_docobj_0219_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_docobj_0219_v0_0_s_ifspec)
#include <docobj.h>
#undef __MIDL_itf_docobj_0219_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_docobj_0219_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_docobj_0220_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_docobj_0220_v0_0_c_ifspec)
#include <docobj.h>
#undef __MIDL_itf_docobj_0220_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_docobj_0220_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_docobj_0220_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_docobj_0220_v0_0_s_ifspec)
#include <docobj.h>
#undef __MIDL_itf_docobj_0220_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_docobj_0220_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_eventcpts_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_eventcpts_0000_v0_0_c_ifspec)
#include <evntcpts.h>
#undef __MIDL_itf_eventcpts_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_eventcpts_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_eventcpts_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_eventcpts_0000_v0_0_s_ifspec)
#include <evntcpts.h>
#undef __MIDL_itf_eventcpts_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_eventcpts_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace_InitDLL) && !defined(__polyspace_no_InitDLL)
#include <exadmin.h>
#undef InitDLL
  extern CInitDLL InitDLL;
#endif

#if defined(__polyspace___MIDL_itf_filter_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_filter_0000_v0_0_c_ifspec)
#include <filter.h>
#undef __MIDL_itf_filter_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_filter_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_filter_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_filter_0000_v0_0_s_ifspec)
#include <filter.h>
#undef __MIDL_itf_filter_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_filter_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace_auxRGBMap) && !defined(__polyspace_no_auxRGBMap)
#include <glaux.h>
#undef auxRGBMap
  extern float auxRGBMap[20][3];
#endif

#if defined(__polyspace___MIDL_itf_hliface_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_hliface_0000_v0_0_c_ifspec)
#include <hliface.h>
#undef __MIDL_itf_hliface_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_hliface_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_hliface_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_hliface_0000_v0_0_s_ifspec)
#include <hliface.h>
#undef __MIDL_itf_hliface_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_hliface_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_hlink_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_hlink_0000_v0_0_c_ifspec)
#include <hlink.h>
#undef __MIDL_itf_hlink_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_hlink_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_hlink_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_hlink_0000_v0_0_s_ifspec)
#include <hlink.h>
#undef __MIDL_itf_hlink_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_hlink_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_hlink_0164_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_hlink_0164_v0_0_c_ifspec)
#include <hlink.h>
#undef __MIDL_itf_hlink_0164_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_hlink_0164_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_hlink_0164_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_hlink_0164_v0_0_s_ifspec)
#include <hlink.h>
#undef __MIDL_itf_hlink_0164_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_hlink_0164_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_hlink_0165_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_hlink_0165_v0_0_c_ifspec)
#include <hlink.h>
#undef __MIDL_itf_hlink_0165_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_hlink_0165_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_hlink_0165_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_hlink_0165_v0_0_s_ifspec)
#include <hlink.h>
#undef __MIDL_itf_hlink_0165_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_hlink_0165_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_hlink_0166_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_hlink_0166_v0_0_c_ifspec)
#include <hlink.h>
#undef __MIDL_itf_hlink_0166_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_hlink_0166_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_hlink_0166_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_hlink_0166_v0_0_s_ifspec)
#include <hlink.h>
#undef __MIDL_itf_hlink_0166_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_hlink_0166_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_hlink_0167_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_hlink_0167_v0_0_c_ifspec)
#include <hlink.h>
#undef __MIDL_itf_hlink_0167_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_hlink_0167_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_hlink_0167_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_hlink_0167_v0_0_s_ifspec)
#include <hlink.h>
#undef __MIDL_itf_hlink_0167_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_hlink_0167_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_hlink_0168_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_hlink_0168_v0_0_c_ifspec)
#include <hlink.h>
#undef __MIDL_itf_hlink_0168_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_hlink_0168_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_hlink_0168_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_hlink_0168_v0_0_s_ifspec)
#include <hlink.h>
#undef __MIDL_itf_hlink_0168_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_hlink_0168_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_hlink_0169_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_hlink_0169_v0_0_c_ifspec)
#include <hlink.h>
#undef __MIDL_itf_hlink_0169_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_hlink_0169_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_hlink_0169_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_hlink_0169_v0_0_s_ifspec)
#include <hlink.h>
#undef __MIDL_itf_hlink_0169_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_hlink_0169_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_hlink_0170_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_hlink_0170_v0_0_c_ifspec)
#include <hlink.h>
#undef __MIDL_itf_hlink_0170_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_hlink_0170_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_hlink_0170_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_hlink_0170_v0_0_s_ifspec)
#include <hlink.h>
#undef __MIDL_itf_hlink_0170_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_hlink_0170_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_iadmw_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_iadmw_0000_v0_0_c_ifspec)
#include <iadmw.h>
#undef __MIDL_itf_iadmw_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_iadmw_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_iadmw_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_iadmw_0000_v0_0_s_ifspec)
#include <iadmw.h>
#undef __MIDL_itf_iadmw_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_iadmw_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_iadmw_0218_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_iadmw_0218_v0_0_c_ifspec)
#include <iadmw.h>
#undef __MIDL_itf_iadmw_0218_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_iadmw_0218_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_iadmw_0218_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_iadmw_0218_v0_0_s_ifspec)
#include <iadmw.h>
#undef __MIDL_itf_iadmw_0218_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_iadmw_0218_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_inetsdk_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_inetsdk_0000_v0_0_c_ifspec)
#include <inetsdk.h>
#undef __MIDL_itf_inetsdk_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_inetsdk_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_inetsdk_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_inetsdk_0000_v0_0_s_ifspec)
#include <inetsdk.h>
#undef __MIDL_itf_inetsdk_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_inetsdk_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_irtprph_0296_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_irtprph_0296_v0_0_c_ifspec)
#include <irtprph.h>
#undef __MIDL_itf_irtprph_0296_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_irtprph_0296_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_irtprph_0296_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_irtprph_0296_v0_0_s_ifspec)
#include <irtprph.h>
#undef __MIDL_itf_irtprph_0296_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_irtprph_0296_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_irtpsph_0295_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_irtpsph_0295_v0_0_c_ifspec)
#include <irtpsph.h>
#undef __MIDL_itf_irtpsph_0295_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_irtpsph_0295_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_irtpsph_0295_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_irtpsph_0295_v0_0_s_ifspec)
#include <irtpsph.h>
#undef __MIDL_itf_irtpsph_0295_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_irtpsph_0295_v0_0_s_ifspec;
#endif

#if defined(__polyspace_cin) && !defined(__polyspace_no_cin)
#include <istream.h>
#undef cin
  extern _CRTIMP istream_withassign cin;
#endif

#if defined(__polyspace___MIDL_itf_javadbg_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_javadbg_0000_v0_0_c_ifspec)
#include <javadbg.h>
#undef __MIDL_itf_javadbg_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_javadbg_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_javadbg_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_javadbg_0000_v0_0_s_ifspec)
#include <javadbg.h>
#undef __MIDL_itf_javadbg_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_javadbg_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace__amblksiz) && !defined(__polyspace_no__amblksiz)
#include <malloc.h>
#undef _amblksiz
  extern unsigned int _amblksiz;
#endif

#if defined(__polyspace_Common_Scodes) && !defined(__polyspace_no_Common_Scodes)
#include <mapidbg.h>
#undef Common_Scodes
  extern SCODE Common_Scodes[];
#endif

#if defined(__polyspace_MAPILogon_Scodes) && !defined(__polyspace_no_MAPILogon_Scodes)
#include <mapidbg.h>
#undef MAPILogon_Scodes
  extern SCODE MAPILogon_Scodes[];
#endif

#if defined(__polyspace_MAPIAllocateBuffer_Scodes) && !defined(__polyspace_no_MAPIAllocateBuffer_Scodes)
#include <mapidbg.h>
#undef MAPIAllocateBuffer_Scodes
  extern SCODE MAPIAllocateBuffer_Scodes[];
#endif

#if defined(__polyspace_MAPIAllocateMore_Scodes) && !defined(__polyspace_no_MAPIAllocateMore_Scodes)
#include <mapidbg.h>
#undef MAPIAllocateMore_Scodes
  extern SCODE MAPIAllocateMore_Scodes[];
#endif

#if defined(__polyspace_MAPIFreeBuffer_Scodes) && !defined(__polyspace_no_MAPIFreeBuffer_Scodes)
#include <mapidbg.h>
#undef MAPIFreeBuffer_Scodes
  extern SCODE MAPIFreeBuffer_Scodes[];
#endif

#if defined(__polyspace_IUnknown_QueryInterface_Scodes) && !defined(__polyspace_no_IUnknown_QueryInterface_Scodes)
#include <mapidbg.h>
#undef IUnknown_QueryInterface_Scodes
  extern SCODE IUnknown_QueryInterface_Scodes[];
#endif

#if defined(__polyspace_IUnknown_AddRef_Scodes) && !defined(__polyspace_no_IUnknown_AddRef_Scodes)
#include <mapidbg.h>
#undef IUnknown_AddRef_Scodes
  extern SCODE IUnknown_AddRef_Scodes[];
#endif

#if defined(__polyspace_IUnknown_Release_Scodes) && !defined(__polyspace_no_IUnknown_Release_Scodes)
#include <mapidbg.h>
#undef IUnknown_Release_Scodes
  extern SCODE IUnknown_Release_Scodes[];
#endif

#if defined(__polyspace_IUnknown_GetLastError_Scodes) && !defined(__polyspace_no_IUnknown_GetLastError_Scodes)
#include <mapidbg.h>
#undef IUnknown_GetLastError_Scodes
  extern SCODE IUnknown_GetLastError_Scodes[];
#endif

#if defined(__polyspace_IMAPIProp_CopyTo_Scodes) && !defined(__polyspace_no_IMAPIProp_CopyTo_Scodes)
#include <mapidbg.h>
#undef IMAPIProp_CopyTo_Scodes
  extern SCODE IMAPIProp_CopyTo_Scodes[];
#endif

#if defined(__polyspace_IMAPIProp_CopyProps_Scodes) && !defined(__polyspace_no_IMAPIProp_CopyProps_Scodes)
#include <mapidbg.h>
#undef IMAPIProp_CopyProps_Scodes
  extern SCODE IMAPIProp_CopyProps_Scodes[];
#endif

#if defined(__polyspace_IMAPIProp_DeleteProps_Scodes) && !defined(__polyspace_no_IMAPIProp_DeleteProps_Scodes)
#include <mapidbg.h>
#undef IMAPIProp_DeleteProps_Scodes
  extern SCODE IMAPIProp_DeleteProps_Scodes[];
#endif

#if defined(__polyspace_IMAPIProp_GetIDsFromNames_Scodes) && !defined(__polyspace_no_IMAPIProp_GetIDsFromNames_Scodes)
#include <mapidbg.h>
#undef IMAPIProp_GetIDsFromNames_Scodes
  extern SCODE IMAPIProp_GetIDsFromNames_Scodes[];
#endif

#if defined(__polyspace_IMAPIProp_GetLastError_Scodes) && !defined(__polyspace_no_IMAPIProp_GetLastError_Scodes)
#include <mapidbg.h>
#undef IMAPIProp_GetLastError_Scodes
  extern SCODE IMAPIProp_GetLastError_Scodes[];
#endif

#if defined(__polyspace_IMAPIProp_GetNamesFromIDs_Scodes) && !defined(__polyspace_no_IMAPIProp_GetNamesFromIDs_Scodes)
#include <mapidbg.h>
#undef IMAPIProp_GetNamesFromIDs_Scodes
  extern SCODE IMAPIProp_GetNamesFromIDs_Scodes[];
#endif

#if defined(__polyspace_IMAPIProp_GetPropList_Scodes) && !defined(__polyspace_no_IMAPIProp_GetPropList_Scodes)
#include <mapidbg.h>
#undef IMAPIProp_GetPropList_Scodes
  extern SCODE IMAPIProp_GetPropList_Scodes[];
#endif

#if defined(__polyspace_IMAPIProp_GetProps_Scodes) && !defined(__polyspace_no_IMAPIProp_GetProps_Scodes)
#include <mapidbg.h>
#undef IMAPIProp_GetProps_Scodes
  extern SCODE IMAPIProp_GetProps_Scodes[];
#endif

#if defined(__polyspace_IMAPIProp_OpenProperty_Scodes) && !defined(__polyspace_no_IMAPIProp_OpenProperty_Scodes)
#include <mapidbg.h>
#undef IMAPIProp_OpenProperty_Scodes
  extern SCODE IMAPIProp_OpenProperty_Scodes[];
#endif

#if defined(__polyspace_IMAPIProp_SetProps_Scodes) && !defined(__polyspace_no_IMAPIProp_SetProps_Scodes)
#include <mapidbg.h>
#undef IMAPIProp_SetProps_Scodes
  extern SCODE IMAPIProp_SetProps_Scodes[];
#endif

#if defined(__polyspace_IMAPIProp_SaveChanges_Scodes) && !defined(__polyspace_no_IMAPIProp_SaveChanges_Scodes)
#include <mapidbg.h>
#undef IMAPIProp_SaveChanges_Scodes
  extern SCODE IMAPIProp_SaveChanges_Scodes[];
#endif

#if defined(__polyspace_IStream_Read_Scodes) && !defined(__polyspace_no_IStream_Read_Scodes)
#include <mapidbg.h>
#undef IStream_Read_Scodes
  extern SCODE IStream_Read_Scodes[];
#endif

#if defined(__polyspace_IStream_Write_Scodes) && !defined(__polyspace_no_IStream_Write_Scodes)
#include <mapidbg.h>
#undef IStream_Write_Scodes
  extern SCODE IStream_Write_Scodes[];
#endif

#if defined(__polyspace_IStream_Seek_Scodes) && !defined(__polyspace_no_IStream_Seek_Scodes)
#include <mapidbg.h>
#undef IStream_Seek_Scodes
  extern SCODE IStream_Seek_Scodes[];
#endif

#if defined(__polyspace_IStream_SetSize_Scodes) && !defined(__polyspace_no_IStream_SetSize_Scodes)
#include <mapidbg.h>
#undef IStream_SetSize_Scodes
  extern SCODE IStream_SetSize_Scodes[];
#endif

#if defined(__polyspace_IStream_Tell_Scodes) && !defined(__polyspace_no_IStream_Tell_Scodes)
#include <mapidbg.h>
#undef IStream_Tell_Scodes
  extern SCODE IStream_Tell_Scodes[];
#endif

#if defined(__polyspace_IStream_LockRegion_Scodes) && !defined(__polyspace_no_IStream_LockRegion_Scodes)
#include <mapidbg.h>
#undef IStream_LockRegion_Scodes
  extern SCODE IStream_LockRegion_Scodes[];
#endif

#if defined(__polyspace_IStream_UnlockRegion_Scodes) && !defined(__polyspace_no_IStream_UnlockRegion_Scodes)
#include <mapidbg.h>
#undef IStream_UnlockRegion_Scodes
  extern SCODE IStream_UnlockRegion_Scodes[];
#endif

#if defined(__polyspace_IStream_Clone_Scodes) && !defined(__polyspace_no_IStream_Clone_Scodes)
#include <mapidbg.h>
#undef IStream_Clone_Scodes
  extern SCODE IStream_Clone_Scodes[];
#endif

#if defined(__polyspace_IStream_CopyTo_Scodes) && !defined(__polyspace_no_IStream_CopyTo_Scodes)
#include <mapidbg.h>
#undef IStream_CopyTo_Scodes
  extern SCODE IStream_CopyTo_Scodes[];
#endif

#if defined(__polyspace_IStream_Revert_Scodes) && !defined(__polyspace_no_IStream_Revert_Scodes)
#include <mapidbg.h>
#undef IStream_Revert_Scodes
  extern SCODE IStream_Revert_Scodes[];
#endif

#if defined(__polyspace_IStream_Stat_Scodes) && !defined(__polyspace_no_IStream_Stat_Scodes)
#include <mapidbg.h>
#undef IStream_Stat_Scodes
  extern SCODE IStream_Stat_Scodes[];
#endif

#if defined(__polyspace_IStream_Commit_Scodes) && !defined(__polyspace_no_IStream_Commit_Scodes)
#include <mapidbg.h>
#undef IStream_Commit_Scodes
  extern SCODE IStream_Commit_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_GetLastError_Scodes) && !defined(__polyspace_no_IMAPITable_GetLastError_Scodes)
#include <mapidbg.h>
#undef IMAPITable_GetLastError_Scodes
  extern SCODE IMAPITable_GetLastError_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_Advise_Scodes) && !defined(__polyspace_no_IMAPITable_Advise_Scodes)
#include <mapidbg.h>
#undef IMAPITable_Advise_Scodes
  extern SCODE IMAPITable_Advise_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_Unadvise_Scodes) && !defined(__polyspace_no_IMAPITable_Unadvise_Scodes)
#include <mapidbg.h>
#undef IMAPITable_Unadvise_Scodes
  extern SCODE IMAPITable_Unadvise_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_GetStatus_Scodes) && !defined(__polyspace_no_IMAPITable_GetStatus_Scodes)
#include <mapidbg.h>
#undef IMAPITable_GetStatus_Scodes
  extern SCODE IMAPITable_GetStatus_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_SetColumns_Scodes) && !defined(__polyspace_no_IMAPITable_SetColumns_Scodes)
#include <mapidbg.h>
#undef IMAPITable_SetColumns_Scodes
  extern SCODE IMAPITable_SetColumns_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_QueryColumns_Scodes) && !defined(__polyspace_no_IMAPITable_QueryColumns_Scodes)
#include <mapidbg.h>
#undef IMAPITable_QueryColumns_Scodes
  extern SCODE IMAPITable_QueryColumns_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_GetRowCount_Scodes) && !defined(__polyspace_no_IMAPITable_GetRowCount_Scodes)
#include <mapidbg.h>
#undef IMAPITable_GetRowCount_Scodes
  extern SCODE IMAPITable_GetRowCount_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_SeekRow_Scodes) && !defined(__polyspace_no_IMAPITable_SeekRow_Scodes)
#include <mapidbg.h>
#undef IMAPITable_SeekRow_Scodes
  extern SCODE IMAPITable_SeekRow_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_SeekRowApprox_Scodes) && !defined(__polyspace_no_IMAPITable_SeekRowApprox_Scodes)
#include <mapidbg.h>
#undef IMAPITable_SeekRowApprox_Scodes
  extern SCODE IMAPITable_SeekRowApprox_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_QueryPosition_Scodes) && !defined(__polyspace_no_IMAPITable_QueryPosition_Scodes)
#include <mapidbg.h>
#undef IMAPITable_QueryPosition_Scodes
  extern SCODE IMAPITable_QueryPosition_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_FindRow_Scodes) && !defined(__polyspace_no_IMAPITable_FindRow_Scodes)
#include <mapidbg.h>
#undef IMAPITable_FindRow_Scodes
  extern SCODE IMAPITable_FindRow_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_Restrict_Scodes) && !defined(__polyspace_no_IMAPITable_Restrict_Scodes)
#include <mapidbg.h>
#undef IMAPITable_Restrict_Scodes
  extern SCODE IMAPITable_Restrict_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_CreateBookmark_Scodes) && !defined(__polyspace_no_IMAPITable_CreateBookmark_Scodes)
#include <mapidbg.h>
#undef IMAPITable_CreateBookmark_Scodes
  extern SCODE IMAPITable_CreateBookmark_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_FreeBookmark_Scodes) && !defined(__polyspace_no_IMAPITable_FreeBookmark_Scodes)
#include <mapidbg.h>
#undef IMAPITable_FreeBookmark_Scodes
  extern SCODE IMAPITable_FreeBookmark_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_SortTable_Scodes) && !defined(__polyspace_no_IMAPITable_SortTable_Scodes)
#include <mapidbg.h>
#undef IMAPITable_SortTable_Scodes
  extern SCODE IMAPITable_SortTable_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_QuerySortOrder_Scodes) && !defined(__polyspace_no_IMAPITable_QuerySortOrder_Scodes)
#include <mapidbg.h>
#undef IMAPITable_QuerySortOrder_Scodes
  extern SCODE IMAPITable_QuerySortOrder_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_QueryRows_Scodes) && !defined(__polyspace_no_IMAPITable_QueryRows_Scodes)
#include <mapidbg.h>
#undef IMAPITable_QueryRows_Scodes
  extern SCODE IMAPITable_QueryRows_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_Abort_Scodes) && !defined(__polyspace_no_IMAPITable_Abort_Scodes)
#include <mapidbg.h>
#undef IMAPITable_Abort_Scodes
  extern SCODE IMAPITable_Abort_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_ExpandRow_Scodes) && !defined(__polyspace_no_IMAPITable_ExpandRow_Scodes)
#include <mapidbg.h>
#undef IMAPITable_ExpandRow_Scodes
  extern SCODE IMAPITable_ExpandRow_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_CollapseRow_Scodes) && !defined(__polyspace_no_IMAPITable_CollapseRow_Scodes)
#include <mapidbg.h>
#undef IMAPITable_CollapseRow_Scodes
  extern SCODE IMAPITable_CollapseRow_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_WaitForCompletion_Scodes) && !defined(__polyspace_no_IMAPITable_WaitForCompletion_Scodes)
#include <mapidbg.h>
#undef IMAPITable_WaitForCompletion_Scodes
  extern SCODE IMAPITable_WaitForCompletion_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_GetCollapseState_Scodes) && !defined(__polyspace_no_IMAPITable_GetCollapseState_Scodes)
#include <mapidbg.h>
#undef IMAPITable_GetCollapseState_Scodes
  extern SCODE IMAPITable_GetCollapseState_Scodes[];
#endif

#if defined(__polyspace_IMAPITable_SetCollapseState_Scodes) && !defined(__polyspace_no_IMAPITable_SetCollapseState_Scodes)
#include <mapidbg.h>
#undef IMAPITable_SetCollapseState_Scodes
  extern SCODE IMAPITable_SetCollapseState_Scodes[];
#endif

#if defined(__polyspace_IMAPISession_LogOff_Scodes) && !defined(__polyspace_no_IMAPISession_LogOff_Scodes)
#include <mapidbg.h>
#undef IMAPISession_LogOff_Scodes
  extern SCODE IMAPISession_LogOff_Scodes[];
#endif

#if defined(__polyspace_IMAPISession_Release_Scodes) && !defined(__polyspace_no_IMAPISession_Release_Scodes)
#include <mapidbg.h>
#undef IMAPISession_Release_Scodes
  extern SCODE IMAPISession_Release_Scodes[];
#endif

#if defined(__polyspace_IMAPISession_GetLastError_Scodes) && !defined(__polyspace_no_IMAPISession_GetLastError_Scodes)
#include <mapidbg.h>
#undef IMAPISession_GetLastError_Scodes
  extern SCODE IMAPISession_GetLastError_Scodes[];
#endif

#if defined(__polyspace_IMAPISession_GetMsgStoresTable_Scodes) && !defined(__polyspace_no_IMAPISession_GetMsgStoresTable_Scodes)
#include <mapidbg.h>
#undef IMAPISession_GetMsgStoresTable_Scodes
  extern SCODE IMAPISession_GetMsgStoresTable_Scodes[];
#endif

#if defined(__polyspace_IMAPISession_GetStatusTable_Scodes) && !defined(__polyspace_no_IMAPISession_GetStatusTable_Scodes)
#include <mapidbg.h>
#undef IMAPISession_GetStatusTable_Scodes
  extern SCODE IMAPISession_GetStatusTable_Scodes[];
#endif

#if defined(__polyspace_IMAPISession_OpenMsgStore_Scodes) && !defined(__polyspace_no_IMAPISession_OpenMsgStore_Scodes)
#include <mapidbg.h>
#undef IMAPISession_OpenMsgStore_Scodes
  extern SCODE IMAPISession_OpenMsgStore_Scodes[];
#endif

#if defined(__polyspace_IMAPISession_OpenAddressBook_Scodes) && !defined(__polyspace_no_IMAPISession_OpenAddressBook_Scodes)
#include <mapidbg.h>
#undef IMAPISession_OpenAddressBook_Scodes
  extern SCODE IMAPISession_OpenAddressBook_Scodes[];
#endif

#if defined(__polyspace_IMAPISession_OpenEntry_Scodes) && !defined(__polyspace_no_IMAPISession_OpenEntry_Scodes)
#include <mapidbg.h>
#undef IMAPISession_OpenEntry_Scodes
  extern SCODE IMAPISession_OpenEntry_Scodes[];
#endif

#if defined(__polyspace_IMAPISession_OpenProfileSection_Scodes) && !defined(__polyspace_no_IMAPISession_OpenProfileSection_Scodes)
#include <mapidbg.h>
#undef IMAPISession_OpenProfileSection_Scodes
  extern SCODE IMAPISession_OpenProfileSection_Scodes[];
#endif

#if defined(__polyspace_IMAPISession_Advise_Scodes) && !defined(__polyspace_no_IMAPISession_Advise_Scodes)
#include <mapidbg.h>
#undef IMAPISession_Advise_Scodes
  extern SCODE IMAPISession_Advise_Scodes[];
#endif

#if defined(__polyspace_IMAPISession_Unadvise_Scodes) && !defined(__polyspace_no_IMAPISession_Unadvise_Scodes)
#include <mapidbg.h>
#undef IMAPISession_Unadvise_Scodes
  extern SCODE IMAPISession_Unadvise_Scodes[];
#endif

#if defined(__polyspace_IMAPISession_CompareEntryIDs_Scodes) && !defined(__polyspace_no_IMAPISession_CompareEntryIDs_Scodes)
#include <mapidbg.h>
#undef IMAPISession_CompareEntryIDs_Scodes
  extern SCODE IMAPISession_CompareEntryIDs_Scodes[];
#endif

#if defined(__polyspace_IMAPISession_MessageOptions_Scodes) && !defined(__polyspace_no_IMAPISession_MessageOptions_Scodes)
#include <mapidbg.h>
#undef IMAPISession_MessageOptions_Scodes
  extern SCODE IMAPISession_MessageOptions_Scodes[];
#endif

#if defined(__polyspace_IMAPISession_QueryDefaultMessageOpt_Scodes) && !defined(__polyspace_no_IMAPISession_QueryDefaultMessageOpt_Scodes)
#include <mapidbg.h>
#undef IMAPISession_QueryDefaultMessageOpt_Scodes
  extern SCODE IMAPISession_QueryDefaultMessageOpt_Scodes[];
#endif

#if defined(__polyspace_IMAPISession_EnumAdrTypes_Scodes) && !defined(__polyspace_no_IMAPISession_EnumAdrTypes_Scodes)
#include <mapidbg.h>
#undef IMAPISession_EnumAdrTypes_Scodes
  extern SCODE IMAPISession_EnumAdrTypes_Scodes[];
#endif

#if defined(__polyspace_IMAPISession_QueryIdentity_Scodes) && !defined(__polyspace_no_IMAPISession_QueryIdentity_Scodes)
#include <mapidbg.h>
#undef IMAPISession_QueryIdentity_Scodes
  extern SCODE IMAPISession_QueryIdentity_Scodes[];
#endif

#if defined(__polyspace_IMsgStore_Advise_Scodes) && !defined(__polyspace_no_IMsgStore_Advise_Scodes)
#include <mapidbg.h>
#undef IMsgStore_Advise_Scodes
  extern SCODE IMsgStore_Advise_Scodes[];
#endif

#if defined(__polyspace_IMsgStore_Unadvise_Scodes) && !defined(__polyspace_no_IMsgStore_Unadvise_Scodes)
#include <mapidbg.h>
#undef IMsgStore_Unadvise_Scodes
  extern SCODE IMsgStore_Unadvise_Scodes[];
#endif

#if defined(__polyspace_IMsgStore_CompareEntryIDs_Scodes) && !defined(__polyspace_no_IMsgStore_CompareEntryIDs_Scodes)
#include <mapidbg.h>
#undef IMsgStore_CompareEntryIDs_Scodes
  extern SCODE IMsgStore_CompareEntryIDs_Scodes[];
#endif

#if defined(__polyspace_IMsgStore_OpenEntry_Scodes) && !defined(__polyspace_no_IMsgStore_OpenEntry_Scodes)
#include <mapidbg.h>
#undef IMsgStore_OpenEntry_Scodes
  extern SCODE IMsgStore_OpenEntry_Scodes[];
#endif

#if defined(__polyspace_IMsgStore_SetReceiveFolder_Scodes) && !defined(__polyspace_no_IMsgStore_SetReceiveFolder_Scodes)
#include <mapidbg.h>
#undef IMsgStore_SetReceiveFolder_Scodes
  extern SCODE IMsgStore_SetReceiveFolder_Scodes[];
#endif

#if defined(__polyspace_IMsgStore_GetReceiveFolder_Scodes) && !defined(__polyspace_no_IMsgStore_GetReceiveFolder_Scodes)
#include <mapidbg.h>
#undef IMsgStore_GetReceiveFolder_Scodes
  extern SCODE IMsgStore_GetReceiveFolder_Scodes[];
#endif

#if defined(__polyspace_IMsgStore_GetReceiveFolderTable_Scodes) && !defined(__polyspace_no_IMsgStore_GetReceiveFolderTable_Scodes)
#include <mapidbg.h>
#undef IMsgStore_GetReceiveFolderTable_Scodes
  extern SCODE IMsgStore_GetReceiveFolderTable_Scodes[];
#endif

#if defined(__polyspace_IMsgStore_StoreLogoff_Scodes) && !defined(__polyspace_no_IMsgStore_StoreLogoff_Scodes)
#include <mapidbg.h>
#undef IMsgStore_StoreLogoff_Scodes
  extern SCODE IMsgStore_StoreLogoff_Scodes[];
#endif

#if defined(__polyspace_IMsgStore_AbortSubmit_Scodes) && !defined(__polyspace_no_IMsgStore_AbortSubmit_Scodes)
#include <mapidbg.h>
#undef IMsgStore_AbortSubmit_Scodes
  extern SCODE IMsgStore_AbortSubmit_Scodes[];
#endif

#if defined(__polyspace_IMsgStore_GetOutgoingQueue_Scodes) && !defined(__polyspace_no_IMsgStore_GetOutgoingQueue_Scodes)
#include <mapidbg.h>
#undef IMsgStore_GetOutgoingQueue_Scodes
  extern SCODE IMsgStore_GetOutgoingQueue_Scodes[];
#endif

#if defined(__polyspace_IMsgStore_SetLockState_Scodes) && !defined(__polyspace_no_IMsgStore_SetLockState_Scodes)
#include <mapidbg.h>
#undef IMsgStore_SetLockState_Scodes
  extern SCODE IMsgStore_SetLockState_Scodes[];
#endif

#if defined(__polyspace_IMsgStore_FinishedMsg_Scodes) && !defined(__polyspace_no_IMsgStore_FinishedMsg_Scodes)
#include <mapidbg.h>
#undef IMsgStore_FinishedMsg_Scodes
  extern SCODE IMsgStore_FinishedMsg_Scodes[];
#endif

#if defined(__polyspace_IMsgStore_NotifyNewMail_Scodes) && !defined(__polyspace_no_IMsgStore_NotifyNewMail_Scodes)
#include <mapidbg.h>
#undef IMsgStore_NotifyNewMail_Scodes
  extern SCODE IMsgStore_NotifyNewMail_Scodes[];
#endif

#if defined(__polyspace_IMAPIFolder_GetContentsTable_Scodes) && !defined(__polyspace_no_IMAPIFolder_GetContentsTable_Scodes)
#include <mapidbg.h>
#undef IMAPIFolder_GetContentsTable_Scodes
  extern SCODE IMAPIFolder_GetContentsTable_Scodes[];
#endif

#if defined(__polyspace_IMAPIFolder_GetHierarchyTable_Scodes) && !defined(__polyspace_no_IMAPIFolder_GetHierarchyTable_Scodes)
#include <mapidbg.h>
#undef IMAPIFolder_GetHierarchyTable_Scodes
  extern SCODE IMAPIFolder_GetHierarchyTable_Scodes[];
#endif

#if defined(__polyspace_IMAPIFolder_SaveContentsSort_Scodes) && !defined(__polyspace_no_IMAPIFolder_SaveContentsSort_Scodes)
#include <mapidbg.h>
#undef IMAPIFolder_SaveContentsSort_Scodes
  extern SCODE IMAPIFolder_SaveContentsSort_Scodes[];
#endif

#if defined(__polyspace_IMAPIFolder_OpenEntry_Scodes) && !defined(__polyspace_no_IMAPIFolder_OpenEntry_Scodes)
#include <mapidbg.h>
#undef IMAPIFolder_OpenEntry_Scodes
  extern SCODE IMAPIFolder_OpenEntry_Scodes[];
#endif

#if defined(__polyspace_IMAPIFolder_CreateMessage_Scodes) && !defined(__polyspace_no_IMAPIFolder_CreateMessage_Scodes)
#include <mapidbg.h>
#undef IMAPIFolder_CreateMessage_Scodes
  extern SCODE IMAPIFolder_CreateMessage_Scodes[];
#endif

#if defined(__polyspace_IMAPIFolder_CopyMessages_Scodes) && !defined(__polyspace_no_IMAPIFolder_CopyMessages_Scodes)
#include <mapidbg.h>
#undef IMAPIFolder_CopyMessages_Scodes
  extern SCODE IMAPIFolder_CopyMessages_Scodes[];
#endif

#if defined(__polyspace_IMAPIFolder_DeleteMessages_Scodes) && !defined(__polyspace_no_IMAPIFolder_DeleteMessages_Scodes)
#include <mapidbg.h>
#undef IMAPIFolder_DeleteMessages_Scodes
  extern SCODE IMAPIFolder_DeleteMessages_Scodes[];
#endif

#if defined(__polyspace_IMAPIFolder_CreateFolder_Scodes) && !defined(__polyspace_no_IMAPIFolder_CreateFolder_Scodes)
#include <mapidbg.h>
#undef IMAPIFolder_CreateFolder_Scodes
  extern SCODE IMAPIFolder_CreateFolder_Scodes[];
#endif

#if defined(__polyspace_IMAPIFolder_CopyFolder_Scodes) && !defined(__polyspace_no_IMAPIFolder_CopyFolder_Scodes)
#include <mapidbg.h>
#undef IMAPIFolder_CopyFolder_Scodes
  extern SCODE IMAPIFolder_CopyFolder_Scodes[];
#endif

#if defined(__polyspace_IMAPIFolder_DeleteFolder_Scodes) && !defined(__polyspace_no_IMAPIFolder_DeleteFolder_Scodes)
#include <mapidbg.h>
#undef IMAPIFolder_DeleteFolder_Scodes
  extern SCODE IMAPIFolder_DeleteFolder_Scodes[];
#endif

#if defined(__polyspace_IMAPIFolder_SetSearchCriteria_Scodes) && !defined(__polyspace_no_IMAPIFolder_SetSearchCriteria_Scodes)
#include <mapidbg.h>
#undef IMAPIFolder_SetSearchCriteria_Scodes
  extern SCODE IMAPIFolder_SetSearchCriteria_Scodes[];
#endif

#if defined(__polyspace_IMAPIFolder_GetSearchCriteria_Scodes) && !defined(__polyspace_no_IMAPIFolder_GetSearchCriteria_Scodes)
#include <mapidbg.h>
#undef IMAPIFolder_GetSearchCriteria_Scodes
  extern SCODE IMAPIFolder_GetSearchCriteria_Scodes[];
#endif

#if defined(__polyspace_IMAPIFolder_SetReadFlags_Scodes) && !defined(__polyspace_no_IMAPIFolder_SetReadFlags_Scodes)
#include <mapidbg.h>
#undef IMAPIFolder_SetReadFlags_Scodes
  extern SCODE IMAPIFolder_SetReadFlags_Scodes[];
#endif

#if defined(__polyspace_IMAPIFolder_GetMessageStatus_Scodes) && !defined(__polyspace_no_IMAPIFolder_GetMessageStatus_Scodes)
#include <mapidbg.h>
#undef IMAPIFolder_GetMessageStatus_Scodes
  extern SCODE IMAPIFolder_GetMessageStatus_Scodes[];
#endif

#if defined(__polyspace_IMAPIFolder_SetMessageStatus_Scodes) && !defined(__polyspace_no_IMAPIFolder_SetMessageStatus_Scodes)
#include <mapidbg.h>
#undef IMAPIFolder_SetMessageStatus_Scodes
  extern SCODE IMAPIFolder_SetMessageStatus_Scodes[];
#endif

#if defined(__polyspace_IMAPIFolder_EmptyFolder_Scodes) && !defined(__polyspace_no_IMAPIFolder_EmptyFolder_Scodes)
#include <mapidbg.h>
#undef IMAPIFolder_EmptyFolder_Scodes
  extern SCODE IMAPIFolder_EmptyFolder_Scodes[];
#endif

#if defined(__polyspace_IMessage_SaveChanges_Scodes) && !defined(__polyspace_no_IMessage_SaveChanges_Scodes)
#include <mapidbg.h>
#undef IMessage_SaveChanges_Scodes
  extern SCODE IMessage_SaveChanges_Scodes[];
#endif

#if defined(__polyspace_IMessage_GetAttachmentTable_Scodes) && !defined(__polyspace_no_IMessage_GetAttachmentTable_Scodes)
#include <mapidbg.h>
#undef IMessage_GetAttachmentTable_Scodes
  extern SCODE IMessage_GetAttachmentTable_Scodes[];
#endif

#if defined(__polyspace_IMessage_OpenAttach_Scodes) && !defined(__polyspace_no_IMessage_OpenAttach_Scodes)
#include <mapidbg.h>
#undef IMessage_OpenAttach_Scodes
  extern SCODE IMessage_OpenAttach_Scodes[];
#endif

#if defined(__polyspace_IMessage_CreateAttach_Scodes) && !defined(__polyspace_no_IMessage_CreateAttach_Scodes)
#include <mapidbg.h>
#undef IMessage_CreateAttach_Scodes
  extern SCODE IMessage_CreateAttach_Scodes[];
#endif

#if defined(__polyspace_IMessage_DeleteAttach_Scodes) && !defined(__polyspace_no_IMessage_DeleteAttach_Scodes)
#include <mapidbg.h>
#undef IMessage_DeleteAttach_Scodes
  extern SCODE IMessage_DeleteAttach_Scodes[];
#endif

#if defined(__polyspace_IMessage_GetRecipientTable_Scodes) && !defined(__polyspace_no_IMessage_GetRecipientTable_Scodes)
#include <mapidbg.h>
#undef IMessage_GetRecipientTable_Scodes
  extern SCODE IMessage_GetRecipientTable_Scodes[];
#endif

#if defined(__polyspace_IMessage_ModifyRecipients_Scodes) && !defined(__polyspace_no_IMessage_ModifyRecipients_Scodes)
#include <mapidbg.h>
#undef IMessage_ModifyRecipients_Scodes
  extern SCODE IMessage_ModifyRecipients_Scodes[];
#endif

#if defined(__polyspace_IMessage_SubmitMessage_Scodes) && !defined(__polyspace_no_IMessage_SubmitMessage_Scodes)
#include <mapidbg.h>
#undef IMessage_SubmitMessage_Scodes
  extern SCODE IMessage_SubmitMessage_Scodes[];
#endif

#if defined(__polyspace_IMessage_SetReadFlag_Scodes) && !defined(__polyspace_no_IMessage_SetReadFlag_Scodes)
#include <mapidbg.h>
#undef IMessage_SetReadFlag_Scodes
  extern SCODE IMessage_SetReadFlag_Scodes[];
#endif

#if defined(__polyspace_IAttach_SaveChanges_Scodes) && !defined(__polyspace_no_IAttach_SaveChanges_Scodes)
#include <mapidbg.h>
#undef IAttach_SaveChanges_Scodes
  extern SCODE IAttach_SaveChanges_Scodes[];
#endif

#if defined(__polyspace_IAddrBook_OpenEntry_Scodes) && !defined(__polyspace_no_IAddrBook_OpenEntry_Scodes)
#include <mapidbg.h>
#undef IAddrBook_OpenEntry_Scodes
  extern SCODE IAddrBook_OpenEntry_Scodes[];
#endif

#if defined(__polyspace_IAddrBook_CompareEntryIDs_Scodes) && !defined(__polyspace_no_IAddrBook_CompareEntryIDs_Scodes)
#include <mapidbg.h>
#undef IAddrBook_CompareEntryIDs_Scodes
  extern SCODE IAddrBook_CompareEntryIDs_Scodes[];
#endif

#if defined(__polyspace_IAddrBook_CreateOneOff_Scodes) && !defined(__polyspace_no_IAddrBook_CreateOneOff_Scodes)
#include <mapidbg.h>
#undef IAddrBook_CreateOneOff_Scodes
  extern SCODE IAddrBook_CreateOneOff_Scodes[];
#endif

#if defined(__polyspace_IAddrBook_ResolveName_Scodes) && !defined(__polyspace_no_IAddrBook_ResolveName_Scodes)
#include <mapidbg.h>
#undef IAddrBook_ResolveName_Scodes
  extern SCODE IAddrBook_ResolveName_Scodes[];
#endif

#if defined(__polyspace_IAddrBook_Address_Scodes) && !defined(__polyspace_no_IAddrBook_Address_Scodes)
#include <mapidbg.h>
#undef IAddrBook_Address_Scodes
  extern SCODE IAddrBook_Address_Scodes[];
#endif

#if defined(__polyspace_IAddrBook_Details_Scodes) && !defined(__polyspace_no_IAddrBook_Details_Scodes)
#include <mapidbg.h>
#undef IAddrBook_Details_Scodes
  extern SCODE IAddrBook_Details_Scodes[];
#endif

#if defined(__polyspace_IAddrBook_RecipOptions_Scodes) && !defined(__polyspace_no_IAddrBook_RecipOptions_Scodes)
#include <mapidbg.h>
#undef IAddrBook_RecipOptions_Scodes
  extern SCODE IAddrBook_RecipOptions_Scodes[];
#endif

#if defined(__polyspace_IAddrBook_QueryDefaultRecipOpt_Scodes) && !defined(__polyspace_no_IAddrBook_QueryDefaultRecipOpt_Scodes)
#include <mapidbg.h>
#undef IAddrBook_QueryDefaultRecipOpt_Scodes
  extern SCODE IAddrBook_QueryDefaultRecipOpt_Scodes[];
#endif

#if defined(__polyspace_IAddrBook_ButtonPress_Scodes) && !defined(__polyspace_no_IAddrBook_ButtonPress_Scodes)
#include <mapidbg.h>
#undef IAddrBook_ButtonPress_Scodes
  extern SCODE IAddrBook_ButtonPress_Scodes[];
#endif

#if defined(__polyspace_IABContainer_GetContentsTable_Scodes) && !defined(__polyspace_no_IABContainer_GetContentsTable_Scodes)
#include <mapidbg.h>
#undef IABContainer_GetContentsTable_Scodes
  extern SCODE IABContainer_GetContentsTable_Scodes[];
#endif

#if defined(__polyspace_IABContainer_GetHierarchyTable_Scodes) && !defined(__polyspace_no_IABContainer_GetHierarchyTable_Scodes)
#include <mapidbg.h>
#undef IABContainer_GetHierarchyTable_Scodes
  extern SCODE IABContainer_GetHierarchyTable_Scodes[];
#endif

#if defined(__polyspace_INotifObj_ChangeEvMask_Scodes) && !defined(__polyspace_no_INotifObj_ChangeEvMask_Scodes)
#include <mapidbg.h>
#undef INotifObj_ChangeEvMask_Scodes
  extern SCODE INotifObj_ChangeEvMask_Scodes[];
#endif

#if defined(__polyspace_IMAPIStatus_ChangePassword_Scodes) && !defined(__polyspace_no_IMAPIStatus_ChangePassword_Scodes)
#include <mapidbg.h>
#undef IMAPIStatus_ChangePassword_Scodes
  extern SCODE IMAPIStatus_ChangePassword_Scodes[];
#endif

#if defined(__polyspace_IMAPIStatus_FlushQueues_Scodes) && !defined(__polyspace_no_IMAPIStatus_FlushQueues_Scodes)
#include <mapidbg.h>
#undef IMAPIStatus_FlushQueues_Scodes
  extern SCODE IMAPIStatus_FlushQueues_Scodes[];
#endif

#if defined(__polyspace_IMAPIStatus_SettingsDialog_Scodes) && !defined(__polyspace_no_IMAPIStatus_SettingsDialog_Scodes)
#include <mapidbg.h>
#undef IMAPIStatus_SettingsDialog_Scodes
  extern SCODE IMAPIStatus_SettingsDialog_Scodes[];
#endif

#if defined(__polyspace_IMAPIStatus_ValidateState_Scodes) && !defined(__polyspace_no_IMAPIStatus_ValidateState_Scodes)
#include <mapidbg.h>
#undef IMAPIStatus_ValidateState_Scodes
  extern SCODE IMAPIStatus_ValidateState_Scodes[];
#endif

#if defined(__polyspace_IMSProvider_Logon_Scodes) && !defined(__polyspace_no_IMSProvider_Logon_Scodes)
#include <mapidbg.h>
#undef IMSProvider_Logon_Scodes
  extern SCODE IMSProvider_Logon_Scodes[];
#endif

#if defined(__polyspace_IMSProvider_Deinit_Scodes) && !defined(__polyspace_no_IMSProvider_Deinit_Scodes)
#include <mapidbg.h>
#undef IMSProvider_Deinit_Scodes
  extern SCODE IMSProvider_Deinit_Scodes[];
#endif

#if defined(__polyspace_IMSProvider_Init_Scodes) && !defined(__polyspace_no_IMSProvider_Init_Scodes)
#include <mapidbg.h>
#undef IMSProvider_Init_Scodes
  extern SCODE IMSProvider_Init_Scodes[];
#endif

#if defined(__polyspace_IMSProvider_SpoolerLogon_Scodes) && !defined(__polyspace_no_IMSProvider_SpoolerLogon_Scodes)
#include <mapidbg.h>
#undef IMSProvider_SpoolerLogon_Scodes
  extern SCODE IMSProvider_SpoolerLogon_Scodes[];
#endif

#if defined(__polyspace_IMSProvider_Shutdown_Scodes) && !defined(__polyspace_no_IMSProvider_Shutdown_Scodes)
#include <mapidbg.h>
#undef IMSProvider_Shutdown_Scodes
  extern SCODE IMSProvider_Shutdown_Scodes[];
#endif

#if defined(__polyspace_SMAPI_MAPILogon_Scodes) && !defined(__polyspace_no_SMAPI_MAPILogon_Scodes)
#include <mapidbg.h>
#undef SMAPI_MAPILogon_Scodes
  extern SCODE SMAPI_MAPILogon_Scodes[];
#endif

#if defined(__polyspace_SMAPI_MAPILogoff_Scodes) && !defined(__polyspace_no_SMAPI_MAPILogoff_Scodes)
#include <mapidbg.h>
#undef SMAPI_MAPILogoff_Scodes
  extern SCODE SMAPI_MAPILogoff_Scodes[];
#endif

#if defined(__polyspace_SMAPI_MAPIFreeBuffer_Scodes) && !defined(__polyspace_no_SMAPI_MAPIFreeBuffer_Scodes)
#include <mapidbg.h>
#undef SMAPI_MAPIFreeBuffer_Scodes
  extern SCODE SMAPI_MAPIFreeBuffer_Scodes[];
#endif

#if defined(__polyspace_SMAPI_MAPISendMail_Scodes) && !defined(__polyspace_no_SMAPI_MAPISendMail_Scodes)
#include <mapidbg.h>
#undef SMAPI_MAPISendMail_Scodes
  extern SCODE SMAPI_MAPISendMail_Scodes[];
#endif

#if defined(__polyspace_SMAPI_MAPISendDocuments_Scodes) && !defined(__polyspace_no_SMAPI_MAPISendDocuments_Scodes)
#include <mapidbg.h>
#undef SMAPI_MAPISendDocuments_Scodes
  extern SCODE SMAPI_MAPISendDocuments_Scodes[];
#endif

#if defined(__polyspace_SMAPI_MAPIFindNext_Scodes) && !defined(__polyspace_no_SMAPI_MAPIFindNext_Scodes)
#include <mapidbg.h>
#undef SMAPI_MAPIFindNext_Scodes
  extern SCODE SMAPI_MAPIFindNext_Scodes[];
#endif

#if defined(__polyspace_SMAPI_MAPIReadMail_Scodes) && !defined(__polyspace_no_SMAPI_MAPIReadMail_Scodes)
#include <mapidbg.h>
#undef SMAPI_MAPIReadMail_Scodes
  extern SCODE SMAPI_MAPIReadMail_Scodes[];
#endif

#if defined(__polyspace_SMAPI_MAPISaveMail_Scodes) && !defined(__polyspace_no_SMAPI_MAPISaveMail_Scodes)
#include <mapidbg.h>
#undef SMAPI_MAPISaveMail_Scodes
  extern SCODE SMAPI_MAPISaveMail_Scodes[];
#endif

#if defined(__polyspace_SMAPI_MAPIDeleteMail_Scodes) && !defined(__polyspace_no_SMAPI_MAPIDeleteMail_Scodes)
#include <mapidbg.h>
#undef SMAPI_MAPIDeleteMail_Scodes
  extern SCODE SMAPI_MAPIDeleteMail_Scodes[];
#endif

#if defined(__polyspace_SMAPI_MAPIAddress_Scodes) && !defined(__polyspace_no_SMAPI_MAPIAddress_Scodes)
#include <mapidbg.h>
#undef SMAPI_MAPIAddress_Scodes
  extern SCODE SMAPI_MAPIAddress_Scodes[];
#endif

#if defined(__polyspace_SMAPI_MAPIResolveName_Scodes) && !defined(__polyspace_no_SMAPI_MAPIResolveName_Scodes)
#include <mapidbg.h>
#undef SMAPI_MAPIResolveName_Scodes
  extern SCODE SMAPI_MAPIResolveName_Scodes[];
#endif

#if defined(__polyspace_SMAPI_MAPIDetails_Scodes) && !defined(__polyspace_no_SMAPI_MAPIDetails_Scodes)
#include <mapidbg.h>
#undef SMAPI_MAPIDetails_Scodes
  extern SCODE SMAPI_MAPIDetails_Scodes[];
#endif

#if defined(__polyspace_IMSLogon_OpenEntry_Scodes) && !defined(__polyspace_no_IMSLogon_OpenEntry_Scodes)
#include <mapidbg.h>
#undef IMSLogon_OpenEntry_Scodes
  extern SCODE IMSLogon_OpenEntry_Scodes[];
#endif

#if defined(__polyspace_IMSLogon_OpenStatusEntry_Scodes) && !defined(__polyspace_no_IMSLogon_OpenStatusEntry_Scodes)
#include <mapidbg.h>
#undef IMSLogon_OpenStatusEntry_Scodes
  extern SCODE IMSLogon_OpenStatusEntry_Scodes[];
#endif

#if defined(__polyspace_IMSLogon_CompareEntryIDs_Scodes) && !defined(__polyspace_no_IMSLogon_CompareEntryIDs_Scodes)
#include <mapidbg.h>
#undef IMSLogon_CompareEntryIDs_Scodes
  extern SCODE IMSLogon_CompareEntryIDs_Scodes[];
#endif

#if defined(__polyspace_IMSLogon_Advise_Scodes) && !defined(__polyspace_no_IMSLogon_Advise_Scodes)
#include <mapidbg.h>
#undef IMSLogon_Advise_Scodes
  extern SCODE IMSLogon_Advise_Scodes[];
#endif

#if defined(__polyspace_IMSLogon_Unadvise_Scodes) && !defined(__polyspace_no_IMSLogon_Unadvise_Scodes)
#include <mapidbg.h>
#undef IMSLogon_Unadvise_Scodes
  extern SCODE IMSLogon_Unadvise_Scodes[];
#endif

#if defined(__polyspace_IMSLogon_Logoff_Scodes) && !defined(__polyspace_no_IMSLogon_Logoff_Scodes)
#include <mapidbg.h>
#undef IMSLogon_Logoff_Scodes
  extern SCODE IMSLogon_Logoff_Scodes[];
#endif

#if defined(__polyspace_rgchCsds) && !defined(__polyspace_no_rgchCsds)
#include <mapiutil.h>
#undef rgchCsds
  extern char rgchCsds[];
#endif

#if defined(__polyspace_rgchCids) && !defined(__polyspace_no_rgchCids)
#include <mapiutil.h>
#undef rgchCids
  extern char rgchCids[];
#endif

#if defined(__polyspace_rgchCsdi) && !defined(__polyspace_no_rgchCsdi)
#include <mapiutil.h>
#undef rgchCsdi
  extern char rgchCsdi[];
#endif

#if defined(__polyspace_rgchCidi) && !defined(__polyspace_no_rgchCidi)
#include <mapiutil.h>
#undef rgchCidi
  extern char rgchCidi[];
#endif

#if defined(__polyspace_pinstX) && !defined(__polyspace_no_pinstX)
#include <mapiwin.h>
#undef pinstX
  extern LPVOID pinstX;
#endif

#if defined(__polyspace__mbcasemap) && !defined(__polyspace_no__mbcasemap)
#include <mbctype.h>
#undef _mbcasemap
  extern unsigned char _mbcasemap[];
#endif

#if defined(__polyspace___MIDL_itf_mddefw_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mddefw_0000_v0_0_c_ifspec)
#include <mddefw.h>
#undef __MIDL_itf_mddefw_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mddefw_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mddefw_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mddefw_0000_v0_0_s_ifspec)
#include <mddefw.h>
#undef __MIDL_itf_mddefw_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mddefw_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mimeinfo_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mimeinfo_0000_v0_0_c_ifspec)
#include <mimeinfo.h>
#undef __MIDL_itf_mimeinfo_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mimeinfo_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mimeinfo_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mimeinfo_0000_v0_0_s_ifspec)
#include <mimeinfo.h>
#undef __MIDL_itf_mimeinfo_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mimeinfo_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mimeinfo_0074_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mimeinfo_0074_v0_0_c_ifspec)
#include <mimeinfo.h>
#undef __MIDL_itf_mimeinfo_0074_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mimeinfo_0074_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mimeinfo_0074_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mimeinfo_0074_v0_0_s_ifspec)
#include <mimeinfo.h>
#undef __MIDL_itf_mimeinfo_0074_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mimeinfo_0074_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mlang_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mlang_0000_v0_0_c_ifspec)
#include <mlang.h>
#undef __MIDL_itf_mlang_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mlang_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mlang_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mlang_0000_v0_0_s_ifspec)
#include <mlang.h>
#undef __MIDL_itf_mlang_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mlang_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mlang_0106_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mlang_0106_v0_0_c_ifspec)
#include <mlang.h>
#undef __MIDL_itf_mlang_0106_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mlang_0106_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mlang_0106_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mlang_0106_v0_0_s_ifspec)
#include <mlang.h>
#undef __MIDL_itf_mlang_0106_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mlang_0106_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mmc_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mmc_0000_v0_0_c_ifspec)
#include <mmc.h>
#undef __MIDL_itf_mmc_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mmc_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mmc_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mmc_0000_v0_0_s_ifspec)
#include <mmc.h>
#undef __MIDL_itf_mmc_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mmc_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mmc_0106_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mmc_0106_v0_0_c_ifspec)
#include <mmc.h>
#undef __MIDL_itf_mmc_0106_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mmc_0106_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mmc_0106_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mmc_0106_v0_0_s_ifspec)
#include <mmc.h>
#undef __MIDL_itf_mmc_0106_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mmc_0106_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mmc_0114_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mmc_0114_v0_0_c_ifspec)
#include <mmc.h>
#undef __MIDL_itf_mmc_0114_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mmc_0114_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mmc_0114_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mmc_0114_v0_0_s_ifspec)
#include <mmc.h>
#undef __MIDL_itf_mmc_0114_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mmc_0114_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mmstream_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mmstream_0000_v0_0_c_ifspec)
#include <mmstream.h>
#undef __MIDL_itf_mmstream_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mmstream_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mmstream_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mmstream_0000_v0_0_s_ifspec)
#include <mmstream.h>
#undef __MIDL_itf_mmstream_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mmstream_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace_DBPROPSET_PWROWSET) && !defined(__polyspace_no_DBPROPSET_PWROWSET)
#include <msdaosp.h>
#undef DBPROPSET_PWROWSET
  extern const GUID DBPROPSET_PWROWSET;
#endif

#if defined(__polyspace___MIDL_itf_msdaosp_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_msdaosp_0000_v0_0_c_ifspec)
#include <msdaosp.h>
#undef __MIDL_itf_msdaosp_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_msdaosp_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_msdaosp_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_msdaosp_0000_v0_0_s_ifspec)
#include <msdaosp.h>
#undef __MIDL_itf_msdaosp_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_msdaosp_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_MSDASC_0149_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_MSDASC_0149_v0_0_c_ifspec)
#include <msdasc.h>
#undef __MIDL_itf_MSDASC_0149_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_MSDASC_0149_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_MSDASC_0149_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_MSDASC_0149_v0_0_s_ifspec)
#include <msdasc.h>
#undef __MIDL_itf_MSDASC_0149_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_MSDASC_0149_v0_0_s_ifspec;
#endif

#if defined(__polyspace_IID_ISQLGetDiagField) && !defined(__polyspace_no_IID_ISQLGetDiagField)
#include <msdasql.h>
#undef IID_ISQLGetDiagField
  extern const GUID IID_ISQLGetDiagField;
#endif

#if defined(__polyspace_IID_IRowsetChangeExtInfo) && !defined(__polyspace_no_IID_IRowsetChangeExtInfo)
#include <msdasql.h>
#undef IID_IRowsetChangeExtInfo
  extern const GUID IID_IRowsetChangeExtInfo;
#endif

#if defined(__polyspace_CLSID_MSDASQL) && !defined(__polyspace_no_CLSID_MSDASQL)
#include <msdasql.h>
#undef CLSID_MSDASQL
  extern const GUID CLSID_MSDASQL;
#endif

#if defined(__polyspace_CLSID_MSDASQL_ENUMERATOR) && !defined(__polyspace_no_CLSID_MSDASQL_ENUMERATOR)
#include <msdasql.h>
#undef CLSID_MSDASQL_ENUMERATOR
  extern const GUID CLSID_MSDASQL_ENUMERATOR;
#endif

#if defined(__polyspace_DBPROPSET_PROVIDERROWSET) && !defined(__polyspace_no_DBPROPSET_PROVIDERROWSET)
#include <msdasql.h>
#undef DBPROPSET_PROVIDERROWSET
  extern const GUID DBPROPSET_PROVIDERROWSET;
#endif

#if defined(__polyspace_DBPROPSET_PROVIDERDBINIT) && !defined(__polyspace_no_DBPROPSET_PROVIDERDBINIT)
#include <msdasql.h>
#undef DBPROPSET_PROVIDERDBINIT
  extern const GUID DBPROPSET_PROVIDERDBINIT;
#endif

#if defined(__polyspace_DBPROPSET_PROVIDERSTMTATTR) && !defined(__polyspace_no_DBPROPSET_PROVIDERSTMTATTR)
#include <msdasql.h>
#undef DBPROPSET_PROVIDERSTMTATTR
  extern const GUID DBPROPSET_PROVIDERSTMTATTR;
#endif

#if defined(__polyspace_DBPROPSET_PROVIDERCONNATTR) && !defined(__polyspace_no_DBPROPSET_PROVIDERCONNATTR)
#include <msdasql.h>
#undef DBPROPSET_PROVIDERCONNATTR
  extern const GUID DBPROPSET_PROVIDERCONNATTR;
#endif

#if defined(__polyspace___MIDL_itf_msdatsrc_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_msdatsrc_0000_v0_0_c_ifspec)
#include <msdatsrc.h>
#undef __MIDL_itf_msdatsrc_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_msdatsrc_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_msdatsrc_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_msdatsrc_0000_v0_0_s_ifspec)
#include <msdatsrc.h>
#undef __MIDL_itf_msdatsrc_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_msdatsrc_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mshtmhst_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mshtmhst_0000_v0_0_c_ifspec)
#include <mshtmhst.h>
#undef __MIDL_itf_mshtmhst_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mshtmhst_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mshtmhst_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mshtmhst_0000_v0_0_s_ifspec)
#include <mshtmhst.h>
#undef __MIDL_itf_mshtmhst_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mshtmhst_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mshtmhst_0350_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mshtmhst_0350_v0_0_c_ifspec)
#include <mshtmhst.h>
#undef __MIDL_itf_mshtmhst_0350_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mshtmhst_0350_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mshtmhst_0350_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mshtmhst_0350_v0_0_s_ifspec)
#include <mshtmhst.h>
#undef __MIDL_itf_mshtmhst_0350_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mshtmhst_0350_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mshtml_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mshtml_0000_v0_0_c_ifspec)
#include <mshtml.h>
#undef __MIDL_itf_mshtml_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mshtml_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mshtml_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mshtml_0000_v0_0_s_ifspec)
#include <mshtml.h>
#undef __MIDL_itf_mshtml_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mshtml_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace_SharedFileNeedsCopying) && !defined(__polyspace_no_SharedFileNeedsCopying)
#include <msshared.h>
#undef SharedFileNeedsCopying
  extern BOOL SharedFileNeedsCopying;
#endif

#if defined(__polyspace___MIDL_itf_mstask_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mstask_0000_v0_0_c_ifspec)
#include <mstask.h>
#undef __MIDL_itf_mstask_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mstask_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mstask_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mstask_0000_v0_0_s_ifspec)
#include <mstask.h>
#undef __MIDL_itf_mstask_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mstask_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mstask_0119_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mstask_0119_v0_0_c_ifspec)
#include <mstask.h>
#undef __MIDL_itf_mstask_0119_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mstask_0119_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mstask_0119_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mstask_0119_v0_0_s_ifspec)
#include <mstask.h>
#undef __MIDL_itf_mstask_0119_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mstask_0119_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mstask_0120_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mstask_0120_v0_0_c_ifspec)
#include <mstask.h>
#undef __MIDL_itf_mstask_0120_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mstask_0120_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mstask_0120_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mstask_0120_v0_0_s_ifspec)
#include <mstask.h>
#undef __MIDL_itf_mstask_0120_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mstask_0120_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mstask_0121_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mstask_0121_v0_0_c_ifspec)
#include <mstask.h>
#undef __MIDL_itf_mstask_0121_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mstask_0121_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mstask_0121_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mstask_0121_v0_0_s_ifspec)
#include <mstask.h>
#undef __MIDL_itf_mstask_0121_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mstask_0121_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mstask_0122_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mstask_0122_v0_0_c_ifspec)
#include <mstask.h>
#undef __MIDL_itf_mstask_0122_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mstask_0122_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mstask_0122_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mstask_0122_v0_0_s_ifspec)
#include <mstask.h>
#undef __MIDL_itf_mstask_0122_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mstask_0122_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mstask_0123_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mstask_0123_v0_0_c_ifspec)
#include <mstask.h>
#undef __MIDL_itf_mstask_0123_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mstask_0123_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mstask_0123_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mstask_0123_v0_0_s_ifspec)
#include <mstask.h>
#undef __MIDL_itf_mstask_0123_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mstask_0123_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mstask_0124_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mstask_0124_v0_0_c_ifspec)
#include <mstask.h>
#undef __MIDL_itf_mstask_0124_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mstask_0124_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mstask_0124_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mstask_0124_v0_0_s_ifspec)
#include <mstask.h>
#undef __MIDL_itf_mstask_0124_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mstask_0124_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_msxml_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_msxml_0000_v0_0_c_ifspec)
#include <msxml.h>
#undef __MIDL_itf_msxml_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_msxml_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_msxml_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_msxml_0000_v0_0_s_ifspec)
#include <msxml.h>
#undef __MIDL_itf_msxml_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_msxml_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mtx_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mtx_0000_v0_0_c_ifspec)
#include <mtx.h>
#undef __MIDL_itf_mtx_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mtx_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mtx_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mtx_0000_v0_0_s_ifspec)
#include <mtx.h>
#undef __MIDL_itf_mtx_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mtx_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mtx_0006_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mtx_0006_v0_0_c_ifspec)
#include <mtx.h>
#undef __MIDL_itf_mtx_0006_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mtx_0006_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mtx_0006_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mtx_0006_v0_0_s_ifspec)
#include <mtx.h>
#undef __MIDL_itf_mtx_0006_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mtx_0006_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mtx_0100_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mtx_0100_v0_0_c_ifspec)
#include <mtx.h>
#undef __MIDL_itf_mtx_0100_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mtx_0100_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mtx_0100_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mtx_0100_v0_0_s_ifspec)
#include <mtx.h>
#undef __MIDL_itf_mtx_0100_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mtx_0100_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mtxadmin_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mtxadmin_0000_v0_0_c_ifspec)
#include <mtxadmin.h>
#undef __MIDL_itf_mtxadmin_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mtxadmin_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mtxadmin_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mtxadmin_0000_v0_0_s_ifspec)
#include <mtxadmin.h>
#undef __MIDL_itf_mtxadmin_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mtxadmin_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mtxdm_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mtxdm_0000_v0_0_c_ifspec)
#include <mtxdm.h>
#undef __MIDL_itf_mtxdm_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mtxdm_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mtxdm_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mtxdm_0000_v0_0_s_ifspec)
#include <mtxdm.h>
#undef __MIDL_itf_mtxdm_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mtxdm_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mtxdm_0094_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mtxdm_0094_v0_0_c_ifspec)
#include <mtxdm.h>
#undef __MIDL_itf_mtxdm_0094_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mtxdm_0094_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mtxdm_0094_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mtxdm_0094_v0_0_s_ifspec)
#include <mtxdm.h>
#undef __MIDL_itf_mtxdm_0094_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mtxdm_0094_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mtxdm_0095_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mtxdm_0095_v0_0_c_ifspec)
#include <mtxdm.h>
#undef __MIDL_itf_mtxdm_0095_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mtxdm_0095_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mtxdm_0095_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mtxdm_0095_v0_0_s_ifspec)
#include <mtxdm.h>
#undef __MIDL_itf_mtxdm_0095_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mtxdm_0095_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mtxdm_0096_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mtxdm_0096_v0_0_c_ifspec)
#include <mtxdm.h>
#undef __MIDL_itf_mtxdm_0096_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mtxdm_0096_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mtxdm_0096_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mtxdm_0096_v0_0_s_ifspec)
#include <mtxdm.h>
#undef __MIDL_itf_mtxdm_0096_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mtxdm_0096_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mtxspm_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_mtxspm_0000_v0_0_c_ifspec)
#include <mtxspm.h>
#undef __MIDL_itf_mtxspm_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mtxspm_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_mtxspm_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_mtxspm_0000_v0_0_s_ifspec)
#include <mtxspm.h>
#undef __MIDL_itf_mtxspm_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_mtxspm_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL__intf_0053_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL__intf_0053_v0_0_c_ifspec)
#include <multinfo.h>
#undef __MIDL__intf_0053_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL__intf_0053_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL__intf_0053_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL__intf_0053_v0_0_s_ifspec)
#include <multinfo.h>
#undef __MIDL__intf_0053_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL__intf_0053_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oaidl_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oaidl_0000_v0_0_c_ifspec)
#include <oaidl.h>
#undef __MIDL_itf_oaidl_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oaidl_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oaidl_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oaidl_0000_v0_0_s_ifspec)
#include <oaidl.h>
#undef __MIDL_itf_oaidl_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oaidl_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace_IOleAutomationTypes_v1_0_c_ifspec) && !defined(__polyspace_no_IOleAutomationTypes_v1_0_c_ifspec)
#include <oaidl.h>
#undef IOleAutomationTypes_v1_0_c_ifspec
  extern RPC_IF_HANDLE IOleAutomationTypes_v1_0_c_ifspec;
#endif

#if defined(__polyspace_IOleAutomationTypes_v1_0_s_ifspec) && !defined(__polyspace_no_IOleAutomationTypes_v1_0_s_ifspec)
#include <oaidl.h>
#undef IOleAutomationTypes_v1_0_s_ifspec
  extern RPC_IF_HANDLE IOleAutomationTypes_v1_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oaidl_0092_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oaidl_0092_v0_0_c_ifspec)
#include <oaidl.h>
#undef __MIDL_itf_oaidl_0092_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oaidl_0092_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oaidl_0092_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oaidl_0092_v0_0_s_ifspec)
#include <oaidl.h>
#undef __MIDL_itf_oaidl_0092_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oaidl_0092_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objidl_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_objidl_0000_v0_0_c_ifspec)
#include <objidl.h>
#undef __MIDL_itf_objidl_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objidl_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objidl_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_objidl_0000_v0_0_s_ifspec)
#include <objidl.h>
#undef __MIDL_itf_objidl_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objidl_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objidl_0043_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_objidl_0043_v0_0_c_ifspec)
#include <objidl.h>
#undef __MIDL_itf_objidl_0043_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objidl_0043_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objidl_0043_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_objidl_0043_v0_0_s_ifspec)
#include <objidl.h>
#undef __MIDL_itf_objidl_0043_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objidl_0043_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objidl_0044_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_objidl_0044_v0_0_c_ifspec)
#include <objidl.h>
#undef __MIDL_itf_objidl_0044_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objidl_0044_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objidl_0044_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_objidl_0044_v0_0_s_ifspec)
#include <objidl.h>
#undef __MIDL_itf_objidl_0044_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objidl_0044_v0_0_s_ifspec;
#endif

#if defined(__polyspace_FMTID_SummaryInformation) && !defined(__polyspace_no_FMTID_SummaryInformation)
#include <objidl.h>
#undef FMTID_SummaryInformation
  extern const FMTID FMTID_SummaryInformation;
#endif

#if defined(__polyspace_FMTID_DocSummaryInformation) && !defined(__polyspace_no_FMTID_DocSummaryInformation)
#include <objidl.h>
#undef FMTID_DocSummaryInformation
  extern const FMTID FMTID_DocSummaryInformation;
#endif

#if defined(__polyspace_FMTID_UserDefinedProperties) && !defined(__polyspace_no_FMTID_UserDefinedProperties)
#include <objidl.h>
#undef FMTID_UserDefinedProperties
  extern const FMTID FMTID_UserDefinedProperties;
#endif

#if defined(__polyspace___MIDL_itf_objidl_0048_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_objidl_0048_v0_0_c_ifspec)
#include <objidl.h>
#undef __MIDL_itf_objidl_0048_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objidl_0048_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objidl_0048_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_objidl_0048_v0_0_s_ifspec)
#include <objidl.h>
#undef __MIDL_itf_objidl_0048_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objidl_0048_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objidl_0052_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_objidl_0052_v0_0_c_ifspec)
#include <objidl.h>
#undef __MIDL_itf_objidl_0052_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objidl_0052_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objidl_0052_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_objidl_0052_v0_0_s_ifspec)
#include <objidl.h>
#undef __MIDL_itf_objidl_0052_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objidl_0052_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objidl_0053_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_objidl_0053_v0_0_c_ifspec)
#include <objidl.h>
#undef __MIDL_itf_objidl_0053_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objidl_0053_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objidl_0053_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_objidl_0053_v0_0_s_ifspec)
#include <objidl.h>
#undef __MIDL_itf_objidl_0053_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objidl_0053_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objidl_0069_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_objidl_0069_v0_0_c_ifspec)
#include <objidl.h>
#undef __MIDL_itf_objidl_0069_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objidl_0069_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objidl_0069_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_objidl_0069_v0_0_s_ifspec)
#include <objidl.h>
#undef __MIDL_itf_objidl_0069_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objidl_0069_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objidl_0071_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_objidl_0071_v0_0_c_ifspec)
#include <objidl.h>
#undef __MIDL_itf_objidl_0071_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objidl_0071_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objidl_0071_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_objidl_0071_v0_0_s_ifspec)
#include <objidl.h>
#undef __MIDL_itf_objidl_0071_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objidl_0071_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objidl_0072_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_objidl_0072_v0_0_c_ifspec)
#include <objidl.h>
#undef __MIDL_itf_objidl_0072_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objidl_0072_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objidl_0072_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_objidl_0072_v0_0_s_ifspec)
#include <objidl.h>
#undef __MIDL_itf_objidl_0072_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objidl_0072_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objsafe_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_objsafe_0000_v0_0_c_ifspec)
#include <objsafe.h>
#undef __MIDL_itf_objsafe_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objsafe_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objsafe_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_objsafe_0000_v0_0_s_ifspec)
#include <objsafe.h>
#undef __MIDL_itf_objsafe_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objsafe_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objsafe_0006_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_objsafe_0006_v0_0_c_ifspec)
#include <objsafe.h>
#undef __MIDL_itf_objsafe_0006_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objsafe_0006_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_objsafe_0006_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_objsafe_0006_v0_0_s_ifspec)
#include <objsafe.h>
#undef __MIDL_itf_objsafe_0006_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_objsafe_0006_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_ocidl_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_ocidl_0000_v0_0_c_ifspec)
#include <ocidl.h>
#undef __MIDL_itf_ocidl_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_ocidl_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_ocidl_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_ocidl_0000_v0_0_s_ifspec)
#include <ocidl.h>
#undef __MIDL_itf_ocidl_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_ocidl_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace_IOleControlTypes_v1_0_c_ifspec) && !defined(__polyspace_no_IOleControlTypes_v1_0_c_ifspec)
#include <ocidl.h>
#undef IOleControlTypes_v1_0_c_ifspec
  extern RPC_IF_HANDLE IOleControlTypes_v1_0_c_ifspec;
#endif

#if defined(__polyspace_IOleControlTypes_v1_0_s_ifspec) && !defined(__polyspace_no_IOleControlTypes_v1_0_s_ifspec)
#include <ocidl.h>
#undef IOleControlTypes_v1_0_s_ifspec
  extern RPC_IF_HANDLE IOleControlTypes_v1_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0000_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0000_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace_DBCOLUMN_IDNAME) && !defined(__polyspace_no_DBCOLUMN_IDNAME)
#include <oledb.h>
#undef DBCOLUMN_IDNAME
  extern const DBID DBCOLUMN_IDNAME;
#endif

#if defined(__polyspace_DBCOLUMN_NAME) && !defined(__polyspace_no_DBCOLUMN_NAME)
#include <oledb.h>
#undef DBCOLUMN_NAME
  extern const DBID DBCOLUMN_NAME;
#endif

#if defined(__polyspace_DBCOLUMN_NUMBER) && !defined(__polyspace_no_DBCOLUMN_NUMBER)
#include <oledb.h>
#undef DBCOLUMN_NUMBER
  extern const DBID DBCOLUMN_NUMBER;
#endif

#if defined(__polyspace_DBCOLUMN_TYPE) && !defined(__polyspace_no_DBCOLUMN_TYPE)
#include <oledb.h>
#undef DBCOLUMN_TYPE
  extern const DBID DBCOLUMN_TYPE;
#endif

#if defined(__polyspace_DBCOLUMN_PRECISION) && !defined(__polyspace_no_DBCOLUMN_PRECISION)
#include <oledb.h>
#undef DBCOLUMN_PRECISION
  extern const DBID DBCOLUMN_PRECISION;
#endif

#if defined(__polyspace_DBCOLUMN_SCALE) && !defined(__polyspace_no_DBCOLUMN_SCALE)
#include <oledb.h>
#undef DBCOLUMN_SCALE
  extern const DBID DBCOLUMN_SCALE;
#endif

#if defined(__polyspace_DBCOLUMN_FLAGS) && !defined(__polyspace_no_DBCOLUMN_FLAGS)
#include <oledb.h>
#undef DBCOLUMN_FLAGS
  extern const DBID DBCOLUMN_FLAGS;
#endif

#if defined(__polyspace_DBCOLUMN_BASECOLUMNNAME) && !defined(__polyspace_no_DBCOLUMN_BASECOLUMNNAME)
#include <oledb.h>
#undef DBCOLUMN_BASECOLUMNNAME
  extern const DBID DBCOLUMN_BASECOLUMNNAME;
#endif

#if defined(__polyspace_DBCOLUMN_BASETABLENAME) && !defined(__polyspace_no_DBCOLUMN_BASETABLENAME)
#include <oledb.h>
#undef DBCOLUMN_BASETABLENAME
  extern const DBID DBCOLUMN_BASETABLENAME;
#endif

#if defined(__polyspace_DBCOLUMN_COLLATINGSEQUENCE) && !defined(__polyspace_no_DBCOLUMN_COLLATINGSEQUENCE)
#include <oledb.h>
#undef DBCOLUMN_COLLATINGSEQUENCE
  extern const DBID DBCOLUMN_COLLATINGSEQUENCE;
#endif

#if defined(__polyspace_DBCOLUMN_COMPUTEMODE) && !defined(__polyspace_no_DBCOLUMN_COMPUTEMODE)
#include <oledb.h>
#undef DBCOLUMN_COMPUTEMODE
  extern const DBID DBCOLUMN_COMPUTEMODE;
#endif

#if defined(__polyspace_DBCOLUMN_DEFAULTVALUE) && !defined(__polyspace_no_DBCOLUMN_DEFAULTVALUE)
#include <oledb.h>
#undef DBCOLUMN_DEFAULTVALUE
  extern const DBID DBCOLUMN_DEFAULTVALUE;
#endif

#if defined(__polyspace_DBCOLUMN_DOMAINNAME) && !defined(__polyspace_no_DBCOLUMN_DOMAINNAME)
#include <oledb.h>
#undef DBCOLUMN_DOMAINNAME
  extern const DBID DBCOLUMN_DOMAINNAME;
#endif

#if defined(__polyspace_DBCOLUMN_HASDEFAULT) && !defined(__polyspace_no_DBCOLUMN_HASDEFAULT)
#include <oledb.h>
#undef DBCOLUMN_HASDEFAULT
  extern const DBID DBCOLUMN_HASDEFAULT;
#endif

#if defined(__polyspace_DBCOLUMN_ISAUTOINCREMENT) && !defined(__polyspace_no_DBCOLUMN_ISAUTOINCREMENT)
#include <oledb.h>
#undef DBCOLUMN_ISAUTOINCREMENT
  extern const DBID DBCOLUMN_ISAUTOINCREMENT;
#endif

#if defined(__polyspace_DBCOLUMN_ISCASESENSITIVE) && !defined(__polyspace_no_DBCOLUMN_ISCASESENSITIVE)
#include <oledb.h>
#undef DBCOLUMN_ISCASESENSITIVE
  extern const DBID DBCOLUMN_ISCASESENSITIVE;
#endif

#if defined(__polyspace_DBCOLUMN_ISSEARCHABLE) && !defined(__polyspace_no_DBCOLUMN_ISSEARCHABLE)
#include <oledb.h>
#undef DBCOLUMN_ISSEARCHABLE
  extern const DBID DBCOLUMN_ISSEARCHABLE;
#endif

#if defined(__polyspace_DBCOLUMN_ISUNIQUE) && !defined(__polyspace_no_DBCOLUMN_ISUNIQUE)
#include <oledb.h>
#undef DBCOLUMN_ISUNIQUE
  extern const DBID DBCOLUMN_ISUNIQUE;
#endif

#if defined(__polyspace_DBCOLUMN_BASECATALOGNAME) && !defined(__polyspace_no_DBCOLUMN_BASECATALOGNAME)
#include <oledb.h>
#undef DBCOLUMN_BASECATALOGNAME
  extern const DBID DBCOLUMN_BASECATALOGNAME;
#endif

#if defined(__polyspace_DBCOLUMN_BASESCHEMANAME) && !defined(__polyspace_no_DBCOLUMN_BASESCHEMANAME)
#include <oledb.h>
#undef DBCOLUMN_BASESCHEMANAME
  extern const DBID DBCOLUMN_BASESCHEMANAME;
#endif

#if defined(__polyspace_DBCOLUMN_GUID) && !defined(__polyspace_no_DBCOLUMN_GUID)
#include <oledb.h>
#undef DBCOLUMN_GUID
  extern const DBID DBCOLUMN_GUID;
#endif

#if defined(__polyspace_DBCOLUMN_PROPID) && !defined(__polyspace_no_DBCOLUMN_PROPID)
#include <oledb.h>
#undef DBCOLUMN_PROPID
  extern const DBID DBCOLUMN_PROPID;
#endif

#if defined(__polyspace_DBCOLUMN_TYPEINFO) && !defined(__polyspace_no_DBCOLUMN_TYPEINFO)
#include <oledb.h>
#undef DBCOLUMN_TYPEINFO
  extern const DBID DBCOLUMN_TYPEINFO;
#endif

#if defined(__polyspace_DBCOLUMN_DOMAINCATALOG) && !defined(__polyspace_no_DBCOLUMN_DOMAINCATALOG)
#include <oledb.h>
#undef DBCOLUMN_DOMAINCATALOG
  extern const DBID DBCOLUMN_DOMAINCATALOG;
#endif

#if defined(__polyspace_DBCOLUMN_DOMAINSCHEMA) && !defined(__polyspace_no_DBCOLUMN_DOMAINSCHEMA)
#include <oledb.h>
#undef DBCOLUMN_DOMAINSCHEMA
  extern const DBID DBCOLUMN_DOMAINSCHEMA;
#endif

#if defined(__polyspace_DBCOLUMN_DATETIMEPRECISION) && !defined(__polyspace_no_DBCOLUMN_DATETIMEPRECISION)
#include <oledb.h>
#undef DBCOLUMN_DATETIMEPRECISION
  extern const DBID DBCOLUMN_DATETIMEPRECISION;
#endif

#if defined(__polyspace_DBCOLUMN_NUMERICPRECISIONRADIX) && !defined(__polyspace_no_DBCOLUMN_NUMERICPRECISIONRADIX)
#include <oledb.h>
#undef DBCOLUMN_NUMERICPRECISIONRADIX
  extern const DBID DBCOLUMN_NUMERICPRECISIONRADIX;
#endif

#if defined(__polyspace_DBCOLUMN_OCTETLENGTH) && !defined(__polyspace_no_DBCOLUMN_OCTETLENGTH)
#include <oledb.h>
#undef DBCOLUMN_OCTETLENGTH
  extern const DBID DBCOLUMN_OCTETLENGTH;
#endif

#if defined(__polyspace_DBCOLUMN_COLUMNSIZE) && !defined(__polyspace_no_DBCOLUMN_COLUMNSIZE)
#include <oledb.h>
#undef DBCOLUMN_COLUMNSIZE
  extern const DBID DBCOLUMN_COLUMNSIZE;
#endif

#if defined(__polyspace_DBCOLUMN_CLSID) && !defined(__polyspace_no_DBCOLUMN_CLSID)
#include <oledb.h>
#undef DBCOLUMN_CLSID
  extern const DBID DBCOLUMN_CLSID;
#endif

#if defined(__polyspace_DBCOLUMN_MAYSORT) && !defined(__polyspace_no_DBCOLUMN_MAYSORT)
#include <oledb.h>
#undef DBCOLUMN_MAYSORT
  extern const DBID DBCOLUMN_MAYSORT;
#endif

#if defined(__polyspace_DBSCHEMA_TABLES_INFO) && !defined(__polyspace_no_DBSCHEMA_TABLES_INFO)
#include <oledb.h>
#undef DBSCHEMA_TABLES_INFO
  extern const GUID DBSCHEMA_TABLES_INFO;
#endif

#if defined(__polyspace_MDGUID_MDX) && !defined(__polyspace_no_MDGUID_MDX)
#include <oledb.h>
#undef MDGUID_MDX
  extern const GUID MDGUID_MDX;
#endif

#if defined(__polyspace_DBGUID_MDX) && !defined(__polyspace_no_DBGUID_MDX)
#include <oledb.h>
#undef DBGUID_MDX
  extern const GUID DBGUID_MDX;
#endif

#if defined(__polyspace_MDSCHEMA_CUBES) && !defined(__polyspace_no_MDSCHEMA_CUBES)
#include <oledb.h>
#undef MDSCHEMA_CUBES
  extern const GUID MDSCHEMA_CUBES;
#endif

#if defined(__polyspace_MDSCHEMA_DIMENSIONS) && !defined(__polyspace_no_MDSCHEMA_DIMENSIONS)
#include <oledb.h>
#undef MDSCHEMA_DIMENSIONS
  extern const GUID MDSCHEMA_DIMENSIONS;
#endif

#if defined(__polyspace_MDSCHEMA_HIERARCHIES) && !defined(__polyspace_no_MDSCHEMA_HIERARCHIES)
#include <oledb.h>
#undef MDSCHEMA_HIERARCHIES
  extern const GUID MDSCHEMA_HIERARCHIES;
#endif

#if defined(__polyspace_MDSCHEMA_LEVELS) && !defined(__polyspace_no_MDSCHEMA_LEVELS)
#include <oledb.h>
#undef MDSCHEMA_LEVELS
  extern const GUID MDSCHEMA_LEVELS;
#endif

#if defined(__polyspace_MDSCHEMA_MEASURES) && !defined(__polyspace_no_MDSCHEMA_MEASURES)
#include <oledb.h>
#undef MDSCHEMA_MEASURES
  extern const GUID MDSCHEMA_MEASURES;
#endif

#if defined(__polyspace_MDSCHEMA_PROPERTIES) && !defined(__polyspace_no_MDSCHEMA_PROPERTIES)
#include <oledb.h>
#undef MDSCHEMA_PROPERTIES
  extern const GUID MDSCHEMA_PROPERTIES;
#endif

#if defined(__polyspace_MDSCHEMA_MEMBERS) && !defined(__polyspace_no_MDSCHEMA_MEMBERS)
#include <oledb.h>
#undef MDSCHEMA_MEMBERS
  extern const GUID MDSCHEMA_MEMBERS;
#endif

#if defined(__polyspace_DBCOLUMN_BASETABLEVERSION) && !defined(__polyspace_no_DBCOLUMN_BASETABLEVERSION)
#include <oledb.h>
#undef DBCOLUMN_BASETABLEVERSION
  extern const DBID DBCOLUMN_BASETABLEVERSION;
#endif

#if defined(__polyspace_DBCOLUMN_KEYCOLUMN) && !defined(__polyspace_no_DBCOLUMN_KEYCOLUMN)
#include <oledb.h>
#undef DBCOLUMN_KEYCOLUMN
  extern const DBID DBCOLUMN_KEYCOLUMN;
#endif

#if defined(__polyspace_DBPROPSET_TRUSTEE) && !defined(__polyspace_no_DBPROPSET_TRUSTEE)
#include <oledb.h>
#undef DBPROPSET_TRUSTEE
  extern const GUID DBPROPSET_TRUSTEE;
#endif

#if defined(__polyspace_DBOBJECT_TABLE) && !defined(__polyspace_no_DBOBJECT_TABLE)
#include <oledb.h>
#undef DBOBJECT_TABLE
  extern const GUID DBOBJECT_TABLE;
#endif

#if defined(__polyspace_DBOBJECT_COLUMN) && !defined(__polyspace_no_DBOBJECT_COLUMN)
#include <oledb.h>
#undef DBOBJECT_COLUMN
  extern const GUID DBOBJECT_COLUMN;
#endif

#if defined(__polyspace_DBOBJECT_DATABASE) && !defined(__polyspace_no_DBOBJECT_DATABASE)
#include <oledb.h>
#undef DBOBJECT_DATABASE
  extern const GUID DBOBJECT_DATABASE;
#endif

#if defined(__polyspace_DBOBJECT_PROCEDURE) && !defined(__polyspace_no_DBOBJECT_PROCEDURE)
#include <oledb.h>
#undef DBOBJECT_PROCEDURE
  extern const GUID DBOBJECT_PROCEDURE;
#endif

#if defined(__polyspace_DBOBJECT_VIEW) && !defined(__polyspace_no_DBOBJECT_VIEW)
#include <oledb.h>
#undef DBOBJECT_VIEW
  extern const GUID DBOBJECT_VIEW;
#endif

#if defined(__polyspace_DBOBJECT_SCHEMA) && !defined(__polyspace_no_DBOBJECT_SCHEMA)
#include <oledb.h>
#undef DBOBJECT_SCHEMA
  extern const GUID DBOBJECT_SCHEMA;
#endif

#if defined(__polyspace_DBOBJECT_DOMAIN) && !defined(__polyspace_no_DBOBJECT_DOMAIN)
#include <oledb.h>
#undef DBOBJECT_DOMAIN
  extern const GUID DBOBJECT_DOMAIN;
#endif

#if defined(__polyspace_DBOBJECT_COLLATION) && !defined(__polyspace_no_DBOBJECT_COLLATION)
#include <oledb.h>
#undef DBOBJECT_COLLATION
  extern const GUID DBOBJECT_COLLATION;
#endif

#if defined(__polyspace_DBOBJECT_TRUSTEE) && !defined(__polyspace_no_DBOBJECT_TRUSTEE)
#include <oledb.h>
#undef DBOBJECT_TRUSTEE
  extern const GUID DBOBJECT_TRUSTEE;
#endif

#if defined(__polyspace_DBOBJECT_SCHEMAROWSET) && !defined(__polyspace_no_DBOBJECT_SCHEMAROWSET)
#include <oledb.h>
#undef DBOBJECT_SCHEMAROWSET
  extern const GUID DBOBJECT_SCHEMAROWSET;
#endif

#if defined(__polyspace_DBOBJECT_CHARACTERSET) && !defined(__polyspace_no_DBOBJECT_CHARACTERSET)
#include <oledb.h>
#undef DBOBJECT_CHARACTERSET
  extern const GUID DBOBJECT_CHARACTERSET;
#endif

#if defined(__polyspace_DBOBJECT_TRANSLATION) && !defined(__polyspace_no_DBOBJECT_TRANSLATION)
#include <oledb.h>
#undef DBOBJECT_TRANSLATION
  extern const GUID DBOBJECT_TRANSLATION;
#endif

#if defined(__polyspace_DB_PROPERTY_CHECK_OPTION) && !defined(__polyspace_no_DB_PROPERTY_CHECK_OPTION)
#include <oledb.h>
#undef DB_PROPERTY_CHECK_OPTION
  extern const GUID DB_PROPERTY_CHECK_OPTION;
#endif

#if defined(__polyspace_DB_PROPERTY_CONSTRAINT_CHECK_DEFERRED) && !defined(__polyspace_no_DB_PROPERTY_CONSTRAINT_CHECK_DEFERRED)
#include <oledb.h>
#undef DB_PROPERTY_CONSTRAINT_CHECK_DEFERRED
  extern const GUID DB_PROPERTY_CONSTRAINT_CHECK_DEFERRED;
#endif

#if defined(__polyspace_DB_PROPERTY_DROP_CASCADE) && !defined(__polyspace_no_DB_PROPERTY_DROP_CASCADE)
#include <oledb.h>
#undef DB_PROPERTY_DROP_CASCADE
  extern const GUID DB_PROPERTY_DROP_CASCADE;
#endif

#if defined(__polyspace_DB_PROPERTY_ON_COMMIT_PRESERVE_ROWS) && !defined(__polyspace_no_DB_PROPERTY_ON_COMMIT_PRESERVE_ROWS)
#include <oledb.h>
#undef DB_PROPERTY_ON_COMMIT_PRESERVE_ROWS
  extern const GUID DB_PROPERTY_ON_COMMIT_PRESERVE_ROWS;
#endif

#if defined(__polyspace_DB_PROPERTY_UNIQUE) && !defined(__polyspace_no_DB_PROPERTY_UNIQUE)
#include <oledb.h>
#undef DB_PROPERTY_UNIQUE
  extern const GUID DB_PROPERTY_UNIQUE;
#endif

#if defined(__polyspace_DB_PROPERTY_PRIMARY) && !defined(__polyspace_no_DB_PROPERTY_PRIMARY)
#include <oledb.h>
#undef DB_PROPERTY_PRIMARY
  extern const GUID DB_PROPERTY_PRIMARY;
#endif

#if defined(__polyspace_DB_PROPERTY_CLUSTERED) && !defined(__polyspace_no_DB_PROPERTY_CLUSTERED)
#include <oledb.h>
#undef DB_PROPERTY_CLUSTERED
  extern const GUID DB_PROPERTY_CLUSTERED;
#endif

#if defined(__polyspace_DB_PROPERTY_NONCLUSTERED) && !defined(__polyspace_no_DB_PROPERTY_NONCLUSTERED)
#include <oledb.h>
#undef DB_PROPERTY_NONCLUSTERED
  extern const GUID DB_PROPERTY_NONCLUSTERED;
#endif

#if defined(__polyspace_DB_PROPERTY_BTREE) && !defined(__polyspace_no_DB_PROPERTY_BTREE)
#include <oledb.h>
#undef DB_PROPERTY_BTREE
  extern const GUID DB_PROPERTY_BTREE;
#endif

#if defined(__polyspace_DB_PROPERTY_HASH) && !defined(__polyspace_no_DB_PROPERTY_HASH)
#include <oledb.h>
#undef DB_PROPERTY_HASH
  extern const GUID DB_PROPERTY_HASH;
#endif

#if defined(__polyspace_DB_PROPERTY_FILLFACTOR) && !defined(__polyspace_no_DB_PROPERTY_FILLFACTOR)
#include <oledb.h>
#undef DB_PROPERTY_FILLFACTOR
  extern const GUID DB_PROPERTY_FILLFACTOR;
#endif

#if defined(__polyspace_DB_PROPERTY_INITIALSIZE) && !defined(__polyspace_no_DB_PROPERTY_INITIALSIZE)
#include <oledb.h>
#undef DB_PROPERTY_INITIALSIZE
  extern const GUID DB_PROPERTY_INITIALSIZE;
#endif

#if defined(__polyspace_DB_PROPERTY_DISALLOWNULL) && !defined(__polyspace_no_DB_PROPERTY_DISALLOWNULL)
#include <oledb.h>
#undef DB_PROPERTY_DISALLOWNULL
  extern const GUID DB_PROPERTY_DISALLOWNULL;
#endif

#if defined(__polyspace_DB_PROPERTY_IGNORENULL) && !defined(__polyspace_no_DB_PROPERTY_IGNORENULL)
#include <oledb.h>
#undef DB_PROPERTY_IGNORENULL
  extern const GUID DB_PROPERTY_IGNORENULL;
#endif

#if defined(__polyspace_DB_PROPERTY_IGNOREANYNULL) && !defined(__polyspace_no_DB_PROPERTY_IGNOREANYNULL)
#include <oledb.h>
#undef DB_PROPERTY_IGNOREANYNULL
  extern const GUID DB_PROPERTY_IGNOREANYNULL;
#endif

#if defined(__polyspace_DB_PROPERTY_SORTBOOKMARKS) && !defined(__polyspace_no_DB_PROPERTY_SORTBOOKMARKS)
#include <oledb.h>
#undef DB_PROPERTY_SORTBOOKMARKS
  extern const GUID DB_PROPERTY_SORTBOOKMARKS;
#endif

#if defined(__polyspace_DB_PROPERTY_AUTOMATICUPDATE) && !defined(__polyspace_no_DB_PROPERTY_AUTOMATICUPDATE)
#include <oledb.h>
#undef DB_PROPERTY_AUTOMATICUPDATE
  extern const GUID DB_PROPERTY_AUTOMATICUPDATE;
#endif

#if defined(__polyspace_DB_PROPERTY_EXPLICITUPDATE) && !defined(__polyspace_no_DB_PROPERTY_EXPLICITUPDATE)
#include <oledb.h>
#undef DB_PROPERTY_EXPLICITUPDATE
  extern const GUID DB_PROPERTY_EXPLICITUPDATE;
#endif

#if defined(__polyspace_DBGUID_LIKE_SQL) && !defined(__polyspace_no_DBGUID_LIKE_SQL)
#include <oledb.h>
#undef DBGUID_LIKE_SQL
  extern const GUID DBGUID_LIKE_SQL;
#endif

#if defined(__polyspace_DBGUID_LIKE_DOS) && !defined(__polyspace_no_DBGUID_LIKE_DOS)
#include <oledb.h>
#undef DBGUID_LIKE_DOS
  extern const GUID DBGUID_LIKE_DOS;
#endif

#if defined(__polyspace_DBGUID_LIKE_OFS) && !defined(__polyspace_no_DBGUID_LIKE_OFS)
#include <oledb.h>
#undef DBGUID_LIKE_OFS
  extern const GUID DBGUID_LIKE_OFS;
#endif

#if defined(__polyspace_DBGUID_LIKE_MAPI) && !defined(__polyspace_no_DBGUID_LIKE_MAPI)
#include <oledb.h>
#undef DBGUID_LIKE_MAPI
  extern const GUID DBGUID_LIKE_MAPI;
#endif

#if defined(__polyspace_DBSCHEMA_CATALOGS) && !defined(__polyspace_no_DBSCHEMA_CATALOGS)
#include <oledb.h>
#undef DBSCHEMA_CATALOGS
  extern const GUID DBSCHEMA_CATALOGS;
#endif

#if defined(__polyspace_DBSCHEMA_CHARACTER_SETS) && !defined(__polyspace_no_DBSCHEMA_CHARACTER_SETS)
#include <oledb.h>
#undef DBSCHEMA_CHARACTER_SETS
  extern const GUID DBSCHEMA_CHARACTER_SETS;
#endif

#if defined(__polyspace_DBSCHEMA_COLLATIONS) && !defined(__polyspace_no_DBSCHEMA_COLLATIONS)
#include <oledb.h>
#undef DBSCHEMA_COLLATIONS
  extern const GUID DBSCHEMA_COLLATIONS;
#endif

#if defined(__polyspace_DBSCHEMA_COLUMNS) && !defined(__polyspace_no_DBSCHEMA_COLUMNS)
#include <oledb.h>
#undef DBSCHEMA_COLUMNS
  extern const GUID DBSCHEMA_COLUMNS;
#endif

#if defined(__polyspace_DBSCHEMA_CHECK_CONSTRAINTS) && !defined(__polyspace_no_DBSCHEMA_CHECK_CONSTRAINTS)
#include <oledb.h>
#undef DBSCHEMA_CHECK_CONSTRAINTS
  extern const GUID DBSCHEMA_CHECK_CONSTRAINTS;
#endif

#if defined(__polyspace_DBSCHEMA_CONSTRAINT_COLUMN_USAGE) && !defined(__polyspace_no_DBSCHEMA_CONSTRAINT_COLUMN_USAGE)
#include <oledb.h>
#undef DBSCHEMA_CONSTRAINT_COLUMN_USAGE
  extern const GUID DBSCHEMA_CONSTRAINT_COLUMN_USAGE;
#endif

#if defined(__polyspace_DBSCHEMA_CONSTRAINT_TABLE_USAGE) && !defined(__polyspace_no_DBSCHEMA_CONSTRAINT_TABLE_USAGE)
#include <oledb.h>
#undef DBSCHEMA_CONSTRAINT_TABLE_USAGE
  extern const GUID DBSCHEMA_CONSTRAINT_TABLE_USAGE;
#endif

#if defined(__polyspace_DBSCHEMA_KEY_COLUMN_USAGE) && !defined(__polyspace_no_DBSCHEMA_KEY_COLUMN_USAGE)
#include <oledb.h>
#undef DBSCHEMA_KEY_COLUMN_USAGE
  extern const GUID DBSCHEMA_KEY_COLUMN_USAGE;
#endif

#if defined(__polyspace_DBSCHEMA_REFERENTIAL_CONSTRAINTS) && !defined(__polyspace_no_DBSCHEMA_REFERENTIAL_CONSTRAINTS)
#include <oledb.h>
#undef DBSCHEMA_REFERENTIAL_CONSTRAINTS
  extern const GUID DBSCHEMA_REFERENTIAL_CONSTRAINTS;
#endif

#if defined(__polyspace_DBSCHEMA_TABLE_CONSTRAINTS) && !defined(__polyspace_no_DBSCHEMA_TABLE_CONSTRAINTS)
#include <oledb.h>
#undef DBSCHEMA_TABLE_CONSTRAINTS
  extern const GUID DBSCHEMA_TABLE_CONSTRAINTS;
#endif

#if defined(__polyspace_DBSCHEMA_COLUMN_DOMAIN_USAGE) && !defined(__polyspace_no_DBSCHEMA_COLUMN_DOMAIN_USAGE)
#include <oledb.h>
#undef DBSCHEMA_COLUMN_DOMAIN_USAGE
  extern const GUID DBSCHEMA_COLUMN_DOMAIN_USAGE;
#endif

#if defined(__polyspace_DBSCHEMA_INDEXES) && !defined(__polyspace_no_DBSCHEMA_INDEXES)
#include <oledb.h>
#undef DBSCHEMA_INDEXES
  extern const GUID DBSCHEMA_INDEXES;
#endif

#if defined(__polyspace_DBSCHEMA_COLUMN_PRIVILEGES) && !defined(__polyspace_no_DBSCHEMA_COLUMN_PRIVILEGES)
#include <oledb.h>
#undef DBSCHEMA_COLUMN_PRIVILEGES
  extern const GUID DBSCHEMA_COLUMN_PRIVILEGES;
#endif

#if defined(__polyspace_DBSCHEMA_TABLE_PRIVILEGES) && !defined(__polyspace_no_DBSCHEMA_TABLE_PRIVILEGES)
#include <oledb.h>
#undef DBSCHEMA_TABLE_PRIVILEGES
  extern const GUID DBSCHEMA_TABLE_PRIVILEGES;
#endif

#if defined(__polyspace_DBSCHEMA_USAGE_PRIVILEGES) && !defined(__polyspace_no_DBSCHEMA_USAGE_PRIVILEGES)
#include <oledb.h>
#undef DBSCHEMA_USAGE_PRIVILEGES
  extern const GUID DBSCHEMA_USAGE_PRIVILEGES;
#endif

#if defined(__polyspace_DBSCHEMA_PROCEDURES) && !defined(__polyspace_no_DBSCHEMA_PROCEDURES)
#include <oledb.h>
#undef DBSCHEMA_PROCEDURES
  extern const GUID DBSCHEMA_PROCEDURES;
#endif

#if defined(__polyspace_DBSCHEMA_SCHEMATA) && !defined(__polyspace_no_DBSCHEMA_SCHEMATA)
#include <oledb.h>
#undef DBSCHEMA_SCHEMATA
  extern const GUID DBSCHEMA_SCHEMATA;
#endif

#if defined(__polyspace_DBSCHEMA_SQL_LANGUAGES) && !defined(__polyspace_no_DBSCHEMA_SQL_LANGUAGES)
#include <oledb.h>
#undef DBSCHEMA_SQL_LANGUAGES
  extern const GUID DBSCHEMA_SQL_LANGUAGES;
#endif

#if defined(__polyspace_DBSCHEMA_STATISTICS) && !defined(__polyspace_no_DBSCHEMA_STATISTICS)
#include <oledb.h>
#undef DBSCHEMA_STATISTICS
  extern const GUID DBSCHEMA_STATISTICS;
#endif

#if defined(__polyspace_DBSCHEMA_TABLES) && !defined(__polyspace_no_DBSCHEMA_TABLES)
#include <oledb.h>
#undef DBSCHEMA_TABLES
  extern const GUID DBSCHEMA_TABLES;
#endif

#if defined(__polyspace_DBSCHEMA_TRANSLATIONS) && !defined(__polyspace_no_DBSCHEMA_TRANSLATIONS)
#include <oledb.h>
#undef DBSCHEMA_TRANSLATIONS
  extern const GUID DBSCHEMA_TRANSLATIONS;
#endif

#if defined(__polyspace_DBSCHEMA_PROVIDER_TYPES) && !defined(__polyspace_no_DBSCHEMA_PROVIDER_TYPES)
#include <oledb.h>
#undef DBSCHEMA_PROVIDER_TYPES
  extern const GUID DBSCHEMA_PROVIDER_TYPES;
#endif

#if defined(__polyspace_DBSCHEMA_VIEWS) && !defined(__polyspace_no_DBSCHEMA_VIEWS)
#include <oledb.h>
#undef DBSCHEMA_VIEWS
  extern const GUID DBSCHEMA_VIEWS;
#endif

#if defined(__polyspace_DBSCHEMA_VIEW_COLUMN_USAGE) && !defined(__polyspace_no_DBSCHEMA_VIEW_COLUMN_USAGE)
#include <oledb.h>
#undef DBSCHEMA_VIEW_COLUMN_USAGE
  extern const GUID DBSCHEMA_VIEW_COLUMN_USAGE;
#endif

#if defined(__polyspace_DBSCHEMA_VIEW_TABLE_USAGE) && !defined(__polyspace_no_DBSCHEMA_VIEW_TABLE_USAGE)
#include <oledb.h>
#undef DBSCHEMA_VIEW_TABLE_USAGE
  extern const GUID DBSCHEMA_VIEW_TABLE_USAGE;
#endif

#if defined(__polyspace_DBSCHEMA_PROCEDURE_PARAMETERS) && !defined(__polyspace_no_DBSCHEMA_PROCEDURE_PARAMETERS)
#include <oledb.h>
#undef DBSCHEMA_PROCEDURE_PARAMETERS
  extern const GUID DBSCHEMA_PROCEDURE_PARAMETERS;
#endif

#if defined(__polyspace_DBSCHEMA_FOREIGN_KEYS) && !defined(__polyspace_no_DBSCHEMA_FOREIGN_KEYS)
#include <oledb.h>
#undef DBSCHEMA_FOREIGN_KEYS
  extern const GUID DBSCHEMA_FOREIGN_KEYS;
#endif

#if defined(__polyspace_DBSCHEMA_PRIMARY_KEYS) && !defined(__polyspace_no_DBSCHEMA_PRIMARY_KEYS)
#include <oledb.h>
#undef DBSCHEMA_PRIMARY_KEYS
  extern const GUID DBSCHEMA_PRIMARY_KEYS;
#endif

#if defined(__polyspace_DBSCHEMA_PROCEDURE_COLUMNS) && !defined(__polyspace_no_DBSCHEMA_PROCEDURE_COLUMNS)
#include <oledb.h>
#undef DBSCHEMA_PROCEDURE_COLUMNS
  extern const GUID DBSCHEMA_PROCEDURE_COLUMNS;
#endif

#if defined(__polyspace_DBCOL_SELFCOLUMNS) && !defined(__polyspace_no_DBCOL_SELFCOLUMNS)
#include <oledb.h>
#undef DBCOL_SELFCOLUMNS
  extern const GUID DBCOL_SELFCOLUMNS;
#endif

#if defined(__polyspace_DBCOL_SPECIALCOL) && !defined(__polyspace_no_DBCOL_SPECIALCOL)
#include <oledb.h>
#undef DBCOL_SPECIALCOL
  extern const GUID DBCOL_SPECIALCOL;
#endif

#if defined(__polyspace_PSGUID_QUERY) && !defined(__polyspace_no_PSGUID_QUERY)
#include <oledb.h>
#undef PSGUID_QUERY
  extern const GUID PSGUID_QUERY;
#endif

#if defined(__polyspace_DBPROPSET_COLUMN) && !defined(__polyspace_no_DBPROPSET_COLUMN)
#include <oledb.h>
#undef DBPROPSET_COLUMN
  extern const GUID DBPROPSET_COLUMN;
#endif

#if defined(__polyspace_DBPROPSET_DATASOURCE) && !defined(__polyspace_no_DBPROPSET_DATASOURCE)
#include <oledb.h>
#undef DBPROPSET_DATASOURCE
  extern const GUID DBPROPSET_DATASOURCE;
#endif

#if defined(__polyspace_DBPROPSET_DATASOURCEINFO) && !defined(__polyspace_no_DBPROPSET_DATASOURCEINFO)
#include <oledb.h>
#undef DBPROPSET_DATASOURCEINFO
  extern const GUID DBPROPSET_DATASOURCEINFO;
#endif

#if defined(__polyspace_DBPROPSET_DBINIT) && !defined(__polyspace_no_DBPROPSET_DBINIT)
#include <oledb.h>
#undef DBPROPSET_DBINIT
  extern const GUID DBPROPSET_DBINIT;
#endif

#if defined(__polyspace_DBPROPSET_INDEX) && !defined(__polyspace_no_DBPROPSET_INDEX)
#include <oledb.h>
#undef DBPROPSET_INDEX
  extern const GUID DBPROPSET_INDEX;
#endif

#if defined(__polyspace_DBPROPSET_ROWSET) && !defined(__polyspace_no_DBPROPSET_ROWSET)
#include <oledb.h>
#undef DBPROPSET_ROWSET
  extern const GUID DBPROPSET_ROWSET;
#endif

#if defined(__polyspace_DBPROPSET_TABLE) && !defined(__polyspace_no_DBPROPSET_TABLE)
#include <oledb.h>
#undef DBPROPSET_TABLE
  extern const GUID DBPROPSET_TABLE;
#endif

#if defined(__polyspace_DBPROPSET_DATASOURCEALL) && !defined(__polyspace_no_DBPROPSET_DATASOURCEALL)
#include <oledb.h>
#undef DBPROPSET_DATASOURCEALL
  extern const GUID DBPROPSET_DATASOURCEALL;
#endif

#if defined(__polyspace_DBPROPSET_DATASOURCEINFOALL) && !defined(__polyspace_no_DBPROPSET_DATASOURCEINFOALL)
#include <oledb.h>
#undef DBPROPSET_DATASOURCEINFOALL
  extern const GUID DBPROPSET_DATASOURCEINFOALL;
#endif

#if defined(__polyspace_DBPROPSET_ROWSETALL) && !defined(__polyspace_no_DBPROPSET_ROWSETALL)
#include <oledb.h>
#undef DBPROPSET_ROWSETALL
  extern const GUID DBPROPSET_ROWSETALL;
#endif

#if defined(__polyspace_DBPROPSET_SESSION) && !defined(__polyspace_no_DBPROPSET_SESSION)
#include <oledb.h>
#undef DBPROPSET_SESSION
  extern const GUID DBPROPSET_SESSION;
#endif

#if defined(__polyspace_DBPROPSET_SESSIONALL) && !defined(__polyspace_no_DBPROPSET_SESSIONALL)
#include <oledb.h>
#undef DBPROPSET_SESSIONALL
  extern const GUID DBPROPSET_SESSIONALL;
#endif

#if defined(__polyspace_DBPROPSET_DBINITALL) && !defined(__polyspace_no_DBPROPSET_DBINITALL)
#include <oledb.h>
#undef DBPROPSET_DBINITALL
  extern const GUID DBPROPSET_DBINITALL;
#endif

#if defined(__polyspace_DBPROPSET_PROPERTIESINERROR) && !defined(__polyspace_no_DBPROPSET_PROPERTIESINERROR)
#include <oledb.h>
#undef DBPROPSET_PROPERTIESINERROR
  extern const GUID DBPROPSET_PROPERTIESINERROR;
#endif

#if defined(__polyspace_DBPROPSET_VIEW) && !defined(__polyspace_no_DBPROPSET_VIEW)
#include <oledb.h>
#undef DBPROPSET_VIEW
  extern const GUID DBPROPSET_VIEW;
#endif

#if defined(__polyspace_DBGUID_DEFAULT) && !defined(__polyspace_no_DBGUID_DEFAULT)
#include <oledb.h>
#undef DBGUID_DEFAULT
  extern const GUID DBGUID_DEFAULT;
#endif

#if defined(__polyspace_DBGUID_SQL) && !defined(__polyspace_no_DBGUID_SQL)
#include <oledb.h>
#undef DBGUID_SQL
  extern const GUID DBGUID_SQL;
#endif

#if defined(__polyspace_DBStructureDefinitions_v0_0_c_ifspec) && !defined(__polyspace_no_DBStructureDefinitions_v0_0_c_ifspec)
#include <oledb.h>
#undef DBStructureDefinitions_v0_0_c_ifspec
  extern RPC_IF_HANDLE DBStructureDefinitions_v0_0_c_ifspec;
#endif

#if defined(__polyspace_DBStructureDefinitions_v0_0_s_ifspec) && !defined(__polyspace_no_DBStructureDefinitions_v0_0_s_ifspec)
#include <oledb.h>
#undef DBStructureDefinitions_v0_0_s_ifspec
  extern RPC_IF_HANDLE DBStructureDefinitions_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0078_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0078_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0078_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0078_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0078_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0078_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0078_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0078_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0087_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0087_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0087_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0087_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0087_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0087_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0087_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0087_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0088_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0088_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0088_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0088_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0088_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0088_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0088_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0088_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0090_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0090_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0090_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0090_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0090_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0090_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0090_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0090_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0091_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0091_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0091_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0091_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0091_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0091_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0091_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0091_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0092_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0092_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0092_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0092_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0092_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0092_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0092_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0092_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0096_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0096_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0096_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0096_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0096_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0096_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0096_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0096_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0098_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0098_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0098_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0098_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0098_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0098_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0098_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0098_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0103_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0103_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0103_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0103_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0103_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0103_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0103_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0103_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0106_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0106_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0106_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0106_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0106_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0106_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0106_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0106_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0107_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0107_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0107_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0107_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0107_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0107_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0107_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0107_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0110_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0110_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0110_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0110_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0110_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0110_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0110_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0110_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0112_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0112_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0112_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0112_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0112_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0112_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0112_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0112_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0113_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0113_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0113_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0113_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0113_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0113_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0113_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0113_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0114_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0114_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0114_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0114_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0114_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0114_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0114_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0114_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0123_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0123_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0123_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0123_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0123_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0123_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0123_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0123_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0125_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0125_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0125_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0125_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0125_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0125_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0125_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0125_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0129_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0129_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0129_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0129_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0129_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0129_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0129_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0129_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0131_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0131_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0131_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0131_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0131_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0131_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0131_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0131_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0132_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0132_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0132_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0132_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0132_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0132_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0132_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0132_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0133_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0133_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0133_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0133_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0133_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0133_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0133_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0133_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0142_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0142_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0142_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0142_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0142_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0142_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0142_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0142_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0156_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0156_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0156_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0156_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0156_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0156_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0156_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0156_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0160_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0160_v0_0_c_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0160_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0160_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oledb_0160_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oledb_0160_v0_0_s_ifspec)
#include <oledb.h>
#undef __MIDL_itf_oledb_0160_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oledb_0160_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oleidl_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oleidl_0000_v0_0_c_ifspec)
#include <oleidl.h>
#undef __MIDL_itf_oleidl_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oleidl_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oleidl_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oleidl_0000_v0_0_s_ifspec)
#include <oleidl.h>
#undef __MIDL_itf_oleidl_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oleidl_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace_IOLETypes_v0_0_c_ifspec) && !defined(__polyspace_no_IOLETypes_v0_0_c_ifspec)
#include <oleidl.h>
#undef IOLETypes_v0_0_c_ifspec
  extern RPC_IF_HANDLE IOLETypes_v0_0_c_ifspec;
#endif

#if defined(__polyspace_IOLETypes_v0_0_s_ifspec) && !defined(__polyspace_no_IOLETypes_v0_0_s_ifspec)
#include <oleidl.h>
#undef IOLETypes_v0_0_s_ifspec
  extern RPC_IF_HANDLE IOLETypes_v0_0_s_ifspec;
#endif

#if defined(__polyspace_g_dwObjectCount) && !defined(__polyspace_no_g_dwObjectCount)
#include <olestd.h>
#undef g_dwObjectCount
  extern DWORD g_dwObjectCount;
#endif

#if defined(__polyspace___MIDL_itf_oletx2xa_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oletx2xa_0000_v0_0_c_ifspec)
#include <oletx2xa.h>
#undef __MIDL_itf_oletx2xa_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oletx2xa_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oletx2xa_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oletx2xa_0000_v0_0_s_ifspec)
#include <oletx2xa.h>
#undef __MIDL_itf_oletx2xa_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oletx2xa_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace_XaMapperTypes_v0_0_c_ifspec) && !defined(__polyspace_no_XaMapperTypes_v0_0_c_ifspec)
#include <oletx2xa.h>
#undef XaMapperTypes_v0_0_c_ifspec
  extern RPC_IF_HANDLE XaMapperTypes_v0_0_c_ifspec;
#endif

#if defined(__polyspace_XaMapperTypes_v0_0_s_ifspec) && !defined(__polyspace_no_XaMapperTypes_v0_0_s_ifspec)
#include <oletx2xa.h>
#undef XaMapperTypes_v0_0_s_ifspec
  extern RPC_IF_HANDLE XaMapperTypes_v0_0_s_ifspec;
#endif

#if defined(__polyspace_XaMapperAPIs_v0_0_c_ifspec) && !defined(__polyspace_no_XaMapperAPIs_v0_0_c_ifspec)
#include <oletx2xa.h>
#undef XaMapperAPIs_v0_0_c_ifspec
  extern RPC_IF_HANDLE XaMapperAPIs_v0_0_c_ifspec;
#endif

#if defined(__polyspace_XaMapperAPIs_v0_0_s_ifspec) && !defined(__polyspace_no_XaMapperAPIs_v0_0_s_ifspec)
#include <oletx2xa.h>
#undef XaMapperAPIs_v0_0_s_ifspec
  extern RPC_IF_HANDLE XaMapperAPIs_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oletx2xa_0018_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_oletx2xa_0018_v0_0_c_ifspec)
#include <oletx2xa.h>
#undef __MIDL_itf_oletx2xa_0018_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oletx2xa_0018_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_oletx2xa_0018_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_oletx2xa_0018_v0_0_s_ifspec)
#include <oletx2xa.h>
#undef __MIDL_itf_oletx2xa_0018_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_oletx2xa_0018_v0_0_s_ifspec;
#endif

#if defined(__polyspace_cout) && !defined(__polyspace_no_cout)
#include <ostream.h>
#undef cout
  extern ostream_withassign _CRTIMP cout;
#endif

#if defined(__polyspace_cerr) && !defined(__polyspace_no_cerr)
#include <ostream.h>
#undef cerr
  extern ostream_withassign _CRTIMP cerr;
#endif

#if defined(__polyspace_clog) && !defined(__polyspace_no_clog)
#include <ostream.h>
#undef clog
  extern ostream_withassign _CRTIMP clog;
#endif

#if defined(__polyspace_HexTable) && !defined(__polyspace_no_HexTable)
#include <parser.h>
#undef HexTable
  extern BYTE HexTable[];
#endif

#if defined(__polyspace___MIDL_itf_perhist_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_perhist_0000_v0_0_c_ifspec)
#include <perhist.h>
#undef __MIDL_itf_perhist_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_perhist_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_perhist_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_perhist_0000_v0_0_s_ifspec)
#include <perhist.h>
#undef __MIDL_itf_perhist_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_perhist_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_perhist_0099_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_perhist_0099_v0_0_c_ifspec)
#include <perhist.h>
#undef __MIDL_itf_perhist_0099_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_perhist_0099_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_perhist_0099_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_perhist_0099_v0_0_s_ifspec)
#include <perhist.h>
#undef __MIDL_itf_perhist_0099_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_perhist_0099_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_playlist_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_playlist_0000_v0_0_c_ifspec)
#include <playlist.h>
#undef __MIDL_itf_playlist_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_playlist_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_playlist_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_playlist_0000_v0_0_s_ifspec)
#include <playlist.h>
#undef __MIDL_itf_playlist_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_playlist_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_playlist_0227_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_playlist_0227_v0_0_c_ifspec)
#include <playlist.h>
#undef __MIDL_itf_playlist_0227_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_playlist_0227_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_playlist_0227_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_playlist_0227_v0_0_s_ifspec)
#include <playlist.h>
#undef __MIDL_itf_playlist_0227_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_playlist_0227_v0_0_s_ifspec;
#endif

#if defined(__polyspace__p_overlay) && !defined(__polyspace_no__p_overlay)
#include <process.h>
#undef _p_overlay
  extern int _p_overlay;
#endif

#if defined(__polyspace___MIDL_itf_propbag2_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_propbag2_0000_v0_0_c_ifspec)
#include <propbag2.h>
#undef __MIDL_itf_propbag2_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_propbag2_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_propbag2_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_propbag2_0000_v0_0_s_ifspec)
#include <propbag2.h>
#undef __MIDL_itf_propbag2_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_propbag2_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_propbag2_0141_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_propbag2_0141_v0_0_c_ifspec)
#include <propbag2.h>
#undef __MIDL_itf_propbag2_0141_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_propbag2_0141_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_propbag2_0141_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_propbag2_0141_v0_0_s_ifspec)
#include <propbag2.h>
#undef __MIDL_itf_propbag2_0141_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_propbag2_0141_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_rndnot_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_rndnot_0000_v0_0_c_ifspec)
#include <rndnot.h>
#undef __MIDL_itf_rndnot_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_rndnot_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_rndnot_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_rndnot_0000_v0_0_s_ifspec)
#include <rndnot.h>
#undef __MIDL_itf_rndnot_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_rndnot_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace_TriggerBackupRPC_ClientIfHandle) && !defined(__polyspace_no_TriggerBackupRPC_ClientIfHandle)
#include <rpcbak.h>
#undef TriggerBackupRPC_ClientIfHandle
  extern RPC_IF_HANDLE TriggerBackupRPC_ClientIfHandle;
#endif

#if defined(__polyspace_TriggerBackupRPC_ServerIfHandle) && !defined(__polyspace_no_TriggerBackupRPC_ServerIfHandle)
#include <rpcbak.h>
#undef TriggerBackupRPC_ServerIfHandle
  extern RPC_IF_HANDLE TriggerBackupRPC_ServerIfHandle;
#endif

#if defined(__polyspace_TriggerPrivateRPC_ClientIfHandle) && !defined(__polyspace_no_TriggerPrivateRPC_ClientIfHandle)
#include <rpcpri.h>
#undef TriggerPrivateRPC_ClientIfHandle
  extern RPC_IF_HANDLE TriggerPrivateRPC_ClientIfHandle;
#endif

#if defined(__polyspace_TriggerPrivateRPC_ServerIfHandle) && !defined(__polyspace_no_TriggerPrivateRPC_ServerIfHandle)
#include <rpcpri.h>
#undef TriggerPrivateRPC_ServerIfHandle
  extern RPC_IF_HANDLE TriggerPrivateRPC_ServerIfHandle;
#endif

#if defined(__polyspace_TriggerPublicRPC_ClientIfHandle) && !defined(__polyspace_no_TriggerPublicRPC_ClientIfHandle)
#include <rpcpub.h>
#undef TriggerPublicRPC_ClientIfHandle
  extern RPC_IF_HANDLE TriggerPublicRPC_ClientIfHandle;
#endif

#if defined(__polyspace_TriggerPublicRPC_ServerIfHandle) && !defined(__polyspace_no_TriggerPublicRPC_ServerIfHandle)
#include <rpcpub.h>
#undef TriggerPublicRPC_ServerIfHandle
  extern RPC_IF_HANDLE TriggerPublicRPC_ServerIfHandle;
#endif

#if defined(__polyspace___MIDL__intf_0001_ClientIfHandle) && !defined(__polyspace_no___MIDL__intf_0001_ClientIfHandle)
#include <rpcpub.h>
#undef __MIDL__intf_0001_ClientIfHandle
  extern RPC_IF_HANDLE __MIDL__intf_0001_ClientIfHandle;
#endif

#if defined(__polyspace___MIDL__intf_0001_ServerIfHandle) && !defined(__polyspace_no___MIDL__intf_0001_ServerIfHandle)
#include <rpcpub.h>
#undef __MIDL__intf_0001_ServerIfHandle
  extern RPC_IF_HANDLE __MIDL__intf_0001_ServerIfHandle;
#endif

#if defined(__polyspace_rgdwCRC) && !defined(__polyspace_no_rgdwCRC)
#include <rtflib.h>
#undef rgdwCRC
  extern const DWORD rgdwCRC[];
#endif

#if defined(__polyspace_hMainInstance) && !defined(__polyspace_no_hMainInstance)
#include <scrnsave.h>
#undef hMainInstance
  extern HINSTANCE hMainInstance;
#endif

#if defined(__polyspace_hMainWindow) && !defined(__polyspace_no_hMainWindow)
#include <scrnsave.h>
#undef hMainWindow
  extern HWND hMainWindow;
#endif

#if defined(__polyspace_fChildPreview) && !defined(__polyspace_no_fChildPreview)
#include <scrnsave.h>
#undef fChildPreview
  extern BOOL fChildPreview;
#endif

#if defined(__polyspace_szName) && !defined(__polyspace_no_szName)
#include <scrnsave.h>
#undef szName
  extern TCHAR szName[TITLEBARNAMELEN];
#endif

#if defined(__polyspace_szAppName) && !defined(__polyspace_no_szAppName)
#include <scrnsave.h>
#undef szAppName
  extern TCHAR szAppName[APPNAMEBUFFERLEN];
#endif

#if defined(__polyspace_szIniFile) && !defined(__polyspace_no_szIniFile)
#include <scrnsave.h>
#undef szIniFile
  extern TCHAR szIniFile[MAXFILELEN];
#endif

#if defined(__polyspace_szScreenSaver) && !defined(__polyspace_no_szScreenSaver)
#include <scrnsave.h>
#undef szScreenSaver
  extern TCHAR szScreenSaver[22];
#endif

#if defined(__polyspace_szHelpFile) && !defined(__polyspace_no_szHelpFile)
#include <scrnsave.h>
#undef szHelpFile
  extern TCHAR szHelpFile[MAXFILELEN];
#endif

#if defined(__polyspace_szNoHelpMemory) && !defined(__polyspace_no_szNoHelpMemory)
#include <scrnsave.h>
#undef szNoHelpMemory
  extern TCHAR szNoHelpMemory[BUFFLEN];
#endif

#if defined(__polyspace_MyHelpMessage) && !defined(__polyspace_no_MyHelpMessage)
#include <scrnsave.h>
#undef MyHelpMessage
  extern UINT MyHelpMessage;
#endif

#if defined(__polyspace_KspKernelFunctions) && !defined(__polyspace_no_KspKernelFunctions)
#include <secpkg.h>
#undef KspKernelFunctions
  extern SECPKG_KERNEL_FUNCTIONS KspKernelFunctions;
#endif

#if defined(__polyspace___MIDL_itf_servprov_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_servprov_0000_v0_0_c_ifspec)
#include <servprov.h>
#undef __MIDL_itf_servprov_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_servprov_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_servprov_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_servprov_0000_v0_0_s_ifspec)
#include <servprov.h>
#undef __MIDL_itf_servprov_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_servprov_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_servprov_0074_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_servprov_0074_v0_0_c_ifspec)
#include <servprov.h>
#undef __MIDL_itf_servprov_0074_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_servprov_0074_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_servprov_0074_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_servprov_0074_v0_0_s_ifspec)
#include <servprov.h>
#undef __MIDL_itf_servprov_0074_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_servprov_0074_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_simpdata_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_simpdata_0000_v0_0_c_ifspec)
#include <simpdata.h>
#undef __MIDL_itf_simpdata_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_simpdata_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_simpdata_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_simpdata_0000_v0_0_s_ifspec)
#include <simpdata.h>
#undef __MIDL_itf_simpdata_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_simpdata_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_simpdata_0122_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_simpdata_0122_v0_0_c_ifspec)
#include <simpdata.h>
#undef __MIDL_itf_simpdata_0122_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_simpdata_0122_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_simpdata_0122_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_simpdata_0122_v0_0_s_ifspec)
#include <simpdata.h>
#undef __MIDL_itf_simpdata_0122_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_simpdata_0122_v0_0_s_ifspec;
#endif

#if defined(__polyspace_SrvPrecToLen) && !defined(__polyspace_no_SrvPrecToLen)
#include <srvconst.h>
#undef SrvPrecToLen
  extern unsigned char SrvPrecToLen[];
#endif

#if defined(__polyspace_SrvLenToPrec) && !defined(__polyspace_no_SrvLenToPrec)
#include <srvconst.h>
#undef SrvLenToPrec
  extern unsigned char SrvLenToPrec[];
#endif

#if defined(__polyspace___MIDL_itf_strmif_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0000_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0000_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0056_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0056_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0056_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0056_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0056_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0056_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0056_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0056_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0057_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0057_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0057_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0057_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0057_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0057_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0057_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0057_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0058_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0058_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0058_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0058_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0058_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0058_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0058_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0058_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0059_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0059_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0059_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0059_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0059_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0059_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0059_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0059_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0060_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0060_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0060_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0060_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0060_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0060_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0060_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0060_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0061_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0061_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0061_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0061_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0061_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0061_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0061_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0061_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0062_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0062_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0062_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0062_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0062_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0062_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0062_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0062_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0063_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0063_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0063_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0063_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0063_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0063_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0063_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0063_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0064_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0064_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0064_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0064_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0064_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0064_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0064_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0064_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0065_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0065_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0065_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0065_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0065_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0065_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0065_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0065_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0066_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0066_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0066_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0066_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0066_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0066_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0066_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0066_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0067_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0067_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0067_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0067_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0067_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0067_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0067_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0067_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0068_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0068_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0068_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0068_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0068_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0068_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0068_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0068_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0069_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0069_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0069_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0069_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0069_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0069_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0069_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0069_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0070_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0070_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0070_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0070_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0070_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0070_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0070_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0070_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0072_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0072_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0072_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0072_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0072_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0072_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0072_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0072_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0074_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0074_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0074_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0074_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0074_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0074_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0074_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0074_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0076_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0076_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0076_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0076_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0076_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0076_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0076_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0076_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0077_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0077_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0077_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0077_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0077_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0077_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0077_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0077_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0078_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0078_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0078_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0078_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0078_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0078_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0078_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0078_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0079_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0079_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0079_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0079_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0079_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0079_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0079_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0079_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0080_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0080_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0080_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0080_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0080_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0080_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0080_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0080_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0081_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0081_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0081_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0081_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0081_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0081_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0081_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0081_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0082_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0082_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0082_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0082_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0082_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0082_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0082_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0082_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0083_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0083_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0083_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0083_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0083_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0083_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0083_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0083_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0084_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0084_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0084_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0084_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0084_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0084_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0084_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0084_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0087_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0087_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0087_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0087_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0087_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0087_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0087_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0087_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0094_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0094_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0094_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0094_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0094_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0094_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0094_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0094_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0101_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0101_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0101_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0101_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0101_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0101_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0101_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0101_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0102_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0102_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0102_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0102_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0102_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0102_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0102_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0102_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0105_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0105_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0105_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0105_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0105_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0105_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0105_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0105_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0107_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0107_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0107_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0107_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0107_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0107_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0107_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0107_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0108_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0108_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0108_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0108_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0108_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0108_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0108_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0108_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0109_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0109_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0109_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0109_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0109_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0109_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0109_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0109_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0111_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0111_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0111_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0111_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0111_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0111_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0111_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0111_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0115_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0115_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0115_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0115_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0115_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0115_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0115_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0115_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0118_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0118_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0118_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0118_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0118_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0118_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0118_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0118_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0119_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0119_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0119_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0119_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0119_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0119_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0119_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0119_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0206_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0206_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0206_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0206_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0206_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0206_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0206_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0206_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0207_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0207_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0207_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0207_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0207_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0207_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0207_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0207_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0208_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0208_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0208_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0208_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0208_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0208_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0208_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0208_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0209_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0209_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0209_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0209_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0209_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0209_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0209_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0209_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0210_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0210_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0210_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0210_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0210_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0210_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0210_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0210_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0211_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0211_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0211_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0211_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0211_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0211_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0211_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0211_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0212_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0212_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0212_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0212_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0212_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0212_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0212_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0212_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0213_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0213_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0213_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0213_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0213_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0213_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0213_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0213_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0214_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0214_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0214_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0214_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0214_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0214_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0214_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0214_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0215_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0215_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0215_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0215_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0215_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0215_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0215_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0215_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0217_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0217_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0217_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0217_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0217_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0217_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0217_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0217_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0223_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0223_v0_0_c_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0223_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0223_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_strmif_0223_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_strmif_0223_v0_0_s_ifspec)
#include <strmif.h>
#undef __MIDL_itf_strmif_0223_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_strmif_0223_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_subsmgr_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_subsmgr_0000_v0_0_c_ifspec)
#include <subsmgr.h>
#undef __MIDL_itf_subsmgr_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_subsmgr_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_subsmgr_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_subsmgr_0000_v0_0_s_ifspec)
#include <subsmgr.h>
#undef __MIDL_itf_subsmgr_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_subsmgr_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_subsmgr_0073_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_subsmgr_0073_v0_0_c_ifspec)
#include <subsmgr.h>
#undef __MIDL_itf_subsmgr_0073_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_subsmgr_0073_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_subsmgr_0073_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_subsmgr_0073_v0_0_s_ifspec)
#include <subsmgr.h>
#undef __MIDL_itf_subsmgr_0073_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_subsmgr_0073_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_tapi3_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_tapi3_0000_v0_0_c_ifspec)
#include <tapi3.h>
#undef __MIDL_itf_tapi3_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_tapi3_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_tapi3_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_tapi3_0000_v0_0_s_ifspec)
#include <tapi3.h>
#undef __MIDL_itf_tapi3_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_tapi3_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_tapi3_0331_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_tapi3_0331_v0_0_c_ifspec)
#include <tapi3.h>
#undef __MIDL_itf_tapi3_0331_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_tapi3_0331_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_tapi3_0331_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_tapi3_0331_v0_0_s_ifspec)
#include <tapi3.h>
#undef __MIDL_itf_tapi3_0331_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_tapi3_0331_v0_0_s_ifspec;
#endif

#if defined(__polyspace_crit_comlog) && !defined(__polyspace_no_crit_comlog)
#include <trace.h>
#undef crit_comlog
  extern CSCRITSEC crit_comlog;
#endif

#if defined(__polyspace_crit_dlbtrc) && !defined(__polyspace_no_crit_dlbtrc)
#include <trace.h>
#undef crit_dlbtrc
  extern CSCRITSEC crit_dlbtrc;
#endif

#if defined(__polyspace_crit_dlblog) && !defined(__polyspace_no_crit_dlblog)
#include <trace.h>
#undef crit_dlblog
  extern CSCRITSEC crit_dlblog;
#endif

#if defined(__polyspace_com_str) && !defined(__polyspace_no_com_str)
#include <trace.h>
#undef com_str
  extern UCHAR com_str[256];
#endif

#if defined(__polyspace_com_logstr) && !defined(__polyspace_no_com_logstr)
#include <trace.h>
#undef com_logstr
  extern UCHAR com_logstr[256];
#endif

#if defined(__polyspace_com_trcsem) && !defined(__polyspace_no_com_trcsem)
#include <trace.h>
#undef com_trcsem
  extern ULONG pascal com_trcsem;
#endif

#if defined(__polyspace_com_logsem) && !defined(__polyspace_no_com_logsem)
#include <trace.h>
#undef com_logsem
  extern ULONG pascal com_logsem;
#endif

#if defined(__polyspace_dlb_logsem) && !defined(__polyspace_no_dlb_logsem)
#include <trace.h>
#undef dlb_logsem
  extern ULONG pascal dlb_logsem;
#endif

#if defined(__polyspace_dlb_trcsem) && !defined(__polyspace_no_dlb_trcsem)
#include <trace.h>
#undef dlb_trcsem
  extern ULONG pascal dlb_trcsem;
#endif

#if defined(__polyspace_ptrc) && !defined(__polyspace_no_ptrc)
#include <trace.h>
#undef ptrc
  extern TRC FAR * pascal ptrc;
#endif

#if defined(__polyspace___MIDL_itf_transact_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_transact_0000_v0_0_c_ifspec)
#include <transact.h>
#undef __MIDL_itf_transact_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_transact_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_transact_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_transact_0000_v0_0_s_ifspec)
#include <transact.h>
#undef __MIDL_itf_transact_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_transact_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace_BasicTransactionTypes_v0_0_c_ifspec) && !defined(__polyspace_no_BasicTransactionTypes_v0_0_c_ifspec)
#include <transact.h>
#undef BasicTransactionTypes_v0_0_c_ifspec
  extern RPC_IF_HANDLE BasicTransactionTypes_v0_0_c_ifspec;
#endif

#if defined(__polyspace_BasicTransactionTypes_v0_0_s_ifspec) && !defined(__polyspace_no_BasicTransactionTypes_v0_0_s_ifspec)
#include <transact.h>
#undef BasicTransactionTypes_v0_0_s_ifspec
  extern RPC_IF_HANDLE BasicTransactionTypes_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_transact_0010_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_transact_0010_v0_0_c_ifspec)
#include <transact.h>
#undef __MIDL_itf_transact_0010_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_transact_0010_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_transact_0010_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_transact_0010_v0_0_s_ifspec)
#include <transact.h>
#undef __MIDL_itf_transact_0010_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_transact_0010_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_trkcom_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_trkcom_0000_v0_0_c_ifspec)
#include <trkcom.h>
#undef __MIDL_itf_trkcom_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_trkcom_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace_Stub__MIDL_itf_trkcom_0000_v0_0_s_ifspec) && !defined(__polyspace_no_Stub__MIDL_itf_trkcom_0000_v0_0_s_ifspec)
#include <trkcom.h>
#undef Stub__MIDL_itf_trkcom_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE Stub__MIDL_itf_trkcom_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace_g_strRestrictSuffix) && !defined(__polyspace_no_g_strRestrictSuffix)
#include <tssutil.h>
#undef g_strRestrictSuffix
  extern const LPCTSTR g_strRestrictSuffix;
#endif

#if defined(__polyspace_g_strAdultsGrp) && !defined(__polyspace_no_g_strAdultsGrp)
#include <tssutil.h>
#undef g_strAdultsGrp
  extern const LPCTSTR g_strAdultsGrp;
#endif

#if defined(__polyspace_g_strUsersGrp) && !defined(__polyspace_no_g_strUsersGrp)
#include <tssutil.h>
#undef g_strUsersGrp
  extern const LPCTSTR g_strUsersGrp;
#endif

#if defined(__polyspace_g_strGuestAccountName) && !defined(__polyspace_no_g_strGuestAccountName)
#include <tssutil.h>
#undef g_strGuestAccountName
  extern const LPCTSTR g_strGuestAccountName;
#endif

#if defined(__polyspace_g_strRestrictQueryOwner) && !defined(__polyspace_no_g_strRestrictQueryOwner)
#include <tssutil.h>
#undef g_strRestrictQueryOwner
  extern const LPCTSTR g_strRestrictQueryOwner;
#endif

#if defined(__polyspace_g_strRestrictQueryBase) && !defined(__polyspace_no_g_strRestrictQueryBase)
#include <tssutil.h>
#undef g_strRestrictQueryBase
  extern const LPCTSTR g_strRestrictQueryBase;
#endif

#if defined(__polyspace_g_strQueryBase) && !defined(__polyspace_no_g_strQueryBase)
#include <tssutil.h>
#undef g_strQueryBase
  extern const LPCTSTR g_strQueryBase;
#endif

#if defined(__polyspace___MIDL_itf_txcoord_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_txcoord_0000_v0_0_c_ifspec)
#include <txcoord.h>
#undef __MIDL_itf_txcoord_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_txcoord_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_txcoord_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_txcoord_0000_v0_0_s_ifspec)
#include <txcoord.h>
#undef __MIDL_itf_txcoord_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_txcoord_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_txcoord_0088_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_txcoord_0088_v0_0_c_ifspec)
#include <txcoord.h>
#undef __MIDL_itf_txcoord_0088_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_txcoord_0088_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_txcoord_0088_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_txcoord_0088_v0_0_s_ifspec)
#include <txcoord.h>
#undef __MIDL_itf_txcoord_0088_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_txcoord_0088_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_txctx_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_txctx_0000_v0_0_c_ifspec)
#include <txctx.h>
#undef __MIDL_itf_txctx_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_txctx_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_txctx_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_txctx_0000_v0_0_s_ifspec)
#include <txctx.h>
#undef __MIDL_itf_txctx_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_txctx_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_txdtc_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_txdtc_0000_v0_0_c_ifspec)
#include <txdtc.h>
#undef __MIDL_itf_txdtc_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_txdtc_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_txdtc_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_txdtc_0000_v0_0_s_ifspec)
#include <txdtc.h>
#undef __MIDL_itf_txdtc_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_txdtc_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_txdtc_0108_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_txdtc_0108_v0_0_c_ifspec)
#include <txdtc.h>
#undef __MIDL_itf_txdtc_0108_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_txdtc_0108_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_txdtc_0108_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_txdtc_0108_v0_0_s_ifspec)
#include <txdtc.h>
#undef __MIDL_itf_txdtc_0108_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_txdtc_0108_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_txdtc_0111_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_txdtc_0111_v0_0_c_ifspec)
#include <txdtc.h>
#undef __MIDL_itf_txdtc_0111_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_txdtc_0111_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_txdtc_0111_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_txdtc_0111_v0_0_s_ifspec)
#include <txdtc.h>
#undef __MIDL_itf_txdtc_0111_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_txdtc_0111_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_txdtc_0122_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_txdtc_0122_v0_0_c_ifspec)
#include <txdtc.h>
#undef __MIDL_itf_txdtc_0122_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_txdtc_0122_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_txdtc_0122_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_txdtc_0122_v0_0_s_ifspec)
#include <txdtc.h>
#undef __MIDL_itf_txdtc_0122_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_txdtc_0122_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_unknwn_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_unknwn_0000_v0_0_c_ifspec)
#include <unknwn.h>
#undef __MIDL_itf_unknwn_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_unknwn_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_unknwn_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_unknwn_0000_v0_0_s_ifspec)
#include <unknwn.h>
#undef __MIDL_itf_unknwn_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_unknwn_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlhist_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlhist_0000_v0_0_c_ifspec)
#include <urlhist.h>
#undef __MIDL_itf_urlhist_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlhist_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlhist_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlhist_0000_v0_0_s_ifspec)
#include <urlhist.h>
#undef __MIDL_itf_urlhist_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlhist_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlhist_0226_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlhist_0226_v0_0_c_ifspec)
#include <urlhist.h>
#undef __MIDL_itf_urlhist_0226_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlhist_0226_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlhist_0226_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlhist_0226_v0_0_s_ifspec)
#include <urlhist.h>
#undef __MIDL_itf_urlhist_0226_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlhist_0226_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlhist_0227_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlhist_0227_v0_0_c_ifspec)
#include <urlhist.h>
#undef __MIDL_itf_urlhist_0227_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlhist_0227_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlhist_0227_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlhist_0227_v0_0_s_ifspec)
#include <urlhist.h>
#undef __MIDL_itf_urlhist_0227_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlhist_0227_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlhist_0228_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlhist_0228_v0_0_c_ifspec)
#include <urlhist.h>
#undef __MIDL_itf_urlhist_0228_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlhist_0228_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlhist_0228_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlhist_0228_v0_0_s_ifspec)
#include <urlhist.h>
#undef __MIDL_itf_urlhist_0228_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlhist_0228_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlhist_0229_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlhist_0229_v0_0_c_ifspec)
#include <urlhist.h>
#undef __MIDL_itf_urlhist_0229_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlhist_0229_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlhist_0229_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlhist_0229_v0_0_s_ifspec)
#include <urlhist.h>
#undef __MIDL_itf_urlhist_0229_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlhist_0229_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0000_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0000_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0111_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0111_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0111_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0111_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0111_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0111_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0111_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0111_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0112_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0112_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0112_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0112_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0112_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0112_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0112_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0112_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0113_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0113_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0113_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0113_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0113_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0113_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0113_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0113_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0114_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0114_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0114_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0114_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0114_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0114_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0114_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0114_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0115_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0115_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0115_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0115_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0115_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0115_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0115_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0115_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0116_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0116_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0116_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0116_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0116_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0116_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0116_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0116_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0117_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0117_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0117_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0117_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0117_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0117_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0117_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0117_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0118_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0118_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0118_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0118_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0118_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0118_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0118_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0118_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0119_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0119_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0119_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0119_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0119_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0119_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0119_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0119_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0120_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0120_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0120_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0120_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0120_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0120_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0120_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0120_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0121_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0121_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0121_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0121_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0121_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0121_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0121_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0121_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0122_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0122_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0122_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0122_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0122_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0122_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0122_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0122_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0123_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0123_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0123_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0123_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0123_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0123_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0123_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0123_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0124_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0124_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0124_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0124_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0124_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0124_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0124_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0124_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0125_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0125_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0125_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0125_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0125_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0125_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0125_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0125_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0126_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0126_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0126_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0126_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0126_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0126_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0126_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0126_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0127_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0127_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0127_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0127_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0127_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0127_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0127_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0127_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0128_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0128_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0128_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0128_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0128_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0128_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0128_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0128_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0129_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0129_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0129_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0129_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0129_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0129_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0129_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0129_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0130_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0130_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0130_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0130_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0130_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0130_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0130_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0130_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0131_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0131_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0131_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0131_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0131_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0131_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0131_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0131_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0132_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0132_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0132_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0132_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0132_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0132_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0132_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0132_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0133_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0133_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0133_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0133_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0133_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0133_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0133_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0133_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0134_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0134_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0134_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0134_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0134_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0134_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0134_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0134_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0135_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0135_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0135_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0135_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0135_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0135_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0135_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0135_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0136_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0136_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0136_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0136_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0136_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0136_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0136_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0136_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0137_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0137_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0137_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0137_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0137_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0137_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0137_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0137_v0_0_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0138_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0138_v0_0_c_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0138_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0138_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_urlmon_0138_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_urlmon_0138_v0_0_s_ifspec)
#include <urlmon.h>
#undef __MIDL_itf_urlmon_0138_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_urlmon_0138_v0_0_s_ifspec;
#endif

#if defined(__polyspace_ExtensionApis) && !defined(__polyspace_no_ExtensionApis)
#include <wdbgexts.h>
#undef ExtensionApis
  extern WINDBG_EXTENSION_APIS ExtensionApis;
#endif

#if defined(__polyspace_g_rgSCardT0Pci) && !defined(__polyspace_no_g_rgSCardT0Pci)
#include <winscard.h>
#undef g_rgSCardT0Pci
  extern const SCARD_IO_REQUEST  g_rgSCardT0Pci;
#endif

#if defined(__polyspace_g_rgSCardT1Pci) && !defined(__polyspace_no_g_rgSCardT1Pci)
#include <winscard.h>
#undef g_rgSCardT1Pci
  extern const SCARD_IO_REQUEST   g_rgSCardT1Pci;
#endif

#if defined(__polyspace_g_rgSCardRawPci) && !defined(__polyspace_no_g_rgSCardRawPci)
#include <winscard.h>
#undef g_rgSCardRawPci
  extern const SCARD_IO_REQUEST   g_rgSCardRawPci;
#endif

#if defined(__polyspace_szWindowTitle) && !defined(__polyspace_no_szWindowTitle)
#include <winwrap.h>
#undef szWindowTitle
  extern CHAR szWindowTitle[];
#endif

#if defined(__polyspace___MIDL_itf_wtypes_0000_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_wtypes_0000_v0_0_c_ifspec)
#include <wtypes.h>
#undef __MIDL_itf_wtypes_0000_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_wtypes_0000_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_wtypes_0000_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_wtypes_0000_v0_0_s_ifspec)
#include <wtypes.h>
#undef __MIDL_itf_wtypes_0000_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_wtypes_0000_v0_0_s_ifspec;
#endif

#if defined(__polyspace_IWinTypes_v0_1_c_ifspec) && !defined(__polyspace_no_IWinTypes_v0_1_c_ifspec)
#include <wtypes.h>
#undef IWinTypes_v0_1_c_ifspec
  extern RPC_IF_HANDLE IWinTypes_v0_1_c_ifspec;
#endif

#if defined(__polyspace_IWinTypes_v0_1_s_ifspec) && !defined(__polyspace_no_IWinTypes_v0_1_s_ifspec)
#include <wtypes.h>
#undef IWinTypes_v0_1_s_ifspec
  extern RPC_IF_HANDLE IWinTypes_v0_1_s_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_wtypes_0001_v0_0_c_ifspec) && !defined(__polyspace_no___MIDL_itf_wtypes_0001_v0_0_c_ifspec)
#include <wtypes.h>
#undef __MIDL_itf_wtypes_0001_v0_0_c_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_wtypes_0001_v0_0_c_ifspec;
#endif

#if defined(__polyspace___MIDL_itf_wtypes_0001_v0_0_s_ifspec) && !defined(__polyspace_no___MIDL_itf_wtypes_0001_v0_0_s_ifspec)
#include <wtypes.h>
#undef __MIDL_itf_wtypes_0001_v0_0_s_ifspec
  extern RPC_IF_HANDLE __MIDL_itf_wtypes_0001_v0_0_s_ifspec;
#endif

#if defined(__polyspace__Denorm) && !defined(__polyspace_no__Denorm)
#include <ymath.h>
#undef _Denorm
  extern _CRTIMP const _Dconst _Denorm;
#endif

#if defined(__polyspace__Hugeval) && !defined(__polyspace_no__Hugeval)
#include <ymath.h>
#undef _Hugeval
  extern _CRTIMP const _Dconst _Hugeval;
#endif

#if defined(__polyspace__Inf) && !defined(__polyspace_no__Inf)
#include <ymath.h>
#undef _Inf
  extern _CRTIMP const _Dconst _Inf;
#endif

#if defined(__polyspace__Nan) && !defined(__polyspace_no__Nan)
#include <ymath.h>
#undef _Nan
  extern _CRTIMP const _Dconst _Nan;
#endif

#if defined(__polyspace__Snan) && !defined(__polyspace_no__Snan)
#include <ymath.h>
#undef _Snan
  extern _CRTIMP const _Dconst _Snan;
#endif

#if defined(__polyspace__FDenorm) && !defined(__polyspace_no__FDenorm)
#include <ymath.h>
#undef _FDenorm
  extern _CRTIMP const _Dconst _FDenorm;
#endif

#if defined(__polyspace__FInf) && !defined(__polyspace_no__FInf)
#include <ymath.h>
#undef _FInf
  extern _CRTIMP const _Dconst _FInf;
#endif

#if defined(__polyspace__FNan) && !defined(__polyspace_no__FNan)
#include <ymath.h>
#undef _FNan
  extern _CRTIMP const _Dconst _FNan;
#endif

#if defined(__polyspace__FSnan) && !defined(__polyspace_no__FSnan)
#include <ymath.h>
#undef _FSnan
  extern _CRTIMP const _Dconst _FSnan;
#endif

#if defined(__polyspace__LDenorm) && !defined(__polyspace_no__LDenorm)
#include <ymath.h>
#undef _LDenorm
  extern _CRTIMP const _Dconst _LDenorm;
#endif

#if defined(__polyspace__LInf) && !defined(__polyspace_no__LInf)
#include <ymath.h>
#undef _LInf
  extern _CRTIMP const _Dconst _LInf;
#endif

#if defined(__polyspace__LNan) && !defined(__polyspace_no__LNan)
#include <ymath.h>
#undef _LNan
  extern _CRTIMP const _Dconst _LNan;
#endif

#if defined(__polyspace__LSnan) && !defined(__polyspace_no__LSnan)
#include <ymath.h>
#undef _LSnan
  extern _CRTIMP const _Dconst _LSnan;
#endif


#endif
/****************************************************************************
 *  /  NON-STD LIBRARIES VARIABLES STUBS
 ****************************************************************************/

