/*
 *
 * This file and its contents are the property of The MathWorks, Inc.
 * 
 * This file contains confidential proprietary information.
 * The reproduction, distribution, utilization or the communication
 * of this file or any part thereof is strictly prohibited.
 * Offenders will be held liable for the payment of damages.
 *
 * Copyright 1999-2012 The MathWorks, Inc.
 *
 */

/* hack to avoid double definition of __malloc_alloc_oom_handler */
#define RECIPES_CPP


// C++/5322

#if (defined __OS_VISUAL) && (defined PST_HAS_XLOCALE_FOR_STUB) && (defined __polyspace_ms_locale_id_idcnt)
   
  #include "xlocale"
  int locale::id::_Id_cnt = 0 ;

#endif

/*
  If bool is not supported, use a typedef for bool.
*/
#ifdef _BOOL
typedef bool __bool;
#else /* ifndef _BOOL */
typedef int __bool;
#endif /* ifdef _BOOL */

#ifdef PST_HAS_EXCEPTION
#define THROW(x) throw(x)
#else
#define THROW(x)
#endif /* ifdef PST_HAS_EXCEPTION */


/*
 * ISO/IEC 14882
 * 18.4 lib.support.dynamic
 *
 * Header <new> synopsis:
 * *
 * void* operator new(std::size_t size) throw(std::bad_alloc);
 * void* operator new(std::size_t size, const std::nothrow_t&) throw();
 * void  operator delete(void* ptr) throw ();
 * void  operator delete(void* ptr, const std::nothrow_t&) throw();
 *
 * void* operator new[](std::size_t size) throw(std::bad_alloc);
 * void* operator new[](std::size_t size, const std::nothrow_t&) throw();
 * void  operator delete[](void*) throw ();
 * void  operator delete[](void*, const std::nothrow_t&) throw();
 *
 * void* operator new(std::size_t size, void* ptr) throw();
 * void* operator new[](std::size_t size, void* ptr) throw();
 * void  operator delete(void* ptr, void*) throw();
 * void  operator delete[](void* ptr, void*) throw();
 */


#include <__polyspace__stddef.h>

#ifdef PST_HAS_NAMESPACE
namespace std
{
  using ::size_t ;
}
#endif

#if (!defined POLYSPACE_NO_STL_STUBS) 

/* Now <new> is in official STL stubs */


#if (defined __polyspace_set_new_handler) \
  || (defined __polyspace_new) \
  || (defined __polyspace_new_nothrow) \
  || (defined __polyspace_delete) \
  || (defined __polyspace_delete_nothrow) \
  || (defined __polyspace_new_array) \
  || (defined __polyspace_new_array_nothrow) \
  || (defined __polyspace_delete_array) \
  || (defined __polyspace_delete_array_nothrow) \
  || (defined __polyspace_placement_new) \
  || (defined __polyspace_placement_delete) \
  || (defined __polyspace_placement_new_array) \
  || (defined __polyspace_placement_delete_array)
#include <new>
#endif

#ifndef PST_HAS_EXCEPTION
#undef __polyspace_new_nothrow
#undef __polyspace_delete_nothrow
#undef __polyspace_new_array_nothrow
#undef __polyspace_delete_array_nothrow
#endif

#if (defined __polyspace_set_new_handler) || (defined __polyspace_new) || (defined __polyspace_new_nothrow)
#ifdef PST_HAS_NAMESPACE
extern "C" std::new_handler _new_handler = 0;
#else
extern "C" new_handler _new_handler = 0;
#endif
#endif

#if (defined __polyspace_new) || (defined __polyspace_new_nothrow)
PST_STUB_C_DECL(void *,malloc,(size_t size)) __PST_THROW;
#endif

#ifdef __polyspace_new
void *operator new(size_t size) THROW(std::bad_alloc)
{
  void *ptr;

  if (size == 0) size = 1;
  while ((ptr = (void *)malloc(size)) == 0) {
    if (_new_handler != 0) {
      (*_new_handler) ();
    }
    else {
      THROW(std::bad_alloc());
    }
  }  /* while */
  return ptr;
}  /* operator new */
#endif

#ifdef __polyspace_new_nothrow
void *operator new(size_t size, const std::nothrow_t&) THROW()
{
  void *ptr;

  if (size == 0) size = 1;
  while ((ptr = (void *)malloc(size)) == 0) {
    if (_new_handler != 0) {
      int done = 0;
      try {
	(*_new_handler) ();
      }
      catch (std::bad_alloc) {
	done = 1;
      }
      if (done) return (void*)0;
    } else {
      return (void *)0;
    }  /* if */
  }  /* while */
  return ptr;
}  /* operator new */
#endif

#ifdef __polyspace_delete
PST_STUB_C_DECL(void,free,(void *ptr)) __PST_THROW;

void operator delete(void *ptr) THROW()
{
  if (ptr != 0) {
    free(ptr);
  }  /* if */
}  /* operator delete */ 
#endif

#ifdef __polyspace_delete_nothrow
void operator delete(void *ptr,const std::nothrow_t&) THROW()
{
  operator delete(ptr);
}  /* operator delete */ 
#endif

#ifdef __polyspace_new_array
void *operator new[](size_t size) THROW(std::bad_alloc)
{
  return operator new(size);
}  /* operator new[] */
#endif

#ifdef __polyspace_new_array_nothrow
void *operator new[](size_t size,const std::nothrow_t& nothrow_arg) THROW()
{
  return operator new(size, nothrow_arg);
}  /* operator new[] */
#endif

#ifdef __polyspace_delete_array
void operator delete[](void *ptr) THROW()
{
  operator delete(ptr);
}  /* operator delete[] */
#endif

#ifdef __polyspace_delete_array_nothrow
void operator delete[](void *ptr,const std::nothrow_t&	nothrow_arg) THROW()
{
  operator delete(ptr, nothrow_arg);
}  /* operator delete[] */
#endif

#ifdef __polyspace_placement_delete
void operator delete(void *, void *) THROW()
{
}  /* operator delete (size_t, void*) */
#endif

#ifdef __polyspace_placement_delete_array
void operator delete[](void*, void*) THROW()
{
}  /* operator delete[](void*, void*) */
#endif

#ifdef PST_HAS_NAMESPACE
namespace std {
#endif

#ifdef __polyspace_set_new_handler
  new_handler set_new_handler(new_handler handler) THROW()
  {
    new_handler rr = _new_handler;
    _new_handler = handler;
    return rr;
  } 
#endif

#ifdef PST_HAS_NAMESPACE
}  /* namespace std */
#endif

#endif /* POLYSPACE_NO_STL_STUBS */

/*
   Even if <new> is in official STL stubs, definition of 
    placement new cannot be done by automatic stubber 
    and is fundemental for functionnal correctness

   Should be OK without including <new> because does not depend 
    on special types
*/

#ifdef __polyspace_placement_new
void *operator new(size_t, void *ptr) THROW()
{
  return ptr;
}  /* operator new (size_t, void*) */
#endif

#ifdef __polyspace_placement_new_array
void *operator new[](size_t, void* ptr) THROW()
{
  return ptr;
}  /* operator new[](size_t, void*) */
#endif


// GNATS 10795 (-D __polyspace_no_abort does not work)
// Remove dependencies to the abort() function in the stubs in order to avoid
// issues when -D __polyspace_no_abort is set.
#undef PST_ABORT
#define PST_ABORT() do { } while (1)


#if (!defined POLYSPACE_NO_STL_STUBS) 

/*
 * ISO/IEC 14882
 * 18.6 lib.support.exception
 *
 * Header <exception> synopsis:
 *
 * namespace std {
 *   typedef void (*unexpected_handler)();
 *   unexpected_handler set_unexpected(unexpected_handler f) throw();
 *   void unexpected();
 *
 *   typedef void (*terminate_handler)();
 *   terminate_handler set_terminate(terminate_handler f) throw();
 *   void terminate();
 *
 *   // following has empty exception specification since TC1
 *   __bool uncaught_exception() throw();
 * }
 */

#if (defined  __polyspace_set_unexpected) \
  || (defined __polyspace_unexpected) \
  || (defined __polyspace_set_terminate) \
  || (defined __polyspace_terminate) \
  || (defined __polyspace_uncaught_exception)
#include <exception>
#endif

#ifdef PST_HAS_NAMESPACE
namespace std {
#endif  

  /* all class definitions are inline now */

  /*
   * Other functions
   */

#if (defined __polyspace_set_unexpected) || (defined __polyspace_unexpected)
#  if (! defined(__polyspace_no_terminate))
#    define __polyspace_terminate
#  endif
  extern unexpected_handler __default_unexpected_routine = terminate;
#endif

#ifdef __polyspace_set_unexpected
  unexpected_handler set_unexpected(unexpected_handler new_func) THROW()
    /*
      Set the unexpected routine pointer to the value passed by the caller
      and return the old value.
    */
  {
    unexpected_handler old_func = __default_unexpected_routine;
    if (new_func != 0) {
      __default_unexpected_routine = new_func;
    } else {
      terminate();
    }
    return old_func;
  }
#endif
  
#ifdef __polyspace_unexpected
  void unexpected()
    /*
      The default unexpected routine.  This routine calls terminate.
    */
  {
    __default_unexpected_routine();
  }
#endif

#ifdef PST_HAS_NAMESPACE
}  /* namespace std */
#endif


#ifdef PST_HAS_NAMESPACE
namespace std {
#endif

#if (defined __polyspace_set_terminate) || (defined __polyspace_terminate)
  void __default_initial_terminate_routine() {
    PST_ABORT();
  }
  
  terminate_handler __default_terminate_routine = __default_initial_terminate_routine;
#endif

#ifdef __polyspace_set_terminate
#  if (! defined(__polyspace_no_terminate))
#    define __polyspace_terminate
#  endif
  terminate_handler set_terminate(terminate_handler new_func) THROW()
    /*
      Set the terminate routine pointer to the value passed by the caller
      and return the old value.
    */
  {
    terminate_handler old_func = __default_terminate_routine;
    if (new_func != 0) {
      __default_terminate_routine = new_func;
    }
    else {
      terminate();
    }
    return old_func;
  }
#endif
  
#ifdef __polyspace_terminate
  void terminate()
    /*
      The default terminate routine.
    */
  {
    __default_terminate_routine();
  }
#endif
  
#ifdef __polyspace_uncaught_exception
  __bool uncaught_exception() THROW()
  {
    volatile __bool random;
    return random;
  }
#endif

#ifdef PST_HAS_NAMESPACE
}  /* namespace std */
#endif


#endif /* !defined POLYSPACE_NO_STL_STUBS */



/* type used in pst for exception management */
struct __intern_a_thrown_object {
  void *        __intern_object_ptr;
  unsigned char __intern_num_ptrs;
  unsigned int  __intern_num_type;
  /* for use when Config.tid_is_func_ptr = true : */
  /* void (*__intern_num_type)(void); */
};


#if defined(__polyspace___memzero) && !defined(__polyspace_no___memzero)

extern "C" {
  void __memzero(void    *buffer,unsigned long	n)
    /*
      Initialize a block of memory.
    */
  {
    __ps_builtin_memzero(buffer, n);
  }  /* __memzero */
}

#endif
