/*
 *
 * This file and its contents are the property of The MathWorks, Inc.
 * 
 * This file contains confidential proprietary information.
 * The reproduction, distribution, utilization or the communication
 * of this file or any part thereof is strictly prohibited.
 * Offenders will be held liable for the payment of damages.
 *
 * Copyright 1999-2012 The MathWorks, Inc.
 *
 */

#if ! ((defined POLYSPACE_NO_STANDARD_STUBS) || (defined POLYSPACE_NO_STL_STUBS))

#include <__polyspace__compat.h>

#ifdef __polyspace__limits_contents
#include <limits>

namespace std
{

/*                                */
/* constants declared in 'limits' */
/*                                */

const __ps_bool                      __pst__Num_Base::is_specialized;
const __ps_bool                      __pst__Num_Base::is_signed;
const __ps_bool                      __pst__Num_Base::is_integer;
const __ps_bool                      __pst__Num_Base::is_exact;
const int                       __pst__Num_Base::radix;
const int                       __pst__Num_Base::min_exponent;
const int                       __pst__Num_Base::min_exponent10;
const int                       __pst__Num_Base::max_exponent;
const int                       __pst__Num_Base::max_exponent10;
const __ps_bool                      __pst__Num_Base::has_infinity;
const __ps_bool                      __pst__Num_Base::has_quiet_NaN;
const __ps_bool                      __pst__Num_Base::has_signaling_NaN;
const float_denorm_style        __pst__Num_Base::has_denorm;
const __ps_bool                      __pst__Num_Base::has_denorm_loss;
const __ps_bool                      __pst__Num_Base::is_iec559;
const __ps_bool                      __pst__Num_Base::is_bounded;
const __ps_bool                      __pst__Num_Base::is_modulo;
const __ps_bool                      __pst__Num_Base::traps;
const __ps_bool                      __pst__Num_Base::tinyness_before;
const float_round_style         __pst__Num_Base::round_style;
const int                       __pst__Num_Base::digits;
const int                       __pst__Num_Base::digits10;

const __ps_bool                      __pst__Num_int_base::is_bounded;
const __ps_bool                      __pst__Num_int_base::is_exact;
const __ps_bool                      __pst__Num_int_base::is_integer;
const __ps_bool                      __pst__Num_int_base::is_modulo;
const __ps_bool                      __pst__Num_int_base::is_specialized;
const int                       __pst__Num_int_base::radix;

const float_denorm_style        __pst__Num_float_base::has_denorm;
const __ps_bool                      __pst__Num_float_base::has_denorm_loss;
const __ps_bool                      __pst__Num_float_base::has_infinity;
const __ps_bool                      __pst__Num_float_base::has_quiet_NaN;
const __ps_bool                      __pst__Num_float_base::has_signaling_NaN;
const __ps_bool                      __pst__Num_float_base::is_bounded;
const __ps_bool                      __pst__Num_float_base::is_exact;
const __ps_bool                      __pst__Num_float_base::is_iec559;
const __ps_bool                      __pst__Num_float_base::is_integer;
const __ps_bool                      __pst__Num_float_base::is_modulo;
const __ps_bool                      __pst__Num_float_base::is_signed;
const __ps_bool                      __pst__Num_float_base::is_specialized;
const __ps_bool                      __pst__Num_float_base::tinyness_before;
const __ps_bool                      __pst__Num_float_base::traps;
const float_round_style         __pst__Num_float_base::round_style;
const int                       __pst__Num_float_base::radix;

const __ps_bool                      numeric_limits<char>::is_signed;
const int                       numeric_limits<char>::digits;
const int                       numeric_limits<char>::digits10;

#if defined(_WCHAR_T) && \
    (! defined(PST_DEFINE_WCHAR_T_KEYWORD_IS_UNSIGNED_LONG)) && \
    (! defined(PST_DEFINE_WCHAR_T_KEYWORD_IS_UNSIGNED_SHORT))

const __ps_bool                      numeric_limits<wchar_t>::is_signed;
const int                       numeric_limits<wchar_t>::digits;
const int                       numeric_limits<wchar_t>::digits10;

#endif

const __ps_bool                      numeric_limits<signed char>::is_signed;
const int                       numeric_limits<signed char>::digits;
const int                       numeric_limits<signed char>::digits10;

const __ps_bool                      numeric_limits<unsigned char>::is_signed;
const int                       numeric_limits<unsigned char>::digits;
const int                       numeric_limits<unsigned char>::digits10;

const __ps_bool                      numeric_limits<short>::is_signed;
const int                       numeric_limits<short>::digits;
const int                       numeric_limits<short>::digits10;

const __ps_bool                      numeric_limits<unsigned short>::is_signed;
const int                       numeric_limits<unsigned short>::digits;
const int                       numeric_limits<unsigned short>::digits10;

const __ps_bool                      numeric_limits<int>::is_signed;
const int                       numeric_limits<int>::digits;
const int                       numeric_limits<int>::digits10;

const __ps_bool                      numeric_limits<unsigned int>::is_signed;
const int                       numeric_limits<unsigned int>::digits;
const int                       numeric_limits<unsigned int>::digits10;

const __ps_bool                      numeric_limits<long>::is_signed;
const int                       numeric_limits<long>::digits;
const int                       numeric_limits<long>::digits10;

const __ps_bool                      numeric_limits<unsigned long>::is_signed;
const int                       numeric_limits<unsigned long>::digits;
const int                       numeric_limits<unsigned long>::digits10;

const __ps_bool                      numeric_limits<long long>::is_signed;
const int                       numeric_limits<long long>::digits;
const int                       numeric_limits<long long>::digits10;

const __ps_bool                      numeric_limits<unsigned long long>::is_signed;
const int                       numeric_limits<unsigned long long>::digits;
const int                       numeric_limits<unsigned long long>::digits10;

#ifdef ___PS_BOOL

const __ps_bool                      numeric_limits<__ps_bool>::is_modulo;
const __ps_bool                      numeric_limits<__ps_bool>::is_signed;
const int                       numeric_limits<__ps_bool>::digits;
const int                       numeric_limits<__ps_bool>::digits10;

#endif

const int                        numeric_limits<float>::digits;
const int                        numeric_limits<float>::digits10;
const int                        numeric_limits<float>::max_exponent;
const int                        numeric_limits<float>::max_exponent10;
const int                        numeric_limits<float>::min_exponent;
const int                        numeric_limits<float>::min_exponent10;

const int                        numeric_limits<double>::digits;
const int                        numeric_limits<double>::digits10;
const int                        numeric_limits<double>::max_exponent;
const int                        numeric_limits<double>::max_exponent10;
const int                        numeric_limits<double>::min_exponent;
const int                        numeric_limits<double>::min_exponent10;

const int                        numeric_limits<long double>::digits;
const int                        numeric_limits<long double>::digits10;
const int                        numeric_limits<long double>::max_exponent;
const int                        numeric_limits<long double>::max_exponent10;
const int                        numeric_limits<long double>::min_exponent;
const int                        numeric_limits<long double>::min_exponent10;

}

#endif /* __polyspace__limits_contents */

#ifdef __polyspace__locale_contents
#include <locale>

namespace std
{
/*                                */
/* constants declared in 'locale' */
/*                                */

const locale::category locale::none;
const locale::category locale::collate;
const locale::category locale::ctype;
const locale::category locale::monetary;
const locale::category locale::numeric;
const locale::category locale::time;
const locale::category locale::messages;
const locale::category locale::all;

}

/* some static variable definition */

locale::id ctype<char>::id;
const size_t ctype<char>::table_size = 256;

#ifdef PST_VISUAL

locale::id codecvt<wchar_t, char, mbstate_t>::id;
locale::id ctype<wchar_t>::id;

#endif

#endif /* __polyspace__locale_contents */

#ifdef __polyspace__ios_base_contents

#if (defined __polyspace_cin) \
  || (defined __polyspace_cout) \
  || (defined __polyspace_cerr) \
  || (defined __polyspace_clog) \
  || (defined __polyspace_wcin) \
  || (defined __polyspace_wcout) \
  || (defined __polyspace_wcerr) \
  || (defined __polyspace_wclog)
#include <iostream>
#endif

namespace std
{

#ifdef __polyspace_cin
istream cin;
#endif

#ifdef __polyspace_cout
ostream	cout;
#endif

#ifdef __polyspace_cerr
ostream	cerr;
#endif

#ifdef __polyspace_clog
ostream clog;
#endif

#ifdef __polyspace_wcin
wistream wcin;
#endif

#ifdef __polyspace_wcout
wostream wcout;
#endif

#ifdef __polyspace_wcerr
wostream wcerr;
#endif

#ifdef __polyspace_wclog
wostream wclog;
#endif

} // std

#include <__polyspace__ios_base.h>

namespace std
{
const ios_base::fmtflags ios_base::boolalpha(__pst_boolalpha);
const ios_base::fmtflags ios_base::dec(__pst_dec);
const ios_base::fmtflags ios_base::fixed(__pst_fixed);
const ios_base::fmtflags ios_base::hex(__pst_hex);
const ios_base::fmtflags ios_base::internal(__pst_internal);
const ios_base::fmtflags ios_base::left(__pst_left);
const ios_base::fmtflags ios_base::oct(__pst_oct);
const ios_base::fmtflags ios_base::right(__pst_right);
const ios_base::fmtflags ios_base::scientific(__pst_scientific);
const ios_base::fmtflags ios_base::showbase(__pst_showbase);
const ios_base::fmtflags ios_base::showpoint(__pst_showpoint);
const ios_base::fmtflags ios_base::showpos(__pst_showpos);
const ios_base::fmtflags ios_base::skipws(__pst_skipws);
const ios_base::fmtflags ios_base::unitbuf(__pst_unitbuf);
const ios_base::fmtflags ios_base::uppercase(__pst_uppercase);
const ios_base::fmtflags ios_base::adjustfield(__pst_adjustfield);
const ios_base::fmtflags ios_base::basefield(__pst_basefield);
const ios_base::fmtflags ios_base::floatfield(__pst_floatfield);

const ios_base::iostate	 ios_base::badbit(__pst_badbit);
const ios_base::iostate	 ios_base::eofbit(__pst_eofbit);
const ios_base::iostate	 ios_base::failbit(__pst_failbit);
const ios_base::iostate	 ios_base::goodbit(__pst_goodbit);

const ios_base::openmode ios_base::app(__pst_app);
const ios_base::openmode ios_base::ate(__pst_ate);
const ios_base::openmode ios_base::binary(__pst_binary);
const ios_base::openmode ios_base::in(__pst_in);
const ios_base::openmode ios_base::out(__pst_out);
const ios_base::openmode ios_base::trunc(__pst_trunc);
#ifdef  PST_STL_PERMISSIVE_STUB
const ios_base::openmode ios_base::noreplace(__pst_noreplace);
const ios_base::openmode ios_base::nocreate(__pst_nocreate);
#endif /* PST_STL_PERMISSIVE_STUB */

const ios_base::seekdir	 ios_base::beg(__pst_beg);
const ios_base::seekdir  ios_base::cur(__pst_cur);
const ios_base::seekdir  ios_base::end(__pst_end);

  // Manipulators //
 ios_base&	boolalpha(ios_base	&str) {return str;}
 ios_base&	noboolalpha(ios_base	&str) {return str;}
 
 ios_base&	showbase(ios_base	&str) {return str;}
 ios_base&	noshowbase(ios_base	&str) {return str;}
 
 ios_base&	showpoint(ios_base	&str) {return str;}
 ios_base&	noshowpoint(ios_base	&str) {return str;}
 
 ios_base&	showpos(ios_base	&str) {return str;}
 ios_base&	noshowpos(ios_base	&str) {return str;}
 
 ios_base&	skipws(ios_base	&str)	      {return str;}
 ios_base&	noskipws(ios_base	&str) {return str;}
 
 ios_base&	uppercase(ios_base	&str) {return str;}
 ios_base&	nouppercase(ios_base	&str) {return str;}

 ios_base&	unitbuf(ios_base	&str) {return str;}
 ios_base&	nounitbuf(ios_base	&str) {return str;}

  // Adjust field //
 ios_base&	internal(ios_base	&str) {return str;}
 ios_base&	left(ios_base	&str)	      {return str;}
 ios_base&	right(ios_base	&str)	      {return str;}
 
  // Basefield //
 ios_base&	dec(ios_base	&str)	      {return str;}
 ios_base&	hex(ios_base	&str)	      {return str;}
 ios_base&	oct(ios_base	&str)	      {return str;}
 
  // Floatfield //
 ios_base&	fixed(ios_base	&str)	      {return str;}
 ios_base&	scientific(ios_base	&str) {return str;}

}
#endif /* __polyspace__ios_base_contents */
#endif /* ! ((defined POLYSPACE_NO_STANDARD_STUBS) || (defined POLYSPACE_NO_STL_STUBS)) */










