/* Copyright 2006-2011 The MathWorks, Inc. */

/* 
 * File: sil_main.c
 *
 * SIL main
 *
 */ 
#include "xil_interface_lib.h"

int main(const int argc, char * argv[]) {
   XIL_INTERFACE_LIB_ERROR_CODE errorCode = XIL_INTERFACE_LIB_SUCCESS;
   /* avoid warnings about infinite loops */
   volatile int loop = 1;

   /* XIL initialization */   
   errorCode = xilInit(argc, (void **) argv);
   if (errorCode != XIL_INTERFACE_LIB_SUCCESS) {
      /* terminate application */
      return errorCode;
   }
	/* main XIL loop */
   while(loop) {
      errorCode = xilRun();
      if (errorCode != XIL_INTERFACE_LIB_SUCCESS) {
          if (errorCode == XIL_INTERFACE_LIB_TERMINATE) {
              int exitCode; 
              /* orderly shutdown of rtiostream */
              exitCode = xilTerminateComms(); 
              if (exitCode == XIL_INTERFACE_LIB_SUCCESS) {
                  exitCode = 0;
              }
              /* terminate */
              return exitCode;
          } else {
              /* terminate with error code */
              return errorCode;
          }
      }
   } 
   return errorCode;
}
