var mydata = [
    {id: 0, name: "aaa", value: "123", status:0, prompt:"AAA",type:"enum",values:["a1","a2"],disps:["A1","A2"] },
    {id: 1, name: "bbb", value: "456", status:0, prompt:"BBB",type:"enum",values:["b1","b2"],disps:["B1","B2"] },
    {id: 2, name: "ccc", value: "789", status:0, prompt:"CCC",type:"enum",values:["c1","c2"],disps:["C1","C2"] },
    
];

require([
    // "dgrid/Grid", "dojo/domReady!"
    "dgrid/OnDemandGrid", "dojo/store/Memory", "dgrid/CellSelection", "dgrid/Keyboard", "dgrid/Selection", "dgrid/extensions/ColumnResizer", "dgrid/editor", "dgrid/List", "dojo/parser",
], function(Grid, Memory, CellSelection, Keyboard, Selection, ColumnResizer, editor, List, parser){
    
    var MyGrid = dojo.declare([Grid, Keyboard, ColumnResizer, editor ]);
 
    var mycols =[
        // editor({label: "Parameter", field: "name", editor: "checkbox", editOn: "dbclick"}),
        editor({label: "Parameter", field: "name"},  "text"),

        editor({label: "Value", field: "value", editor: "text"}),
    ];

    function editorType(object, data, cell) {
        return "text";
    }

    var mycols = [
        {label: "ID", field: "id", sortable: true},
        {label: "Parameter", field: "name", renderCell: actionRenderName, sortable: true},
        {label: "Value", field: "value", renderCell: actionRenderValue, sortable: true},
    ];

    function actionRenderName(object, data, cell) {
        name = '<div class="name">' + object.name + '</div>';
        prompt = '<div class="prompt">' + object.prompt; + '</div>';
        cell.innerHTML = '<div class="param">' + name + '<br>' + prompt + '</div>';

    }

    function actionRenderValue (object, data, cell) {
        var disabled = '';
        if (object.status > 0) {
            disabled = 'disabled="disabled"';
        }
        
        switch (object.type) {
        case "enum":
            var str = '';
            for (var i=0; i < object.values.length; i++) {
                var selected = '';
                if (object.value == object.values[i]) {
                    selected = 'selected="selected"';
                }
                str = str + '<option value="' + object.values[i] + '" ' + selected + '>' + object.disps[i] + '</option>';
            }
            cell.innerHTML = '<select data-dojo-type="dijit/form/Select" id="'+ object.name +'" ' + disabled + '>' + str + '</select>';
            break;
        case "int":
            cell.innerHTML = '<input id="'+object.name+'" type="text" value=' + object.value + ' ' + disabled + '>';
            break;
        case "boolean":
            var checked = '';
            if (data == 'on') {
                checked = 'checked="checked"';
            }
            cell.innerHTML = '<input id="'+object.name+'" type="checkbox"' + ' ' + checked + ' ' + disabled + '>';
            break;
        case "string":
            cell.innerHTML = '<input id="'+object.name+'"type="text" value="' + object.value + '" ' + disabled + '>';
            break;
        }
        cell.innerHTML = '<div>' + cell.innerHTML + '</div>';
    }

    
    var testStore = new Memory({data: mydata});
    
    grid = new MyGrid({
        // store: testStore,
        getBeforePut: false,
        columns: mycols
    }, "grid");
    
    grid.renderArray(mydata);
    
    parser.parse();

    // var arrayOfStrings =["a", "b", "c"];
    // var list = new List({}, "list");
    // list.renderArray(arrayOfStrings);


});



