// Copyright 2014 MathWorks, Inc.

// DO NOT CHANGE THIS!
// CLIENT DATA HAS BEEN SAVED THAT RELIES ON THIS BEING EXACTLY
// "_N_E_W_L_I_N_E_"
// "_S_I_N_G_L_E_Q_U_O_T_E_"
var NEWLINE_STANDIN = "_N_E_W_L_I_N_E_";
var NEWLINE_STANDIN_REGEX = new RegExp(NEWLINE_STANDIN, "g");
var SINGLE_QUOTE_STANDIN = "_S_I_N_G_L_E_Q_U_O_T_E_";
var SINGLE_QUOTE_STANDIN_REGEX = new RegExp(SINGLE_QUOTE_STANDIN, "g");
// SERIOUSLY, DON'T CHANGE IT!

var VIEWBOX_X_WIDTH = 570;
var VIEWBOX_Y_WIDTH = 365;
var SVG_ASPECT_RATIO = VIEWBOX_Y_WIDTH / VIEWBOX_X_WIDTH;

var SCROLL_RESPONSE_DELAY_MS = 200;

// this specifies how much percentage of width each viewmark has when there are x (x=1,2,3,4,5,6)
// viewmarks per row on the manager UI
var RATIO_SET = [];
RATIO_SET[1] = "80%";
RATIO_SET[2] = "46%";
RATIO_SET[3] = "32%";
RATIO_SET[4] = "23%";
RATIO_SET[5] = "19%";
RATIO_SET[6] = "15%";

var ratioIndex = 0;

var numberPerRow = 3;
var viewmarkHeight = 0;
var viewportHeight = 0;
var pageLoaded     = false;

var onloadSVGResizeBegin = 0;
var onloadSVGResizeEnd = 0;

var idForDelete = 0;
var groupForDelete = '';
var collapsedViewmarks = 0;

var groups;
var groupStates;

var canvases;
var rowPerViewPort;
var viewmarksPerViewport;

var showSpinnerHandle = null;

function mouseUp() {
    if (this === event.target) {
        updateViewMarker("", " ", "closeUI");
    }
}

function responsivelyLoadSVGs() {
    var begin_target = Math.max(Math.floor((window.pageYOffset/document.documentElement.offsetHeight) * (canvases.length - collapsedViewmarks)) - numberPerRow, 0);
    var end_target   = Math.min(begin_target + viewmarksPerViewport + numberPerRow, canvases.length - collapsedViewmarks);

    var sum = 0;
    var totalWithCollapsed = 0;

    for(var i_grp=0; i_grp<groupStates.length; i_grp++) {
        var groupState = groupStates[i_grp];
        var begin_i = groupState.beginIndx;
        var end_i   = groupState.endIndx

        if (groupState.expanded) {
            for(var k = Math.max(begin_i, begin_target)+totalWithCollapsed; k <= Math.min(end_i, end_target)+totalWithCollapsed; k++) {
                loadSvgSingle(k);
                sum+=1;
            }                
            begin_target += sum;
            sum=0;
            
        } else {
            totalWithCollapsed += (end_i - begin_i)+1;
        }

        if (begin_target >= end_target) {
                break;
            }
        }
}

var delayedExec = function(after, fn) {
    var timer;
    return function() {

        timer && clearTimeout(timer);
        timer = setTimeout(fn, after);
    };
};

var scrolled = delayedExec(SCROLL_RESPONSE_DELAY_MS, function() {

    if (pageLoaded) {
        responsivelyLoadSVGs();
    }
    else {
        var currentViewportHeight = document.body.clientHeight;

        if (viewportHeight !=0 && currentViewportHeight == viewportHeight) {
            pageLoaded = true;
        }
    }
});

function imageClicked(ev) {
    showSpinnerHandle = window.setTimeout(function() {
        var spinner = getByClass("spinner");
        var spinner = getByClass("spinner");
        removeClass(spinner, "spinner_msg");
        spinner.style.display = 'block';
        
        var spinner_title = getByClass("spinner_title", spinner);
        spinner_title.style.display = "none";
	
        var spinnertext = getByClass("spinner_text", spinner);
        spinnertext.style.display = 'block';
        
        var spinnerwarning = getByClass("spinner_warning", spinner);
        spinnerwarning.style.display = 'none';
    }, 400);
    
    var id = this.parentElement.parentElement.id;
    updateViewMarker(id, '', 'open');
    updateViewMarker(id, '', 'markavailable');
}

function cancelSpinner(id) {
    var spinner = getByClass("spinner");
    addClass(spinner, "spinner_msg");
    removeClass(spinner, "spinner_image");

    var spinner_title = getByClass("spinner_title", spinner);
    spinner_title.style.display = "block";

    var spinnertext = getByClass("spinner_text", spinner);
    spinnertext.style.display = 'none';

    var spinnerwarning = getByClass("spinner_warning", spinner);
    spinnerwarning.style.display = 'block';

    var viewmark = document.getElementById(id);    // add a class for bad state
    viewmark.style.background = "rgba(153,153,153, 1)";

    var imgFrame = getByClass("imgframe", viewmark);
    imgFrame.style.opacity = "0.3";

    idForDelete = id;
    spinner.style.display = 'block';
    
    updateViewMarker(id, '', 'markunavailable');

    showSpinnerHandle && window.clearTimeout(showSpinnerHandle);
}

function handleSvgLoaded(ev) {
    sizeSingleSvgToFrame(this);
}

function sizeSingleSvgToFrame(svgIFrame) {
    try {
        var svg = svgIFrame.contentDocument.getElementsByTagName('svg')[0];

        var parent = svgIFrame.parentElement;
        var parentRect = parent.getBoundingClientRect();

        if (parentRect.width > 0) {
            svgIFrame.width = Math.floor(parentRect.width);
            svgIFrame.height = Math.floor(parentRect.height);
            svg.setAttribute('width', parentRect.width * 0.95 );  // the coefficient 0.95 is used to diminish the difference between canvas image and svg image
            svg.setAttribute('height', parentRect.height);
        }
    } catch (e) {
        // Swallowing exceptions so that one SVG failing to load doesn't doom the whole page.
    }
}

function sizeDivsToAspectRatio(className) {
    var divs = document.getElementsByClassName(className);
    var firstWidth = 0;
    for (var i = 0; i < divs.length; ++i) {
        var boundingRect = divs[i].getBoundingClientRect();
        if (boundingRect.width > 0) {
            // The divs may not have exactly the same width.
            // Using the width of the first div ensures they end up with uniform height.
            firstWidth = boundingRect.width;
            break;
        }
    }
    
    for (var i = 0; i < divs.length; ++i) {
        divs[i].style.height = (firstWidth * SVG_ASPECT_RATIO).toFixed(0) + 'px';
    }
    
    viewmarkHeight = firstWidth * SVG_ASPECT_RATIO;
}

function loadSvgs(beginIndex, endIndex) {
    for (var i = beginIndex; i < endIndex; ++i) {
        loadSvgSingle(i);
    }
}

function loadSvgSingle(index) {
    var canvas = canvases[index];
    if (!canvas.imageLoaded) {
        var iframe = canvas.parentNode.querySelector("iframe");
        iframe.onload = function() {
            var img = canvas.parentNode.querySelector("img");
            img.onload = function() {
                var cxt = canvas.getContext("2d");
                var canvasRect = canvas.getBoundingClientRect();
                canvas.width = canvasRect.width;
                canvas.height = canvasRect.height;  
                cxt.drawImage(img, 0, 0, canvas.width, canvas.height);
            };
            img.src = canvas.imagePath;
        };

        iframe.src = canvas.imagePath;
        canvas.imageLoaded = true;
    }
}

function getUpdateCommand(viewMarkerId, newValue, field, modelname) {
   if (field=='open')
      command = "slprivate('slsfviewmark', '" + modelname + "', 'open', '" + viewMarkerId  +  "'); "
   else if (field=='name')
      command = "slprivate('slsfviewmark', '" + modelname + "', 'modifyname',  '" + viewMarkerId +  "', '" + newValue + "') "
   else if (field=='annotation')
      command = "slprivate('slsfviewmark', '" + modelname + "', 'modifyannotation',  '" + viewMarkerId +  "', '" + newValue + "') "
   else if (field=='delete')
      command = "slprivate('slsfviewmark', '" + modelname + "', 'delete',  '" + viewMarkerId +  "') "
   else if (field=='markunavailable')
      command = "slprivate('slsfviewmark', '" + modelname + "', 'markunavailable', '" + viewMarkerId  +  "'); "
   else if (field=='markavailable')
      command = "slprivate('slsfviewmark', '" + modelname + "', 'markavailable', '" + viewMarkerId  +  "'); "
   else if (field=='closeUI')
      command = "slprivate('slsfviewmark', '" + modelname + "', 'closeUI') "
   else if (field=='deletegroup')
      command = "slprivate('slsfviewmark', '" + modelname + "', 'deletegroup',  '" + viewMarkerId +  "') "
   else if (field=='resetxml')
      command = "slprivate('slsfviewmark', '" + modelname + "', 'resetxml') "
   else if (field=='printout')
      command = "disp('" + newValue + "');";

   return command;
}

function jump(anchorId) {
    var model = document.getElementById(anchorId)
    if (model) {                                
        window.scrollTo(0, model.offsetTop - 40);
    }else{
        pageLoaded = true;
    }
}

function getByClass(className, target) {
    return getAllByClass(className, target)[0];
}

function getAllByClass(className, target) {
    target = target || document;
    return target.getElementsByClassName(className);
}

function hasClass(div, className) {
    var findClassRegex = new RegExp("(?:\\s|^)" + className + "(?:\\s|$)");
    return div.className.search(findClassRegex) !== -1;
}

function addClass(div, className) {
    if (!hasClass(div, className)) {
      div.className += " " + className;
    }
}

function removeClass(div, className) {
    var findClassRegex = new RegExp("(?:\\s|^)" + className + "(?:\\s|$)", "g");
    if (hasClass(div, className)) {
       div.className = div.className.replace(findClassRegex, " ");
       div.className = div.className.trim();    
    }
}

function activate(ev) {
    removeClass(ev.target, "inactive");
    addClass(ev.target, "active");
}

function deactivate(ev){
    removeClass(ev.target, "active");
    addClass(ev.target, "inactive");
}

function updateViewMarker(viewMarkerId, newValue, field) {
    var MATLAB_COMMAND_PREFIX = "matlab:";

    // getUpdateCommand is assumed to have been defined before this is called
    var updateNameCommand = MATLAB_COMMAND_PREFIX + getUpdateCommand(viewMarkerId, newValue, field, DEFAULT_ANCHOR_ID);  

    // viewMarketQtBridge is exposed by QtWebBrowser2::slotAddViewMarkerQtBridgeToJS
    // updateViewMarker is defined as a signal on ViewMarkerQtBridge in QtWebBrowser.hpp.
    // The slot is handled by QtWebBrowser2::handleLinkClicked(QString).
    // DEPRECATED :: TO BE REPLACED when .click() functionality is available.
    try {
        viewMarkerQtBridge.updateViewMarker(updateNameCommand);
        return true;
    } catch(ex) {
        console.log(ex);
        // TODO: somehow alert that we can't update?
        // Presently just silently fails.
    }
    
    return false;
}

function getViewMarkerId(viewmarkerFrame) {
    return (getByClass("viewMarkerId", viewmarkerFrame)).value;
}

var lastNewName = "";
function update(ev) {
    ev.target.blur();

    var newName = ev.target.value;  // it's tempting to call .trim(), but .trim() doesn't always handle i18n well
    if (lastNewName === newName) {
        return;
    }
    lastNewName = newName;

    var viewMarkerFrame = ev.target.parentElement.parentElement;
    var viewMarkerId    = getViewMarkerId(viewMarkerFrame);
    
    if (updateViewMarker(viewMarkerId, encodeSingleQuote(newName), "name")) {
        ev.target.title = newName;
    } else {
        ev.target.title = "UPDATE ERROR";
    }
}

function showEditor(ev) {
    addClass(document.body, "lockControls");
    
    var viewMarkerFrame = ev.target.parentElement;
    var glass           = getByClass("glass", viewMarkerFrame);
    var editPane        = getByClass("editPane", viewMarkerFrame);
    var textArea        = editPane.getElementsByTagName("textarea")[0];
    
    textArea.value = glass.title;
    editPane.style.display = "block";
    
    textArea.focus();
}

function hideEditor(ev) {
    removeClass(document.body, "lockControls");
    var editPane = ev.target.parentElement;
    editPane.style.display = "none";
}

function hideDialog(ev) {
    removeClass(document.body, "lockControls");
    var editPane = ev.target.parentElement.parentElement;
    editPane.style.display = "none";
}

function deleteViewMark(ev) {
    var viewMarkerFrame = ev.target.parentElement;
    var viewMarkerId = getViewMarkerId(viewMarkerFrame);
    
    updateViewMarker(viewMarkerId, " ", "delete");

    var SLIDE_OUT_STEP = 100;  // pixels
    slideOut(viewMarkerFrame, SLIDE_OUT_STEP, function(div) {
      div.parentElement.removeChild(div);
    });
    
    var outer = viewMarkerFrame.parentElement;
    var remainingChildren = outer.getElementsByClassName('viewmarkerframe');

    removeModelNameIfNeeded = window.setTimeout(function() {
        var modelname = outer.previousElementSibling;
        if (remainingChildren.length==0) {
            modelname.parentElement.removeChild(modelname);
        }	
    }, 500);
}

function showDeleteGroupConfirmation(ev) {
    addClass(document.body, "lockControls");

    var viewMarkerFrame        = ev.target.parentElement.parentElement;
    var deleteGroupConfirmationPane = getByClass("deleteGroupConfirmationPane", viewMarkerFrame);   
    groupForDelete = ev.target.parentElement.getAttribute('id');
    deleteGroupConfirmationPane.style.display = "block";    
    
    ev.cancelBubble = true;
}

function deleteGroupViewMark(ev) { // clean up var declaration
    var group = [];
    var i;
    var nextElement;
    var frames;
    var framesLen;
    
    for (i=0; i<groups.length; i++) {
        group = groups[i];
        if (groups[i].getAttribute('id') != groupForDelete) {
            continue;
        }

        groupStates[i].expanded = false;      
        nextElement = groups[i].nextElementSibling;
        frames = nextElement.getElementsByClassName('viewmarkerframe');
        framesLen = frames.length;
        collapsedViewmarks = collapsedViewmarks + framesLen;

        updateViewMarker(groupForDelete, " ", "deletegroup");

        var SLIDE_OUT_STEP = 100;  // pixels
        var groupToRemove = group.nextElementSibling;
        slideOut(groupToRemove, SLIDE_OUT_STEP, function(div) {
            div.parentElement.removeChild(div);
        });

        break;
    }

    hideDialog(ev);

    loadSvgAfterCollapsing(group);

    parentOfMdlName = group.parentElement;
    parentOfMdlName.removeChild(group);
    for (var j=groupStates[i].beginIndx; j<=groupStates[i].endIndx; j++) {
        svgs.splice(j, 1);
    }
    groupStates.splice(i, 1);
    collapsedViewmarks = collapsedViewmarks - framesLen;    
    pageHeight = document.documentElement.offsetHeight;
    updateViewMarker("", " ", "resetxml");
    document.body.className = "";
}

function stopDeleteGroupViewMark(ev) {
    hideDialog(ev);
    document.body.className = "";
}

function OKButtonForUnavailableCallback(ev) {
    hideDialog(ev);
    
    updateViewMarker(idForDelete, " ", "delete");

    var SLIDE_OUT_STEP = 100;  // pixels
    var parentViewMarker = document.getElementById(idForDelete);
    slideOut(parentViewMarker, SLIDE_OUT_STEP, function(div) {
      div.parentElement.removeChild(div);
    });

    idForDelete = 0;    

    var outer = parentViewMarker.parentElement;
    var remainingChildren = outer.getElementsByClassName('viewmarkerframe');

    removeModelNameIfNeeded = window.setTimeout(function() {
        var modelname = outer.previousElementSibling;
        if (remainingChildren.length==0) {
            modelname.parentElement.removeChild(modelname);
        }	
    }, 500);
}

function CancelButtonForUnavailableCallback(ev) {
    hideDialog(ev);
}

function OKButtonForWarningDescLenCallback(ev) {
    hideDialog(ev);
}

function showDeleteViewMark(ev) {
    document.body.className = "lockControls";

    var viewMarkerFrame        = ev.target.parentElement;
    var glass                  = getByClass("glass", viewMarkerFrame);
    var deleteConfirmationPane = getByClass("deleteConfirmationPane", viewMarkerFrame);

    deleteConfirmationPane.style.display = "block";    
}

function hideDeleteViewMark(ev) {
    document.body.className = "lockControls";

    var viewMarkerFrame        = ev.target.parentElement;
    var glass                  = getByClass("glass", viewMarkerFrame); 
    var deleteConfirmationPane = getByClass("deleteConfirmationPane", viewMarkerFrame);

    deleteConfirmationPane.style.display = "none";    
}


function encodeNewlines(string) {
    return string.replace(/\n/g, NEWLINE_STANDIN);
}

function decodeNewlines(string) {
    return string.replace(NEWLINE_STANDIN_REGEX, "\n");
}

function encodeSingleQuote(string) {
    return string.replace(/'/g, SINGLE_QUOTE_STANDIN);
}

function decodeSingleQuote(string) {
    return string.replace(SINGLE_QUOTE_STANDIN_REGEX, "'");
}

function saveViewMarkerAnnotation(ev) {
    var editPane = ev.target.parentElement;
    var viewMarkerFrame = editPane.parentElement;
    var textArea = editPane.getElementsByTagName("textarea")[0];
    
    var viewMarkerId = getViewMarkerId(viewMarkerFrame);
    var newAnnotation = textArea.value;
    
    // MATLAB errors if there is a newline in the string we send it.
    // Replace \n with the NEWLINE_STANDIN.
    var newlineEncodedNewAnnotation = encodeSingleQuote(encodeNewlines(newAnnotation));
    var glass = getByClass("glass", viewMarkerFrame);
    if (updateViewMarker(viewMarkerId, newlineEncodedNewAnnotation, "annotation")) {
        glass.title = newAnnotation;
    } else {
        glass.title = "UPDATE ERROR";
    }
    
    // TODO: alert if fails
}

function stopEvent(ev) {
    ev.preventDefault();
    return false;
}

function textAreaOnPasteCallback(ev) {
    var textArea = ev.target;
    var copiedData = ev.clipboardData.getData("text/plain");
		
    if (copiedData.length > textArea.maxLength) {
        var warningDescLenPane = getByClass("warningDescLen");
        warningDescLenPane.style.display = "block";
    }
}

function adjustFrameRatioForScreen() {
    var frames = document.getElementsByClassName("viewmarkerframe");
    for (var i = 0; i < frames.length; ++i) {
        frames[i].style.width = RATIO_SET[ratioIndex];
    }
}

function handleLayout() {
    adjustFrameRatioForScreen();
    sizeDivsToAspectRatio("viewmarkerframe_inner");
    jump(DEFAULT_ANCHOR_ID);
}

function fadeViewMarkerGlow(div) {
    // Should match viewmarker.css .viewmarkerframe_new !!
    var HIGHLIGHT_OPACITY = 1;
    var HIGHLIGHT_PARAMS = "0 0 10px 4px";
    var HIGHLIGHT_RED    = 85;
    var HIGHLIGHT_GREEN  = 161;
    var HIGHLIGHT_BLUE   = 255;
    var OPACITY_STEP     = -0.1;

    var opacity = HIGHLIGHT_OPACITY;
    var fadeHandle = window.setInterval(function() {
        if (opacity < 0.1) {
            window.clearInterval(fadeHandle);
            removeClass(div, "viewmarkerframe_new");
            div.style.boxShadow = "";
            return;
        }
        opacity += OPACITY_STEP;
        var boxShadow = HIGHLIGHT_PARAMS + " rgba(" + HIGHLIGHT_RED + ", " + HIGHLIGHT_GREEN + ", " + HIGHLIGHT_BLUE + ", " + opacity + ")";
        div.style.boxShadow = boxShadow;
    }, 80);
}

function slideIn(div, stepRight, stepLeft, overShootBy, onComplete) {
    div.style.left = parseInt(window.getComputedStyle(div).left) + "px";

    var step = stepRight;
    var slideHandle = window.setInterval(function() {
        var left = parseInt(div.style.left);
        if (left > overShootBy) {
          step = stepLeft;
        }
        if (left <= 0 && step < 0) {
            window.clearInterval(slideHandle);
            onComplete(div);
            return;
        }
  
        left += step;
        div.style.left = left + "px";
    }, 30);
}

function slideOut(div, step, onComplete) {
    var viewportWidth = document.body.clientWidth;
    div.style.position = "relative";
    div.style.left = "0px";

    var slideHandle = window.setInterval(function() {
    var left = parseInt(div.style.left);
        if (left > viewportWidth) {
            window.clearInterval(slideHandle);
            onComplete(div);
            return;
        }

        left += step;
        div.style.left = left + "px";
    }, 30);
}

function showNewViewMarker() {
    var newViewMarker = getByClass("viewmarkerframe_new");
    if (!newViewMarker) {
        return;
    }
    newViewMarker.style.position = "relative"
    
    // Animation parameters.    
    var STEP_RIGHT   = 40;  // pixels
    var STEP_LEFT    = -20; // pixels
    var OVERSHOOT_BY = 50;  // pixels
    slideIn(newViewMarker, STEP_RIGHT, STEP_LEFT, OVERSHOOT_BY, fadeViewMarkerGlow);
}

function loadSvgAfterCollapsing(modelName) {
    var groupIdx = -1;
    for (i=0; i<groupStates.length; i++) {
        var groupState = groupStates[i];
        if (groupState.id == modelName.id) {
            groupIdx = i;
            groupState.expanded = !groupState.expanded;
            break;
        }
    }

    if (groupIdx<0) {
        return;
    }

    var sumNonHiddenAfter =0;
    var sumAfter = 0;

    for (var i=groupIdx+1; i<groups.length; i++) {
        var nextElement = groups[i].nextElementSibling;
        var viewmarks = nextElement.getElementsByClassName('viewmarkerframe');
        sumAfter += viewmarks.length;
        
        if (!hasClass(nextElement, 'hidden')) {
            sumNonHiddenAfter += viewmarks.length;
        }
    }

    if (sumNonHiddenAfter < viewmarksPerViewport) {
        // the collapsed group will sink
        var beginIdxInViewport = viewmarksPerViewport - sumNonHiddenAfter
        var before = beginIdxInViewport + numberPerRow;
        var after = sumNonHiddenAfter;            

        var sumBefore = 0;
        var toBreak = false;
        for (var j=groupIdx; j>=0; j--) {
          var groupState = groupStates[j];
          if (groupState.expanded) {
            for (var k=groupState.endIndx; k>groupState.beginIndx; k--) {
                loadSvgSingle(k);
                sumBefore += 1;
                if (sumBefore == before) {
                    toBreak = true;
                    break;
                }
            }
            
            if (toBreak) {
                toBreak = false;
                break;
            }
          }
        }

        var sumAfter = 0;
        for (var j=groupIdx; j<groupStates.length; j++) {
          var groupState = groupStates[j];
          if (groupState.expanded) {
            for(var k=groupState.beginIndx; k<=groupState.endIndx; k++) {
                loadSvgSingle(k);
                sumAfter += 1;
                if (sumAfter == after) {
                    toBreak = true;
                    break;
                }
            }

            if (toBreak) {
                toBreak = false;
                break;
            }
          }
        }

    } else {
        // will not sink
        var sumAfter = 0;
        var toBreak = false;
        for (var j=groupIdx+1; j<groupStates.length; j++) {
          var groupState = groupStates[j];
          if (groupState.expanded) {
            for (var k=groupState.beginIndx; k<groupState.endIndx; k++) {
                loadSvgSingle(k);
                sumAfter += 1;
                if (sumAfter == viewmarksPerViewport) {
                    toBreak = true;
                    break;
                }
            }

            if (toBreak) {
                toBreak = false;
                break;
            }
          }
        }
    }
}

function toggleViewMarkerOuterFrame(ev) {
    var modelName = ev.target;
    if (!modelName.id) {
        modelName = modelName.parentElement;
    }

    var modelViewMarkersOuterFrame = modelName.nextElementSibling;
    var frames = modelViewMarkersOuterFrame.getElementsByClassName('viewmarkerframe');

    if (hasClass(modelName, "closed")) {       // opening
        removeClass(modelName, "closed");
        removeClass(modelViewMarkersOuterFrame, "hidden");
        addClass(modelName, "open");

        collapsedViewmarks = collapsedViewmarks - frames.length;
        jump(modelName.id);
        updateGroupStates(modelName.id, true);
    } else {                                   // collapsing
        removeClass(modelName, "open");
        addClass(modelViewMarkersOuterFrame, "hidden");
        addClass(modelName, "closed");

        collapsedViewmarks = collapsedViewmarks + frames.length;

        loadSvgAfterCollapsing(modelName);
        updateGroupStates(modelName.id, false);
    }

    pageHeight = document.documentElement.offsetHeight;
}

function handleWindowResize() {
    handleLayout();
    viewportHeight = document.body.clientHeight;
    pageHeight = document.documentElement.offsetHeight;
    document.body.style.backgroundImage = "url(file:///" + backgroundFileName + ") ";
    rowPerViewPort = Math.floor(viewportHeight/ ((pageWidth-20)/numberPerRow * SVG_ASPECT_RATIO));
    viewmarksPerViewport  = rowPerViewPort * numberPerRow;
}

function setGroupStates() {
    groups = document.getElementsByClassName('viewmarkerframe_mdlname');
    var beginIndexForGroup = 0;
    var endIndexForGroup = 0;
    var subtotal = 0;
    groupStates = []; 
    
    for (var i=0; i<groups.length; i++) {
        var group = groups[i];
        var viewmarkGrp = group.nextElementSibling;
        var frames = viewmarkGrp.getElementsByClassName('viewmarkerframe');
        
        groupStates.push({
            id: group.getAttribute('id'),
            expanded: true,
            beginIndx: beginIndexForGroup + subtotal,
            endIndx: endIndexForGroup + subtotal - 1 + frames.length
        });
  
        subtotal += frames.length;
    }
}

function updateGroupStates(id, newState) {
    for (var i=0; i<groupStates.length; i++) {
        var groupState = groupStates[i];
        if (groupState.id == id) { 
           groupState.expanded = newState;
        }
    }
}

window.onload = function() {
    handleLayout();
    
    // Show the page.
    var pageHider = document.getElementById("hidePage");
    pageHider.id = "";

    var labels = document.getElementsByClassName("nameLabel");
    for (var i = 0; i < labels.length; ++i) {
        var label = labels[i];
        label.addEventListener("click", activate);
        label.addEventListener("blur", deactivate);
        label.addEventListener("change", update);
        label.title = label.value;  // add name as tool tip
        label.addEventListener("dragstart", stopEvent);
    }
    
    var editButtons = document.getElementsByClassName("editButton");
    for (var i = 0; i < editButtons.length; ++i) {
        var editButton = editButtons[i];
        editButton.addEventListener("click", showEditor);
    }
    
    var deleteButtons = document.getElementsByClassName("deleteButton");
    for (var i = 0; i < deleteButtons.length; ++i) {
        var deleteButton = deleteButtons[i];
        deleteButton.addEventListener("click", deleteViewMark);
    }

    var closeButtons = document.getElementsByClassName("closeButton");
    for (var i = 0; i < closeButtons.length; ++i) {
        var closeButton = closeButtons[i];
        closeButton.addEventListener("click", hideEditor);
    }
    
    var OKButtonDeleteGroup = getByClass("OKButtonDeleteGroup");
    OKButtonDeleteGroup.addEventListener("click", deleteGroupViewMark);

    var stopDeleteButtonDeleteGroup = getByClass("stopDeleteButtonDeleteGroup");
    stopDeleteButtonDeleteGroup.addEventListener("click", stopDeleteGroupViewMark);

    var OKButtonForUnavailable = getByClass("OKButtonForUnavailable");
    OKButtonForUnavailable.addEventListener("click", OKButtonForUnavailableCallback);    

    var CancelButtonForUnavailable = getByClass("CancelButtonForUnavailable");
    CancelButtonForUnavailable.addEventListener("click", CancelButtonForUnavailableCallback);    

    var OKButtonForWarningDescLen = getByClass("OKButtonForWarningDescLen");
    OKButtonForWarningDescLen.addEventListener("click", OKButtonForWarningDescLenCallback);    

    var imgframes = document.getElementsByClassName("imgframe");
    for (var i = 0; i < imgframes.length; ++i) {
        imgframes[i].addEventListener("click", imageClicked);
    }

    var anchors = document.getElementsByTagName("a");
    for (var i = 0; i < anchors.length; ++i) {
        anchors[i].addEventListener("dragstart", stopEvent);
    }

    var textAreas = document.getElementsByTagName("textarea");
    for (var i = 0; i < textAreas.length; ++i) {
        textAreas[i].addEventListener("dragstart", stopEvent);
        textAreas[i].addEventListener("paste", textAreaOnPasteCallback);
        textAreas[i].addEventListener("keyup", saveViewMarkerAnnotation);
    }
    
    var glasses = getAllByClass("glass");
    for (var i = 0; i < glasses.length; ++i) {
        glasses[i].title = decodeSingleQuote(decodeNewlines(glasses[i].title));
    }
    
    var modelNames = getAllByClass("modelGroupIcon");
    for (var i = 0; i < modelNames.length; ++i) {
        var modelName = modelNames[i];
        modelName.addEventListener("click", toggleViewMarkerOuterFrame);
    }

    var modelNameTexts = getAllByClass("viewmarkerframe_mdlname_text");
    for (var i = 0; i < modelNameTexts.length; ++i) {
        var modelNameText = modelNameTexts[i];
        modelNameText.addEventListener("dblclick", toggleViewMarkerOuterFrame);
    }

    var deletegroups = getAllByClass("deletegroup");
    for (var i = 0; i < deletegroups.length; ++i) {
        var deletegroup = deletegroups[i];
        deletegroup.addEventListener("click", showDeleteGroupConfirmation);
    }

    // initializations
    canvases = getAllByClass("canvas_image");
    for(var i=0; i<canvases.length; i++) {
        var canvas = canvases[i];
        canvas.imagePath = svgPath[i];
        canvas.imageLoaded = false;
    }

    if (pageWidth > 1800)
        numberPerRow = 6;
    else if (pageWidth > 1500)
        numberPerRow = 5;
    else if (pageWidth > 1200)
        numberPerRow = 4;
    else if (pageWidth > 900)
        numberPerRow = 3;
    else if (pageWidth > 500)
        numberPerRow = 2;
    else
        numberPerRow = 2;
    
    ratioIndex = numberPerRow;

    setGroupStates();
    
    window.onresize = handleWindowResize;    

    getByClass("outermost").addEventListener("mouseup", mouseUp);

    var viewmarkerframe_outers = getAllByClass("viewmarkerframe_outer");
    for (var i=0; i<viewmarkerframe_outers.length; i++) {
    	var viewmarkerframe_outer = viewmarkerframe_outers[i];
    	viewmarkerframe_outer.addEventListener("mouseup", mouseUp);
    }
}
