<!-- C Coder project version history:

                Declared plugin version         Declared project version
     ==========================================================================================
     11a        none (default is 1.0)           none (default is 1.0)
     11b        none (default is 1.0)           none (default is 1.0)
     12a        R2012a                          1.0 (+ extra data ignored by 11a/b)
     12b        R2012a                          1.0 (+ extra data ignored by 11a/b)
     13a prerel R2012a                          R2012a
     13a        R2013a                          R2013a
     14a        R2014a_nu                       R2014a_nu

     This file converts "R2013a"-stamped C projects and all HDL Coder projects to "R2014a_nu"-stamped
     unified projects. The suffix at the end of the R2014a exists to maintain compatibility with
     internal R2014a projects of the unified project spec. R2014a with no suffix refers to R2014b.

     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
     !!! CHANGES TO XSL FILES LIKE THIS ONE ARE ONLY PICKED UP IF YOU BUILD THE ACTUAL JAR FILE !!!
     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

     gmake COMPONENTS_TO_BUILD="coder_java" prebuild

-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output indent="yes" />

    <!--g982690 - Performs the necessary transformations on old CRL values and initalizes the new
    TargetLangStandard param when appropriate. -->
    <xsl:template match="//param.CodeReplacementLibrary">
        <xsl:choose>
            <xsl:when test="not(../param.TargetLangStandard)">
                <xsl:choose>
                    <xsl:when test="text() = 'Intel IPP (ANSI)'">
                        <param.CodeReplacementLibrary>Intel IPP</param.CodeReplacementLibrary>
                    </xsl:when>
                    <xsl:when test="text() = 'Intel IPP (ISO)'">
                        <param.TargetLangStandard>C99 (ISO)</param.TargetLangStandard>
                        <param.CodeReplacementLibrary>Intel IPP</param.CodeReplacementLibrary>
                    </xsl:when>
                    <xsl:when test="text() = 'C89/C90 (ANSI)' or text() = 'ANSI_C'">
                        <param.TargetLangStandard>C89/C90 (ANSI)</param.TargetLangStandard>
                        <param.CodeReplacementLibrary>None</param.CodeReplacementLibrary>
                    </xsl:when>
                    <xsl:when test="text() = 'C99 (ISO)' or text() = 'ISO_C'">
                        <param.TargetLangStandard>C99 (ISO)</param.TargetLangStandard>
                        <param.CodeReplacementLibrary>None</param.CodeReplacementLibrary>
                    </xsl:when>
                    <xsl:when test="text() = 'C++ (ISO)' or text() = 'ISO_C++'">
                        <param.TargetLangStandard>C++03 (ISO)</param.TargetLangStandard>
                        <param.CodeReplacementLibrary>None</param.CodeReplacementLibrary>
                    </xsl:when>
                    <xsl:when test="text() = 'GNU99 (GNU)' or text() = 'GNU' or text() = 'ADI TigerSHARC'
                            or text() = 'MULTI BF53x' or text() = 'Intel IPP/SSE (GNU)' or text() = 'Intel IPP (GNU)'">
                        <param.TargetLangStandard>C99 (ISO)</param.TargetLangStandard>
                        <param.CodeReplacementLibrary>
                            <xsl:value-of select="text()"/>
                        </param.CodeReplacementLibrary>
                    </xsl:when>
                    <xsl:otherwise>
                        <param.CodeReplacementLibrary>
                            <xsl:value-of select="text()" />
                        </param.CodeReplacementLibrary>
                        <param.DeprecatedCRLFlag>true</param.DeprecatedCRLFlag>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <param.CodeReplacementLibrary>
                    <xsl:value-of select="text()" />
                </param.CodeReplacementLibrary>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!--This dummy flag param should only exist the first time a legacy project is opened in the new MATLAB -->
    <xsl:template match="//param.DeprecatedCRLFlag" />

    <!--g998857 - This converts all structs with negative alignments to zero unless they have an explicit type
    name and are externally defined. -->
    <xsl:template match="//Input/Alignment[../Class/text() ='struct' and  ../TypeName[not(TypeName)] = '' and ../Extern/text() = 'false']">
        <Alignment>0</Alignment>
    </xsl:template>

    <!--g1016056 - Convert all 'Auto' values in legacy projects to 'Signed' -->
    <xsl:template match="//Input/numerictype/Signedness[string-length(text()) = 6 and substring(text(), 2, 4) = 'Auto' and ../../Class[text() ='embedded.fi']]">
        <Signedness>'Signed'</Signedness>
    </xsl:template>

    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>