% Programming language constructs.
%
% Control flow.
%   if            - Conditionally execute statements.
%   else          - Execute statement if previous IF condition failed.
%   elseif        - Execute if previous IF failed and condition is true.
%   end           - Terminate scope of control statements.
%   for           - Repeat statements a specific number of times.
%   parfor        - Parallel FOR-loop.
%   while         - Repeat statements an indefinite number of times.
%   break         - Terminate execution of WHILE or FOR loop.
%   continue      - Pass control to the next iteration of a loop.
%   switch        - Switch among several cases based on expression.
%   case          - SWITCH statement case.
%   otherwise     - Default SWITCH statement case.
%   try           - Begin TRY block.
%   catch         - Begin CATCH block.
%   return        - Return to invoking function.
%   error         - Display message and abort function.
%   MException    - Constructs MATLAB exception object.
%   assert        - Generate an error when a condition is violated.
%   rethrow       - Reissue error.
%
% Evaluation and execution.
%   eval          - Execute string with MATLAB expression.
%   evalc         - Evaluate MATLAB expression with capture.
%   feval         - Execute the specified function.
%   evalin        - Evaluate expression in workspace.
%   builtin       - Execute built-in function from overloaded method.
%   assignin      - Assign variable in workspace.
%   run           - Run script.
%
% Scripts, functions, classes, and variables.
%   script        - About MATLAB scripts and M-files.
%   function      - Add new function.
%   global        - Define global variable.
%   persistent    - Define persistent variable.
%   mfilename     - Name of currently executing M-file.
%   lists         - Comma separated lists.
%   exist         - Check if variables or functions are defined.
%   mlock         - Prevent M-file from being cleared.
%   munlock       - Allow M-file to be cleared.
%   mislocked     - True if M-file cannot be cleared.
%   precedence    - Operator Precedence in MATLAB.
%   isvarname     - True for valid variable name.
%   iskeyword     - Check if input is a keyword.
%   javachk       - Validate level of Java support.
%   genvarname    - Construct a valid MATLAB variable name from a string.
%   classdef      - Define a new class or subclass.
%
% Argument handling.
%   nargchk       - Validate number of input arguments. 
%   nargoutchk    - Validate number of output arguments. 
%   nargin        - Number of function input arguments.
%   nargout       - Number of function output arguments.
%   varargin      - Variable length input argument list.
%   varargout     - Variable length output argument list.
%   inputname     - Input argument name.
%   inputParser   - Construct input parser object.
%   ans           - Most recent answer.
%
% Message display.
%   warning       - Display warning message.
%   lastwarn      - Last warning message.
%   disp          - Display array.
%   display       - Display array.
%   details       - Display array.
%
% Interactive input.
%   input         - Prompt for user input. 
%   keyboard      - Invoke keyboard from M-file.
%
% Abstract superclasses.
%   handle        - Superclass of all handle classes.
%   hgsetget      - HG-style set and get for MATLAB objects.
%   dynamicprops  - Support for dynamic properties.
%
% See also GENERAL, IOFUN, OPS, DATATYPES, MATFUN, FUNFUN, ELFUN, POLYFUN.

% Other.
%   checkSyntacticWarnings - Check M-files for syntactic warnings.

%   Copyright 1984-2012 The MathWorks, Inc.



