/* Copyright 2013 The MathWorks, Inc. */
#include <coder/target_services/TargetMessages.hpp>

// Use exported header for internal builds
#ifdef BUILDING_LIBMWCODER_TARGET_SERVICES
#include <coder/target_services/MemoryService.hpp>

// Use local header for target builds
#else
#include "MemoryService.hpp"
#endif

namespace coder { namespace tgtsvc {

void *Message::operator new(size_t size)
{
    MemoryService &ms = MemoryService::instance();
    void *ret = ms.alloc(size);
    return ret;
}

void Message::operator delete(void *ptr) throw ()
{
    MemoryService &ms = MemoryService::instance();
    ms.free(ptr);
}

void *Message::operator new(size_t size, const std::nothrow_t &nothrow_value) throw()
{
    MemoryService &ms = MemoryService::instance();
    return ms.alloc(size);
}

void Message::operator delete (void* ptr, const std::nothrow_t& nothrow_constant) throw()
{
    MemoryService &ms = MemoryService::instance();
    ms.free(ptr);
}

Message *Message::alloc(uint16_t payloadSize)
{
    MemoryService &ms = MemoryService::instance();
    void *p = ms.alloc(payloadSize + sizeof(Message));
    return new (p) Message;
}

uint16_t Message::payloadCapacity() const
{
    MemoryService &ms = MemoryService::instance();
    return ms.capacity(this) - sizeof(Message);
}

uint16_t Message::maxPayloadCapacity()
{
    MemoryService &ms = MemoryService::instance();
    return ms.maxCapacity() - sizeof(Message);
}

}}
