/* Copyright 2013-2014 The MathWorks, Inc. */
define("matlabeditor/MatlabEditorMain", [
    "dojo/_base/declare",
    "dojo/dom",
    "dojo/dom-style",
    "dojo/query",
    "dijit/layout/BorderContainer",
    "dijit/layout/ContentPane",
    "MW/rtc/RichTextComponent",
    "MW/rtc/RichTextComponentFactory",
    "MW/rtc/RichTextComponentFeatureEnum"    
], function(
    declare,
    dom,
    domStyle,
    query,
    BorderContainer,
    ContentPane,
    RichTextComponent,
    RichTextComponentFactory,
    RichTextComponentFeatureEnum    
    ) {
    return declare([], {
        constructor: function () {
            
            var editorPlaceholder = dom.byId("editorPlaceHolder");
            var features = [];
            features.push(RichTextComponentFeatureEnum.PAREN_MATCH);
            features.push(RichTextComponentFeatureEnum.SYNTAX_HIGHLIGHTING);
            features.push(RichTextComponentFeatureEnum.TAB_COMPLETION);
            features.push(RichTextComponentFeatureEnum.CODE_ANALYZER);
            features.push(RichTextComponentFeatureEnum.GUTTER_LINE_NUMBER);
            features.push(RichTextComponentFeatureEnum.INDENT_ON_NEWLINE);
            features.push(RichTextComponentFeatureEnum.PAREN_MATCH);
            features.push(RichTextComponentFeatureEnum.SECTIONS);
            
            var rtc = RichTextComponentFactory.create(features, editorPlaceHolder);
            rtc.startup();
            rtcDocument = rtc.getDocument();
            
            /*--------------------------------------------------------------------
                    Initialize editor with initial text and read/write  
                    status from Qt. These methods are required as signals 
                    from Qt are fired before javaScript loads.
            ----------------------------------------------------------------------*/

            var textFromMatlab = qtwebkitbridge.jsGetEditorTextFromQt();
            updateDocumentText(textFromMatlab);
            var enabled = qtwebkitbridge.jsGetEditorEnabledFromQt();
            updateEnabledStatus(enabled);

            /*--------------------------------------------------------------------
                    Bind Qt notification with JS for updates
            ----------------------------------------------------------------------*/

            try {
                qtwebkitbridge.signalJSToSetEditorText.connect(updateDocumentText);
                qtwebkitbridge.signalJSToSetBackgroundColor.connect(updateBackgroundColor);
                qtwebkitbridge.signalJSToSetEditorFocus.connect(updateDocumentFocus);
                qtwebkitbridge.signalJSToSetEditorEnabled.connect(updateEnabledStatus);
                qtwebkitbridge.signalJSToResizeEditor.connect(resizeDocument);
            }
            catch(e) {
                    //log errors
            }

            /*--------------------------------------------------------------------
                    Notify Qt whenever the document text changes
            ----------------------------------------------------------------------*/
            
            rtcDocument.onChange = function() {
                // we get doc change notification on enabled/disabled
                qtwebkitbridge.jsSetEditorTextInQt(rtcDocument.getText());
            }

            /*--------------------------------------------------------------------
                    Callbacks that react to Qt notifications
            ----------------------------------------------------------------------*/

            function updateDocumentText(text) {
                setTimeout(function() {
                var oldText = rtcDocument.getText();
                if(oldText != text){
                    //var readonlyStatus = rtcDocument.isReadOnly();
                    //rtcDocument.setReadOnly(false);
                    rtcDocument.setText(text);
                    //rtcDocument.setReadOnly(readonlyStatus);
                }
                }, 0);
            }
            
            function updateBackgroundColor(red, green, blue) {
                var color = "#"+ red.toString(16)+green.toString(16)+blue.toString(16);
                //change this when rtc folks give us API for changing background colour
                query(".scrollPane").style("backgroundColor", color);
            }

            function updateDocumentFocus(focus) {
                // Show cursor only when document has focus and is enabled.
                var enabled = qtwebkitbridge.jsGetEditorEnabledFromQt();
                if(focus && enabled) {
                    rtc.focus();
                }
                else {
                    rtc.blur();
                }
            }

            function updateEnabledStatus(enabled) {
                setTimeout(function() {
                var oldStatus = rtcDocument.isReadOnly();                
                // notion of enabled is opposite to that of readonly
                if(oldStatus == enabled) {
                
                    if(enabled) {
                        rtcDocument.setReadOnly(false);
                    }
                    else {
                        rtcDocument.setReadOnly(true);
                        rtc.blur();
                    }
                }}, 0);
            }

            function resizeDocument() {
                rtc.resize();
            }

            /*-----------------------------------------------------------------------------
                Cleanup is not currently being used. Will be called on dojo addOnUnload
            ------------------------------------------------------------------------------*/
            function cleanup() {
                rtc.destroy();
            }
        }

    });
});

